/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Bang;
import controlP5.Button;
import controlP5.CallbackEvent;
import controlP5.CallbackListener;
import controlP5.ColorWheel;
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.Knob;
import controlP5.RadioButton;
import controlP5.ScrollableList;
import controlP5.Slider;
import controlP5.Tab;
import controlP5.Textarea;
import controlP5.Textfield;
import controlP5.Textlabel;
import controlP5.Toggle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.data.FloatList;
import processing.data.IntDict;
import processing.data.IntList;
import processing.data.StringDict;
import processing.data.StringList;
import processing.data.XML;
import processing.event.MouseEvent;

public class Display_Builder_4
extends PApplet {
    Locale app_locale;
    PApplet app = this;
    Project project = new Project();
    UI ui = new UI();
    UiElements ui_elements = new UiElements();
    Exports export_manager = new Exports();
    String app_title = "Display Builder";
    String app_version = "4.3.12";
    String xml_version = "3.3";
    int copyright_year_end = 2025;
    String web_url = "https://matkeane.com";
    String web_api_path = "app";
    String web_button_url = String.valueOf(this.web_url) + "/" + this.web_api_path + "/" + this.sanitize_network_string(this.app_title) + "/?version=" + this.app_version;
    Boolean debug_mode = false;
    int font_display_id_size;
    PFont font_display_id;
    PFont font_display_ui;

    public void settings() {
        this.pixelDensity(1);
        this.size(1280, 720, "processing.awt.PGraphicsJava2D");
        this.smooth();
    }

    public void setup() {
        if (this.surface != null) {
            this.surface.setTitle(String.valueOf(this.app_title) + " " + this.app_version);
            this.surface.setResizable(this.project.pref_ui_scaling.booleanValue());
        }
        Display_Builder_4.println((String)("Welcome to " + this.app_title + " " + this.app_version));
        Display_Builder_4.println((String)("System: " + System.getProperty("os.name") + " version: " + System.getProperty("os.version") + " arch: " + System.getProperty("os.arch")));
        Locale.setDefault(Locale.US);
        this.app_locale = Locale.getDefault();
        Display_Builder_4.println((String)("Using Locale: " + this.app_locale.getDisplayName() + " " + this.app_locale.toLanguageTag()));
        Display_Builder_4.println((String)("Monitor resolution: " + this.displayWidth + "x" + this.displayHeight + ", displayDensity: " + this.displayDensity() + ", pixelDensity: " + this.pixelDensity));
        this.font_display_id_size = 224;
        this.font_display_id = this.createFont("Verdana", this.font_display_id_size, true);
        this.font_display_ui = this.createFont("Verdana", 12.0f, true);
        this.frameRate(60.0f);
        this.check_memory();
        this.setup_resolutions_list();
        this.export_manager.init();
        this.project.load_defaults();
        this.ui_elements.init();
        this.setup_ui_elements();
        this.project.displaygroup_current_update();
        this.ui.window_size_check();
        this.ui.pan_surface_to_viewport_centre();
        this.redraw_screen();
    }

    public void draw() {
        if (this.project.pref_ui_scaling.booleanValue()) {
            this.ui.window_size_check();
        }
        if (this.project.process_project_file.booleanValue()) {
            this.debug_output("Project load file triggered in draw loop.");
            this.load_project_file();
        } else {
            this.redraw_screen();
        }
    }

    public void redraw_screen() {
        if (this.ui.active.booleanValue() && this.ui.ready.booleanValue()) {
            this.background(this.ui.colour_get_by_name("viewport_bg"));
            this.project.guides_draw("image");
            this.draw_grid();
            this.draw_target_surface();
            this.project.displays_draw_all();
            this.project.guides_draw("line");
            this.draw_ui_pane();
            this.draw_mouse_position();
            this.draw_scrollbars();
            this.draw_position_data_overlay();
            this.osd_message_overlay_draw();
            this.draw_throbber();
        }
    }

    public void keyPressed() {
        this.ui.keyboard_event(this.keyCode, true);
        if (this.key == '\u001b') {
            this.key = '\u0000';
        }
    }

    public void keyReleased() {
        if (this.key == '\u001a') {
            this.debug_output("Keyboard UNDO.");
        }
        if (this.keyCode == 9) {
            this.ui.tab_select_next();
        }
        this.ui.keyboard_event(this.keyCode, false);
    }

    public void mouseWheel(MouseEvent event) {
        float scroll_amount = event.getCount();
        this.ui.mouse_wheel(Float.valueOf(scroll_amount));
    }

    public void mouseMoved() {
        this.ui.mouse_moved();
    }

    public void mousePressed() {
        this.ui.mouse_pressed();
    }

    public void mouseDragged() {
        this.ui.mouse_dragged();
    }

    public void mouseReleased() {
        this.ui.mouse_released();
    }

    public StringList export_data_csv(DisplayGroup group) {
        StringList csv_output = new StringList();
        Boolean[] group_tier_list_positions = this.project.stage_tiers.get(group.stagetier_id).displaygroup_check(group.id);
        if (group_tier_list_positions[0].booleanValue()) {
            csv_output.append(this.generate_prefix_csv());
        }
        csv_output.append(this.generate_display_data_csv(group));
        return csv_output;
    }

    public ExportFormat export_format_config_csv(ExportFormat export_format) {
        export_format.id = 0;
        export_format.comment_prefix = "# ";
        export_format.comment_type = 1;
        export_format.export_clipboard = true;
        export_format.export_file = true;
        export_format.export_stagetiers_separate_files = true;
        export_format.file_extension = ".csv";
        export_format.format_name = "";
        export_format.name = "CSV: Data table";
        return export_format;
    }

    public StringList generate_prefix_csv() {
        StringList output = new StringList();
        StringList csv_headers = new StringList();
        csv_headers.append("Display Number");
        csv_headers.append("Display Group");
        csv_headers.append("Name");
        csv_headers.append("Row");
        csv_headers.append("Column");
        csv_headers.append("Player ID");
        csv_headers.append("Output ID");
        csv_headers.append("Display Width");
        csv_headers.append("Display Height");
        csv_headers.append("Stage Width");
        csv_headers.append("Stage Height");
        csv_headers.append("Rotation");
        csv_headers.append("Left X");
        csv_headers.append("Top Y");
        csv_headers.append("Centre X");
        csv_headers.append("Centre Y");
        csv_headers.append("Right X");
        csv_headers.append("Bottom Y");
        csv_headers.append("Crop Left");
        csv_headers.append("Crop Right");
        csv_headers.append("Crop Top");
        csv_headers.append("Crop Bottom");
        String headers_output = Display_Builder_4.join((String[])csv_headers.array(), (String)", ");
        output.append(headers_output);
        return output;
    }

    public StringList generate_display_data_csv(DisplayGroup group) {
        StringList display_data = new StringList();
        StringList csv_column = new StringList();
        for (DisplayObject display : group.displays) {
            csv_column.clear();
            csv_column.append(String.valueOf(display.display_id + 1));
            csv_column.append(String.valueOf(display.parent_displaygroup_id + 1));
            csv_column.append("\"" + display.name + "\"");
            csv_column.append(String.valueOf(display.row_id + 1));
            csv_column.append(String.valueOf(display.col_id + 1));
            csv_column.append("\"" + group.player_name_prefix + display.player_number + "\"");
            csv_column.append(String.valueOf(display.output_number));
            csv_column.append(String.valueOf(Display_Builder_4.floor((float)group.display_resolution.x)));
            csv_column.append(String.valueOf(Display_Builder_4.floor((float)group.display_resolution.y)));
            csv_column.append(String.valueOf(Display_Builder_4.floor((float)group.display_dimensions_stage.x)));
            csv_column.append(String.valueOf(Display_Builder_4.floor((float)group.display_dimensions_stage.y)));
            csv_column.append(String.valueOf(Display_Builder_4.degrees((float)display.rotation)));
            csv_column.append(String.valueOf(display.stage_bounds[3]));
            csv_column.append(String.valueOf(display.stage_bounds[0]));
            csv_column.append(String.valueOf(Display_Builder_4.floor((float)display.position.x)));
            csv_column.append(String.valueOf(Display_Builder_4.floor((float)display.position.y)));
            csv_column.append(String.valueOf(display.stage_bounds[1]));
            csv_column.append(String.valueOf(display.stage_bounds[2]));
            csv_column.append(String.valueOf(display.stage_bounds[3] - group.projection_surface_bounds[3]));
            csv_column.append(String.valueOf(group.projection_surface_bounds[1] - display.stage_bounds[1]));
            csv_column.append(String.valueOf(display.stage_bounds[0] - group.projection_surface_bounds[0]));
            csv_column.append(String.valueOf(group.projection_surface_bounds[2] - display.stage_bounds[2]));
            display_data.append(Display_Builder_4.join((String[])csv_column.array(), (String)", "));
        }
        return display_data;
    }

    public StringList export_data_wo4(DisplayGroup group) {
        StringList wo4_output = new StringList();
        Boolean[] group_tier_list_positions = this.project.stage_tiers.get(group.stagetier_id).displaygroup_check(group.id);
        if (group_tier_list_positions[0].booleanValue()) {
            wo4_output.append(this.generate_prefix_wo4());
        }
        wo4_output.append(this.generate_display_data_wo4(group, group_tier_list_positions[0]));
        if (group_tier_list_positions[2].booleanValue()) {
            wo4_output.append(this.generate_suffix_wo4());
        }
        return wo4_output;
    }

    public ExportFormat export_format_config_wo4(ExportFormat export_format) {
        export_format.id = 1;
        export_format.comment_prefix = "// ";
        export_format.comment_type = 1;
        export_format.export_clipboard = true;
        export_format.export_file = true;
        export_format.export_stagetiers_separate_files = true;
        export_format.file_extension = ".txt";
        export_format.format_name = "wo4";
        export_format.name = "DATA: WO v4";
        return export_format;
    }

    public StringList generate_prefix_wo4() {
        StringList output = new StringList();
        output.append("UTF8 DATATON_DFC_DATA_590925_620721_AUC069 {");
        output.append("  \"Structure and File Format (C) Copyright Dataton AB\" 2011 1");
        output.append("  \"WATCHMAKER\" 4 0 0 0");
        output.append("  ObjTransferable ObjTransferable struct extends {");
        output.append("    TextTransferable struct extends {");
        output.append("      Transferable struct {");
        output.append("        }");
        output.append("      } {");
        output.append("      }");
        output.append("    } {");
        output.append("    mObjData list object true,");
        output.append("    mClassName string");
        output.append("    } {");
        output.append("    {");
        output.append("      DisplayDevice struct extends {");
        output.append("        StageItem struct {");
        output.append("          mName string,");
        output.append("          mLoc IPoint struct extends {");
        output.append("            iPDBase struct {");
        output.append("              x int,");
        output.append("              y int");
        output.append("              }");
        output.append("            } {");
        output.append("            },");
        output.append("          mAddress string,");
        output.append("          mPrimary bool");
        output.append("          }");
        output.append("        } {");
        output.append("        mColor IColor struct {");
        output.append("          r int,");
        output.append("          g int,");
        output.append("          b int,");
        output.append("          a int");
        output.append("          },");
        output.append("        mDim IDimension struct extends {");
        output.append("          iPDBase");
        output.append("          } {");
        output.append("          },");
        output.append("        mStageDim IDimension,");
        output.append("        mFixedScale bool,");
        output.append("        mAngle float,");
        output.append("        mSoftEdges list SoftedgeSpec struct {");
        output.append("          mIntersection Quad struct {");
        output.append("            MVertices array 4 Point struct extends {");
        output.append("              vtCSBase struct {");
        output.append("                x float,");
        output.append("                y float");
        output.append("                }");
        output.append("              } {");
        output.append("              }");
        output.append("            },");
        output.append("          mTweenPoints TweenPointTrack struct extends {");
        output.append("            TweenTrack struct extends {");
        output.append("              TweenParam struct {");
        output.append("                }");
        output.append("              } {");
        output.append("              mExpanded bool,");
        output.append("              mHeight int");
        output.append("              }");
        output.append("            } {");
        output.append("            mPoints list TweenPoint struct extends {");
        output.append("              TweenParam");
        output.append("              } {");
        output.append("              mTimePos float");
        output.append("              } true,");
        output.append("            mExpr reference TweenExpression struct {");
        output.append("              mExpr Expression struct {");
        output.append("                mItems list ExprItem struct {");
        output.append("                  } true");
        output.append("                }");
        output.append("              } false");
        output.append("            }");
        output.append("          } false,");
        output.append("        mDistortion WarpSpec struct {");
        output.append("          mMode WarpMode enum {");
        output.append("            kWP_Rectangular 0,");
        output.append("            kWP_Perspective 1,");
        output.append("            kWP_Horizontal 2,");
        output.append("            kWP_Vertical 3,");
        output.append("            kWP_Spherical 4");
        output.append("            },");
        output.append("          mSmoothCorners bool,");
        output.append("          mHorizontalRows list WarpRow struct {");
        output.append("            mOriginalY float,");
        output.append("            mWarpPoints list WarpingPoint struct {");
        output.append("              mOriginalX float,");
        output.append("              mAnchor BezierPoint struct extends {");
        output.append("                Point");
        output.append("                } {");
        output.append("                mControl1 Point,");
        output.append("                mControl2 Point");
        output.append("                },");
        output.append("              mVerticalControl array 2 Point,");
        output.append("              mDistribution array 4 float");
        output.append("              } false");
        output.append("            } false,");
        output.append("          mDirectMesh DirectMesh struct {");
        output.append("            mVertices list DirectMeshPoint struct {");
        output.append("              mDestScreenCoord Point,");
        output.append("              mUVCoord Point,");
        output.append("              mColor IColor");
        output.append("              } false,");
        output.append("            mTriangles list DirectMeshTriangle struct {");
        output.append("              mPointIndices array 3 int");
        output.append("              } false");
        output.append("            }");
        output.append("          },");
        output.append("        mWhitePoint FColor struct {");
        output.append("          r float,");
        output.append("          g float,");
        output.append("          b float,");
        output.append("          a float");
        output.append("          }");
        output.append("        } {");
        return output;
    }

    public StringList generate_display_data_wo4(DisplayGroup group, Boolean flag_initial_displaygroup_in_export) {
        StringList display_data = new StringList();
        for (DisplayObject display : group.displays) {
            if (!flag_initial_displaygroup_in_export.booleanValue() || display.display_id != 0) {
                display_data.append("      DisplayDevice {");
            }
            display_data.append("        \"" + display.name + "\",");
            display_data.append("        { " + Display_Builder_4.floor((float)display.position.x) + ", " + Display_Builder_4.floor((float)display.position.y) + " },");
            display_data.append("        \"" + group.player_name_prefix + display.player_number + "\",");
            display_data.append("        false,");
            display_data.append("        { " + this.get_color_rgb_values_string(display.outline_colour) + " },");
            display_data.append("        { " + Display_Builder_4.floor((float)group.display_resolution.x) + ", " + Display_Builder_4.floor((float)group.display_resolution.y) + " },");
            display_data.append("        { " + Display_Builder_4.floor((float)group.display_dimensions_stage.x) + ", " + Display_Builder_4.floor((float)group.display_dimensions_stage.y) + " },");
            if (group.stage_scale == 1.0f) {
                display_data.append("        true,");
            } else {
                display_data.append("        false,");
            }
            display_data.append("        " + this.get_angle_as_fraction(display.rotation) + ",");
            display_data.append("        {");
            display_data.append("          },");
            display_data.append("        {");
            display_data.append("          0,");
            display_data.append("          false,");
            display_data.append("          {");
            display_data.append("            },");
            display_data.append("          {");
            display_data.append("            {");
            display_data.append("              },");
            display_data.append("            {");
            display_data.append("              }");
            display_data.append("            }");
            display_data.append("          },");
            display_data.append("        { 1, 1, 1, 1 }");
            display_data.append("        },");
        }
        return display_data;
    }

    public StringList generate_suffix_wo4() {
        StringList output = new StringList();
        output.append("      },");
        output.append("    \"StageItem\"");
        output.append("    }");
        output.append("  }");
        output.append("");
        return output;
    }

    public StringList wo5_export_data(DisplayGroup group) {
        StringList wo5_output = new StringList();
        Boolean[] group_tier_list_positions = this.project.stage_tiers.get(group.stagetier_id).displaygroup_check(group.id);
        if (group_tier_list_positions[0].booleanValue()) {
            wo5_output.append(this.generate_prefix_wo5());
        }
        wo5_output.append(this.generate_display_data_wo5(group, group_tier_list_positions[0]));
        if (group_tier_list_positions[2].booleanValue()) {
            wo5_output.append(this.generate_suffix_wo5());
        }
        return wo5_output;
    }

    public ExportFormat export_format_config_wo5(ExportFormat export_format) {
        export_format.id = 2;
        export_format.comment_prefix = "// ";
        export_format.comment_type = 1;
        export_format.export_clipboard = true;
        export_format.export_file = true;
        export_format.export_stagetiers_separate_files = true;
        export_format.file_extension = ".txt";
        export_format.format_name = "wo5";
        export_format.name = "DATA: WO v5";
        return export_format;
    }

    public StringList generate_prefix_wo5() {
        StringList output = new StringList();
        output.append("UTF8 DATATON_DFC_DATA_590925_620721_AUC069 {");
        output.append("  \"Structure and File Format (C) Copyright Dataton AB\" 2012 1");
        output.append("  \"WATCHMAKER\" 5 0 0 0");
        output.append("  ObjTransferable ObjTransferable struct extends {");
        output.append("    TextTransferable struct extends {");
        output.append("      Transferable struct {");
        output.append("        }");
        output.append("      } {");
        output.append("      }");
        output.append("    } {");
        output.append("    mObjData list object true,");
        output.append("    mClassName string");
        output.append("    } {");
        output.append("    {");
        output.append("      DisplayDevice struct extends {");
        output.append("        StageItem struct {");
        output.append("          mName string,");
        output.append("          mLoc IPoint struct extends {");
        output.append("            iPDBase struct {");
        output.append("              x int,");
        output.append("              y int");
        output.append("              }");
        output.append("            } {");
        output.append("            },");
        output.append("          mAddress string,");
        output.append("          mPrimary bool");
        output.append("          }");
        output.append("        } {");
        output.append("        mColor IColor struct {");
        output.append("          r int,");
        output.append("          g int,");
        output.append("          b int,");
        output.append("          a int");
        output.append("          },");
        output.append("        mDim IDimension struct extends {");
        output.append("          iPDBase");
        output.append("          } {");
        output.append("          },");
        output.append("        mStageDim IDimension,");
        output.append("        mFixedScale bool,");
        output.append("        mAngle float,");
        output.append("        mSoftEdges list SoftedgeSpec struct {");
        output.append("          mIntersection Quad struct {");
        output.append("            MVertices array 4 Point struct extends {");
        output.append("              vtCSBase struct {");
        output.append("                x float,");
        output.append("                y float");
        output.append("                }");
        output.append("              } {");
        output.append("              }");
        output.append("            },");
        output.append("          mTweenPoints TweenPointTrack struct extends {");
        output.append("            TweenTrack struct extends {");
        output.append("              TweenParam struct {");
        output.append("                }");
        output.append("              } {");
        output.append("              mExpanded bool,");
        output.append("              mHeight int");
        output.append("              }");
        output.append("            } {");
        output.append("            mPoints list TweenPoint struct extends {");
        output.append("              TweenParam");
        output.append("              } {");
        output.append("              mTimePos float");
        output.append("              } true,");
        output.append("            mExpr reference TweenExpression struct {");
        output.append("              mExpr Expression struct {");
        output.append("                mItems list ExprItem struct {");
        output.append("                  } true");
        output.append("                },");
        output.append("              mExprY Expression,");
        output.append("              mExprZ Expression");
        output.append("              } false");
        output.append("            }");
        output.append("          } false,");
        output.append("        mOutput int,");
        output.append("        mDistortion WarpSpec struct {");
        output.append("          mMode WarpMode enum {");
        output.append("            kWP_Rectangular 0,");
        output.append("            kWP_Perspective 1,");
        output.append("            kWP_Horizontal 2,");
        output.append("            kWP_Vertical 3,");
        output.append("            kWP_Spherical 4");
        output.append("            },");
        output.append("          mSmoothCorners bool,");
        output.append("          mHorizontalRows list WarpRow struct {");
        output.append("            mOriginalY float,");
        output.append("            mWarpPoints list WarpingPoint struct {");
        output.append("              mOriginalX float,");
        output.append("              mAnchor BezierPoint struct extends {");
        output.append("                Point");
        output.append("                } {");
        output.append("                mControl1 Point,");
        output.append("                mControl2 Point");
        output.append("                },");
        output.append("              mVerticalControl array 2 Point,");
        output.append("              mDistribution array 4 float");
        output.append("              } false");
        output.append("            } false,");
        output.append("          mDirectMesh DirectMesh struct {");
        output.append("            mVertices list DirectMeshPoint struct {");
        output.append("              mDestScreenCoord Point,");
        output.append("              mUVCoord Point,");
        output.append("              mColor IColor");
        output.append("              } false,");
        output.append("            mTriangles list DirectMeshTriangle struct {");
        output.append("              mPointIndices array 3 int");
        output.append("              } false");
        output.append("            }");
        output.append("          },");
        output.append("        mWhitePoint FColor struct {");
        output.append("          r float,");
        output.append("          g float,");
        output.append("          b float,");
        output.append("          a float");
        output.append("          },");
        output.append("        mStereo Stereoscopy enum {");
        output.append("          kDS_None 0,");
        output.append("          kDS_Left 1,");
        output.append("          kDS_Right 2");
        output.append("          }");
        output.append("        } {");
        return output;
    }

    public StringList generate_display_data_wo5(DisplayGroup group, Boolean flag_initial_displaygroup_in_export) {
        StringList display_data = new StringList();
        for (DisplayObject display : group.displays) {
            if (!flag_initial_displaygroup_in_export.booleanValue() || display.display_id != 0) {
                display_data.append("      DisplayDevice {");
            }
            display_data.append("        \"" + display.name + "\",");
            display_data.append("        { " + Display_Builder_4.floor((float)display.position.x) + ", " + Display_Builder_4.floor((float)display.position.y) + " },");
            display_data.append("        \"" + group.player_name_prefix + display.player_number + "\",");
            display_data.append("        false,");
            display_data.append("        { " + this.get_color_rgb_values_string(display.outline_colour) + " },");
            display_data.append("        { " + Display_Builder_4.floor((float)group.display_resolution.x) + ", " + Display_Builder_4.floor((float)group.display_resolution.y) + " },");
            display_data.append("        { " + Display_Builder_4.floor((float)group.display_dimensions_stage.x) + ", " + Display_Builder_4.floor((float)group.display_dimensions_stage.y) + " },");
            if (group.stage_scale == 1.0f) {
                display_data.append("        true,");
            } else {
                display_data.append("        false,");
            }
            display_data.append("        " + this.get_angle_as_fraction(display.rotation) + ",");
            display_data.append("        {");
            display_data.append("          },");
            display_data.append("        " + display.output_number + ",");
            display_data.append("        {");
            display_data.append("          0,");
            display_data.append("          false,");
            display_data.append("          {");
            display_data.append("            },");
            display_data.append("          {");
            display_data.append("            {");
            display_data.append("              },");
            display_data.append("            {");
            display_data.append("              }");
            display_data.append("            }");
            display_data.append("          },");
            display_data.append("        { 1, 1, 1, 1 },");
            display_data.append("        0 // mStereo");
            display_data.append("        },");
        }
        return display_data;
    }

    public StringList generate_suffix_wo5() {
        StringList output = new StringList();
        output.append("      },");
        output.append("    \"StageItem\"");
        output.append("    }");
        output.append("  }");
        output.append("");
        return output;
    }

    public StringList export_data_wo6(DisplayGroup group) {
        StringList wo6_output = new StringList();
        Boolean[] group_tier_list_positions = this.project.stage_tiers.get(group.stagetier_id).displaygroup_check(group.id);
        if (group_tier_list_positions[0].booleanValue()) {
            wo6_output.append(this.generate_prefix_wo6());
        }
        wo6_output.append(this.generate_display_data_wo6(group, group_tier_list_positions[0]));
        if (group_tier_list_positions[2].booleanValue()) {
            wo6_output.append(this.generate_suffix_wo6());
        }
        return wo6_output;
    }

    public ExportFormat export_format_config_wo6(ExportFormat export_format) {
        export_format.id = 3;
        export_format.comment_prefix = "// ";
        export_format.comment_type = 1;
        export_format.export_clipboard = true;
        export_format.export_file = true;
        export_format.export_stagetiers_separate_files = true;
        export_format.file_extension = ".txt";
        export_format.format_name = "wo6";
        export_format.name = "DATA: WO v6";
        return export_format;
    }

    public StringList generate_prefix_wo6() {
        StringList output = new StringList();
        output.append("UTF8 DATATON_DFC_DATA_590925_620721_AUC069 {");
        output.append("  \"Structure and File Format (C) Copyright Dataton AB\" 2015 1");
        output.append("  \"WATCHMAKER\" 6 0 0 0");
        output.append("  ObjTransferable ObjTransferable struct extends {");
        output.append("    TextTransferable struct extends {");
        output.append("      Transferable struct {");
        output.append("      }");
        output.append("    } {");
        output.append("    }");
        output.append("  } {");
        output.append("    mObjData list object true,");
        output.append("    mClassName string");
        output.append("  } {");
        output.append("    { // mObjData");
        output.append("      DisplayDevice struct extends {");
        output.append("        DisplayDeviceBase struct extends {");
        output.append("          StageItem struct {");
        output.append("            mName string,");
        output.append("            mLoc IPoint struct extends {");
        output.append("              iPDBase struct {");
        output.append("                x int,");
        output.append("                y int");
        output.append("              }");
        output.append("            } {");
        output.append("            },");
        output.append("            mAddress string,");
        output.append("            mPrimary bool,");
        output.append("            mEnabled bool");
        output.append("          }");
        output.append("        } {");
        output.append("          mColor IColor struct {");
        output.append("            r int,");
        output.append("            g int,");
        output.append("            b int,");
        output.append("            a int");
        output.append("          },");
        output.append("          mAngle float,");
        output.append("          mDisplayMode DisplayMode enum {");
        output.append("            kDM_Normal 0,");
        output.append("            kDM_Muted 1,");
        output.append("            kDM_White 2,");
        output.append("            kDM_White_Masked 3,");
        output.append("            kDM_Pattern 4");
        output.append("          },");
        output.append("          mDistortion WarpSpec struct {");
        output.append("            mMode WarpMode enum {");
        output.append("              kWP_Rectangular 0,");
        output.append("              kWP_Perspective 1,");
        output.append("              kWP_Horizontal 2,");
        output.append("              kWP_Vertical 3,");
        output.append("              kWP_Spherical 4");
        output.append("            },");
        output.append("            mSmoothCorners bool,");
        output.append("            mHorizontalRows list WarpRow struct {");
        output.append("              mOriginalY float,");
        output.append("              mWarpPoints list WarpingPoint struct {");
        output.append("                mOriginalX float,");
        output.append("                mAnchor BezierPoint struct extends {");
        output.append("                  Point struct extends {");
        output.append("                    vtCSBase struct {");
        output.append("                      x float,");
        output.append("                      y float");
        output.append("                    }");
        output.append("                  } {");
        output.append("                  }");
        output.append("                } {");
        output.append("                  mControl1 Point,");
        output.append("                  mControl2 Point");
        output.append("                },");
        output.append("                mVerticalControl array 2 Point,");
        output.append("                mDistribution array 4 float");
        output.append("              } false");
        output.append("            } false,");
        output.append("            mDirectMesh DirectMesh struct {");
        output.append("              mVertices list DirectMeshPoint struct {");
        output.append("                mDestScreenCoord Point,");
        output.append("                mUVCoord Point,");
        output.append("                mColor IColor");
        output.append("              } false,");
        output.append("              mTriangles list DirectMeshTriangle struct {");
        output.append("                mPointIndices array 3 int");
        output.append("              } false");
        output.append("            }");
        output.append("          },");
        output.append("          mDialogState ModelessDialogState struct extends {");
        output.append("            WinState struct {");
        output.append("              mState State enum {");
        output.append("                kWS_NotShown 0,");
        output.append("                kWS_Iconized 1,");
        output.append("                kWS_Normal 2,");
        output.append("                kWS_ZoomedFull 3");
        output.append("              },");
        output.append("              mLeft int,");
        output.append("              mTop int,");
        output.append("              mWidth int,");
        output.append("              mHeight int,");
        output.append("              mActive bool");
        output.append("            }");
        output.append("          } {");
        output.append("            mLastTab int");
        output.append("          },");
        output.append("          mMasks list DisplayMaskSpec struct {");
        output.append("            mEdges list DMEdge struct {");
        output.append("              mInner DMPoint struct {");
        output.append("                mPos Point");
        output.append("              },");
        output.append("              mOuter DMPoint,");
        output.append("              mCollapsed bool");
        output.append("            } false,");
        output.append("            mBlendCurve TweenPointTrack struct extends {");
        output.append("              TweenTrack struct extends {");
        output.append("                TweenParam struct {");
        output.append("                }");
        output.append("              } {");
        output.append("                mExpanded bool,");
        output.append("                mHeight int");
        output.append("              }");
        output.append("            } {");
        output.append("              mPoints list TweenPoint struct extends {");
        output.append("                TweenParam");
        output.append("              } {");
        output.append("                mTimePos float");
        output.append("              } true,");
        output.append("              mExpr reference TweenExpression struct {");
        output.append("                mExpr Expression struct {");
        output.append("                  mItems list ExprItem struct {");
        output.append("                  } true");
        output.append("                },");
        output.append("                mExprY Expression,");
        output.append("                mExprZ Expression");
        output.append("              } false");
        output.append("            },");
        output.append("            mIsEnabled bool");
        output.append("          } false,");
        output.append("          mIsSynchMaster bool");
        output.append("        }");
        output.append("      } {");
        output.append("        mDim IDimension struct extends {");
        output.append("          iPDBase");
        output.append("        } {");
        output.append("        },");
        output.append("        mStageDim IDimension,");
        output.append("        mFixedScale bool,");
        output.append("        mSoftEdges list SoftedgeSpec struct {");
        output.append("          mIntersection Quad struct {");
        output.append("            MVertices array 4 Point");
        output.append("          },");
        output.append("          mTweenPoints TweenPointTrack");
        output.append("        } false,");
        output.append("        mUseDefaultSoftEdges bool,");
        output.append("        mOutput int,");
        output.append("        mWhitePoint FColor struct {");
        output.append("          r float,");
        output.append("          g float,");
        output.append("          b float,");
        output.append("          a float");
        output.append("        },");
        output.append("        mStereo Stereoscopy enum {");
        output.append("          kDS_None 0,");
        output.append("          kDS_Left 1,");
        output.append("          kDS_Right 2");
        output.append("        }");
        output.append("      } {");
        return output;
    }

    public StringList generate_display_data_wo6(DisplayGroup group, Boolean flag_initial_displaygroup_in_export) {
        StringList display_data = new StringList();
        for (DisplayObject display : group.displays) {
            if (!flag_initial_displaygroup_in_export.booleanValue() || display.display_id != 0) {
                display_data.append("      DisplayDevice {");
            }
            display_data.append("        \"" + display.name + "\", // mName");
            display_data.append("        { " + Display_Builder_4.floor((float)display.position.x) + ", " + Display_Builder_4.floor((float)display.position.y) + " }, // mLoc: Centre x,y");
            display_data.append("        \"" + group.player_name_prefix + display.player_number + "\", // mAddress");
            display_data.append("        false, // mPrimary");
            display_data.append("        true, // mEnabled");
            display_data.append("        { " + this.get_color_rgb_values_string(display.outline_colour) + " }, // mColor r g b a");
            display_data.append("        " + this.get_angle_as_fraction(display.rotation) + ", // mAngle");
            display_data.append("        0, // mDisplayMode");
            display_data.append("        { // mDistortion");
            display_data.append("          0, // mMode");
            display_data.append("          false, // mSmoothCorners");
            display_data.append("          { // mHorizontalRows");
            display_data.append("          },");
            display_data.append("          { // mDirectMesh");
            display_data.append("            { // mVertices");
            display_data.append("            },");
            display_data.append("            { // mTriangles");
            display_data.append("            }");
            display_data.append("          }");
            display_data.append("        },");
            display_data.append("        { 0, 0, 0, 0, 0, false, -1 }, // mDialogState");
            display_data.append("        { // mMasks");
            display_data.append("        },");
            display_data.append("        false, // mIsSynchMaster");
            display_data.append("        { " + Display_Builder_4.floor((float)group.display_resolution.x) + ", " + Display_Builder_4.floor((float)group.display_resolution.y) + " }, // mDim x y");
            display_data.append("        { " + Display_Builder_4.floor((float)group.display_dimensions_stage.x) + ", " + Display_Builder_4.floor((float)group.display_dimensions_stage.y) + " }, // mStageDim x y");
            if (group.stage_scale == 1.0f) {
                display_data.append("        true,");
            } else {
                display_data.append("        false,");
            }
            display_data.append("        { // mSoftEdges");
            display_data.append("        },");
            display_data.append("        true, // mUseDefaultSoftEdges");
            display_data.append("        " + display.output_number + ", // mOutput");
            display_data.append("        { 1, 1, 1, 1 }, // mWhitePoint r g b a");
            display_data.append("        0 // mStereo");
            display_data.append("      }");
        }
        return display_data;
    }

    public StringList generate_suffix_wo6() {
        StringList output = new StringList();
        output.append("    },");
        output.append("    \"StageItem\" // mClassName");
        output.append("  }");
        output.append("}");
        output.append("");
        return output;
    }

    public ExportFormat export_format_config_mpcdi(ExportFormat export_format) {
        export_format.id = 4;
        export_format.comment_prefix = "// ";
        export_format.comment_type = 1;
        export_format.export_clipboard = false;
        export_format.export_file = true;
        export_format.export_stagetiers_separate_files = true;
        export_format.file_extension = ".xml";
        export_format.format_name = "wo6";
        export_format.name = "FILE: MPCDI";
        return export_format;
    }

    public void mpcdi_file_export() {
        XML xml_mpcdi = new XML("MPCDI");
        xml_mpcdi.setString("profile", "2d");
        xml_mpcdi.setInt("level", 1);
        xml_mpcdi.setString("date", this.get_current_date_string());
        xml_mpcdi.setString("version", "1.0");
        XML xml_mpcdi_display = xml_mpcdi.addChild("display");
        XML xml_mpcdi_buffer = xml_mpcdi_display.addChild("buffer");
        xml_mpcdi_buffer.setString("id", "Area");
        PVector surface_dimensions = this.project.surface_dimensions_get("project");
        xml_mpcdi_buffer.setInt("xResolution", Display_Builder_4.round((float)surface_dimensions.x));
        xml_mpcdi_buffer.setInt("yResolution", Display_Builder_4.round((float)surface_dimensions.y));
        for (DisplayGroup group : this.project.display_groups) {
            this.generate_display_data_mpcdi(group, xml_mpcdi_buffer);
        }
        XML xml_mpcdi_extensionset = xml_mpcdi.addChild("extensionSet");
        XML xml_mpcdi_extension = xml_mpcdi_extensionset.addChild("extension");
        xml_mpcdi_extension.setString("name", "Generator");
        xml_mpcdi_extension.setString("hasExternalFiles", "false");
        XML xml_mpcdi_generated = xml_mpcdi_extension.addChild("generatedBy");
        xml_mpcdi_generated.setContent(this.app_signature_get());
        String mpcdi_xml_filename = "mpcdi.xml";
        String mpcdi_xml_filepath = String.valueOf(this.export_manager.export_folder_filepath) + mpcdi_xml_filename;
        String string = "Saving mpcdi XML file to: " + mpcdi_xml_filepath;
        this.ui.getClass();
        this.ui.osd_message_display(string, 0);
        this.saveXML(xml_mpcdi, mpcdi_xml_filepath);
        String mpcdi_zip_filename = String.valueOf(this.project.pref_project_name) + ".mpcdi";
        String mpcdi_zip_filepath = String.valueOf(this.export_manager.export_folder_filepath) + mpcdi_zip_filename;
        byte[] file_read_buffer = new byte[1024];
        try {
            int stream_length;
            File file_source = new File(mpcdi_xml_filepath);
            File file_destination = new File(mpcdi_zip_filepath);
            FileInputStream file_stream_input = new FileInputStream(file_source);
            FileOutputStream file_stream_output = new FileOutputStream(file_destination);
            ZipOutputStream zip_stream_output = new ZipOutputStream(file_stream_output);
            ZipEntry zip_entry = new ZipEntry(file_source.getName());
            zip_stream_output.putNextEntry(zip_entry);
            while ((stream_length = file_stream_input.read(file_read_buffer)) > 0) {
                zip_stream_output.write(file_read_buffer, 0, stream_length);
            }
            this.ui.getClass();
            this.ui.osd_message_display("MPCDI file successfully exported.", 1);
            file_stream_input.close();
            zip_stream_output.close();
        }
        catch (Exception exception) {
            this.ui.getClass();
            this.ui.osd_message_display("Error while attempting to create MPCDI Zip file.", 2);
        }
    }

    public XML generate_display_data_mpcdi(DisplayGroup group, XML xml_mpcdi_buffer) {
        PVector surface_dimensions = this.project.surface_dimensions_get("project");
        PVector display_dimensions_mpcdi = new PVector(group.display_resolution.x / surface_dimensions.x, group.display_resolution.y / surface_dimensions.y);
        int[] surface_bounds_project = this.project.surface_bounds_get("project");
        PVector display_position_mpcdi = new PVector(0.0f, 0.0f);
        String region_id = "";
        for (DisplayObject display : group.displays) {
            XML xml_mpcdi_display = xml_mpcdi_buffer.addChild("region");
            region_id = display.name;
            if (this.project.display_groups.size() > 1) {
                region_id = String.valueOf(group.name) + " - " + display.name;
            }
            xml_mpcdi_display.setString("id", region_id);
            xml_mpcdi_display.setInt("xResolution", Display_Builder_4.round((float)group.display_resolution.x));
            xml_mpcdi_display.setInt("yResolution", Display_Builder_4.round((float)group.display_resolution.y));
            xml_mpcdi_display.setString("xsize", Display_Builder_4.nf((float)display_dimensions_mpcdi.x));
            xml_mpcdi_display.setString("ysize", Display_Builder_4.nf((float)display_dimensions_mpcdi.y));
            display_position_mpcdi.x = (float)(display.stage_bounds[3] - surface_bounds_project[3]) / surface_dimensions.x;
            display_position_mpcdi.y = (float)(surface_bounds_project[2] - display.stage_bounds[2]) / surface_dimensions.y;
            xml_mpcdi_display.setString("x", Display_Builder_4.nf((float)display_position_mpcdi.x));
            xml_mpcdi_display.setString("y", Display_Builder_4.nf((float)display_position_mpcdi.y));
        }
        return xml_mpcdi_buffer;
    }

    public StringList export_data_d3_csv(DisplayGroup group) {
        StringList csv_output = new StringList();
        csv_output.append(this.generate_prefix_d3_csv());
        csv_output.append(this.generate_display_data_d3_csv(group));
        return csv_output;
    }

    public ExportFormat export_format_config_d3(ExportFormat export_format) {
        export_format.id = 5;
        export_format.comment_prefix = "# ";
        export_format.comment_type = 1;
        export_format.export_clipboard = true;
        export_format.export_file = true;
        export_format.export_stagetiers_separate_files = true;
        export_format.file_extension = ".csv";
        export_format.format_name = "d3";
        export_format.name = "DATA: D3";
        return export_format;
    }

    public StringList generate_prefix_d3_csv() {
        StringList output = new StringList();
        StringList csv_headers = new StringList();
        csv_headers.append("Projector_Name");
        csv_headers.append("Projector_Qte(Stack)");
        csv_headers.append("Projector_Native-Rez-X");
        csv_headers.append("Projector_Native-Rez-Y");
        csv_headers.append("Projector_Lumens(lux)");
        csv_headers.append("Projector_Brightness(%)");
        csv_headers.append("Projector_Total_Lumens(lux)");
        csv_headers.append("Projector_Trow-Ratio");
        csv_headers.append("Lens_Shift-H(%)");
        csv_headers.append("Lens_Shift-V(%)");
        csv_headers.append("Lens_X");
        csv_headers.append("Lens_Y");
        csv_headers.append("Lens_Z");
        csv_headers.append("Pitch(deg)");
        csv_headers.append("Yaw(deg)");
        csv_headers.append("Roll(deg)");
        csv_headers.append("Target_X");
        csv_headers.append("Target_Y");
        csv_headers.append("Target_Z");
        csv_headers.append("Target_Distance");
        csv_headers.append("Target_Width");
        csv_headers.append("Target_Height");
        csv_headers.append("Target_Illuminance");
        csv_headers.append("Target_DPI");
        csv_headers.append("Unit_Dim");
        csv_headers.append("Unit_Illuminance");
        csv_headers.append("Projector_UUID");
        String headers_output = Display_Builder_4.join((String[])csv_headers.array(), (String)",");
        output.append(headers_output);
        return output;
    }

    public StringList generate_display_data_d3_csv(DisplayGroup group) {
        StringList display_data = new StringList();
        StringList csv_column = new StringList();
        for (DisplayObject display : group.displays) {
            csv_column.clear();
            float projector_location_x = this.pixels_to_physical(display.position.x);
            float projector_location_y = this.pixels_to_physical(display.position.y) * -1.0f;
            float projector_location_z = -10.0f;
            int lens_position_precision = 4;
            csv_column.append(String.valueOf(group.name) + "-" + display.name);
            csv_column.append("1");
            csv_column.append(String.valueOf(Display_Builder_4.floor((float)group.display_resolution.x)));
            csv_column.append(String.valueOf(Display_Builder_4.floor((float)group.display_resolution.y)));
            csv_column.append("20000");
            csv_column.append("100");
            csv_column.append("20000");
            csv_column.append(Display_Builder_4.nf((float)(Display_Builder_4.abs((float)projector_location_z) / group.display_dimensions_physical.x), (int)1, (int)lens_position_precision));
            csv_column.append("0");
            csv_column.append("0");
            csv_column.append(Display_Builder_4.nf((float)projector_location_x, (int)1, (int)lens_position_precision));
            csv_column.append(Display_Builder_4.nf((float)projector_location_z, (int)1, (int)lens_position_precision));
            csv_column.append(Display_Builder_4.nf((float)projector_location_y, (int)1, (int)lens_position_precision));
            csv_column.append("0");
            csv_column.append("0");
            csv_column.append(String.valueOf(Display_Builder_4.degrees((float)display.rotation)));
            csv_column.append(Display_Builder_4.nf((float)projector_location_x, (int)1, (int)lens_position_precision));
            csv_column.append("0");
            csv_column.append(Display_Builder_4.nf((float)projector_location_y, (int)1, (int)lens_position_precision));
            csv_column.append(String.valueOf(projector_location_z));
            csv_column.append(String.valueOf(Display_Builder_4.floor((float)group.display_dimensions_physical.x)));
            csv_column.append(String.valueOf(Display_Builder_4.floor((float)group.display_dimensions_physical.y)));
            csv_column.append("100");
            csv_column.append(String.valueOf(group.display_pixel_density));
            csv_column.append("m");
            csv_column.append("lux");
            csv_column.append(this.uuid_string_get());
            display_data.append(Display_Builder_4.join((String[])csv_column.array(), (String)","));
        }
        return display_data;
    }

    public ExportFormat export_format_config_kinetic(ExportFormat export_format) {
        export_format.id = 6;
        export_format.comment_prefix = "# ";
        export_format.comment_type = 2;
        export_format.export_clipboard = true;
        export_format.export_file = true;
        export_format.export_stagetiers_separate_files = true;
        export_format.file_extension = ".csv";
        export_format.format_name = "RenderSurfaces";
        export_format.name = "CSV: KINETIC Surfaces";
        return export_format;
    }

    public StringList generate_kinetic_rendersurface_csv(DisplayGroup group) {
        StringList output = new StringList();
        StringList csv_column = new StringList();
        PVector group_surface_dimensions = new PVector();
        String csv_safe_name = "";
        group_surface_dimensions = group.projection_surface_dimensions_get();
        csv_safe_name = this.sanitize_string_csv(group.name);
        csv_column.clear();
        csv_column.append("RS" + Display_Builder_4.nf((int)this.get_number_from_id(group.id), (int)2) + " " + csv_safe_name);
        csv_column.append(String.valueOf(group.projection_surface_bounds[3]));
        csv_column.append(String.valueOf(group.projection_surface_bounds[0]));
        csv_column.append(String.valueOf(Display_Builder_4.round((float)group_surface_dimensions.x)));
        csv_column.append(String.valueOf(Display_Builder_4.round((float)group_surface_dimensions.y)));
        csv_column.append("#" + Display_Builder_4.hex((int)group.outline_colour, (int)6));
        output.append(Display_Builder_4.join((String[])csv_column.array(), (String)","));
        return output;
    }

    public ExportFormat export_format_config_psd_jsx_script(ExportFormat export_format) {
        export_format.id = 7;
        export_format.comment_prefix = "// ";
        export_format.comment_type = 1;
        export_format.export_clipboard = true;
        export_format.export_file = true;
        export_format.export_stagetiers_separate_files = true;
        export_format.file_extension = ".jsx";
        export_format.format_name = "PSD script";
        export_format.name = "JSX: PSD Script";
        return export_format;
    }

    public StringList generate_project_psd_jsx_script(ArrayList<MixedInputResult> image_file_list) {
        MixedInputResult image_file_status;
        Display_Builder_4.println((String)"generate_project_export_psd_jsx_script.");
        int[] project_projection_bounds = this.project.surface_bounds_get("project");
        PVector document_surface_dimensions = this.project.surface_dimensions_get("project");
        PVector document_origin_offset = new PVector((float)(0 - project_projection_bounds[3]), (float)(0 - project_projection_bounds[0]));
        StringList output = new StringList();
        StringList document_parameters = new StringList();
        document_parameters.append(String.valueOf(Display_Builder_4.round((float)document_surface_dimensions.x)));
        document_parameters.append(String.valueOf(Display_Builder_4.round((float)document_surface_dimensions.y)));
        document_parameters.append("96");
        document_parameters.append("\"" + this.sanitize_string_csv(this.project.pref_project_name) + "\"");
        document_parameters.append("NewDocumentMode.RGB");
        document_parameters.append("DocumentFill.WHITE");
        document_parameters.append("1");
        document_parameters.append("BitsPerChannelType.EIGHT");
        String document_parameters_output = Display_Builder_4.join((String[])document_parameters.array(), (String)", ");
        output.append("/* Photoshop script to create Display Outputs in PSD file. */");
        output.append("displayDialogs = DialogModes.NO; // Suppress Dialogue boxes.");
        output.append("var original_ruler_unit = preferences.rulerUnits; // Store current units.");
        output.append("preferences.rulerUnits = Units.PIXELS; // Set units to Pixels.");
        output.append("// Create new document.");
        output.append("var master_doc_ref = app.documents.add(" + document_parameters_output + ")");
        output.append("// Add document metadata.");
        output.append("doc_info_ref = master_doc_ref.info;");
        output.append("doc_info_ref.title = \"" + this.project.pref_project_name + "\";");
        output.append("doc_info_ref.author = \"" + this.app_signature_get() + "\";");
        output.append("doc_info_ref.ownerUrl = \"" + this.web_url + "\";");
        output.append("// Create layer groups 'OUTPUT' & 'MAP'.");
        output.append("var layer_sets = new Array(); // Create array for the layer sets.");
        output.append("layer_sets[0] = master_doc_ref.layerSets.add();");
        output.append("layer_sets[0].name = \"OUTPUT\";");
        output.append("layer_sets[1] = master_doc_ref.layerSets.add();");
        output.append("layer_sets[1].name = \"MAP\";");
        output.append("// Create arrays to hold the layers.");
        output.append("var output_layers = new Array();");
        output.append("var map_layers = new Array();");
        if (image_file_list.size() > 0) {
            output.append("// Create layer group for grid images.");
            output.append("layer_sets[2] = master_doc_ref.layerSets.add();");
            output.append("layer_sets[2].name = \"GRID IMAGES\";");
            output.append("var grid_image_layers = new Array();");
        }
        output.append("var selection_bounds = new Array();");
        output.append("var layer_dimensions = new Array();");
        output.append("var fillColor = new SolidColor();");
        output.append("var text_layer_ref;");
        output.append("var textColor = new SolidColor();");
        output.append("textColor.rgb.red = 255;");
        output.append("textColor.rgb.green = 255;");
        output.append("textColor.rgb.blue = 255;");
        output.append("var text_bounds = 0");
        output.append("var text_width = 0");
        output.append("var text_scale = 100");
        output.append("//");
        output.append("// Create one layer per display.");
        int layer_id_map = 0;
        int layer_id_output = 0;
        String layer_name = "";
        int layer_colour = this.color(255, 255, 255, 255);
        int layer_colour_previous = this.color(255, 255, 255, 255);
        for (DisplayGroup group : this.project.display_groups) {
            PVector layer_position_top_left = new PVector(0.0f, 0.0f);
            PVector layer_position_bottom_right = new PVector(0.0f, 0.0f);
            int[] nArray = new int[4];
            nArray[3] = 255;
            int[] layer_color_rgba = nArray;
            if (group.display_type == this.project.LED_PANEL || group.display_type == this.project.DISPLAY_VIRTUAL) {
                layer_name = String.valueOf(this.get_number_from_id(layer_id_map)) + " " + group.name;
                layer_colour = group.outline_colour;
                if (layer_id_map > 0 && this.colour_compare_match(layer_colour, layer_colour_previous).booleanValue()) {
                    layer_colour = this.colour_generate_hue_shift(layer_colour, layer_id_map);
                }
                layer_color_rgba = this.get_color_rgb_values(layer_colour);
                layer_position_top_left.y = (float)group.projection_surface_bounds[0] + document_origin_offset.y;
                layer_position_bottom_right.x = (float)group.projection_surface_bounds[1] + document_origin_offset.x + 1.0f;
                layer_position_bottom_right.y = (float)group.projection_surface_bounds[2] + document_origin_offset.y + 1.0f;
                layer_position_top_left.x = (float)group.projection_surface_bounds[3] + document_origin_offset.x;
                output.append("//");
                output.append("// MAP " + Display_Builder_4.nf((int)layer_id_map, (int)2) + ":");
                output.append("  layer_dimensions[0] = " + Display_Builder_4.round((float)(layer_position_bottom_right.x - layer_position_top_left.x)) + ";");
                output.append("  layer_dimensions[1] = " + Display_Builder_4.round((float)(layer_position_bottom_right.y - layer_position_top_left.y)) + ";");
                output.append("  map_layers[" + layer_id_map + "] = layer_sets[1].artLayers.add();");
                output.append("  map_layers[" + layer_id_map + "].name = \"" + layer_name + "\"; // Set MAP name.");
                output.append("  master_doc_ref.activeLayer = map_layers[" + layer_id_map + "];");
                output.append("  // Create area shape using bounds of each Display.");
                output.append("  selection_bounds = [");
                output.append("    [" + layer_position_top_left.x + "," + layer_position_top_left.y + "],");
                output.append("    [" + layer_position_bottom_right.x + "," + layer_position_top_left.y + "],");
                output.append("    [" + layer_position_bottom_right.x + "," + layer_position_bottom_right.y + "],");
                output.append("    [" + layer_position_top_left.x + "," + layer_position_bottom_right.y + "]");
                output.append("  ] ");
                output.append("  master_doc_ref.selection.select(selection_bounds); // Set selection area.");
                output.append("  // Fill layer with solid colour.");
                output.append("  fillColor.rgb.red   = " + layer_color_rgba[0] + ";");
                output.append("  fillColor.rgb.green = " + layer_color_rgba[1] + ";");
                output.append("  fillColor.rgb.blue  = " + layer_color_rgba[2] + ";");
                output.append("  app.activeDocument.selection.fill(fillColor, ColorBlendMode.NORMAL, 100, false);");
                output.append(this.layer_text_script_get(1, layer_name, group.projection_surface_bounds, document_origin_offset));
                output.append("  master_doc_ref.activeLayer = map_layers[" + layer_id_map + "];");
                output.append("  // Restore area shape after adding text layer.");
                output.append("  selection_bounds = [");
                output.append("    [" + layer_position_top_left.x + "," + layer_position_top_left.y + "],");
                output.append("    [" + layer_position_bottom_right.x + "," + layer_position_top_left.y + "],");
                output.append("    [" + layer_position_bottom_right.x + "," + layer_position_bottom_right.y + "],");
                output.append("    [" + layer_position_top_left.x + "," + layer_position_bottom_right.y + "]");
                output.append("  ]");
                output.append("  master_doc_ref.selection.select(selection_bounds); // Set selection area.");
                if (group.id < image_file_list.size()) {
                    image_file_status = image_file_list.get(group.id);
                    if (image_file_status.status.booleanValue()) {
                        output.append(this.grid_file_script_get(group.id, group.name, image_file_status.text));
                    }
                }
                ++layer_id_map;
                layer_colour_previous = group.outline_colour;
                continue;
            }
            for (DisplayObject display : group.displays) {
                layer_name = String.valueOf(group.name) + " " + this.get_number_from_id(display.display_id);
                layer_position_top_left.y = (float)display.stage_bounds[0] + document_origin_offset.y;
                layer_position_bottom_right.x = (float)display.stage_bounds[1] + document_origin_offset.x + 1.0f;
                layer_position_bottom_right.y = (float)display.stage_bounds[2] + document_origin_offset.y + 1.0f;
                layer_position_top_left.x = (float)display.stage_bounds[3] + document_origin_offset.x;
                layer_color_rgba = this.get_color_rgb_values(display.outline_colour);
                output.append("//");
                output.append("// Display output " + Display_Builder_4.nf((int)layer_id_output, (int)2) + ":");
                output.append("  layer_dimensions[0] = " + Display_Builder_4.round((float)(layer_position_bottom_right.x - layer_position_top_left.x)) + ";");
                output.append("  layer_dimensions[1] = " + Display_Builder_4.round((float)(layer_position_bottom_right.y - layer_position_top_left.y)) + ";");
                output.append("  output_layers[" + layer_id_output + "] = layer_sets[0].artLayers.add();");
                output.append("  output_layers[" + layer_id_output + "].name = \"" + layer_name + "\"; // Set Output name.");
                output.append("  master_doc_ref.activeLayer = output_layers[" + layer_id_output + "];");
                output.append("  // Create area shape using bounds of each Display.");
                output.append("  selection_bounds = [");
                output.append("    [" + layer_position_top_left.x + "," + layer_position_top_left.y + "],");
                output.append("    [" + layer_position_bottom_right.x + "," + layer_position_top_left.y + "],");
                output.append("    [" + layer_position_bottom_right.x + "," + layer_position_bottom_right.y + "],");
                output.append("    [" + layer_position_top_left.x + "," + layer_position_bottom_right.y + "]");
                output.append("  ]");
                output.append("  master_doc_ref.selection.select(selection_bounds); // Set selection area.");
                output.append("  // Fill layer with solid colour.");
                output.append("  fillColor.rgb.red   = " + layer_color_rgba[0] + ";");
                output.append("  fillColor.rgb.green = " + layer_color_rgba[1] + ";");
                output.append("  fillColor.rgb.blue  = " + layer_color_rgba[2] + ";");
                output.append("  app.activeDocument.selection.fill(fillColor, ColorBlendMode.NORMAL, 100, false);");
                output.append(this.layer_text_script_get(0, layer_name, display.stage_bounds, document_origin_offset));
                output.append("  master_doc_ref.activeLayer = output_layers[" + layer_id_output + "];");
                output.append("  // Add Guides at Display bounds. ");
                output.append("  master_doc_ref.guides.add(Direction.HORIZONTAL," + layer_position_top_left.y + ");");
                output.append("  master_doc_ref.guides.add(Direction.VERTICAL," + layer_position_bottom_right.x + ");");
                output.append("  master_doc_ref.guides.add(Direction.HORIZONTAL," + layer_position_bottom_right.y + ");");
                output.append("  master_doc_ref.guides.add(Direction.VERTICAL," + layer_position_top_left.x + ");");
                ++layer_id_output;
            }
            layer_position_top_left.y = (float)group.projection_surface_bounds[0] + document_origin_offset.y;
            layer_position_bottom_right.x = (float)group.projection_surface_bounds[1] + document_origin_offset.x + 1.0f;
            layer_position_bottom_right.y = (float)group.projection_surface_bounds[2] + document_origin_offset.y + 1.0f;
            layer_position_top_left.x = (float)group.projection_surface_bounds[3] + document_origin_offset.x;
            output.append("  // Get selection for DisplayGroup.");
            output.append("  selection_bounds = [");
            output.append("    [" + layer_position_top_left.x + "," + layer_position_top_left.y + "],");
            output.append("    [" + layer_position_bottom_right.x + "," + layer_position_top_left.y + "],");
            output.append("    [" + layer_position_bottom_right.x + "," + layer_position_bottom_right.y + "],");
            output.append("    [" + layer_position_top_left.x + "," + layer_position_bottom_right.y + "]");
            output.append("  ]");
            output.append("  master_doc_ref.selection.select(selection_bounds); // Set selection area.");
            if (group.id >= image_file_list.size()) continue;
            image_file_status = image_file_list.get(group.id);
            if (!image_file_status.status.booleanValue()) continue;
            output.append(this.grid_file_script_get(group.id, group.name, image_file_status.text));
        }
        if (image_file_list.size() > this.project.display_groups.size()) {
            image_file_status = image_file_list.get(image_file_list.size() - 1);
            String grid_name = "physical";
            String file_ref = "file_ref_" + grid_name;
            String grid_image_document_name = "display_builder_grid_image_" + grid_name;
            output.append("  //");
            output.append("  // Import Physical grid image.");
            output.append("  var " + file_ref + " = new File(\"" + image_file_status.text + "\");");
            output.append("  var " + grid_image_document_name + " = app.open(" + file_ref + ");");
            output.append("  app.activeDocument = " + grid_image_document_name + ";");
            output.append("  " + grid_image_document_name + ".selection.selectAll();");
            output.append("  " + grid_image_document_name + ".selection.copy();");
            output.append("  app.activeDocument = master_doc_ref;");
            output.append("  master_doc_ref.selection.selectAll();");
            output.append("  master_doc_ref.backgroundLayer.allLocked = false;");
            output.append("  master_doc_ref.activeLayer = master_doc_ref.backgroundLayer;");
            output.append("  master_doc_ref.activeLayer.isBackgroundLayer = false;");
            output.append("  master_doc_ref.activeLayer.name = \"Lineup - " + grid_name + "\";");
            output.append("  master_doc_ref.paste();");
            output.append("  master_doc_ref.activeLayer.merge();");
            output.append("  " + grid_image_document_name + ".close(SaveOptions.DONOTSAVECHANGES);");
        }
        output.append("  app.activeDocument.selection.deselect(); // Unset selection.");
        output.append("//");
        output.append("// Add guides at document centre.");
        output.append("master_doc_ref.guides.add(Direction.HORIZONTAL," + document_surface_dimensions.y / 2.0f + ");");
        output.append("master_doc_ref.guides.add(Direction.VERTICAL," + document_surface_dimensions.x / 2.0f + ");");
        output.append("// Add User custom guides.");
        for (Guide guide : this.project.guides) {
            if (guide.type != 1) continue;
            GuideLine user_guide_line = (GuideLine)this.project.guides.get(guide.id);
            if (user_guide_line.orientation == 0) {
                output.append("master_doc_ref.guides.add(Direction.VERTICAL," + (user_guide_line.get_position().x + document_origin_offset.x) + ");");
                continue;
            }
            output.append("master_doc_ref.guides.add(Direction.HORIZONTAL," + (user_guide_line.get_position().y + document_origin_offset.y) + ");");
        }
        String psd_filename = String.valueOf(this.sanitize_file_name(String.valueOf(this.project.pref_project_name) + " XMAP " + this.get_current_date_string())) + ".psd";
        output.append("// Save file.");
        output.append("psd_file = new File(\"" + this.export_manager.export_folder_filepath + psd_filename + "\"); // File save location.");
        output.append("psd_file_options = new PhotoshopSaveOptions();");
        output.append("psd_file_options.alphaChannels = false;");
        output.append("psd_file_options.annotations = false;");
        output.append("psd_file_options.embedColorProfile = false;");
        output.append("psd_file_options.layers = true;");
        output.append("psd_file_options.spotColors = false;");
        output.append("master_doc_ref.saveAs(psd_file, psd_file_options, true, Extension.LOWERCASE);");
        output.append("//master_doc_ref.close()");
        output.append("master_doc_ref = null; // Release references.");
        output.append("app.beep(); // Done!");
        output.append("app.preferences.rulerUnits = original_ruler_unit; // Restore original ruler unit setting.");
        return output;
    }

    public StringList grid_file_script_get(int group_id, String group_name, String image_filepath) {
        StringList file_output = new StringList();
        String file_ref = "file_ref_" + group_id;
        String grid_image_document_name = "display_builder_grid_image_" + group_id;
        file_output.append("  //");
        file_output.append("  // Import DisplayGroup grid image.");
        file_output.append("  var " + file_ref + " = new File(\"" + image_filepath + "\");");
        file_output.append("  var " + grid_image_document_name + " = app.open(" + file_ref + ");");
        file_output.append("  app.activeDocument = " + grid_image_document_name + ";");
        file_output.append("  " + grid_image_document_name + ".selection.selectAll();");
        file_output.append("  " + grid_image_document_name + ".selection.copy();");
        file_output.append("  app.activeDocument = master_doc_ref;");
        file_output.append("  grid_image_layers[" + group_id + "] = layer_sets[2].artLayers.add();");
        file_output.append("  grid_image_layers[" + group_id + "].name = \"" + this.get_number_from_id(group_id) + " " + group_name + "\"; // Set name.");
        file_output.append("  master_doc_ref.activeLayer = grid_image_layers[" + group_id + "];");
        file_output.append("  master_doc_ref.paste();");
        file_output.append("  " + grid_image_document_name + ".close(SaveOptions.DONOTSAVECHANGES);");
        return file_output;
    }

    public StringList layer_text_script_get(int layer_group_id, String label_text, int[] area_surface_bounds, PVector origin_offset) {
        StringList text_output = new StringList();
        PVector area_dimensions = this.dimensions_from_bounds(area_surface_bounds);
        PVector text_position = new PVector((float)area_surface_bounds[3] + area_dimensions.x * 0.5f + origin_offset.x, (float)area_surface_bounds[0] + area_dimensions.y * 0.5f + origin_offset.y);
        text_output.append("  // Add text label for DisplayGroup " + label_text + ".");
        text_output.append("  text_layer_ref = layer_sets[" + layer_group_id + "].artLayers.add();");
        text_output.append("  master_doc_ref.activeLayer = text_layer_ref;");
        text_output.append("  text_layer_ref.name = \"Text: " + label_text + "\" // Set layer name.");
        text_output.append("  text_layer_ref.kind = LayerKind.TEXT;");
        text_output.append("  var text_item_ref = text_layer_ref.textItem;");
        text_output.append("  text_item_ref.justification = Justification.CENTER;");
        text_output.append("  text_item_ref.position =  Array(" + text_position.x + ", " + text_position.y + ");");
        text_output.append("  text_item_ref.size = 100;");
        text_output.append("  text_item_ref.baselineShift = -42;");
        text_output.append("  text_item_ref.color = textColor;");
        text_output.append("  text_item_ref.contents = \"" + label_text + "\";");
        text_output.append("  text_bounds = text_layer_ref.bounds;");
        text_output.append("  text_width = text_bounds[2] - text_bounds[0];");
        text_output.append("  if (text_width > layer_dimensions[0]) {");
        text_output.append("    text_scale = ((layer_dimensions[0] * 0.95) / text_width) * 100;");
        text_output.append("    text_layer_ref.resize(text_scale, text_scale);");
        text_output.append("  }");
        text_output.append("  text_layer_ref.rasterize(RasterizeType.TEXTCONTENTS);");
        text_output.append("  text_layer_ref.merge(); // Merge with previous layer.");
        return text_output;
    }

    public StringList export_data_wo7(DisplayGroup group) {
        StringList wo7_output = new StringList();
        Boolean[] group_tier_list_positions = this.project.stage_tiers.get(group.stagetier_id).displaygroup_check(group.id);
        wo7_output.append(this.generate_display_data_wo7(group, group_tier_list_positions));
        return wo7_output;
    }

    public ExportFormat export_format_config_wo7(ExportFormat export_format) {
        export_format.id = 8;
        export_format.comment_prefix = "";
        export_format.comment_type = 0;
        export_format.export_clipboard = true;
        export_format.export_file = true;
        export_format.export_stagetiers_separate_files = false;
        export_format.file_extension = ".txt";
        export_format.format_name = "wo7";
        export_format.name = "DATA: WO v7";
        return export_format;
    }

    public StringList generate_display_data_wo7(DisplayGroup group, Boolean[] group_tier_list_positions) {
        StringList output = new StringList();
        this.debug_output("wo7_export_data_displays for DisplayGroup " + group.id);
        Boolean stagesize_same_as_resolution = true;
        PVector display_dimensions_pixels = new PVector(0.0f, 0.0f);
        PVector display_dimensions_stage = new PVector(0.0f, 0.0f);
        String output_type = "";
        if (group.stage_scale != 1.0f) {
            stagesize_same_as_resolution = false;
        }
        if (group_tier_list_positions[0].booleanValue()) {
            output.append("{");
            output.append("  \"Displays\": [");
        }
        for (DisplayObject display : group.displays) {
            output.append("    {");
            if (group.display_type == this.project.DISPLAY_VIRTUAL) {
                output_type = "virtual";
                display_dimensions_pixels = display.stage_footprint.copy();
                display_dimensions_stage = display.stage_footprint.copy();
                output.append("      \"address\": null,");
            } else {
                output_type = "gpu";
                display_dimensions_pixels = group.display_resolution.copy();
                display_dimensions_stage = group.display_dimensions_stage.copy();
                output.append("      \"address\": \"" + group.player_name_prefix + display.player_number + "\",");
            }
            output.append("      \"center\": {");
            output.append("        \"x\": " + display.position.x + ",");
            output.append("        \"y\": " + display.position.y * -1.0f + ",");
            output.append("        \"z\": 0.0");
            output.append("      },");
            output.append(this.export_data_displays_geometry_wo7());
            output.append("      \"height\": " + display_dimensions_stage.y + ",");
            output.append("      \"masks\": {},");
            output.append("      \"masksWithGeometry\": true,");
            output.append("      \"maskImageAsset\": null,");
            output.append("      \"name\": \"" + display.name + "\",");
            output.append("      \"output\": {");
            output.append("        \"channel\": " + display.output_number + ",");
            output.append("        \"colorDepth\": \"8-bpc\",");
            output.append("        \"mode\": \"normal\",");
            output.append("        \"resolutionX\": " + Display_Builder_4.floor((float)display_dimensions_pixels.x) + ",");
            output.append("        \"resolutionY\": " + Display_Builder_4.floor((float)display_dimensions_pixels.y) + ",");
            output.append("        \"sdiLinkType\": \"Single-Link\",");
            output.append("        \"type\": \"" + output_type + "\",");
            output.append("        \"delayFrames\": 0");
            output.append("      },");
            output.append("      \"rotationZ\": " + display.rotation + ",");
            output.append("      \"tiersMask\": " + this.get_number_from_id(group.stagetier_id) + ",");
            output.append("      \"useHwSync\": false,");
            output.append("      \"isSyncMaster\": false,");
            output.append("      \"hwGroup\": null,");
            output.append("      \"whitePoint\": {");
            output.append("        \"a\": 1.0,");
            output.append("        \"b\": 1.0,");
            output.append("        \"g\": 1.0,");
            output.append("        \"r\": 1.0");
            output.append("      },");
            output.append("      \"width\": " + display_dimensions_stage.x + ",");
            output.append("      \"zFar\": 200000,");
            output.append("      \"zNear\": 100,");
            output.append("      \"enabled\": false,");
            output.append("      \"locked\": false,");
            output.append("      \"sizeAsResolution\": " + stagesize_same_as_resolution + ",");
            output.append("      \"color\": \"#" + Display_Builder_4.hex((int)display.outline_colour, (int)6) + "\",");
            output.append("      \"displaySettingAssetKey\": null,");
            output.append("      \"canvasId\": null,");
            output.append("      \"interlaced\": false,");
            output.append("      \"ndiCalibrationStream\": \"\",");
            output.append("      \"calibrationPoints\": null,");
            output.append("      \"showInfo\": true");
            if (display.display_id == group.displays.size() - 1 && group_tier_list_positions[2].booleanValue()) {
                output.append("    }");
                continue;
            }
            output.append("    },");
        }
        if (group_tier_list_positions[2].booleanValue()) {
            output.append("  ]");
            output.append("}");
        }
        return output;
    }

    public StringList get_export_data_comments_json() {
        StringList comment_lines = new StringList();
        comment_lines.append(",{");
        comment_lines.append("  \"Comments\": [");
        comment_lines.append("    {");
        comment_lines.append("      \"project_name\": \"" + this.project.pref_project_name + "\",");
        comment_lines.append("      \"generated\": \"" + this.app_signature_get() + "\",");
        comment_lines.append("    }");
        comment_lines.append("  ]");
        comment_lines.append("}");
        return comment_lines;
    }

    public StringList export_data_displays_geometry_wo7() {
        StringList output = new StringList();
        output.append("      \"colorSpace\": \"sRGB (gamma 2.2)\",");
        output.append("      \"eyeId\": \"0\",");
        output.append("      \"eye\": {");
        output.append("        \"x\": 0.0,");
        output.append("        \"y\": 0.0,");
        output.append("        \"z\": 5000.0");
        output.append("      },");
        output.append("      \"frustum\": null,");
        output.append("      \"geometry\": {");
        output.append("        \"enabled\": false,");
        output.append("        \"rows\": [");
        output.append("          [");
        output.append("            \"0\",");
        output.append("            \"1\"");
        output.append("          ],");
        output.append("          [");
        output.append("            \"2\",");
        output.append("            \"3\"");
        output.append("          ]");
        output.append("        ],");
        output.append("        \"junctions\": {");
        output.append("          \"3\": {");
        output.append("            \"src\": {");
        output.append("              \"x\": 1.0,");
        output.append("              \"y\": 1.0");
        output.append("            },");
        output.append("            \"dst\": {");
        output.append("              \"x\": 1.0,");
        output.append("              \"y\": 1.0");
        output.append("            },");
        output.append("            \"handles\": {");
        output.append("              \"Down\": {");
        output.append("                \"x\": 0.0,");
        output.append("                \"y\": -0.0");
        output.append("              },");
        output.append("              \"Left\": {");
        output.append("                \"x\": -0.0,");
        output.append("                \"y\": 0.0");
        output.append("              }");
        output.append("            },");
        output.append("            \"smooth\": true");
        output.append("          },");
        output.append("          \"2\": {");
        output.append("            \"src\": {");
        output.append("              \"x\": 0.0,");
        output.append("              \"y\": 1.0");
        output.append("            },");
        output.append("            \"dst\": {");
        output.append("              \"x\": 0.0,");
        output.append("              \"y\": 1.0");
        output.append("            },");
        output.append("            \"handles\": {");
        output.append("              \"Right\": {");
        output.append("                \"x\": 0.0,");
        output.append("                \"y\": 0.0");
        output.append("              },");
        output.append("              \"Down\": {");
        output.append("                \"x\": 0.0,");
        output.append("                \"y\": -0.0");
        output.append("              }");
        output.append("            },");
        output.append("            \"smooth\": true");
        output.append("          },");
        output.append("          \"1\": {");
        output.append("            \"src\": {");
        output.append("              \"x\": 1.0,");
        output.append("              \"y\": 0.0");
        output.append("            },");
        output.append("            \"dst\": {");
        output.append("              \"x\": 1.0,");
        output.append("              \"y\": 0.0");
        output.append("            },");
        output.append("            \"handles\": {");
        output.append("              \"Up\": {");
        output.append("                \"x\": 0.0,");
        output.append("                \"y\": 0.0");
        output.append("              },");
        output.append("              \"Left\": {");
        output.append("                \"x\": -0.0,");
        output.append("                \"y\": 0.0");
        output.append("              }");
        output.append("            },");
        output.append("            \"smooth\": true");
        output.append("          },");
        output.append("          \"0\": {");
        output.append("            \"src\": {");
        output.append("              \"x\": 0.0,");
        output.append("              \"y\": 0.0");
        output.append("            },");
        output.append("            \"dst\": {");
        output.append("              \"x\": 0.0,");
        output.append("              \"y\": 0.0");
        output.append("            },");
        output.append("            \"handles\": {");
        output.append("              \"Right\": {");
        output.append("                \"x\": 0.0,");
        output.append("                \"y\": 0.0");
        output.append("              },");
        output.append("              \"Up\": {");
        output.append("                \"x\": 0.0,");
        output.append("                \"y\": 0.0");
        output.append("              }");
        output.append("            },");
        output.append("            \"smooth\": true");
        output.append("          }");
        output.append("        },");
        output.append("        \"perspectiveCorrection\": null,");
        output.append("        \"cornerShapes\": false");
        output.append("      },");
        return output;
    }

    public StringList export_data_virtual_display_cues_wo7(DisplayGroup group) {
        PVector offset = new PVector(0.0f, 0.0f);
        if (group.stagetier_id < this.project.stage_tiers.size()) {
            StageTier group_stagetier = this.project.stage_tiers.get(group.stagetier_id);
            if (group_stagetier.name.equals("OUTPUT")) {
                offset = group.child_displaygroup_offset_get();
            }
        }
        StringList output = new StringList();
        output.append("{");
        output.append("  \"Cues\": [");
        for (DisplayObject display : group.displays) {
            output.append("    {");
            output.append("      \"start\": 0,");
            output.append("      \"layer\": " + display.display_id + ",");
            output.append("      \"locked\": false,");
            output.append("      \"color\": null,");
            output.append("      \"type\": \"media\",");
            output.append("      \"duration\": 10000,");
            output.append("      \"preroll\": 300,");
            output.append("      \"inTime\": 0,");
            output.append("      \"freeRunning\": false,");
            output.append("      \"useHwAcc\": true,");
            output.append("      \"looping\": null,");
            output.append("      \"pos\": [");
            output.append("        " + (display.position.x + offset.x) + ",");
            output.append("        " + (display.position.y + offset.y) * -1.0f + ",");
            output.append("        0.0");
            output.append("      ],");
            output.append("      \"anchor\": [");
            output.append("        " + display.stage_footprint.x / 2.0f + ",");
            output.append("        " + display.stage_footprint.y / 2.0f + ",");
            output.append("        0.0");
            output.append("      ],");
            output.append("      \"tweens\": {},");
            output.append("      \"fadeIn\": null,");
            output.append("      \"fadeOut\": null,");
            output.append("      \"mediaSource\": {");
            output.append("        \"virtualDisplay\": \"" + display.display_id + "\"");
            output.append("      },");
            output.append("      \"assetVersion\": \"latest\",");
            output.append("      \"modelId\": null,");
            output.append("      \"meshInfo\": null,");
            output.append("      \"sizeInfo\": {");
            output.append("        \"originalBoundingBox\": {");
            output.append("          \"p0\": {");
            output.append("            \"x\": 0.0,");
            output.append("            \"y\": 0.0,");
            output.append("            \"z\": 0.0");
            output.append("          },");
            output.append("          \"size\": {");
            output.append("            \"x\": " + display.stage_footprint.x + ",");
            output.append("            \"y\": " + display.stage_footprint.y + ",");
            output.append("            \"z\": 0.0");
            output.append("          }");
            output.append("        },");
            output.append("        \"textureResolution\": {");
            output.append("          \"width\": " + Display_Builder_4.round((float)display.stage_footprint.x) + ",");
            output.append("          \"height\": " + Display_Builder_4.round((float)display.stage_footprint.y));
            output.append("        },");
            output.append("        \"textureResolutionPreScale\": true,");
            output.append("        \"preScaleType\": {");
            output.append("          \"factor\": [");
            output.append("            1.0,");
            output.append("            1.0,");
            output.append("            1.0");
            output.append("          ]");
            output.append("        },");
            output.append("        \"uniformScale\": true");
            output.append("      },");
            output.append("      \"routes\": null,");
            output.append("      \"blendMode\": \"normal\",");
            output.append("      \"culling\": \"none\",");
            output.append("      \"depthCheck\": false,");
            output.append("      \"tiersMask\": " + this.binary_mask_get_for_id(group.stagetier_id) + ",");
            output.append("      \"routeList\": null,");
            output.append("      \"frameBlend\": true");
            if (display.display_id == group.displays.size() - 1) {
                output.append("    }");
                continue;
            }
            output.append("    },");
        }
        output.append("  ]");
        output.append("}");
        return output;
    }

    public StringList generate_wo6_project_data() {
        StringList output = new StringList();
        output.append("UTF8 DATATON_DFC_DATA_590925_620721_AUC069 {");
        output.append("  \"Structure and File Format (C) Copyright Dataton AB\" 2017 1");
        output.append("  \"WATCHMAKER\" 6 3 1 0");
        output.append("  WATCHOUT_Show WATCHOUT_Show struct extends {");
        output.append("    SingleDocument struct {");
        output.append("      mWinStateList list NamedWinState struct extends {");
        output.append("        WinState struct {");
        output.append("          mState State enum {");
        output.append("            kWS_NotShown 0,");
        output.append("            kWS_Iconized 1,");
        output.append("            kWS_Normal 2,");
        output.append("            kWS_ZoomedFull 3");
        output.append("          },");
        output.append("          mLeft int,");
        output.append("          mTop int,");
        output.append("          mWidth int,");
        output.append("          mHeight int,");
        output.append("          mActive bool");
        output.append("        }");
        output.append("      } {");
        output.append("        mName string");
        output.append("      } true");
        output.append("    }");
        output.append("  } {");
        output.append("    mTextStyles list TextStyle struct {");
        output.append("      mName string,");
        output.append("      mBold bool,");
        output.append("      mItalic bool,");
        output.append("      mTextColor IColor struct {");
        output.append("        r int,");
        output.append("        g int,");
        output.append("        b int,");
        output.append("        a int");
        output.append("      },");
        output.append("      mFontName string,");
        output.append("      mFontSize int,");
        output.append("      mAlign int,");
        output.append("      mIndent int,");
        output.append("      mIndentSub int,");
        output.append("      mLineSpace int,");
        output.append("      mParaSpace int,");
        output.append("      mScaleBy int,");
        output.append("      mEffects TextEffects struct {");
        output.append("        mLightAngle float,");
        output.append("        mUseGlobalAngle bool,");
        output.append("        mDropShadow TextEffects::DropShadow struct {");
        output.append("          mActive bool,");
        output.append("          mDistance int,");
        output.append("          mOpacity float,");
        output.append("          mBlur int");
        output.append("        },");
        output.append("        mEmboss TextEffects::Emboss struct {");
        output.append("          mActive bool,");
        output.append("          mWidth int,");
        output.append("          mStrength int");
        output.append("        }");
        output.append("      }");
        output.append("    } false,");
        output.append("    mMediaList MediaList struct {");
        output.append("      mItemList MediaItemList struct {");
        output.append("        mItems list MediaListItem struct {");
        output.append("        } true");
        output.append("      },");
        output.append("      MWinState MediaWinState struct extends {");
        output.append("        WinState");
        output.append("      } {");
        output.append("        MColWidth array 8 int");
        output.append("      },");
        output.append("      mTallRows bool");
        output.append("    },");
        output.append("    mStage Stage struct {");
        output.append("      mTiers StageList struct {");
        output.append("        mItemList StageItemList struct {");
        output.append("          mItems list StageListItem struct {");
        output.append("          } true");
        output.append("        }");
        output.append("      },");
        output.append("      mCurrTier reference StageTier struct extends {");
        output.append("        StageListItem");
        output.append("      } {");
        output.append("        mItems StageItemList,");
        output.append("        mName string,");
        output.append("        mTierNum int,");
        output.append("        mTierMask int");
        output.append("      } false,");
        output.append("      mLayers list StageLayer struct {");
        output.append("        mItems list StageItem struct extends {");
        output.append("          StageListItem");
        output.append("        } {");
        output.append("          mName string,");
        output.append("          mLoc IPoint struct extends {");
        output.append("            iPDBase struct {");
        output.append("              x int,");
        output.append("              y int");
        output.append("            }");
        output.append("          } {");
        output.append("          },");
        output.append("          mAddress string,");
        output.append("          mPrimary bool,");
        output.append("          mEnabled bool,");
        output.append("          mDialogState ModelessDialogState struct extends {");
        output.append("            WinState");
        output.append("          } {");
        output.append("            mLastTab int,");
        output.append("            mNotebook string");
        output.append("          }");
        output.append("        } true,");
        output.append("        mName string,");
        output.append("        mVisible bool,");
        output.append("        mLevelNum int,");
        output.append("        mLevelMask int");
        output.append("      } false,");
        output.append("      mCurrLayer reference StageLayer false,");
        output.append("      mScale float,");
        output.append("      mLiveUpdate bool,");
        output.append("      mBackgroundColor IColor,");
        output.append("      mStaticItemsVisible bool,");
        output.append("      mWireframeMode bool,");
        output.append("      mPerspective bool,");
        output.append("      mFrameDimmedImages bool,");
        output.append("      mSBLayersVisible bool,");
        output.append("      mClickSelectsFrontmost bool,");
        output.append("      mCondPreview CondPreview enum {");
        output.append("        kCPV_Enabled 0,");
        output.append("        kCPV_None 1,");
        output.append("        kCPV_All 2");
        output.append("      },");
        output.append("      mPreviewMode PreviewMode enum {");
        output.append("        kPM_Wireframe 0,");
        output.append("        kPM_Thumbnails 1,");
        output.append("        kPM_VideoThumbnails 2,");
        output.append("        kPM_BestQuality 3,");
        output.append("        kPM_Masked 4");
        output.append("      },");
        output.append("      mPreviewAudio bool,");
        output.append("      mPreviewTiers PreviewTiers enum {");
        output.append("        kPL_All 0,");
        output.append("        kPL_Current 1,");
        output.append("        kPL_Some 2");
        output.append("      },");
        output.append("      mSpecPreviewTiers int,");
        output.append("      MWinState StageWinState struct extends {");
        output.append("        WinState");
        output.append("      } {");
        output.append("        XScroll int,");
        output.append("        YScroll int,");
        output.append("        DoViewStageList bool,");
        output.append("        StageListWidth int");
        output.append("      }");
        output.append("    },");
        output.append("    mPrefs Preferences struct {");
        output.append("      mBaseAddr string,");
        output.append("      mFramerateChoice FramerateStandard enum {");
        output.append("        <23.98Hz> 0,");
        output.append("        <24Hz> 1,");
        output.append("        <25Hz> 2,");
        output.append("        <29.97Hz> 3,");
        output.append("        <30Hz> 4,");
        output.append("        <48Hz> 5,");
        output.append("        <50Hz> 6,");
        output.append("        <59.94Hz> 7,");
        output.append("        <60Hz> 8");
        output.append("      },");
        output.append("      mIsCustomFramerate bool,");
        output.append("      mFrameRate float,");
        output.append("      mSoftedge TweenPointTrack struct extends {");
        output.append("        TweenTrack struct extends {");
        output.append("          TweenParam struct {");
        output.append("          }");
        output.append("        } {");
        output.append("          mExpanded bool,");
        output.append("          mHeight int");
        output.append("        }");
        output.append("      } {");
        output.append("        mPoints list TweenPoint struct extends {");
        output.append("          TweenParam");
        output.append("        } {");
        output.append("          mTimePos float");
        output.append("        } true,");
        output.append("        mExpr reference TweenExpression struct {");
        output.append("          mExpr Expression struct {");
        output.append("            mItems list ExprItem struct {");
        output.append("            } true");
        output.append("          },");
        output.append("          mExprY Expression,");
        output.append("          mExprZ Expression");
        output.append("        } false");
        output.append("      },");
        output.append("      mSoftedgeLayer int,");
        output.append("      mSBEnterRate time,");
        output.append("      mSBExitRate time,");
        output.append("      mEnabledConditions int,");
        output.append("      mComms CommsPrefs struct {");
        output.append("        mTCPOpen bool,");
        output.append("        mUDPOpen bool,");
        output.append("        mTCEnabled bool,");
        output.append("        mTCFormat TimeFormat enum {");
        output.append("          TF_Normal 0,");
        output.append("          TF_FILM 1,");
        output.append("          TF_EBU 2,");
        output.append("          TF_SMPTEnd 3,");
        output.append("          TF_SMPTEd 4,");
        output.append("          TF_SMPTE30 5,");
        output.append("          TF_PAL 6,");
        output.append("          TF_NTSC 7,");
        output.append("          TF_NTSC24 8");
        output.append("        },");
        output.append("        mTCOffset time,");
        output.append("        mDMXUnivRcv int,");
        output.append("        mDMXUnivSend int,");
        output.append("        mMSCEnabled bool,");
        output.append("        mMSCDevID int,");
        output.append("        mMSCQListMode MSCQListMode enum {");
        output.append("          kMQ_Ignore 0,");
        output.append("          kMQ_AllToMain 1,");
        output.append("          kMQ_MapToAux 2");
        output.append("        }");
        output.append("      },");
        output.append("      mControlPort string,");
        output.append("      mStillDuration time,");
        output.append("      mCenterAnchor bool,");
        output.append("      mAutoOnline bool,");
        output.append("      mAutoSaveEnabled bool,");
        output.append("      mAutoSaveInterval float,");
        output.append("      mAutoFileRefresh bool,");
        output.append("      mWASAPISharedMode WASAPIShareMode enum {");
        output.append("        kShared 0,");
        output.append("        kExclusive 1");
        output.append("      },");
        output.append("      mAudioOutputLimit int,");
        output.append("      mDisplayImportScaleFactor float,");
        output.append("      mDisplayImportOffset IPoint,");
        output.append("      mGlob3D Glob3D struct {");
        output.append("        mVanishing IPoint,");
        output.append("        mFocalLength int,");
        output.append("        mStereoEyeDist int");
        output.append("      },");
        output.append("      mTextLightAngle float,");
        output.append("      mDynImgSvrAddr string,");
        output.append("      mTrackingSvrAddr string,");
        output.append("      mTrackingSvrPort int,");
        output.append("      mTrackingScale int,");
        output.append("      mVolume float,");
        output.append("      mClusterName string,");
        output.append("      mExternalNdiIps string,");
        output.append("      mIsAudioFreeWheeling bool,");
        output.append("      mUseStereoPairs bool,");
        output.append("      mIsBypassAudioSplitter bool");
        output.append("    },");
        output.append("    mVarList VarList struct extends {");
        output.append("      VarListBase struct {");
        output.append("        mItemList VarItemList struct {");
        output.append("          mItems list VarListItem struct {");
        output.append("            mName string");
        output.append("          } true");
        output.append("        }");
        output.append("      }");
        output.append("    } {");
        output.append("      MWinState MediaWinState");
        output.append("    },");
        output.append("    mOutputList OutputList struct {");
        output.append("      mItemList OutputItemList struct {");
        output.append("        mItems list OutputItem struct {");
        output.append("          mName string");
        output.append("        } true");
        output.append("      },");
        output.append("      MWinState MediaWinState");
        output.append("    },");
        output.append("    mMainTimeline reference MainTimeline struct extends {");
        output.append("      Timeline struct extends {");
        output.append("        VisibleMedia struct extends {");
        output.append("          Media struct extends {");
        output.append("            MediaListItem");
        output.append("          } {");
        output.append("            mFile MediaFile struct {");
        output.append("              mPath string,");
        output.append("              mFileSize int,");
        output.append("              mModDate int,");
        output.append("              mHasURL bool,");
        output.append("              mIsProxy bool,");
        output.append("              mNoDownload bool,");
        output.append("              mAutoRefresh bool");
        output.append("            },");
        output.append("            mStagePreview bool");
        output.append("          }");
        output.append("        } {");
        output.append("          mDim IDimension struct extends {");
        output.append("            iPDBase");
        output.append("          } {");
        output.append("          },");
        output.append("          mAlphaMode AlphaMode enum {");
        output.append("            KAMUnknown 0,");
        output.append("            KAMNoAlpha 1,");
        output.append("            KAMStraight 2,");
        output.append("            KAMPreWhite 3,");
        output.append("            KAMPreBlack 4");
        output.append("          },");
        output.append("          mForcedAlphaMode AlphaMode,");
        output.append("          mSuppressThumbnail bool");
        output.append("        }");
        output.append("      } {");
        output.append("        mName string,");
        output.append("        mLayers list Layer struct {");
        output.append("          mName string,");
        output.append("          mCues list Cue struct {");
        output.append("            mTime TimeRange struct {");
        output.append("              MStart time,");
        output.append("              MDuration time");
        output.append("            },");
        output.append("            mCueID int");
        output.append("          } true,");
        output.append("          mExpanded bool,");
        output.append("          mIndex int,");
        output.append("          mConditional int,");
        output.append("          mDisabled bool,");
        output.append("          mStandBy StandByMode enum {");
        output.append("            kSB_Normal 0,");
        output.append("            kSB_StandBy 1,");
        output.append("            kSB_Both 2");
        output.append("          },");
        output.append("          mLocked bool,");
        output.append("          mSpecLevels bool,");
        output.append("          mLevels int");
        output.append("        } false,");
        output.append("        mCurrLayerIndex int,");
        output.append("        mTimeScale int,");
        output.append("        mDuration time,");
        output.append("        mCueIDSeed int,");
        output.append("        mFrontmostAtTop bool,");
        output.append("        MWinState TimelineWinState struct extends {");
        output.append("          WinState");
        output.append("        } {");
        output.append("          MSashPos int,");
        output.append("          MHdrWidth int,");
        output.append("          MVScrollPos int");
        output.append("        },");
        output.append("        mFixedDuration bool,");
        output.append("        mSpecTiers bool,");
        output.append("        mTiers int");
        output.append("      }");
        output.append("    } {");
        output.append("    } false,");
        output.append("    mTaskList TaskList struct {");
        output.append("      mItemList TaskItemList struct {");
        output.append("        mItems list TaskListItem struct {");
        output.append("          mTaskNum int");
        output.append("        } true");
        output.append("      },");
        output.append("      MWinState MediaWinState");
        output.append("    },");
        output.append("    mStatusList StatusList struct {");
        output.append("      MItems list StatusListItem struct {");
        output.append("        mSeqNum int");
        output.append("      } true,");
        output.append("      MWinState MediaWinState");
        output.append("    },");
        output.append("    mShaders ShaderProxies struct {");
        output.append("      mProxies list SCProxy struct {");
        output.append("        mRecipe ShaderRecipe struct {");
        output.append("          mIdentifiers string,");
        output.append("          mNumbIdentifiers int,");
        output.append("          mHash int");
        output.append("        }");
        output.append("      } false");
        output.append("    },");
        output.append("    mWinLayouts array 10 WindowLayout struct {");
        output.append("      mIsSet bool,");
        output.append("      mMediaWinState MediaWinState,");
        output.append("      mVarWinState MediaWinState,");
        output.append("      mOutputWinState MediaWinState,");
        output.append("      mTaskListWinState MediaWinState,");
        output.append("      mStatusListState MediaWinState,");
        output.append("      mStageWinState StageWinState,");
        output.append("      mStageScale float,");
        output.append("      mStageDefaultScale float,");
        output.append("      mTimeLineWinState TimelineWinState,");
        output.append("      mWinStates list NamedWinState false,");
        output.append("      mTaskStates list WindowLayout::taskStateListElem struct {");
        output.append("        task reference TimelineTask struct extends {");
        output.append("          Task struct extends {");
        output.append("            TaskListItem");
        output.append("          } {");
        output.append("            mTrigger Expression");
        output.append("          }");
        output.append("        } {");
        output.append("          mAction reference AuxTimeline struct extends {");
        output.append("            Timeline");
        output.append("          } {");
        output.append("            mAlwaysOnTop StackingOrder enum {");
        output.append("              kTaskListOrder 0,");
        output.append("              kOnTop 1,");
        output.append("              kAboveEdgeBlend 2");
        output.append("            }");
        output.append("          } false");
        output.append("        } false,");
        output.append("        winState TimelineWinState");
        output.append("      } false,");
        output.append("      mStageItemStates list WindowLayout::stageItemStateListElem struct {");
        output.append("        stageItem reference StageItem true,");
        output.append("        winState ModelessDialogState");
        output.append("      } false");
        output.append("    }");
        output.append("  } #1 {");
        output.append("    { // mWinStateList");
        output.append("      NamedWinState { 3, 0, 0, 0, 0, true, \"Desktop\" }, // mState mLeft mTop mWidth mHeight mActive mName");
        output.append("    },");
        output.append("    { // mTextStyles");
        output.append("    },");
        output.append("    { // mMediaList");
        output.append("      { // mItemList");
        output.append("        { // mItems");
        output.append("          MediaFolder struct extends {");
        output.append("            MediaListItem");
        output.append("          } {");
        output.append("            mName string,");
        output.append("            mItemList MediaItemList,");
        output.append("            mCollapsed bool");
        output.append("          } {");
        output.append("            \"Lineup\", // mName");
        output.append("            { // mItemList");
        output.append("              { // mItems");
        output.append("                StillMedia struct extends {");
        output.append("                  VisibleMedia");
        output.append("                } {");
        output.append("                  mSprite bool,");
        output.append("                  mIsPreSplit bool,");
        output.append("                  mMultiFileExt string");
        output.append("                } #3 {");
        output.append("                  { \"lineup/pixel-grid-1-4992x1080.png\", 173657, 1558004346, false, false, false, false }, // mFile mPath mFileSize mModDate mHasURL mIsProxy mNoDownload mAutoRefresh");
        output.append("                  true, // mStagePreview");
        output.append("                  { 4992, 1080 }, // mDim x y");
        output.append("                  1, // mAlphaMode");
        output.append("                  0, // mForcedAlphaMode");
        output.append("                  false, // mSuppressThumbnail");
        output.append("                  false, // mSprite");
        output.append("                  false, // mIsPreSplit");
        output.append("                  \"\" // mMultiFileExt");
        output.append("                },");
        output.append("                StillMedia #7 {");
        output.append("                  { \"lineup/display-greyscale-bars-1920x1080.png\", 10491, 1558004347, false, false, false, false }, // mFile mPath mFileSize mModDate mHasURL mIsProxy mNoDownload mAutoRefresh");
        output.append("                  true, // mStagePreview");
        output.append("                  { 1920, 1080 }, // mDim x y");
        output.append("                  1, // mAlphaMode");
        output.append("                  0, // mForcedAlphaMode");
        output.append("                  false, // mSuppressThumbnail");
        output.append("                  false, // mSprite");
        output.append("                  false, // mIsPreSplit");
        output.append("                  \"\" // mMultiFileExt");
        output.append("                },");
        output.append("                StillMedia #8 {");
        output.append("                  { \"lineup/display-warping-grid-1920x1080.png\", 48133, 1558004344, false, false, false, false }, // mFile mPath mFileSize mModDate mHasURL mIsProxy mNoDownload mAutoRefresh");
        output.append("                  true, // mStagePreview");
        output.append("                  { 1920, 1080 }, // mDim x y");
        output.append("                  2, // mAlphaMode");
        output.append("                  0, // mForcedAlphaMode");
        output.append("                  false, // mSuppressThumbnail");
        output.append("                  false, // mSprite");
        output.append("                  false, // mIsPreSplit");
        output.append("                  \"\" // mMultiFileExt");
        output.append("                },");
        output.append("                StillMedia #9 {");
        output.append("                  { \"lineup/physical-grid-4992x1080.png\", 101482, 1558004347, false, false, false, false }, // mFile mPath mFileSize mModDate mHasURL mIsProxy mNoDownload mAutoRefresh");
        output.append("                  true, // mStagePreview");
        output.append("                  { 4992, 1080 }, // mDim x y");
        output.append("                  1, // mAlphaMode");
        output.append("                  0, // mForcedAlphaMode");
        output.append("                  false, // mSuppressThumbnail");
        output.append("                  false, // mSprite");
        output.append("                  false, // mIsPreSplit");
        output.append("                  \"\" // mMultiFileExt");
        output.append("                },");
        output.append("                StillMedia #6 {");
        output.append("                  { \"lineup/display-colourbars-709-1920x1080.png\", 11507, 1558004347, false, false, false, false }, // mFile mPath mFileSize mModDate mHasURL mIsProxy mNoDownload mAutoRefresh");
        output.append("                  true, // mStagePreview");
        output.append("                  { 1920, 1080 }, // mDim x y");
        output.append("                  1, // mAlphaMode");
        output.append("                  0, // mForcedAlphaMode");
        output.append("                  false, // mSuppressThumbnail");
        output.append("                  false, // mSprite");
        output.append("                  false, // mIsPreSplit");
        output.append("                  \"\" // mMultiFileExt");
        output.append("                }");
        output.append("              }");
        output.append("            },");
        output.append("            false // mCollapsed");
        output.append("          }");
        output.append("        }");
        output.append("      },");
        output.append("      { 2, 560, 8, 436, 210, true, // MWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
        output.append("        { 286, 120, 75, 75, 60, 32767, 0, 0 }");
        output.append("      },");
        output.append("      false // mTallRows");
        output.append("    },");
        output.append("    { // mStage");
        output.append("      { // mTiers");
        output.append("        { // mItemList");
        output.append("          { // mItems");
        output.append("            StageTier #2 {");
        output.append("              { // mItems");
        output.append("                { // mItems");
        output.append("                  DisplayDevice struct extends {");
        output.append("                    DisplayDeviceBase struct extends {");
        output.append("                      StageItem");
        output.append("                    } {");
        output.append("                      mColor IColor,");
        output.append("                      mAngle float,");
        output.append("                      mAntiAliasing AntiAliasing enum {");
        output.append("                        kAA_Off 0,");
        output.append("                        kAA_Low 1,");
        output.append("                        kAA_Medium 2,");
        output.append("                        kAA_High 3");
        output.append("                      },");
        output.append("                      mDisplayMode DisplayMode enum {");
        output.append("                        kDM_Normal 0,");
        output.append("                        kDM_Muted 1,");
        output.append("                        kDM_White 2,");
        output.append("                        kDM_White_Masked 3,");
        output.append("                        kDM_Pattern 4");
        output.append("                      },");
        output.append("                      mDistortion WarpSpec struct {");
        output.append("                        mMode WarpMode enum {");
        output.append("                          kWP_Rectangular 0,");
        output.append("                          kWP_Perspective 1,");
        output.append("                          kWP_Horizontal 2,");
        output.append("                          kWP_Vertical 3,");
        output.append("                          kWP_Spherical 4,");
        output.append("                          kWP_FromFile 5");
        output.append("                        },");
        output.append("                        mAntiAliasing AntiAliasing2 enum {");
        output.append("                          kAA_Off 0,");
        output.append("                          kAA_Low 1,");
        output.append("                          kAA_Medium 2,");
        output.append("                          kAA_High 3");
        output.append("                        },");
        output.append("                        mSmoothCorners bool,");
        output.append("                        mHasWarpMesh bool,");
        output.append("                        mWarpDir string,");
        output.append("                        mHorizontalRows list WarpRow struct {");
        output.append("                          mOriginalY float,");
        output.append("                          mWarpPoints list WarpingPoint struct {");
        output.append("                            mOriginalX float,");
        output.append("                            mAnchor BezierPoint struct extends {");
        output.append("                              Point struct extends {");
        output.append("                                vtCSBase struct {");
        output.append("                                  x float,");
        output.append("                                  y float");
        output.append("                                }");
        output.append("                              } {");
        output.append("                              }");
        output.append("                            } {");
        output.append("                              mControl1 Point,");
        output.append("                              mControl2 Point");
        output.append("                            },");
        output.append("                            mVerticalControl array 2 Point,");
        output.append("                            mDistribution array 4 float");
        output.append("                          } false");
        output.append("                        } false,");
        output.append("                        mDirectMesh DirectMesh struct {");
        output.append("                          mVertices list DirectMeshPoint struct {");
        output.append("                            mDestScreenCoord Point,");
        output.append("                            mUVCoord Point,");
        output.append("                            mColor IColor");
        output.append("                          } false,");
        output.append("                          mTriangles list DirectMeshTriangle struct {");
        output.append("                            mPointIndices array 3 int");
        output.append("                          } false");
        output.append("                        }");
        output.append("                      },");
        output.append("                      mMasks list DisplayMaskSpec struct extends {");
        output.append("                        DisplayMaskSpecBase struct {");
        output.append("                          mIsEnabled bool");
        output.append("                        }");
        output.append("                      } {");
        output.append("                        mEdges list DMEdge struct {");
        output.append("                          mInner DMPoint struct {");
        output.append("                            mPos Point");
        output.append("                          },");
        output.append("                          mOuter DMPoint,");
        output.append("                          mCollapsed bool");
        output.append("                        } false,");
        output.append("                        mBlendCurve TweenPointTrack");
        output.append("                      } false,");
        output.append("                      mMaskList list DisplayMaskSpecBase true,");
        output.append("                      mMasksWithGeometry bool,");
        output.append("                      mIsSynchMaster bool,");
        output.append("                      mDisplayData string");
        output.append("                    }");
        output.append("                  } {");
        output.append("                    mDim IDimension,");
        output.append("                    mStageDim IDimension,");
        output.append("                    mFixedScale bool,");
        output.append("                    mSoftEdges list SoftedgeSpec struct {");
        output.append("                      mIntersection Quad struct {");
        output.append("                        MVertices array 4 Point");
        output.append("                      },");
        output.append("                      mTweenPoints TweenPointTrack");
        output.append("                    } false,");
        output.append("                    mUseDefaultSoftEdges bool,");
        output.append("                    mOutput int,");
        output.append("                    mWhitePoint FColor struct {");
        output.append("                      r float,");
        output.append("                      g float,");
        output.append("                      b float,");
        output.append("                      a float");
        output.append("                    },");
        output.append("                    mStereo Stereoscopy enum {");
        output.append("                      kDS_None 0,");
        output.append("                      kDS_Left 1,");
        output.append("                      kDS_Right 2");
        output.append("                    }");
        output.append("                  } {");
        output.append("                    \"Display_1\", // mName");
        output.append("                    { 1960, 1540 }, // mLoc x y");
        output.append("                    \"Player_1\", // mAddress");
        output.append("                    false, // mPrimary");
        output.append("                    true, // mEnabled");
        output.append("                    { 0, 0, 0, 0, 0, false, -1, \"DisplayNotebook\" }, // mDialogState mState mLeft mTop mWidth mHeight mActive mLastTab mNotebook");
        output.append("                    { 255, 102, 0, 255 }, // mColor r g b a");
        output.append("                    0, // mAngle");
        output.append("                    0, // mAntiAliasing");
        output.append("                    0, // mDisplayMode");
        output.append("                    { // mDistortion");
        output.append("                      0, // mMode");
        output.append("                      0, // mAntiAliasing");
        output.append("                      false, // mSmoothCorners");
        output.append("                      false, // mHasWarpMesh");
        output.append("                      \"\", // mWarpDir");
        output.append("                      { // mHorizontalRows");
        output.append("                      },");
        output.append("                      { // mDirectMesh");
        output.append("                        { // mVertices");
        output.append("                        },");
        output.append("                        { // mTriangles");
        output.append("                        }");
        output.append("                      }");
        output.append("                    },");
        output.append("                    { // mMasks");
        output.append("                    },");
        output.append("                    { // mMaskList");
        output.append("                    },");
        output.append("                    true, // mMasksWithGeometry");
        output.append("                    false, // mIsSynchMaster");
        output.append("                    \"\", // mDisplayData");
        output.append("                    { 1920, 1080 }, // mDim x y");
        output.append("                    { 1920, 1080 }, // mStageDim x y");
        output.append("                    true, // mFixedScale");
        output.append("                    { // mSoftEdges");
        output.append("                    },");
        output.append("                    true, // mUseDefaultSoftEdges");
        output.append("                    1, // mOutput");
        output.append("                    { 1, 1, 1, 1 }, // mWhitePoint r g b a");
        output.append("                    0 // mStereo");
        output.append("                  },");
        output.append("                  DisplayDevice {");
        output.append("                    \"Display_2\", // mName");
        output.append("                    { 3496, 1540 }, // mLoc x y");
        output.append("                    \"Player_1\", // mAddress");
        output.append("                    false, // mPrimary");
        output.append("                    true, // mEnabled");
        output.append("                    { 0, 0, 0, 0, 0, false, -1, \"DisplayNotebook\" }, // mDialogState mState mLeft mTop mWidth mHeight mActive mLastTab mNotebook");
        output.append("                    { 255, 102, 0, 255 }, // mColor r g b a");
        output.append("                    0, // mAngle");
        output.append("                    0, // mAntiAliasing");
        output.append("                    0, // mDisplayMode");
        output.append("                    { // mDistortion");
        output.append("                      0, // mMode");
        output.append("                      0, // mAntiAliasing");
        output.append("                      false, // mSmoothCorners");
        output.append("                      false, // mHasWarpMesh");
        output.append("                      \"\", // mWarpDir");
        output.append("                      { // mHorizontalRows");
        output.append("                      },");
        output.append("                      { // mDirectMesh");
        output.append("                        { // mVertices");
        output.append("                        },");
        output.append("                        { // mTriangles");
        output.append("                        }");
        output.append("                      }");
        output.append("                    },");
        output.append("                    { // mMasks");
        output.append("                    },");
        output.append("                    { // mMaskList");
        output.append("                    },");
        output.append("                    true, // mMasksWithGeometry");
        output.append("                    false, // mIsSynchMaster");
        output.append("                    \"\", // mDisplayData");
        output.append("                    { 1920, 1080 }, // mDim x y");
        output.append("                    { 1920, 1080 }, // mStageDim x y");
        output.append("                    true, // mFixedScale");
        output.append("                    { // mSoftEdges");
        output.append("                    },");
        output.append("                    true, // mUseDefaultSoftEdges");
        output.append("                    2, // mOutput");
        output.append("                    { 1, 1, 1, 1 }, // mWhitePoint r g b a");
        output.append("                    0 // mStereo");
        output.append("                  },");
        output.append("                  DisplayDevice {");
        output.append("                    \"Display_3\", // mName");
        output.append("                    { 5032, 1540 }, // mLoc x y");
        output.append("                    \"Player_1\", // mAddress");
        output.append("                    false, // mPrimary");
        output.append("                    true, // mEnabled");
        output.append("                    { 0, 0, 0, 0, 0, false, -1, \"DisplayNotebook\" }, // mDialogState mState mLeft mTop mWidth mHeight mActive mLastTab mNotebook");
        output.append("                    { 255, 102, 0, 255 }, // mColor r g b a");
        output.append("                    0, // mAngle");
        output.append("                    0, // mAntiAliasing");
        output.append("                    0, // mDisplayMode");
        output.append("                    { // mDistortion");
        output.append("                      0, // mMode");
        output.append("                      0, // mAntiAliasing");
        output.append("                      false, // mSmoothCorners");
        output.append("                      false, // mHasWarpMesh");
        output.append("                      \"\", // mWarpDir");
        output.append("                      { // mHorizontalRows");
        output.append("                      },");
        output.append("                      { // mDirectMesh");
        output.append("                        { // mVertices");
        output.append("                        },");
        output.append("                        { // mTriangles");
        output.append("                        }");
        output.append("                      }");
        output.append("                    },");
        output.append("                    { // mMasks");
        output.append("                    },");
        output.append("                    { // mMaskList");
        output.append("                    },");
        output.append("                    true, // mMasksWithGeometry");
        output.append("                    false, // mIsSynchMaster");
        output.append("                    \"\", // mDisplayData");
        output.append("                    { 1920, 1080 }, // mDim x y");
        output.append("                    { 1920, 1080 }, // mStageDim x y");
        output.append("                    true, // mFixedScale");
        output.append("                    { // mSoftEdges");
        output.append("                    },");
        output.append("                    true, // mUseDefaultSoftEdges");
        output.append("                    3, // mOutput");
        output.append("                    { 1, 1, 1, 1 }, // mWhitePoint r g b a");
        output.append("                    0 // mStereo");
        output.append("                  }");
        output.append("                }");
        output.append("              },");
        output.append("              \"Main\", // mName");
        output.append("              0, // mTierNum");
        output.append("              1 // mTierMask");
        output.append("            }");
        output.append("          }");
        output.append("        }");
        output.append("      },");
        output.append("      #2, // mCurrTier");
        output.append("      { // mLayers");
        output.append("      },");
        output.append("      #0, // mCurrLayer");
        output.append("      15.68, // mScale");
        output.append("      false, // mLiveUpdate");
        output.append("      { 0, 0, 0, 255 }, // mBackgroundColor r g b a");
        output.append("      true, // mStaticItemsVisible");
        output.append("      false, // mWireframeMode");
        output.append("      true, // mPerspective");
        output.append("      true, // mFrameDimmedImages");
        output.append("      false, // mSBLayersVisible");
        output.append("      true, // mClickSelectsFrontmost");
        output.append("      0, // mCondPreview");
        output.append("      3, // mPreviewMode");
        output.append("      true, // mPreviewAudio");
        output.append("      0, // mPreviewTiers");
        output.append("      0, // mSpecPreviewTiers");
        output.append("      { 2, 8, 8, 540, 210, false, -75, 4, false, 190 } // MWinState mState mLeft mTop mWidth mHeight mActive XScroll YScroll DoViewStageList StageListWidth");
        output.append("    },");
        output.append("    { // mPrefs");
        output.append("      \"\", // mBaseAddr");
        output.append("      8, // mFramerateChoice");
        output.append("      false, // mIsCustomFramerate");
        output.append("      60, // mFrameRate");
        output.append("      { // mSoftedge");
        output.append("        true, // mExpanded");
        output.append("        0, // mHeight");
        output.append("        { // mPoints");
        output.append("          OpacityTweenPoint struct extends {");
        output.append("            _tween1DValue struct extends {");
        output.append("              _quadTweenPoint struct extends {");
        output.append("                TweenPoint");
        output.append("              } {");
        output.append("                mSmooth bool");
        output.append("              }");
        output.append("            } {");
        output.append("              mValue float");
        output.append("            }");
        output.append("          } {");
        output.append("          } { 0, false, 1 // mTimePos mSmooth mValue");
        output.append("          },");
        output.append("          OpacityTweenPoint { 0.2, true, 0.2 }, // mTimePos mSmooth mValue");
        output.append("          OpacityTweenPoint { 1, false, 0 } // mTimePos mSmooth mValue");
        output.append("        },");
        output.append("        #0 // mExpr");
        output.append("      },");
        output.append("      0, // mSoftedgeLayer");
        output.append("      1.0, // mSBEnterRate");
        output.append("      1.0, // mSBExitRate");
        output.append("      0, // mEnabledConditions");
        output.append("      { false, false, false, 0, 0.0, 0, 1, false, 0, 0 }, // mComms mTCPOpen mUDPOpen mTCEnabled mTCFormat mTCOffset mDMXUnivRcv mDMXUnivSend mMSCEnabled mMSCDevID mMSCQListMode");
        output.append("      \"\", // mControlPort");
        output.append("      10.0, // mStillDuration");
        output.append("      true, // mCenterAnchor");
        output.append("      false, // mAutoOnline");
        output.append("      true, // mAutoSaveEnabled");
        output.append("      5, // mAutoSaveInterval");
        output.append("      false, // mAutoFileRefresh");
        output.append("      0, // mWASAPISharedMode");
        output.append("      8, // mAudioOutputLimit");
        output.append("      1000, // mDisplayImportScaleFactor");
        output.append("      { 1000, 1000 }, // mDisplayImportOffset x y");
        output.append("      { // mGlob3D");
        output.append("        { 3000, 1000 }, // mVanishing x y");
        output.append("        50, // mFocalLength");
        output.append("        150 // mStereoEyeDist");
        output.append("      },");
        output.append("      0.875, // mTextLightAngle");
        output.append("      \"\", // mDynImgSvrAddr");
        output.append("      \"238.210.10.1\", // mTrackingSvrAddr");
        output.append("      24002, // mTrackingSvrPort");
        output.append("      1000, // mTrackingScale");
        output.append("      0.5, // mVolume");
        output.append("      \"\", // mClusterName");
        output.append("      \"\", // mExternalNdiIps");
        output.append("      false, // mIsAudioFreeWheeling");
        output.append("      false, // mUseStereoPairs");
        output.append("      false // mIsBypassAudioSplitter");
        output.append("    },");
        output.append("    { // mVarList");
        output.append("      { // mItemList");
        output.append("        { // mItems");
        output.append("        }");
        output.append("      },");
        output.append("      { 0, 0, 0, 0, 0, false, // MWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
        output.append("        { 0, 0, 0, 0, 0, 0, 0, 0 }");
        output.append("      }");
        output.append("    },");
        output.append("    { // mOutputList");
        output.append("      { // mItemList");
        output.append("        { // mItems");
        output.append("        }");
        output.append("      },");
        output.append("      { 0, 0, 0, 0, 0, false, // MWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
        output.append("        { 0, 0, 0, 0, 0, 0, 0, 0 }");
        output.append("      }");
        output.append("    },");
        output.append("    { // mMainTimeline");
        output.append("      { \"\", 0, 0, false, false, false, false }, // mFile mPath mFileSize mModDate mHasURL mIsProxy mNoDownload mAutoRefresh");
        output.append("      true, // mStagePreview");
        output.append("      { 0, 0 }, // mDim x y");
        output.append("      0, // mAlphaMode");
        output.append("      0, // mForcedAlphaMode");
        output.append("      false, // mSuppressThumbnail");
        output.append("      \"Main Timeline\", // mName");
        output.append("      { // mLayers");
        int i = 0;
        while (i < 10) {
            output.append("        {");
            output.append("          \"\", // mName");
            output.append("          { // mCues");
            output.append("          },");
            output.append("          false, // mExpanded");
            output.append("          1, // mIndex");
            output.append("          0, // mConditional");
            output.append("          false, // mDisabled");
            output.append("          0, // mStandBy");
            output.append("          false, // mLocked");
            output.append("          false, // mSpecLevels");
            output.append("          1 // mLevels");
            output.append("        },");
            ++i;
        }
        output.append("        {");
        output.append("          \"\", // mName");
        output.append("          { // mCues");
        output.append("          },");
        output.append("          false, // mExpanded");
        output.append("          10, // mIndex");
        output.append("          0, // mConditional");
        output.append("          false, // mDisabled");
        output.append("          0, // mStandBy");
        output.append("          false, // mLocked");
        output.append("          false, // mSpecLevels");
        output.append("          1 // mLevels");
        output.append("        }");
        output.append("      },");
        output.append("      1, // mCurrLayerIndex");
        output.append("      50, // mTimeScale");
        output.append("      10:00.0, // mDuration");
        output.append("      0, // mCueIDSeed");
        output.append("      true, // mFrontmostAtTop");
        output.append("      { 2, 8, 374, 994, 328, false, 170, 200, 0 }, // MWinState mState mLeft mTop mWidth mHeight mActive MSashPos MHdrWidth MVScrollPos");
        output.append("      false, // mFixedDuration");
        output.append("      false, // mSpecTiers");
        output.append("      0 // mTiers");
        output.append("    },");
        output.append("    { // mTaskList");
        output.append("      { // mItemList");
        output.append("        { // mItems");
        output.append("          TimelineTask #4 {");
        output.append("            1, // mTaskNum");
        output.append("            { // mTrigger");
        output.append("              { // mItems");
        output.append("              }");
        output.append("            },");
        output.append("            { // mAction");
        output.append("              { \"\", 0, 0, false, false, false, false }, // mFile mPath mFileSize mModDate mHasURL mIsProxy mNoDownload mAutoRefresh");
        output.append("              true, // mStagePreview");
        output.append("              { 0, 0 }, // mDim x y");
        output.append("              0, // mAlphaMode");
        output.append("              0, // mForcedAlphaMode");
        output.append("              false, // mSuppressThumbnail");
        output.append("              \"Lineup\", // mName");
        output.append("              { // mLayers");
        output.append("                {");
        output.append("                  \"Control\", // mName");
        output.append("                  { // mCues");
        output.append("                    ControlCue struct extends {");
        output.append("                      Cue");
        output.append("                    } {");
        output.append("                      mName string,");
        output.append("                      mNamedTarget bool,");
        output.append("                      mTarget TargetTimeline enum {");
        output.append("                        kCCT_Current 0,");
        output.append("                        kCCT_Main 1,");
        output.append("                        kCCT_Named 2");
        output.append("                      },");
        output.append("                      mTargetName string,");
        output.append("                      mStop bool,");
        output.append("                      mJump bool,");
        output.append("                      mToCue bool,");
        output.append("                      mReverse bool,");
        output.append("                      mRun bool,");
        output.append("                      mJumpTime time,");
        output.append("                      mRestartDelay time,");
        output.append("                      mJumpCue string");
        output.append("                    } {");
        output.append("                      { 4.9, 0.001 }, // mTime MStart MDuration");
        output.append("                      2, // mCueID");
        output.append("                      \"\", // mName");
        output.append("                      false, // mNamedTarget");
        output.append("                      0, // mTarget");
        output.append("                      \"\", // mTargetName");
        output.append("                      false, // mStop");
        output.append("                      false, // mJump");
        output.append("                      false, // mToCue");
        output.append("                      false, // mReverse");
        output.append("                      false, // mRun");
        output.append("                      0.0, // mJumpTime");
        output.append("                      0.0, // mRestartDelay");
        output.append("                      \"\" // mJumpCue");
        output.append("                    },");
        output.append("                    ControlCue {");
        output.append("                      { 9.9, 0.001 }, // mTime MStart MDuration");
        output.append("                      3, // mCueID");
        output.append("                      \"\", // mName");
        output.append("                      false, // mNamedTarget");
        output.append("                      0, // mTarget");
        output.append("                      \"\", // mTargetName");
        output.append("                      false, // mStop");
        output.append("                      false, // mJump");
        output.append("                      false, // mToCue");
        output.append("                      false, // mReverse");
        output.append("                      false, // mRun");
        output.append("                      0.0, // mJumpTime");
        output.append("                      0.0, // mRestartDelay");
        output.append("                      \"\" // mJumpCue");
        output.append("                    },");
        output.append("                    ControlCue {");
        output.append("                      { 14.9, 0.001 }, // mTime MStart MDuration");
        output.append("                      5, // mCueID");
        output.append("                      \"\", // mName");
        output.append("                      false, // mNamedTarget");
        output.append("                      0, // mTarget");
        output.append("                      \"\", // mTargetName");
        output.append("                      false, // mStop");
        output.append("                      false, // mJump");
        output.append("                      false, // mToCue");
        output.append("                      false, // mReverse");
        output.append("                      false, // mRun");
        output.append("                      0.0, // mJumpTime");
        output.append("                      0.0, // mRestartDelay");
        output.append("                      \"\" // mJumpCue");
        output.append("                    },");
        output.append("                    ControlCue {");
        output.append("                      { 19.9, 0.001 }, // mTime MStart MDuration");
        output.append("                      7, // mCueID");
        output.append("                      \"\", // mName");
        output.append("                      false, // mNamedTarget");
        output.append("                      0, // mTarget");
        output.append("                      \"\", // mTargetName");
        output.append("                      false, // mStop");
        output.append("                      false, // mJump");
        output.append("                      false, // mToCue");
        output.append("                      false, // mReverse");
        output.append("                      false, // mRun");
        output.append("                      0.0, // mJumpTime");
        output.append("                      0.0, // mRestartDelay");
        output.append("                      \"\" // mJumpCue");
        output.append("                    }");
        output.append("                  },");
        output.append("                  false, // mExpanded");
        output.append("                  1, // mIndex");
        output.append("                  0, // mConditional");
        output.append("                  false, // mDisabled");
        output.append("                  0, // mStandBy");
        output.append("                  false, // mLocked");
        output.append("                  false, // mSpecLevels");
        output.append("                  1 // mLevels");
        output.append("                },");
        output.append("                {");
        output.append("                  \"Lineup\", // mName");
        output.append("                  { // mCues");
        output.append("                    MediaCue struct extends {");
        output.append("                      MediaCueBase struct extends {");
        output.append("                        TweeningCue struct extends {");
        output.append("                          Cue");
        output.append("                        } {");
        output.append("                        }");
        output.append("                      } {");
        output.append("                        mMedia reference Media true");
        output.append("                      }");
        output.append("                    } {");
        output.append("                      mPreroll time,");
        output.append("                      mParams list TweenParam true,");
        output.append("                      mPreviewQuality PreviewQuality enum {");
        output.append("                        kPQ_Best 0,");
        output.append("                        kPQ_Reduced 1,");
        output.append("                        kPQ_None 2");
        output.append("                      },");
        output.append("                      mInitialPos Point3D struct extends {");
        output.append("                        _pvs3DBase struct {");
        output.append("                          x float,");
        output.append("                          y float,");
        output.append("                          z float");
        output.append("                        }");
        output.append("                      } {");
        output.append("                      },");
        output.append("                      mOrientAlongPath bool,");
        output.append("                      mRenderAsMaskOnly bool,");
        output.append("                      mMask Masking enum {");
        output.append("                        kMM_None 0,");
        output.append("                        kMM_Alpha 1,");
        output.append("                        kMM_AlphaInv 2,");
        output.append("                        kMM_Luma 3,");
        output.append("                        kMM_LumaInv 4");
        output.append("                      },");
        output.append("                      mBlend Blending enum {");
        output.append("                        kBM_Normal 0,");
        output.append("                        kBM_Add 1,");
        output.append("                        kBM_Multiply 2,");
        output.append("                        kBM_Screen 3,");
        output.append("                        kBM_Lighten 4,");
        output.append("                        kBM_Darken 5,");
        output.append("                        kBM_Linear_Burn 6");
        output.append("                      },");
        output.append("                      mExplicitTarget bool,");
        output.append("                      mPlayThroughDisplay reference StageItem true,");
        output.append("                      mShader reference SCProxy false,");
        output.append("                      mStacking ZOrder enum {");
        output.append("                        kZO_Default 0,");
        output.append("                        kZO_ByLayer 1,");
        output.append("                        kZO_ByDepth 2");
        output.append("                      },");
        output.append("                      mOrientation FwdMotion enum {");
        output.append("                        kFM_XPlus 0,");
        output.append("                        kFM_XMinus 1,");
        output.append("                        kFM_YPlus 2,");
        output.append("                        kFM_YMinus 3,");
        output.append("                        kFM_ZPlus 4,");
        output.append("                        kFM_ZMinus 5");
        output.append("                      },");
        output.append("                      mLocalVanishingPoint bool,");
        output.append("                      mInteractive string,");
        output.append("                      mTrackingName string,");
        output.append("                      mExtTransform bool");
        output.append("                    } {");
        output.append("                      { 0.0, 5.0 }, // mTime MStart MDuration");
        output.append("                      1, // mCueID");
        output.append("                      #3, // mMedia");
        output.append("                      0.0, // mPreroll");
        output.append("                      { // mParams");
        output.append("                        AnchorTweenPointQuad struct extends {");
        output.append("                          _tweenPointQP struct extends {");
        output.append("                            _quadTweenPoint");
        output.append("                          } {");
        output.append("                            mValue Point3D");
        output.append("                          }");
        output.append("                        } {");
        output.append("                        } {");
        output.append("                          0, // mTimePos");
        output.append("                          false, // mSmooth");
        output.append("                          { 2496, 540, 0 } // mValue x y z");
        output.append("                        }");
        output.append("                      },");
        output.append("                      0, // mPreviewQuality");
        output.append("                      { 3496, 1540, 0 }, // mInitialPos x y z");
        output.append("                      false, // mOrientAlongPath");
        output.append("                      false, // mRenderAsMaskOnly");
        output.append("                      0, // mMask");
        output.append("                      0, // mBlend");
        output.append("                      false, // mExplicitTarget");
        output.append("                      #0, // mPlayThroughDisplay");
        output.append("                      #5 { // mShader");
        output.append("                        { \"Opac\", 1, 1667330127 } // mRecipe mIdentifiers mNumbIdentifiers mHash");
        output.append("                      },");
        output.append("                      0, // mStacking");
        output.append("                      0, // mOrientation");
        output.append("                      false, // mLocalVanishingPoint");
        output.append("                      \"\", // mInteractive");
        output.append("                      \"\", // mTrackingName");
        output.append("                      false // mExtTransform");
        output.append("                    },");
        output.append("                    MediaCue {");
        output.append("                      { 5.0, 5.0 }, // mTime MStart MDuration");
        output.append("                      4, // mCueID");
        output.append("                      #9, // mMedia");
        output.append("                      0.0, // mPreroll");
        output.append("                      { // mParams");
        output.append("                        AnchorTweenPointQuad {");
        output.append("                          0, // mTimePos");
        output.append("                          false, // mSmooth");
        output.append("                          { 2496, 540, 0 } // mValue x y z");
        output.append("                        }");
        output.append("                      },");
        output.append("                      0, // mPreviewQuality");
        output.append("                      { 3496, 1540, 0 }, // mInitialPos x y z");
        output.append("                      false, // mOrientAlongPath");
        output.append("                      false, // mRenderAsMaskOnly");
        output.append("                      0, // mMask");
        output.append("                      0, // mBlend");
        output.append("                      false, // mExplicitTarget");
        output.append("                      #0, // mPlayThroughDisplay");
        output.append("                      #5, // mShader");
        output.append("                      0, // mStacking");
        output.append("                      0, // mOrientation");
        output.append("                      false, // mLocalVanishingPoint");
        output.append("                      \"\", // mInteractive");
        output.append("                      \"\", // mTrackingName");
        output.append("                      false // mExtTransform");
        output.append("                    },");
        output.append("                    MediaCue {");
        output.append("                      { 10.0, 5.0 }, // mTime MStart MDuration");
        output.append("                      6, // mCueID");
        output.append("                      1, // mMedia");
        output.append("                      0.0, // mPreroll");
        output.append("                      { // mParams");
        output.append("                        AnchorTweenPointQuad {");
        output.append("                          0, // mTimePos");
        output.append("                          false, // mSmooth");
        output.append("                          { 0, 0, 0 } // mValue x y z");
        output.append("                        },");
        output.append("                        TweenPointTrack {");
        output.append("                          true, // mExpanded");
        output.append("                          0, // mHeight");
        output.append("                          { // mPoints");
        output.append("                            ScaleTweenPoint struct extends {");
        output.append("                              _tweenPointQP");
        output.append("                            } {");
        output.append("                            } {");
        output.append("                              0, // mTimePos");
        output.append("                              false, // mSmooth");
        output.append("                              { 2.6, 1, 0 } // mValue x y z");
        output.append("                            }");
        output.append("                          },");
        output.append("                          #0 // mExpr");
        output.append("                        }");
        output.append("                      },");
        output.append("                      0, // mPreviewQuality");
        output.append("                      { 1000, 1000, 0 }, // mInitialPos x y z");
        output.append("                      false, // mOrientAlongPath");
        output.append("                      false, // mRenderAsMaskOnly");
        output.append("                      0, // mMask");
        output.append("                      0, // mBlend");
        output.append("                      false, // mExplicitTarget");
        output.append("                      #0, // mPlayThroughDisplay");
        output.append("                      #5, // mShader");
        output.append("                      0, // mStacking");
        output.append("                      0, // mOrientation");
        output.append("                      false, // mLocalVanishingPoint");
        output.append("                      \"\", // mInteractive");
        output.append("                      \"\", // mTrackingName");
        output.append("                      false // mExtTransform");
        output.append("                    },");
        output.append("                    MediaCue {");
        output.append("                      { 15.0, 5.0 }, // mTime MStart MDuration");
        output.append("                      8, // mCueID");
        output.append("                      #6, // mMedia");
        output.append("                      0.0, // mPreroll");
        output.append("                      { // mParams");
        output.append("                        AnchorTweenPointQuad {");
        output.append("                          0, // mTimePos");
        output.append("                          false, // mSmooth");
        output.append("                          { 0, 0, 0 } // mValue x y z");
        output.append("                        },");
        output.append("                        TweenPointTrack {");
        output.append("                          true, // mExpanded");
        output.append("                          0, // mHeight");
        output.append("                          { // mPoints");
        output.append("                            ScaleTweenPoint {");
        output.append("                              0, // mTimePos");
        output.append("                              false, // mSmooth");
        output.append("                              { 2.6, 1, 0 } // mValue x y z");
        output.append("                            }");
        output.append("                          },");
        output.append("                          #0 // mExpr");
        output.append("                        }");
        output.append("                      },");
        output.append("                      0, // mPreviewQuality");
        output.append("                      { 1000, 1000, 0 }, // mInitialPos x y z");
        output.append("                      false, // mOrientAlongPath");
        output.append("                      false, // mRenderAsMaskOnly");
        output.append("                      0, // mMask");
        output.append("                      0, // mBlend");
        output.append("                      false, // mExplicitTarget");
        output.append("                      #0, // mPlayThroughDisplay");
        output.append("                      #5, // mShader");
        output.append("                      0, // mStacking");
        output.append("                      0, // mOrientation");
        output.append("                      false, // mLocalVanishingPoint");
        output.append("                      \"\", // mInteractive");
        output.append("                      \"\", // mTrackingName");
        output.append("                      false // mExtTransform");
        output.append("                    }");
        output.append("                  },");
        output.append("                  false, // mExpanded");
        output.append("                  2, // mIndex");
        output.append("                  0, // mConditional");
        output.append("                  false, // mDisabled");
        output.append("                  0, // mStandBy");
        output.append("                  false, // mLocked");
        output.append("                  false, // mSpecLevels");
        output.append("                  1 // mLevels");
        output.append("                },");
        output.append("                {");
        output.append("                  \"\", // mName");
        output.append("                  { // mCues");
        output.append("                  },");
        output.append("                  false, // mExpanded");
        output.append("                  3, // mIndex");
        output.append("                  0, // mConditional");
        output.append("                  false, // mDisabled");
        output.append("                  0, // mStandBy");
        output.append("                  false, // mLocked");
        output.append("                  false, // mSpecLevels");
        output.append("                  1 // mLevels");
        output.append("                }");
        output.append("              },");
        output.append("              2, // mCurrLayerIndex");
        output.append("              50, // mTimeScale");
        output.append("              30.0, // mDuration");
        output.append("              8, // mCueIDSeed");
        output.append("              true, // mFrontmostAtTop");
        output.append("              { 0, 169, 316, 700, 472, false, 314, 200, 0 }, // MWinState mState mLeft mTop mWidth mHeight mActive MSashPos MHdrWidth MVScrollPos");
        output.append("              false, // mFixedDuration");
        output.append("              false, // mSpecTiers");
        output.append("              0, // mTiers");
        output.append("              1 // mAlwaysOnTop");
        output.append("            }");
        output.append("          }");
        output.append("        }");
        output.append("      },");
        output.append("      { 2, 557, 223, 442, 210, false, // MWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
        output.append("        { 90, 90, 32767, 0, 0, 0, 0, 0 }");
        output.append("      }");
        output.append("    },");
        output.append("    { // mStatusList");
        output.append("      { // MItems");
        output.append("      },");
        output.append("      { 0, 0, 0, 0, 0, false, // MWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
        output.append("        { 0, 0, 0, 0, 0, 0, 0, 0 }");
        output.append("      }");
        output.append("    },");
        output.append("    { // mShaders");
        output.append("      { // mProxies");
        output.append("        #5");
        output.append("      }");
        output.append("    },");
        output.append("    { // mWinLayouts");
        i = 0;
        while (i < 10) {
            output.append("      {");
            output.append("        false, // mIsSet");
            output.append("        { 0, 0, 0, 0, 0, false, // mMediaWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
            output.append("          { 0, 0, 0, 0, 0, 0, 0, 0 }");
            output.append("        },");
            output.append("        { 0, 0, 0, 0, 0, false, // mVarWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
            output.append("          { 0, 0, 0, 0, 0, 0, 0, 0 }");
            output.append("        },");
            output.append("        { 0, 0, 0, 0, 0, false, // mOutputWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
            output.append("          { 0, 0, 0, 0, 0, 0, 0, 0 }");
            output.append("        },");
            output.append("        { 0, 0, 0, 0, 0, false, // mTaskListWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
            output.append("          { 0, 0, 0, 0, 0, 0, 0, 0 }");
            output.append("        },");
            output.append("        { 0, 0, 0, 0, 0, false, // mStatusListState mState mLeft mTop mWidth mHeight mActive MColWidth");
            output.append("          { 0, 0, 0, 0, 0, 0, 0, 0 }");
            output.append("        },");
            output.append("        { 0, 0, 0, 0, 0, false, 0, 0, false, 0 }, // mStageWinState mState mLeft mTop mWidth mHeight mActive XScroll YScroll DoViewStageList StageListWidth");
            output.append("        0, // mStageScale");
            output.append("        0, // mStageDefaultScale");
            output.append("        { 0, 0, 0, 0, 0, false, 0, 0, 0 }, // mTimeLineWinState mState mLeft mTop mWidth mHeight mActive MSashPos MHdrWidth MVScrollPos");
            output.append("        { // mWinStates");
            output.append("        },");
            output.append("        { // mTaskStates");
            output.append("        },");
            output.append("        { // mStageItemStates");
            output.append("        }");
            output.append("      },");
            ++i;
        }
        output.append("      {");
        output.append("        false, // mIsSet");
        output.append("        { 0, 0, 0, 0, 0, false, // mMediaWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
        output.append("          { 0, 0, 0, 0, 0, 0, 0, 0 }");
        output.append("        },");
        output.append("        { 0, 0, 0, 0, 0, false, // mVarWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
        output.append("          { 0, 0, 0, 0, 0, 0, 0, 0 }");
        output.append("        },");
        output.append("        { 0, 0, 0, 0, 0, false, // mOutputWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
        output.append("          { 0, 0, 0, 0, 0, 0, 0, 0 }");
        output.append("        },");
        output.append("        { 0, 0, 0, 0, 0, false, // mTaskListWinState mState mLeft mTop mWidth mHeight mActive MColWidth");
        output.append("          { 0, 0, 0, 0, 0, 0, 0, 0 }");
        output.append("        },");
        output.append("        { 0, 0, 0, 0, 0, false, // mStatusListState mState mLeft mTop mWidth mHeight mActive MColWidth");
        output.append("          { 0, 0, 0, 0, 0, 0, 0, 0 }");
        output.append("        },");
        output.append("        { 0, 0, 0, 0, 0, false, 0, 0, false, 0 }, // mStageWinState mState mLeft mTop mWidth mHeight mActive XScroll YScroll DoViewStageList StageListWidth");
        output.append("        0, // mStageScale");
        output.append("        0, // mStageDefaultScale");
        output.append("        { 0, 0, 0, 0, 0, false, 0, 0, 0 }, // mTimeLineWinState mState mLeft mTop mWidth mHeight mActive MSashPos MHdrWidth MVScrollPos");
        output.append("        { // mWinStates");
        output.append("        },");
        output.append("        { // mTaskStates");
        output.append("        },");
        output.append("        { // mStageItemStates");
        output.append("        }");
        output.append("      }");
        output.append("    }");
        output.append("  }");
        output.append("}");
        return output;
    }

    public void text_content_get_from_clipboard() {
        String clipboard_text_content = this.clipboard_contents_get();
        String[] clipboard_text_content_array = Display_Builder_4.splitTokens((String)clipboard_text_content, (String)"\r\n");
        this.text_file_type_check_and_import(clipboard_text_content_array);
    }

    public void text_file_load(String filepath) {
        String[] text_file_lines = this.text_file_load_from_path(filepath);
        this.text_file_type_check_and_import(text_file_lines);
    }

    public String[] text_file_load_from_path(String filepath) {
        String[] text_file_lines = this.loadStrings(filepath);
        return text_file_lines;
    }

    public void text_file_type_check_and_import(String[] text_file_lines) {
        block22: {
            block20: {
                String text_file_signature;
                this.debug_output("Parsing Text data. Found " + text_file_lines.length + " lines");
                String[] text_file_line_signature = text_file_lines[0].split(",");
                if (text_file_line_signature.length <= 0) break block20;
                switch (text_file_signature = text_file_line_signature[0].trim()) {
                    case "DATA": {
                        if (text_file_line_signature[2].equals("displaybuilder-xmap-script")) {
                            this.import_data_xmap(text_file_lines);
                            break;
                        }
                        this.debug_output("text_file_type_check = import failed: no valid GENERATOR tag found.");
                        break;
                    }
                    case "UTF8 DATATON_DFC_DATA_590925_620721_AUC069 {": {
                        this.debug_output("text_file_type_check = Found Watchout clipboard data.");
                        String[] watchout_signature_array = Display_Builder_4.splitTokens((String)text_file_lines[2]);
                        if (watchout_signature_array.length > 0 && watchout_signature_array[0].equals("\"WATCHMAKER\"") && this.is_integer(watchout_signature_array[1])) {
                            int watchout_version = PApplet.parseInt((String)watchout_signature_array[1]);
                            this.debug_output("Got clipboard data in format: Watchout " + watchout_version);
                            switch (watchout_version) {
                                case 6: {
                                    this.import_data_wo6(text_file_lines);
                                }
                            }
                            break;
                        }
                        break block22;
                    }
                    case "{": {
                        String[] json_array = Display_Builder_4.splitTokens((String)text_file_lines[1]);
                        if (json_array[0].equals("\"Displays\":")) {
                            this.debug_output("Got clipboard data in format: Watchout 7 json Display data.");
                        }
                        if (json_array[0].equals("\"Cues\":")) {
                            this.debug_output("Got clipboard data in format: Watchout 7 json Timeline cue data.");
                            break;
                        }
                        break block22;
                    }
                    default: {
                        this.ui.getClass();
                        this.ui.osd_message_display("Error: Failed to import data - no valid data format was detected.", 2);
                        break;
                    }
                }
                break block22;
            }
            this.ui.getClass();
            this.ui.osd_message_display("Error: Failed to import data - no data was detected.", 2);
        }
    }

    public void obj_file_load(String obj_filepath) {
        String[] obj_lines = this.loadStrings(obj_filepath);
        FloatList vertex_x_values = new FloatList();
        FloatList vertex_y_values = new FloatList();
        FloatList vertex_z_values = new FloatList();
        this.debug_output("Parsing OBJ data. Found " + obj_lines.length + " lines");
        int i = 0;
        while (i < obj_lines.length) {
            String[] vertex_line;
            if (obj_lines[i].substring(0, 2).equals("v ") && this.is_float((vertex_line = obj_lines[i].substring(2).split(" "))[0]) && this.is_float(vertex_line[1]) && this.is_float(vertex_line[2])) {
                vertex_x_values.append(Float.valueOf(vertex_line[0]).floatValue());
                vertex_y_values.append(Float.valueOf(vertex_line[1]).floatValue() * -1.0f);
                vertex_z_values.append(Float.valueOf(vertex_line[2]).floatValue());
            }
            ++i;
        }
        int vertex_count = vertex_x_values.size() + vertex_y_values.size();
        this.debug_output("Parsing OBJ data. Found " + vertex_count + " valid vertices.");
        if (vertex_x_values.size() >= 2 && vertex_y_values.size() >= 2) {
            this.ui.set_active(false);
            Float[] vertex_bounds = new Float[]{Float.valueOf(vertex_y_values.min()), Float.valueOf(vertex_x_values.max()), Float.valueOf(vertex_y_values.max()), Float.valueOf(vertex_x_values.min())};
            PVector obj_surface_dimensions = new PVector(Display_Builder_4.abs((float)(vertex_bounds[1].floatValue() - vertex_bounds[3].floatValue())), Display_Builder_4.abs((float)(vertex_bounds[0].floatValue() - vertex_bounds[2].floatValue())));
            if (obj_surface_dimensions.x > 0.0f && obj_surface_dimensions.y > 0.0f) {
                if (this.project.viewport_physical_scale == 0.0f) {
                    PVector display_footprint = this.project.current_displaygroup.display_footprint_get();
                    this.project.current_displaygroup.display_dimensions_physical.y = obj_surface_dimensions.y;
                    this.project.current_displaygroup.display_dimensions_physical.x = obj_surface_dimensions.y * this.project.current_displaygroup.display_aspect_ratio.floatValue();
                    this.project.viewport_physical_scale_calculate(display_footprint.y, obj_surface_dimensions.y);
                    this.project.current_displaygroup.physical_scale = this.project.viewport_physical_scale;
                    this.project.current_displaygroup.pixel_density_calculate();
                }
                int[] stage_bounds = new int[4];
                int i2 = 0;
                while (i2 < 4) {
                    stage_bounds[i2] = Display_Builder_4.round((float)this.physical_to_pixels(vertex_bounds[i2].floatValue()));
                    ++i2;
                }
                this.project.pref_target_surface_bounds = stage_bounds;
                this.project.getClass();
                this.project.pref_projection_surface_mode = 1;
                this.project.current_displaygroup.parent_displaygroup_set(-1);
                this.project.current_displaygroup.anchor_alignment_id_set(0.0f);
                this.project.current_displaygroup.parent_offset = new PVector((float)stage_bounds[3], (float)stage_bounds[0]);
                this.project.current_displaygroup.displays_fit_to_surface();
                i2 = 0;
                while (i2 < 4) {
                    this.project.guideline_add();
                    this.project.current_guide.parent_id_set(-1);
                    this.project.current_guide.position = new PVector((float)stage_bounds[i2], (float)stage_bounds[i2]);
                    this.project.current_guide.orientation_set(1 - Display_Builder_4.round((float)(i2 % 2)));
                    ++i2;
                }
                this.ui.set_active(true);
                this.ui.pan_surface_to_viewport_centre();
                this.ui_elements.update_display_dimensions();
                this.ui_elements.update_surface_dimensions();
                this.ui_elements.update_surface_physical_dimensions();
                String message = "Successfully imported OBJ surface with dimensions:";
                message = String.valueOf(message) + this.get_formatted_float_string(obj_surface_dimensions.x) + "x" + this.get_formatted_float_string(obj_surface_dimensions.y) + "m.";
                this.ui.getClass();
                this.ui.osd_message_display(message, 1);
            } else {
                this.ui.getClass();
                this.ui.osd_message_display("Error Loading OBJ file - At least one dimension of surface is zero.", 2);
            }
        } else {
            String string = "Error Loading OBJ file - Found only " + vertex_count + " vertices.";
            this.ui.getClass();
            this.ui.osd_message_display(string, 2);
        }
    }

    public void import_data_wo6(String[] text_file_lines) {
        this.debug_output("import_data_wo6 - attempting to parse text data");
        String text_line = "";
        String match_displaydevices_start = "^(\\s*)DisplayDeviceBase\\b(.*)$";
        String match_display_start = "^(\\s*)\\\"(.*)\\\"\\,\\s//\\smName$";
        String match_display_end = "^(\\s*)(\\d)\\s//\\smStereo$";
        String match_displaydevices_end = "^(\\s*)\\\"StageItem\\\"(.*)$";
        String[] string_match = new String[]{};
        Boolean displaydevice_section = false;
        int display_count = 0;
        int[] display_index_list = new int[]{};
        int i = 0;
        while (i < text_file_lines.length) {
            text_line = text_file_lines[i];
            if (!displaydevice_section.booleanValue() && (string_match = Display_Builder_4.match((String)text_line, (String)match_displaydevices_start)) != null) {
                displaydevice_section = true;
            }
            if (displaydevice_section.booleanValue()) {
                string_match = Display_Builder_4.match((String)text_line, (String)match_display_start);
                if (string_match != null) {
                    display_index_list = Display_Builder_4.append((int[])display_index_list, (int)i);
                    ++display_count;
                }
                string_match = Display_Builder_4.match((String)text_line, (String)match_display_end);
                string_match = Display_Builder_4.match((String)text_line, (String)match_displaydevices_end);
                if (string_match != null) {
                    displaydevice_section = false;
                    display_index_list = Display_Builder_4.append((int[])display_index_list, (int)i);
                }
            }
            ++i;
        }
        if (display_count > 0) {
            Display_Builder_4.println((String)("Found " + display_count + " displays:"));
            String tier_name = "Import: " + display_count + " Displays.";
            int stagetier_id = this.project.stage_tier_add(-1, tier_name);
            DisplayGroup new_displaygroup = this.project.displaygroup_add();
            new_displaygroup.group_name_set(tier_name);
            new_displaygroup.displays_overrides_active = true;
            new_displaygroup.stagetier_id_set(stagetier_id);
            int line_start = 0;
            int line_count = 0;
            int i2 = 0;
            while (i2 < display_count) {
                line_start = display_index_list[i2];
                line_count = display_index_list[i2 + 1] - line_start;
                Display_Builder_4.subset((String[])text_file_lines, (int)line_start, (int)line_count);
                ++i2;
            }
        } else {
            this.debug_output("Error parsing data - No Display devices found.");
            this.ui.getClass();
            this.ui.osd_message_display("Error parsing data - No Displays found in imported data.", 2);
        }
    }

    public void parse_display_data_wo6(String[] text_data_display, DisplayObject display) {
    }

    public void import_data_xmap(String[] text_file_lines) {
        ImportLayerData import_layer_data;
        ArrayList<ImportLayerData> import_maps = new ArrayList<ImportLayerData>();
        ArrayList<ImportLayerData> import_outputs = new ArrayList<ImportLayerData>();
        String xmap_document_name = "";
        int[] xmap_document_dimensions = new int[2];
        int map_count = 0;
        int output_count = 0;
        String[] text_file_line_split = new String[]{};
        int i = 0;
        while (i < text_file_lines.length) {
            block34: {
                block35: {
                    text_file_line_split = text_file_lines[i].split(",");
                    if (text_file_line_split.length <= 0) break block34;
                    if (!text_file_line_split[0].equals("DATA")) break block35;
                    switch (text_file_line_split[1]) {
                        case "DOCUMENT_NAME": {
                            xmap_document_name = this.sanitize_file_name(text_file_line_split[2]);
                            break;
                        }
                        case "DOCUMENT_DIMENSIONS": {
                            xmap_document_dimensions[0] = Integer.valueOf(text_file_line_split[2]);
                            xmap_document_dimensions[1] = Integer.valueOf(text_file_line_split[3]);
                            break;
                        }
                        case "DOCUMENT_FILEPATH": {
                            String cfr_ignored_0 = text_file_line_split[2];
                            break;
                        }
                        case "MAP_IMAGES_FILEPATH": {
                            String cfr_ignored_1 = text_file_line_split[2];
                            break;
                        }
                        case "MAP_COUNT": {
                            map_count = Integer.valueOf(text_file_line_split[2]);
                            break;
                        }
                        case "OUTPUT_COUNT": {
                            output_count = Integer.valueOf(text_file_line_split[2]);
                        }
                    }
                }
                if (text_file_line_split[0].equals("MAP")) {
                    import_layer_data = new ImportLayerData();
                    import_layer_data.id = Integer.valueOf(text_file_line_split[1]);
                    import_layer_data.type = 0;
                    import_layer_data.name = this.sanitize_file_name(text_file_line_split[2]);
                    import_layer_data.bounds_top = Float.valueOf(text_file_line_split[3]).floatValue();
                    import_layer_data.bounds_right = Float.valueOf(text_file_line_split[4]).floatValue();
                    import_layer_data.bounds_bottom = Float.valueOf(text_file_line_split[5]).floatValue();
                    import_layer_data.bounds_left = Float.valueOf(text_file_line_split[6]).floatValue();
                    import_maps.add(import_layer_data);
                }
                if (text_file_line_split[0].equals("OUTPUT")) {
                    import_layer_data = new ImportLayerData();
                    import_layer_data.id = Integer.valueOf(text_file_line_split[1]);
                    import_layer_data.type = 1;
                    import_layer_data.name = this.sanitize_file_name(text_file_line_split[2]);
                    import_layer_data.bounds_top = Float.valueOf(text_file_line_split[3]).floatValue();
                    import_layer_data.bounds_right = Float.valueOf(text_file_line_split[4]).floatValue();
                    import_layer_data.bounds_bottom = Float.valueOf(text_file_line_split[5]).floatValue();
                    import_layer_data.bounds_left = Float.valueOf(text_file_line_split[6]).floatValue();
                    import_outputs.add(import_layer_data);
                }
            }
            ++i;
        }
        this.debug_output("import_data_xmap creating " + map_count + " maps for file: " + xmap_document_name);
        if (map_count > 0 && import_maps.size() == map_count) {
            DisplayObject new_display;
            this.ui.active = false;
            PVector layer_centre = new PVector(0.0f, 0.0f);
            PVector layer_footprint = new PVector(0.0f, 0.0f);
            this.project.reset_project_lists();
            this.project.name_set(xmap_document_name);
            DisplayGroup displaygroup_maps = this.project.displaygroup_add();
            displaygroup_maps.group_active = false;
            displaygroup_maps.name = "MAPs Group";
            displaygroup_maps.group_display_type_set(this.project.DISPLAY_VIRTUAL);
            displaygroup_maps.displays_overrides_active = true;
            displaygroup_maps.player_start_number = 0;
            displaygroup_maps.softedge_dimensions = new PVector(0.0f, 0.0f);
            displaygroup_maps.player_name_prefix = "Virtual ";
            displaygroup_maps.display_cols = map_count;
            displaygroup_maps.display_rows = 1;
            displaygroup_maps.display_colour_mode = 3;
            displaygroup_maps.display_rotation = 0.0f;
            displaygroup_maps.display_aspect_ratio_locked = true;
            displaygroup_maps.projection_surface_bounds[0] = 0;
            displaygroup_maps.projection_surface_bounds[1] = xmap_document_dimensions[0] - 1;
            displaygroup_maps.projection_surface_bounds[2] = xmap_document_dimensions[1] - 1;
            displaygroup_maps.projection_surface_bounds[3] = 0;
            this.project.stage_tier_add(0, "MAP");
            displaygroup_maps.stagetier_id = 0;
            int i2 = 0;
            while (i2 < import_maps.size()) {
                import_layer_data = (ImportLayerData)import_maps.get(i2);
                Display_Builder_4.println((String)("Importing MAP layer " + i2 + ": " + import_layer_data.name));
                new_display = displaygroup_maps.display_add(true);
                new_display.parent_displaygroup_id = displaygroup_maps.id;
                new_display.display_id = this.get_id_from_number(import_layer_data.id);
                new_display.name = import_layer_data.name;
                new_display.name_override = true;
                new_display.row_id = 1;
                new_display.col_id = this.get_id_from_number(import_layer_data.id);
                new_display.rotation = 0.0f;
                new_display.player_number = 1;
                new_display.output_number = import_layer_data.id;
                new_display.position_override = true;
                new_display.rotation_override = true;
                new_display.info_overlay_show = true;
                layer_footprint.x = import_layer_data.bounds_right - import_layer_data.bounds_left;
                layer_footprint.y = import_layer_data.bounds_bottom - import_layer_data.bounds_top;
                new_display.stage_footprint = layer_footprint.copy();
                layer_centre.x = import_layer_data.bounds_left + layer_footprint.x / 2.0f;
                layer_centre.y = import_layer_data.bounds_top + layer_footprint.y / 2.0f;
                new_display.position = layer_centre.copy();
                new_display.stage_bounds[0] = Display_Builder_4.round((float)import_layer_data.bounds_top);
                new_display.stage_bounds[1] = Display_Builder_4.round((float)import_layer_data.bounds_right);
                new_display.stage_bounds[2] = Display_Builder_4.round((float)import_layer_data.bounds_bottom);
                new_display.stage_bounds[3] = Display_Builder_4.round((float)import_layer_data.bounds_left);
                new_display.text_size_id_calculate();
                ++i2;
            }
            displaygroup_maps.player_count_update();
            displaygroup_maps.group_active = true;
            displaygroup_maps.colour_palette_calculate();
            this.debug_output("import_data_xmap creating " + output_count + " outputs for file: " + xmap_document_name);
            if (output_count > 0 && import_outputs.size() == output_count) {
                DisplayGroup displaygroup_outputs = this.project.displaygroup_add();
                displaygroup_outputs.group_active = false;
                displaygroup_outputs.name = "OUTPUTs Group";
                displaygroup_outputs.parent_id_set(displaygroup_maps.id);
                this.project.getClass();
                displaygroup_outputs.group_display_type_set(0);
                displaygroup_outputs.displays_overrides_active = true;
                displaygroup_outputs.player_start_number = 1;
                displaygroup_outputs.player_outputs_count = 6;
                displaygroup_outputs.softedge_dimensions = new PVector(0.0f, 0.0f);
                displaygroup_outputs.player_name_prefix = "Player_";
                displaygroup_outputs.display_cols = output_count;
                displaygroup_outputs.display_rows = 1;
                displaygroup_outputs.display_colour_mode = 0;
                displaygroup_outputs.display_rotation = 0.0f;
                displaygroup_outputs.display_aspect_ratio_locked = true;
                displaygroup_outputs.projection_surface_bounds[0] = 0;
                displaygroup_outputs.projection_surface_bounds[1] = xmap_document_dimensions[0] - 1;
                displaygroup_outputs.projection_surface_bounds[2] = xmap_document_dimensions[1] - 1;
                displaygroup_outputs.projection_surface_bounds[3] = 0;
                this.project.stage_tier_add(1, "OUTPUT");
                displaygroup_outputs.stagetier_id = 1;
                int i3 = 0;
                while (i3 < import_outputs.size()) {
                    import_layer_data = (ImportLayerData)import_outputs.get(i3);
                    Display_Builder_4.println((String)("Importing OUTPUT layer " + i3 + ": " + import_layer_data.name));
                    new_display = displaygroup_outputs.display_add(true);
                    new_display.parent_displaygroup_id = displaygroup_outputs.id;
                    new_display.display_id = this.get_id_from_number(import_layer_data.id);
                    new_display.name = import_layer_data.name;
                    new_display.name_override = true;
                    new_display.row_id = 1;
                    new_display.col_id = this.get_id_from_number(import_layer_data.id);
                    new_display.player_number = 1;
                    new_display.output_number = import_layer_data.id;
                    new_display.position_override = true;
                    new_display.info_overlay_show = true;
                    layer_footprint.x = import_layer_data.bounds_right - import_layer_data.bounds_left;
                    layer_footprint.y = import_layer_data.bounds_bottom - import_layer_data.bounds_top;
                    new_display.stage_footprint = layer_footprint.copy();
                    if (layer_footprint.x > layer_footprint.y) {
                        new_display.rotation = 0.0f;
                    } else {
                        new_display.rotation = Display_Builder_4.radians((float)90.0f);
                        new_display.rotation_override = true;
                    }
                    if (i3 == 0) {
                        int res_width = Display_Builder_4.round((float)Display_Builder_4.max((float)layer_footprint.x, (float)layer_footprint.y));
                        int res_height = Display_Builder_4.round((float)Display_Builder_4.min((float)layer_footprint.x, (float)layer_footprint.y));
                        displaygroup_outputs.resolution_object_set_by_id(this.project.resolution_preset_add_custom(res_width, res_height));
                    }
                    layer_centre.x = import_layer_data.bounds_left + layer_footprint.x / 2.0f;
                    layer_centre.y = import_layer_data.bounds_top + layer_footprint.y / 2.0f;
                    new_display.position = layer_centre.copy();
                    new_display.stage_bounds[0] = Display_Builder_4.round((float)import_layer_data.bounds_top);
                    new_display.stage_bounds[1] = Display_Builder_4.round((float)import_layer_data.bounds_right);
                    new_display.stage_bounds[2] = Display_Builder_4.round((float)import_layer_data.bounds_bottom);
                    new_display.stage_bounds[3] = Display_Builder_4.round((float)import_layer_data.bounds_left);
                    new_display.text_size_id_calculate();
                    ++i3;
                }
                displaygroup_outputs.player_count_update();
                displaygroup_outputs.group_active = true;
            }
            this.project.process_project_file = false;
            this.ui.active = true;
            if (this.ui.ready.booleanValue()) {
                this.project.displaygroup_select(0);
                this.project.viewport_physical_scale = this.project.current_displaygroup.physical_scale;
                this.project.projection_surface_bounds_update();
                this.project.physical_grid.grid_scale_calculate();
                this.ui.pan_surface_to_viewport_centre();
                this.ui_elements.update_all_controls();
                String string = "Successfully imported XMAP data file with " + map_count + " MAPs and " + output_count + " OUTPUTs.";
                this.ui.getClass();
                this.ui.osd_message_display(string, 1);
            }
        } else {
            this.debug_output("import_data_xmap = import failed: No MAP data found.");
        }
    }

    public void load_internal_defaults() {
        this.debug_output("Loading internal defaults.");
        this.project.viewport_physical_scale = 0.0f;
        this.project.physical_settings_active = false;
        this.project.current_displaygroup.display_cols = 3;
        this.project.current_displaygroup.display_rows = 1;
        this.project.current_displaygroup.display_invert_cols_rows = false;
        this.project.current_displaygroup.display_basename = "Display_";
        this.project.current_displaygroup.display_resolution.x = 1920.0f;
        this.project.current_displaygroup.display_resolution.y = 1080.0f;
        this.project.current_displaygroup.display_rotation = 0.0f;
        this.project.current_displaygroup.player_outputs_count = 1;
        this.project.current_displaygroup.display_dimensions_physical.x = 0.0f;
        this.project.current_displaygroup.display_dimensions_physical.y = 0.0f;
        this.project.current_displaygroup.group_physical_dimensions_update("", "");
        this.project.current_displaygroup.anchor_alignment_id = 0;
        this.project.current_displaygroup.parent_offset.x = 1000.0f;
        this.project.current_displaygroup.parent_offset.y = 1000.0f;
        this.project.current_displaygroup.softedge_dimensions.x = this.softedge_to_pixels(this.project.current_displaygroup.display_resolution.x * this.project.default_softedge_fraction, Display_Builder_4.round((float)this.project.current_displaygroup.display_resolution.x));
        this.project.current_displaygroup.softedge_dimensions.y = 0.0f;
        this.project.current_displaygroup.projection_surface_bounds = new int[4];
        this.project.getClass();
        this.project.pref_projection_surface_mode = 0;
        this.project.current_displaygroup.projection_surface_bounds_calculate();
        this.project.pref_ui_toggle_show_layout_grid = true;
        this.project.pref_ui_grid_size_v = this.project.pref_ui_grid_size_h = 1000;
        this.project.physical_grid.visibility_set(false);
        this.project.physical_grid.alignment_id_set(0);
        this.ui.viewport_scale = 20.0f;
        this.ui.viewport.x = 0.0f;
        this.ui.viewport.y = 0.0f;
        if (this.ui.ready.booleanValue()) {
            this.ui_elements.update_all_controls();
        }
    }

    public void setup_resolutions_list() {
        XML xml_display_resolution_list = this.loadXML("display_resolutions.xml");
        if (xml_display_resolution_list == null) {
            Display_Builder_4.println((String)"Error loading Display Resolutions XML file.");
            String text_display_resolution_list = "<display_resolutions>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"LED1\" width_px=\"56\" height_px=\"112\" cols=\"2\" rows=\"4\" type=\"led_panel\" width_physical=\"0.5\" height_physical=\"1.0\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"Starway 2.6\" width_px=\"192\" height_px=\"192\" cols=\"2\" rows=\"2\" type=\"led_panel\" width_physical=\"0.5\" height_physical=\"0.5\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"Absen Lyra LST 3.9\" width_px=\"256\" height_px=\"128\" cols=\"4\" rows=\"2\" type=\"led_panel\" width_physical=\"1.0\" height_physical=\"0.5\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"Absen Polaris 3.9\" width_px=\"128\" height_px=\"256\" cols=\"2\" rows=\"4\" type=\"led_panel\" width_physical=\"0.5\" height_physical=\"1.0\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"VGA\" width_px=\"640\" height_px=\"480\" cols=\"8\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"PAL\" width_px=\"720\" height_px=\"576\" cols=\"8\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"PAL-Sq.\" width_px=\"768\" height_px=\"576\" cols=\"8\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"SVGA\" width_px=\"800\" height_px=\"600\" cols=\"8\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"SQUARE\" width_px=\"1000\" height_px=\"1000\" cols=\"4\" rows=\"4\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"XGA\" width_px=\"1024\" height_px=\"768\" cols=\"8\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"HD720\" width_px=\"1280\" height_px=\"720\" cols=\"12\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"WXGA\" width_px=\"1280\" height_px=\"768\" cols=\"10\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"WXG+A\" width_px=\"1280\" height_px=\"800\" cols=\"10\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"QVGA\" width_px=\"1280\" height_px=\"960\" cols=\"8\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"SXGA\" width_px=\"1280\" height_px=\"1024\" cols=\"8\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"SXGA+\" width_px=\"1400\" height_px=\"1050\" cols=\"8\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"UXGA\" width_px=\"1600\" height_px=\"1200\" cols=\"8\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"WSXGA+\" width_px=\"1680\" height_px=\"1080\" cols=\"10\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"HD1080\" width_px=\"1920\" height_px=\"1080\" cols=\"12\" rows=\"6\" default=\"true\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"WUXGA\" width_px=\"1920\" height_px=\"1200\" cols=\"10\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"2K\" width_px=\"2048\" height_px=\"1080\" cols=\"12\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"QXGA\" width_px=\"2048\" height_px=\"1536\" cols=\"8\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"WQHD\" width_px=\"2560\" height_px=\"1440\" cols=\"12\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"WQXGA\" width_px=\"2560\" height_px=\"1600\" cols=\"10\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"QSXGA\" width_px=\"2560\" height_px=\"2048\" cols=\"8\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"4K UHD\" width_px=\"3840\" height_px=\"2160\" cols=\"12\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"4K DCI\" width_px=\"4096\" height_px=\"2160\" cols=\"12\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "<resolution name=\"8K UHD\" width_px=\"7680\" height_px=\"4320\" cols=\"12\" rows=\"6\"></resolution>";
            text_display_resolution_list = String.valueOf(text_display_resolution_list) + "</display_resolutions>";
            xml_display_resolution_list = this.parseXML(text_display_resolution_list);
        }
        if (xml_display_resolution_list != null) {
            XML[] resolution_list = xml_display_resolution_list.getChildren("resolution");
            this.debug_output("Loading xml_display_resolution_list: found " + resolution_list.length + " resolutions.");
            this.project.resolutions_preset_count_initial = resolution_list.length;
            String res_name = "";
            int res_width = 0;
            int res_height = 0;
            int res_cols = 0;
            int res_rows = 0;
            int res_type = 0;
            String res_type_name = "";
            float res_width_physical = 0.0f;
            float res_height_physical = 0.0f;
            int i = 0;
            while (i < resolution_list.length) {
                res_name = resolution_list[i].getString("name", "");
                res_width = resolution_list[i].getInt("width_px", 0);
                res_height = resolution_list[i].getInt("height_px", 0);
                res_cols = resolution_list[i].getInt("cols", 0);
                res_rows = resolution_list[i].getInt("rows", 0);
                res_type = 0;
                res_type_name = resolution_list[i].getString("type", "");
                res_width_physical = resolution_list[i].getFloat("width_physical", 0.0f);
                res_height_physical = resolution_list[i].getFloat("height_physical", 0.0f);
                if (res_type_name != null && res_type_name.equals("led_panel")) {
                    res_type = 2;
                }
                if (!res_name.equals("") && res_width > 0 && res_height > 0) {
                    this.project.resolution_preset_add(res_name, res_width, res_height, res_cols, res_rows, res_type, res_width_physical, res_height_physical);
                    if (resolution_list[i].hasAttribute("default")) {
                        this.project.default_resolution_id = i;
                    }
                }
                ++i;
            }
        }
    }

    public void check_project_file(File project_filepath_input) {
        block13: {
            String file_extension;
            if (project_filepath_input == null) break block13;
            String filepath_project_file = project_filepath_input.getAbsolutePath();
            switch (file_extension = this.file_extension_get(filepath_project_file)) {
                case "obj": {
                    this.obj_file_load(filepath_project_file);
                    break;
                }
                case "xml": {
                    this.project.filepath_set(filepath_project_file);
                    this.project.process_project_file = true;
                    break;
                }
                case "txt": {
                    this.text_file_load(filepath_project_file);
                    break;
                }
                default: {
                    this.debug_output("Error: check_project_file Cannot load file with extension: " + file_extension);
                    String string = "Error: Cannot load file with extension: " + file_extension;
                    this.ui.getClass();
                    this.ui.osd_message_display(string, 2);
                }
            }
        }
    }

    public void load_project_file() {
        XML xml_project_file;
        Boolean loading_completed = false;
        String project_file_path = this.project.filepath_get();
        this.debug_output("\nload_project_file: " + project_file_path);
        int displaygroup_start_id = this.project.display_groups.size();
        this.ui.getClass();
        this.ui.osd_message_display("Loading Project file ...", 0);
        if (project_file_path.equals("default_project") || project_file_path.equals("")) {
            xml_project_file = this.loadXML("default_project.xml");
        } else {
            xml_project_file = this.loadXML(project_file_path);
            File file = new File(project_file_path);
            long file_mtime = file.lastModified();
            int file_mtime_trunc = PApplet.parseInt((float)(file_mtime / 1000L));
            long file_size_bytes = file.length();
            this.debug_output("Project file last modified time: " + file_mtime_trunc + " file size (bytes): " + file_size_bytes);
        }
        if (xml_project_file != null) {
            if (xml_project_file.hasAttribute("xml_version")) {
                this.debug_output("Loaded project file with XML version: " + xml_project_file.getString("xml_version"));
                this.debug_output("XML file has locale: " + xml_project_file.getString("locale"));
            }
            this.ui.active = false;
            if (this.project.project_load_overwrite.booleanValue()) {
                this.project.reset_project_lists();
                displaygroup_start_id = 0;
            }
            XML[] project_prefs = xml_project_file.getChild("project_preferences").getChildren("setting");
            this.debug_output("Loading project_prefs: found " + project_prefs.length + " settings.");
            if (project_prefs.length > 0) {
                int i = 0;
                while (i < project_prefs.length) {
                    this.project_file_load_preference(project_prefs[i]);
                    ++i;
                }
            } else {
                Display_Builder_4.println((String)"Error loading Project preferences.");
            }
            XML[] project_colours = xml_project_file.getChild("project_preferences").getChild("ui_colours").getChildren("colour");
            this.debug_output("Loading project_colours: found " + project_colours.length + " colours.");
            if (project_colours.length > 0) {
                int i = 0;
                while (i < project_colours.length) {
                    this.project_file_load_colour(project_colours[i]);
                    ++i;
                }
            } else {
                Display_Builder_4.println((String)"Error loading Project colours.");
            }
            if (xml_project_file.getChild("project_stage_tiers") != null) {
                XML[] project_stage_tiers = xml_project_file.getChild("project_stage_tiers").getChildren("tier");
                this.debug_output("Loading project stage tiers: found " + project_stage_tiers.length + " StageTiers.");
                if (project_stage_tiers.length > 0) {
                    this.project_file_load_stagetier(project_stage_tiers);
                } else {
                    Display_Builder_4.println((String)"Error loading Project stage tiers.");
                    this.project.stage_tier_add();
                }
            } else {
                Display_Builder_4.println((String)"Project contains no stage tiers - adding default tier.");
                this.project.stage_tier_add();
            }
            this.project.current_stage_tier = this.project.stage_tiers.get(0);
            XML[] project_display_groups = xml_project_file.getChild("project_displays").getChildren("display_group");
            this.debug_output("Loading project displays: found " + project_display_groups.length + " DisplayGroups.");
            if (project_display_groups.length > 0) {
                int i = 0;
                while (i < project_display_groups.length) {
                    this.project_file_load_displaygroup(project_display_groups[i], displaygroup_start_id);
                    ++i;
                }
            } else {
                Display_Builder_4.println((String)"Error loading Project display groups.");
            }
            if (xml_project_file.getChild("project_guides") != null) {
                XML[] project_guides = xml_project_file.getChild("project_guides").getChildren("guide");
                this.debug_output("Loading guides: found " + project_guides.length + " Guides.");
                if (project_guides.length > 0) {
                    int i = 0;
                    while (i < project_guides.length) {
                        this.project_file_load_guide(project_guides[i]);
                        ++i;
                    }
                } else {
                    Display_Builder_4.println((String)"Error loading guides.");
                }
            }
            loading_completed = true;
            this.ui.getClass();
            this.ui.osd_message_display("Successfully loaded project file.", 1);
        } else {
            this.debug_output("Error loading Project XML file.");
            this.ui.getClass();
            this.ui.osd_message_display("Error loading Project XML file.", 2);
            if (project_file_path.equals("default_project")) {
                this.load_internal_defaults();
                loading_completed = true;
            }
        }
        this.project.process_project_file = false;
        if (loading_completed.booleanValue()) {
            this.project.projection_surface_bounds_update();
            this.ui.active = true;
            this.test_pattern_colours_add();
            if (this.ui.ready.booleanValue()) {
                this.project.displaygroup_select(displaygroup_start_id);
                this.project.viewport_physical_scale = this.project.current_displaygroup.physical_scale;
                this.project.projection_surface_bounds_update();
                this.project.physical_grid.grid_scale_calculate();
                this.project.player_count_get_total();
                this.project.summary_text_update();
                this.ui.pan_surface_to_viewport_centre();
                this.ui_elements.update_all_controls();
            }
        }
    }

    public void project_file_load_guide(XML guide_data) {
        int guide_data_id = guide_data.getInt("id", -1);
        this.debug_output("Parsing Guide: " + guide_data_id);
        XML guide_properties = guide_data.getChild("guide_properties");
        if (guide_properties != null) {
            Guide new_guide;
            Boolean guide_locked = this.boolean_from_string(guide_properties.getString("locked", "false"));
            String guide_name = guide_properties.getString("name", "");
            Float guide_opacity = Float.valueOf(guide_properties.getFloat("opacity", 50.0f));
            Float guide_position_x = Float.valueOf(guide_properties.getFloat("position_x", 0.0f));
            Float guide_position_y = Float.valueOf(guide_properties.getFloat("position_y", 0.0f));
            PVector guide_position = new PVector(guide_position_x.floatValue(), guide_position_y.floatValue());
            Float guide_rotation = Float.valueOf(Display_Builder_4.radians((float)guide_properties.getFloat("rotation", 0.0f)));
            Float guide_scale = Float.valueOf(guide_properties.getFloat("scale", 1.0f));
            Boolean guide_visible = this.boolean_from_string(guide_properties.getString("visible"));
            int guide_parent_id = guide_properties.getInt("parent_id", -1);
            int guide_parent_alignment_id = guide_properties.getInt("parent_alignment_id", 4);
            int guide_data_type_id = guide_data.getInt("type_id", -1);
            if (guide_data_type_id == 0) {
                XML image_properties = guide_data.getChild("image_properties");
                if (image_properties != null) {
                    String image_filepath = image_properties.getString("image_filepath");
                    try {
                        File guide_image_file = new File(image_filepath);
                        if (guide_image_file != null) {
                            new_guide = (GuideImage)this.project.guides.get(this.project.guideimage_add(guide_image_file));
                            ((GuideImage)new_guide).locked = guide_locked;
                            ((GuideImage)new_guide).name = guide_name;
                            new_guide.opacity_set(guide_opacity.floatValue());
                            ((GuideImage)new_guide).parent_alignment_id = guide_parent_alignment_id;
                            new_guide.parent_id_set(guide_parent_id);
                            ((GuideImage)new_guide).position.x = guide_position_x.floatValue();
                            ((GuideImage)new_guide).position.y = guide_position_y.floatValue();
                            new_guide.rotation_set(guide_rotation.floatValue());
                            new_guide.scale_set(guide_scale.floatValue());
                            ((GuideImage)new_guide).visible = guide_visible;
                        }
                    }
                    catch (Exception exception) {
                        this.debug_output("Error while attempting to load guide image file " + image_filepath);
                        this.ui.getClass();
                        this.ui.osd_message_display("Error while attempting to load guide image file.", 2);
                    }
                } else {
                    this.debug_output("Error loading image properties for Guide-Image " + guide_data_id);
                }
            }
            if (guide_data_type_id == 1) {
                XML line_properties = guide_data.getChild("line_properties");
                if (line_properties != null) {
                    int line_orientation = line_properties.getInt("orientation", 0);
                    int line_colour = this.parse_colour_data(line_properties);
                    new_guide = (GuideLine)this.project.guides.get(this.project.guideline_add());
                    ((GuideLine)new_guide).colour_set(line_colour);
                    ((GuideLine)new_guide).orientation_set(line_orientation);
                    ((GuideLine)new_guide).locked = guide_locked;
                    ((GuideLine)new_guide).name = guide_name;
                    new_guide.opacity_set(guide_opacity.floatValue());
                    ((GuideLine)new_guide).parent_alignment_id = guide_parent_alignment_id;
                    new_guide.parent_id_set(guide_parent_id);
                    new_guide.position_set(guide_position);
                    new_guide.rotation_set(guide_rotation.floatValue());
                    new_guide.scale_set(guide_scale.floatValue());
                    ((GuideLine)new_guide).visible = guide_visible;
                } else {
                    this.debug_output("Error loading line properties for Guide-Line " + guide_data_id);
                }
            }
            if (guide_data_type_id == 2) {
                XML measure_properties = guide_data.getChild("measurement_properties");
                if (measure_properties != null) {
                    int line_colour = this.parse_colour_data(measure_properties);
                    Float guide_position_2_x = Float.valueOf(measure_properties.getFloat("position_2_x", 0.0f));
                    Float guide_position_2_y = Float.valueOf(measure_properties.getFloat("position_2_y", 0.0f));
                    GuideMeasure new_guide2 = (GuideMeasure)this.project.guides.get(this.project.guidemeasure_add());
                    new_guide2.colour_set(line_colour);
                    new_guide2.position_last.x = guide_position_2_x.floatValue();
                    new_guide2.position_last.y = guide_position_2_y.floatValue();
                    new_guide2.distance = Float.valueOf(this.ui.translate_calculate_distance(new_guide2.position, new_guide2.position_last));
                    new_guide2.locked = true;
                    new_guide2.name = guide_name;
                    new_guide2.opacity_set(guide_opacity.floatValue());
                    new_guide2.parent_alignment_id = guide_parent_alignment_id;
                    new_guide2.parent_id_set(guide_parent_id);
                    new_guide2.position_set(guide_position);
                    new_guide2.rotation_set(guide_rotation.floatValue());
                    new_guide2.scale_set(guide_scale.floatValue());
                    new_guide2.visible = guide_visible;
                } else {
                    this.debug_output("Error loading properties for Guide-Measure " + guide_data_id);
                }
            }
        } else {
            this.debug_output("Error loading properties for Guide " + guide_data_id);
        }
    }

    public void project_file_load_stagetier(XML[] stagetier_data) {
        int i = 0;
        while (i < stagetier_data.length) {
            XML tier_data = stagetier_data[i];
            int tier_data_id = tier_data.getInt("id", 0);
            String tier_data_name = tier_data.getString("name", "");
            this.project.stage_tier_add(tier_data_id, tier_data_name);
            ++i;
        }
    }

    public void project_file_load_displaygroup(XML displaygroup_data, int displaygroup_start_id) {
        DisplayGroup new_displaygroup = this.project.displaygroup_add();
        new_displaygroup.group_active_set(false);
        if (new_displaygroup.id >= 0) {
            XML[] group_displays;
            new_displaygroup.group_name_set(displaygroup_data.getString("name"));
            new_displaygroup.display_type = displaygroup_data.getInt("display_type");
            XML[] group_settings = displaygroup_data.getChild("group_settings").getChildren("setting");
            if (group_settings.length > 0) {
                int i = 0;
                while (i < group_settings.length) {
                    this.project_file_load_displaygroup_setting(group_settings[i], new_displaygroup);
                    ++i;
                }
            } else {
                this.debug_output("Error loading DisplayGroup settings for group " + new_displaygroup.name);
            }
            if (new_displaygroup.display_dimensions_physical.x > 0.0f) {
                new_displaygroup.group_physical_dimensions_update("", Display_Builder_4.nf((float)new_displaygroup.display_dimensions_physical.x, (int)0, (int)4));
            }
            if ((group_displays = displaygroup_data.getChild("group_displays").getChildren("display")).length > 0) {
                int i = 0;
                while (i < group_displays.length) {
                    this.project_file_load_displaygroup_display(group_displays[i], new_displaygroup);
                    if (i == 0) {
                        this.project.viewport_physical_scale_calculate(new_displaygroup.display_resolution.y, new_displaygroup.display_dimensions_physical.y);
                    }
                    ++i;
                }
                new_displaygroup.group_active_set(true);
                if (new_displaygroup.parent_group_id > -1) {
                    new_displaygroup.parent_displaygroup_set(displaygroup_start_id + new_displaygroup.parent_group_id);
                }
            } else {
                this.debug_output("Error loading DisplayGroup displays for group " + new_displaygroup.name);
            }
            this.project.displaygroup_select(new_displaygroup.id);
            new_displaygroup.anchor_point_calculate();
            new_displaygroup.displays_update();
            new_displaygroup.player_count_update();
            new_displaygroup.debug_info();
        } else {
            this.debug_output("Error getting current DisplayGroup reference.");
        }
    }

    public void project_file_load_displaygroup_setting(XML setting, DisplayGroup new_displaygroup) {
        String setting_name = setting.getString("id");
        if (!setting.getContent().equals("")) {
            Boolean show_43_marks;
            int origin_offset_y;
            int origin_offset_x;
            int origin_alignment_id;
            int parent_alignment_id;
            int parent_group_id;
            int stagetier_id;
            Float display_rotation;
            int colour_mode;
            int display_ip_start_address;
            Boolean displays_overrides_active;
            Boolean share_player_outputs;
            Boolean invert_cols_rows;
            int display_rows;
            int display_cols;
            if (setting_name.equals("display_cols") && (display_cols = setting.getIntContent(1)) >= 0 && display_cols <= this.project.max_array_size) {
                new_displaygroup.display_cols = display_cols;
            }
            if (setting_name.equals("display_rows") && (display_rows = setting.getIntContent(1)) >= 0 && display_rows <= this.project.max_array_size) {
                new_displaygroup.display_rows = display_rows;
            }
            if (setting_name.equals("display_invert_cols_rows") && (invert_cols_rows = this.boolean_from_string(setting.getContent())) != null) {
                new_displaygroup.display_invert_cols_rows = invert_cols_rows;
            }
            if (setting_name.equals("share_player_outputs") && (share_player_outputs = this.boolean_from_string(setting.getContent())) != null) {
                new_displaygroup.player_outputs_sharing = share_player_outputs;
            }
            if (setting_name.equals("displays_overrides_active") && (displays_overrides_active = this.boolean_from_string(setting.getContent())) != null) {
                new_displaygroup.displays_overrides_active = displays_overrides_active;
            }
            if (setting_name.equals("display_colour_mode")) {
                new_displaygroup.display_colour_mode = setting.getIntContent(0);
            }
            if (setting_name.equals("display_basename")) {
                new_displaygroup.display_basename = setting.getContent();
            }
            if (setting_name.equals("display_baseip")) {
                new_displaygroup.player_name_prefix = setting.getContent();
            }
            if (setting_name.equals("display_ip_start_address") && (display_ip_start_address = setting.getIntContent(1)) >= 0 && display_ip_start_address <= 255) {
                new_displaygroup.player_start_number = display_ip_start_address;
            }
            if (setting_name.equals("multi_output_count")) {
                int output_count = setting.getIntContent(1);
                new_displaygroup.player_outputs_count = output_count = Display_Builder_4.min((int)output_count, (int)6);
            }
            if (setting_name.equals("group_outline_colour")) {
                new_displaygroup.colour_set(this.parse_colour_data(setting));
            }
            if (setting_name.equals("display_colour_mode") && (colour_mode = setting.getIntContent(0)) >= 0 && colour_mode <= 3) {
                new_displaygroup.display_colour_mode = colour_mode;
            }
            if (setting_name.equals("display_rotation") && (display_rotation = Float.valueOf(setting.getFloatContent(1.0f))).floatValue() % 90.0f == 0.0f && display_rotation.floatValue() < 360.0f) {
                new_displaygroup.display_rotation = Display_Builder_4.radians((float)display_rotation.floatValue());
            }
            if (setting_name.equals("display_resolution")) {
                if (this.project.resolutions_lookup.hasKey(setting.getContent())) {
                    new_displaygroup.resolution_set_by_id(this.project.resolutions_lookup.get(setting.getContent()));
                } else {
                    Display_Builder_4.println((String)"Attempting to load a custom resolution.");
                    if (setting.getInt("width_px", 0) > 0) {
                        new_displaygroup.display_resolution.x = setting.getInt("width_px");
                    }
                    if (setting.getInt("height_px", 0) > 0) {
                        new_displaygroup.display_resolution.y = setting.getInt("height_px");
                    }
                    int resolution_id = this.project.resolution_preset_add_custom(Display_Builder_4.round((float)new_displaygroup.display_resolution.x), Display_Builder_4.round((float)new_displaygroup.display_resolution.y));
                    new_displaygroup.resolution_set_by_id(resolution_id);
                }
                String width_physical_string = setting.getString("width_physical");
                Float width_physical_float = Float.valueOf(0.0f);
                if (this.is_float(width_physical_string)) {
                    width_physical_float = Float.valueOf(PApplet.parseFloat((String)width_physical_string));
                } else {
                    String converted_string = this.locale_float_convert(width_physical_string);
                    if (this.is_float(converted_string)) {
                        width_physical_float = Float.valueOf(PApplet.parseFloat((String)converted_string));
                    }
                }
                new_displaygroup.display_dimensions_physical.x = Display_Builder_4.abs((float)width_physical_float.floatValue());
                String height_physical_string = setting.getString("height_physical");
                Float height_physical_float = Float.valueOf(0.0f);
                if (this.is_float(height_physical_string)) {
                    height_physical_float = Float.valueOf(PApplet.parseFloat((String)height_physical_string));
                } else {
                    String converted_string = this.locale_float_convert(height_physical_string);
                    if (this.is_float(converted_string)) {
                        height_physical_float = Float.valueOf(PApplet.parseFloat((String)converted_string));
                    }
                }
                new_displaygroup.display_dimensions_physical.y = Display_Builder_4.abs((float)height_physical_float.floatValue());
                String scale_string = setting.getString("stage_scale");
                Float scale_float = Float.valueOf(0.0f);
                if (this.is_float(scale_string)) {
                    scale_float = Float.valueOf(PApplet.parseFloat((String)scale_string));
                } else {
                    String converted_string = this.locale_float_convert(scale_string);
                    if (this.is_float(converted_string)) {
                        scale_float = Float.valueOf(PApplet.parseFloat((String)converted_string));
                    }
                }
                new_displaygroup.stage_scale = Display_Builder_4.abs((float)scale_float.floatValue());
            }
            if (setting_name.equals("stagetier_id") && (stagetier_id = setting.getIntContent(0)) < this.project.stage_tiers.size()) {
                new_displaygroup.stagetier_id_set(stagetier_id);
            }
            if (setting_name.equals("parent_group_id") && (parent_group_id = setting.getIntContent(-1)) > -1) {
                this.debug_output("Display parent_group_id: " + parent_group_id + " set for DisplayGroup: " + new_displaygroup.id);
                new_displaygroup.parent_group_id = parent_group_id;
            }
            if (setting_name.equals("parent_alignment_id") && (parent_alignment_id = setting.getIntContent(0)) > 0) {
                this.debug_output("Display parent_alignment_id: " + parent_alignment_id + " set for DisplayGroup: " + new_displaygroup.id);
                new_displaygroup.parent_alignment_id = parent_alignment_id;
            }
            if (setting_name.equals("origin_alignment_id") && (origin_alignment_id = setting.getIntContent(0)) > 0) {
                this.debug_output("Display origin_alignment_id: " + origin_alignment_id + " set for DisplayGroup: " + new_displaygroup.id);
                new_displaygroup.anchor_alignment_id = origin_alignment_id;
            }
            if (setting_name.equals("origin_offset_x") && (origin_offset_x = setting.getIntContent(0)) != 0) {
                this.debug_output("Display origin_offset_x: " + origin_offset_x + " set for DisplayGroup: " + new_displaygroup.id);
                new_displaygroup.parent_offset.x = origin_offset_x;
            }
            if (setting_name.equals("origin_offset_y") && (origin_offset_y = setting.getIntContent(0)) != 0) {
                this.debug_output("Display origin_offset_y: " + origin_offset_y + " set for DisplayGroup: " + new_displaygroup.id);
                new_displaygroup.parent_offset.y = origin_offset_y;
            }
            if (setting_name.equals("softedge_h_px")) {
                int softedge_h_px = setting.getIntContent(0);
                new_displaygroup.softedge_dimensions.x = softedge_h_px;
            }
            if (setting_name.equals("softedge_v_px")) {
                int softedge_v_px = setting.getIntContent(0);
                new_displaygroup.softedge_dimensions.y = softedge_v_px;
            }
            if (setting_name.equals("display_show_43_marks") && (show_43_marks = this.boolean_from_string(setting.getContent())) != null) {
                new_displaygroup.display_show_43_marks = show_43_marks;
            }
        } else {
            this.debug_output("Empty XML value for DisplayGroup setting: " + setting_name);
        }
    }

    public void project_file_load_displaygroup_display(XML display_data, DisplayGroup new_displaygroup) {
        XML display_layout = display_data.getChild("layout");
        XML display_position = display_data.getChild("position");
        XML display_rotation = display_data.getChild("rotation");
        XML display_colour = display_data.getChild("colour");
        DisplayObject new_display = new_displaygroup.display_add(false);
        new_display.parent_displaygroup_set(new_displaygroup.id);
        if (display_data.getString("override") != null) {
            Boolean display_name_override;
            new_display.name_override = display_name_override = this.boolean_from_string(display_data.getString("override"));
            if (display_name_override.booleanValue()) {
                new_display.name = display_data.getString("name");
            }
        }
        new_display.rowcol_ids_set(display_layout.getInt("r"), display_layout.getInt("c"));
        new_display.output_number_set(display_layout.getInt("output_id"));
        Float rotation_value = Float.valueOf(0.0f);
        if (display_rotation != null) {
            if (display_rotation.getString("override") != null) {
                new_display.rotation_override = this.boolean_from_string(display_rotation.getString("override"));
            }
            rotation_value = Float.valueOf(Display_Builder_4.radians((float)display_rotation.getFloatContent(0.0f)));
            new_display.rotation = rotation_value.floatValue();
        }
        if (rotation_value.floatValue() == 0.0f || rotation_value.floatValue() == (float)Math.PI) {
            new_display.footprint_set(display_position.getInt("width"), display_position.getInt("height"));
        } else {
            new_display.footprint_set(display_position.getInt("height"), display_position.getInt("width"));
        }
        new_display.position_set(display_position.getFloat("centre_x"), display_position.getFloat("centre_y"));
        if (display_position.getString("override") != null) {
            new_display.position_override = this.boolean_from_string(display_position.getString("override"));
        }
        new_display.outline_colour_set(this.parse_colour_data(display_colour));
    }

    public int parse_colour_data(XML colour_data) {
        int colour_r = 255;
        int colour_g = 102;
        int colour_b = 0;
        int colour_a = 128;
        if (colour_data.getInt("r", 0) >= 0) {
            colour_r = colour_data.getInt("r");
        }
        if (colour_data.getInt("g", 0) >= 0) {
            colour_g = colour_data.getInt("g");
        }
        if (colour_data.getInt("b", 0) >= 0) {
            colour_b = colour_data.getInt("b");
        }
        if (colour_data.getInt("a", 0) >= 0) {
            colour_a = colour_data.getInt("a");
        }
        int new_colour = this.color(colour_r, colour_g, colour_b, colour_a);
        return new_colour;
    }

    public void project_file_load_preference(XML preference) {
        String pref_name = preference.getString("id");
        if (!preference.getContent().equals("")) {
            Boolean export_show_softedge_text;
            Boolean export_show_info_overlay;
            Boolean export_show_displaygroup_name;
            Boolean export_show_displaygroup_id;
            Boolean export_show_display_id;
            Boolean export_show_display_coordinates;
            Boolean export_show_column_row_numbers;
            Boolean export_grid_show_markers;
            Boolean export_invert_grid_colour;
            Boolean export_grid_show_alignment;
            Boolean export_grid_use_grid_colour;
            Boolean export_grid_use_display_colours;
            Boolean export_grid_crosshatch_show;
            Boolean export_colourbars;
            Boolean export_warping_grid;
            Boolean export_physical_grid;
            Boolean export_pixel_grid;
            Boolean export_display_data;
            Boolean ui_show_parent_links_overlay;
            Boolean ui_show_display_spacing;
            Boolean ui_show_mouse_coords_overlay;
            Boolean ui_toggle_show_physical_grid;
            int ui_physical_grid_alignment;
            int ui_grid_size_v;
            int ui_grid_size_h;
            Boolean ui_toggle_show_layout_grid;
            Boolean ui_show_display_info_crop;
            Boolean ui_show_display_info;
            Boolean show_current_group_only;
            Boolean ui_scale_auto;
            Boolean resolution_list_order_invert;
            if (pref_name.equals("resolution_list_order_invert") && (resolution_list_order_invert = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_resolution_list_order_invert = resolution_list_order_invert;
            }
            if (pref_name.equals("projection_surface_mode")) {
                if (preference.getContent().equals("automatic")) {
                    this.project.getClass();
                    this.project.pref_projection_surface_mode = 0;
                }
                if (preference.getContent().equals("fixed")) {
                    this.project.getClass();
                    this.project.pref_projection_surface_mode = 1;
                }
            }
            if (pref_name.equals("ui_display_scale")) {
                this.ui.viewport_scale = preference.getIntContent(20);
            }
            if (pref_name.equals("ui_scale_auto") && (ui_scale_auto = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_ui_scale_auto = ui_scale_auto;
            }
            if (pref_name.equals("ui_show_current_group_only") && (show_current_group_only = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_ui_show_current_group_only = show_current_group_only;
            }
            if (pref_name.equals("pref_ui_show_display_info") && (ui_show_display_info = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_ui_show_display_info = ui_show_display_info;
            }
            if (pref_name.equals("ui_show_display_info_crop") && (ui_show_display_info_crop = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_ui_show_display_info_crop = ui_show_display_info_crop;
            }
            if (pref_name.equals("ui_toggle_show_layout_grid") && (ui_toggle_show_layout_grid = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_ui_toggle_show_layout_grid = ui_toggle_show_layout_grid;
            }
            if (pref_name.equals("ui_grid_size_h") && (ui_grid_size_h = preference.getIntContent(0)) > 0) {
                this.project.pref_ui_grid_size_h = ui_grid_size_h;
            }
            if (pref_name.equals("ui_grid_size_v") && (ui_grid_size_v = preference.getIntContent(0)) > 0) {
                this.project.pref_ui_grid_size_v = ui_grid_size_v;
            }
            if (pref_name.equals("ui_physical_grid_alignment") && (ui_physical_grid_alignment = preference.getIntContent(0)) >= 0) {
                this.project.physical_grid.alignment_id_set(ui_physical_grid_alignment);
            }
            if (pref_name.equals("ui_physical_grid_offset_x") && this.is_float(preference.getContent())) {
                this.project.physical_grid.origin_offset_set("x", PApplet.parseFloat((String)preference.getContent()));
            }
            if (pref_name.equals("ui_physical_grid_offset_y") && this.is_float(preference.getContent())) {
                this.project.physical_grid.origin_offset_set("y", PApplet.parseFloat((String)preference.getContent()));
            }
            if (pref_name.equals("ui_toggle_show_physical_grid") && (ui_toggle_show_physical_grid = this.boolean_from_string(preference.getContent())) != null) {
                this.project.physical_grid.visible = ui_toggle_show_physical_grid;
            }
            if (pref_name.equals("ui_show_mouse_coords_overlay") && (ui_show_mouse_coords_overlay = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_ui_show_mouse_coords_overlay = ui_show_mouse_coords_overlay;
            }
            if (pref_name.equals("ui_show_display_spacing") && (ui_show_display_spacing = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_ui_show_overlay_display_spacing = ui_show_display_spacing;
            }
            if (pref_name.equals("ui_show_parent_links_overlay") && (ui_show_parent_links_overlay = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_ui_show_parent_links = ui_show_parent_links_overlay;
            }
            if (pref_name.equals("export_format")) {
                int export_format = preference.getIntContent(3);
                this.export_manager.export_format_select(export_format);
            }
            if (pref_name.equals("export_filepath")) {
                this.export_manager.export_folder_filepath = preference.getContent();
            }
            if (pref_name.equals("export_filename_base")) {
                this.project.pref_project_name = preference.getContent();
            }
            if (pref_name.equals("export_display_data") && (export_display_data = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_display_data = export_display_data;
            }
            if (pref_name.equals("export_pixel_grid") && (export_pixel_grid = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_pixel_grid = export_pixel_grid;
            }
            if (pref_name.equals("export_physical_grid") && (export_physical_grid = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_physical_grid = export_physical_grid;
            }
            if (pref_name.equals("export_warping_grid") && (export_warping_grid = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_warping_grid = export_warping_grid;
            }
            if ((pref_name.equals("export_colourbars") || pref_name.equals("export_colourbars_709")) && (export_colourbars = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_colourbars = export_colourbars;
            }
            if (pref_name.equals("export_grid_crosshatch_show") && (export_grid_crosshatch_show = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_grid_crosshatch_show = export_grid_crosshatch_show;
            }
            if (pref_name.equals("export_grid_cell_unit")) {
                this.project.pref_export_grid_cell_unit = preference.getIntContent(1);
            }
            if (pref_name.equals("export_grid_cell_size")) {
                this.project.pref_export_grid_cell_size = preference.getIntContent(50);
            }
            if (pref_name.equals("export_grid_marker_interval")) {
                this.project.pref_export_grid_marker_interval = preference.getIntContent(1000);
            }
            if (pref_name.equals("export_grid_use_display_colours") && (export_grid_use_display_colours = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_grid_use_display_colours = export_grid_use_display_colours;
            }
            if (pref_name.equals("export_grid_use_grid_colour") && (export_grid_use_grid_colour = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_grid_use_grid_colour = export_grid_use_grid_colour;
            }
            if (pref_name.equals("export_grid_show_alignment") && (export_grid_show_alignment = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_grid_show_alignment = export_grid_show_alignment;
            }
            if (pref_name.equals("export_invert_grid_colour") && (export_invert_grid_colour = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_grid_invert_colour = export_invert_grid_colour;
            }
            if (pref_name.equals("export_grid_show_markers") && (export_grid_show_markers = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_grid_show_markers = export_grid_show_markers;
            }
            if (pref_name.equals("export_show_column_row_numbers") && (export_show_column_row_numbers = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_show_column_row_numbers = export_show_column_row_numbers;
            }
            if (pref_name.equals("export_show_display_coordinates") && (export_show_display_coordinates = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_show_display_coordinates = export_show_display_coordinates;
            }
            if (pref_name.equals("export_show_display_id") && (export_show_display_id = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_show_display_id = export_show_display_id;
            }
            if (pref_name.equals("export_show_displaygroup_id") && (export_show_displaygroup_id = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_show_displaygroup_id = export_show_displaygroup_id;
            }
            if (pref_name.equals("export_show_displaygroup_name") && (export_show_displaygroup_name = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_show_displaygroup_name = export_show_displaygroup_name;
            }
            if (pref_name.equals("export_show_info_overlay") && (export_show_info_overlay = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_show_info_overlay = export_show_info_overlay;
            }
            if (pref_name.equals("export_show_softedge_text") && (export_show_softedge_text = this.boolean_from_string(preference.getContent())) != null) {
                this.project.pref_export_show_softedge_text = export_show_softedge_text;
            }
        }
    }

    public void project_file_load_colour(XML colour_data) {
        String colour_id = colour_data.getString("id");
        int r = colour_data.getInt("r", -1);
        int g = colour_data.getInt("g", -1);
        int b = colour_data.getInt("b", -1);
        int a = colour_data.getInt("a", 255);
        if (r >= 0 && g >= 0 && b >= 0 && a >= 0) {
            this.ui.colours.set(colour_id, this.color(r, g, b, a));
        }
        this.ui.colours.set("ui_element_enabled", this.color(0, 180, 0, 255));
        this.ui.colours.set("ui_element_disabled", this.color(150, 50, 50, 255));
    }

    public void project_save_folder_selected(File selection) {
        if (selection == null) {
            this.debug_output("Project save window was closed or the user hit cancel.");
        } else {
            String project_filepath_folder = String.valueOf(selection.getAbsolutePath()) + "/";
            this.debug_output("User selected folder: " + project_filepath_folder);
            this.save_project_file(project_filepath_folder);
        }
    }

    public void save_project_file(String project_filepath_folder) {
        this.ui.getClass();
        this.ui.osd_message_display("Saving project file...", 0);
        XML xml_project = new XML("display_builder_project");
        xml_project.setString("xml_version", this.xml_version);
        xml_project.setString("app_version", this.app_version);
        xml_project.setString("generated_yyyy_mm_dd", this.get_current_date_string());
        xml_project.setString("name", this.project.pref_project_name);
        xml_project.setString("locale", this.app_locale.toLanguageTag());
        XML xml_project_stagetiers = xml_project.addChild("project_stage_tiers");
        for (StageTier tier : this.project.stage_tiers) {
            tier.generate_project_xml(xml_project_stagetiers);
        }
        XML xml_project_displays = xml_project.addChild("project_displays");
        for (DisplayGroup group : this.project.display_groups) {
            xml_project_displays.addChild(this.generate_displaygroup_xml(group));
        }
        if (this.project.guides.size() > 0) {
            XML xml_project_guides = xml_project.addChild("project_guides");
            for (Guide guide : this.project.guides) {
                guide.generate_project_xml(xml_project_guides);
            }
        }
        xml_project.addChild(this.generate_project_xml());
        String project_filename_temp = String.valueOf(this.project.pref_project_name) + " " + this.get_current_date_string();
        String project_filename = String.valueOf(this.sanitize_file_name(project_filename_temp)) + "-displaybuilder.xml";
        String project_filepath = String.valueOf(project_filepath_folder) + project_filename;
        this.debug_output("Saving project file to: " + project_filepath);
        this.saveXML(xml_project, project_filepath);
        this.ui.getClass();
        this.ui.osd_message_display("Project file saved.", 1);
    }

    public XML generate_display_xml(DisplayObject display) {
        XML xml_display = new XML("display");
        xml_display.setInt("id", display.display_id);
        xml_display.setString("name", display.name);
        xml_display.setString("override", this.boolean_to_string(display.name_override));
        xml_display.setInt("ip", display.player_number);
        XML xml_layout = xml_display.addChild("layout");
        xml_layout.setInt("output_id", display.output_number);
        xml_layout.setInt("col", display.col_id);
        xml_layout.setInt("row", display.row_id);
        XML xml_position = xml_display.addChild("position");
        xml_position.setString("override", this.boolean_to_string(display.position_override));
        if (display.parent_displaygroup.display_type == this.project.DISPLAY_VIRTUAL) {
            xml_position.setInt("width", Display_Builder_4.round((float)display.stage_footprint.x));
            xml_position.setInt("height", Display_Builder_4.round((float)display.stage_footprint.y));
        } else {
            xml_position.setInt("width", Display_Builder_4.round((float)display.parent_displaygroup.resolution.pixel_count.x));
            xml_position.setInt("height", Display_Builder_4.round((float)display.parent_displaygroup.resolution.pixel_count.y));
        }
        xml_position.setFloat("centre_x", display.position.x);
        xml_position.setFloat("centre_y", display.position.y);
        XML xml_rotation = xml_display.addChild("rotation");
        xml_rotation.setString("override", this.boolean_to_string(display.rotation_override));
        xml_rotation.setString("id", "display_rotation");
        xml_rotation.setString("type", "float");
        xml_rotation.setString("description", "Rotation - Degrees clockwise");
        xml_rotation.setContent(Float.toString(Display_Builder_4.degrees((float)display.rotation)));
        XML xml_colour = xml_display.addChild("colour");
        int[] rgba_color_values = this.get_color_rgb_values(display.outline_colour);
        xml_colour.setInt("r", rgba_color_values[0]);
        xml_colour.setInt("g", rgba_color_values[1]);
        xml_colour.setInt("b", rgba_color_values[2]);
        xml_colour.setInt("a", rgba_color_values[3]);
        return xml_display;
    }

    public XML generate_displaygroup_xml(DisplayGroup displaygroup) {
        XML xml_displaygroup = new XML("display_group");
        xml_displaygroup.setInt("id", displaygroup.id);
        xml_displaygroup.setString("name", displaygroup.name);
        xml_displaygroup.setInt("display_type", displaygroup.display_type);
        XML xml_group_settings = xml_displaygroup.addChild("group_settings");
        XML xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "display_cols");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Display columns");
        xml_setting.setContent(Integer.toString(displaygroup.display_cols));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "display_rows");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Display rows");
        xml_setting.setContent(Integer.toString(displaygroup.display_rows));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "display_invert_cols_rows");
        xml_setting.setString("type", "boolean");
        xml_setting.setString("description", "Toggle Col-Row layout order for displays");
        xml_setting.setContent(this.boolean_to_string(displaygroup.display_invert_cols_rows));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "share_player_outputs");
        xml_setting.setString("type", "boolean");
        xml_setting.setString("description", "Share free player outputs between Groups");
        xml_setting.setContent(this.boolean_to_string(displaygroup.player_outputs_sharing));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "display_basename");
        xml_setting.setString("type", "string");
        xml_setting.setString("description", "Display name prefix");
        xml_setting.setContent(displaygroup.display_basename);
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "display_baseip");
        xml_setting.setString("type", "string");
        xml_setting.setString("description", "Computer name prefix or base I.P. address");
        xml_setting.setContent(displaygroup.player_name_prefix);
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "display_ip_start_address");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Starting address for last octet of Display I.P. address");
        xml_setting.setContent(Integer.toString(displaygroup.player_start_number));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "multi_output_count");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Number of outputs per player");
        xml_setting.setContent(Integer.toString(displaygroup.player_outputs_count));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "group_outline_colour");
        xml_setting.setString("type", "integer");
        int[] rgba_color_values = this.get_color_rgb_values(displaygroup.outline_colour);
        xml_setting.setInt("r", rgba_color_values[0]);
        xml_setting.setInt("g", rgba_color_values[1]);
        xml_setting.setInt("b", rgba_color_values[2]);
        xml_setting.setInt("a", rgba_color_values[3]);
        xml_setting.setString("description", "Outline colour for Display Group");
        xml_setting.setContent("rgba colour");
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "display_colour_mode");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Colour preference for Display outlines");
        xml_setting.setContent(Integer.toString(displaygroup.display_colour_mode));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "display_rotation");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Display rotation - Degrees clockwise");
        xml_setting.setContent(Float.toString(Display_Builder_4.degrees((float)displaygroup.display_rotation)));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "display_resolution");
        xml_setting.setString("type", "mixed");
        xml_setting.setString("description", "Group display resolution");
        xml_setting.setInt("width_px", Display_Builder_4.round((float)displaygroup.display_resolution.x));
        xml_setting.setInt("height_px", Display_Builder_4.round((float)displaygroup.display_resolution.y));
        xml_setting.setString("width_physical", Display_Builder_4.nf((float)displaygroup.display_dimensions_physical.x, (int)0, (int)4));
        xml_setting.setString("height_physical", Display_Builder_4.nf((float)displaygroup.display_dimensions_physical.y, (int)0, (int)4));
        xml_setting.setString("stage_scale", Display_Builder_4.nf((float)displaygroup.stage_scale, (int)1, (int)2));
        if (displaygroup.resolution != null) {
            xml_setting.setContent(displaygroup.resolution.name);
        } else {
            xml_setting.setContent("Custom resolution");
        }
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "displays_overrides_active");
        xml_setting.setString("type", "boolean");
        xml_setting.setString("description", "Display overrides active");
        xml_setting.setContent(this.boolean_to_string(displaygroup.displays_overrides_active));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "stagetier_id");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "StageTier ID");
        xml_setting.setContent(Integer.toString(displaygroup.stagetier_id));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "origin_alignment_id");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Origin position ID");
        xml_setting.setContent(Integer.toString(displaygroup.anchor_alignment_id));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "parent_group_id");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "ID of parent group");
        xml_setting.setContent(Integer.toString(displaygroup.parent_group_id));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "parent_alignment_id");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Parent alignment position ID");
        xml_setting.setContent(Integer.toString(displaygroup.parent_alignment_id));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "origin_offset_x");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Horizontal offset from origin in pixels");
        xml_setting.setContent(Display_Builder_4.nf((float)displaygroup.parent_offset.x, (int)0, (int)0));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "origin_offset_y");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Vertical offset from origin in pixels");
        xml_setting.setContent(Display_Builder_4.nf((float)displaygroup.parent_offset.y, (int)0, (int)0));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "softedge_h_px");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Horizontal size of softedge in pixels");
        xml_setting.setContent(Display_Builder_4.nf((float)displaygroup.softedge_dimensions.x, (int)0, (int)0));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "softedge_v_px");
        xml_setting.setString("type", "integer");
        xml_setting.setString("description", "Vertical size of softedge in pixels");
        xml_setting.setContent(Display_Builder_4.nf((float)displaygroup.softedge_dimensions.y, (int)0, (int)0));
        xml_setting = xml_group_settings.addChild("setting");
        xml_setting.setString("id", "display_show_43_marks");
        xml_setting.setString("type", "boolean");
        xml_setting.setString("description", "Show 4:3 cut marks for displays");
        xml_setting.setContent(this.boolean_to_string(displaygroup.display_show_43_marks));
        XML xml_group_displays = xml_displaygroup.addChild("group_displays");
        for (DisplayObject display : displaygroup.displays) {
            xml_group_displays.addChild(this.generate_display_xml(display));
        }
        return xml_displaygroup;
    }

    public XML generate_project_xml() {
        XML xml_project_preferences = new XML("project_preferences");
        XML xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "resolution_list_order_invert");
        xml_pref.setString("type", "boolean");
        xml_pref.setString("description", "Invert order of Display Resolutions menu");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_resolution_list_order_invert));
        xml_pref = xml_project_preferences.addChild("setting");
        DisplayResolution resolution = this.project.resolutions_list.get(this.project.default_resolution_id);
        xml_pref.setString("id", "display_default_resolution");
        xml_pref.setString("type", "mixed");
        xml_pref.setString("description", "Default display resolution");
        xml_pref.setInt("width_px", Display_Builder_4.round((float)resolution.pixel_count.x));
        xml_pref.setInt("height_px", Display_Builder_4.round((float)resolution.pixel_count.y));
        xml_pref.setString("width_physical", "0.0");
        xml_pref.setString("height_physical", "0.0");
        xml_pref.setContent(resolution.name);
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "projection_surface_mode");
        xml_pref.setString("description", "Calculation method for projection surface");
        xml_pref.setString("type", "string");
        if (this.project.pref_projection_surface_mode == 0) {
            xml_pref.setContent("automatic");
        } else {
            xml_pref.setContent("fixed");
        }
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "projection_surface_width");
        xml_pref.setString("description", "Horizontal pixel size of projection surface");
        xml_pref.setString("type", "integer");
        xml_pref.setContent(Integer.toString(0));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "projection_surface_height");
        xml_pref.setString("description", "Vertical pixel size of projection surface");
        xml_pref.setString("type", "integer");
        xml_pref.setContent(Integer.toString(0));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_display_scale");
        xml_pref.setString("description", "Default scale value");
        xml_pref.setString("type", "float");
        xml_pref.setContent(Integer.toString(Display_Builder_4.round((float)this.ui.viewport_scale)));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_scale_auto");
        xml_pref.setString("description", "Automatically scale UI to fit displays");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_ui_scale_auto));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_show_current_group_only");
        xml_pref.setString("description", "Show only current DisplayGroup in UI");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_ui_show_current_group_only));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_show_display_info");
        xml_pref.setString("description", "Show Display info on hover.");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_ui_show_display_info));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_show_display_info_crop");
        xml_pref.setString("description", "Show Display crop values in overlay");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_ui_show_display_info_crop));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_show_mouse_coords_overlay");
        xml_pref.setString("description", "Show/Hide Mouse position overlay");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_ui_show_mouse_coords_overlay));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_show_display_spacing");
        xml_pref.setString("description", "Show/Hide display spacing overlay");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_ui_show_overlay_display_spacing));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_show_parent_links_overlay");
        xml_pref.setString("description", "Show/Hide links betwen DisplayGroups when parented");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_ui_show_parent_links));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_toggle_show_layout_grid");
        xml_pref.setString("description", "Show layout grid");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_ui_toggle_show_layout_grid));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_grid_size_h");
        xml_pref.setString("description", "Layout grid size horizontal");
        xml_pref.setString("type", "integer");
        xml_pref.setContent(Integer.toString(this.project.pref_ui_grid_size_h));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_grid_size_v");
        xml_pref.setString("description", "Layout grid size vertical");
        xml_pref.setString("type", "integer");
        xml_pref.setContent(Integer.toString(this.project.pref_ui_grid_size_v));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_physical_grid_alignment");
        xml_pref.setString("description", "Physical grid alignment ID.");
        xml_pref.setString("type", "integer");
        xml_pref.setContent(Integer.toString(this.project.physical_grid.alignment_id_get()));
        PVector physical_grid_origin_offsets = this.project.physical_grid.origins_offset_get();
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_physical_grid_offset_x");
        xml_pref.setString("description", "Physical grid horizontal offset");
        xml_pref.setString("type", "float");
        xml_pref.setContent(Float.toString(physical_grid_origin_offsets.x));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_physical_grid_offset_y");
        xml_pref.setString("description", "Physical grid vertical offset");
        xml_pref.setString("type", "float");
        xml_pref.setContent(Float.toString(physical_grid_origin_offsets.y));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "ui_toggle_show_physical_grid");
        xml_pref.setString("description", "Show physical grid");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.physical_grid.visibility_get()));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_format");
        xml_pref.setString("description", "Id of selected export format");
        xml_pref.setString("type", "integer");
        xml_pref.setContent(Integer.toString(this.export_manager.format_id_selected));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_filepath");
        xml_pref.setString("description", "Export filepath");
        xml_pref.setString("type", "string");
        xml_pref.setContent(this.export_manager.export_folder_filepath);
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_filename_base");
        xml_pref.setString("description", "Prefix for filenames");
        xml_pref.setString("type", "string");
        xml_pref.setContent(this.project.pref_project_name);
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_display_data");
        xml_pref.setString("description", "Export Display data");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_display_data));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_pixel_grid");
        xml_pref.setString("description", "Generate master alignment grid image");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_pixel_grid));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_physical_grid");
        xml_pref.setString("description", "Generate physical grid reference image");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_physical_grid));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_warping_grid");
        xml_pref.setString("description", "Generate warping grid image");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_warping_grid));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_colourbars");
        xml_pref.setString("description", "Generate colour bars image");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_colourbars));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_grid_cell_unit");
        xml_pref.setString("description", "Id of units for grid image exports");
        xml_pref.setString("type", "integer");
        xml_pref.setContent(Integer.toString(this.project.pref_export_grid_cell_unit));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_grid_cell_size");
        xml_pref.setString("description", "Cell size for grid image exports");
        xml_pref.setString("type", "integer");
        xml_pref.setContent(Integer.toString(this.project.pref_export_grid_cell_size));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_grid_crosshatch_show");
        xml_pref.setString("description", "Show crosshatch pattern on alignment grid");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_grid_crosshatch_show));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_grid_marker_interval");
        xml_pref.setString("description", "Marker interval for grid image exports");
        xml_pref.setString("type", "integer");
        xml_pref.setContent(Integer.toString(this.project.pref_export_grid_marker_interval));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_grid_use_display_colours");
        xml_pref.setString("description", "Use Display colour preferences in alignment grid image");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_grid_use_display_colours));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_grid_use_grid_colour");
        xml_pref.setString("description", "Use user-selected Grid colour in alignment image");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_grid_use_grid_colour));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_grid_show_alignment");
        xml_pref.setString("description", "Include layout grid lines in alignment image");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_grid_show_alignment));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_invert_grid_colour");
        xml_pref.setString("description", "Invert alignment grid colours");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_grid_invert_colour));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_grid_show_markers");
        xml_pref.setString("description", "Show interval markers on alignment grid");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_grid_show_markers));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_show_column_row_numbers");
        xml_pref.setString("description", "Show Display column & row numbers on alignment grid");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_show_column_row_numbers));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_show_display_coordinates");
        xml_pref.setString("description", "Show Display pixel coordinates on alignment grid");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_show_display_coordinates));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_show_display_id");
        xml_pref.setString("description", "Show Display ID on alignment grid");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_show_display_id));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_show_displaygroup_id");
        xml_pref.setString("description", "Show DisplayGroup ID on alignment grid");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_show_displaygroup_id));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_show_displaygroup_name");
        xml_pref.setString("description", "Show DisplayGroup Name on alignment grid");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_show_displaygroup_name));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_show_info_overlay");
        xml_pref.setString("description", "Show info overlay with grid dimensions");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_show_info_overlay));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "export_show_softedge_text");
        xml_pref.setString("description", "Show Softedge text overlay on alignment grid");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.boolean_to_string(this.project.pref_export_show_softedge_text));
        XML xml_project_colours = xml_project_preferences.addChild("ui_colours");
        for (String colour_name : this.ui.colours.keys()) {
            int colour_values = this.ui.colours.get(colour_name);
            XML xml_colour = xml_project_colours.addChild("colour");
            xml_colour.setString("id", colour_name);
            xml_colour.setInt("a", colour_values >> 24 & 0xFF);
            xml_colour.setInt("r", colour_values >> 16 & 0xFF);
            xml_colour.setInt("g", colour_values >> 8 & 0xFF);
            xml_colour.setInt("b", colour_values & 0xFF);
        }
        xml_pref = xml_project_preferences.addChild("info");
        xml_pref.setString("id", "display_resolution");
        xml_pref.setString("description", "Display resolution data");
        xml_pref.setInt("display_width_px", this.displayWidth);
        xml_pref.setInt("display_height_px", this.displayHeight);
        xml_pref.setInt("display_density", this.displayDensity());
        xml_pref = xml_project_preferences.addChild("info");
        xml_pref.setString("id", "app_resolution");
        xml_pref.setString("description", "App resolution data");
        xml_pref.setInt("app_width_px", this.width);
        xml_pref.setInt("app_height_px", this.height);
        return xml_project_preferences;
    }

    public MixedInputResult test_pattern_image_create(String pattern_type, String colour_range, PVector image_dimensions, float export_scale) {
        if (export_scale > 0.0f) {
            int cb;
            int bar_colours_count;
            int image_width = Display_Builder_4.round((float)(image_dimensions.x * export_scale));
            int image_height = Display_Builder_4.round((float)(image_dimensions.y * export_scale));
            float aspect_ratio = this.aspect_ratio_calculate(image_dimensions);
            int color_fg = this.color(255, 255, 255, 255);
            int[] bar_colours = this.bars_colour_values_generate(colour_range);
            int bar_count = bar_colours_count = bar_colours.length;
            float bar_height = image_dimensions.y / (float)bar_colours_count;
            float bar_width = image_width;
            int text_size = Display_Builder_4.round((float)((float)image_height * 0.03f));
            PVector text_origin = new PVector(0.0f, 0.0f);
            String image_filename = "display-bars-" + pattern_type + "-" + colour_range;
            PGraphics grid_image = this.createGraphics(image_width, image_height);
            if (!this.project.pref_image_export_antialiasing.booleanValue()) {
                grid_image.noSmooth();
            }
            grid_image.beginDraw();
            grid_image.fill(0.0f, 0.0f, 0.0f, 0.0f);
            grid_image.stroke(color_fg);
            grid_image.rectMode(0);
            grid_image.noStroke();
            grid_image.textAlign(3, 3);
            if (pattern_type.equals("softedge")) {
                cb = 0;
                while (cb < bar_count) {
                    grid_image.fill(bar_colours[cb]);
                    grid_image.rect(0.0f, bar_height * (float)cb, bar_width, bar_height);
                    ++cb;
                }
            }
            if (pattern_type.equals("smpte-bars")) {
                bar_count = 7;
                bar_height = image_height;
                bar_width = image_dimensions.x / (float)bar_count;
                cb = 0;
                while (cb < bar_count) {
                    grid_image.fill(bar_colours[cb]);
                    grid_image.rect(bar_width * (float)cb, 0.0f, bar_width, bar_height);
                    ++cb;
                }
                bar_height = (float)image_height * 0.333f;
                grid_image.fill(this.bars_colour_get_by_name_and_range("black", colour_range));
                grid_image.rect(0.0f, (float)image_height - bar_height, (float)image_width, bar_height);
                cb = 0;
                while (cb < bar_count) {
                    grid_image.fill(bar_colours[6 - cb]);
                    grid_image.rect(bar_width * (float)cb, (float)image_height - bar_height, bar_width, bar_height);
                    cb += 2;
                }
                bar_height = (float)image_height * 0.25f;
                bar_width = image_dimensions.x * 0.178f;
                int[] pluge_colours = new int[]{this.bars_colour_get_by_name_and_range("pluge-i-", colour_range), this.bars_colour_get_by_name_and_range("white", "rgb-16-235"), this.bars_colour_get_by_name_and_range("pluge-q+", colour_range), this.bars_colour_get_by_name_and_range("pluge-ire-3.5", colour_range), this.bars_colour_get_by_name_and_range("pluge-ire-7.5", colour_range), this.bars_colour_get_by_name_and_range("pluge-ire-11.5", colour_range)};
                grid_image.fill(this.bars_colour_get_by_name_and_range("black", colour_range));
                grid_image.rect(0.0f, (float)image_height - bar_height, (float)image_width, bar_height);
                int cb2 = 0;
                while (cb2 < 3) {
                    grid_image.fill(pluge_colours[cb2]);
                    grid_image.rect(bar_width * (float)cb2, (float)image_height - bar_height, bar_width, bar_height);
                    ++cb2;
                }
                float pluge_origin = image_dimensions.x / 7.0f * 5.0f;
                bar_width = image_dimensions.x / 21.0f;
                int cb3 = 0;
                while (cb3 < 3) {
                    grid_image.fill(pluge_colours[cb3 + 3]);
                    grid_image.rect(pluge_origin + bar_width * (float)cb3, (float)image_height - bar_height, bar_width, bar_height);
                    ++cb3;
                }
            }
            if (pattern_type.equals("test-pattern")) {
                image_filename = "display-bars-" + pattern_type;
                PVector image_centre = image_dimensions.copy().mult(0.5f);
                float width_smpte_43 = image_dimensions.y / 3.0f * 4.0f;
                if (aspect_ratio <= 1.3333334f) {
                    bar_count = 9;
                    bar_width = image_dimensions.x / (float)bar_count;
                    width_smpte_43 = image_dimensions.x / 9.0f * 7.0f;
                } else {
                    bar_count = 8;
                    bar_width = (image_dimensions.x - width_smpte_43) / 2.0f;
                }
                PVector bars_origin = new PVector(bar_width, 0.0f);
                float bar_width_sides = bar_width;
                bar_height = image_height;
                grid_image.fill(this.bars_colour_get_by_name_and_range("white", "rgb-0-255"));
                grid_image.rect(0.0f, 0.0f, bar_width, bar_height);
                text_origin.x = bar_width * 0.5f;
                text_origin.y = (float)image_height * 0.15f;
                this.render_grid_text(grid_image, "255", text_origin, text_size);
                grid_image.fill(this.bars_colour_get_by_name_and_range("white", "rgb-16-235"));
                grid_image.rect(0.0f, image_centre.y, bar_width, bar_height * 0.5f);
                text_origin.y = (float)image_height * 0.87f;
                this.render_grid_text(grid_image, "235", text_origin, text_size);
                grid_image.fill(this.bars_colour_get_by_name_and_range("black", "rgb-0-255"));
                grid_image.rect(image_dimensions.x - bar_width, 0.0f, bar_width, bar_height);
                text_origin.x = image_dimensions.x - bar_width * 0.5f;
                text_origin.y = (float)image_height * 0.15f;
                this.render_grid_text(grid_image, "0", text_origin, text_size);
                grid_image.fill(this.bars_colour_get_by_name_and_range("black", "rgb-16-235"));
                grid_image.rect(image_dimensions.x - bar_width, image_centre.y, bar_width, bar_height * 0.5f);
                text_origin.y = (float)image_height * 0.87f;
                this.render_grid_text(grid_image, "16", text_origin, text_size);
                float bar_width_swatches = bar_width * 0.25f;
                bar_height = (float)image_height * 0.2f;
                int swatch_fill = 0;
                int swatch_count = 4;
                int[] swatch_values = new int[]{4, 8, 12, 16};
                int i = 0;
                while (i < swatch_count) {
                    swatch_fill = 255 - swatch_values[i];
                    grid_image.fill((float)swatch_fill, (float)swatch_fill, (float)swatch_fill, 255.0f);
                    grid_image.rect(bar_width_swatches * (float)i, (float)image_height * 0.4f, bar_width_swatches, bar_height);
                    swatch_fill = swatch_values[i];
                    grid_image.fill((float)swatch_fill, (float)swatch_fill, (float)swatch_fill, 255.0f);
                    grid_image.rect((float)image_width - bar_width_swatches * (float)(i + 1), (float)image_height * 0.4f, bar_width_swatches, bar_height);
                    ++i;
                }
                bar_count = 7;
                bar_width = width_smpte_43 / (float)bar_count;
                bar_height = image_height;
                int cb4 = 0;
                while (cb4 < bar_count) {
                    grid_image.fill(bar_colours[cb4]);
                    grid_image.rect(bars_origin.x + bar_width * (float)cb4, 0.0f, bar_width, bar_height);
                    ++cb4;
                }
                bars_origin.y = image_dimensions.y * 0.8f;
                bar_height = (float)image_height * 0.2f;
                grid_image.fill(this.bars_colour_get_by_name_and_range("black", colour_range));
                grid_image.rect(bars_origin.x, bars_origin.y, image_dimensions.x * 0.75f, bar_height);
                cb4 = 0;
                while (cb4 < bar_count) {
                    grid_image.fill(bar_colours[6 - cb4]);
                    grid_image.rect(bars_origin.x + bar_width * (float)cb4, bars_origin.y, bar_width, bar_height);
                    cb4 += 2;
                }
                text_origin.x = bars_origin.x + bar_width * 0.5f;
                text_origin.y = (float)image_height * 0.87f;
                this.render_grid_text(grid_image, "180", text_origin, text_size);
                text_origin.x = bars_origin.x + width_smpte_43 - bar_width * 0.5f;
                this.render_grid_text(grid_image, "180", text_origin, text_size);
                bar_colours = this.bars_colour_values_generate("rgb-16-235");
                bar_count = 7;
                bars_origin.y = 0.0f;
                bar_height = (float)image_height * 0.2f;
                cb4 = 0;
                while (cb4 < bar_count) {
                    grid_image.fill(bar_colours[cb4]);
                    grid_image.rect(bars_origin.x + bar_width * (float)cb4, 0.0f, bar_width, bar_height);
                    ++cb4;
                }
                text_origin.x = bars_origin.x + bar_width * 0.5f;
                text_origin.y = (float)image_height * 0.15f;
                this.render_grid_text(grid_image, "235", text_origin, text_size);
                text_origin.x = bars_origin.x + width_smpte_43 - bar_width * 0.5f;
                this.render_grid_text(grid_image, "235", text_origin, text_size);
                bar_width = width_smpte_43 / 256.0f;
                bar_height = (float)image_height * 0.1f;
                bars_origin.y = image_dimensions.y * 0.4f;
                i = 0;
                while (i < 256) {
                    swatch_fill = 255 - i;
                    grid_image.fill((float)swatch_fill, (float)swatch_fill, (float)swatch_fill, 255.0f);
                    grid_image.rect(bars_origin.x + bar_width * (float)i, bars_origin.y, bar_width, bar_height);
                    grid_image.fill(0.0f, 0.0f, (float)swatch_fill, 255.0f);
                    grid_image.rect(bars_origin.x + bar_width * (float)i, bars_origin.y + bar_height, bar_width, bar_height);
                    ++i;
                }
                grid_image.rectMode(3);
                grid_image.pushStyle();
                grid_image.stroke(this.ui.colour_get_by_name("matkeane"));
                grid_image.strokeWeight((float)(this.project.pref_export_grid_line_width * (image_height / 1080)) * export_scale);
                grid_image.noFill();
                if (aspect_ratio != 1.7777778f) {
                    PVector aspect_marker_dimensions = new PVector(0.0f, 0.0f);
                    if (aspect_ratio < 1.7777778f) {
                        aspect_marker_dimensions.x = image_dimensions.x;
                        aspect_marker_dimensions.y = image_dimensions.x / 16.0f * 9.0f;
                    } else {
                        aspect_marker_dimensions.y = image_dimensions.y;
                        aspect_marker_dimensions.x = image_dimensions.y / 9.0f * 16.0f;
                    }
                    grid_image.rect(image_centre.x, image_centre.y, aspect_marker_dimensions.x, aspect_marker_dimensions.y);
                }
                float circle_radius = Display_Builder_4.min((float)image_dimensions.x, (float)image_dimensions.y) * 0.5f;
                grid_image.ellipseMode(2);
                grid_image.ellipse(image_centre.x, image_centre.y, circle_radius, circle_radius);
                grid_image.line(0.0f, image_centre.y, bar_width_sides *= 0.5f, image_centre.y);
                grid_image.line((float)image_width - bar_width_sides, image_centre.y, (float)image_width, image_centre.y);
                grid_image.line(image_centre.x, 0.0f, image_centre.x, (float)image_height * 0.1f);
                grid_image.line(image_centre.x, (float)image_height * 0.9f, image_centre.x, (float)image_height);
                PVector arrow_origin = new PVector(0.0f, 0.0f);
                float arrow_size = (float)image_height * 0.04f;
                float arrow_origin_offset = 0.0f;
                float arrow_drawing_origin = 0.0f;
                int i2 = 0;
                while (i2 < 4) {
                    switch (i2) {
                        case 0: {
                            arrow_origin.x = (float)image_width * 0.5f;
                            arrow_origin.y = 0.0f;
                            arrow_origin_offset = (float)image_width * 0.4f;
                            break;
                        }
                        case 1: {
                            arrow_origin.x = image_width;
                            arrow_origin.y = (float)image_height * 0.5f;
                            arrow_origin_offset = (float)image_height * 0.4f;
                            break;
                        }
                        case 2: {
                            arrow_origin.x = (float)image_width * 0.5f;
                            arrow_origin.y = image_height;
                            arrow_origin_offset = (float)image_width * 0.4f;
                            break;
                        }
                        case 3: {
                            arrow_origin.x = 0.0f;
                            arrow_origin.y = (float)image_height * 0.5f;
                            arrow_origin_offset = (float)image_height * 0.4f;
                        }
                    }
                    grid_image.pushMatrix();
                    grid_image.translate(arrow_origin.x, arrow_origin.y);
                    grid_image.rotate(Display_Builder_4.radians((float)(i2 * 90)));
                    arrow_drawing_origin = arrow_origin_offset * 1.0f;
                    grid_image.line(arrow_drawing_origin, 0.0f, arrow_drawing_origin + arrow_size, arrow_size);
                    grid_image.line(arrow_drawing_origin, 0.0f, arrow_drawing_origin - arrow_size, arrow_size);
                    arrow_drawing_origin = arrow_origin_offset * -1.0f;
                    grid_image.line(arrow_drawing_origin, 0.0f, arrow_drawing_origin + arrow_size, arrow_size);
                    grid_image.line(arrow_drawing_origin, 0.0f, arrow_drawing_origin - arrow_size, arrow_size);
                    grid_image.popMatrix();
                    ++i2;
                }
                bar_width = width_smpte_43 / (float)bar_count;
                grid_image.noStroke();
                grid_image.fill(this.bars_colour_get_by_name_and_range("black", "rgb-0-255"));
                grid_image.rect(image_centre.x, image_centre.y, bar_width * 4.0f, (float)image_height * 0.1f);
                String app_signature = "Test pattern " + image_width + "x" + image_height + "px ratio: " + Display_Builder_4.nf((float)aspect_ratio, (int)1, (int)2);
                app_signature = String.valueOf(app_signature) + "\nGenerated by Display Builder (v" + this.app_version + ") - www.matkeane.com";
                text_origin.x = image_centre.x;
                text_origin.y = image_centre.y + (float)image_height * 0.005f;
                text_size = Display_Builder_4.round((float)((float)image_height * 0.025f));
                this.render_grid_text(grid_image, app_signature, text_origin, text_size);
                grid_image.popStyle();
                grid_image.rectMode(0);
            }
            grid_image.endDraw();
            image_filename = String.valueOf(image_filename) + "-" + image_width + "x" + image_height + ".png";
            String image_filepath = String.valueOf(this.export_manager.export_folder_filepath) + image_filename;
            if (grid_image.save(image_filepath)) {
                MixedInputResult file_status = new MixedInputResult(true, export_scale, image_filepath);
                return file_status;
            }
            return null;
        }
        this.debug_output("Error: Image size exceeds available memory - no image created.");
        return null;
    }

    public int[] bars_colour_values_generate(String colour_range) {
        int bars_count = 8;
        int[] bar_colours = new int[bars_count];
        if (colour_range.equals("greyscale")) {
            float greyscale_step = 256 / (bars_count - 1);
            int gr = 0;
            while (gr < bars_count) {
                int colour_bar_rgb;
                int grey_value = 256 - Display_Builder_4.round((float)(greyscale_step * (float)gr));
                bar_colours[gr] = colour_bar_rgb = this.color(grey_value, grey_value, grey_value);
                ++gr;
            }
        } else {
            bar_colours[0] = this.bars_colour_get_by_name_and_range("white", colour_range);
            bar_colours[1] = this.bars_colour_get_by_name_and_range("yellow", colour_range);
            bar_colours[2] = this.bars_colour_get_by_name_and_range("cyan", colour_range);
            bar_colours[3] = this.bars_colour_get_by_name_and_range("green", colour_range);
            bar_colours[4] = this.bars_colour_get_by_name_and_range("magenta", colour_range);
            bar_colours[5] = this.bars_colour_get_by_name_and_range("red", colour_range);
            bar_colours[6] = this.bars_colour_get_by_name_and_range("blue", colour_range);
            bar_colours[7] = this.bars_colour_get_by_name_and_range("black", colour_range);
        }
        return bar_colours;
    }

    public void test_pattern_colours_add() {
        String colour_range = "rgb-16-180";
        this.bars_colour_set(180, 180, 180, "white", colour_range);
        this.bars_colour_set(180, 180, 16, "yellow", colour_range);
        this.bars_colour_set(16, 180, 180, "cyan", colour_range);
        this.bars_colour_set(16, 180, 16, "green", colour_range);
        this.bars_colour_set(180, 16, 180, "magenta", colour_range);
        this.bars_colour_set(180, 16, 16, "red", colour_range);
        this.bars_colour_set(16, 16, 180, "blue", colour_range);
        this.bars_colour_set(16, 16, 16, "black", colour_range);
        this.bars_colour_set(104, 104, 104, "gray", colour_range);
        this.bars_colour_set(106, 52, 16, "pluge-i+", colour_range);
        this.bars_colour_set(16, 70, 106, "pluge-i-", colour_range);
        this.bars_colour_set(72, 16, 118, "pluge-q+", colour_range);
        this.bars_colour_set(8, 8, 8, "pluge-ire-3.5", colour_range);
        this.bars_colour_set(16, 16, 16, "pluge-ire-7.5", colour_range);
        this.bars_colour_set(24, 24, 24, "pluge-ire-11.5", colour_range);
        colour_range = "rgb-16-235";
        this.bars_colour_set(235, 235, 235, "white", colour_range);
        this.bars_colour_set(235, 235, 16, "yellow", colour_range);
        this.bars_colour_set(16, 235, 235, "cyan", colour_range);
        this.bars_colour_set(16, 235, 16, "green", colour_range);
        this.bars_colour_set(235, 16, 235, "magenta", colour_range);
        this.bars_colour_set(235, 16, 16, "red", colour_range);
        this.bars_colour_set(16, 16, 235, "blue", colour_range);
        this.bars_colour_set(16, 16, 16, "black", colour_range);
        this.bars_colour_set(104, 104, 104, "gray", colour_range);
        colour_range = "rgb-0-255";
        this.bars_colour_set(255, 255, 255, "white", colour_range);
        this.bars_colour_set(255, 255, 0, "yellow", colour_range);
        this.bars_colour_set(0, 255, 255, "cyan", colour_range);
        this.bars_colour_set(0, 255, 0, "green", colour_range);
        this.bars_colour_set(255, 0, 255, "magenta", colour_range);
        this.bars_colour_set(255, 0, 0, "red", colour_range);
        this.bars_colour_set(0, 0, 180, "blue", colour_range);
        this.bars_colour_set(0, 0, 0, "black", colour_range);
        this.bars_colour_set(180, 180, 180, "gray", colour_range);
    }

    public int bars_colour_get_by_name(String colour_name) {
        String colour_name_lookup = "bars-" + colour_name;
        return this.ui.colour_get_by_name(colour_name_lookup);
    }

    public int bars_colour_get_by_name_and_range(String colour_name, String colour_range) {
        String colour_name_lookup = "bars-" + colour_name + "-" + colour_range;
        return this.ui.colour_get_by_name(colour_name_lookup);
    }

    public void bars_colour_set(int r, int g, int b, String colour_name, String colour_range) {
        String colour_name_lookup = "bars-" + colour_name + "-" + colour_range;
        this.ui.colour_set_by_name_rgba(colour_name_lookup, r, g, b, 255);
    }

    public MixedInputResult project_physical_grid_render(PGraphics grid_image) {
        PVector project_surface_dimensions = this.project.surface_dimensions_get("project");
        float image_scale = this.export_manager.max_image_scale_calculate(project_surface_dimensions);
        if (image_scale > 0.0f) {
            PVector grid_image_dimensions = PVector.mult((PVector)project_surface_dimensions, (float)image_scale);
            grid_image = this.createGraphics(Display_Builder_4.round((float)grid_image_dimensions.x), Display_Builder_4.round((float)grid_image_dimensions.y));
            if (!this.project.pref_image_export_antialiasing.booleanValue()) {
                grid_image.noSmooth();
            }
            grid_image.beginDraw();
            grid_image.fill(this.project.grid_colour_get("bg"));
            grid_image.noStroke();
            grid_image.rectMode(0);
            grid_image.rect(0.0f, 0.0f, grid_image_dimensions.x, grid_image_dimensions.y);
            grid_image.noFill();
            this.project.physical_grid.grid_render(grid_image, grid_image_dimensions, Float.valueOf(image_scale));
            for (DisplayGroup group : this.project.display_groups) {
                this.displaygroup_grid_image_render(group, grid_image, "physical");
            }
            grid_image.endDraw();
            String image_filename = String.valueOf(this.project.pref_project_name) + "-physical-grid-" + Display_Builder_4.round((float)grid_image_dimensions.x) + "x" + Display_Builder_4.round((float)grid_image_dimensions.y);
            if (image_scale < 1.0f) {
                image_filename = String.valueOf(image_filename) + "-" + Display_Builder_4.round((float)(100.0f * image_scale)) + "pc";
            }
            image_filename = this.sanitize_file_name(image_filename);
            image_filename = String.valueOf(image_filename) + ".png";
            String image_filepath = String.valueOf(this.export_manager.export_folder_filepath) + image_filename;
            if (grid_image.save(image_filepath)) {
                MixedInputResult file_status = new MixedInputResult(true, image_scale, image_filepath);
                return file_status;
            }
            return null;
        }
        return null;
    }

    public MixedInputResult displaygroup_grid_image_render(DisplayGroup group, PGraphics grid_image, String grid_type) {
        PVector displaygroup_dimensions = group.projection_surface_dimensions_get();
        float image_scale = this.export_manager.max_image_scale_calculate(displaygroup_dimensions);
        if (image_scale > 0.0f) {
            int[] project_projection_bounds = this.project.surface_bounds_get("project");
            int grid_surface_width = Display_Builder_4.round((float)(displaygroup_dimensions.x * image_scale));
            int grid_surface_height = Display_Builder_4.round((float)(displaygroup_dimensions.y * image_scale));
            float grid_surface_width_physical = 0.0f;
            float grid_surface_height_physical = 0.0f;
            float grid_cell_pixels = 50.0f;
            float grid_cell_marker_interval = 1000.0f;
            String credits_text_markers = ", Marker interval: ";
            switch (this.project.pref_export_grid_cell_unit) {
                case 1: {
                    grid_cell_pixels = this.project.pref_export_grid_cell_size;
                    grid_cell_marker_interval = (float)this.project.pref_export_grid_marker_interval / grid_cell_pixels;
                    credits_text_markers = String.valueOf(credits_text_markers) + this.project.pref_export_grid_marker_interval + " pixels";
                    break;
                }
                case 2: {
                    grid_cell_pixels = displaygroup_dimensions.x / (float)this.project.pref_export_grid_cell_size;
                    grid_cell_marker_interval = this.project.pref_export_grid_marker_interval;
                    credits_text_markers = String.valueOf(credits_text_markers) + Display_Builder_4.round((float)grid_cell_marker_interval) + " cells";
                }
            }
            if (image_scale < 1.0f) {
                grid_cell_pixels *= 1.0f / image_scale;
            }
            float circle_width = Display_Builder_4.min((float)50.0f, (float)(grid_cell_pixels * image_scale));
            PVector display_origin_offset = new PVector(0.0f, 0.0f);
            if (grid_type.equals("pixel")) {
                display_origin_offset.x = group.projection_surface_bounds[3] * -1;
                display_origin_offset.y = group.projection_surface_bounds[0] * -1;
            }
            if (grid_type.equals("physical")) {
                grid_surface_width = Display_Builder_4.round((float)((float)(project_projection_bounds[1] - project_projection_bounds[3] + 1) * image_scale));
                grid_surface_height = Display_Builder_4.round((float)((float)(project_projection_bounds[2] - project_projection_bounds[0] + 1) * image_scale));
                grid_surface_width_physical = PApplet.parseFloat((int)grid_surface_width) / this.project.viewport_physical_scale;
                grid_surface_height_physical = PApplet.parseFloat((int)grid_surface_height) / this.project.viewport_physical_scale;
                grid_cell_pixels = this.project.viewport_physical_scale;
                grid_cell_marker_interval = 5.0f;
                display_origin_offset.x = 0 - project_projection_bounds[3];
                display_origin_offset.y = 0 - project_projection_bounds[0];
            }
            this.debug_output("DisplayGroup " + group.id + " Rendering " + grid_type + " alignment grid at scale: " + image_scale + ", " + grid_surface_width + "x" + grid_surface_height);
            PVector surface_centre = new PVector(PApplet.parseFloat((int)grid_surface_width) / 2.0f, PApplet.parseFloat((int)grid_surface_height) / 2.0f);
            int color_bg = this.project.grid_colour_get("bg");
            int color_fg = this.project.grid_colour_get("fg");
            int color_mid = this.project.grid_colour_get("mid");
            float display_shortest_dimension = Display_Builder_4.min((int)grid_surface_width, (int)grid_surface_height);
            int text_size = Display_Builder_4.max((int)16, (int)Display_Builder_4.round((float)(display_shortest_dimension / 48.0f)));
            if (grid_type.equals("pixel")) {
                grid_image = this.createGraphics(grid_surface_width, grid_surface_height);
                if (!this.project.pref_image_export_antialiasing.booleanValue()) {
                    grid_image.noSmooth();
                }
                grid_image.beginDraw();
            }
            String displaygroup_name = String.valueOf(this.get_number_from_id(group.id)) + "-" + group.name;
            String image_filename = String.valueOf(this.project.pref_project_name) + "-" + displaygroup_name + "-" + grid_type + "-grid-" + Display_Builder_4.round((float)displaygroup_dimensions.x) + "x" + Display_Builder_4.round((float)displaygroup_dimensions.y);
            if (image_scale < 1.0f) {
                image_filename = String.valueOf(image_filename) + "-" + Display_Builder_4.round((float)(100.0f * image_scale)) + "pc";
            }
            image_filename = this.sanitize_file_name(image_filename);
            image_filename = String.valueOf(image_filename) + ".png";
            grid_image.strokeWeight((float)this.project.pref_export_grid_line_width * image_scale);
            if (grid_type.equals("pixel")) {
                grid_image.rectMode(0);
                grid_image.fill(color_bg);
                grid_image.stroke(color_fg);
                grid_image.rect(0.0f, 0.0f, (float)grid_surface_width, (float)grid_surface_height);
            }
            grid_image.noFill();
            PVector grid_origin = new PVector(0.0f, 0.0f);
            PVector grid_origin_marker = new PVector(0.0f, 0.0f);
            if (this.project.pref_export_grid_show_alignment.booleanValue() || this.project.pref_export_physical_grid.booleanValue()) {
                float xpos = 0.0f;
                float ypos = 0.0f;
                float grid_cell_width = grid_cell_pixels * image_scale;
                float grid_cell_height = grid_cell_pixels * image_scale;
                int grid_cols = Display_Builder_4.ceil((float)((float)grid_surface_width / grid_cell_width));
                int grid_rows = Display_Builder_4.ceil((float)((float)grid_surface_height / grid_cell_height));
                int col_count_offset = 0;
                int row_count_offset = 0;
                int[] grid_cell_count_centre = new int[]{Display_Builder_4.ceil((float)(PApplet.parseFloat((int)(grid_surface_width / 2)) / grid_cell_width)), Display_Builder_4.ceil((float)(PApplet.parseFloat((int)(grid_surface_height / 2)) / grid_cell_height))};
                int grid_start_index = 1;
                if (grid_type.equals("pixel")) {
                    grid_image.ellipseMode(3);
                    grid_image.stroke(color_fg);
                    grid_image.ellipse(grid_origin_marker.x, grid_origin_marker.y, circle_width * 2.0f, circle_width * 2.0f);
                    grid_image.ellipse(grid_origin_marker.x, grid_origin_marker.y, circle_width * 4.0f, circle_width * 4.0f);
                }
                if (grid_type.equals("pixel")) {
                    grid_image.pushMatrix();
                    grid_image.scale(image_scale);
                    String[] text_lines = new String[]{"PLAY", "2024"};
                    grid_image.textAlign(3, 3);
                    grid_image.fill(color_mid);
                    if (this.project.pref_export_show_softedge_text != false && group.display_cols > 1 && group.softedge_dimensions.x > 0.0f || group.display_rows > 1 && group.softedge_dimensions.y > 0.0f) {
                        PVector display_footprint = group.display_footprint_get();
                        PVector softedge_dimensions_copy = group.softedge_dimensions.copy();
                        if (group.display_cols == 1) {
                            softedge_dimensions_copy.x = 0.0f;
                        }
                        if (group.display_rows == 1) {
                            softedge_dimensions_copy.y = 0.0f;
                        }
                        PVector softedge_interval = new PVector(display_footprint.x - softedge_dimensions_copy.x, display_footprint.y - softedge_dimensions_copy.y);
                        int text_row = 0;
                        int text_size_col = Display_Builder_4.max((int)100, (int)Display_Builder_4.round((float)(softedge_dimensions_copy.x * 0.33f)));
                        int text_size_row = 100;
                        text_size_row = group.display_cols > 1 && softedge_dimensions_copy.x > 0.0f ? Display_Builder_4.max((int)100, (int)Display_Builder_4.round((float)(softedge_dimensions_copy.y * 0.5f))) : Display_Builder_4.max((int)100, (int)Display_Builder_4.round((float)((softedge_interval.x - softedge_dimensions_copy.x) * 0.15f)));
                        PVector text_repeat_count = new PVector(2.0f, PApplet.parseFloat((int)(grid_surface_height / text_size_col)));
                        PVector text_origin_offset = new PVector(0.0f, (float)text_size_col * 0.05f);
                        PVector text_origin_column = new PVector(display_footprint.x - group.softedge_dimensions.x / 2.0f, (float)(grid_surface_height / 2) - ((float)Display_Builder_4.floor((float)(text_repeat_count.y / 2.0f)) * PApplet.parseFloat((int)text_size_col) + text_origin_offset.y));
                        PVector text_spacing = new PVector((softedge_interval.x - softedge_dimensions_copy.x) / 4.0f, (float)text_size_col);
                        float text_row_origin_x = display_footprint.x / 2.0f;
                        int col = 0;
                        while (col < group.display_cols) {
                            if (group.softedge_dimensions.x > 0.0f && col > 0) {
                                grid_image.textSize((float)text_size_col);
                                xpos = text_origin_column.x + softedge_interval.x * (float)(col - 1);
                                ypos = text_origin_column.y;
                                while (ypos < (float)grid_surface_height / image_scale) {
                                    grid_image.text(text_lines[text_row % 2], xpos, ypos);
                                    ypos += text_spacing.y;
                                    ++text_row;
                                }
                            }
                            if (group.softedge_dimensions.y > 0.0f) {
                                grid_image.textSize((float)text_size_row);
                                text_row_origin_x = display_footprint.x / 2.0f + softedge_interval.x * (float)col;
                                int row = 1;
                                while (row < group.display_rows) {
                                    ypos = softedge_dimensions_copy.y / 2.0f + softedge_interval.y * (float)row;
                                    grid_image.text(text_lines[0], text_row_origin_x - text_spacing.x, ypos - (float)text_size_row * 0.2f);
                                    grid_image.text(text_lines[1], text_row_origin_x + text_spacing.x, ypos - (float)text_size_row * 0.2f);
                                    ++row;
                                }
                            }
                            ++col;
                        }
                    }
                    grid_image.popMatrix();
                }
                if (grid_type.equals("pixel") && this.project.pref_export_grid_cell_unit != 0) {
                    float grid_num;
                    text_size = Display_Builder_4.max((int)18, (int)Display_Builder_4.round((float)(grid_surface_height / 40)));
                    float box_size = (float)text_size * 1.5f;
                    float box_position = Display_Builder_4.max((float)box_size, (float)(grid_cell_height * 0.5f));
                    if (grid_type.equals("physical")) {
                        text_size = Display_Builder_4.max((int)18, (int)Display_Builder_4.round((float)25.0f));
                        box_size = (float)text_size * 1.6f;
                        box_position = Display_Builder_4.max((float)box_size, (float)(grid_cell_height * 0.5f));
                    }
                    grid_image.noFill();
                    if (this.project.pref_export_grid_use_grid_colour.booleanValue()) {
                        grid_image.stroke(this.ui.colour_get_by_name("grid_line_pixel"));
                    } else {
                        grid_image.stroke(color_fg);
                    }
                    int marker_text = 0;
                    int crosshatch_linewidth = Display_Builder_4.round((float)Display_Builder_4.max((float)1.0f, (float)((float)this.project.pref_export_grid_line_width * image_scale * 0.5f)));
                    int col = grid_start_index;
                    while (col < grid_cols) {
                        xpos = grid_origin.x + (float)col * grid_cell_width;
                        if (this.project.pref_export_grid_crosshatch_show.booleanValue() && (col == 0 || col % 2 == 0)) {
                            grid_image.pushStyle();
                            grid_image.strokeWeight((float)crosshatch_linewidth);
                            grid_image.stroke(255.0f, 0.0f, 0.0f, 200.0f);
                            grid_image.line(xpos, 0.0f, xpos + (float)grid_surface_height, (float)grid_surface_height);
                            grid_image.stroke(0.0f, 0.0f, 255.0f, 200.0f);
                            grid_image.line(xpos, 0.0f, xpos - (float)grid_surface_height, (float)grid_surface_height);
                            grid_image.popStyle();
                        }
                        grid_image.line(xpos, 0.0f, xpos, (float)grid_surface_height);
                        if (this.project.pref_export_grid_marker_interval != 0) {
                            grid_num = Display_Builder_4.round((float)((float)col / grid_cell_marker_interval));
                            if (this.project.pref_export_grid_show_markers.booleanValue() && (float)(col - col_count_offset) % grid_cell_marker_interval == 0.0f) {
                                grid_image.line(xpos, 0.0f, xpos, (float)grid_surface_height);
                                grid_image.pushMatrix();
                                grid_image.translate(xpos, box_position);
                                grid_image.pushStyle();
                                grid_image.noStroke();
                                grid_image.fill(color_fg);
                                grid_image.beginShape();
                                grid_image.vertex(0.0f, box_size * -0.9f);
                                grid_image.vertex(box_size * 0.5f, 0.0f);
                                grid_image.vertex(0.0f, box_size * 0.9f);
                                grid_image.vertex(box_size * -0.5f, 0.0f);
                                grid_image.endShape();
                                grid_image.popStyle();
                                grid_image.popMatrix();
                                grid_image.textSize((float)text_size);
                                grid_image.textAlign(3);
                                grid_image.fill(color_bg);
                                marker_text = grid_type.equals("physical") ? Display_Builder_4.abs((int)(col - col_count_offset)) : (this.project.pref_export_grid_cell_unit == 1 ? Display_Builder_4.round((float)grid_num) : Display_Builder_4.round((float)col));
                                grid_image.text(Display_Builder_4.nf((float)marker_text, (int)1, (int)0), xpos, box_position + (float)text_size / 2.5f);
                            }
                        }
                        ++col;
                    }
                    box_position = group.display_resolution.x / 8.0f * image_scale;
                    if (grid_type.equals("physical")) {
                        box_position = grid_origin.x + grid_cell_width * 0.75f;
                    }
                    int row = grid_start_index;
                    while (row < grid_rows) {
                        ypos = grid_origin.y + (float)row * grid_cell_height + (float)this.project.pref_export_grid_line_width * 0.5f;
                        grid_image.line(0.0f, ypos, (float)grid_surface_width, ypos);
                        if (this.project.pref_export_grid_marker_interval != 0) {
                            grid_num = Display_Builder_4.round((float)((float)row / grid_cell_marker_interval));
                            if (this.project.pref_export_grid_show_markers.booleanValue() && (float)(row - row_count_offset) % grid_cell_marker_interval == 0.0f) {
                                grid_image.line(0.0f, ypos, (float)grid_surface_width, ypos);
                                grid_image.pushMatrix();
                                grid_image.translate(box_position, ypos);
                                grid_image.pushStyle();
                                grid_image.noStroke();
                                grid_image.fill(color_fg);
                                grid_image.beginShape();
                                grid_image.vertex(0.0f, box_size * -0.5f);
                                grid_image.vertex(box_size * 0.9f, 0.0f);
                                grid_image.vertex(0.0f, box_size * 0.5f);
                                grid_image.vertex(box_size * -0.9f, 0.0f);
                                grid_image.endShape();
                                grid_image.popStyle();
                                grid_image.popMatrix();
                                grid_image.textSize((float)text_size);
                                grid_image.textAlign(3);
                                grid_image.fill(color_bg);
                                marker_text = grid_type.equals("physical") ? Display_Builder_4.abs((int)(row - row_count_offset)) : (this.project.pref_export_grid_cell_unit == 1 ? Display_Builder_4.round((float)grid_num) : Display_Builder_4.round((float)row));
                                grid_image.text(Display_Builder_4.nf((float)marker_text, (int)1, (int)0), box_position, ypos + (float)text_size / 2.5f);
                            }
                        }
                        ++row;
                    }
                }
            }
            grid_image.noFill();
            grid_image.stroke(color_fg);
            grid_image.rectMode(0);
            grid_image.rect(0.0f, 0.0f, (float)(grid_surface_width - 1), (float)(grid_surface_height - 1));
            int cross_size = Display_Builder_4.round((float)(display_shortest_dimension / 43.0f));
            grid_image.line(surface_centre.x - (float)cross_size, surface_centre.y - (float)cross_size, surface_centre.x + (float)cross_size, surface_centre.y + (float)cross_size);
            grid_image.line(surface_centre.x - (float)cross_size, surface_centre.y + (float)cross_size, surface_centre.x + (float)cross_size, surface_centre.y - (float)cross_size);
            grid_image.ellipseMode(3);
            grid_image.ellipse(surface_centre.x, surface_centre.y, (float)(cross_size *= 2), (float)cross_size);
            if (grid_type.equals("pixel")) {
                int[] projection_surface_bounds_get = this.project.projection_surface_bounds_get();
                grid_origin_marker.x += (float)projection_surface_bounds_get[3];
                grid_origin_marker.y += (float)projection_surface_bounds_get[0];
            } else {
                grid_origin_marker = this.project.physical_grid.stage_origin.copy();
            }
            for (DisplayObject display : group.displays) {
                int n = group.display_type;
                this.project.getClass();
                if (n == 0) {
                    int[] display_overlap_bounds = group.display_overlap_bounds_calculate(display.display_id);
                    this.render_softedge_area(group, display, grid_image, grid_type, display_overlap_bounds, color_bg, color_fg, color_mid);
                }
                this.display_render_grid_outline(group, display, grid_image, grid_type, image_scale, display_origin_offset, grid_origin_marker);
            }
            if (group.id == 0) {
                PVector guide_position = new PVector(0.0f, 0.0f);
                PVector drawing_offset = new PVector((float)project_projection_bounds[3], (float)project_projection_bounds[0]);
                for (Guide guide : this.project.guides) {
                    if (guide.type != 1) continue;
                    guide_position = PVector.sub((PVector)guide.get_position(), (PVector)drawing_offset);
                    grid_image.pushStyle();
                    grid_image.stroke(guide.colour_get(), guide.opacity * 2.55f);
                    if (guide.orientation_get() == 0) {
                        grid_image.line(guide_position.x, 0.0f, guide_position.x, (float)grid_surface_height);
                    } else {
                        grid_image.line(0.0f, guide_position.y, (float)grid_surface_width, guide_position.y);
                    }
                    grid_image.popStyle();
                }
            }
            if (this.project.pref_export_show_displaygroup_name.booleanValue()) {
                String name_text = group.name;
                if (displaygroup_dimensions.y > displaygroup_dimensions.x) {
                    name_text = group.name.replaceAll("\\s", "\n");
                }
                grid_image.pushStyle();
                PVector text_position = new PVector((float)group.projection_surface_bounds[3] + displaygroup_dimensions.x * 0.5f, (float)group.projection_surface_bounds[2] - displaygroup_dimensions.y * 0.25f);
                if (group.display_type == this.project.LED_PANEL || group.display_type == this.project.DISPLAY_VIRTUAL) {
                    text_position.y = (float)group.projection_surface_bounds[2] - displaygroup_dimensions.y * 0.25f;
                }
                text_size = Display_Builder_4.round((float)Display_Builder_4.min((float)(displaygroup_dimensions.x * 0.175f), (float)(displaygroup_dimensions.y * 0.175f)));
                text_position.add(display_origin_offset);
                grid_image.textSize((float)text_size);
                grid_image.textAlign(3, 3);
                grid_image.fill(0);
                grid_image.text(name_text, text_position.x + 2.0f, text_position.y + 2.0f);
                if (this.project.pref_export_grid_use_display_colours.booleanValue()) {
                    grid_image.fill(group.outline_colour);
                } else {
                    grid_image.fill(color_fg);
                }
                grid_image.text(name_text, text_position.x, text_position.y);
                grid_image.popStyle();
            }
            if (this.project.pref_export_show_info_overlay.booleanValue() && (grid_type.equals("pixel") || group.id == 0)) {
                float credits_origin_x;
                float credits_origin_y = credits_origin_x = grid_cell_pixels / 2.0f;
                text_size = Display_Builder_4.max((int)10, (int)Display_Builder_4.round((float)(display_shortest_dimension / 45.0f)));
                grid_image.textSize((float)text_size);
                grid_image.textAlign(37, 101);
                grid_image.fill(this.ui.colour_get_by_name("matkeane"));
                StringList credits_text_list = new StringList();
                String credits_text = "Alignment grid generated by " + this.app_title + " (app v" + this.app_version + ")";
                credits_text_list.append(credits_text);
                credits_text = "Projection surface dimensions: " + grid_surface_width + "x" + grid_surface_height + " pixels";
                if (grid_type.equals("physical")) {
                    credits_text = String.valueOf(credits_text) + ", " + Display_Builder_4.nf((float)grid_surface_width_physical, (int)1, (int)2) + "x" + Display_Builder_4.nf((float)grid_surface_height_physical, (int)1, (int)2) + " metres";
                    credits_origin_y = credits_origin_x = grid_cell_pixels;
                }
                credits_text_list.append(credits_text);
                if (this.project.pref_export_grid_show_alignment.booleanValue()) {
                    credits_text = "Grid cell dimensions: " + Display_Builder_4.nf((float)(grid_cell_pixels * image_scale), (int)0, (int)1) + " pixels";
                    if (this.project.pref_export_grid_marker_interval != 0) {
                        credits_text = String.valueOf(credits_text) + credits_text_markers;
                    }
                    credits_text_list.append(credits_text);
                }
                int credits_text_char_count = 0;
                int i = 0;
                while (i < credits_text_list.size()) {
                    String credits_text_list_line = credits_text_list.get(i);
                    credits_text_char_count = Display_Builder_4.max((int)credits_text_char_count, (int)credits_text_list_line.length());
                    ++i;
                }
                float credits_text_lines = (float)credits_text_list.size() * 1.5f;
                credits_text = this.convert_stringlist_to_string(credits_text_list);
                grid_image.fill(0.0f, 0.0f, 0.0f, 150.0f);
                grid_image.noStroke();
                grid_image.rectMode(0);
                grid_image.rect(credits_origin_x, credits_origin_y, (float)Display_Builder_4.round((float)((float)credits_text_char_count * ((float)text_size * 0.55f))), (float)Display_Builder_4.round((float)(credits_text_lines * (float)text_size)));
                grid_image.fill(255);
                grid_image.text(credits_text, credits_origin_x, credits_origin_y);
            }
            if (grid_type.equals("pixel")) {
                grid_image.endDraw();
                String image_filepath = String.valueOf(this.export_manager.export_folder_filepath) + image_filename;
                if (grid_image.save(image_filepath)) {
                    MixedInputResult file_status = new MixedInputResult(true, image_scale, image_filepath);
                    return file_status;
                }
                return null;
            }
        } else {
            this.debug_output("Error: Projection surface exceeds available memory - no image created.");
        }
        return null;
    }

    public void render_softedge_area(DisplayGroup parent_displaygroup, DisplayObject display, PGraphics grid_image, String grid_type, int[] softedge_coords, int color_bg, int color_fg, int color_mid) {
        PVector softedge_dimensions = this.dimensions_from_bounds(softedge_coords);
        String[] text_lines = new String[]{"Display", "Builder"};
        if (softedge_dimensions.x > 1.0f && softedge_dimensions.y > 1.0f) {
            this.pushStyle();
            grid_image.fill(display.outline_colour, 50.0f);
            grid_image.stroke(color_fg);
            grid_image.rectMode(1);
            grid_image.rect((float)softedge_coords[3], (float)softedge_coords[0], (float)softedge_coords[1], (float)softedge_coords[2]);
            if (grid_type.equals("pixel")) {
                int dash_length = 10;
                int dash_count = Display_Builder_4.round((float)(Display_Builder_4.max((float)softedge_dimensions.x, (float)softedge_dimensions.y) / (float)(dash_length * 1)));
                PVector softedge_centreline_origin = new PVector((float)(softedge_coords[3] + dash_length), (float)softedge_coords[0] + softedge_dimensions.y * 0.5f);
                PVector softedge_centreline_target = new PVector((float)softedge_coords[1], softedge_centreline_origin.y);
                if (softedge_dimensions.y > softedge_dimensions.x) {
                    softedge_centreline_origin.x = (float)softedge_coords[3] + softedge_dimensions.x * 0.5f;
                    softedge_centreline_origin.y = softedge_coords[0] + dash_length;
                    softedge_centreline_target.x = softedge_centreline_origin.x;
                    softedge_centreline_target.y = softedge_coords[2];
                }
                PVector dash_origin = new PVector(0.0f, 0.0f);
                PVector dash_target = new PVector(0.0f, 0.0f);
                int i = 0;
                while (i < dash_count) {
                    Float dash_segment = Float.valueOf((float)i / PApplet.parseFloat((int)dash_count));
                    dash_origin.x = Display_Builder_4.lerp((float)softedge_centreline_origin.x, (float)softedge_centreline_target.x, (float)dash_segment.floatValue());
                    dash_origin.y = Display_Builder_4.lerp((float)softedge_centreline_origin.y, (float)softedge_centreline_target.y, (float)dash_segment.floatValue());
                    dash_segment = Float.valueOf((float)(i + 1) / PApplet.parseFloat((int)dash_count));
                    dash_target.x = Display_Builder_4.lerp((float)softedge_centreline_origin.x, (float)softedge_centreline_target.x, (float)dash_segment.floatValue());
                    dash_target.y = Display_Builder_4.lerp((float)softedge_centreline_origin.y, (float)softedge_centreline_target.y, (float)dash_segment.floatValue());
                    grid_image.line(dash_origin.x, dash_origin.y, dash_target.x, dash_target.y);
                    i += 2;
                }
                if (this.project.pref_export_show_softedge_text.booleanValue() && parent_displaygroup.softedge_dimensions.x == 0.0f && parent_displaygroup.softedge_dimensions.y == 0.0f) {
                    grid_image.pushMatrix();
                    grid_image.textAlign(3, 3);
                    grid_image.fill(color_mid);
                    int text_size_col = Display_Builder_4.max((int)100, (int)Display_Builder_4.round((float)(softedge_dimensions.x * 0.3f)));
                    int text_size_row = Display_Builder_4.max((int)100, (int)Display_Builder_4.round((float)(softedge_dimensions.y * 0.5f)));
                    PVector text_repeat_count = new PVector(2.0f, softedge_dimensions.y / (float)text_size_col);
                    PVector text_origin_offset = new PVector(0.0f, (float)text_size_col * 0.1f);
                    PVector text_origin_column = new PVector((float)softedge_coords[3] + softedge_dimensions.x * 0.5f, softedge_centreline_origin.y + softedge_dimensions.y / 2.0f - ((float)Display_Builder_4.floor((float)(text_repeat_count.y / 2.0f)) * PApplet.parseFloat((int)text_size_col) + text_origin_offset.y));
                    PVector text_spacing = new PVector(softedge_dimensions.x / 4.0f, (float)text_size_col);
                    if (softedge_dimensions.x > softedge_dimensions.y) {
                        text_repeat_count.y = 1.0f;
                        text_origin_column.y = (float)softedge_coords[0] + softedge_dimensions.y * 0.5f;
                        text_spacing.y = 0.0f;
                        grid_image.textSize((float)text_size_row);
                    } else {
                        text_repeat_count.x = 1.0f;
                        text_spacing.x = 0.0f;
                        grid_image.textSize((float)text_size_col);
                    }
                    int text_index = display.display_id % 2;
                    float ypos = 0.0f;
                    int text_row = 0;
                    while ((float)text_row < text_repeat_count.y) {
                        ypos = text_origin_column.y + (float)text_row * text_spacing.y;
                        grid_image.text(text_lines[text_index % 2], text_origin_column.x - text_spacing.x, ypos);
                        ++text_index;
                        if (ypos + text_spacing.y < (float)softedge_coords[2]) {
                            grid_image.text(text_lines[text_index % 2], text_origin_column.x + text_spacing.x, ypos + text_spacing.y);
                        }
                        ++text_index;
                        text_row += 2;
                    }
                    grid_image.popMatrix();
                }
            }
            this.popStyle();
        } else if (parent_displaygroup.display_cols * parent_displaygroup.display_rows == 1) {
            grid_image.pushStyle();
            int text_size = Display_Builder_4.round((float)(Display_Builder_4.min((float)display.stage_footprint.x, (float)display.stage_footprint.y) / 6.0f));
            float ypos = display.stage_footprint.y * 0.5f + (float)text_size * 0.33f;
            grid_image.fill(color_fg);
            grid_image.textSize((float)text_size);
            grid_image.text(text_lines[0], display.stage_footprint.x * 0.25f, ypos);
            grid_image.text(text_lines[1], display.stage_footprint.x * 0.75f, ypos);
            grid_image.popStyle();
        }
    }

    public void display_render_grid_outline(DisplayGroup parent_displaygroup, DisplayObject display, PGraphics grid_image, String grid_type, float image_scale, PVector origin_offset, PVector grid_origin_marker) {
        int display_size_h = display.stage_bounds[1] - display.stage_bounds[3];
        int display_size_v = display.stage_bounds[2] - display.stage_bounds[0];
        float circle_width = Display_Builder_4.min((int)display_size_h, (int)display_size_v);
        float cross_size = circle_width * 0.05f;
        int text_size = Display_Builder_4.round((float)(Display_Builder_4.min((float)display.stage_footprint.x, (float)display.stage_footprint.y) / 3.5f));
        PVector text_position = new PVector(display.position.x, display.position.y - cross_size * 4.5f);
        int text_shadow_offset = 2;
        int display_shortest_dimension = Display_Builder_4.min((int)grid_image.width, (int)grid_image.height);
        int color_fg = this.color(255, 255, 255, 255);
        grid_image.noFill();
        grid_image.stroke(color_fg);
        if (this.project.pref_export_grid_use_display_colours.booleanValue()) {
            grid_image.stroke(display.outline_colour);
        } else {
            grid_image.stroke(color_fg);
        }
        grid_image.pushMatrix();
        grid_image.translate(origin_offset.x * image_scale, origin_offset.y * image_scale);
        grid_image.scale(image_scale);
        grid_image.ellipseMode(3);
        grid_image.ellipse(display.position.x, display.position.y, circle_width, circle_width);
        grid_image.rectMode(0);
        if (parent_displaygroup.display_colour_mode == 4) {
            grid_image.fill(display.outline_colour);
        }
        grid_image.rect((float)display.stage_bounds[3], (float)display.stage_bounds[0], (float)display_size_h, (float)display_size_v);
        grid_image.noFill();
        grid_image.line((float)display.stage_bounds[3], (float)display.stage_bounds[0], (float)display.stage_bounds[1], (float)display.stage_bounds[2]);
        grid_image.line((float)display.stage_bounds[3], (float)display.stage_bounds[2], (float)display.stage_bounds[1], (float)display.stage_bounds[0]);
        grid_image.line((float)display.stage_bounds[3], display.position.y, (float)display.stage_bounds[1], display.position.y);
        grid_image.line(display.position.x, (float)display.stage_bounds[0], display.position.x, (float)display.stage_bounds[2]);
        grid_image.ellipseMode(3);
        grid_image.ellipse(display.position.x, display.position.y, cross_size, cross_size);
        grid_image.textSize((float)text_size);
        grid_image.textAlign(3, 3);
        grid_image.fill(0);
        StringList display_id_text_elements = new StringList();
        if (this.project.pref_export_show_displaygroup_id.booleanValue() && this.project.display_groups.size() > 1) {
            display_id_text_elements.append(Display_Builder_4.nf((float)this.get_number_from_id(display.parent_displaygroup_id), (int)0, (int)0));
        }
        if (this.project.pref_export_show_display_id.booleanValue()) {
            display_id_text_elements.append(Display_Builder_4.nf((float)this.get_number_from_id(display.display_id), (int)0, (int)0));
        }
        String display_id_text = Display_Builder_4.join((String[])display_id_text_elements.array(), (String)"-");
        grid_image.text(display_id_text, text_position.x + (float)text_shadow_offset, text_position.y + (float)text_shadow_offset);
        if (this.project.pref_export_grid_use_display_colours.booleanValue() && parent_displaygroup.display_colour_mode != 4) {
            grid_image.fill(display.outline_colour);
        } else {
            grid_image.fill(color_fg);
        }
        grid_image.text(display_id_text, text_position.x, text_position.y);
        if (this.project.pref_export_show_display_coordinates.booleanValue() || this.project.pref_export_show_column_row_numbers.booleanValue()) {
            this.stage_to_surface(display.position);
            PVector display_footprint = display.footprint_get();
            String display_coordinates_text = "";
            text_size = Display_Builder_4.max((int)12, (int)Display_Builder_4.round((float)(display_shortest_dimension / 45)));
            grid_image.textSize((float)text_size);
            grid_image.textAlign(3, 3);
            if (this.project.pref_export_show_column_row_numbers.booleanValue()) {
                display_coordinates_text = "[";
                display_coordinates_text = this.project.current_displaygroup.display_invert_cols_rows == false ? String.valueOf(display_coordinates_text) + "c" + this.get_number_from_id(display.col_id) + ",r" + this.get_number_from_id(display.row_id) : String.valueOf(display_coordinates_text) + "r" + this.get_number_from_id(display.row_id) + ",c" + this.get_number_from_id(display.col_id);
                display_coordinates_text = String.valueOf(display_coordinates_text) + "]";
            }
            if (this.project.pref_export_show_display_coordinates.booleanValue()) {
                if (this.project.pref_export_show_column_row_numbers.booleanValue()) {
                    display_coordinates_text = String.valueOf(display_coordinates_text) + " ";
                }
                if (grid_type.equals("pixel")) {
                    display_coordinates_text = String.valueOf(display_coordinates_text) + "(" + Display_Builder_4.round((float)display.position.x) + ", " + Display_Builder_4.round((float)display.position.y) + ")";
                }
            }
            text_position.x = display.position.x;
            text_position.y = display_footprint.y < 500.0f ? display.position.y + display_footprint.y * 0.25f : display.position.y + (float)(text_size * 3);
            text_shadow_offset = 1;
            this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
            if (grid_type.equals("physical") && this.project.pref_export_show_display_coordinates.booleanValue()) {
                PVector text_position_offset = this.alignment_id_as_vector(this.project.physical_grid.alignment_id).mult(this.physical_to_pixels(0.5f));
                int[] surface_bounds_project = this.project.projection_surface_bounds_get();
                if (parent_displaygroup.display_type == this.project.LED_PANEL || parent_displaygroup.display_type == this.project.DISPLAY_VIRTUAL) {
                    if (display.col_id == 0 && display.row_id == 0) {
                        PVector displaygroup_dimensions = parent_displaygroup.projection_surface_dimensions_get();
                        text_position.x = parent_displaygroup.projection_surface_bounds[3];
                        if (text_position.x == 0.0f || text_position.x == (float)surface_bounds_project[3]) {
                            grid_image.textAlign(37, 3);
                        } else {
                            grid_image.textAlign(3, 3);
                        }
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[0]) + "\n" + Display_Builder_4.nfp((float)this.pixels_to_physical(text_position.x - grid_origin_marker.x), (int)0, (int)2) + "m\n" + this.ui.symbol_arrow_strings[2];
                        text_position.y = grid_origin_marker.y + text_position_offset.y;
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        text_position.x = (float)parent_displaygroup.projection_surface_bounds[3] + displaygroup_dimensions.x * 0.5f;
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[0]) + "\n" + Display_Builder_4.nfp((float)this.pixels_to_physical(text_position.x - grid_origin_marker.x), (int)0, (int)2) + "m\n" + this.ui.symbol_arrow_strings[2];
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        text_position.x = parent_displaygroup.projection_surface_bounds[1] + 1;
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[0]) + "\n" + Display_Builder_4.nfp((float)this.pixels_to_physical(text_position.x - grid_origin_marker.x), (int)0, (int)2) + "m\n" + this.ui.symbol_arrow_strings[2];
                        if (text_position.x >= (float)surface_bounds_project[1]) {
                            grid_image.textAlign(39, 3);
                        } else {
                            grid_image.textAlign(3, 3);
                        }
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        text_position_offset = this.alignment_id_as_vector(parent_displaygroup.anchor_alignment_id).mult(this.physical_to_pixels(-0.5f));
                        text_position.x = parent_displaygroup.anchor_point.x + text_position_offset.x;
                        text_position.y = parent_displaygroup.projection_surface_bounds[0];
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[3]) + " " + Display_Builder_4.nfp((float)this.pixels_to_physical(text_position.y - grid_origin_marker.y), (int)0, (int)2) + "m" + this.ui.symbol_arrow_strings[1];
                        if (text_position.y == 0.0f || text_position.y == (float)surface_bounds_project[0]) {
                            grid_image.textAlign(3, 101);
                        } else {
                            grid_image.textAlign(3, 3);
                        }
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        text_position.y = (float)parent_displaygroup.projection_surface_bounds[0] + displaygroup_dimensions.y * 0.5f;
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[3]) + " " + Display_Builder_4.nfp((float)this.pixels_to_physical(text_position.y - grid_origin_marker.y), (int)0, (int)2) + "m " + this.ui.symbol_arrow_strings[1];
                        grid_image.textAlign(3, 3);
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        text_position.y = parent_displaygroup.projection_surface_bounds[2] + 1;
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[3]) + " " + Display_Builder_4.nfp((float)this.pixels_to_physical(text_position.y - grid_origin_marker.y), (int)0, (int)2) + "m " + this.ui.symbol_arrow_strings[1];
                        if (text_position.y >= (float)surface_bounds_project[2]) {
                            grid_image.textAlign(3, 102);
                        } else {
                            grid_image.textAlign(3, 3);
                        }
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                    }
                } else {
                    float dash_target;
                    float dash_origin;
                    int dash_length;
                    Float softedge_centre;
                    if (this.get_number_from_id(display.row_id) == parent_displaygroup.display_rows) {
                        text_shadow_offset = 1;
                        text_position.y = display.position.y;
                        text_position.y += grid_origin_marker.y - display.position.y - (float)Integer.signum(Display_Builder_4.round((float)(display.position.y - grid_origin_marker.y))) * this.physical_to_pixels(0.5f);
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[0]) + "\n" + Display_Builder_4.nfp((float)this.pixels_to_physical((float)display.stage_bounds[3] - grid_origin_marker.x), (int)0, (int)2) + "m\n" + this.ui.symbol_arrow_strings[2];
                        text_position.x = display.stage_bounds[3];
                        text_position.y = Display_Builder_4.min((float)grid_origin_marker.y, (float)surface_bounds_project[2]);
                        text_position.y = Display_Builder_4.max((float)text_position.y, (float)surface_bounds_project[0]);
                        text_position.y += text_position_offset.y;
                        if (display.col_id == 0) {
                            grid_image.textAlign(37, 3);
                        } else {
                            grid_image.textAlign(3, 3);
                        }
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[0]) + "\n" + Display_Builder_4.nfp((float)this.pixels_to_physical((float)display.stage_bounds[1] - grid_origin_marker.x), (int)0, (int)2) + "m\n" + this.ui.symbol_arrow_strings[2];
                        text_position.x = display.stage_bounds[1];
                        if (this.get_number_from_id(display.col_id) == parent_displaygroup.display_cols) {
                            grid_image.textAlign(39, 3);
                        } else {
                            grid_image.textAlign(3, 3);
                        }
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[0]) + "\n" + Display_Builder_4.nfp((float)this.pixels_to_physical(display.position.x - grid_origin_marker.x), (int)0, (int)2) + "m\n" + this.ui.symbol_arrow_strings[2];
                        text_position.x = display.position.x;
                        grid_image.textAlign(3, 3);
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        if (parent_displaygroup.softedge_dimensions.x != 0.0f && this.get_number_from_id(display.col_id) < parent_displaygroup.display_cols) {
                            softedge_centre = Float.valueOf((float)display.stage_bounds[1] - parent_displaygroup.softedge_dimensions.x / 2.0f);
                            dash_length = 10;
                            dash_origin = display.stage_bounds[0];
                            dash_target = display.stage_bounds[2];
                            grid_image.pushStyle();
                            grid_image.stroke(this.color(255, 255, 255, 180));
                            while (dash_origin < dash_target) {
                                grid_image.line(softedge_centre.floatValue(), dash_origin, softedge_centre.floatValue(), dash_origin + (float)dash_length);
                                dash_origin += (float)(dash_length * 2);
                            }
                            grid_image.popStyle();
                            display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[0]) + "\n" + Display_Builder_4.nfp((float)this.pixels_to_physical(softedge_centre.floatValue() - grid_origin_marker.x), (int)0, (int)2) + "m\n" + this.ui.symbol_arrow_strings[2];
                            text_position.x = softedge_centre.floatValue();
                            grid_image.textAlign(3, 3);
                            this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        }
                    }
                    if (display.col_id == 0 || this.get_number_from_id(display.col_id) == parent_displaygroup.display_cols) {
                        text_shadow_offset = 1;
                        text_position.x = display.col_id == 0 ? (float)display.stage_bounds[3] + this.physical_to_pixels(1.0f) : (float)display.stage_bounds[1] - this.physical_to_pixels(1.0f);
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[3]) + " " + Display_Builder_4.nfp((float)this.pixels_to_physical((float)display.stage_bounds[0] - grid_origin_marker.y), (int)0, (int)2) + "m " + this.ui.symbol_arrow_strings[1];
                        text_position.y = display.stage_bounds[0];
                        if (display.row_id == 0) {
                            grid_image.textAlign(3, 101);
                        } else {
                            grid_image.textAlign(3, 3);
                        }
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[3]) + " " + Display_Builder_4.nfp((float)this.pixels_to_physical((float)display.stage_bounds[2] - grid_origin_marker.y), (int)0, (int)2) + "m " + this.ui.symbol_arrow_strings[1];
                        text_position.y = display.stage_bounds[2];
                        if (this.get_number_from_id(display.row_id) == parent_displaygroup.display_rows) {
                            grid_image.textAlign(3, 102);
                        } else {
                            grid_image.textAlign(3, 3);
                        }
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        display_coordinates_text = String.valueOf(this.ui.symbol_arrow_strings[3]) + " " + Display_Builder_4.nfp((float)this.pixels_to_physical(display.position.y - grid_origin_marker.y), (int)0, (int)2) + "m " + this.ui.symbol_arrow_strings[1];
                        text_position.y = display.position.y;
                        grid_image.textAlign(3, 3);
                        this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        if (parent_displaygroup.softedge_dimensions.y != 0.0f && this.get_number_from_id(display.row_id) < parent_displaygroup.display_rows) {
                            softedge_centre = Float.valueOf((float)display.stage_bounds[2] - parent_displaygroup.softedge_dimensions.y / 2.0f);
                            dash_length = 10;
                            dash_origin = 0.0f - origin_offset.x;
                            dash_target = (float)grid_image.width - origin_offset.x;
                            grid_image.pushStyle();
                            grid_image.stroke(this.color(255, 255, 255, 180));
                            while (dash_origin < dash_target) {
                                grid_image.line(dash_origin, softedge_centre.floatValue(), dash_origin + (float)dash_length, softedge_centre.floatValue());
                                dash_origin += (float)(dash_length * 2);
                            }
                            grid_image.popStyle();
                            display_coordinates_text = "- " + Display_Builder_4.nfp((float)this.pixels_to_physical(softedge_centre.floatValue() - grid_origin_marker.y), (int)0, (int)2) + "m ";
                            text_position.y = softedge_centre.floatValue();
                            grid_image.textAlign(3, 3);
                            this.render_grid_text(grid_image, display_coordinates_text, text_position, text_size);
                        }
                    }
                }
            }
        }
        grid_image.popMatrix();
    }

    public void render_grid_text(PGraphics grid_image, String text_string, PVector text_position, int text_size) {
        if (!text_string.trim().equals("")) {
            boolean text_shadow_offset = true;
            int[] nArray = new int[2];
            nArray[0] = 255;
            int[] txt_colours = nArray;
            if (this.project.pref_export_grid_invert_colour.booleanValue()) {
                txt_colours[0] = 0;
                txt_colours[1] = 255;
            }
            grid_image.textSize((float)text_size);
            grid_image.textLeading((float)text_size * 1.4f);
            grid_image.fill(txt_colours[1]);
            grid_image.text(text_string, text_position.x + (float)text_shadow_offset, text_position.y - (float)text_size * 0.25f + (float)text_shadow_offset);
            grid_image.fill(txt_colours[0]);
            grid_image.text(text_string, text_position.x, text_position.y - (float)text_size * 0.25f);
        }
    }

    public MixedInputResult create_display_reference_grid(int display_id) {
        float export_scale = this.export_manager.max_image_scale_calculate(this.project.current_displaygroup.display_resolution);
        if (export_scale > 0.0f) {
            float grid_num;
            int grid_count;
            float ypos;
            float xpos;
            int res_width = Display_Builder_4.round((float)(this.project.current_displaygroup.resolution.pixel_count.x * export_scale));
            int res_height = Display_Builder_4.round((float)(this.project.current_displaygroup.resolution.pixel_count.y * export_scale));
            float res_width_half = res_width / 2;
            float res_height_half = res_height / 2;
            int grid_cols = this.project.current_displaygroup.resolution.grid_cols;
            int grid_rows = this.project.current_displaygroup.resolution.grid_rows;
            float grid_size_h = PApplet.parseFloat((int)res_width) / (float)grid_cols;
            float grid_size_v = PApplet.parseFloat((int)res_height) / (float)grid_rows;
            int color_fg = this.color(255, 255, 255, 255);
            int color_mid = this.color(255, 255, 255, 110);
            this.debug_output("Rendering Warping grid at " + res_width + "x" + res_height + ", cols: " + grid_cols + " (" + grid_size_h + "px), rows: " + grid_rows + " (" + grid_size_v + "px)");
            String image_filename = "display-warping-grid-" + res_width + "x" + res_height + ".png";
            PGraphics grid_image = this.createGraphics(res_width, res_height);
            if (!this.project.pref_image_export_antialiasing.booleanValue()) {
                grid_image.noSmooth();
            }
            grid_image.beginDraw();
            grid_image.pushMatrix();
            grid_image.fill(0.0f, 0.0f, 0.0f, 0.0f);
            grid_image.stroke(color_fg);
            grid_image.ellipseMode(3);
            float circle_width = Display_Builder_4.min((float)grid_size_h, (float)grid_size_v) * 0.5f;
            grid_image.ellipse(res_width_half, res_height_half, circle_width, circle_width);
            int text_size = Display_Builder_4.round((float)(res_height / 42));
            float box_size = (float)text_size * 1.3f;
            int col = 0;
            while (col < grid_cols) {
                xpos = (float)col * grid_size_h;
                grid_image.stroke(color_fg);
                grid_image.line(xpos, 0.0f, xpos, (float)res_height);
                grid_image.stroke(color_mid);
                grid_image.line(xpos += grid_size_h / 2.0f, 0.0f, xpos, (float)res_height);
                ++col;
            }
            grid_image.line((float)(res_width - 1), 0.0f, (float)(res_width - 1), (float)res_height);
            int row = 0;
            while (row < grid_rows) {
                ypos = (float)row * grid_size_v;
                grid_image.stroke(color_fg);
                grid_image.line(0.0f, ypos, (float)res_width, ypos);
                grid_image.stroke(color_mid);
                grid_image.line(0.0f, ypos += grid_size_v / 2.0f, (float)res_width, ypos);
                ++row;
            }
            grid_image.stroke(color_fg);
            grid_image.rectMode(0);
            grid_image.rect(0.0f, 0.0f, (float)(res_width - 1), (float)(res_height - 1));
            grid_image.stroke(color_fg);
            grid_image.line(0.0f, 0.0f, (float)res_width, (float)res_height);
            grid_image.line(0.0f, (float)res_height, (float)res_width, 0.0f);
            col = 0;
            while (col < grid_cols) {
                xpos = (float)col * grid_size_h;
                grid_count = grid_cols / 2;
                if (col > 0 && col != grid_count) {
                    grid_num = Display_Builder_4.map((float)col, (float)0.0f, (float)grid_cols, (float)(grid_count * -1), (float)grid_count);
                    grid_image.rectMode(3);
                    grid_image.fill(255);
                    grid_image.rect(xpos, (float)(res_height / 2), box_size, box_size);
                    grid_image.textSize((float)text_size);
                    grid_image.textAlign(3);
                    grid_image.fill(0);
                    grid_image.text(Display_Builder_4.nf((float)grid_num, (int)1, (int)0), xpos, (float)(res_height / 2) + (float)text_size / 2.5f);
                }
                ++col;
            }
            row = 0;
            while (row < grid_rows) {
                ypos = (float)row * grid_size_v;
                grid_count = grid_rows / 2;
                if (row > 0 && row != grid_count) {
                    grid_num = Display_Builder_4.map((float)row, (float)0.0f, (float)grid_rows, (float)(grid_count * -1), (float)grid_count);
                    grid_image.rectMode(3);
                    grid_image.fill(255);
                    grid_image.rect((float)(res_width / 2), ypos, box_size, box_size);
                    grid_image.textSize((float)text_size);
                    grid_image.textAlign(3);
                    grid_image.fill(0);
                    grid_image.text(Display_Builder_4.nf((float)grid_num, (int)1, (int)0), (float)(res_width / 2), ypos + (float)text_size / 2.5f);
                }
                ++row;
            }
            grid_image.popMatrix();
            grid_image.endDraw();
            String image_filepath = String.valueOf(this.export_manager.export_folder_filepath) + image_filename;
            if (grid_image.save(image_filepath)) {
                MixedInputResult file_status = new MixedInputResult(true, export_scale, image_filepath);
                return file_status;
            }
            return null;
        }
        this.debug_output("Error: Image size exceeds available memory - no image created.");
        return null;
    }

    public void controlEvent(ControlEvent theEvent) {
        if (this.ui.ready.booleanValue()) {
            if (theEvent.isController()) {
                theEvent.controller();
            } else if (theEvent.isTab()) {
                this.debug_output("got an event from tab : " + theEvent.getTab().getName() + " with id " + theEvent.getTab().getId());
                this.ui.active_tab_id_set(theEvent.getTab().getId());
            } else {
                ControlGroup ui_control_group = theEvent.group();
                this.debug_output("UI Control event from group: " + ui_control_group.getName() + ", isOpen " + theEvent.getGroup().isOpen());
                if (theEvent.group().getName() == "radio_physical_grid_alignment") {
                    this.project.physical_grid_alignment_id_set(Display_Builder_4.round((float)theEvent.getValue()));
                }
                if (theEvent.group().getName() == "radio_displaygroup_origin") {
                    this.project.displaygroup_origin_alignment_id_set(theEvent.getValue());
                }
                if (theEvent.group().getName() == "radio_displaygroup_alignment") {
                    this.project.displaygroup_parent_alignment_id_set(theEvent.getValue());
                }
            }
        }
    }

    public void bang_display_aspect_locked() {
        this.project.current_displaygroup.display_aspect_ratio_lock_toggle();
        this.ui_elements.update_display_dimensions();
    }

    public void bang_guide_locked() {
        if (this.project.current_guide != null) {
            this.project.current_guide.toggle_lock();
        }
    }

    public void bang_swatch_display_outline() {
        this.ui.colour_swatch_clicked(1);
    }

    public void bang_swatch_grid_physical() {
        this.ui.colour_swatch_clicked(4);
    }

    public void bang_swatch_grid_pixel() {
        this.ui.colour_swatch_clicked(2);
    }

    public void bang_swatch_guide() {
        this.ui.colour_swatch_clicked(5);
    }

    public void bang_swatch_surface() {
        this.ui.colour_swatch_clicked(3);
    }

    public void button_display_col_subtract() {
        this.project.current_displaygroup.display_count_increment("h", -1);
    }

    public void button_display_col_add() {
        this.project.current_displaygroup.display_count_increment("h", 1);
    }

    public void button_display_data_copy() {
        this.export_manager.export_display_data_to_clipboard();
    }

    public void button_display_data_export() {
        this.ui.select_export_folder();
    }

    public void button_resolution_preset_add() {
        String res_width = ((Textfield)this.ui_elements.controls.get(Textfield.class, "textfield_display_width_resolution")).getText();
        String res_height = ((Textfield)this.ui_elements.controls.get(Textfield.class, "textfield_display_height_resolution")).getText();
        if (this.is_integer(res_width) && this.is_integer(res_height)) {
            this.project.resolution_preset_add_custom(Integer.valueOf(res_width), Integer.valueOf(res_height));
        }
    }

    public void button_display_row_subtract() {
        this.project.current_displaygroup.display_count_increment("v", -1);
    }

    public void button_display_row_add() {
        this.project.current_displaygroup.display_count_increment("v", 1);
    }

    public void button_display_group_add() {
        this.project.displaygroup_add_or_copy(-1);
    }

    public void button_display_group_duplicate() {
        this.project.displaygroup_add_or_copy(this.project.current_displaygroup_id);
    }

    public void button_display_group_delete() {
        this.project.displaygroup_current_delete();
    }

    public void button_export_lineup_grid_fit_squares() {
        this.project.export_lineup_grid_fit_squares();
    }

    public void button_guide_delete() {
        this.project.guide_delete();
    }

    public void button_guide_line_add() {
        this.project.guideline_add();
    }

    public void button_guide_line_add_auto() {
        this.project.guideline_add_auto();
    }

    public void button_guide_image_load() {
        this.selectInput("Please choose an image file", "guide_image_file_check");
    }

    public void button_invert_cols_rows_layout() {
        this.project.current_displaygroup.display_layout_order_invert();
    }

    public void button_link_matkeane() {
        this.link(this.web_button_url);
        this.clipboard_contents_set(this.web_button_url);
    }

    public void button_obj_surface_load() {
        this.selectInput("Please choose an OBJ file", "check_project_file");
    }

    public void button_origin_offset_reset() {
        this.project.current_displaygroup.parent_offset_reset();
    }

    public void button_preview_tier_add() {
        this.project.preview_tier_add();
    }

    public void button_project_load_mode() {
        this.project.toggle_project_load_mode();
    }

    public void button_project_load() {
        this.selectInput("Please choose a Display Builder project file", "check_project_file");
    }

    public void button_project_physical_scale_set() {
        this.project.viewport_physical_scale_set_from_current_displaygroup();
    }

    public void button_project_reset() {
        this.project.reset();
    }

    public void button_project_save() {
        this.ui.select_project_save_folder();
    }

    public void button_stagesize_round() {
        this.project.current_displaygroup.stage_scale_set(this.project.current_displaygroup.stage_scale, true);
    }

    public void button_stagesize_reset() {
        this.project.current_displaygroup.stage_scale_calculate("reset", "");
    }

    public void button_stagetier_add() {
        this.project.stage_tier_add();
    }

    public void button_stagetier_delete() {
        this.project.stage_tier_delete();
    }

    public void button_surface_mode() {
        this.project.surface_mode_toggle();
    }

    public void button_surface_fit() {
        this.project.current_displaygroup.displays_fit_to_surface();
    }

    public void knob_display_rotation(float knob_value) {
        if (this.project.current_displaygroup != null) {
            this.project.current_displaygroup.rotation_set_radians(knob_value);
        }
    }

    public void knob_guide_rotation(float knob_value) {
        if (this.project.current_guide != null) {
            this.project.current_guide.rotation_set(knob_value - 1.5707964f);
        }
    }

    public void menu_display_colour_options(int menu_id) {
        this.project.current_displaygroup.colour_setting_update(menu_id);
    }

    public void menu_displaygroups(int menu_id) {
        this.debug_output("UI DisplayGroup menu, selected entry: " + menu_id);
        this.project.displaygroup_select(menu_id);
    }

    public void menu_displaygroup_parent(int menu_id) {
        this.debug_output("UI menu_displaygroup_parent, selected entry: " + menu_id);
        this.project.displaygroup_parent_id_set(menu_id - 1);
    }

    public void menu_export_format(int menu_id) {
        this.debug_output("UI Export Format menu, selected entry: " + menu_id);
        this.export_manager.export_format_select_from_menu_entry(menu_id);
    }

    public void menu_export_grid_unit(int menu_id) {
        this.project.export_lineup_grid_unit_change(menu_id);
    }

    public void menu_guide_image(int menu_id) {
        this.project.guide_select(menu_id);
    }

    public void menu_guide_parent(int menu_id) {
        this.debug_output("UI menu_guide_parent, selected entry: " + menu_id);
        int offset_menu_id = menu_id - 1;
        this.project.guide_parent_set(offset_menu_id);
    }

    public void menu_resolution_presets(int menu_id) {
        this.debug_output("UI Resolution menu, selected entry: " + menu_id);
        if (this.project.pref_resolution_list_order_invert.booleanValue()) {
            menu_id = this.project.resolutions_list.size() - 1 - menu_id;
            this.debug_output("Inverted UI Resolution menu entry: " + menu_id);
        }
        this.project.current_displaygroup.resolution_set_by_id(menu_id);
    }

    public void menu_stagetiers(int menu_id) {
        this.debug_output("UI StageTier menu, selected entry: " + menu_id);
        this.project.stage_tier_select(menu_id);
    }

    public void slider_guide_opacity(float slider_value) {
        this.project.current_guide.opacity_set(slider_value);
    }

    public void slider_image_scale(float slider_value) {
        this.project.current_guide.scale_set(slider_value);
    }

    public void slider_stage_scale(float slider_value) {
        this.ui.stage_scale_set(slider_value);
    }

    public void textfield_display_baseip(String ui_text) {
        this.project.current_displaygroup.display_baseip_set(ui_text);
    }

    public void textfield_display_basename(String ui_text) {
        this.project.current_displaygroup.display_basename_set(ui_text);
    }

    public void textfield_display_count_h(String ui_text) {
        this.project.current_displaygroup.display_count_set("h", Display_Builder_4.round((float)this.parse_math_string_expression(ui_text)));
    }

    public void textfield_display_count_v(String ui_text) {
        this.project.current_displaygroup.display_count_set("v", Display_Builder_4.round((float)this.parse_math_string_expression(ui_text)));
    }

    public void textfield_display_group_name(String ui_text) {
        if (this.project.current_displaygroup != null) {
            this.project.current_displaygroup.group_name_set(ui_text);
        }
    }

    public void textfield_display_height_physical(String ui_text) {
        this.project.current_displaygroup.group_physical_dimensions_update("textfield_display_height_physical", ui_text);
    }

    public void textfield_display_height_resolution(String ui_text) {
        this.project.current_displaygroup.resolution_set_value("textfield_display_height_resolution", ui_text);
    }

    public void textfield_display_height_stage(String ui_text) {
        this.project.current_displaygroup.stage_scale_calculate("textfield_display_height_stage", ui_text);
    }

    public void textfield_display_width_physical(String ui_text) {
        this.project.current_displaygroup.group_physical_dimensions_update("textfield_display_width_physical", ui_text);
    }

    public void textfield_display_width_resolution(String ui_text) {
        this.project.current_displaygroup.resolution_set_value("textfield_display_width_resolution", ui_text);
    }

    public void textfield_display_width_stage(String ui_text) {
        this.project.current_displaygroup.stage_scale_calculate("textfield_display_width_stage", ui_text);
    }

    public void textfield_display_startip(String ui_text) {
        int ui_text_as_integer = 0;
        if (this.is_integer(ui_text)) {
            ui_text_as_integer = Integer.parseInt(ui_text);
        }
        this.project.current_displaygroup.player_start_number_set(ui_text_as_integer);
    }

    public void textfield_grid_h_px(String ui_text) {
        this.project.grid_dimensions_ui_update("x", ui_text);
    }

    public void textfield_grid_v_px(String ui_text) {
        this.project.grid_dimensions_ui_update("y", ui_text);
    }

    public void textfield_group_surface_h_physical(String ui_text) {
        this.project.surface_dimensions_physical_ui_update("textfield_group_surface_h_physical", ui_text);
    }

    public void textfield_group_surface_v_physical(String ui_text) {
        this.project.surface_dimensions_physical_ui_update("textfield_group_surface_v_physical", ui_text);
    }

    public void textfield_guide_position_x(String ui_text) {
        this.project.guide_position_update_from_ui("x", ui_text);
    }

    public void textfield_guide_position_y(String ui_text) {
        this.project.guide_position_update_from_ui("y", ui_text);
    }

    public void textfield_lineup_grid_size(String ui_text) {
        this.project.export_lineup_grid_cell_size_set(ui_text);
    }

    public void textfield_lineup_marker_interval(String ui_text) {
        this.project.export_grid_marker_interval_set(ui_text);
    }

    public void textfield_lineup_grid_line_width(String ui_text) {
        this.project.export_lineup_grid_line_width_set(ui_text);
    }

    public void textfield_multi_output(String ui_text) {
        this.project.current_displaygroup.player_outputs_count_set(Display_Builder_4.round((float)this.parse_math_string_expression(ui_text)));
    }

    public void textfield_origin_offset_h_px(String ui_text) {
        this.project.current_displaygroup.parent_offset_ui_input_parse("x", ui_text);
    }

    public void textfield_origin_offset_v_px(String ui_text) {
        this.project.current_displaygroup.parent_offset_ui_input_parse("y", ui_text);
    }

    public void textfield_physical_grid_offset_h(String ui_text) {
        this.project.physical_grid_offset_ui_input_parse("x", ui_text);
    }

    public void textfield_physical_grid_offset_v(String ui_text) {
        this.project.physical_grid_offset_ui_input_parse("y", ui_text);
    }

    public void textfield_project_name(String ui_text) {
        this.project.name_set(ui_text);
    }

    public void textfield_projection_surface_h_px(String ui_text) {
        this.project.target_surface_bounds_calculate("textfield_projection_surface_h_px", ui_text);
    }

    public void textfield_projection_surface_v_px(String ui_text) {
        this.project.target_surface_bounds_calculate("textfield_projection_surface_v_px", ui_text);
    }

    public void textfield_softedge_h_pc(String ui_text) {
        this.project.current_displaygroup.softedge_set_value_from_ui("x", "pc", ui_text);
    }

    public void textfield_softedge_h_physical(String ui_text) {
        this.project.current_displaygroup.softedge_set_value_from_ui("x", "physical", ui_text);
    }

    public void textfield_softedge_h_px(String ui_text) {
        this.project.current_displaygroup.softedge_set_value_from_ui("x", "px", ui_text);
    }

    public void textfield_softedge_v_pc(String ui_text) {
        this.project.current_displaygroup.softedge_set_value_from_ui("y", "pc", ui_text);
    }

    public void textfield_softedge_v_physical(String ui_text) {
        this.project.current_displaygroup.softedge_set_value_from_ui("y", "physical", ui_text);
    }

    public void textfield_softedge_v_px(String ui_text) {
        this.project.current_displaygroup.softedge_set_value_from_ui("y", "px", ui_text);
    }

    public void textfield_stagetier_name(String ui_text) {
        if (this.project.current_stage_tier != null) {
            this.project.current_stage_tier.name_set(ui_text, true);
        }
    }

    public void toggle_auto_scale(boolean toggle_status) {
        this.project.toggle_ui_auto_scale(toggle_status);
    }

    public void toggle_current_displaygroup_solo(boolean toggle_status) {
        this.project.pref_ui_show_current_group_only = toggle_status;
    }

    public void toggle_display_info(boolean toggle_status) {
        this.project.pref_ui_show_display_info = toggle_status;
    }

    public void toggle_display_info_crop(boolean toggle_status) {
        this.project.pref_ui_show_display_info_crop = toggle_status;
    }

    public void toggle_displaygroup_43_marks(boolean toggle_status) {
        this.project.current_displaygroup.group_show_43_marks_set(toggle_status);
    }

    public void toggle_mouse_coords_overlay(boolean toggle_status) {
        this.project.pref_ui_show_mouse_coords_overlay = toggle_status;
    }

    public void toggle_overlay_display_spacing(boolean toggle_status) {
        this.project.pref_ui_show_overlay_display_spacing = toggle_status;
    }

    public void toggle_overlay_parent_links(boolean toggle_status) {
        this.project.pref_ui_show_parent_links = toggle_status;
    }

    public void toggle_player_outputs_shared(boolean toggle_status) {
        this.project.current_displaygroup.player_outputs_sharing_toggle(toggle_status);
    }

    public void toggle_ui_scaling(boolean toggle_status) {
        this.project.toggle_ui_scaling(toggle_status);
    }

    public void toggle_view_guideimages(boolean toggle_status) {
        this.project.pref_ui_view_guideimages = toggle_status;
    }

    public void toggle_view_guidelines(boolean toggle_status) {
        this.project.pref_ui_view_guidelines = toggle_status;
    }

    public void toggle_view_ui_grid_pixel(boolean toggle_status) {
        this.project.pref_ui_toggle_show_layout_grid = toggle_status;
    }

    public void toggle_view_ui_grid_physical(boolean toggle_status) {
        this.project.toggle_physical_grid_visibility(toggle_status);
    }

    public void toggle_export_colourbars(boolean toggle_status) {
        this.project.pref_export_colourbars = toggle_status;
    }

    public void toggle_export_display_data(boolean toggle_status) {
        this.project.pref_export_display_data = toggle_status;
    }

    public void toggle_export_grid_crosshatch_show(boolean toggle_status) {
        this.project.pref_export_grid_crosshatch_show = toggle_status;
    }

    public void toggle_export_grid_show_alignment(boolean toggle_status) {
        this.project.pref_export_grid_show_alignment = toggle_status;
        if (!this.project.pref_export_grid_show_alignment.booleanValue()) {
            this.project.pref_export_grid_show_markers = false;
        }
    }

    public void toggle_export_grid_use_display_colours(boolean toggle_status) {
        this.project.pref_export_grid_use_display_colours = toggle_status;
    }

    public void toggle_export_grid_use_grid_colour(boolean toggle_status) {
        this.project.pref_export_grid_use_grid_colour = toggle_status;
    }

    public void toggle_export_grid_show_markers(boolean toggle_status) {
        this.project.pref_export_grid_show_markers = toggle_status;
        if (!this.project.pref_export_grid_show_alignment.booleanValue()) {
            this.project.pref_export_grid_show_markers = false;
        }
    }

    public void toggle_export_invert_grid_colour(boolean toggle_status) {
        this.project.pref_export_grid_invert_colour = toggle_status;
    }

    public void toggle_export_show_column_row_numbers(boolean toggle_status) {
        this.project.pref_export_show_column_row_numbers = toggle_status;
    }

    public void toggle_export_show_display_coordinates(boolean toggle_status) {
        this.project.pref_export_show_display_coordinates = toggle_status;
    }

    public void toggle_export_show_display_id(boolean toggle_status) {
        this.project.pref_export_show_display_id = toggle_status;
    }

    public void toggle_export_show_displaygroup_id(boolean toggle_status) {
        this.project.pref_export_show_displaygroup_id = toggle_status;
    }

    public void toggle_export_show_displaygroup_name(boolean toggle_status) {
        this.project.pref_export_show_displaygroup_name = toggle_status;
    }

    public void toggle_export_show_softedge_text(boolean toggle_status) {
        this.project.pref_export_show_softedge_text = toggle_status;
    }

    public void toggle_export_pixel_grid(boolean toggle_status) {
        this.project.pref_export_pixel_grid = toggle_status;
    }

    public void toggle_export_physical_grid(boolean toggle_status) {
        this.project.pref_export_physical_grid = toggle_status;
    }

    public void toggle_export_psd_jsx(boolean toggle_status) {
        this.project.pref_export_psd_jsx = toggle_status;
    }

    public void toggle_export_warping_grid(boolean toggle_status) {
        this.project.pref_export_warping_grid = toggle_status;
    }

    public void export_folder_selected(File selection) {
        if (selection == null) {
            this.debug_output("Export window was closed or the user hit cancel.");
        } else {
            String filepath_selected = String.valueOf(selection.getAbsolutePath()) + "/";
            this.debug_output("User selected " + filepath_selected);
            this.export_manager.export_folder_selected_by_user(filepath_selected);
        }
    }

    public void guide_image_file_check(File guide_image_filepath_input) {
        if (guide_image_filepath_input != null) {
            String file_name = guide_image_filepath_input.getName();
            if (this.file_extension_check(file_name, "image").booleanValue()) {
                this.project.guideimage_add(guide_image_filepath_input);
            } else {
                String file_extension = this.file_extension_get(file_name);
                this.debug_output("Error: Cannot load file with extension: " + file_extension);
                String string = "Error: Cannot load file with extension: " + file_extension;
                this.ui.getClass();
                this.ui.osd_message_display(string, 2);
            }
        } else {
            this.debug_output("Error loading Guide image file.");
        }
    }

    public void draw_dashed_line(int origin_x, int origin_y, int target_x, int target_y, int dash_length) {
        float line_length = Display_Builder_4.sqrt((float)(Display_Builder_4.abs((int)(target_x * origin_x)) + Display_Builder_4.abs((int)(target_y * origin_y))));
        line_length = (Display_Builder_4.abs((int)(target_x - origin_x)) + Display_Builder_4.abs((int)(target_y - origin_y))) / 2;
        int dash_count = Display_Builder_4.round((float)(line_length / (float)dash_length));
        PVector dash_origin = new PVector(0.0f, 0.0f);
        PVector dash_target = new PVector(0.0f, 0.0f);
        int i = 0;
        while (i < dash_count) {
            Float dash_segment = Float.valueOf((float)i / PApplet.parseFloat((int)dash_count));
            dash_origin.x = Display_Builder_4.lerp((float)origin_x, (float)target_x, (float)dash_segment.floatValue());
            dash_origin.y = Display_Builder_4.lerp((float)origin_y, (float)target_y, (float)dash_segment.floatValue());
            dash_segment = Float.valueOf((float)(i + 1) / PApplet.parseFloat((int)dash_count));
            dash_target.x = Display_Builder_4.lerp((float)origin_x, (float)target_x, (float)dash_segment.floatValue());
            dash_target.y = Display_Builder_4.lerp((float)origin_y, (float)target_y, (float)dash_segment.floatValue());
            this.line(dash_origin.x, dash_origin.y, dash_target.x, dash_target.y);
            i += 2;
        }
    }

    public void draw_mouse_position() {
        if (!this.ui.mouse_within_ui_pane() && !this.ui.drag_to_pan_active().booleanValue()) {
            this.noFill();
            if (this.ui.transform_mode_selected.booleanValue()) {
                this.stroke(this.ui.colour_get_by_name("ui_mouse_info"));
                int symbol_size = 40;
                if (this.ui.tool_mode < this.ui.MODE_DRAW) {
                    int n = this.ui.tool_mode;
                    this.ui.getClass();
                    if (n != 1) {
                        this.line(this.mouseX, this.mouseY, this.ui.transform_origin.x, this.ui.transform_origin.y);
                    }
                    this.pushMatrix();
                    this.translate(this.ui.transform_origin.x, this.ui.transform_origin.y);
                    this.rectMode(3);
                    int n2 = this.ui.tool_mode;
                    this.ui.getClass();
                    if (n2 == 1) {
                        symbol_size = (int)((float)symbol_size * 0.5f);
                        this.line(symbol_size * -1, 0.0f, symbol_size, 0.0f);
                        this.line(0.0f, symbol_size * -1, 0.0f, symbol_size);
                    }
                    int n3 = this.ui.tool_mode;
                    this.ui.getClass();
                    if (n3 == 2) {
                        this.rotate(this.ui.transform_angle);
                        this.rect(0.0f, 0.0f, symbol_size, symbol_size);
                    }
                    if (this.ui.tool_mode == this.ui.TRANSFORM_SCALE) {
                        this.scale(this.ui.transform_scale.x, this.ui.transform_scale.y);
                        this.rect(0.0f, 0.0f, symbol_size, symbol_size);
                        this.rect(0.0f, 0.0f, (float)symbol_size * 0.6f, (float)symbol_size * 0.6f);
                    }
                    this.popMatrix();
                } else {
                    if (this.ui.tool_mode == this.ui.MODE_DRAW) {
                        this.stroke(this.ui.colour_get_by_name("display_stroke"), 128.0f);
                        this.line(0.0f, this.mouseY, this.width, this.mouseY);
                        this.line(this.mouseX, 0.0f, this.mouseX, this.height);
                        if (this.ui.transform_in_progress.booleanValue()) {
                            this.stroke(this.ui.colour_get_by_name("ui_mouse_info"));
                            this.rectMode(1);
                            this.rect(this.ui.transform_source_position.x, this.ui.transform_source_position.y, this.mouseX, this.mouseY);
                        }
                    }
                    if (this.ui.tool_mode == this.ui.MODE_MEASURE && this.ui.transform_in_progress.booleanValue()) {
                        switch (this.ui.transform_constrain_axis) {
                            case 0: {
                                this.ui.drawing_target.x = this.mouseX;
                                this.ui.drawing_target.y = this.ui.transform_source_position.y;
                                break;
                            }
                            case 1: {
                                this.ui.drawing_target.x = this.ui.transform_source_position.x;
                                this.ui.drawing_target.y = this.mouseY;
                                break;
                            }
                            default: {
                                this.ui.drawing_target.x = this.mouseX;
                                this.ui.drawing_target.y = this.mouseY;
                            }
                        }
                        this.stroke(this.ui.colour_get_by_name("ui_mouse_info"));
                        this.line(this.ui.transform_source_position.x, this.ui.transform_source_position.y, this.ui.drawing_target.x, this.ui.drawing_target.y);
                    }
                }
            }
        }
    }

    public void draw_mouse_crosshairs() {
        if (this.project.pref_ui_show_mouse_coords_overlay.booleanValue() && !this.is_mouse_within_ui_pane()) {
            this.noFill();
            this.stroke(this.ui.colour_get_by_name("display_stroke"));
            this.line(0.0f, this.mouseY - 2, this.width, this.mouseY - 2);
            this.line(this.mouseX - 2, 0.0f, this.mouseX - 2, this.height - (this.ui_elements.pane_height - 1));
        }
    }

    public void draw_ui_pane() {
        if (this.ui.active.booleanValue()) {
            this.pushStyle();
            int pane_origin = this.ui_elements.get_ui_pane_origin();
            this.fill(this.ui.colour_get_by_name("ui_pane_bg"));
            this.stroke(0);
            this.rectMode(0);
            this.rect(0.0f, pane_origin, this.width, this.ui_elements.pane_height);
            Boolean draw_ui_layout_grid = false;
            if (this.debug_mode.booleanValue() && draw_ui_layout_grid.booleanValue()) {
                this.stroke(180.0f, 80.0f, 20.0f, 120.0f);
                int i = 0;
                while (i < this.ui_elements.control_grid_row_positions.length) {
                    int row_pos = this.ui_elements.control_grid_row_positions[i];
                    this.line(0.0f, row_pos, this.width, row_pos);
                    ++i;
                }
                i = 0;
                while (i < this.ui_elements.control_grid_column_positions.length) {
                    this.line(this.ui_elements.control_grid_column_positions[i], this.ui_elements.control_grid_origin[1], this.ui_elements.control_grid_column_positions[i], this.height);
                    ++i;
                }
            }
            this.stroke(0.0f, 170.0f, 255.0f, 255.0f);
            pane_origin = (int)((float)pane_origin + (this.ui_elements.tab_dimensions.y + 1.0f));
            this.line(0.0f, pane_origin, this.width, pane_origin);
            this.stroke(this.ui.colour_get_by_name("ui_label"), 100.0f);
            this.strokeWeight(1.0f);
            int line_origin_y = 0;
            this.ui_elements.pane_height_default = 180;
            switch (this.ui.active_tab_id) {
                case 0: {
                    this.draw_logo(16, this.ui_elements.control_grid_row_positions[0] + 15, 0.35f);
                    this.stroke(this.ui.colour_get_by_name("ui_label"), 100.0f);
                    this.strokeWeight(1.0f);
                    line_origin_y = this.ui_elements.control_grid_row_positions[2] + this.ui_elements.get_scaled_size(15);
                    this.line(this.ui_elements.get_grid_width(14.0f), line_origin_y, this.ui_elements.get_grid_width(20.0f), line_origin_y);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    int line_origin_x = this.ui_elements.get_grid_width(18.5f);
                    int box_size = this.ui_elements.get_scaled_size(11);
                    line_origin_y = this.ui_elements.control_grid_row_positions[1] + box_size;
                    int line_end_y = this.ui_elements.control_grid_row_positions[2] + box_size;
                    this.line(line_origin_x - box_size * 2, line_origin_y, line_origin_x, line_origin_y);
                    if (this.project.current_displaygroup.display_aspect_ratio_locked.booleanValue()) {
                        this.line(line_origin_x, line_origin_y, line_origin_x, line_end_y);
                    }
                    this.line(line_origin_x - box_size * 2, line_end_y, line_origin_x, line_end_y);
                    Float drawing_height = Float.valueOf((float)this.ui_elements.pane_height - this.ui_elements.tab_dimensions.y);
                    PVector drawing_origin = new PVector((float)this.ui_elements.get_grid_width(56.0f), (float)pane_origin + drawing_height.floatValue() * 0.5f);
                    this.project.current_displaygroup.displays_icon_draw(drawing_origin, drawing_height);
                    break;
                }
                case 4: {
                    this.stroke(200.0f, 200.0f, 255.0f, 15.0f);
                    break;
                }
                case 5: {
                    break;
                }
            }
            this.ui_elements.calculate_ui_pane_height();
            this.stroke(this.ui.colour_get_by_name("ui_pane_line"), 100.0f);
            int i = 0;
            while (i < this.ui_elements.divider_positions[this.ui.active_tab_id].length) {
                this.line(this.ui_elements.divider_positions[this.ui.active_tab_id][i], this.ui_elements.control_grid_origin[1] + 42, this.ui_elements.divider_positions[this.ui.active_tab_id][i], (float)this.ui_elements.pane_origin + (float)this.ui_elements.pane_height * 0.95f);
                ++i;
            }
            this.popStyle();
        }
    }

    public void draw_target_surface() {
        int n = this.project.pref_projection_surface_mode;
        this.project.getClass();
        if (n == 1) {
            int[] target_surface_bounds = this.project.surface_bounds_get("target");
            this.noFill();
            this.stroke(this.ui.colour_get_by_name("surface_stroke"));
            this.pushMatrix();
            this.translate(this.ui.viewport.x, this.ui.viewport.y);
            this.scale(this.ui.viewport_scale / 100.0f);
            this.strokeWeight(2.0f);
            this.line(target_surface_bounds[3], target_surface_bounds[0], target_surface_bounds[1], target_surface_bounds[0]);
            this.line(target_surface_bounds[3], target_surface_bounds[2], target_surface_bounds[1], target_surface_bounds[2]);
            this.line(target_surface_bounds[3], target_surface_bounds[0], target_surface_bounds[3], target_surface_bounds[2]);
            this.line(target_surface_bounds[1], target_surface_bounds[0], target_surface_bounds[1], target_surface_bounds[2]);
            this.line(target_surface_bounds[3], target_surface_bounds[0], target_surface_bounds[1], target_surface_bounds[2]);
            this.line(target_surface_bounds[3], target_surface_bounds[2], target_surface_bounds[1], target_surface_bounds[0]);
            this.strokeWeight(1.0f);
            this.popMatrix();
        }
    }

    public void draw_logo(int origin_x, int origin_y, float draw_scale) {
        int logo_height = 175;
        float horizontal_offset = (float)logo_height * 0.65f;
        float element_width = (float)logo_height * 0.57f;
        float element_nudge = (float)logo_height * 0.011f;
        this.pushMatrix();
        this.translate(origin_x, origin_y);
        this.scale(draw_scale * this.ui.window_scale);
        this.noFill();
        this.stroke(this.ui.colour_get_by_name("matkeane"), 160.0f);
        this.strokeWeight(6.0f);
        this.strokeCap(4);
        this.rectMode(0);
        this.rect(0.0f, 0.0f, element_width, logo_height);
        this.translate(horizontal_offset, 0.0f);
        this.line(element_nudge, 0.0f, 0.0f, logo_height);
        this.line(element_nudge, 0.0f, (float)logo_height * 0.085f, 0.0f);
        this.line(0.0f, logo_height, (float)logo_height * 0.085f, logo_height);
        this.translate(element_width * 0.2f, 0.0f);
        this.arc(0.0f, (float)logo_height * 0.5f, logo_height, logo_height, -1.5707964f, 1.5707964f, 1);
        this.translate(horizontal_offset, 0.0f);
        this.rect(0.0f, 0.0f, element_width, logo_height);
        this.translate(horizontal_offset, 0.0f);
        this.line(0.0f, 0.0f, 0.0f, logo_height);
        this.line(0.0f, 0.0f, element_width / 2.0f, 0.0f);
        this.line(0.0f, logo_height, element_width / 2.0f, logo_height);
        this.translate(element_width * 0.54f, 0.0f);
        this.arc(0.0f, (float)logo_height * 0.25f, (float)logo_height * 0.5f, (float)logo_height * 0.5f, -1.5707964f, 1.5707964f, 1);
        this.arc(0.0f, (float)logo_height * 0.75f, (float)logo_height * 0.5f, (float)logo_height * 0.5f, -1.5707964f, 1.5707964f, 1);
        this.popMatrix();
    }

    public void draw_viewport_centre_mark() {
        int mark_length = 20;
        this.pushMatrix();
        PVector viewport_centre = this.ui.viewport_centre_get();
        this.translate(viewport_centre.x, viewport_centre.y);
        this.stroke(45);
        this.line(0 - mark_length / 2, 0.0f, mark_length / 2, 0.0f);
        this.line(0.0f, 0 - mark_length / 2, 0.0f, mark_length / 2);
        this.popMatrix();
    }

    public void draw_grid() {
        int grid_alpha = 128;
        if (this.project.pref_ui_toggle_show_layout_grid.booleanValue()) {
            float screen_grid_x = this.stage_to_screen(this.project.pref_ui_grid_size_h);
            float screen_grid_y = this.stage_to_screen(this.project.pref_ui_grid_size_v);
            this.ui_elements.get_ui_pane_origin();
            float gr_x_pos = 0.0f;
            float gr_y_pos = 0.0f;
            int grid_line_x = Display_Builder_4.ceil((float)(this.ui.viewport.x / screen_grid_x)) * -1;
            int grid_line_y = Display_Builder_4.ceil((float)(this.ui.viewport.y / screen_grid_y)) * -1;
            int grid_count_x = Display_Builder_4.ceil((float)((float)this.width / screen_grid_x)) + Display_Builder_4.abs((int)grid_line_x);
            int grid_count_y = Display_Builder_4.ceil((float)((float)this.height / screen_grid_y)) + Display_Builder_4.abs((int)grid_line_y);
            grid_line_x = Display_Builder_4.min((int)grid_line_x, (int)0);
            grid_line_y = Display_Builder_4.min((int)grid_line_y, (int)0);
            this.stroke(this.ui.colour_get_by_name("grid_line_pixel"), grid_alpha);
            this.pushMatrix();
            PVector grid_drawing_origin = new PVector(this.ui.viewport.x + (float)grid_line_x * screen_grid_x, this.ui.viewport.y + (float)grid_line_y * screen_grid_y);
            this.translate(grid_drawing_origin.x, grid_drawing_origin.y);
            while (grid_line_x <= grid_count_x) {
                gr_x_pos = Display_Builder_4.round((float)((float)grid_line_x * screen_grid_x));
                this.line(gr_x_pos, 0.0f, gr_x_pos, (float)this.height - grid_drawing_origin.y);
                ++grid_line_x;
            }
            while (grid_line_y <= grid_count_y) {
                gr_y_pos = Display_Builder_4.round((float)((float)grid_line_y * screen_grid_y));
                this.line(0.0f, gr_y_pos, (float)this.width - grid_drawing_origin.x, gr_y_pos);
                ++grid_line_y;
            }
            this.popMatrix();
            this.stroke(this.ui.colour_get_by_name("grid_line_pixel"), 255.0f);
            if (this.ui_elements.pane_position_screen_top.booleanValue()) {
                this.line(this.ui.viewport.x, this.ui_elements.pane_origin + this.ui_elements.pane_height, this.ui.viewport.x, this.height);
            } else {
                this.line(this.ui.viewport.x, 0.0f, this.ui.viewport.x, this.height);
            }
            this.line(0.0f, this.ui.viewport.y, this.width, this.ui.viewport.y);
        }
        this.draw_viewport_centre_mark();
        this.project.physical_grid.grid_draw();
    }

    public void osd_message_overlay_draw() {
        if (this.ui.ready.booleanValue()) {
            int time_elapsed = this.millis() - this.ui.osd_message_timer;
            if (time_elapsed > this.ui.osd_message_duration) {
                this.ui.osd_message_opacity = this.ui.osd_message_opacity > 0 ? (this.ui.osd_message_opacity -= 4) : 0;
            }
            if (this.ui.osd_message_opacity > 0 && !this.ui.osd_message_text.equals("")) {
                this.pushStyle();
                this.rectMode(0);
                switch (this.ui.osd_message_status) {
                    case 1: {
                        this.fill(this.ui.colour_get_by_name("ui_element_enabled"), (float)this.ui.osd_message_opacity * 0.4f);
                        break;
                    }
                    case 2: {
                        this.fill(this.ui.colour_get_by_name("ui_element_disabled"), (float)this.ui.osd_message_opacity * 0.4f);
                        break;
                    }
                    default: {
                        this.fill(50.0f, 50.0f, 80.0f, (float)this.ui.osd_message_opacity * 0.6f);
                    }
                }
                this.noStroke();
                this.pushMatrix();
                int osd_message_position = this.ui_elements.pane_origin - this.ui_elements.osd_overlay_height;
                if (this.ui_elements.pane_position_screen_top.booleanValue()) {
                    osd_message_position = this.ui_elements.pane_origin + this.ui_elements.pane_height;
                }
                this.translate(0.0f, osd_message_position);
                this.rect(0.0f, 0.0f, this.width, this.ui_elements.osd_overlay_height);
                this.fill(this.ui.colour_get_by_name("info_text"), this.ui.osd_message_opacity);
                this.textFont(this.font_display_ui, this.ui_elements.get_scaled_size(12));
                this.textAlign(37, 3);
                this.text(this.ui.osd_message_text, this.ui_elements.osd_overlay_height, (float)this.ui_elements.osd_overlay_height * 0.4f);
                this.popMatrix();
                this.popStyle();
            }
        }
    }

    public void draw_position_data_overlay() {
        if (this.project.pref_ui_show_mouse_coords_overlay.booleanValue() && this.ui.active.booleanValue()) {
            PVector mouse_position = new PVector((float)this.mouseX, (float)this.mouseY);
            PVector cursor_position_stage = this.screen_to_stage(mouse_position);
            this.ui.overlay_text = "";
            if (this.debug_mode.booleanValue()) {
                this.ui.overlay_text = "[" + Display_Builder_4.round((float)this.frameRate) + "] ";
            }
            this.ui.overlay_text = String.valueOf(this.ui.overlay_text) + "Layout. ";
            this.ui.overlay_text = String.valueOf(this.ui.overlay_text) + "Stage: " + Display_Builder_4.round((float)cursor_position_stage.x) + "x" + Display_Builder_4.round((float)cursor_position_stage.y) + "px";
            if (this.project.physical_settings_active_get().booleanValue()) {
                PVector position_physical = PVector.sub((PVector)cursor_position_stage, (PVector)this.project.physical_grid.origins_stage_get()).div(this.project.viewport_physical_scale);
                this.ui.overlay_text = String.valueOf(this.ui.overlay_text) + ", Physical: " + Display_Builder_4.nf((float)position_physical.x, (int)1, (int)2) + "x" + Display_Builder_4.nf((float)position_physical.y, (int)1, (int)2) + "m";
            } else {
                this.ui.overlay_text = String.valueOf(this.ui.overlay_text) + ", Physical scale disabled.";
            }
            if (this.ui.transform_in_progress.booleanValue()) {
                this.ui.overlay_text = String.valueOf(this.ui.overlay_text) + ", Transform ";
                this.ui.overlay_text = String.valueOf(this.ui.overlay_text) + this.ui.transform_get_text_data();
            }
            this.fill(this.ui.colour_get_by_name("info_text"));
            this.textFont(this.font_display_id, this.ui_elements.get_scaled_size(12));
            this.textAlign(37, 3);
            if (!this.ui.overlay_text.equals("")) {
                this.text(this.ui.overlay_text, 10.0f, this.height - 20);
            }
        }
    }

    public void draw_scrollbars() {
        PVector scrollbar_origin = new PVector(0.0f, 0.0f);
        int viewport_width = this.ui.window_width_current - this.ui.scrollbar_width;
        int viewport_height = this.ui.window_height_current - this.ui_elements.pane_height;
        int viewport_origin_y = this.ui_elements.pane_origin + this.ui_elements.pane_height;
        int viewport_limit_y = this.ui.window_height_current;
        if (!this.ui_elements.pane_position_screen_top.booleanValue()) {
            viewport_height = this.ui_elements.get_ui_pane_origin() - this.ui.scrollbar_width;
            viewport_origin_y = 0;
            viewport_limit_y = this.ui_elements.get_ui_pane_origin() - this.ui.scrollbar_width;
        }
        int[] surface_bounds = this.project.current_displaygroup.projection_surface_bounds_get();
        float overshoot_top = Display_Builder_4.abs((float)Display_Builder_4.min((float)0.0f, (float)(this.ui.viewport.y + this.stage_to_screen(surface_bounds[0]) - (float)viewport_origin_y)));
        float overshoot_right = Display_Builder_4.abs((float)Display_Builder_4.min((float)0.0f, (float)((float)viewport_width - (this.ui.viewport.x + this.stage_to_screen(surface_bounds[1])))));
        float overshoot_bottom = Display_Builder_4.abs((float)Display_Builder_4.min((float)0.0f, (float)((float)viewport_limit_y - (this.ui.viewport.y + this.stage_to_screen(surface_bounds[2])))));
        float overshoot_left = Display_Builder_4.abs((float)Display_Builder_4.min((float)0.0f, (float)(this.ui.viewport.x + this.stage_to_screen(surface_bounds[3]))));
        float full_width = this.stage_to_screen(surface_bounds[1] - surface_bounds[3]);
        float full_height = this.stage_to_screen(surface_bounds[2] - surface_bounds[0]);
        int scrollbar_bg = this.color(200);
        int scrollbar_fg = this.color(66);
        this.noStroke();
        if (overshoot_left > 0.0f || overshoot_right > 0.0f) {
            scrollbar_origin.y = this.ui_elements.pane_position_screen_top != false ? (float)(this.ui.window_height_current - this.ui.scrollbar_width) : (float)viewport_height;
            this.fill(scrollbar_bg);
            this.rectMode(0);
            this.rect(scrollbar_origin.x, scrollbar_origin.y, viewport_width, this.ui.scrollbar_width);
            float scrollbar_left = Display_Builder_4.map((float)overshoot_left, (float)0.0f, (float)full_width, (float)0.0f, (float)viewport_width);
            float scrollbar_right = Display_Builder_4.map((float)overshoot_right, (float)0.0f, (float)full_width, (float)0.0f, (float)viewport_width);
            this.fill(scrollbar_fg);
            this.rectMode(1);
            this.rect(scrollbar_left, scrollbar_origin.y, (float)viewport_width - scrollbar_right, scrollbar_origin.y + (float)this.ui.scrollbar_width);
        }
        if (overshoot_top > 0.0f || overshoot_bottom > 0.0f) {
            scrollbar_origin.x = viewport_width;
            scrollbar_origin.y = this.ui_elements.pane_position_screen_top != false ? (float)(this.ui_elements.pane_origin + this.ui_elements.pane_height) : 0.0f;
            this.fill(scrollbar_bg);
            this.rectMode(0);
            this.rect(scrollbar_origin.x, scrollbar_origin.y, this.ui.scrollbar_width, viewport_limit_y);
            float scrollbar_top = Display_Builder_4.map((float)overshoot_top, (float)0.0f, (float)full_height, (float)0.0f, (float)viewport_height);
            float scrollbar_bottom = Display_Builder_4.map((float)overshoot_bottom, (float)0.0f, (float)full_height, (float)0.0f, (float)viewport_height);
            this.fill(scrollbar_fg);
            this.rectMode(1);
            this.rect(scrollbar_origin.x, scrollbar_origin.y + scrollbar_top, this.ui.window_width_current, (float)viewport_limit_y - scrollbar_bottom);
        }
    }

    public void draw_throbber() {
        if (this.ui.operation_in_progress.booleanValue()) {
            int viewport_centre_x = Display_Builder_4.round((float)(this.width / 2));
            int viewport_centre_y = Display_Builder_4.round((float)((this.height - (this.ui_elements.pane_height + this.ui.scrollbar_width)) / 2));
            int box_size = 175;
            int box_corner_radius = 25;
            int segment_count = 8;
            int segment_size = Display_Builder_4.round((float)(box_size / 3));
            float segment_alpha = 0.0f;
            float segment_degrees = 360 / segment_count;
            int base_angle = this.millis() / 2 % 360;
            this.rectMode(3);
            this.fill(0.0f, 0.0f, 0.0f, 150.0f);
            this.stroke(this.ui.colour_get_by_name("matkeane"));
            this.pushMatrix();
            this.translate(viewport_centre_x, viewport_centre_y);
            this.rect(0.0f, 0.0f, box_size, box_size, box_corner_radius);
            int i = 0;
            while (i < segment_count) {
                segment_alpha = Display_Builder_4.map((float)Display_Builder_4.sin((float)Display_Builder_4.radians((float)((float)base_angle - segment_degrees * (float)i))), (float)-1.0f, (float)1.0f, (float)0.0f, (float)120.0f);
                this.pushMatrix();
                this.rotate(Display_Builder_4.radians((float)segment_degrees) * (float)i);
                this.translate((float)box_size * -0.25f, 0.0f);
                this.noStroke();
                this.fill(255.0f, 102.0f, 0.0f, segment_alpha);
                this.ellipse(0.0f, 0.0f, segment_size, segment_size);
                this.popMatrix();
                ++i;
            }
            this.fill(255);
            this.textAlign(3);
            this.textSize(box_corner_radius);
            this.text("Thinking...", 0.0f, (float)box_corner_radius * 0.33f);
            this.popMatrix();
        }
    }

    public void setup_ui_elements() {
        this.ui_elements.controls.setAutoDraw(true);
        String current_tab_group = "";
        this.ui_elements.controls.getTooltip().setDelay(250L);
        this.ui_elements.controls.getTooltip().setPositionOffset(10.0f, 5.0f);
        int i = 0;
        while (i < this.ui_elements.tab_name_labels.length) {
            ((Tab)this.ui_elements.controls.addTab(this.ui_elements.tab_name_labels[i][0]).setLabel(this.ui_elements.tab_name_labels[i][1]).setId(i)).activateEvent(true).setWidth(Display_Builder_4.round((float)this.ui_elements.tab_dimensions.x)).setHeight(Display_Builder_4.round((float)this.ui_elements.tab_dimensions.y));
            this.ui_elements.controls.getTab((String)this.ui_elements.tab_name_labels[i][0]).getCaptionLabel().getStyle().marginLeft = this.ui_elements.tab_caption_margin_left;
            ++i;
        }
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_project_name", 0, 0, 20, 20).setCaptionLabel("PROJECT NAME:")).setText(this.project.pref_project_name).setAutoClear(false);
        this.ui_elements.control_tooltips.set("textfield_project_name", "Set project name; Used in exported file names.");
        this.ui_elements.controls.addTextlabel("label_project_summary_title", "PROJECT SUMMARY:", 0, 0);
        this.ui_elements.controls.addTextlabel("label_project_summary_data", "", 0, 0);
        this.ui_elements.control_tooltips.set("label_project_summary_data", "PROJECT SUMMARY.");
        ((Button)this.ui_elements.controls.addButton("button_project_reset").setLabel("Reset Project")).setColorBackground(this.ui.colour_get_by_name("ui_element_warning"));
        this.ui_elements.control_tooltips.set("button_project_reset", "Reset project to defaults.");
        ((Button)this.ui_elements.controls.addButton("button_project_load").setLabel("LOAD")).setColorBackground(this.ui.colour_get_by_name("matkeane"));
        this.ui_elements.control_tooltips.set("button_project_load", "Load a project file.");
        ((Button)this.ui_elements.controls.addButton("button_project_save").setLabel("SAVE")).setColorBackground(this.ui.colour_get_by_name("matkeane"));
        this.ui_elements.control_tooltips.set("button_project_save", "Save the current project.");
        this.ui_elements.controls.addButton("button_project_load_mode").setLabel("OVERWRITE");
        this.ui_elements.control_tooltips.set("button_project_load_mode", "Choose whether the selected file will replace, or appended to, the current project.");
        current_tab_group = "group_guides";
        ((Button)this.ui_elements.controls.addButton("button_guide_image_load").setLabel("LOAD IMAGE")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_guide_image_load", "Load a new guide image.");
        ((Button)this.ui_elements.controls.addButton("button_guide_line_add").setLabel("ADD LINE")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_guide_line_add", "Add a new guide line at the centre of the Viewport. Use 'x' and 'y' keys to switch between horizontal and vertical axes.");
        ((Button)this.ui_elements.controls.addButton("button_guide_line_add_auto").setLabel("AUTO LINES")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_guide_line_add_auto", "Automatically add new guide lines at the boundaries of the current Display Group.");
        ((Button)((Button)this.ui_elements.controls.addButton("button_guide_delete").setColorBackground(this.ui.colour_get_by_name("ui_element_warning"))).setLabel("DELETE")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_guide_delete", "Delete the current guide.");
        this.ui_elements.controls.addTextlabel("label_guide_info", "", 0, 0).moveTo(current_tab_group);
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_guide_position_x", 100, 0, 20, 20).setCaptionLabel("POSITION X:")).setText("0").setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_guide_position_x", "Set the horizontal position of the current guide.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_guide_position_y", 100, 0, 20, 20).setCaptionLabel("POSITION Y:")).setText("0").setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_guide_position_y", "Set the vertical position of the current guide.");
        this.ui_elements.controls.addTextlabel("label_guide_rotation", "ROTATION:", 0, 0).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_guide_rotation_value", "", 0, 0).moveTo(current_tab_group);
        ((Knob)((Knob)((Knob)((Knob)this.ui_elements.controls.addKnob("knob_guide_rotation").setBroadcast(false)).setRange(0.0f, 4.712389f).setValue(1.5707964f).setStartAngle(-1.5707964f).setMax(4.712389f).setNumberOfTickMarks(6).setTickMarkLength(4).snapToTickMarks(false).setDragDirection(0).setLabelVisible(false)).setCaptionLabel("")).moveTo(current_tab_group)).setBroadcast(true);
        this.ui_elements.control_tooltips.set("knob_guide_rotation", "Set the rotation of the current guide.");
        ((Bang)((Bang)((Bang)((Bang)this.ui_elements.controls.addBang("bang_guide_locked").setId(6)).setLabel("LOCKED")).setColorForeground(this.ui.colour_get_by_name("ui_element_enabled"))).setColorActive(this.ui.colour_get_by_name("ui_element_enabled"))).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("bang_guide_locked", "Lock the current guide.");
        ((Slider)((Slider)((Slider)this.ui_elements.controls.addSlider("slider_guide_opacity", 0.0f, 100.0f, 50.0f, 0, 0, 200, 20).setBroadcast(false)).setNumberOfTickMarks(11).snapToTickMarks(false).setLabel("Opacity:")).setValue(50.0f).moveTo(current_tab_group)).setBroadcast(true);
        this.ui_elements.control_tooltips.set("slider_guide_opacity", "Set the opacity of the current guide.");
        ((Slider)((Slider)((Slider)this.ui_elements.controls.addSlider("slider_image_scale", 0.0f, 200.0f, 100.0f, 0, 0, 200, 20).setBroadcast(false)).setNumberOfTickMarks(11).snapToTickMarks(false).setLabel("Scale:")).setValue(100.0f).moveTo(current_tab_group)).setBroadcast(true);
        this.ui_elements.control_tooltips.set("slider_image_scale", "Set the scale of the current guide.");
        ((Bang)((Bang)((Bang)((Bang)this.ui_elements.controls.addBang("bang_swatch_guide").setId(5)).setLabel("COLOUR:")).setColorForeground(this.ui.colour_get_by_name("guide_line_default"))).setColorActive(this.ui.colour_get_by_name("guide_line_default"))).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("bang_swatch_guide", "Set the colour of the current guide.");
        current_tab_group = "group_displaygroups";
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_stagetier_name", 0, 0, 190, 10).setCaptionLabel("")).setText("STAGE TIER").setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_stagetier_name", "Set the name of this stage tier.");
        ((Button)this.ui_elements.controls.addButton("button_stagetier_add").setLabel("ADD")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_stagetier_add", "Add a new stage tier.");
        ((Button)((Button)((Button)this.ui_elements.controls.addButton("button_stagetier_delete").setLabel("DELETE")).setLock(true)).setColorBackground(this.ui.colour_get_by_name("ui_element_warning"))).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_stagetier_delete", "Delete this stage tier.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_group_name", 0, 0, 190, 0).setCaptionLabel("")).setText("DEFAULT").setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_display_group_name", "Set the name of this group of displays.");
        ((Button)this.ui_elements.controls.addButton("button_display_group_add").setLabel("ADD")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_display_group_add", "Add a new display group.");
        ((Button)this.ui_elements.controls.addButton("button_display_group_duplicate").setLabel("COPY")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_display_group_duplicate", "Duplicate this display group.");
        ((Button)((Button)((Button)this.ui_elements.controls.addButton("button_display_group_delete").setLabel("DELETE")).setLock(true)).setColorBackground(this.ui.colour_get_by_name("ui_element_warning"))).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_display_group_delete", "Delete this display group.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_basename", 0, 0, 20, 20).setCaptionLabel("DISPLAY NAME PREFIX:")).setText(this.project.current_displaygroup.display_basename).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_display_basename", "Prefix used for Display names (shown on stage).");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_baseip", 0, 0, 20, 20).setCaptionLabel("PLAYER NAME PREFIX:")).setText(this.project.current_displaygroup.player_name_prefix).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_display_baseip", "Shared prefix for computer name, or base I.P. address.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_startip", 0, 0, 30, 0).setCaptionLabel("START NUMBER / IP:")).setText(Integer.toString(this.project.current_displaygroup.player_start_number)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_display_startip", "Initial value for Computer ID or I.P. address.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_multi_output", 0, 0, 20, 20).setCaptionLabel("OUTPUTS PER PLAYER:")).setText(Integer.toString(this.project.current_displaygroup.player_outputs_count)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_multi_output", "Number of video outputs per player (Requires WO5 or later).");
        ((Toggle)((Toggle)this.ui_elements.controls.addToggle("toggle_player_outputs_shared").setCaptionLabel("Share/Use free outputs:")).moveTo(current_tab_group)).setState(false);
        this.ui_elements.control_tooltips.set("toggle_player_outputs_shared", "Share/use free outputs from other groups.");
        Textlabel ui_label_display_colour = this.ui_elements.controls.addTextlabel("label_display_colour", "COLOURS:", 0, 0);
        ui_label_display_colour.moveTo(current_tab_group);
        ((Bang)((Bang)((Bang)((Bang)this.ui_elements.controls.addBang("bang_swatch_display_outline").setId(1)).setLabel("DISPLAY OUTLINE COLOUR:")).setColorForeground(this.ui.colour_get_by_name("display_stroke"))).setColorActive(this.ui.colour_get_by_name("display_stroke"))).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("bang_swatch_display_outline", "Choose the outline colour of the Display.");
        this.ui.dropdownlist_display_colour_options = this.ui_elements.controls.addScrollableList("menu_display_colour_options", 0, 0, 20, 20);
        this.ui.dropdownlist_display_colour_options.setBackgroundColor(this.color(120));
        this.ui.dropdownlist_display_colour_options.setCaptionLabel("Display Colours");
        this.ui.dropdownlist_display_colour_options.setBarHeight(20);
        this.ui.dropdownlist_display_colour_options.setItemHeight(18);
        this.ui.dropdownlist_display_colour_options.addItem("Identical for All", (Object)0);
        this.ui.dropdownlist_display_colour_options.addItem("By Output Group", (Object)1);
        this.ui.dropdownlist_display_colour_options.addItem("By Row / Column", (Object)2);
        this.ui.dropdownlist_display_colour_options.addItem("By Display", (Object)3);
        this.ui.dropdownlist_display_colour_options.addItem("UV Grid", (Object)4);
        this.ui.dropdownlist_display_colour_options.setValue(0.0f);
        this.ui.dropdownlist_display_colour_options.setOpen(false);
        this.ui.dropdownlist_display_colour_options.moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("menu_display_colour_options", "Choose an option for Display outline colours.");
        ((Button)this.ui_elements.controls.addButton("button_obj_surface_load").setLabel("IMPORT OBJ")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_obj_surface_load", "Import an OBJ file to define a 2D (X-Y) projection surface.");
        ((Button)this.ui_elements.controls.addButton("button_preview_tier_add").setLabel("ADD PREVIEW")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_preview_tier_add", "Add a preview Display on a new Stage Tier to cover this Display Group.");
        current_tab_group = "group_display_setup";
        this.ui_elements.controls.addTextlabel("label_display_rotation", "ROTATION:", 0, 0).moveTo(current_tab_group);
        ((Knob)((Knob)this.ui_elements.controls.addKnob("knob_display_rotation", 0.0f, 360.0f, this.project.current_displaygroup.display_rotation, 140, 8, 0).setStartAngle(-1.5707964f).setRange(0.0f, 4.712389f).setMax(4.712389f).setNumberOfTickMarks(3).showTickMarks(true).snapToTickMarks(true).setLabelVisible(false)).setCaptionLabel("")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("knob_display_rotation", "Set the rotation of the Displays in this Group.");
        this.ui_elements.controls.addTextlabel("label_resolution_presets", "RESOLUTION:", 0, 0).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_resolution_width", "WIDTH:", 0, 0).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_resolution_height", "HEIGHT:", 0, 0).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_resolution_aspect_ratio", Display_Builder_4.nf((float)this.project.current_displaygroup.display_aspect_ratio.floatValue(), (int)0, (int)2), 0, 0).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_resolution_pixel_count", "PIXEL COUNT", 0, 0).moveTo(current_tab_group);
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_width_resolution", 0, 0, 20, 20).setCaptionLabel("")).setText(Display_Builder_4.nf((float)this.project.current_displaygroup.display_dimensions_stage.x)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_display_width_resolution", "Set the horizontal pixel resolution of the Display.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_height_resolution", 0, 0, 20, 20).setCaptionLabel("")).setText(Display_Builder_4.nf((float)this.project.current_displaygroup.display_dimensions_stage.y)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_display_height_resolution", "Set the vertical pixel resolution of the Display.");
        ((Bang)((Bang)((Bang)this.ui_elements.controls.addBang("bang_display_aspect_locked").setLabel("")).setColorForeground(this.ui.colour_get_by_name("ui_element_enabled"))).setColorActive(this.ui.colour_get_by_name("ui_element_enabled"))).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("bang_display_aspect_locked", "Lock the aspect ratio of the Display resolution.");
        ((Button)((Button)this.ui_elements.controls.addButton("button_resolution_preset_add").setLabel("ADD")).setLock(true)).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_resolution_preset_add", "Add the current custom resolution as a preset.");
        this.ui_elements.controls.addTextlabel("label_display_physical_size", "PHYSICAL DISPLAY SIZE:", 0, 0).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("label_display_physical_size", "Optional: Used to calculate physical size of projection surface.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_width_physical", 0, 0, 20, 20).setCaptionLabel("")).setText(this.physical_dimension_get_as_string(this.project.current_displaygroup.display_dimensions_physical.x)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_display_width_physical", "Set physical width of Display.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_height_physical", 0, 0, 20, 20).setCaptionLabel("")).setText(this.physical_dimension_get_as_string(this.project.current_displaygroup.display_dimensions_physical.y)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_display_height_physical", "Set physical height of Display.");
        ((Button)((Button)this.ui_elements.controls.addButton("button_project_physical_scale_set").setLabel("SET PROJECT SCALE")).setLock(true)).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_project_physical_scale_set", "Set the physical scale for the project from this DisplayGroup's scale. Other DisplayGroups will use this value to calculate their physical dimensions and/or stage-scale.");
        this.ui_elements.controls.addTextlabel("label_display_physical_area", "", 0, 0).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_pixel_size", "", 0, 0).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_stage_size", "STAGE SIZE:", 0, 0).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("label_stage_size", "Optional: Stage size if different from Display resolution.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_width_stage", 0, 0, 20, 20).setCaptionLabel("px")).setText(Display_Builder_4.nf((float)this.project.current_displaygroup.display_dimensions_stage.x)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_display_width_stage", "Set Stage width of the Display.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_height_stage", 0, 0, 20, 20).setCaptionLabel("px")).setText(Display_Builder_4.nf((float)this.project.current_displaygroup.display_dimensions_stage.y)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_display_height_stage", "Set Stage height of the Display.");
        ((Button)this.ui_elements.controls.addButton("button_stagesize_round").setLabel("Round")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_stagesize_round", "Round to multiple of " + this.project.pref_dimension_rounding_multiple + "px.");
        ((Button)this.ui_elements.controls.addButton("button_stagesize_reset").setLabel("Reset")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_stagesize_reset", "Reset Stage size to match Display resolution.");
        current_tab_group = "group_display_layout";
        this.ui_elements.controls.addTextlabel("label_displays", "DISPLAYS:", 0, 0).moveTo(current_tab_group);
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_count_h", 30, 0, 20, 20).setCaptionLabel("H / COLS")).setText(Integer.toString(this.project.current_displaygroup.display_cols)).setAutoClear(false).moveTo(current_tab_group);
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_display_count_v", 30, 0, 20, 20).setCaptionLabel("V / ROWS")).setText(Integer.toString(this.project.current_displaygroup.display_rows)).setAutoClear(false).moveTo(current_tab_group);
        ((Button)this.ui_elements.controls.addButton("button_display_col_subtract").setLabel("-")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_display_col_subtract", "Remove horizontal display column.");
        ((Button)this.ui_elements.controls.addButton("button_display_col_add").setLabel("+")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_display_col_add", "Add horizontal display column.");
        ((Button)this.ui_elements.controls.addButton("button_display_row_subtract").setLabel("-")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_display_row_subtract", "Remove vertical display row.");
        ((Button)this.ui_elements.controls.addButton("button_display_row_add").setLabel("+")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_display_row_add", "Add vertical display row.");
        ((Button)((Button)this.ui_elements.controls.addButton("button_invert_cols_rows_layout").setLabel("H/V ORDER")).moveTo(current_tab_group)).setLock(true);
        this.ui_elements.control_tooltips.set("button_invert_cols_rows_layout", "Switch between Horizontal and Vertical ordering.");
        this.ui_elements.controls.addTextlabel("label_displays_count_summary", "GROUP SUMMARY", 0, 0).moveTo(current_tab_group);
        Textlabel ui_label_softedge = this.ui_elements.controls.addTextlabel("label_softedge", "SOFTEDGE / DISPLAY OVERLAP:", 0, 0);
        ui_label_softedge.moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_soft_h", "H:", 0, 0).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_soft_v", "V:", 0, 0).moveTo(current_tab_group);
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_softedge_h_px", 90, 0, 20, 20).setCaptionLabel("PX")).setText(Display_Builder_4.nf((float)this.project.current_displaygroup.softedge_dimensions.x, (int)0, (int)0)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_softedge_h_px", "Horizontal softedge value in pixels.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_softedge_v_px", 90, 0, 20, 20).setCaptionLabel("PX")).setText(Display_Builder_4.nf((float)this.project.current_displaygroup.softedge_dimensions.y, (int)0, (int)0)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_softedge_v_px", "Vertical softedge value in pixels.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_softedge_h_pc", 90, 0, 20, 20).setCaptionLabel("%")).setText(Display_Builder_4.nfs((float)this.project.current_displaygroup.softedge_values_get("horizontal", "percentage"), (int)1, (int)2)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_softedge_h_pc", "Horizontal softedge value as percentage of Display resolution width.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_softedge_v_pc", 90, 0, 20, 20).setCaptionLabel("%")).setText(Display_Builder_4.nfs((float)this.project.current_displaygroup.softedge_values_get("vertical", "percentage"), (int)1, (int)2)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_softedge_v_pc", "Vertical softedge value as percentage of Display resolution height.");
        ((Textfield)((Textfield)this.ui_elements.controls.addTextfield("textfield_softedge_h_physical", 90, 0, 20, 20).setCaptionLabel("m")).setText(Display_Builder_4.nfs((float)this.project.current_displaygroup.softedge_values_get("horizontal", "physical"), (int)1, (int)2)).setAutoClear(false).moveTo(current_tab_group)).setLock(true);
        this.ui_elements.control_tooltips.set("textfield_softedge_h_physical", "Vertical softedge value in physical units.");
        ((Textfield)((Textfield)this.ui_elements.controls.addTextfield("textfield_softedge_v_physical", 90, 0, 20, 20).setCaptionLabel("m")).setText(Display_Builder_4.nfs((float)this.project.current_displaygroup.softedge_values_get("vertical", "physical"), (int)1, (int)2)).setAutoClear(false).moveTo(current_tab_group)).setLock(true);
        this.ui_elements.control_tooltips.set("textfield_softedge_v_physical", "Vertical softedge value in physical units.");
        Textlabel ui_label_surface = this.ui_elements.controls.addTextlabel("label_surface", "GROUP SURFACE AREA:", 0, 0);
        ui_label_surface.moveTo(current_tab_group);
        PVector project_surface_dimensions = this.project.surface_dimensions_get("project");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_projection_surface_h_px", 0, 0, 20, 20).setCaptionLabel("PX")).setText(Display_Builder_4.nf((float)project_surface_dimensions.x)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_projection_surface_h_px", "Total horizontal surface area in pixels.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_projection_surface_v_px", 0, 0, 20, 20).setCaptionLabel("PX")).setText(Display_Builder_4.nf((float)project_surface_dimensions.y)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_projection_surface_v_px", "Total vertical surface area in pixels.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_group_surface_h_physical", 0, 0, 20, 20).setCaptionLabel("M")).setText("0.00").setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_group_surface_h_physical", "Physical horizontal surface area");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_group_surface_v_physical", 0, 0, 20, 20).setCaptionLabel("M")).setText("0.00").setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_group_surface_v_physical", "Physical vertical surface area");
        this.ui_elements.controls.addTextlabel("label_group_surface_area_ratio", "Ratio:", 70, 0).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_group_surface_area_pixels", "Pixels", 70, 0).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_group_surface_area_physical", "Physical", 70, 0).moveTo(current_tab_group);
        ((Button)this.ui_elements.controls.addButton("button_surface_mode").setLabel("AUTOMATIC")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_surface_mode", "Switch between automatic and user-specified surface area.");
        ((Button)this.ui_elements.controls.addButton("button_surface_fit").setLabel("FIT DISPLAYS")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_surface_fit", "Automatically fit current display resolution to surface area (if set manually).");
        this.ui_elements.controls.addTextlabel("label_displaygroup_origin", "ORIGIN:", 20, 0).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("label_displaygroup_origin", "Choose the alignment origin for the current Display Group.");
        RadioButton ui_radio_displaygroup_origin = this.ui_elements.controls.addRadioButton("radio_displaygroup_origin").setItemsPerRow(3);
        int i2 = 0;
        while (i2 < this.ui.alignment_grid_labels.length) {
            ui_radio_displaygroup_origin.addItem("DGO-" + this.ui.alignment_grid_labels[i2], (float)i2);
            ++i2;
        }
        ui_radio_displaygroup_origin.hideLabels();
        ui_radio_displaygroup_origin.activate(0);
        ui_radio_displaygroup_origin.moveTo(current_tab_group);
        RadioButton ui_radio_displaygroup_alignment = this.ui_elements.controls.addRadioButton("radio_displaygroup_alignment").setItemsPerRow(3);
        int i3 = 0;
        while (i3 < this.ui.alignment_grid_labels.length) {
            ui_radio_displaygroup_alignment.addItem("DGA-" + this.ui.alignment_grid_labels[i3], (float)i3);
            ++i3;
        }
        ui_radio_displaygroup_alignment.hideLabels();
        ui_radio_displaygroup_alignment.activate(this.project.current_displaygroup.parent_alignment_id);
        ui_radio_displaygroup_alignment.moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_parent", "POSITION RELATIVE TO:", 0, 0).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("label_parent", "Choose the alignment target for the current Display Group.");
        this.ui_elements.controls.addTextlabel("label_origin_h", "HORIZONTAL OFFSET:", 0, 2).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_origin_v", "VERTICAL OFFSET:", 0, 2).moveTo(current_tab_group);
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_origin_offset_h_px", 100, 0, 20, 20).setCaptionLabel("PX")).setText(Display_Builder_4.nf((float)this.project.current_displaygroup.parent_offset.x, (int)0, (int)0)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_origin_offset_h_px", "Set the horizontal pixel offset from the origin.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_origin_offset_v_px", 100, 0, 20, 20).setCaptionLabel("PX")).setText(Display_Builder_4.nf((float)this.project.current_displaygroup.parent_offset.y, (int)0, (int)0)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_origin_offset_v_px", "Set the vertical pixel offset from the origin.");
        ((Button)this.ui_elements.controls.addButton("button_origin_offset_reset").setLabel("RESET")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_origin_offset_reset", "Reset offsets to zero.");
        current_tab_group = "group_view";
        ((Toggle)this.ui_elements.controls.addToggle("toggle_view_guideimages").setCaptionLabel("GUIDE IMAGES")).setValue(this.project.pref_ui_view_guideimages.booleanValue()).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("toggle_view_guideimages", "Show or hide all guide images.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_view_guidelines").setCaptionLabel("GUIDE LINES")).setValue(this.project.pref_ui_view_guidelines.booleanValue()).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("toggle_view_guidelines", "Show or hide all guide lines.");
        ((ColorWheel)((ColorWheel)((ColorWheel)this.ui_elements.controls.addColorWheel("colourwheel", 250, 10, this.ui_elements.colourpicker_size).setLabelVisible(false)).hide()).moveTo(current_tab_group)).addCallback(new CallbackListener(){

            public void controlEvent(CallbackEvent theEvent) {
                Display_Builder_4.this.ui.colourpicker_event(theEvent.getAction());
            }
        });
        ((Toggle)this.ui_elements.controls.addToggle("toggle_display_info").setCaptionLabel("DISPLAY DATA")).setValue(this.project.pref_ui_show_display_info.booleanValue()).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("toggle_display_info", "Show/Hide data overlay when the mouse is over a Display.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_displaygroup_43_marks").setCaptionLabel("4:3 MARKS")).setValue(this.project.current_displaygroup.display_show_43_marks.booleanValue()).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("toggle_displaygroup_43_marks", "Show 4:3 Centre cut marks in Displays.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_display_info_crop").setCaptionLabel("CROP VALUES")).setValue(this.project.pref_ui_show_display_info_crop.booleanValue()).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("toggle_display_info_crop", "Show/Hide Display cropping values.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_mouse_coords_overlay").setCaptionLabel("MOUSE POSITION")).setValue(this.project.pref_ui_show_mouse_coords_overlay.booleanValue()).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("toggle_mouse_coords_overlay", "Show/Hide Mouse position overlay.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_overlay_display_spacing").setCaptionLabel("DISPLAY SPACING")).setValue(this.project.pref_ui_show_overlay_display_spacing.booleanValue()).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("toggle_overlay_display_spacing", "Show/Hide display spacing overlay.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_overlay_parent_links").setCaptionLabel("parent links")).setValue(this.project.pref_ui_show_parent_links.booleanValue()).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("toggle_overlay_parent_links", "Show/Hide links betwen DisplayGroups when parented.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_current_displaygroup_solo").setCaptionLabel("solo current DisplayGroup")).setValue(this.project.pref_ui_show_current_group_only.booleanValue()).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("toggle_current_displaygroup_solo", "Show only Displays in the currently selected DisplayGroup.");
        ((Slider)this.ui_elements.controls.addSlider("slider_stage_scale", 1.0f, (float)this.ui.viewport_scale_max, this.ui.viewport_scale, 0, 0, 20, 20).setNumberOfTickMarks(11).snapToTickMarks(false).setLabel("View Scale:")).setValue(this.ui.viewport_scale).moveTo(current_tab_group);
        ((Toggle)this.ui_elements.controls.addToggle("toggle_auto_scale").setCaptionLabel("AUTO SCALE TO FIT")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("toggle_auto_scale", "Automatically scale view to fit displays on screen.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_view_ui_grid_pixel").setCaptionLabel("PIXEL GRID")).setValue(this.project.pref_ui_toggle_show_layout_grid.booleanValue()).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("toggle_view_ui_grid_pixel", "Show/Hide layout grid.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_grid_h_px", 0, 0, 20, 20).setCaptionLabel("H:               PX")).setText(Integer.toString(this.project.pref_ui_grid_size_h)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_grid_h_px", "Horizontal Pixel Grid Size.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_grid_v_px", 0, 0, 20, 20).setCaptionLabel("V:               PX")).setText(Integer.toString(this.project.pref_ui_grid_size_v)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_grid_v_px", "Vertical Pixel Grid Size.");
        ((Bang)((Bang)((Bang)((Bang)this.ui_elements.controls.addBang("bang_swatch_grid_pixel").setId(2)).setColorForeground(this.ui.colour_get_by_name("grid_line_pixel"))).setColorActive(this.ui.colour_get_by_name("grid_line_pixel"))).setCaptionLabel("Pixel Grid:")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("bang_swatch_grid_pixel", "Choose Pixel Grid colour.");
        ((Toggle)((Toggle)this.ui_elements.controls.addToggle("toggle_view_ui_grid_physical").setCaptionLabel("PHYSICAL GRID")).setValue(this.project.physical_grid.visibility_get().booleanValue()).moveTo(current_tab_group)).setLock(true);
        this.ui_elements.control_tooltips.set("toggle_view_ui_grid_physical", "Show/Hide physical grid.");
        this.ui_elements.controls.addTextlabel("label_physical_grid_alignment", "ALIGNMENT:         OFFSET:", 0, 0).moveTo(current_tab_group);
        RadioButton ui_radio_physical_grid_alignment = this.ui_elements.controls.addRadioButton("radio_physical_grid_alignment").setItemsPerRow(3);
        int i4 = 0;
        while (i4 < this.ui.alignment_grid_labels.length) {
            ui_radio_physical_grid_alignment.addItem("PGA-" + this.ui.alignment_grid_labels[i4], (float)i4);
            ++i4;
        }
        ui_radio_physical_grid_alignment.hideLabels();
        ui_radio_physical_grid_alignment.activate(this.project.current_displaygroup.parent_alignment_id);
        ui_radio_physical_grid_alignment.moveTo(current_tab_group);
        ((Bang)((Bang)((Bang)((Bang)this.ui_elements.controls.addBang("bang_swatch_grid_physical").setId(4)).setColorForeground(this.ui.colour_get_by_name("grid_line_physical"))).setColorActive(this.ui.colour_get_by_name("grid_line_physical"))).setCaptionLabel("Physical grid:")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("bang_swatch_grid_physical", "Choose the Physical Grid colour.");
        PVector physical_grid_offsets = this.project.physical_grid.origins_offset_get();
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_physical_grid_offset_h", 0, 0, 20, 20).setCaptionLabel("H:")).setText(Display_Builder_4.nf((float)physical_grid_offsets.x, (int)1, (int)2)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_physical_grid_offset_h", "Horizontal Offset for Physical Grid.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_physical_grid_offset_v", 0, 0, 20, 20).setCaptionLabel("V:")).setText(Display_Builder_4.nf((float)physical_grid_offsets.y, (int)1, (int)2)).setAutoClear(false).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("textfield_physical_grid_offset_v", "Vertical Offset for Physical Grid.");
        this.ui_elements.controls.addTextlabel("label_view_colours", "LINE COLOURS:", 0, 0).moveTo(current_tab_group);
        ((Bang)((Bang)((Bang)((Bang)this.ui_elements.controls.addBang("bang_swatch_surface").setId(3)).setColorForeground(this.ui.colour_get_by_name("surface_stroke"))).setColorActive(this.ui.colour_get_by_name("surface_stroke"))).setCaptionLabel("Surface Outline:")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("bang_swatch_surface", "Choose the surface outline colour.");
        current_tab_group = "group_export";
        this.ui_elements.controls.addTextlabel("label_lineup_grid_unit_h", "PIXELS", 0, 0).moveTo(current_tab_group);
        this.ui_elements.controls.addTextlabel("label_lineup_grid_unit_v", "PIXELS", 0, 0).moveTo(current_tab_group);
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_lineup_grid_size", 0, 0, 20, 20).setCaptionLabel("CELL:")).setText(Integer.toString(this.project.pref_export_grid_cell_size)).setAutoClear(false).moveTo("group_export");
        this.ui_elements.control_tooltips.set("textfield_lineup_grid_size", "Horizontal Grid size in pixels or number of squares.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_lineup_marker_interval", 0, 0, 20, 20).setCaptionLabel("MARKER:")).setText(Integer.toString(this.project.pref_export_grid_marker_interval)).setAutoClear(false).moveTo("group_export");
        this.ui_elements.control_tooltips.set("textfield_lineup_marker_interval", "Horizontal Marker interval (zero to disable).");
        ((Button)this.ui_elements.controls.addButton("button_export_lineup_grid_fit_squares").setLabel("WHOLE SQUARES")).moveTo(current_tab_group);
        this.ui_elements.control_tooltips.set("button_export_lineup_grid_fit_squares", "Calculate the largest cell size to allow whole grid squares to fit the DisplayGroup surface.");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_lineup_grid_line_width", 0, 0, 20, 20).setCaptionLabel("PX")).setText(Integer.toString(this.project.pref_export_grid_line_width)).setAutoClear(false).moveTo("group_export");
        this.ui_elements.control_tooltips.set("textfield_lineup_grid_line_width", "Set the pixel width of grid lines.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_grid_use_display_colours").setCaptionLabel("Use Display Colours")).setState(this.project.pref_export_grid_use_display_colours.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_grid_use_display_colours", "Use 'View' colour settings for Display outlines.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_grid_use_grid_colour").setCaptionLabel("Use Grid Colour")).setState(this.project.pref_export_grid_use_grid_colour.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_grid_use_grid_colour", "Use 'View' colour settings for Grid lines.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_invert_grid_colour").setCaptionLabel("Invert Grid Colours")).setState(this.project.pref_export_grid_invert_colour.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_invert_grid_colour", "Invert alignment grid colours.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_grid_crosshatch_show").setCaptionLabel("Crosshatch pattern")).setState(this.project.pref_export_grid_crosshatch_show.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_grid_crosshatch_show", "Include coloured diagonal crosshatch pattern behind alignment grid.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_show_display_id").setCaptionLabel("Display ID")).setState(this.project.pref_export_show_display_id.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_show_display_id", "Show Display ID.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_show_displaygroup_id").setCaptionLabel("Display Group ID")).setState(this.project.pref_export_show_displaygroup_id.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_show_displaygroup_id", "Show Display Group ID.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_show_displaygroup_name").setCaptionLabel("Display Group Name")).setState(this.project.pref_export_show_displaygroup_name.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_show_displaygroup_name", "Show Display Group name.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_show_info_overlay").setCaptionLabel("Grid Info Overlay")).setState(this.project.pref_export_show_info_overlay.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_show_info_overlay", "Show info overlay with the dimensions of the grid image and cells.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_show_display_coordinates").setCaptionLabel("Display coordinates")).setState(this.project.pref_export_show_display_coordinates.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_show_display_coordinates", "Show Display centre coordinates.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_show_column_row_numbers").setCaptionLabel("Column/row numbers")).setState(this.project.pref_export_show_column_row_numbers.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_show_column_row_numbers", "Show column & row number of Displays.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_show_softedge_text").setCaptionLabel("Softedge text overlay")).setState(this.project.pref_export_show_softedge_text.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_show_softedge_text", "Show text overlay in softedges to aid lineup.");
        ((Toggle)((Toggle)this.ui_elements.controls.addToggle("toggle_export_display_data").setCaptionLabel("Display Data:")).moveTo("group_export")).setState(this.project.pref_export_display_data.booleanValue());
        this.ui_elements.control_tooltips.set("toggle_export_display_data", "Export Display data for the project.");
        ((Toggle)((Toggle)this.ui_elements.controls.addToggle("toggle_export_pixel_grid").setCaptionLabel("Pixel Grid")).moveTo("group_export")).setState(this.project.pref_export_pixel_grid.booleanValue());
        this.ui_elements.control_tooltips.set("toggle_export_pixel_grid", "Create pixel alignment image for the projection surface of each Display Group.");
        ((Toggle)((Toggle)this.ui_elements.controls.addToggle("toggle_export_physical_grid").setCaptionLabel("Physical Grid")).moveTo("group_export")).setState(this.project.pref_export_physical_grid.booleanValue()).setLock(true);
        this.ui_elements.control_tooltips.set("toggle_export_physical_grid", "Create physical reference image for the projection surface.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_colourbars").setCaptionLabel("Colour Bars")).setState(this.project.pref_export_colourbars.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_colourbars", "Export colour bars at the resolution of the currently selected Display Group.");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_export_psd_jsx").setCaptionLabel("PSD JSX script")).setState(this.project.pref_export_colourbars.booleanValue()).moveTo("group_export");
        this.ui_elements.control_tooltips.set("toggle_export_psd_jsx", "Export a JSX script file to generate a Photoshop PSD file with all Display Groups.");
        ((Button)((Button)this.ui_elements.controls.addButton("button_display_data_export").setLabel("Export Files")).setColorBackground(this.color(0, 180, 0))).moveTo("group_export");
        this.ui_elements.control_tooltips.set("button_display_data_export", "Export with current settings.");
        ((Button)((Button)this.ui_elements.controls.addButton("button_display_data_copy").setLabel("Copy Data")).setColorBackground(this.color(0, 180, 0))).moveTo("group_export");
        this.ui_elements.control_tooltips.set("button_display_data_copy", "Copy Display data to clipboard.");
        String version_text = "DISPLAY BUILDER\n\n    version " + this.app_version;
        this.ui_elements.controls.addTextlabel("label_version", version_text, 0, 0);
        ((Button)this.ui_elements.controls.addButton("button_link_matkeane").setLabel("matkeane.com")).setColorBackground(this.ui.colour_get_by_name("matkeane"));
        this.ui_elements.control_tooltips.set("button_link_matkeane", "Visit my web site for more information about this app or to check for updates: " + this.web_button_url);
        Textarea ui_licence_textarea = this.ui_elements.controls.addTextarea("licence_textarea");
        String licence_text = "";
        licence_text = "Display Layout Utility for Media Servers.\n";
        licence_text = String.valueOf(licence_text) + "\u00a9 copyright 2013-" + this.copyright_year_end + " Matthew Keane \n";
        licence_text = String.valueOf(licence_text) + "Built with Processing\n";
        licence_text = String.valueOf(licence_text) + "\n";
        licence_text = String.valueOf(licence_text) + "Permission to use, copy, modify, and/or distribute this software for any purpose ";
        licence_text = String.valueOf(licence_text) + "with or without fee is hereby granted, provided that the above copyright notice ";
        licence_text = String.valueOf(licence_text) + "and this permission notice appear in all copies.\n";
        licence_text = String.valueOf(licence_text) + "\n";
        licence_text = String.valueOf(licence_text) + "THE SOFTWARE IS PROVIDED \"AS IS\" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH ";
        licence_text = String.valueOf(licence_text) + "REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND ";
        licence_text = String.valueOf(licence_text) + "FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, ";
        licence_text = String.valueOf(licence_text) + "INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS ";
        licence_text = String.valueOf(licence_text) + "OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER ";
        licence_text = String.valueOf(licence_text) + "TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF ";
        licence_text = String.valueOf(licence_text) + "THIS SOFTWARE.";
        ui_licence_textarea.setText(licence_text);
        String menu_caption = "";
        menu_caption = "Guides";
        this.ui.dropdownlist_guides = this.ui_elements.controls.addScrollableList("menu_guide_image", 0, 0, 20, 20);
        this.ui.dropdownlist_guides.setBackgroundColor(this.color(120));
        this.ui.dropdownlist_guides.setCaptionLabel(menu_caption);
        this.ui.dropdownlist_guides.setBarHeight(20);
        this.ui.dropdownlist_guides.setItemHeight(18);
        this.ui.dropdownlist_guides.setValue(0.0f);
        this.ui.dropdownlist_guides.setOpen(false);
        this.ui.dropdownlist_guides.moveTo("group_guides");
        this.ui_elements.control_tooltips.set("menu_guide_image", "Select a Guide.");
        menu_caption = "Parent";
        this.ui.dropdownlist_guide_parent = this.ui_elements.controls.addScrollableList("menu_guide_parent", 0, 0, 20, 20);
        this.ui.dropdownlist_guide_parent.setBackgroundColor(this.color(120));
        this.ui.dropdownlist_guide_parent.setCaptionLabel(menu_caption);
        this.ui.dropdownlist_guide_parent.setBarHeight(20);
        this.ui.dropdownlist_guide_parent.setItemHeight(18);
        this.ui.dropdownlist_guide_parent.setValue(0.0f);
        this.ui.dropdownlist_guide_parent.setOpen(false);
        this.ui.dropdownlist_guide_parent.moveTo("group_guides");
        this.ui_elements.control_tooltips.set("menu_guide_parent", "Select a parent Display Group for the current Guide.");
        menu_caption = "Tier 1: Main";
        this.ui.dropdownlist_stage_tiers = this.ui_elements.controls.addScrollableList("menu_stagetiers", 20, 0, 190, 100);
        this.ui.dropdownlist_stage_tiers.setBackgroundColor(this.color(120));
        this.ui.dropdownlist_stage_tiers.setCaptionLabel(menu_caption);
        this.ui.dropdownlist_stage_tiers.addItem(menu_caption, (Object)0);
        this.ui.dropdownlist_stage_tiers.setBarHeight(20);
        this.ui.dropdownlist_stage_tiers.setItemHeight(18);
        this.ui.dropdownlist_stage_tiers.setValue(0.0f);
        this.ui.dropdownlist_stage_tiers.setOpen(false);
        this.ui.dropdownlist_stage_tiers.moveTo("group_displaygroups");
        this.ui_elements.control_tooltips.set("menu_stagetiers", "Select a Stage Tier.");
        menu_caption = "Group 1: Default";
        this.ui.dropdownlist_display_groups = this.ui_elements.controls.addScrollableList("menu_displaygroups", 20, 0, 190, 100);
        this.ui.dropdownlist_display_groups.setBackgroundColor(this.color(120));
        this.ui.dropdownlist_display_groups.setCaptionLabel(menu_caption);
        this.ui.dropdownlist_display_groups.addItem(menu_caption, (Object)0);
        this.ui.dropdownlist_display_groups.setBarHeight(20);
        this.ui.dropdownlist_display_groups.setItemHeight(18);
        this.ui.dropdownlist_display_groups.setValue(0.0f);
        this.ui.dropdownlist_display_groups.setOpen(false);
        this.ui.dropdownlist_display_groups.moveTo("group_displaygroups");
        this.ui_elements.control_tooltips.set("menu_displaygroups", "Select a Display Group.");
        menu_caption = "Display Type";
        this.ui.dropdownlist_display_type = this.ui_elements.controls.addScrollableList("menu_display_type", 250, 0, 220, 100);
        this.ui.dropdownlist_display_type.setBackgroundColor(this.color(120));
        this.ui.dropdownlist_display_type.setCaptionLabel(menu_caption);
        this.ui.dropdownlist_display_type.setBarHeight(20);
        this.ui.dropdownlist_display_type.setItemHeight(18);
        this.ui.dropdownlist_display_type.addItem("2D Display", (Object)0);
        this.ui.dropdownlist_display_type.addItem("2D Preview", (Object)1);
        this.ui.dropdownlist_display_type.addItem("Virtual Display", (Object)2);
        this.ui.dropdownlist_display_type.addItem("3D Display", (Object)3);
        this.ui.dropdownlist_display_type.setOpen(false);
        this.ui.dropdownlist_display_type.setLock(true);
        this.ui.dropdownlist_display_type.moveTo("group_display_setup");
        this.ui_elements.control_tooltips.set("menu_display_type", "Choose the type of Display for this Display Group.");
        menu_caption = "Display Resolution: " + this.project.current_displaygroup.display_resolution.x + "x" + this.project.current_displaygroup.display_resolution.y;
        this.ui.dropdownlist_resolutions = this.ui_elements.controls.addScrollableList("menu_resolution_presets", 250, 0, 220, 100);
        this.ui.dropdownlist_resolutions.setBackgroundColor(this.color(120));
        this.ui.dropdownlist_resolutions.setCaptionLabel(menu_caption);
        this.ui.dropdownlist_resolutions.setBarHeight(20);
        this.ui.dropdownlist_resolutions.setItemHeight(18);
        this.ui.dropdownlist_resolutions.setOpen(false);
        this.ui.dropdownlist_resolutions.moveTo("group_display_setup");
        this.ui_elements.control_tooltips.set("menu_resolution_presets", "Choose a resolution preset.");
        menu_caption = "";
        this.ui.dropdownlist_parent_group = this.ui_elements.controls.addScrollableList("menu_displaygroup_parent", 0, 0, 20, 20);
        this.ui.dropdownlist_parent_group.setBackgroundColor(this.color(120));
        this.ui.dropdownlist_parent_group.setCaptionLabel(menu_caption);
        this.ui.dropdownlist_parent_group.setBarHeight(20);
        this.ui.dropdownlist_parent_group.setItemHeight(18);
        this.ui.dropdownlist_parent_group.addItem("Stage", (Object)-1);
        this.ui.dropdownlist_parent_group.setValue(0.0f);
        this.ui.dropdownlist_parent_group.setOpen(false);
        this.ui.dropdownlist_parent_group.moveTo("group_display_layout");
        this.ui_elements.control_tooltips.set("menu_displaygroup_parent", "Select a parent Display Group for the current Display Group. By default the current position is maintained; Hold Shift to reset the offset to zero.");
        menu_caption = "Alignment Grid";
        this.ui.dropdownlist_export_grid_unit = this.ui_elements.controls.addScrollableList("menu_export_grid_unit", 250, 0, 220, 100);
        this.ui.dropdownlist_export_grid_unit.setBackgroundColor(this.color(120));
        this.ui.dropdownlist_export_grid_unit.setCaptionLabel(menu_caption);
        this.ui.dropdownlist_export_grid_unit.setBarHeight(20);
        this.ui.dropdownlist_export_grid_unit.setItemHeight(18);
        this.ui.dropdownlist_export_grid_unit.addItem("None", (Object)0);
        this.ui.dropdownlist_export_grid_unit.addItem("Pixel Grid", (Object)1);
        this.ui.dropdownlist_export_grid_unit.addItem("Grid Squares", (Object)2);
        this.ui.dropdownlist_export_grid_unit.setValue((float)this.project.pref_export_grid_cell_unit);
        this.ui.dropdownlist_export_grid_unit.setOpen(false);
        this.ui.dropdownlist_export_grid_unit.setLock(false);
        this.ui.dropdownlist_export_grid_unit.moveTo("group_export");
        this.ui_elements.control_tooltips.set("menu_export_grid_unit", "Choose the type of alignment grid for exported lineup images.");
        menu_caption = "Export formats.";
        this.ui.dropdownlist_export_formats = this.ui_elements.controls.addScrollableList("menu_export_format", 0, 0, 140, 100);
        this.ui.dropdownlist_export_formats.setBackgroundColor(this.color(120));
        this.ui.dropdownlist_export_formats.setCaptionLabel(menu_caption);
        this.ui.dropdownlist_export_formats.setBarHeight(20);
        this.ui.dropdownlist_export_formats.setItemHeight(18);
        int export_format_count = this.export_manager.export_format_count_get();
        int i5 = 0;
        while (i5 < export_format_count) {
            int export_id = this.export_manager.format_lookup_list[i5];
            String item_label = this.export_manager.format_label_list.get(export_id);
            this.ui.dropdownlist_export_formats.addItem(item_label, (Object)i5);
            ++i5;
        }
        this.ui.dropdownlist_export_formats.setValue(0.0f);
        this.ui.dropdownlist_export_formats.setOpen(false);
        this.ui.dropdownlist_export_formats.moveTo("group_export");
        this.ui_elements.control_tooltips.set("menu_export_format", "Choose the data/file format for exports.");
        this.ui.ready = true;
        this.ui_elements.move_controls();
        this.ui_elements.update_all_controls();
        this.ui_elements.displaygroup_menu_update();
        this.ui_elements.resolutions_menu_update();
        this.debug_output("UI elements setup: " + this.ui.ready);
    }

    public PVector alignment_id_as_vector(int alignment_id) {
        PVector alignment_vector = new PVector(0.0f, 0.0f);
        switch (alignment_id) {
            case 0: {
                alignment_vector.x = 1.0f;
                alignment_vector.y = 1.0f;
                break;
            }
            case 1: {
                alignment_vector.x = 0.0f;
                alignment_vector.y = 1.0f;
                break;
            }
            case 2: {
                alignment_vector.x = -1.0f;
                alignment_vector.y = 1.0f;
                break;
            }
            case 3: {
                alignment_vector.x = 1.0f;
                alignment_vector.y = 0.0f;
                break;
            }
            case 4: {
                alignment_vector.x = 0.0f;
                alignment_vector.y = 0.0f;
                break;
            }
            case 5: {
                alignment_vector.x = -1.0f;
                alignment_vector.y = 0.0f;
                break;
            }
            case 6: {
                alignment_vector.x = 1.0f;
                alignment_vector.y = -1.0f;
                break;
            }
            case 7: {
                alignment_vector.x = 0.0f;
                alignment_vector.y = -1.0f;
                break;
            }
            case 8: {
                alignment_vector.x = -1.0f;
                alignment_vector.y = -1.0f;
            }
        }
        return alignment_vector;
    }

    public int[] alignment_apply_to_bounds(PVector dimensions, int alignment_id) {
        PVector alignment_multiplier = this.ui.alignment_position_vectors[alignment_id].copy();
        int[] nArray = new int[4];
        nArray[1] = Display_Builder_4.round((float)dimensions.x);
        nArray[2] = Display_Builder_4.round((float)dimensions.y);
        int[] bounds = nArray;
        bounds[0] = bounds[0] + Display_Builder_4.floor((float)(dimensions.y * alignment_multiplier.y));
        bounds[1] = bounds[1] + Display_Builder_4.floor((float)(dimensions.x * alignment_multiplier.x));
        bounds[2] = bounds[2] + Display_Builder_4.floor((float)(dimensions.y * alignment_multiplier.y));
        bounds[3] = bounds[3] + Display_Builder_4.floor((float)(dimensions.x * alignment_multiplier.x));
        return bounds;
    }

    public String app_signature_get() {
        String app_signature = "Generated by Display Builder (v" + this.app_version + ") on " + this.get_current_date_string() + " - matkeane.com";
        return app_signature;
    }

    public String aspect_ratio_as_string(float ratio) {
        return Display_Builder_4.nf((float)ratio, (int)1, (int)2);
    }

    public float aspect_ratio_calculate(PVector dimensions) {
        float aspect_ratio = dimensions.x / dimensions.y;
        return aspect_ratio;
    }

    public float aspect_ratio_calculate(int resolution_x, int resolution_y) {
        float aspect_ratio = PApplet.parseFloat((int)resolution_x) / PApplet.parseFloat((int)resolution_y);
        return aspect_ratio;
    }

    public int binary_mask_get_for_id(int id) {
        String id_mask_string = "1";
        int i = 0;
        while (i < id) {
            id_mask_string = String.valueOf(id_mask_string) + "0";
            ++i;
        }
        return Display_Builder_4.unbinary((String)id_mask_string);
    }

    public float calculate_reciprocal_scale() {
        return 1.0f / (this.ui.viewport_scale / 100.0f);
    }

    public int check_memory() {
        int mem_max = PApplet.parseInt((float)Runtime.getRuntime().maxMemory());
        int mem_total = PApplet.parseInt((float)Runtime.getRuntime().totalMemory());
        int mem_free = PApplet.parseInt((float)Runtime.getRuntime().freeMemory());
        int mem_available = mem_total - mem_free;
        int MEGABYTE = 0x100000;
        String mem_output = "Memory";
        mem_output = String.valueOf(mem_output) + " Max: " + mem_max + " (" + mem_max / MEGABYTE + "Mb)";
        mem_output = String.valueOf(mem_output) + " Total: " + mem_total + " (" + mem_total / MEGABYTE + "Mb)";
        mem_output = String.valueOf(mem_output) + " Free: " + mem_free + " (" + mem_free / MEGABYTE + "Mb)";
        mem_output = String.valueOf(mem_output) + " Available: " + mem_available + " (" + mem_available / MEGABYTE + "Mb)";
        this.debug_output(mem_output);
        return mem_max;
    }

    public String convert_stringlist_to_string(StringList string_list) {
        String string_output = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)string_list);
        return string_output;
    }

    public String coordinates_get_as_string(int coord_x, int coord_y) {
        return "[" + coord_x + "," + coord_y + "]";
    }

    public String coordinates_get_as_string(PVector coordinates) {
        return "[" + Display_Builder_4.nf((float)coordinates.x, (int)0, (int)0) + "," + Display_Builder_4.nf((float)coordinates.y, (int)0, (int)0) + "]";
    }

    public void clipboard_contents_set(String clipboard_text) {
        StringSelection stringSelection = new StringSelection(clipboard_text);
        Clipboard system_clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        system_clipboard.setContents(stringSelection, null);
    }

    public String clipboard_contents_get() {
        String clipboard_contents_string = "";
        try {
            Clipboard system_clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = system_clipboard.getContents(null);
            if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    clipboard_contents_string = (String)contents.getTransferData(DataFlavor.stringFlavor);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        return clipboard_contents_string;
    }

    public void debug_output(String debug_string) {
        if (this.debug_mode.booleanValue()) {
            Display_Builder_4.println((String)debug_string);
        }
    }

    public PVector dimensions_from_bounds(int[] surface_bounds) {
        PVector dimensions = new PVector((float)(surface_bounds[1] - surface_bounds[3] + 1), (float)(surface_bounds[2] - surface_bounds[0] + 1));
        return dimensions;
    }

    public void file_get_size(File file_check) {
        if (file_check.exists()) {
            double bytes = file_check.length();
            double kilobytes = bytes / 1024.0;
            double megabytes = kilobytes / 1024.0;
            double gigabytes = megabytes / 1024.0;
            double terabytes = gigabytes / 1024.0;
            double petabytes = terabytes / 1024.0;
            double exabytes = petabytes / 1024.0;
            double d = exabytes / 1024.0;
        } else {
            this.debug_output("File does not exists!");
        }
    }

    public float get_angle_as_fraction(float angle) {
        float angle_degrees = Display_Builder_4.degrees((float)angle);
        float angle_fraction = 1.0f / (360.0f / angle_degrees);
        return angle_fraction;
    }

    public int boolean_to_int(Boolean boolean_value) {
        if (boolean_value.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public Boolean boolean_from_string(String boolean_string_value) {
        if (boolean_string_value.equals("true")) {
            return true;
        }
        if (boolean_string_value.equals("false")) {
            return false;
        }
        return null;
    }

    public String boolean_to_string(Boolean boolean_value) {
        if (boolean_value.booleanValue()) {
            return "true";
        }
        return "false";
    }

    public Boolean colour_compare_match(int colour_1, int colour_2) {
        int[] colour_1_rgba = this.get_color_rgb_values(colour_1);
        int[] colour_2_rgba = this.get_color_rgb_values(colour_2);
        int tolerance = 10;
        if (Display_Builder_4.abs((int)(colour_1_rgba[0] - colour_2_rgba[0])) < tolerance && Display_Builder_4.abs((int)(colour_1_rgba[1] - colour_2_rgba[1])) < tolerance && Display_Builder_4.abs((int)(colour_1_rgba[2] - colour_2_rgba[2])) < tolerance) {
            return true;
        }
        return false;
    }

    public int colour_generate_hue_shift(int base_colour, int index) {
        this.colorMode(3, 360.0f, 100.0f, 100.0f, 100.0f);
        float hue_origin = this.hue(base_colour);
        float sat = this.saturation(base_colour);
        float bri = this.brightness(base_colour);
        float hue_shift = (hue_origin + (float)(index * 137)) % 360.0f;
        int new_colour = this.color(hue_shift, sat, bri);
        this.colorMode(1, 255.0f);
        return new_colour;
    }

    public int get_colour_from_status(Boolean status, Boolean invert) {
        if (invert.booleanValue()) {
            status = status == false;
        }
        if (status.booleanValue()) {
            return this.ui.colours.get("ui_element_enabled");
        }
        return this.ui.colours.get("ui_element_disabled");
    }

    public int[] get_color_rgb_values(int check_color) {
        int[] nArray = new int[4];
        nArray[3] = 255;
        int[] color_rgba = nArray;
        color_rgba[0] = check_color >> 16 & 0xFF;
        color_rgba[1] = check_color >> 8 & 0xFF;
        color_rgba[2] = check_color & 0xFF;
        return color_rgba;
    }

    public String get_color_rgb_values_string(int check_color) {
        String[] color_rgba = new String[]{"0", "0", "0", "255"};
        color_rgba[0] = String.valueOf(check_color >> 16 & 0xFF);
        color_rgba[1] = String.valueOf(check_color >> 8 & 0xFF);
        color_rgba[2] = String.valueOf(check_color & 0xFF);
        String rgba_output = Display_Builder_4.join((String[])color_rgba, (String)", ");
        return rgba_output;
    }

    public String get_current_date_string() {
        String date_string = "";
        String date_separator = "-";
        int d = Display_Builder_4.day();
        int m = Display_Builder_4.month();
        int y = Display_Builder_4.year();
        date_string = String.valueOf(date_string) + String.valueOf(y);
        date_string = String.valueOf(date_string) + date_separator;
        date_string = String.valueOf(date_string) + Display_Builder_4.nf((float)m, (int)2, (int)0);
        date_string = String.valueOf(date_string) + date_separator;
        date_string = String.valueOf(date_string) + Display_Builder_4.nf((float)d, (int)2, (int)0);
        return date_string;
    }

    public Boolean file_extension_check(String checkfile, String file_type_check) {
        String checkfile_extension = this.file_extension_get(checkfile).toLowerCase();
        StringList valid_file_extensions = new StringList();
        if (file_type_check.equals("image")) {
            valid_file_extensions.append("jpg");
            valid_file_extensions.append("png");
        }
        if (file_type_check.equals("project")) {
            valid_file_extensions.append("xml");
        }
        if (file_type_check.equals("surface")) {
            valid_file_extensions.append("obj");
        }
        return valid_file_extensions.hasValue(checkfile_extension);
    }

    public String file_extension_get(String filename) {
        String file_extension = "";
        int pos = filename.lastIndexOf(".");
        if (pos > 0) {
            file_extension = filename.substring(pos + 1);
        }
        return file_extension;
    }

    public String file_get_name_without_extension(String filename) {
        return filename.replaceFirst("[.][^.]+$", "");
    }

    public String get_float_as_integer_string(float floatval) {
        return Integer.toString(Display_Builder_4.round((float)floatval));
    }

    public String get_formatted_float_string(float floatval) {
        return Display_Builder_4.nfs((float)floatval, (int)1, (int)2);
    }

    public int get_id_from_number(int number) {
        return number - 1;
    }

    public int get_number_from_id(int index) {
        return index + 1;
    }

    public int get_resolution_uid() {
        return this.project.resolutions_list.size();
    }

    public int grid_cell_count_from_dimension(Float dimension, Float cell_size) {
        dimension = Float.valueOf(Display_Builder_4.max((float)0.0f, (float)dimension.floatValue()));
        return Display_Builder_4.ceil((float)(dimension.floatValue() / cell_size.floatValue()));
    }

    public int highest_common_factor(int a, int b) {
        if (b == 0) {
            return a;
        }
        return this.highest_common_factor(b, a % b);
    }

    public String human_readable_number_string(int number) {
        if (number >= 1000000000) {
            return String.valueOf(Display_Builder_4.nf((float)((float)number / 1.0E9f), (int)0, (int)2)) + "B";
        }
        if (number >= 1000000) {
            return String.valueOf(Display_Builder_4.nf((float)((float)number / 1000000.0f), (int)0, (int)2)) + "M";
        }
        if (number >= 1000) {
            return String.valueOf(Display_Builder_4.nf((float)((float)number / 1000.0f), (int)0, (int)1)) + "K";
        }
        return String.valueOf(number);
    }

    public String indent(int indent_count) {
        String output = "";
        String padding = "  ";
        int i = 0;
        while (i < indent_count) {
            output = String.valueOf(output) + padding;
            ++i;
        }
        return output;
    }

    public boolean is_float(String string) {
        try {
            Float.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean is_mouse_within_ui_pane() {
        return this.mouseY > this.height - this.ui_elements.pane_height;
    }

    public boolean is_integer(String string) {
        try {
            Integer.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String locale_float_convert(String string) {
        if (string.indexOf(",") >= 0) {
            string = string.replaceAll(",", ".");
        }
        return string;
    }

    public float parse_math_string_expression(String input_string) {
        String match_decimal_string = "(\\-?\\d*\\.?\\d+|\\-\\d+\\.?\\d*)";
        String match_math_operators = "(\\-|\\+|\\*|\\/)";
        String match_pattern = String.valueOf(match_decimal_string) + match_math_operators + match_decimal_string;
        String target_string = this.locale_float_convert(input_string);
        String[][] match_array = Display_Builder_4.matchAll((String)target_string, (String)match_pattern);
        float result = 0.0f;
        if (match_array != null && match_array[0].length >= 4 && this.is_float(match_array[0][1]) && this.is_float(match_array[0][3])) {
            Float value_base = Float.valueOf(match_array[0][1]);
            Float value_factor = Float.valueOf(match_array[0][3]);
            String math_operator = match_array[0][2];
            if (math_operator.equals("+")) {
                result = value_base.floatValue() + value_factor.floatValue();
            }
            if (math_operator.equals("-")) {
                result = value_base.floatValue() - value_factor.floatValue();
            }
            if (math_operator.equals("*")) {
                result = value_base.floatValue() * value_factor.floatValue();
            }
            if (math_operator.equals("/")) {
                result = value_base.floatValue() / value_factor.floatValue();
            }
            return result;
        }
        if (this.is_float(input_string)) {
            return Float.valueOf(input_string).floatValue();
        }
        return 0.0f;
    }

    public MixedInputResult parse_mixed_input(String input_string) {
        MixedInputResult parsed_result = new MixedInputResult(false, 0.0f, "");
        String match_pattern = "(\\-)?(\\d+).?,?(\\d*)\\s*?(?i)(cm|ft|f|in|i|(?<!c)m|px)";
        String[][] match_array = Display_Builder_4.matchAll((String)input_string, (String)match_pattern);
        if (match_array != null) {
            String value_string;
            if (match_array[0][1] == null) {
                match_array[0][1] = "+";
            }
            if (this.is_float(value_string = String.valueOf(match_array[0][1]) + match_array[0][2] + "." + match_array[0][3])) {
                float parsed_value = Float.valueOf(value_string).floatValue();
                String parsed_unit = match_array[0][4].toUpperCase();
                if (parsed_unit.equals("I")) {
                    parsed_unit = "IN";
                }
                if (parsed_unit.equals("F")) {
                    parsed_unit = "FT";
                }
                parsed_result.status = true;
                parsed_result.value = parsed_value;
                parsed_result.text = parsed_unit;
                return parsed_result;
            }
            return null;
        }
        return null;
    }

    public int convert_unit_size_to_pixels(float input_value, String input_unit) {
        int pixel_size = 0;
        if (this.project.physical_settings_active_get().booleanValue()) {
            if (input_unit.equals("PX")) {
                pixel_size = Display_Builder_4.round((float)input_value);
            } else {
                if (input_unit.equals("CM")) {
                    input_value *= 0.01f;
                }
                if (input_unit.equals("FT")) {
                    input_value *= 0.3048f;
                }
                if (input_unit.equals("IN")) {
                    input_value *= 0.0254f;
                }
                pixel_size = Display_Builder_4.round((float)this.physical_to_pixels(input_value));
            }
        }
        return pixel_size;
    }

    public float physical_to_pixels(float physical_size) {
        float pixel_size = physical_size * this.project.viewport_physical_scale;
        return pixel_size;
    }

    public float pixels_to_physical(float pixel_value) {
        float physical_value = 0.0f;
        if (this.project.physical_settings_active_get().booleanValue()) {
            physical_value = pixel_value / this.project.viewport_physical_scale;
        }
        return physical_value;
    }

    public String physical_dimension_get_as_string(float physical_dimension) {
        return Display_Builder_4.nf((float)physical_dimension, (int)0, (int)2);
    }

    public Float[] rect_rotated_bounds_calculate(PVector[] rect_vertices) {
        Float[] rect_rotated_bounds = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
        int i = 0;
        while (i < 4) {
            rect_rotated_bounds[0] = Float.valueOf(Display_Builder_4.min((float)rect_rotated_bounds[0].floatValue(), (float)rect_vertices[i].y));
            rect_rotated_bounds[1] = Float.valueOf(Display_Builder_4.max((float)rect_rotated_bounds[1].floatValue(), (float)rect_vertices[i].x));
            rect_rotated_bounds[2] = Float.valueOf(Display_Builder_4.max((float)rect_rotated_bounds[2].floatValue(), (float)rect_vertices[i].y));
            rect_rotated_bounds[3] = Float.valueOf(Display_Builder_4.min((float)rect_rotated_bounds[3].floatValue(), (float)rect_vertices[i].x));
            ++i;
        }
        return rect_rotated_bounds;
    }

    public PVector[] rect_rotated_vertices_calculate(PVector rect_position, PVector rect_dimensions, Float rect_rotation) {
        Float cos_angle = Float.valueOf(Display_Builder_4.cos((float)rect_rotation.floatValue()));
        Float sin_angle = Float.valueOf(Display_Builder_4.sin((float)rect_rotation.floatValue()));
        PVector dimensions_half = PVector.mult((PVector)rect_dimensions, (float)0.5f);
        PVector vertex_top_left = new PVector(rect_position.x - dimensions_half.x * cos_angle.floatValue() - dimensions_half.y * sin_angle.floatValue(), rect_position.y - dimensions_half.x * sin_angle.floatValue() + dimensions_half.y * cos_angle.floatValue());
        PVector vertex_top_right = new PVector(rect_position.x + dimensions_half.x * cos_angle.floatValue() - dimensions_half.y * sin_angle.floatValue(), rect_position.y + dimensions_half.x * sin_angle.floatValue() + dimensions_half.y * cos_angle.floatValue());
        PVector vertex_bottom_right = new PVector(rect_position.x + dimensions_half.x * cos_angle.floatValue() + dimensions_half.y * sin_angle.floatValue(), rect_position.y + dimensions_half.x * sin_angle.floatValue() - dimensions_half.y * cos_angle.floatValue());
        PVector vertex_bottom_left = new PVector(rect_position.x - dimensions_half.x * cos_angle.floatValue() + dimensions_half.y * sin_angle.floatValue(), rect_position.y - dimensions_half.x * sin_angle.floatValue() - dimensions_half.y * cos_angle.floatValue());
        PVector[] rect_vertex_coords = new PVector[]{vertex_top_left, vertex_top_right, vertex_bottom_right, vertex_bottom_left};
        return rect_vertex_coords;
    }

    public int round_up_to_multiple(int numToRound, int multiple) {
        if (multiple == 0) {
            return numToRound;
        }
        int remainder = numToRound % multiple;
        if (remainder == 0) {
            return numToRound;
        }
        return numToRound + (multiple - remainder);
    }

    public String sanitize_string_csv(String source_string) {
        String csv_safe_string = source_string.replaceAll(",", "-");
        return csv_safe_string;
    }

    public String sanitize_network_string(String name) {
        String name_trimmed = name.trim();
        String machine_name = name_trimmed.replaceAll("\\s", "_");
        machine_name = machine_name.toLowerCase();
        return machine_name;
    }

    public String sanitize_file_name(String name) {
        String name_trimmed = name.trim();
        String file_name_stripquotes = name_trimmed.replaceAll("'", "");
        String file_name_hyphens = file_name_stripquotes.replaceAll("\\s", "-");
        String file_name = file_name_hyphens.replaceAll("[^A-Za-z0-9-]", "_");
        return file_name;
    }

    public float screen_to_stage(int screen_pos) {
        float screen_stage_translate = this.calculate_reciprocal_scale();
        return (float)screen_pos * screen_stage_translate;
    }

    public PVector screen_to_stage(PVector screen_position) {
        PVector screen_stage_translated = PVector.sub((PVector)screen_position, (PVector)this.ui.viewport);
        screen_stage_translated = PVector.mult((PVector)screen_stage_translated, (float)this.calculate_reciprocal_scale());
        return screen_stage_translated;
    }

    public float softedge_to_percent(int soft_px, int display_dimension) {
        return Display_Builder_4.map((float)soft_px, (float)0.0f, (float)display_dimension, (float)0.0f, (float)100.0f);
    }

    public int softedge_to_pixels(float soft_pc, int display_dimension) {
        return Display_Builder_4.round((float)Display_Builder_4.map((float)soft_pc, (float)0.0f, (float)100.0f, (float)0.0f, (float)display_dimension));
    }

    public float stage_to_screen(float source) {
        float stage_to_screen = source * (this.ui.viewport_scale / 100.0f);
        return stage_to_screen;
    }

    public PVector stage_to_screen(PVector stage_position) {
        return PVector.mult((PVector)stage_position, (float)(this.ui.viewport_scale / 100.0f));
    }

    public PVector stage_to_surface(PVector stage_point) {
        PVector surface_point = new PVector(0.0f, 0.0f);
        surface_point.x = stage_point.x - (float)this.project.current_displaygroup.projection_surface_bounds[3];
        surface_point.y = stage_point.y - (float)this.project.current_displaygroup.projection_surface_bounds[0];
        return surface_point;
    }

    public String status_lock_get_as_text(Boolean status_locked) {
        if (status_locked.booleanValue()) {
            return "LOCKED";
        }
        return "UNLOCKED";
    }

    public String status_visible_get_as_text(Boolean status_visible) {
        if (status_visible.booleanValue()) {
            return "VISIBLE";
        }
        return "INVISIBLE";
    }

    public Boolean toggle_status(boolean current_status) {
        return !current_status;
    }

    public int toggle_status(int current_status) {
        if (current_status == 1) {
            return 0;
        }
        return 1;
    }

    public String truncate_string(String string_original, int max_length) {
        String string_truncated = string_original.substring(0, Display_Builder_4.min((int)max_length, (int)string_original.length()));
        return string_truncated;
    }

    public String uuid_string_get() {
        return UUID.randomUUID().toString();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Display_Builder_4"};
        if (passedArgs != null) {
            PApplet.main((String[])Display_Builder_4.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class DisplayGroup {
        int id;
        String name;
        Boolean group_active;
        IntList child_displaygroup_ids;
        IntList child_guide_ids;
        DisplayResolution resolution;
        int display_type;
        PVector anchor_point;
        int anchor_alignment_id;
        int stagetier_id;
        DisplayGroup parent_displaygroup;
        int parent_group_id;
        int parent_alignment_id;
        PVector parent_offset;
        PVector softedge_dimensions;
        int[] projection_surface_bounds = new int[4];
        float physical_scale;
        float stage_scale;
        int player_count;
        String player_name_prefix;
        int player_outputs_count;
        int player_outputs_start_number = 1;
        Boolean player_output_one_reserved = false;
        Boolean player_outputs_sharing;
        int player_outputs_shared_count;
        int player_start_number = 1;
        String display_basename;
        int display_cols;
        int display_rows;
        Boolean display_invert_cols_rows = false;
        int outline_colour;
        int display_colour_mode;
        float display_rotation;
        PVector display_resolution;
        Boolean display_aspect_ratio_locked = true;
        Float display_aspect_ratio;
        PVector display_dimensions_stage;
        PVector display_dimensions_physical;
        float display_pixel_density = 0.0f;
        Boolean display_show_43_marks;
        Boolean displays_overrides_active = false;
        int display_selected_id = -1;
        ArrayList<DisplayObject> displays = new ArrayList();

        DisplayGroup() {
            Display_Builder_4.this.project.getClass();
            this.display_type = 0;
            this.displays_overrides_active = false;
            this.group_active = true;
            this.display_basename = "Display_";
            this.player_name_prefix = "Player_";
            this.display_cols = 1;
            this.display_rows = 1;
            this.display_invert_cols_rows = false;
            this.player_start_number = 1;
            this.player_outputs_count = 4;
            this.player_outputs_sharing = true;
            this.display_rotation = 0.0f;
            this.stagetier_id_set(0);
            this.parent_group_id = -1;
            this.parent_alignment_id = 0;
            this.anchor_alignment_id = 0;
            this.anchor_point = new PVector(0.0f, 0.0f);
            this.parent_offset = new PVector(0.0f, 0.0f);
            this.softedge_dimensions = new PVector(0.0f, 0.0f);
            this.outline_colour = Display_Builder_4.this.ui.colour_get_by_name("display_stroke");
            this.display_colour_mode = 0;
            this.physical_scale = Display_Builder_4.this.project.viewport_physical_scale;
            this.stage_scale = 1.0f;
            this.resolution = Display_Builder_4.this.project.resolutions_list.get(Display_Builder_4.this.project.default_resolution_id);
            this.display_resolution = Display_Builder_4.this.project.resolution_dimensions_get(Display_Builder_4.this.project.default_resolution_id);
            this.display_aspect_ratio = Float.valueOf(this.resolution.aspect_ratio);
            this.display_show_43_marks = false;
            this.display_dimensions_stage = new PVector(0.0f, 0.0f);
            this.display_dimensions_physical = new PVector(0.0f, 0.0f);
            this.child_displaygroup_ids = new IntList();
            this.child_guide_ids = new IntList();
            this.display_physical_dimensions_calculate();
        }

        public void anchor_point_calculate() {
            PVector delta = new PVector(0.0f, 0.0f);
            PVector parent_alignment_point = new PVector(0.0f, 0.0f);
            if (this.parent_displaygroup != null) {
                parent_alignment_point = this.parent_displaygroup.alignment_point_calculate(this.parent_alignment_id);
            }
            parent_alignment_point.add(this.parent_offset);
            delta = parent_alignment_point.sub(this.anchor_point);
            this.anchor_point_add_offset(delta);
        }

        public void anchor_point_add_offset(PVector delta) {
            this.anchor_point.add(delta);
            Display_Builder_4.this.debug_output("DisplayGroup " + this.id + " anchor_point updated to: " + this.anchor_point.x + "," + this.anchor_point.y);
            if (this.displays_overrides_active.booleanValue()) {
                this.displays_update_parent_position(delta);
            }
            this.child_displaygroups_update();
            this.child_guides_update();
        }

        public void child_displaygroup_id_add(int group_id) {
            if (!this.child_displaygroup_ids.hasValue(group_id)) {
                this.child_displaygroup_ids.append(group_id);
            }
        }

        public void child_displaygroup_id_remove(int group_id) {
            if (this.child_displaygroup_ids.hasValue(group_id)) {
                int index = -1;
                int i = 0;
                while (i < this.child_displaygroup_ids.size()) {
                    if (this.child_displaygroup_ids.get(i) == group_id) {
                        index = i;
                    }
                    ++i;
                }
                if (index >= 0) {
                    this.child_displaygroup_ids.remove(index);
                }
            }
        }

        public PVector child_displaygroup_offset_get() {
            PVector child_offset = new PVector(0.0f, 0.0f);
            if (this.child_displaygroup_ids.size() > 0) {
                DisplayGroup child_displaygroup = Display_Builder_4.this.project.display_groups.get(0);
                return child_displaygroup.parent_offset;
            }
            return child_offset;
        }

        public void child_displaygroups_update() {
            int i = 0;
            while (i < this.child_displaygroup_ids.size()) {
                Display_Builder_4.this.project.displaygroup_update_by_id(this.child_displaygroup_ids.get(i));
                ++i;
            }
        }

        public void child_guide_id_add(int guide_id) {
            if (!this.child_guide_ids.hasValue(guide_id)) {
                this.child_guide_ids.append(guide_id);
            }
        }

        public void child_guide_id_remove(int guide_id) {
            if (this.child_guide_ids.hasValue(guide_id)) {
                int index = -1;
                int i = 0;
                while (i < this.child_guide_ids.size()) {
                    if (this.child_guide_ids.get(i) == guide_id) {
                        index = i;
                    }
                    ++i;
                }
                if (index >= 0) {
                    this.child_guide_ids.remove(index);
                    Display_Builder_4.this.debug_output("Removed Child " + guide_id + " from Parent " + this.id);
                }
            }
        }

        public void child_guide_id_update(int guide_id_old, int guide_id_new) {
            if (this.child_guide_ids.hasValue(guide_id_old)) {
                int index = -1;
                int i = 0;
                while (i < this.child_guide_ids.size()) {
                    if (this.child_guide_ids.get(i) == guide_id_old) {
                        index = i;
                    }
                    ++i;
                }
                if (index >= 0) {
                    this.child_guide_ids.set(index, guide_id_new);
                }
            }
        }

        public void child_guides_update() {
            int i = 0;
            while (i < this.child_guide_ids.size()) {
                PVector group_surface_top_left = new PVector((float)this.projection_surface_bounds[3], (float)this.projection_surface_bounds[0]);
                Display_Builder_4.this.project.guide_update_parent_position(this.child_guide_ids.get(i), group_surface_top_left);
                ++i;
            }
        }

        public int colour_get() {
            return this.outline_colour;
        }

        public void colour_palette_calculate() {
            int[] colour_palette;
            int colour_count;
            block19: {
                int display_count;
                block17: {
                    block18: {
                        Display_Builder_4.this.colorMode(3, 360.0f, 100.0f, 100.0f, 100.0f);
                        display_count = this.display_count_get();
                        colour_count = 1;
                        if (this.display_colour_mode != 4) break block17;
                        int alpha = 50;
                        colour_palette = new int[]{Display_Builder_4.this.color(195, 90, 47, alpha), Display_Builder_4.this.color(170, 55, 85, alpha), Display_Builder_4.this.color(50, 35, 95, alpha), Display_Builder_4.this.color(10, 55, 95, alpha), Display_Builder_4.this.color(340, 80, 80, alpha), Display_Builder_4.this.color(0, 0, 20, alpha), Display_Builder_4.this.color(0, 0, 50, alpha), Display_Builder_4.this.color(0, 0, 80, alpha)};
                        if (!this.display_invert_cols_rows.booleanValue()) break block18;
                        colour_count = Display_Builder_4.min((int)this.display_rows, (int)8);
                        if ((this.display_rows - 1) % colour_count == 0) {
                            --colour_count;
                        }
                        break block19;
                    }
                    colour_count = Display_Builder_4.min((int)this.display_cols, (int)8);
                    if ((this.display_cols - 1) % colour_count != 0) break block19;
                    --colour_count;
                    break block19;
                }
                switch (this.display_colour_mode) {
                    case 1: {
                        colour_count = Display_Builder_4.ceil((float)(PApplet.parseFloat((int)display_count) / (float)this.player_outputs_count));
                        break;
                    }
                    case 2: {
                        if (!this.display_invert_cols_rows.booleanValue()) {
                            colour_count = this.display_rows;
                            break;
                        }
                        colour_count = this.display_cols;
                        break;
                    }
                    case 3: {
                        colour_count = display_count;
                    }
                }
                colour_palette = new int[colour_count];
                colour_palette[0] = this.outline_colour;
                float hue_origin = Display_Builder_4.this.hue(Display_Builder_4.this.ui.colour_get_by_name("display_stroke"));
                float sat = Display_Builder_4.this.saturation(Display_Builder_4.this.ui.colour_get_by_name("display_stroke"));
                float bri = Display_Builder_4.this.brightness(Display_Builder_4.this.ui.colour_get_by_name("display_stroke"));
                float hue_shift = 137.0f;
                int p = 1;
                while (p < colour_count) {
                    float hue_new = (hue_origin + (float)p * hue_shift) % 360.0f;
                    colour_palette[p] = Display_Builder_4.this.color(hue_new, sat, bri);
                    ++p;
                }
            }
            Display_Builder_4.this.colorMode(1, 255.0f);
            int palette_index = 0;
            for (DisplayObject display : this.displays) {
                switch (this.display_colour_mode) {
                    case 1: {
                        if (display.display_id <= 0 || display.display_id % this.player_outputs_count != 0) break;
                        ++palette_index;
                        break;
                    }
                    case 2: {
                        if (this.display_invert_cols_rows.booleanValue()) {
                            palette_index = display.col_id;
                            break;
                        }
                        palette_index = display.row_id;
                        break;
                    }
                    case 3: {
                        palette_index = display.display_id;
                        break;
                    }
                    case 4: {
                        if (this.display_invert_cols_rows.booleanValue()) {
                            palette_index = (display.display_id - display.col_id) % colour_count;
                            break;
                        }
                        palette_index = (display.display_id - display.row_id) % colour_count;
                        break;
                    }
                    default: {
                        palette_index = 0;
                    }
                }
                palette_index = Display_Builder_4.min((int)palette_index, (int)(colour_palette.length - 1));
                palette_index = Display_Builder_4.max((int)palette_index, (int)0);
                display.outline_colour_set(colour_palette[palette_index]);
            }
        }

        public void colour_set(int new_colour) {
            this.outline_colour = new_colour;
            this.colour_palette_calculate();
        }

        public void colour_setting_update(int menu_id) {
            if (menu_id != this.display_colour_mode) {
                this.display_colour_mode = menu_id;
                this.colour_palette_calculate();
            }
        }

        public void debug_info() {
            String output = "Info for DisplayGroup id:" + this.id + ", '" + this.name + "' \n";
            output = String.valueOf(output) + "- Displays: " + this.displays.size() + ", in Cols: " + this.display_cols + ", Rows: " + this.display_rows + ", Invert Cols/Rows: " + this.display_invert_cols_rows + ", Players: " + this.player_count + "\n";
            output = String.valueOf(output) + "- Resolution id: " + this.resolution_id_get() + ", display_width: " + this.display_resolution.x + ", display_height: " + this.display_resolution.y + "\n";
            output = String.valueOf(output) + "- display_rotation: " + this.display_rotation + ", display_width_physical: " + this.display_dimensions_physical.x + ", display_height_physical: " + this.display_dimensions_physical.y + "\n";
            output = String.valueOf(output) + "- stage_scale: " + this.stage_scale + ", physical_scale: " + this.physical_scale + "\n";
            output = String.valueOf(output) + "- Origin: " + this.anchor_point.x + "," + this.anchor_point.y + ", Origin id: " + this.parent_group_id + ", origin_offset: " + this.parent_offset.x + "," + this.parent_offset.y + "\n";
            output = String.valueOf(output) + "- softedge_dimensions: " + this.softedge_dimensions.x + "," + this.softedge_dimensions.y + "\n";
            output = String.valueOf(output) + "- projection_surface_bounds: T:" + this.projection_surface_bounds[0] + ",R:" + this.projection_surface_bounds[1];
            output = String.valueOf(output) + ",B:" + this.projection_surface_bounds[2] + ",L:" + this.projection_surface_bounds[3] + " \n";
            Display_Builder_4.this.debug_output(output);
        }

        public DisplayObject display_add(Boolean defer_update) {
            DisplayObject new_display = new DisplayObject();
            new_display.parent_displaygroup_set(this.id);
            new_display.display_id = this.displays.size();
            new_display.row_id = 1;
            new_display.col_id = new_display.display_id;
            new_display.position.x = this.display_resolution.x / 2.0f;
            new_display.position.y = this.display_resolution.y / 2.0f;
            new_display.rotation = 0.0f;
            new_display.player_number = new_display.display_id + 1;
            this.displays.add(new_display);
            if (this.group_active.booleanValue() && !defer_update.booleanValue()) {
                this.player_count_update();
            }
            return new_display;
        }

        public float display_aspect_ratio_get() {
            return this.display_resolution.x / this.display_resolution.y;
        }

        public void display_aspect_ratio_lock_toggle() {
            this.display_aspect_ratio_locked = this.display_aspect_ratio_locked == false;
        }

        public void display_baseip_set(String ui_input) {
            if (!ui_input.equals("")) {
                this.player_name_prefix = ui_input;
                this.displays_update_strings();
                Display_Builder_4.this.ui_elements.update_display_settings();
            }
        }

        public void display_basename_set(String ui_input) {
            if (!ui_input.equals("")) {
                this.display_basename = ui_input;
                this.displays_update_strings();
                Display_Builder_4.this.ui_elements.update_display_settings();
            }
        }

        public int[] display_centre_offsets_get() {
            int[] display_centre_offset = new int[2];
            PVector display_footprint = this.display_footprint_get();
            display_centre_offset[0] = Display_Builder_4.round((float)(display_footprint.x - this.softedge_dimensions.x));
            display_centre_offset[1] = Display_Builder_4.round((float)(display_footprint.y - this.softedge_dimensions.y));
            return display_centre_offset;
        }

        public int display_count_get() {
            return this.displays.size();
        }

        public void display_count_set(String dimension, int ui_value) {
            int display_count_current = this.display_count_get();
            int new_value = Display_Builder_4.constrain((int)Display_Builder_4.round((float)ui_value), (int)1, (int)Display_Builder_4.this.project.max_array_size);
            Display_Builder_4.this.debug_output("DisplayGroup " + this.id + " set_display_count " + dimension + ": " + new_value);
            if (dimension.equals("h")) {
                this.display_cols = new_value;
            }
            if (dimension.equals("v")) {
                this.display_rows = new_value;
            }
            if (display_count_current != this.display_cols * this.display_rows) {
                Display_Builder_4.this.ui_elements.update_display_counts();
                this.displays_update();
            }
        }

        public void display_count_increment(String dimension, int ui_value) {
            int new_value = 0;
            if (dimension.equals("h")) {
                new_value = this.display_cols + ui_value;
            }
            if (dimension.equals("v")) {
                new_value = this.display_rows + ui_value;
            }
            if (new_value > 0 && new_value < Display_Builder_4.this.project.max_array_size) {
                this.display_count_set(dimension, new_value);
            }
        }

        public PVector display_footprint_get() {
            PVector display_footprint = new PVector(0.0f, 0.0f);
            this.stage_dimensions_display_calculate();
            if (this.display_rotation >= (float)Math.PI * 2) {
                this.display_rotation = 0.0f;
            }
            if (this.rotation_is_landscape().booleanValue()) {
                display_footprint.x = this.display_dimensions_stage.x;
                display_footprint.y = this.display_dimensions_stage.y;
            } else {
                display_footprint.x = this.display_dimensions_stage.y;
                display_footprint.y = this.display_dimensions_stage.x;
            }
            return display_footprint;
        }

        public Boolean display_id_is_valid(int display_id) {
            if (display_id >= 0 && display_id < this.display_count_get()) {
                return true;
            }
            return false;
        }

        public void display_layout_order_invert() {
            this.display_invert_cols_rows = this.display_invert_cols_rows != false ? Boolean.valueOf(false) : Boolean.valueOf(true);
            Display_Builder_4.this.ui_elements.update_display_layout_order();
            this.displays_update();
        }

        public String display_name_get(int display_id) {
            return String.valueOf(this.display_basename) + Display_Builder_4.this.get_number_from_id(display_id);
        }

        public int display_pixel_count_get() {
            return Display_Builder_4.round((float)(this.display_resolution.x * this.display_resolution.y));
        }

        public int[] display_player_output_numbers_get(int display_id) {
            int player_number = this.player_start_number;
            int output_number = this.player_outputs_start_number;
            if (this.player_outputs_count == 1) {
                player_number = this.player_start_number + display_id;
                output_number = this.player_outputs_start_number;
            } else if (this.player_outputs_shared_count == 0) {
                player_number = this.player_start_number + Display_Builder_4.floor((float)(display_id / this.player_outputs_count));
                output_number = Display_Builder_4.this.get_number_from_id(display_id % this.player_outputs_count);
                if (this.player_output_one_reserved.booleanValue()) {
                    // empty if block
                }
            } else {
                int display_offset = this.player_outputs_count - this.player_outputs_shared_count;
                if (display_id < this.player_outputs_shared_count) {
                    player_number = this.player_start_number;
                    output_number = display_id + this.player_outputs_start_number;
                } else {
                    player_number = this.player_start_number + Display_Builder_4.floor((float)((display_id + display_offset) / this.player_outputs_count));
                    output_number = Display_Builder_4.this.get_number_from_id((display_id - this.player_outputs_shared_count) % this.player_outputs_count);
                }
            }
            int[] player_output_numbers = new int[]{player_number, ++output_number};
            return player_output_numbers;
        }

        public int[] display_stage_bounds_get(int display_id) {
            int[] stage_bounds = new int[4];
            if (this.display_id_is_valid(display_id).booleanValue()) {
                DisplayObject display = this.displays.get(display_id);
                stage_bounds = display.bounds_get();
            }
            return stage_bounds;
        }

        public Boolean display_selected_id_check(int display_id) {
            if (display_id == this.display_selected_id) {
                return true;
            }
            return false;
        }

        public int display_selected_id_get() {
            return this.display_selected_id;
        }

        public void display_selected_id_set(int display_id) {
            this.display_selected_id = display_id == this.display_selected_id ? -1 : display_id;
            Display_Builder_4.println((String)("DisplayGroup " + this.id + " selected Display ID: " + this.display_selected_id));
        }

        public int[] display_overlap_bounds_calculate(int display_id) {
            int[] overlap_stage_bounds = new int[4];
            if (display_id < this.displays.size() - 1) {
                int[] stage_bounds_source = this.display_stage_bounds_get(display_id);
                int[] stage_bounds_target = this.display_stage_bounds_get(display_id + 1);
                overlap_stage_bounds[0] = Display_Builder_4.max((int)stage_bounds_source[0], (int)stage_bounds_target[0]);
                overlap_stage_bounds[1] = Display_Builder_4.min((int)stage_bounds_source[1], (int)stage_bounds_target[1]);
                overlap_stage_bounds[2] = Display_Builder_4.min((int)stage_bounds_source[2], (int)stage_bounds_target[2]);
                overlap_stage_bounds[3] = Display_Builder_4.max((int)stage_bounds_source[3], (int)stage_bounds_target[3]);
            }
            return overlap_stage_bounds;
        }

        public int[][] display_stage_origins_calculate() {
            PVector display_footprint = this.display_footprint_get();
            PVector display_spacing = PVector.sub((PVector)display_footprint, (PVector)this.softedge_dimensions);
            PVector display_layout_alignment = Display_Builder_4.this.alignment_id_as_vector(this.anchor_alignment_id);
            PVector display_layout_origin = new PVector(0.0f, 0.0f);
            display_layout_origin.x = this.anchor_point.x + display_footprint.x * 0.5f * display_layout_alignment.x;
            display_layout_origin.y = this.anchor_point.y + display_footprint.y * 0.5f * display_layout_alignment.y;
            if (display_layout_alignment.x < 0.0f) {
                display_layout_origin.x -= display_spacing.x * (float)(this.display_cols - 1);
            }
            if (display_layout_alignment.y < 0.0f) {
                display_layout_origin.y -= display_spacing.y * (float)(this.display_rows - 1);
            }
            if (display_layout_alignment.x == 0.0f) {
                display_layout_origin.x = display_spacing.x * (float)(this.display_cols - 1);
                display_layout_origin.x *= -0.5f;
                display_layout_origin.x += this.anchor_point.x;
            }
            if (display_layout_alignment.y == 0.0f) {
                display_layout_origin.y = display_spacing.y * (float)(this.display_rows - 1);
                display_layout_origin.y *= -0.5f;
                display_layout_origin.y += this.anchor_point.y;
            }
            int[] col_origins = new int[this.display_cols];
            int c = 0;
            while (c < this.display_cols) {
                col_origins[c] = Display_Builder_4.round((float)(display_layout_origin.x + (float)c * display_spacing.x));
                ++c;
            }
            int[] row_origins = new int[this.display_rows];
            int r = 0;
            while (r < this.display_rows) {
                row_origins[r] = Display_Builder_4.round((float)(display_layout_origin.y + (float)r * display_spacing.y));
                ++r;
            }
            int[][] col_row_origins = new int[][]{col_origins, row_origins};
            return col_row_origins;
        }

        public void displays_delete_all() {
            Display_Builder_4.this.debug_output("Deleting all Displays in DisplayGroup " + this.id);
            for (DisplayObject display : this.displays) {
                display.cleanup();
            }
            this.displays.clear();
        }

        public void displays_draw_all() {
            if (this.displays.size() > 0 && Display_Builder_4.this.ui.active.booleanValue() && this.group_active.booleanValue()) {
                for (DisplayObject display : this.displays) {
                    display.draw_rect();
                }
            }
        }

        public int displays_fit_softedge_minimum_calculate(int display_dimension_pixels) {
            int softedge_px_min = 0;
            softedge_px_min = this.resolution.type_id == Display_Builder_4.this.project.LED_PANEL ? 0 : (Display_Builder_4.this.project.physical_settings_active_get() != false ? Display_Builder_4.round((float)Display_Builder_4.this.physical_to_pixels(0.8f)) : Display_Builder_4.max((int)100, (int)Display_Builder_4.round((float)((float)display_dimension_pixels * Display_Builder_4.this.project.default_softedge_fraction))));
            return softedge_px_min;
        }

        public void displays_fit_to_surface() {
            if (Display_Builder_4.this.project.pref_projection_surface_mode == 1) {
                Display_Builder_4.this.debug_output("Attempting to calculate best fit for Displays.");
                PVector surface_dimensions = Display_Builder_4.this.project.surface_dimensions_get("target");
                PVector display_footprint = this.display_footprint_get();
                int softedge_px_min = this.displays_fit_softedge_minimum_calculate(Display_Builder_4.round((float)display_footprint.x));
                if (surface_dimensions.x > display_footprint.x) {
                    int fit_display_width = Display_Builder_4.round((float)(display_footprint.x - (float)(softedge_px_min / 2)));
                    int fit_display_count_h = Display_Builder_4.ceil((float)(surface_dimensions.x / (float)fit_display_width));
                    int softedge_count_h = fit_display_count_h - 1;
                    int total_display_width = Display_Builder_4.round((float)(display_footprint.x * (float)fit_display_count_h));
                    int fit_softedge_h = softedge_count_h > 0 ? Display_Builder_4.round((float)((float)total_display_width - surface_dimensions.x)) / softedge_count_h : 0;
                    Display_Builder_4.this.debug_output("Width: Display (-softedge): " + fit_display_width + ", surface: " + surface_dimensions.x + ", Displays needed: " + fit_display_count_h);
                    Display_Builder_4.this.debug_output("Best fit softedge: " + fit_softedge_h);
                    this.display_cols = fit_display_count_h;
                    this.softedge_dimensions.x = fit_softedge_h;
                    Display_Builder_4.this.project.surface_bounds_get("target");
                } else {
                    this.display_cols = 1;
                    this.softedge_dimensions.x = 0.0f;
                }
                softedge_px_min = this.displays_fit_softedge_minimum_calculate(Display_Builder_4.round((float)display_footprint.y));
                if (surface_dimensions.y > display_footprint.y) {
                    int fit_display_height = Display_Builder_4.round((float)(display_footprint.y - (float)softedge_px_min));
                    int fit_display_count_v = Display_Builder_4.ceil((float)(surface_dimensions.y / (float)fit_display_height));
                    int softedge_count_v = fit_display_count_v - 1;
                    int total_display_height = Display_Builder_4.round((float)(display_footprint.y * (float)fit_display_count_v));
                    int fit_softedge_v = softedge_count_v > 0 ? Display_Builder_4.round((float)((float)total_display_height - surface_dimensions.y)) / softedge_count_v : 0;
                    Display_Builder_4.this.debug_output("Height: Display (-softedge): " + fit_display_height + ", surface: " + surface_dimensions.y + ", Displays needed: " + fit_display_count_v);
                    Display_Builder_4.this.debug_output("Best fit softedge: " + fit_softedge_v);
                    this.display_rows = fit_display_count_v;
                    this.softedge_dimensions.y = fit_softedge_v;
                } else {
                    this.display_rows = 1;
                    this.softedge_dimensions.y = 0.0f;
                }
                if (this.parent_displaygroup != null) {
                    int[] parent_bounds = this.parent_displaygroup.projection_surface_bounds_get();
                    this.parent_offset.x -= (float)parent_bounds[3];
                }
                Display_Builder_4.this.ui_elements.update_all_controls();
                Display_Builder_4.this.project.displaygroup_current_update();
            }
        }

        public void displays_icon_draw(PVector drawing_origin, Float drawing_height) {
            Float icon_scale = Float.valueOf(drawing_height.floatValue() * 0.7f / this.display_resolution.y);
            Display_Builder_4.this.pushStyle();
            Display_Builder_4.this.pushMatrix();
            Display_Builder_4.this.translate(drawing_origin.x, drawing_origin.y);
            Display_Builder_4.this.pushMatrix();
            Display_Builder_4.this.scale(icon_scale.floatValue());
            Display_Builder_4.this.rectMode(3);
            Display_Builder_4.this.fill(40.0f, 40.0f, 40.0f);
            Display_Builder_4.this.stroke(Display_Builder_4.this.ui.colour_get_by_name("display_stroke"));
            Display_Builder_4.this.strokeWeight(1.0f / icon_scale.floatValue() * 1.0f);
            Display_Builder_4.this.rect(0.0f, 0.0f, this.display_resolution.x, this.display_resolution.y);
            Display_Builder_4.this.ellipseMode(3);
            Display_Builder_4.this.noFill();
            Float ellipse_diameter = Float.valueOf(Display_Builder_4.min((float)this.display_resolution.x, (float)this.display_resolution.y));
            Display_Builder_4.this.ellipse(0.0f, 0.0f, ellipse_diameter.floatValue(), ellipse_diameter.floatValue());
            Display_Builder_4.this.line(this.display_resolution.x * -0.5f, this.display_resolution.y * 0.5f, this.display_resolution.x * 0.5f, this.display_resolution.y * -0.5f);
            Display_Builder_4.this.rotate(this.display_rotation * -1.0f);
            float crosshair_size = this.display_resolution.y * 0.1f;
            Display_Builder_4.this.line(0.0f, crosshair_size * -4.0f, 0.0f, 0.0f);
            Display_Builder_4.this.line(crosshair_size * -1.0f, crosshair_size * -2.0f, 0.0f, crosshair_size * -4.0f);
            Display_Builder_4.this.line(crosshair_size * 1.0f, crosshair_size * -2.0f, 0.0f, crosshair_size * -4.0f);
            Display_Builder_4.this.popMatrix();
            if (Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                float diagonal_angle = Display_Builder_4.atan((float)(this.display_resolution.y / this.display_resolution.x));
                Display_Builder_4.this.rotate(diagonal_angle * -1.0f);
                float display_diagonal = Display_Builder_4.sqrt((float)(this.display_dimensions_physical.x * this.display_dimensions_physical.x + this.display_dimensions_physical.y * this.display_dimensions_physical.y));
                Display_Builder_4.this.fill(255);
                Display_Builder_4.this.textFont(Display_Builder_4.this.font_display_id, Display_Builder_4.this.ui_elements.get_scaled_size(14));
                Display_Builder_4.this.textAlign(3, 101);
                Display_Builder_4.this.text(String.valueOf(Display_Builder_4.this.get_formatted_float_string(display_diagonal)) + "m ", 0.0f, 0.0f);
            }
            Display_Builder_4.this.popMatrix();
            Display_Builder_4.this.popStyle();
        }

        public void displays_init_all() {
            Display_Builder_4.this.debug_output("Init-ing all Displays in DisplayGroup " + this.id);
            for (DisplayObject display : this.displays) {
                display.parent_displaygroup_set(this.id);
                display.bounds_calculate_from_footprint();
            }
            this.displays.clear();
        }

        public void displays_overrides_check_all() {
            this.displays_overrides_active = false;
            for (DisplayObject display : this.displays) {
                if (!display.position_override.booleanValue() && !display.rotation_override.booleanValue()) continue;
                this.displays_overrides_active = true;
            }
        }

        public void displays_update_parent_position(PVector offset_delta) {
            for (DisplayObject display : this.displays) {
                display.parent_position_delta_apply(offset_delta);
            }
        }

        public void displays_update_strings() {
            int[] player_output_numbers = new int[2];
            for (DisplayObject display : this.displays) {
                display.parent_displaygroup_set(this.id);
                display.name_set(this.display_name_get(display.display_id));
                player_output_numbers = this.display_player_output_numbers_get(display.display_id);
                display.player_number_set(player_output_numbers[0]);
                display.output_number_set(player_output_numbers[1]);
            }
        }

        public void displays_update() {
            if (this.group_active.booleanValue()) {
                DisplayObject current_display;
                int i;
                Display_Builder_4.this.debug_output("Updating displays in DisplayGroup: " + this.id + " - " + this.name + ", displays_overrides_active: " + this.displays_overrides_active);
                int display_count = this.display_cols * this.display_rows;
                int display_count_existing = this.displays.size();
                if (display_count > display_count_existing) {
                    i = display_count_existing + 1;
                    while (i <= display_count) {
                        current_display = this.display_add(true);
                        ++i;
                    }
                    this.max_ip_start_address_calculate();
                } else if (display_count < display_count_existing) {
                    i = display_count_existing;
                    while (i > display_count) {
                        int listid = i - 1;
                        Display_Builder_4.this.debug_output("Removing display Id:" + listid);
                        current_display = this.displays.get(listid);
                        current_display.cleanup();
                        this.displays.remove(listid);
                        --i;
                    }
                }
                this.group_summary_text_update();
                if (display_count != display_count_existing) {
                    this.player_count_update();
                    Display_Builder_4.this.debug_output("Updated display counts - Total:" + display_count + ", Cols:" + this.display_cols + ", Rows:" + this.display_rows);
                }
                this.displays_update_strings();
                if (this.display_cols > 1 && this.display_rows > 1) {
                    Display_Builder_4.this.ui_elements.lock_invert_layout_button(false);
                } else {
                    Display_Builder_4.this.ui_elements.lock_invert_layout_button(true);
                }
                int[][] col_row_origins = this.display_stage_origins_calculate();
                int[] col_origins = col_row_origins[0];
                int[] row_origins = col_row_origins[1];
                int display_number = 0;
                if (!this.display_invert_cols_rows.booleanValue()) {
                    int r = 0;
                    while (r < this.display_rows) {
                        int c = 0;
                        while (c < this.display_cols) {
                            current_display = this.displays.get(display_number);
                            current_display.rowcol_ids_set(r, c);
                            int display_origin_x = col_origins[c];
                            int display_origin_y = row_origins[r];
                            current_display.position_set(display_origin_x, display_origin_y);
                            current_display.rotation_set(this.display_rotation);
                            current_display.draw_rect();
                            ++display_number;
                            ++c;
                        }
                        ++r;
                    }
                } else {
                    int c = 0;
                    while (c < this.display_cols) {
                        int r = 0;
                        while (r < this.display_rows) {
                            current_display = this.displays.get(display_number);
                            current_display.rowcol_ids_set(r, c);
                            int display_origin_x = col_origins[c];
                            int display_origin_y = row_origins[r];
                            current_display.position_set(display_origin_x, display_origin_y);
                            current_display.rotation_set(this.display_rotation);
                            current_display.draw_rect();
                            ++display_number;
                            ++r;
                        }
                        ++c;
                    }
                }
                this.projection_surface_bounds_calculate();
                this.child_displaygroups_update();
                this.child_guides_update();
                Display_Builder_4.this.ui.stage_scale_auto_fit_to_bounds(this.projection_surface_bounds);
                this.colour_palette_calculate();
                Display_Builder_4.this.redraw_screen();
            }
        }

        public void anchor_alignment_id_set(float ui_value) {
            int new_value = Display_Builder_4.round((float)ui_value);
            if (new_value != this.anchor_alignment_id && new_value >= 0) {
                this.anchor_alignment_id = new_value;
                Display_Builder_4.this.debug_output("DisplayGroup set origin_alignment_id to: " + this.anchor_alignment_id);
                this.displays_update();
            }
        }

        public PVector anchor_get() {
            return this.anchor_point;
        }

        public void group_active_set(Boolean status) {
            this.group_active = status;
            Display_Builder_4.this.debug_output("DisplayGroup " + this.id + " set active " + this.group_active);
        }

        public void group_defaults_set() {
            Display_Builder_4.this.debug_output("Setting defaults for DisplayGroup " + this.id);
            this.player_start_number = Display_Builder_4.this.project.player_id_get_next(this.id);
            if (this.id > 0 && Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                this.display_dimensions_physical.x = this.display_resolution.x / Display_Builder_4.this.project.viewport_physical_scale;
                this.display_dimensions_physical.y = this.display_resolution.y / Display_Builder_4.this.project.viewport_physical_scale;
                this.physical_scale = Display_Builder_4.this.project.viewport_physical_scale;
            } else {
                this.display_dimensions_physical.x = 0.0f;
                this.display_dimensions_physical.y = 0.0f;
                this.physical_scale = 0.0f;
            }
            if (this.display_resolution.x > 0.0f) {
                this.softedge_dimensions.x = Display_Builder_4.round((float)(this.display_resolution.x * Display_Builder_4.this.project.default_softedge_fraction));
            }
            this.stagetier_id_set(0);
            this.display_add(true);
            this.displays_update();
        }

        public void group_cleanup() {
            this.group_active = false;
            if (this.child_displaygroup_ids.size() > 0) {
                int child_displaygroup_id = 0;
                int i = 0;
                while (i < this.child_displaygroup_ids.size()) {
                    child_displaygroup_id = this.child_displaygroup_ids.get(i);
                    DisplayGroup child_displaygroup = Display_Builder_4.this.project.display_groups.get(child_displaygroup_id);
                    child_displaygroup.parent_id_set(-1);
                    ++i;
                }
                this.child_displaygroup_ids.clear();
            }
            if (this.parent_displaygroup != null) {
                this.parent_displaygroup.child_displaygroup_id_remove(this.id);
                Display_Builder_4.this.project.getClass();
                if (this.display_type == 1) {
                    this.parent_displaygroup.player_output_one_reserved = false;
                }
                this.parent_displaygroup = null;
            }
            if (this.child_guide_ids.size() > 0) {
                int i = 0;
                while (i < this.child_guide_ids.size()) {
                    Guide child_guide = Display_Builder_4.this.project.guides.get(i);
                    child_guide.parent_id_set(-1);
                    ++i;
                }
                this.child_guide_ids.clear();
            }
            this.displays_delete_all();
            this.resolution = null;
        }

        public void group_copy(int source_displaygroup_id, String copy_name) {
            if (Display_Builder_4.this.project.displaygroup_id_is_valid(source_displaygroup_id).booleanValue()) {
                Display_Builder_4.this.debug_output("Copying properties from DisplayGroup " + source_displaygroup_id + " to " + this.id);
                DisplayGroup source_displaygroup = Display_Builder_4.this.project.displaygroup_get_by_id(source_displaygroup_id);
                this.name = String.valueOf(source_displaygroup.name) + " (" + copy_name + ")";
                this.stagetier_id_set(source_displaygroup.stagetier_id);
                this.anchor_point = source_displaygroup.anchor_point.copy();
                this.anchor_alignment_id = source_displaygroup.anchor_alignment_id;
                this.parent_group_id = source_displaygroup.parent_group_id;
                this.parent_offset = source_displaygroup.parent_offset.copy();
                this.parent_alignment_id = source_displaygroup.parent_alignment_id;
                this.softedge_dimensions = source_displaygroup.softedge_dimensions.copy();
                int i = 0;
                while (i < 4) {
                    this.projection_surface_bounds[i] = source_displaygroup.projection_surface_bounds[i];
                    ++i;
                }
                this.display_aspect_ratio = source_displaygroup.display_aspect_ratio;
                this.display_aspect_ratio_locked = source_displaygroup.display_aspect_ratio_locked;
                this.display_basename = source_displaygroup.display_basename;
                this.display_cols = source_displaygroup.display_cols;
                this.display_colour_mode = source_displaygroup.display_colour_mode;
                this.display_dimensions_physical = source_displaygroup.display_dimensions_physical.copy();
                this.display_dimensions_stage = source_displaygroup.display_dimensions_stage.copy();
                this.display_invert_cols_rows = source_displaygroup.display_invert_cols_rows;
                this.outline_colour = source_displaygroup.outline_colour;
                this.display_pixel_density = source_displaygroup.display_pixel_density;
                this.display_resolution = source_displaygroup.display_resolution.copy();
                this.display_rotation = source_displaygroup.display_rotation;
                this.display_rows = source_displaygroup.display_rows;
                this.display_show_43_marks = source_displaygroup.display_show_43_marks;
                this.display_type = source_displaygroup.display_type;
                int group_display_count = this.display_cols * this.display_rows;
                int i2 = 0;
                while (i2 < group_display_count) {
                    this.display_add(true);
                    ++i2;
                }
                this.physical_scale = source_displaygroup.physical_scale;
                this.player_name_prefix = source_displaygroup.player_name_prefix;
                this.player_start_number = source_displaygroup.player_start_number;
                this.player_outputs_count = source_displaygroup.player_outputs_count;
                this.player_outputs_sharing = source_displaygroup.player_outputs_sharing;
                this.stage_scale = source_displaygroup.stage_scale;
                this.displays_overrides_check_all();
                this.resolution_object_set_by_id(source_displaygroup.resolution_id_get());
                this.parent_displaygroup_set(source_displaygroup.parent_group_id);
                this.displays_update();
            } else {
                Display_Builder_4.this.debug_output("Could not copy properties from DisplayGroup " + source_displaygroup_id);
            }
        }

        public void group_display_type_set(int type_id) {
            this.display_type = type_id;
            Display_Builder_4.this.ui_elements.menu_display_type_label_update();
        }

        public void group_id_update(int new_id) {
            this.id = new_id;
            this.displays_update_strings();
            this.player_count_update();
        }

        public void group_name_set(String new_name) {
            if (!new_name.equals("")) {
                this.name = new_name;
                UI uI = Display_Builder_4.this.ui;
                String string = "Display Group " + (this.id + 1) + " name changed to: " + this.name;
                Display_Builder_4.this.ui.getClass();
                uI.osd_message_display(string, 1);
                Display_Builder_4.this.ui_elements.displaygroup_menu_update();
            }
        }

        public int group_pixel_count_get() {
            int display_pixel_count = this.display_pixel_count_get();
            return display_pixel_count * this.displays.size();
        }

        public void group_show_43_marks_set(boolean ui_toggle_status) {
            this.display_show_43_marks = ui_toggle_status;
        }

        public void group_summary_text_update() {
            String summary_text = "";
            int group_display_count = this.display_count_get();
            int group_pixel_count = group_display_count * this.display_pixel_count_get();
            summary_text = String.valueOf(summary_text) + this.display_count_get();
            String tooltip_text = "Displays: " + summary_text + ", Total pixel count for this group: " + Display_Builder_4.nfc((int)group_pixel_count) + ".";
            summary_text = String.valueOf(summary_text) + "  (" + Display_Builder_4.this.human_readable_number_string(group_pixel_count) + " px)";
            Display_Builder_4.this.ui_elements.display_summary_update(summary_text, tooltip_text);
        }

        public void group_surface_draw() {
            Display_Builder_4.this.pushMatrix();
            Display_Builder_4.this.translate(Display_Builder_4.this.ui.viewport.x, Display_Builder_4.this.ui.viewport.y);
            Display_Builder_4.this.scale(Display_Builder_4.this.ui.viewport_scale / 100.0f);
            Display_Builder_4.this.pushStyle();
            Display_Builder_4.this.noFill();
            Display_Builder_4.this.stroke(this.outline_colour);
            Display_Builder_4.this.strokeWeight(2.0f);
            Display_Builder_4.this.rectMode(1);
            Display_Builder_4.this.rect(this.projection_surface_bounds[3], this.projection_surface_bounds[0], this.projection_surface_bounds[1], this.projection_surface_bounds[2]);
            if (!this.stage_scale_active().booleanValue()) {
                Display_Builder_4.this.line(this.projection_surface_bounds[3], this.projection_surface_bounds[0], this.projection_surface_bounds[1], this.projection_surface_bounds[2]);
                Display_Builder_4.this.line(this.projection_surface_bounds[3], this.projection_surface_bounds[2], this.projection_surface_bounds[1], this.projection_surface_bounds[0]);
            } else {
                Display_Builder_4.this.draw_dashed_line(this.projection_surface_bounds[3], this.projection_surface_bounds[0], this.projection_surface_bounds[1], this.projection_surface_bounds[2], 50);
                Display_Builder_4.this.draw_dashed_line(this.projection_surface_bounds[3], this.projection_surface_bounds[2], this.projection_surface_bounds[1], this.projection_surface_bounds[0], 50);
            }
            if (Display_Builder_4.this.project.pref_ui_show_parent_links.booleanValue() && this.parent_displaygroup != null && (this.parent_offset.x != 0.0f || this.parent_offset.y != 0.0f)) {
                float dot_count = 40.0f;
                int i = 0;
                while ((float)i <= dot_count) {
                    float x = Display_Builder_4.lerp((float)this.anchor_point.x, (float)(this.anchor_point.x - this.parent_offset.x), (float)((float)i / dot_count));
                    float y = Display_Builder_4.lerp((float)this.anchor_point.y, (float)(this.anchor_point.y - this.parent_offset.y), (float)((float)i / dot_count));
                    Display_Builder_4.this.ellipse(x, y, 3.0f, 3.0f);
                    ++i;
                }
            }
            Display_Builder_4.this.translate(this.anchor_point.x, this.anchor_point.y);
            int box_size = 50;
            Display_Builder_4.this.rectMode(3);
            Display_Builder_4.this.rect(0.0f, 0.0f, box_size, box_size);
            box_size = (int)((float)box_size * -0.5f);
            Display_Builder_4.this.translate((float)box_size * Display_Builder_4.this.alignment_id_as_vector((int)this.anchor_alignment_id).x, (float)box_size * Display_Builder_4.this.alignment_id_as_vector((int)this.anchor_alignment_id).y);
            Display_Builder_4.this.fill(this.outline_colour);
            Display_Builder_4.this.ellipse(0.0f, 0.0f, 10.0f, 10.0f);
            Display_Builder_4.this.popStyle();
            Display_Builder_4.this.popMatrix();
        }

        public StringList group_data_text_get(String comment_prefix) {
            StringList group_data = new StringList();
            String text_line = "";
            group_data.append(String.valueOf(comment_prefix) + "Display Group No." + Display_Builder_4.this.get_number_from_id(this.id) + ": '" + this.name + "'");
            StageTier group_stagetier = Display_Builder_4.this.project.stage_tiers.get(this.stagetier_id);
            group_data.append(String.valueOf(comment_prefix) + "Stage Tier No." + Display_Builder_4.this.get_number_from_id(group_stagetier.id) + ": '" + group_stagetier.name + "'");
            group_data.append(String.valueOf(comment_prefix) + "Contains " + this.displays.size() + " Displays in " + this.display_cols + " Columns " + this.display_rows + " Rows");
            group_data.append(String.valueOf(comment_prefix) + "Display resolution " + this.resolution.name + ": " + Display_Builder_4.floor((float)this.display_resolution.x) + " x " + Display_Builder_4.floor((float)this.display_resolution.y) + "px");
            group_data.append(String.valueOf(comment_prefix) + "Total pixel count for Displays in this Group: " + this.group_pixel_count_get() + " (" + Display_Builder_4.this.human_readable_number_string(this.group_pixel_count_get()) + ") px");
            if (this.display_resolution.x != this.display_dimensions_stage.x || this.display_resolution.y != this.display_dimensions_stage.y) {
                group_data.append(String.valueOf(comment_prefix) + "Display stage size: " + Display_Builder_4.floor((float)this.display_dimensions_stage.x) + " x " + Display_Builder_4.floor((float)this.display_dimensions_stage.y) + "px");
            }
            if (this.display_rotation != 0.0f) {
                group_data.append(String.valueOf(comment_prefix) + "Display rotation: " + Float.toString(Display_Builder_4.degrees((float)this.display_rotation)));
            }
            if (this.display_dimensions_physical.x > 0.0f) {
                text_line = "Display physical size: " + Display_Builder_4.this.physical_dimension_get_as_string(this.display_dimensions_physical.x);
                text_line = String.valueOf(text_line) + " x " + Display_Builder_4.this.physical_dimension_get_as_string(this.display_dimensions_physical.y);
                text_line = String.valueOf(text_line) + " - Pixel Density: " + Display_Builder_4.nf((float)this.display_pixel_density, (int)1, (int)2) + "mm/px";
                group_data.append(String.valueOf(comment_prefix) + text_line);
            }
            String softedge_percentage_text = Display_Builder_4.nf((float)this.softedge_values_get("horizontal", "percentage"), (int)2, (int)2);
            group_data.append(String.valueOf(comment_prefix) + "Softedge/Overlap: " + this.softedge_dimensions.x + "px " + softedge_percentage_text + "% (Horizontal)");
            if (this.display_rows > 1) {
                softedge_percentage_text = Display_Builder_4.nf((float)this.softedge_values_get("vertical", "percentage"), (int)2, (int)2);
                group_data.append(String.valueOf(comment_prefix) + "Softedge/Overlap: " + this.softedge_dimensions.y + "px " + softedge_percentage_text + "% (Vertical)");
            }
            int[] display_centre_offset = this.display_centre_offsets_get();
            group_data.append(String.valueOf(comment_prefix) + "Display offset: " + display_centre_offset[0] + "px " + Display_Builder_4.nf((float)Display_Builder_4.this.pixels_to_physical(display_centre_offset[0]), (int)0, (int)2) + "m (Horizontal)");
            if (this.display_rows > 1) {
                group_data.append(String.valueOf(comment_prefix) + "Display offset: " + display_centre_offset[1] + "px " + Display_Builder_4.nf((float)Display_Builder_4.this.pixels_to_physical(display_centre_offset[1]), (int)0, (int)2) + "m (Vertical)");
            }
            PVector group_surface_dimensions = this.projection_surface_dimensions_get();
            text_line = "Display Group dimensions: " + Display_Builder_4.floor((float)group_surface_dimensions.x) + " x " + Display_Builder_4.floor((float)group_surface_dimensions.y);
            text_line = String.valueOf(text_line) + " (" + Display_Builder_4.nfc((int)Display_Builder_4.round((float)(group_surface_dimensions.x * group_surface_dimensions.y))) + ") px";
            if (this.display_dimensions_physical.x > 0.0f) {
                PVector group_surface_area_physical = this.projection_surface_dimensions_physical_get();
                text_line = String.valueOf(text_line) + " - " + Display_Builder_4.this.physical_dimension_get_as_string(group_surface_area_physical.x);
                text_line = String.valueOf(text_line) + " x " + Display_Builder_4.this.physical_dimension_get_as_string(group_surface_area_physical.y) + "m";
                text_line = String.valueOf(text_line) + " (" + Display_Builder_4.this.physical_dimension_get_as_string(group_surface_area_physical.x * group_surface_area_physical.y) + " m2)";
            }
            group_data.append(String.valueOf(comment_prefix) + text_line);
            String bounds_data = String.valueOf(comment_prefix) + "Display Group bounds (pixels)";
            bounds_data = String.valueOf(bounds_data) + " Top: " + this.projection_surface_bounds[0];
            bounds_data = String.valueOf(bounds_data) + " Right: " + this.projection_surface_bounds[1];
            bounds_data = String.valueOf(bounds_data) + " Bottom: " + this.projection_surface_bounds[2];
            bounds_data = String.valueOf(bounds_data) + " Left: " + this.projection_surface_bounds[3];
            group_data.append(bounds_data);
            PVector group_centre_coords = this.group_centre_coords_get();
            text_line = String.valueOf(comment_prefix) + "Display Group centre: " + Display_Builder_4.nf((float)group_centre_coords.x, (int)1, (int)1) + " x " + Display_Builder_4.nf((float)group_centre_coords.y, (int)1, (int)1) + "px";
            if (this.display_dimensions_physical.x > 0.0f) {
                text_line = String.valueOf(text_line) + " - " + Display_Builder_4.this.pixels_to_physical(group_centre_coords.x) + " x " + Display_Builder_4.this.pixels_to_physical(group_centre_coords.y) + "m";
            }
            group_data.append(text_line);
            group_data.append(comment_prefix);
            return group_data;
        }

        public PVector group_centre_coords_get() {
            PVector group_centre_coords = new PVector(0.0f, 0.0f);
            PVector group_surface_dimensions = this.projection_surface_dimensions_get();
            group_centre_coords.x = (float)this.projection_surface_bounds[3] + group_surface_dimensions.x / 2.0f;
            group_centre_coords.y = (float)this.projection_surface_bounds[0] + group_surface_dimensions.y / 2.0f;
            return group_centre_coords;
        }

        public void max_ip_start_address_calculate() {
            int max_ip = Display_Builder_4.max((int)1, (int)(256 - Display_Builder_4.ceil((float)(PApplet.parseFloat((int)this.display_count_get()) / (float)this.player_outputs_count))));
            int new_ip = Display_Builder_4.min((int)this.player_start_number, (int)max_ip);
            if (new_ip != this.player_start_number) {
                this.player_start_number = new_ip;
                this.displays_update_strings();
                Display_Builder_4.this.ui_elements.update_display_settings();
            }
        }

        public Boolean mouse_within_displaygroup(int mouse_pos_x, int mouse_pos_y, String action) {
            Boolean mouse_within_displaygroup = false;
            int stage_x = Display_Builder_4.round((float)Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)((float)mouse_pos_x - Display_Builder_4.this.ui.viewport.x))));
            int stage_y = Display_Builder_4.round((float)Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)((float)mouse_pos_y - Display_Builder_4.this.ui.viewport.y))));
            if (stage_x >= this.projection_surface_bounds[3] && stage_x <= this.projection_surface_bounds[1] && stage_y >= this.projection_surface_bounds[0] && stage_y <= this.projection_surface_bounds[2]) {
                mouse_within_displaygroup = true;
            }
            for (DisplayObject display : this.displays) {
                if (mouse_within_displaygroup.booleanValue()) {
                    if (display.mouse_within_display_check(mouse_pos_x, mouse_pos_y).booleanValue()) {
                        display.info_overlay_show = true;
                        if (!action.equals("click") || this.id != Display_Builder_4.this.project.current_displaygroup.id || this.display_count_get() <= 1) continue;
                        this.display_selected_id_set(display.display_id);
                        continue;
                    }
                    display.info_overlay_show = false;
                    continue;
                }
                display.info_overlay_show = false;
            }
            return mouse_within_displaygroup;
        }

        public PVector alignment_point_calculate(int align_point_id) {
            if (align_point_id < 0 || align_point_id > 8) {
                align_point_id = this.anchor_alignment_id;
            }
            PVector alignment_point = this.anchor_point.copy();
            PVector group_surface_half_dimensions = PVector.mult((PVector)this.projection_surface_dimensions_get(), (float)0.5f);
            switch (align_point_id) {
                case 0: {
                    alignment_point.x = this.projection_surface_bounds[3];
                    alignment_point.y = this.projection_surface_bounds[0];
                    break;
                }
                case 1: {
                    alignment_point.x = (float)this.projection_surface_bounds[3] + group_surface_half_dimensions.x;
                    alignment_point.y = this.projection_surface_bounds[0];
                    break;
                }
                case 2: {
                    alignment_point.x = this.projection_surface_bounds[1] + 1;
                    alignment_point.y = this.projection_surface_bounds[0];
                    break;
                }
                case 3: {
                    alignment_point.x = this.projection_surface_bounds[3];
                    alignment_point.y = (float)this.projection_surface_bounds[0] + group_surface_half_dimensions.y;
                    break;
                }
                case 4: {
                    alignment_point.x = (float)this.projection_surface_bounds[3] + group_surface_half_dimensions.x;
                    alignment_point.y = (float)this.projection_surface_bounds[0] + group_surface_half_dimensions.y;
                    break;
                }
                case 5: {
                    alignment_point.x = this.projection_surface_bounds[1] + 1;
                    alignment_point.y = (float)this.projection_surface_bounds[0] + group_surface_half_dimensions.y;
                    break;
                }
                case 6: {
                    alignment_point.x = this.projection_surface_bounds[3];
                    alignment_point.y = this.projection_surface_bounds[2] + 1;
                    break;
                }
                case 7: {
                    alignment_point.x = (float)this.projection_surface_bounds[3] + group_surface_half_dimensions.x;
                    alignment_point.y = this.projection_surface_bounds[2] + 1;
                    break;
                }
                case 8: {
                    alignment_point.x = this.projection_surface_bounds[1] + 1;
                    alignment_point.y = this.projection_surface_bounds[2] + 1;
                }
            }
            return alignment_point;
        }

        public void parent_offset_reset() {
            PVector offset_current = this.parent_offset.copy();
            this.parent_offset.x = 0.0f;
            this.parent_offset.y = 0.0f;
            PVector offset_delta = PVector.sub((PVector)this.parent_offset, (PVector)offset_current);
            this.anchor_point_add_offset(offset_delta);
            Display_Builder_4.this.ui_elements.parent_offset_controls_update();
            this.displays_update();
        }

        public void parent_offset_set(String input_dimension, int pixel_value) {
            PVector offset_current = this.parent_offset.copy();
            if (input_dimension.equals("x")) {
                this.parent_offset.x = pixel_value;
            }
            if (input_dimension.equals("y")) {
                this.parent_offset.y = pixel_value;
            }
            PVector offset_delta = PVector.sub((PVector)this.parent_offset, (PVector)offset_current);
            this.anchor_point_add_offset(offset_delta);
            Display_Builder_4.this.ui_elements.parent_offset_controls_update();
            this.displays_update();
        }

        public void parent_offset_ui_input_parse(String input_dimension, String ui_text) {
            MixedInputResult mixed_input_parse_result;
            int pixel_value = 0;
            pixel_value = Display_Builder_4.this.project.physical_settings_active_get().booleanValue() ? ((mixed_input_parse_result = Display_Builder_4.this.parse_mixed_input(ui_text)) != null ? Display_Builder_4.this.convert_unit_size_to_pixels(mixed_input_parse_result.value, mixed_input_parse_result.text) : Display_Builder_4.round((float)Display_Builder_4.this.parse_math_string_expression(ui_text))) : Display_Builder_4.round((float)Display_Builder_4.this.parse_math_string_expression(ui_text));
            this.parent_offset_set(input_dimension, pixel_value);
        }

        public void parent_alignment_id_set(float ui_value) {
            int new_value = Display_Builder_4.round((float)ui_value);
            if (new_value != this.parent_alignment_id && new_value >= 0) {
                this.parent_alignment_id = new_value;
                Display_Builder_4.this.debug_output("DisplayGroup set parent_alignment_id to: " + this.parent_alignment_id);
                this.anchor_point_calculate();
                this.displays_update();
            }
        }

        public void parent_id_set(int new_value) {
            Display_Builder_4.this.debug_output("DisplayGroup set_parent_id to: " + new_value);
            if (new_value != this.parent_group_id && new_value != this.id) {
                this.parent_displaygroup_set(new_value);
                if (Display_Builder_4.this.keyPressed && Display_Builder_4.this.keyCode == 16) {
                    this.parent_offset.x = 0.0f;
                    this.parent_offset.y = 0.0f;
                    Display_Builder_4.this.ui_elements.parent_offset_controls_update();
                }
            }
        }

        public void parent_displaygroup_set(int new_parent_id) {
            int previous_parent_id = this.parent_group_id;
            this.parent_group_id = new_parent_id;
            Display_Builder_4.this.debug_output("DisplayGroup " + this.id + " set_parent_displaygroup from " + previous_parent_id + " to: " + this.parent_group_id);
            if (this.parent_group_id < 0) {
                if (this.parent_displaygroup != null) {
                    this.parent_displaygroup.child_displaygroup_id_remove(this.id);
                    this.parent_displaygroup = null;
                }
            } else if (this.parent_group_id < Display_Builder_4.this.project.display_groups.size()) {
                this.parent_displaygroup = Display_Builder_4.this.project.display_groups.get(this.parent_group_id);
                this.parent_displaygroup.child_displaygroup_id_add(this.id);
            }
            if (Display_Builder_4.this.ui.active.booleanValue()) {
                this.stage_position_maintain_current();
            }
            this.displays_update();
        }

        public void display_physical_dimensions_calculate() {
            if (this.resolution != null && this.physical_scale != 0.0f) {
                if (this.resolution.type_id != Display_Builder_4.this.project.LED_PANEL) {
                    this.display_dimensions_physical.x = this.display_resolution.x * this.stage_scale / this.physical_scale;
                    this.display_dimensions_physical.y = this.display_resolution.y * this.stage_scale / this.physical_scale;
                }
                this.pixel_density_calculate();
            }
        }

        public void display_physical_dimensions_calculate_from_surface(String input_name, String ui_input) {
            Display_Builder_4.this.debug_output("DisplayGroup " + this.id + " Calculating Display dimensions to fit dimension: " + ui_input);
            float input_size_physical = Display_Builder_4.this.parse_math_string_expression(ui_input);
            if (input_size_physical > 0.0f) {
                PVector target_dimensions = Display_Builder_4.this.project.surface_dimensions_get("target");
                if (target_dimensions.x <= 1.0f || target_dimensions.y <= 1.0f) {
                    target_dimensions = Display_Builder_4.this.project.surface_dimensions_get("");
                }
                int display_count = 1;
                int total_size_pixel = 0;
                float total_size_physical = 0.0f;
                float surface_physical_scale = 0.0f;
                float display_physical_size = 0.0f;
                String physical_dimension_name = "";
                if (input_name.equals("textfield_group_surface_h_physical")) {
                    surface_physical_scale = target_dimensions.x / input_size_physical;
                    display_count = this.display_cols;
                    total_size_pixel = Display_Builder_4.round((float)target_dimensions.x) + Display_Builder_4.round((float)(this.softedge_dimensions.x * (float)(display_count - 1)));
                    physical_dimension_name = this.display_rotation == 0.0f || this.display_rotation == (float)Math.PI ? "textfield_display_width_physical" : "textfield_display_height_physical";
                } else {
                    surface_physical_scale = target_dimensions.y / input_size_physical;
                    display_count = this.display_rows;
                    total_size_pixel = Display_Builder_4.round((float)target_dimensions.y) + Display_Builder_4.round((float)(this.softedge_dimensions.y * (float)(display_count - 1)));
                    physical_dimension_name = this.display_rotation == 0.0f || this.display_rotation == (float)Math.PI ? "textfield_display_height_physical" : "textfield_display_width_physical";
                }
                total_size_physical = (float)total_size_pixel / surface_physical_scale;
                display_physical_size = total_size_physical / (float)display_count;
                this.group_physical_dimensions_update(physical_dimension_name, Display_Builder_4.nf((float)display_physical_size, (int)1, (int)3));
            }
        }

        public float display_physical_dimensions_constrain_to_maximum(float dimension_value, String dimension_name) {
            if (this.id > 0 && Display_Builder_4.this.project.viewport_physical_scale > 0.0f) {
                if (dimension_name.equals("width")) {
                    dimension_value = Display_Builder_4.min((float)dimension_value, (float)Display_Builder_4.floor((float)(this.display_resolution.x * Display_Builder_4.this.project.max_stage_size_scale / Display_Builder_4.this.project.viewport_physical_scale)));
                }
                if (dimension_name.equals("height")) {
                    dimension_value = Display_Builder_4.min((float)dimension_value, (float)Display_Builder_4.floor((float)(this.display_resolution.y * Display_Builder_4.this.project.max_stage_size_scale / Display_Builder_4.this.project.viewport_physical_scale)));
                }
            }
            return dimension_value;
        }

        public void group_physical_dimensions_update(String input_name, String input_value) {
            Display_Builder_4.this.debug_output("update_display_physical_dimensions from: " + input_name + " = " + input_value);
            float user_input = Display_Builder_4.max((float)0.0f, (float)Display_Builder_4.this.parse_math_string_expression(input_value));
            if (!input_name.equals("rotation")) {
                if (user_input > 0.0f) {
                    if (input_name.equals("textfield_display_width_physical")) {
                        this.display_dimensions_physical.x = user_input = this.display_physical_dimensions_constrain_to_maximum(user_input, "width");
                        this.display_dimensions_physical.y = user_input / this.display_aspect_ratio.floatValue();
                    }
                    if (input_name.equals("textfield_display_height_physical")) {
                        this.display_dimensions_physical.y = user_input = this.display_physical_dimensions_constrain_to_maximum(user_input, "height");
                        this.display_dimensions_physical.x = user_input * this.display_aspect_ratio.floatValue();
                    }
                    if (input_name.equals("") && this.display_dimensions_physical.y > 0.0f) {
                        this.display_dimensions_physical.x = this.display_dimensions_physical.y * this.display_aspect_ratio.floatValue();
                    }
                } else {
                    this.display_dimensions_physical.x = 0.0f;
                    this.display_dimensions_physical.y = 0.0f;
                    Display_Builder_4.this.project.viewport_physical_scale_set(0.0f, this.id);
                }
                Display_Builder_4.this.debug_output("User set physical display size to: " + Display_Builder_4.nf((float)this.display_dimensions_physical.x, (int)1, (int)4) + ", " + Display_Builder_4.nf((float)this.display_dimensions_physical.y, (int)1, (int)4));
            }
            if (this.display_dimensions_physical.y > 0.0f) {
                Display_Builder_4.this.ui_elements.physical_controls_lock(false);
            }
            this.group_physical_scale_calculate("physical");
            Display_Builder_4.this.ui_elements.update_surface_physical_dimensions();
            Display_Builder_4.this.ui_elements.update_softedge_controls();
            Display_Builder_4.this.ui_elements.update_display_dimensions();
            Display_Builder_4.this.ui_elements.update_surface_dimensions();
        }

        public void group_physical_scale_calculate(String update_source_name) {
            Display_Builder_4.this.debug_output("DisplayGroup " + this.id + " calculate_display_physical_scale from: " + update_source_name);
            if (this.display_dimensions_physical.y > 0.0f) {
                if (Display_Builder_4.this.project.displaygroup_is_unique().booleanValue()) {
                    this.physical_scale = this.display_resolution.y / this.display_dimensions_physical.y * this.stage_scale;
                } else if (this.resolution.type_id == Display_Builder_4.this.project.LED_PANEL) {
                    this.physical_scale = this.display_resolution.y / this.display_dimensions_physical.y;
                    Display_Builder_4.this.project.viewport_physical_scale_set_if_not_active(this.physical_scale, this.id);
                    this.stage_scale_set(Display_Builder_4.min((float)(Display_Builder_4.this.project.viewport_physical_scale / this.physical_scale), (float)Display_Builder_4.this.project.max_stage_size_scale), false);
                } else {
                    if (update_source_name.equals("physical")) {
                        this.physical_scale = this.display_resolution.y / this.display_dimensions_physical.y;
                        Display_Builder_4.this.project.viewport_physical_scale_set_if_not_active(this.physical_scale, this.id);
                        this.stage_scale_set(Display_Builder_4.min((float)(Display_Builder_4.this.project.viewport_physical_scale / this.physical_scale), (float)Display_Builder_4.this.project.max_stage_size_scale), false);
                    }
                    if (update_source_name.equals("resolution")) {
                        this.physical_scale = Display_Builder_4.this.project.viewport_physical_scale;
                        this.stage_scale_set(1.0f, false);
                    }
                    if (update_source_name.equals("stage")) {
                        this.physical_scale = Display_Builder_4.this.project.viewport_physical_scale;
                    }
                }
                this.display_physical_dimensions_calculate();
                this.projection_surface_bounds_calculate();
                this.displays_update();
            } else if (update_source_name.equals("stage") && Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                this.physical_scale = Display_Builder_4.this.project.viewport_physical_scale / this.stage_scale;
                this.display_physical_dimensions_calculate();
            } else {
                this.physical_scale = 0.0f;
            }
            if (Display_Builder_4.this.project.displaygroup_is_unique().booleanValue()) {
                Display_Builder_4.this.project.viewport_physical_scale_set(this.physical_scale, this.id);
            }
            Display_Builder_4.this.ui_elements.update_display_dimensions();
        }

        public void pixel_density_calculate() {
            if (this.display_dimensions_physical.x > 0.0f) {
                this.display_pixel_density = this.display_dimensions_physical.x * 1000.0f / this.display_resolution.x;
            }
        }

        public int player_count_get() {
            return this.player_count;
        }

        public void player_count_update() {
            this.player_count = this.display_type == Display_Builder_4.this.project.LED_PANEL || this.display_type == Display_Builder_4.this.project.DISPLAY_VIRTUAL ? 0 : Display_Builder_4.ceil((float)((float)this.display_count_get() / PApplet.parseFloat((int)this.player_outputs_count)));
            Display_Builder_4.this.project.player_count_set_group(this.id, this.player_count);
            if (this.player_outputs_sharing.booleanValue()) {
                Display_Builder_4.this.project.displaygroup_outputs_allocate(this.id);
            } else {
                this.player_start_number = Display_Builder_4.this.project.player_id_get_next(this.id);
            }
            if (this.group_active.booleanValue()) {
                this.colour_palette_calculate();
            }
        }

        public void player_start_number_set(int int_value) {
            Display_Builder_4.this.debug_output("player_start_number_set to: " + int_value);
            this.player_start_number = int_value > 0 ? int_value : Display_Builder_4.this.project.player_id_get_next(this.id);
            this.player_count_update();
            this.max_ip_start_address_calculate();
            this.displays_update_strings();
            Display_Builder_4.this.ui_elements.update_display_settings();
            Display_Builder_4.this.debug_output("Display start IP set to: " + this.player_start_number + " for DisplayGroup: " + this.id);
        }

        public void player_outputs_count_set(int ui_input) {
            int ui_input_constrained = Display_Builder_4.constrain((int)ui_input, (int)1, (int)6);
            if (ui_input_constrained != this.player_outputs_count) {
                this.player_outputs_count = ui_input_constrained;
                Display_Builder_4.this.debug_output("Group " + this.id + " Multi-output setting updated to: " + this.player_outputs_count);
                this.player_count_update();
                this.max_ip_start_address_calculate();
                this.displays_update_strings();
                this.colour_palette_calculate();
            }
            Display_Builder_4.this.ui_elements.update_display_settings();
        }

        public int player_outputs_get_free_count() {
            int available_output_count = 0;
            if (this.player_outputs_sharing.booleanValue()) {
                available_output_count = Display_Builder_4.abs((int)(this.player_outputs_count * this.player_count)) - this.display_count_get();
            }
            return available_output_count;
        }

        public void player_outputs_sharing_toggle(Boolean new_toggle_status) {
            this.player_outputs_sharing = new_toggle_status;
            this.player_count_update();
            Display_Builder_4.this.project.displaygroup_outputs_allocate(this.id);
            this.displays_update_strings();
            Display_Builder_4.this.debug_output("DisplayGroup " + this.id + " Player output sharing: " + this.player_outputs_sharing);
            Display_Builder_4.this.ui_elements.update_display_settings();
        }

        public void player_outputs_start_number_set(int new_start_number) {
            if (new_start_number > 0 && new_start_number <= this.player_outputs_count) {
                this.player_outputs_start_number = new_start_number;
                this.displays_update_strings();
            }
        }

        public PVector position_get() {
            return this.anchor_point;
        }

        public void preview_display_scale_to_parent() {
            if (this.parent_displaygroup != null) {
                PVector surface_dimensions = this.parent_displaygroup.projection_surface_dimensions_get();
                PVector scale_dimensions = new PVector(1.0f, 1.0f);
                if (this.rotation_is_landscape().booleanValue()) {
                    scale_dimensions.x = surface_dimensions.x / this.display_resolution.x;
                    scale_dimensions.y = surface_dimensions.y / this.display_resolution.y;
                } else {
                    scale_dimensions.x = surface_dimensions.x / this.display_resolution.y;
                    scale_dimensions.y = surface_dimensions.y / this.display_resolution.x;
                }
                float stage_scale_temp = Display_Builder_4.max((float)scale_dimensions.x, (float)scale_dimensions.y);
                stage_scale_temp = Display_Builder_4.min((float)stage_scale_temp, (float)Display_Builder_4.this.project.max_stage_size_scale);
                this.stage_scale_set(stage_scale_temp, false);
                this.group_physical_scale_calculate("stage");
                this.projection_surface_bounds_calculate();
                this.displays_update();
                Display_Builder_4.this.debug_output("Preview DisplayGroup ID " + this.id + " stage_scale: " + this.stage_scale);
                Display_Builder_4.this.ui_elements.update_display_dimensions();
            }
        }

        public PVector projection_surface_dimensions_get() {
            PVector surface_dimensions = new PVector(0.0f, 0.0f);
            surface_dimensions.x = Display_Builder_4.abs((int)(this.projection_surface_bounds[1] - this.projection_surface_bounds[3])) + 1;
            surface_dimensions.y = Display_Builder_4.abs((int)(this.projection_surface_bounds[2] - this.projection_surface_bounds[0])) + 1;
            Display_Builder_4.this.debug_output("DisplayGroup " + this.id + " surface_dimensions pixels: " + Display_Builder_4.round((float)surface_dimensions.x) + "," + Display_Builder_4.round((float)surface_dimensions.y));
            return surface_dimensions;
        }

        public PVector projection_surface_dimensions_physical_get() {
            PVector surface_dimensions_physical = new PVector(0.0f, 0.0f);
            if (Display_Builder_4.this.project.physical_settings_active.booleanValue()) {
                PVector surface_dimensions_pixels = this.projection_surface_dimensions_get();
                surface_dimensions_physical.x = surface_dimensions_pixels.x * (1.0f / this.stage_scale) / this.physical_scale;
                surface_dimensions_physical.y = surface_dimensions_pixels.y * (1.0f / this.stage_scale) / this.physical_scale;
                Display_Builder_4.this.debug_output("DisplayGroup " + this.id + " surface_dimensions physical: " + surface_dimensions_physical.x + "," + surface_dimensions_physical.y + " stage_scale: " + this.stage_scale + " physical_scale: " + this.physical_scale);
            }
            return surface_dimensions_physical;
        }

        public void projection_surface_bounds_calculate() {
            this.displays_overrides_check_all();
            if (!this.displays_overrides_active.booleanValue()) {
                if (this.display_rows > 0 && this.display_cols > 0) {
                    PVector display_footprint = this.display_footprint_get();
                    int[][] col_row_origins = this.display_stage_origins_calculate();
                    int[] col_origins = col_row_origins[0];
                    int[] row_origins = col_row_origins[1];
                    this.projection_surface_bounds[0] = row_origins[0] - Display_Builder_4.round((float)(display_footprint.y / 2.0f));
                    this.projection_surface_bounds[2] = row_origins[this.display_rows - 1] + Display_Builder_4.round((float)(display_footprint.y / 2.0f)) - 1;
                    this.projection_surface_bounds[3] = col_origins[0] - Display_Builder_4.round((float)(display_footprint.x / 2.0f));
                    this.projection_surface_bounds[1] = col_origins[this.display_cols - 1] + Display_Builder_4.round((float)(display_footprint.x / 2.0f)) - 1;
                } else {
                    this.projection_surface_bounds_reset();
                }
            } else {
                this.projection_surface_bounds_reset();
                for (DisplayObject display : this.displays) {
                    this.projection_surface_bounds[0] = Display_Builder_4.min((int)this.projection_surface_bounds[0], (int)display.stage_bounds[0]);
                    this.projection_surface_bounds[1] = Display_Builder_4.max((int)this.projection_surface_bounds[1], (int)display.stage_bounds[1]);
                    this.projection_surface_bounds[2] = Display_Builder_4.max((int)this.projection_surface_bounds[2], (int)display.stage_bounds[2]);
                    this.projection_surface_bounds[3] = Display_Builder_4.min((int)this.projection_surface_bounds[3], (int)display.stage_bounds[3]);
                }
            }
            Display_Builder_4.this.ui_elements.update_surface_dimensions();
            Display_Builder_4.this.project.projection_surface_bounds_update();
        }

        public int[] projection_surface_bounds_get() {
            String debug = "Getting display bounds for group " + this.id + " - " + this.name;
            debug = String.valueOf(debug) + ": " + (this.projection_surface_bounds[1] - this.projection_surface_bounds[3]);
            debug = String.valueOf(debug) + "," + (this.projection_surface_bounds[2] - this.projection_surface_bounds[0]);
            debug = String.valueOf(debug) + " - Top:" + this.projection_surface_bounds[0];
            debug = String.valueOf(debug) + ", Right:" + this.projection_surface_bounds[1];
            debug = String.valueOf(debug) + ", Bottom:" + this.projection_surface_bounds[2];
            debug = String.valueOf(debug) + ", Left:" + this.projection_surface_bounds[3];
            return this.projection_surface_bounds;
        }

        public void projection_surface_bounds_reset() {
            int b = 0;
            while (b < 4) {
                this.projection_surface_bounds[b] = 0;
                ++b;
            }
        }

        public PVector projection_surface_centre_screen_get() {
            int[] surface_bounds = this.projection_surface_bounds_get();
            float surface_centre_x = Display_Builder_4.this.stage_to_screen((surface_bounds[1] - surface_bounds[3]) / 2 + surface_bounds[3]);
            float surface_centre_y = Display_Builder_4.this.stage_to_screen((surface_bounds[2] - surface_bounds[0]) / 2 + surface_bounds[0]);
            PVector coords = new PVector((float)Display_Builder_4.round((float)surface_centre_x), (float)Display_Builder_4.round((float)surface_centre_y));
            return coords;
        }

        public MixedInputResult projection_surface_obj_data_get() {
            StringList surface_data = new StringList();
            if (Display_Builder_4.this.project.physical_settings_active.booleanValue()) {
                surface_data.append("# Surface Object: " + Display_Builder_4.this.project.pref_project_name);
                surface_data.append("# " + Display_Builder_4.this.app_signature_get());
                surface_data.append("o " + Display_Builder_4.this.sanitize_network_string(this.name));
                PVector corner_bl = new PVector(0.0f, 0.0f, 0.0f);
                PVector corner_tr = new PVector(0.0f, 0.0f, 0.0f);
                corner_tr.y = Display_Builder_4.this.pixels_to_physical(this.projection_surface_bounds[0] * -1);
                corner_tr.x = Display_Builder_4.this.pixels_to_physical(this.projection_surface_bounds[1] + 1);
                corner_bl.y = Display_Builder_4.this.pixels_to_physical((this.projection_surface_bounds[2] + 1) * -1);
                corner_bl.x = Display_Builder_4.this.pixels_to_physical(this.projection_surface_bounds[3]);
                surface_data.append("v " + corner_bl.x + " " + corner_bl.y + " " + corner_bl.z);
                surface_data.append("v " + corner_tr.x + " " + corner_bl.y + " " + corner_bl.z);
                surface_data.append("v " + corner_bl.x + " " + corner_tr.y + " " + corner_tr.z);
                surface_data.append("v " + corner_tr.x + " " + corner_tr.y + " " + corner_tr.z);
                surface_data.append("vt 1.000000 0.000000");
                surface_data.append("vt 0.000000 1.000000");
                surface_data.append("vt 0.000000 0.000000");
                surface_data.append("vt 1.000000 1.000000");
                surface_data.append("vn 0.0000 -0.0000 1.0000");
                surface_data.append("s off ");
                surface_data.append("f 2/1/1 3/2/1 1/3/1");
                surface_data.append("f 2/1/1 4/4/1 3/2/1");
                String obj_file_name = String.valueOf(Display_Builder_4.this.project.pref_project_name) + " " + Display_Builder_4.this.sanitize_file_name(this.name) + " " + Display_Builder_4.this.get_current_date_string() + ".obj";
                obj_file_name = obj_file_name.replaceAll("\\s", "-");
                String obj_file_path = String.valueOf(Display_Builder_4.this.export_manager.export_folder_filepath) + obj_file_name;
                Display_Builder_4.this.saveStrings(obj_file_path, surface_data.array());
                File obj_file_check = new File(obj_file_path);
                if (obj_file_check.exists()) {
                    UI uI = Display_Builder_4.this.ui;
                    String string = "Data successfully exported to: " + obj_file_name;
                    Display_Builder_4.this.ui.getClass();
                    uI.osd_message_display(string, 1);
                    MixedInputResult file_status = new MixedInputResult(true, 1.0f, obj_file_path);
                    return file_status;
                }
                return null;
            }
            return null;
        }

        public int resolution_id_get() {
            if (this.resolution != null) {
                return this.resolution.id;
            }
            return -1;
        }

        public void resolution_set_value(String input_name, String input_value) {
            Display_Builder_4.this.debug_output("display_resolution_set_value from: " + input_name + " = " + input_value);
            float user_input = PApplet.parseFloat((String)input_value);
            if (input_value.equals("") || Float.isNaN(user_input) || user_input < 0.0f) {
                user_input = 0.0f;
            } else {
                if (input_name.equals("textfield_display_width_resolution")) {
                    this.display_resolution.x = user_input;
                    if (this.display_aspect_ratio_locked.booleanValue()) {
                        this.display_resolution.y = Display_Builder_4.round((float)(this.display_resolution.x / this.display_aspect_ratio.floatValue()));
                    } else {
                        this.display_aspect_ratio = Float.valueOf(Display_Builder_4.this.aspect_ratio_calculate(Display_Builder_4.round((float)this.display_resolution.x), Display_Builder_4.round((float)this.display_resolution.y)));
                    }
                }
                if (input_name.equals("textfield_display_height_resolution")) {
                    this.display_resolution.y = user_input;
                    if (this.display_aspect_ratio_locked.booleanValue()) {
                        this.display_resolution.x = Display_Builder_4.round((float)(this.display_resolution.y * this.display_aspect_ratio.floatValue()));
                    } else {
                        this.display_aspect_ratio = Float.valueOf(Display_Builder_4.this.aspect_ratio_calculate(Display_Builder_4.round((float)this.display_resolution.x), Display_Builder_4.round((float)this.display_resolution.y)));
                    }
                }
                this.softedge_value_sanity_check();
            }
            Display_Builder_4.this.debug_output("Display resolution set to: " + this.display_resolution.x + ", " + this.display_resolution.y + ", " + Display_Builder_4.this.aspect_ratio_as_string(this.display_aspect_ratio.floatValue()));
            this.resolution_object_set_by_id(Display_Builder_4.this.project.resolution_lookup_by_values(this.display_resolution));
            this.group_physical_scale_calculate("resolution");
            this.stage_dimensions_display_calculate();
            this.displays_update();
            Display_Builder_4.this.ui_elements.resolutions_menu_label_update();
            Display_Builder_4.this.ui_elements.update_surface_physical_dimensions();
            Display_Builder_4.this.ui_elements.update_softedge_controls();
            Display_Builder_4.this.ui_elements.update_display_dimensions();
            Display_Builder_4.this.ui_elements.update_surface_dimensions();
        }

        public void resolution_object_set_by_id(int resolution_id) {
            if (Display_Builder_4.this.project.resolution_id_is_valid(resolution_id).booleanValue()) {
                this.resolution = Display_Builder_4.this.project.resolutions_list.get(resolution_id);
                this.group_display_type_set(this.resolution.type_id);
            } else {
                this.resolution = null;
            }
        }

        public void resolution_set_by_id(int rid) {
            Display_Builder_4.this.debug_output("DisplayGroup " + this.id + " resolution_set_by_id: " + rid + " currently: " + this.resolution_id_get());
            if (rid != this.resolution_id_get()) {
                if (Display_Builder_4.this.project.resolution_id_is_valid(rid).booleanValue()) {
                    if (Display_Builder_4.this.project.resolution_id_is_valid(rid).booleanValue()) {
                        this.resolution = Display_Builder_4.this.project.resolutions_list.get(rid);
                        this.display_resolution.x = this.resolution.pixel_count.x;
                        this.display_resolution.y = this.resolution.pixel_count.y;
                        this.display_aspect_ratio = Float.valueOf(Display_Builder_4.this.aspect_ratio_calculate(Display_Builder_4.round((float)this.display_resolution.x), Display_Builder_4.round((float)this.display_resolution.y)));
                        this.group_display_type_set(this.resolution.type_id);
                        this.softedge_value_sanity_check();
                        if (this.resolution.type_id == Display_Builder_4.this.project.LED_PANEL && this.resolution.physical_dimensions.x > 0.0f && this.resolution.physical_dimensions.y > 0.0f) {
                            this.display_dimensions_physical = this.resolution.physical_dimensions.copy();
                        }
                        if (this.display_dimensions_physical.y > 0.0f) {
                            this.group_physical_scale_calculate("resolution");
                        } else {
                            this.stage_scale = 1.0f;
                            this.stage_dimensions_display_calculate();
                            this.displays_update();
                            Display_Builder_4.this.ui_elements.update_softedge_controls();
                            Display_Builder_4.this.ui_elements.update_display_dimensions();
                        }
                        Display_Builder_4.this.debug_output("DisplayGroup " + this.id + ": New display resolution set: " + this.resolution_id_get() + ", " + Display_Builder_4.round((float)this.display_resolution.x) + "x" + Display_Builder_4.round((float)this.display_resolution.y));
                        Display_Builder_4.this.project.summary_text_update();
                    } else {
                        Display_Builder_4.this.debug_output("Error: Could not retrieve Resolution data - no changes made!");
                    }
                } else {
                    Display_Builder_4.this.debug_output("Error: New display resolution outside Array bounds - no changes made!");
                }
            } else {
                Display_Builder_4.this.debug_output("New display resolution matches current settings - no changes made!");
            }
        }

        public Boolean rotation_is_landscape() {
            if (this.display_rotation == 0.0f || this.display_rotation == (float)Math.PI) {
                return true;
            }
            return false;
        }

        public float rotation_get_radians() {
            return this.display_rotation;
        }

        public void rotation_set_radians(float radians_value) {
            this.display_rotation = radians_value;
            Display_Builder_4.this.ui_elements.update_display_dimensions();
            Display_Builder_4.this.ui_elements.update_softedge_controls();
            Display_Builder_4.this.project.getClass();
            if (this.display_type == 1) {
                this.preview_display_scale_to_parent();
            } else {
                this.displays_update();
            }
        }

        public void softedge_set_value_from_ui(String input_dimension, String input_type, String ui_stringvalue) {
            float ui_stringvalue_parsed = Display_Builder_4.this.parse_math_string_expression(ui_stringvalue);
            Display_Builder_4.this.debug_output("set_softedge_value_from_input: " + input_dimension + ", " + input_type + ", " + ui_stringvalue + ", " + ui_stringvalue_parsed);
            PVector display_footprint = this.display_footprint_get();
            int display_dimension = 0;
            if (input_dimension.equals("x")) {
                display_dimension = Display_Builder_4.round((float)display_footprint.x);
                if (input_type.equals("px")) {
                    this.softedge_dimensions.x = Display_Builder_4.round((float)ui_stringvalue_parsed);
                }
                if (input_type.equals("pc")) {
                    this.softedge_dimensions.x = Display_Builder_4.this.softedge_to_pixels(ui_stringvalue_parsed, display_dimension);
                }
                if (input_type.equals("physical") && Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                    this.softedge_dimensions.x = Display_Builder_4.round((float)(ui_stringvalue_parsed * Display_Builder_4.this.project.viewport_physical_scale));
                }
                Display_Builder_4.this.debug_output("Softedge Horizontal pixel value updated to: " + this.softedge_dimensions.x + "px");
            }
            if (input_dimension.equals("y")) {
                display_dimension = Display_Builder_4.round((float)display_footprint.y);
                if (input_type.equals("px")) {
                    this.softedge_dimensions.y = Display_Builder_4.round((float)ui_stringvalue_parsed);
                }
                if (input_type.equals("pc")) {
                    this.softedge_dimensions.y = Display_Builder_4.this.softedge_to_pixels(ui_stringvalue_parsed, display_dimension);
                }
                if (input_type.equals("physical") && Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                    this.softedge_dimensions.y = Display_Builder_4.round((float)(ui_stringvalue_parsed * Display_Builder_4.this.project.viewport_physical_scale));
                }
                Display_Builder_4.this.debug_output("Softedge Vertical pixel value updated to: " + this.softedge_dimensions.y + "px");
            }
            Display_Builder_4.this.ui_elements.update_softedge_controls();
            this.displays_update();
        }

        public float softedge_values_get(String dimension, String units) {
            PVector display_footprint = this.display_footprint_get();
            float softedge_value = 0.0f;
            if (dimension.equals("horizontal")) {
                if (units.equals("pixel")) {
                    softedge_value = this.softedge_dimensions.x;
                }
                if (units.equals("percentage")) {
                    softedge_value = Display_Builder_4.this.softedge_to_percent(Display_Builder_4.round((float)this.softedge_dimensions.x), Display_Builder_4.round((float)display_footprint.x));
                }
                if (units.equals("physical") && Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                    softedge_value = this.softedge_dimensions.x / Display_Builder_4.this.project.viewport_physical_scale;
                }
            }
            if (dimension.equals("vertical")) {
                if (units.equals("pixel")) {
                    softedge_value = this.softedge_dimensions.y;
                }
                if (units.equals("percentage")) {
                    softedge_value = Display_Builder_4.this.softedge_to_percent(Display_Builder_4.round((float)this.softedge_dimensions.y), Display_Builder_4.round((float)display_footprint.y));
                }
                if (units.equals("physical") && Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                    softedge_value = this.softedge_dimensions.y / Display_Builder_4.this.project.viewport_physical_scale;
                }
            }
            return softedge_value;
        }

        public void softedge_value_sanity_check() {
            float softedge_default_value = 20.0f;
            if (this.softedge_dimensions.x > this.display_resolution.x) {
                if (this.resolution.type_id == Display_Builder_4.this.project.LED_PANEL) {
                    softedge_default_value = 0.0f;
                }
                this.softedge_set_value_from_ui("x", "pc", Display_Builder_4.nf((float)softedge_default_value, (int)1, (int)2));
            }
        }

        public void stagetier_id_set(int new_tier_id) {
            Display_Builder_4.this.debug_output("DisplayGroup " + this.id + " assigned to StageTier: " + this.stagetier_id);
            if (this.stagetier_id != new_tier_id) {
                Display_Builder_4.this.project.stage_tiers.get(this.stagetier_id).displaygroup_unregister(this.id);
            }
            this.stagetier_id = new_tier_id;
            Display_Builder_4.this.project.stage_tiers.get(this.stagetier_id).displaygroup_register(this.id);
        }

        public float stage_dimensions_constrain_to_maximum(float dimension_value, String dimension_name) {
            if (dimension_name.equals("width")) {
                dimension_value = Display_Builder_4.min((float)dimension_value, (float)Display_Builder_4.floor((float)(this.display_resolution.x * Display_Builder_4.this.project.max_stage_size_scale)));
            }
            if (dimension_name.equals("height")) {
                dimension_value = Display_Builder_4.min((float)dimension_value, (float)Display_Builder_4.floor((float)(this.display_resolution.y * Display_Builder_4.this.project.max_stage_size_scale)));
            }
            return dimension_value;
        }

        public void stage_dimensions_display_calculate() {
            this.display_dimensions_stage.x = Display_Builder_4.round((float)(this.display_resolution.x * this.stage_scale));
            this.display_dimensions_stage.y = Display_Builder_4.round((float)(this.display_resolution.y * this.stage_scale));
        }

        public void stage_position_maintain_current() {
            PVector parent_coords = new PVector(0.0f, 0.0f);
            if (this.parent_displaygroup != null) {
                parent_coords = this.parent_displaygroup.alignment_point_calculate(this.parent_alignment_id).copy();
            }
            this.parent_offset = parent_coords.sub(this.anchor_point);
            this.parent_offset.mult(-1.0f);
            this.child_guides_update();
            this.child_displaygroups_update();
            Display_Builder_4.this.ui_elements.parent_offset_controls_update();
        }

        public Boolean stage_scale_active() {
            if (this.stage_scale != 1.0f) {
                return true;
            }
            return false;
        }

        public float stage_scale_adjust_dimensions(float stage_scale_temp) {
            if (stage_scale_temp != 1.0f) {
                boolean dimensions_rounded_to_multiple = false;
                float stage_scale_new = stage_scale_temp;
                float rounding_accuracy = 0.25f;
                int dimension_max_y = Display_Builder_4.floor((float)(this.display_resolution.y * Display_Builder_4.this.project.max_stage_size_scale));
                int loop_iterations_count = 0;
                PVector display_dimensions_temp = new PVector(0.0f, 0.0f);
                display_dimensions_temp.x = this.display_resolution.x * stage_scale_temp;
                display_dimensions_temp.y = this.display_resolution.y * stage_scale_temp;
                dimensions_rounded_to_multiple = display_dimensions_temp.x % (float)Display_Builder_4.this.project.pref_dimension_rounding_multiple <= rounding_accuracy;
                while (!dimensions_rounded_to_multiple && loop_iterations_count < 50) {
                    display_dimensions_temp.y = display_dimensions_temp.y > (float)(dimension_max_y - Display_Builder_4.this.project.pref_dimension_rounding_multiple) ? (display_dimensions_temp.y -= display_dimensions_temp.y % (float)Display_Builder_4.this.project.pref_dimension_rounding_multiple) : (display_dimensions_temp.y += (float)Display_Builder_4.this.project.pref_dimension_rounding_multiple - display_dimensions_temp.y % (float)Display_Builder_4.this.project.pref_dimension_rounding_multiple);
                    display_dimensions_temp.x = display_dimensions_temp.y * this.display_aspect_ratio.floatValue();
                    ++loop_iterations_count;
                    boolean bl = dimensions_rounded_to_multiple = display_dimensions_temp.x % (float)Display_Builder_4.this.project.pref_dimension_rounding_multiple <= rounding_accuracy;
                }
                stage_scale_new = (float)Display_Builder_4.round((float)display_dimensions_temp.x) / this.display_resolution.x;
                Display_Builder_4.this.debug_output("stage_scale adjusted to multiple of: " + Display_Builder_4.this.project.pref_dimension_rounding_multiple + " from: " + stage_scale_temp + ", stage_scale_new: " + stage_scale_new);
                return stage_scale_new;
            }
            return stage_scale_temp;
        }

        public void stage_scale_calculate(String input_name, String input_value) {
            float user_input = Display_Builder_4.this.parse_math_string_expression(input_value);
            float stage_scale_temp = 1.0f;
            if (user_input <= 0.0f) {
                stage_scale_temp = 1.0f;
            } else {
                if (input_name.equals("textfield_display_width_stage")) {
                    user_input = this.stage_dimensions_constrain_to_maximum(user_input, "width");
                    stage_scale_temp = user_input / this.display_resolution.x;
                }
                if (input_name.equals("textfield_display_height_stage")) {
                    user_input = this.stage_dimensions_constrain_to_maximum(user_input, "height");
                    stage_scale_temp = user_input / this.display_resolution.y;
                }
            }
            this.stage_scale_set(stage_scale_temp, Display_Builder_4.this.project.pref_dimension_rounding_automatic);
        }

        public void stage_scale_set(float stage_scale_new, Boolean force_rounding) {
            Display_Builder_4.this.debug_output("stage_scale " + this.stage_scale + " - stage_scale_set: " + stage_scale_new + ", force_rounding: " + force_rounding);
            this.stage_scale = force_rounding != false ? this.stage_scale_adjust_dimensions(stage_scale_new) : stage_scale_new;
            if (this.id > 0 && this.resolution.type_id != Display_Builder_4.this.project.LED_PANEL) {
                this.group_physical_scale_calculate("stage");
            }
            this.projection_surface_bounds_calculate();
            this.display_physical_dimensions_calculate();
            this.displays_update();
            Display_Builder_4.this.ui_elements.update_display_dimensions();
        }
    }

    public class DisplayObject {
        int display_id = 0;
        int row_id = 1;
        int col_id = 1;
        Boolean info_overlay_show = false;
        String name = "Display";
        Boolean name_override = false;
        int outline_colour;
        int output_number;
        int player_number;
        PVector position;
        Boolean position_override;
        float rotation;
        Boolean rotation_override;
        int[] stage_bounds = new int[4];
        PVector stage_footprint = new PVector(0.0f, 0.0f);
        float text_size_id;
        int parent_displaygroup_id;
        DisplayGroup parent_displaygroup;

        DisplayObject() {
            this.outline_colour = Display_Builder_4.this.ui.colour_get_by_name("display_stroke");
            this.output_number = 1;
            this.player_number = this.display_id + 1;
            this.parent_displaygroup_id = 0;
            this.position = new PVector(0.0f, 0.0f);
            this.position_override = false;
            this.rotation = 0.0f;
            this.rotation_override = false;
            this.text_size_id = 36.0f;
        }

        public void bounds_calculate_from_footprint() {
            if (!this.rotation_override.booleanValue()) {
                this.stage_footprint = this.parent_displaygroup.display_footprint_get();
            }
            this.stage_bounds[0] = Display_Builder_4.round((float)(this.position.y - this.stage_footprint.y / 2.0f));
            this.stage_bounds[1] = Display_Builder_4.round((float)(this.position.x + (this.stage_footprint.x / 2.0f - 1.0f)));
            this.stage_bounds[2] = Display_Builder_4.round((float)(this.position.y + (this.stage_footprint.y / 2.0f - 1.0f)));
            this.stage_bounds[3] = Display_Builder_4.round((float)(this.position.x - this.stage_footprint.x / 2.0f));
            this.text_size_id_calculate();
        }

        public int[] bounds_get() {
            return this.stage_bounds;
        }

        public void bounds_offset_apply(PVector offset) {
            this.stage_bounds[0] = this.stage_bounds[0] + Display_Builder_4.round((float)offset.y);
            this.stage_bounds[1] = this.stage_bounds[1] + Display_Builder_4.round((float)offset.x);
            this.stage_bounds[2] = this.stage_bounds[2] + Display_Builder_4.round((float)offset.y);
            this.stage_bounds[3] = this.stage_bounds[3] + Display_Builder_4.round((float)offset.x);
        }

        public void bounds_set(int bounds_top, int bounds_right, int bounds_bottom, int bounds_left) {
            this.stage_bounds[0] = bounds_top;
            this.stage_bounds[1] = bounds_right;
            this.stage_bounds[2] = bounds_bottom;
            this.stage_bounds[3] = bounds_left;
        }

        public void cleanup() {
            Display_Builder_4.this.app.unregisterMethod("mouseEvent", (Object)this);
            this.parent_displaygroup = null;
        }

        public void debug_display_info() {
            String output = "Display: " + this.display_id;
            output = String.valueOf(output) + ", IP:" + this.player_number;
            output = String.valueOf(output) + ", output_id:" + this.output_number;
            output = String.valueOf(output) + ", row:" + this.row_id;
            output = String.valueOf(output) + ", col:" + this.col_id;
            output = String.valueOf(output) + ", width:" + this.stage_footprint.x;
            output = String.valueOf(output) + ", height:" + this.stage_footprint.y;
            output = String.valueOf(output) + ", centre_x:" + this.position.x;
            output = String.valueOf(output) + ", centre_y:" + this.position.y;
            output = String.valueOf(output) + ", rotation:" + this.rotation + " (" + Display_Builder_4.degrees((float)this.rotation) + ")";
            output = String.valueOf(output) + ", color: " + Display_Builder_4.this.get_color_rgb_values_string(this.outline_colour);
            output = String.valueOf(output) + " T: " + this.stage_bounds[0];
            output = String.valueOf(output) + " R: " + this.stage_bounds[1];
            output = String.valueOf(output) + " B: " + this.stage_bounds[2];
            output = String.valueOf(output) + " L: " + this.stage_bounds[3];
            Display_Builder_4.this.debug_output(output);
        }

        public PVector footprint_get() {
            return this.stage_footprint;
        }

        public void footprint_set(int new_x, int new_y) {
            this.stage_footprint.x = new_x;
            this.stage_footprint.y = new_y;
        }

        public void info_overlay_show() {
            if (!Display_Builder_4.this.ui.colourpicker_get_visibility().booleanValue()) {
                Display_Builder_4.this.redraw_screen();
            }
        }

        public Boolean mouse_within_display_check(int mouse_x, int mouse_y) {
            Boolean mouse_within_display = false;
            int stage_x = Display_Builder_4.round((float)Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)((float)mouse_x - Display_Builder_4.this.ui.viewport.x))));
            int stage_y = Display_Builder_4.round((float)Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)((float)mouse_y - Display_Builder_4.this.ui.viewport.y))));
            if (stage_x >= this.stage_bounds[3] && stage_x <= this.stage_bounds[1] && stage_y >= this.stage_bounds[0] && stage_y <= this.stage_bounds[2]) {
                mouse_within_display = true;
            }
            return mouse_within_display;
        }

        public void name_set(String new_name) {
            if (!this.name_override.booleanValue()) {
                this.name = new_name;
            }
        }

        public void outline_colour_set(int new_colour) {
            this.outline_colour = new_colour;
        }

        public void player_number_set(int new_player_number) {
            this.player_number = new_player_number;
        }

        public void output_number_set(int new_output_number) {
            this.output_number = new_output_number;
        }

        public void parent_displaygroup_set(int group_id) {
            if (group_id < Display_Builder_4.this.project.display_groups.size()) {
                this.parent_displaygroup_id = group_id;
                this.parent_displaygroup = Display_Builder_4.this.project.display_groups.get(this.parent_displaygroup_id);
            }
        }

        public void parent_position_delta_apply(PVector offset_delta) {
            if (this.position_override.booleanValue()) {
                this.position_offset_apply(offset_delta);
                this.bounds_offset_apply(offset_delta);
            }
        }

        public void rowcol_ids_set(int new_row, int new_col) {
            this.row_id = new_row;
            this.col_id = new_col;
        }

        public void position_calculate_from_bounds() {
            PVector display_dimensions = new PVector((float)(this.stage_bounds[1] - this.stage_bounds[3]), (float)(this.stage_bounds[2] - this.stage_bounds[0]));
            this.position.x = (float)this.stage_bounds[3] + display_dimensions.x / 2.0f;
            this.position.y = (float)this.stage_bounds[0] + display_dimensions.y / 2.0f;
        }

        public void position_offset_apply(PVector offset) {
            this.position.add(offset);
        }

        public void position_set(float new_x, float new_y) {
            if (!this.position_override.booleanValue()) {
                this.position.x = new_x;
                this.position.y = new_y;
            }
            this.bounds_calculate_from_footprint();
        }

        public void rotation_set(float new_rotation) {
            if (!this.rotation_override.booleanValue()) {
                this.rotation = new_rotation;
            }
        }

        public void strings_set() {
            this.name = this.parent_displaygroup.display_name_get(this.display_id);
            int[] player_output_numbers = this.parent_displaygroup.display_player_output_numbers_get(this.display_id);
            this.player_number = player_output_numbers[0];
            this.output_number = player_output_numbers[1];
        }

        public void text_size_id_calculate() {
            this.text_size_id = Display_Builder_4.min((float)this.stage_footprint.x, (float)this.stage_footprint.y) * 0.35f;
            this.text_size_id = Display_Builder_4.max((float)36.0f, (float)this.text_size_id);
        }

        public void draw_rect() {
            if (Display_Builder_4.this.ui.active.booleanValue()) {
                PVector orig = Display_Builder_4.this.stage_to_screen(this.position);
                int fill_opacity = 128;
                int fill_colour = Display_Builder_4.this.ui.colour_get_by_name("display_fill");
                if (this.parent_displaygroup.display_colour_mode == 4) {
                    fill_colour = this.outline_colour;
                }
                if (this.parent_displaygroup.display_selected_id_check(this.display_id).booleanValue()) {
                    fill_opacity = 200;
                }
                if (this.parent_displaygroup_id != Display_Builder_4.this.project.current_displaygroup_id) {
                    fill_opacity = 66;
                }
                fill_colour = fill_colour & 0xFFFFFF | fill_opacity << 24;
                Display_Builder_4.this.fill(fill_colour);
                Display_Builder_4.this.stroke(this.outline_colour);
                float base_font_size = 24.0f * Display_Builder_4.this.ui.window_scale * Display_Builder_4.this.calculate_reciprocal_scale();
                Display_Builder_4.this.pushMatrix();
                Display_Builder_4.this.translate(Display_Builder_4.this.ui.viewport.x + orig.x, Display_Builder_4.this.ui.viewport.y + orig.y);
                Display_Builder_4.this.scale(Display_Builder_4.this.ui.viewport_scale / 100.0f);
                Display_Builder_4.this.rectMode(3);
                Display_Builder_4.this.rect(0.0f, 0.0f, this.stage_footprint.x, this.stage_footprint.y);
                Display_Builder_4.this.pushMatrix();
                Display_Builder_4.this.rotate(this.rotation);
                if (this.parent_displaygroup != null && this.parent_displaygroup.display_aspect_ratio_get() > 1.34f && this.parent_displaygroup.display_show_43_marks.booleanValue()) {
                    float display_shortest_dimension = Display_Builder_4.min((float)this.stage_footprint.x, (float)this.stage_footprint.y);
                    float display_width_43_centre_offset = display_shortest_dimension * (PApplet.parseFloat((int)4) / 3.0f) / 2.0f;
                    float line_length = display_shortest_dimension * 0.2f;
                    float line_origin = display_shortest_dimension / 2.0f * -1.0f;
                    Display_Builder_4.this.line(display_width_43_centre_offset * -1.0f, line_origin, display_width_43_centre_offset * -1.0f, line_origin + line_length);
                    Display_Builder_4.this.line(display_width_43_centre_offset, line_origin, display_width_43_centre_offset, line_origin + line_length);
                    Display_Builder_4.this.line(display_width_43_centre_offset * -1.0f, line_origin *= -1.0f, display_width_43_centre_offset * -1.0f, line_origin - line_length);
                    Display_Builder_4.this.line(display_width_43_centre_offset, line_origin, display_width_43_centre_offset, line_origin - line_length);
                }
                Display_Builder_4.this.textFont(Display_Builder_4.this.font_display_id, this.text_size_id);
                Display_Builder_4.this.textAlign(3, 3);
                if (this.display_id >= 0) {
                    int display_number = Display_Builder_4.this.get_number_from_id(this.display_id);
                    if (Display_Builder_4.this.project.pref_ui_view_display_output_ids.booleanValue()) {
                        display_number = this.output_number;
                    }
                    Display_Builder_4.this.text("" + display_number, 0.0f, this.text_size_id * -0.1f);
                }
                Display_Builder_4.this.popMatrix();
                if (Display_Builder_4.this.project.pref_ui_show_display_info.booleanValue() && this.info_overlay_show.booleanValue()) {
                    int mark_length = Display_Builder_4.round((float)(this.stage_footprint.y * 0.1f));
                    int bounds_x_inner = Display_Builder_4.round((float)(this.stage_footprint.x / 2.0f));
                    int bounds_x_outer = bounds_x_inner + mark_length;
                    int bounds_y_inner = Display_Builder_4.round((float)(this.stage_footprint.y / 2.0f));
                    int bounds_y_outer = bounds_y_inner + mark_length;
                    Display_Builder_4.this.stroke(255.0f, 255.0f, 255.0f, 200.0f);
                    Display_Builder_4.this.line(0 - bounds_x_inner, 0 - bounds_y_inner, 0 - bounds_x_inner, 0 - bounds_y_outer);
                    Display_Builder_4.this.line(0 - bounds_x_inner, 0 - bounds_y_inner, 0 - bounds_x_outer, 0 - bounds_y_inner);
                    Display_Builder_4.this.line(0 + bounds_x_inner, 0 - bounds_y_inner, 0 + bounds_x_inner, 0 - bounds_y_outer);
                    Display_Builder_4.this.line(0 + bounds_x_inner, 0 - bounds_y_inner, 0 + bounds_x_outer, 0 - bounds_y_inner);
                    Display_Builder_4.this.line(0 - bounds_x_inner, 0 + bounds_y_inner, 0 - bounds_x_inner, 0 + bounds_y_outer);
                    Display_Builder_4.this.line(0 - bounds_x_inner, 0 + bounds_y_inner, 0 - bounds_x_outer, 0 + bounds_y_inner);
                    Display_Builder_4.this.line(0 + bounds_x_inner, 0 + bounds_y_inner, 0 + bounds_x_inner, 0 + bounds_y_outer);
                    Display_Builder_4.this.line(0 + bounds_x_inner, 0 + bounds_y_inner, 0 + bounds_x_outer, 0 + bounds_y_inner);
                    int text_offset = 0;
                    Display_Builder_4.this.textFont(Display_Builder_4.this.font_display_id, base_font_size * 0.6f);
                    Display_Builder_4.this.fill(Display_Builder_4.this.ui.colour_get_by_name("info_text"));
                    text_offset = 15;
                    int label_x = Display_Builder_4.round((float)(this.stage_footprint.x / 2.0f));
                    int label_y = Display_Builder_4.round((float)(this.stage_footprint.y / 2.0f)) + text_offset;
                    Display_Builder_4.this.textAlign(3, 0);
                    Display_Builder_4.this.text(Display_Builder_4.this.coordinates_get_as_string(this.stage_bounds[3], this.stage_bounds[0]), 0 - label_x, 0 - label_y);
                    Display_Builder_4.this.textAlign(3, 101);
                    Display_Builder_4.this.text(Display_Builder_4.this.coordinates_get_as_string(this.stage_bounds[1], this.stage_bounds[2]), label_x, label_y);
                    if (Display_Builder_4.this.project.pref_ui_show_display_info_crop.booleanValue()) {
                        Display_Builder_4.this.textAlign(3, 3);
                        Display_Builder_4.this.text("(" + (this.stage_bounds[0] - this.parent_displaygroup.projection_surface_bounds[0]) + ")", 0.0f, bounds_y_inner * -1);
                        Display_Builder_4.this.text("(" + (this.stage_bounds[3] - this.parent_displaygroup.projection_surface_bounds[3]) + ")", bounds_x_inner * -1, 0.0f);
                        Display_Builder_4.this.text("(" + (this.parent_displaygroup.projection_surface_bounds[2] - this.stage_bounds[2]) + ")", 0.0f, bounds_y_inner);
                        Display_Builder_4.this.text("(" + (this.parent_displaygroup.projection_surface_bounds[1] - this.stage_bounds[1]) + ")", bounds_x_inner, 0.0f);
                    }
                    if (Display_Builder_4.this.project.pref_ui_show_overlay_display_spacing.booleanValue()) {
                        String display_spacing_text;
                        PVector display_spacing = new PVector(0.0f, 0.0f);
                        if (this.parent_displaygroup.display_cols > 1 && this.col_id < this.parent_displaygroup.display_cols - 1) {
                            display_spacing.x = this.stage_footprint.x - this.parent_displaygroup.softedge_dimensions.x;
                            display_spacing_text = String.valueOf(display_spacing.x) + "px";
                            if (Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                                display_spacing_text = String.valueOf(display_spacing_text) + ", " + Display_Builder_4.this.physical_dimension_get_as_string(Display_Builder_4.this.pixels_to_physical(Display_Builder_4.round((float)display_spacing.x))) + "m";
                            }
                            Display_Builder_4.this.line(0.0f, 0 - mark_length / 2, 0.0f, mark_length / 2);
                            Display_Builder_4.this.line(0.0f, 0.0f, display_spacing.x, 0.0f);
                            Display_Builder_4.this.line(display_spacing.x, 0 - mark_length / 2, display_spacing.x, mark_length / 2);
                            Display_Builder_4.this.textAlign(3, 3);
                            Display_Builder_4.this.text(String.valueOf(Display_Builder_4.this.ui.symbol_arrow_strings[3]) + " " + display_spacing_text + " " + Display_Builder_4.this.ui.symbol_arrow_strings[1], display_spacing.x / 2.0f, base_font_size * -1.0f);
                        }
                        if (this.parent_displaygroup.display_rows > 1 && this.row_id < this.parent_displaygroup.display_rows - 1) {
                            display_spacing.y = this.stage_footprint.y - this.parent_displaygroup.softedge_dimensions.y;
                            display_spacing_text = String.valueOf(display_spacing.y) + "px";
                            if (Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                                display_spacing_text = String.valueOf(display_spacing_text) + ", " + Display_Builder_4.this.physical_dimension_get_as_string(Display_Builder_4.this.pixels_to_physical(Display_Builder_4.round((float)display_spacing.y))) + "m";
                            }
                            Display_Builder_4.this.line(0 - mark_length / 2, 0.0f, mark_length / 2, 0.0f);
                            Display_Builder_4.this.line(0.0f, 0.0f, 0.0f, display_spacing.y);
                            Display_Builder_4.this.line(0 - mark_length / 2, display_spacing.y, mark_length / 2, display_spacing.y);
                            Display_Builder_4.this.textAlign(3, 3);
                            Display_Builder_4.this.text("| " + display_spacing_text + " |", 0.0f, display_spacing.y / 2.0f);
                        }
                    }
                    Display_Builder_4.this.line(0 - mark_length / 2, 0.0f, mark_length / 2, 0.0f);
                    Display_Builder_4.this.line(0.0f, 0 - mark_length / 2, 0.0f, mark_length / 2);
                    Display_Builder_4.this.textAlign(3, 3);
                    Display_Builder_4.this.text(Display_Builder_4.this.coordinates_get_as_string(this.position), 0.0f, 0.0f - base_font_size);
                    String display_name_text = "[" + Display_Builder_4.this.get_number_from_id(this.parent_displaygroup_id) + "] " + this.name;
                    if (this.position_override.booleanValue()) {
                        display_name_text = String.valueOf(display_name_text) + " " + Display_Builder_4.this.ui.symbol_position;
                    }
                    if (this.rotation_override.booleanValue()) {
                        display_name_text = String.valueOf(display_name_text) + " " + Display_Builder_4.this.ui.symbol_rotation;
                    }
                    if (this.parent_displaygroup.stage_scale_active().booleanValue()) {
                        display_name_text = String.valueOf(display_name_text) + " " + Display_Builder_4.this.ui.symbol_scale;
                    }
                    display_name_text = String.valueOf(display_name_text) + "\n\n";
                    if (this.parent_displaygroup.display_type == Display_Builder_4.this.project.DISPLAY_VIRTUAL) {
                        display_name_text = String.valueOf(display_name_text) + "\nV-Display " + Display_Builder_4.this.get_number_from_id(this.col_id);
                        display_name_text = String.valueOf(display_name_text) + "\n";
                    } else {
                        display_name_text = String.valueOf(display_name_text) + "\n" + this.parent_displaygroup.player_name_prefix + this.player_number;
                        display_name_text = String.valueOf(display_name_text) + "\nOutput " + this.output_number;
                    }
                    Display_Builder_4.this.textAlign(3, 3);
                    Display_Builder_4.this.textFont(Display_Builder_4.this.font_display_id, base_font_size * 0.75f);
                    Display_Builder_4.this.fill(this.outline_colour);
                    if (this.parent_displaygroup.display_colour_mode == 4) {
                        Display_Builder_4.this.fill(Display_Builder_4.this.color(255, 255, 255, 180));
                    }
                    Display_Builder_4.this.text(display_name_text, 0.0f, 0.0f);
                }
                Display_Builder_4.this.popMatrix();
            }
        }
    }

    class DisplayResolution {
        int id;
        float aspect_ratio;
        int grid_cols;
        int grid_rows;
        String name;
        PVector physical_dimensions;
        PVector pixel_count;
        int type_id;

        DisplayResolution(String rname, int rwidth, int rheight, int rcols, int rrows, int rtype_id, float rwidth_physical, float rheight_physical) {
            this.id = Display_Builder_4.this.get_resolution_uid();
            this.aspect_ratio = Display_Builder_4.this.aspect_ratio_calculate(rwidth, rheight);
            this.grid_cols = rcols;
            this.grid_rows = rrows;
            this.name = rname;
            this.physical_dimensions = new PVector(rwidth_physical, rheight_physical);
            this.pixel_count = new PVector((float)rwidth, (float)rheight);
            this.type_id = rtype_id;
            Display_Builder_4.this.project.resolutions_lookup.set(this.name, this.id);
        }
    }

    class ExportFormat {
        int id;
        String comment_prefix;
        int comment_type;
        Boolean export_clipboard;
        Boolean export_file;
        Boolean export_stagetiers_separate_files;
        String file_extension;
        String format_name;
        String name;

        ExportFormat() {
        }
    }

    class Exports {
        ArrayList<ExportFormat> export_formats;
        StringList format_label_list = new StringList();
        final int[] format_lookup_list;
        int format_id_selected;
        String export_folder_filepath;
        PGraphics grid_image;
        final int EXPORT_FILES = 0;
        final int EXPORT_CLIPBOARD = 1;
        final int FORMAT_CSV = 0;
        final int FORMAT_WOV4 = 1;
        final int FORMAT_WOV5 = 2;
        final int FORMAT_WOV6 = 3;
        final int FORMAT_MPCDI = 4;
        final int FORMAT_CSV_D3 = 5;
        final int FORMAT_KINETIC_RS = 6;
        final int FORMAT_PSD_JSX = 7;
        final int FORMAT_WOV7 = 8;

        Exports() {
            int[] nArray = new int[9];
            nArray[0] = 8;
            nArray[1] = 3;
            nArray[2] = 2;
            nArray[3] = 1;
            nArray[5] = 5;
            nArray[6] = 6;
            nArray[7] = 7;
            nArray[8] = 4;
            this.format_lookup_list = nArray;
            this.export_folder_filepath = "exports/";
            this.EXPORT_FILES = 0;
            this.EXPORT_CLIPBOARD = 1;
            this.FORMAT_CSV = 0;
            this.FORMAT_WOV4 = 1;
            this.FORMAT_WOV5 = 2;
            this.FORMAT_WOV6 = 3;
            this.FORMAT_MPCDI = 4;
            this.FORMAT_CSV_D3 = 5;
            this.FORMAT_KINETIC_RS = 6;
            this.FORMAT_PSD_JSX = 7;
            this.FORMAT_WOV7 = 8;
            this.export_formats = new ArrayList();
        }

        public void init() {
            this.export_formats_list_build();
        }

        public void display_data_export(int export_type) {
            ArrayList<MixedInputResult> image_file_list = new ArrayList<MixedInputResult>();
            ExportFormat format_options = this.export_format_config_get(this.format_id_selected);
            Display_Builder_4.this.debug_output("display_data_export type " + export_type + " in format: '" + format_options.name + "'.");
            int comment_type = format_options.comment_type;
            String comment_prefix = format_options.comment_prefix;
            String export_date = Display_Builder_4.this.get_current_date_string();
            String export_filename_separator = "-";
            Display_Builder_4.this.check_memory();
            UI uI = Display_Builder_4.this.ui;
            Display_Builder_4.this.ui.getClass();
            uI.osd_message_display("Exporting data...", 0);
            if (export_type == 0) {
                MixedInputResult image_file_status;
                if (Display_Builder_4.this.project.pref_export_pixel_grid.booleanValue()) {
                    for (DisplayGroup group : Display_Builder_4.this.project.display_groups) {
                        image_file_status = Display_Builder_4.this.displaygroup_grid_image_render(group, this.grid_image, "pixel");
                        if (image_file_status != null) {
                            image_file_list.add(image_file_status);
                            UI uI2 = Display_Builder_4.this.ui;
                            String string = "Pixel grid successfully exported for Display Group " + Display_Builder_4.this.get_number_from_id(group.id) + ".";
                            Display_Builder_4.this.ui.getClass();
                            uI2.osd_message_display(string, 1);
                        }
                        if (this.format_id_selected != 5 || !Display_Builder_4.this.project.physical_settings_active.booleanValue() || (image_file_status = group.projection_surface_obj_data_get()) == null) continue;
                        image_file_list.add(image_file_status);
                        UI uI3 = Display_Builder_4.this.ui;
                        String string = "OBJ file successfully exported for Display Group " + Display_Builder_4.this.get_number_from_id(group.id) + ".";
                        Display_Builder_4.this.ui.getClass();
                        uI3.osd_message_display(string, 1);
                    }
                }
                if (Display_Builder_4.this.project.pref_export_physical_grid.booleanValue() && (image_file_status = Display_Builder_4.this.project_physical_grid_render(this.grid_image)) != null) {
                    image_file_list.add(image_file_status);
                    UI uI4 = Display_Builder_4.this.ui;
                    Display_Builder_4.this.ui.getClass();
                    uI4.osd_message_display("Physical grid successfully exported.", 1);
                }
                if (Display_Builder_4.this.project.pref_export_warping_grid.booleanValue() && (image_file_status = Display_Builder_4.this.create_display_reference_grid(0)) != null) {
                    image_file_list.add(image_file_status);
                }
                if (Display_Builder_4.this.project.pref_export_colourbars.booleanValue()) {
                    float export_scale;
                    PVector image_dimensions = Display_Builder_4.this.project.current_displaygroup.display_resolution.copy();
                    if (Display_Builder_4.this.project.current_displaygroup.display_type == Display_Builder_4.this.project.LED_PANEL) {
                        image_dimensions = Display_Builder_4.this.project.current_displaygroup.projection_surface_dimensions_get();
                    }
                    if ((image_file_status = Display_Builder_4.this.test_pattern_image_create("softedge", "greyscale", image_dimensions, export_scale = Display_Builder_4.this.export_manager.max_image_scale_calculate(image_dimensions))) != null) {
                        image_file_list.add(image_file_status);
                    }
                    if ((image_file_status = Display_Builder_4.this.test_pattern_image_create("softedge", "rgb-16-180", image_dimensions, export_scale)) != null) {
                        image_file_list.add(image_file_status);
                    }
                    if ((image_file_status = Display_Builder_4.this.test_pattern_image_create("softedge", "rgb-0-255", image_dimensions, export_scale)) != null) {
                        image_file_list.add(image_file_status);
                    }
                    if ((image_file_status = Display_Builder_4.this.test_pattern_image_create("smpte-bars", "rgb-16-180", image_dimensions, export_scale)) != null) {
                        image_file_list.add(image_file_status);
                    }
                    if ((image_file_status = Display_Builder_4.this.test_pattern_image_create("test-pattern", "rgb-16-180", image_dimensions, export_scale)) != null) {
                        image_file_list.add(image_file_status);
                    }
                }
            }
            for (MixedInputResult image_result : image_file_list) {
                Display_Builder_4.this.debug_output("image_file_list: " + image_result.status + ", " + image_result.value + ", " + image_result.text);
            }
            if (Display_Builder_4.this.project.pref_export_display_data.booleanValue() || Display_Builder_4.this.project.pref_export_psd_jsx.booleanValue()) {
                Display_Builder_4.this.debug_output("Preparing Export type " + export_type + " in format: '" + this.export_formats.get((int)this.format_id_selected).name + "'.");
                StringList export_output = new StringList();
                StringList export_output_prefix = new StringList();
                StringList export_output_displays = new StringList();
                StringList export_output_suffix = new StringList();
                StringList export_output_comments = new StringList();
                for (StageTier tier : Display_Builder_4.this.project.stage_tiers) {
                    int export_tier_id = tier.id;
                    export_output.clear();
                    export_output_prefix.clear();
                    export_output_displays.clear();
                    export_output_suffix.clear();
                    export_output_comments.clear();
                    String export_filename_temp = String.valueOf(Display_Builder_4.this.project.pref_project_name) + " " + export_date;
                    if (export_type == 1 && export_tier_id != Display_Builder_4.this.project.current_stage_tier.id) {
                        Display_Builder_4.this.debug_output("Export ignoring StageTier " + export_tier_id + " for clipboard export.");
                        continue;
                    }
                    if (this.format_id_selected == 0 || this.format_id_selected == 5) {
                        comment_prefix = "# ";
                    }
                    export_output_comments.append(comment_prefix);
                    export_output_comments.append(String.valueOf(comment_prefix) + "Project: " + Display_Builder_4.this.project.pref_project_name);
                    export_output_comments.append(comment_prefix);
                    if (Display_Builder_4.this.project.stage_tiers.size() > 1) {
                        export_filename_temp = String.valueOf(export_filename_temp) + " tier" + Display_Builder_4.this.get_number_from_id(tier.id) + " ";
                        export_output_comments.append(String.valueOf(comment_prefix) + "StageTier " + Display_Builder_4.this.get_number_from_id(tier.id) + ": " + tier.name);
                        export_output_comments.append(comment_prefix);
                    }
                    if (!format_options.format_name.equals("")) {
                        export_filename_temp = String.valueOf(export_filename_temp) + " " + format_options.format_name;
                    }
                    export_filename_temp = String.valueOf(export_filename_temp) + format_options.file_extension;
                    if (Display_Builder_4.this.project.pref_export_display_data.booleanValue()) {
                        for (DisplayGroup group : Display_Builder_4.this.project.display_groups) {
                            if (!format_options.export_stagetiers_separate_files.booleanValue() || export_tier_id != group.stagetier_id) continue;
                            switch (this.format_id_selected) {
                                case 0: {
                                    export_output_displays.append(Display_Builder_4.this.export_data_csv(group));
                                    break;
                                }
                                case 1: {
                                    export_output_displays.append(Display_Builder_4.this.export_data_wo4(group));
                                    break;
                                }
                                case 2: {
                                    export_output_displays.append(Display_Builder_4.this.wo5_export_data(group));
                                    break;
                                }
                                case 3: {
                                    export_output_displays.append(Display_Builder_4.this.export_data_wo6(group));
                                    break;
                                }
                                case 4: {
                                    if (export_type == 0) {
                                        Display_Builder_4.this.mpcdi_file_export();
                                        break;
                                    }
                                    UI uI5 = Display_Builder_4.this.ui;
                                    Display_Builder_4.this.ui.getClass();
                                    uI5.osd_message_display("Cannot copy MPCDI data to clipboard.", 2);
                                    break;
                                }
                                case 5: {
                                    if (Display_Builder_4.this.project.physical_settings_active.booleanValue()) {
                                        export_output_displays.append(Display_Builder_4.this.export_data_d3_csv(group));
                                        break;
                                    }
                                    export_output_displays.clear();
                                    UI uI6 = Display_Builder_4.this.ui;
                                    Display_Builder_4.this.ui.getClass();
                                    uI6.osd_message_display("Physical dimensions are required for D3 projector exports.", 2);
                                    break;
                                }
                                case 6: {
                                    export_output_displays = Display_Builder_4.this.generate_kinetic_rendersurface_csv(group);
                                    break;
                                }
                                case 7: {
                                    break;
                                }
                                case 8: {
                                    export_output_comments.clear();
                                    export_output_displays.append(Display_Builder_4.this.export_data_wo7(group));
                                }
                            }
                        }
                    }
                    if (Display_Builder_4.this.project.pref_export_psd_jsx.booleanValue()) {
                        export_filename_temp = String.valueOf(export_filename_temp) + "PSD script.jsx";
                        comment_prefix = "// ";
                        export_output_displays = Display_Builder_4.this.generate_project_psd_jsx_script(image_file_list);
                    }
                    if (export_output_displays.size() > 0) {
                        if (this.format_id_selected != 6) {
                            export_output_comments.append(Display_Builder_4.this.project.displaygroup_data_text_get(export_tier_id, comment_prefix));
                            export_output_comments.append(this.project_data_comments_get(comment_type, comment_prefix));
                        } else {
                            export_output_comments.clear();
                            export_output_comments.append(String.valueOf(comment_prefix) + "Project: " + Display_Builder_4.this.project.pref_project_name);
                            export_output_comments.append(String.valueOf(comment_prefix) + Display_Builder_4.this.app_signature_get());
                        }
                        export_output.append(export_output_prefix);
                        export_output.append(export_output_displays);
                        export_output.append(export_output_suffix);
                        if (format_options.comment_type > 0) {
                            export_output.append(export_output_comments);
                        }
                        if (export_type == 0) {
                            String export_filename = export_filename_temp.replaceAll("\\s", export_filename_separator);
                            Display_Builder_4.this.saveStrings(String.valueOf(this.export_folder_filepath) + export_filename, export_output.array());
                            UI uI7 = Display_Builder_4.this.ui;
                            String string = "Data successfully exported to: " + export_filename;
                            Display_Builder_4.this.ui.getClass();
                            uI7.osd_message_display(string, 1);
                        }
                        if (export_type != 1) continue;
                        Display_Builder_4.this.clipboard_contents_set(Display_Builder_4.this.convert_stringlist_to_string(export_output));
                        UI uI8 = Display_Builder_4.this.ui;
                        String string = "Data successfully copied to system clipboard for StageTier " + Display_Builder_4.this.get_number_from_id(tier.id);
                        Display_Builder_4.this.ui.getClass();
                        uI8.osd_message_display(string, 1);
                        continue;
                    }
                    UI uI9 = Display_Builder_4.this.ui;
                    Display_Builder_4.this.ui.getClass();
                    uI9.osd_message_display("Export failed!", 2);
                    Display_Builder_4.this.debug_output("Export failed for StageTier " + tier.id + " in type: " + this.format_id_selected + " format: " + export_type);
                }
            }
            image_file_list.clear();
        }

        public void export_display_data_to_clipboard() {
            this.display_data_export(1);
        }

        public ExportFormat export_format_config_get(int format_id) {
            ExportFormat export_format = this.export_format_id_is_valid(format_id) != false ? this.export_formats.get(format_id) : this.export_formats.get(0);
            return export_format;
        }

        public int export_format_count_get() {
            return this.export_formats.size();
        }

        public Boolean export_format_id_is_valid(int check_id) {
            if (check_id >= 0 && check_id < this.export_formats.size()) {
                return true;
            }
            return false;
        }

        public void export_folder_filepath_set(String filepath) {
            if (!filepath.equals("")) {
                this.export_folder_filepath = filepath;
                Display_Builder_4.this.debug_output("Exoprt filepatyh set to: " + this.export_folder_filepath);
            }
        }

        public void export_folder_selected_by_user(String filepath_selected) {
            this.export_folder_filepath_set(filepath_selected);
            this.display_data_export(0);
        }

        public void export_formats_list_build() {
            ExportFormat new_format = Display_Builder_4.this.export_format_config_csv(new ExportFormat());
            this.export_formats.add(new_format);
            this.format_label_list.append(new_format.name);
            new_format = Display_Builder_4.this.export_format_config_wo4(new ExportFormat());
            this.export_formats.add(new_format);
            this.format_label_list.append(new_format.name);
            new_format = Display_Builder_4.this.export_format_config_wo5(new ExportFormat());
            this.export_formats.add(new_format);
            this.format_label_list.append(new_format.name);
            new_format = Display_Builder_4.this.export_format_config_wo6(new ExportFormat());
            this.export_formats.add(new_format);
            this.format_label_list.append(new_format.name);
            new_format = Display_Builder_4.this.export_format_config_mpcdi(new ExportFormat());
            this.export_formats.add(new_format);
            this.format_label_list.append(new_format.name);
            new_format = Display_Builder_4.this.export_format_config_d3(new ExportFormat());
            this.export_formats.add(new_format);
            this.format_label_list.append(new_format.name);
            new_format = Display_Builder_4.this.export_format_config_kinetic(new ExportFormat());
            this.export_formats.add(new_format);
            this.format_label_list.append(new_format.name);
            new_format = Display_Builder_4.this.export_format_config_psd_jsx_script(new ExportFormat());
            this.export_formats.add(new_format);
            this.format_label_list.append(new_format.name);
            new_format = Display_Builder_4.this.export_format_config_wo7(new ExportFormat());
            this.export_formats.add(new_format);
            this.format_label_list.append(new_format.name);
            Display_Builder_4.this.debug_output("Added " + this.format_label_list.size() + " export formats.");
        }

        public String export_format_list_label_get(int format_id) {
            if (this.export_format_id_is_valid(format_id).booleanValue()) {
                return this.format_label_list.get(format_id);
            }
            return " - ";
        }

        public String export_format_list_label_get_current() {
            if (this.export_format_id_is_valid(this.format_id_selected).booleanValue()) {
                return this.format_label_list.get(this.format_id_selected);
            }
            return " - ";
        }

        public void export_format_select(int format_id) {
            if (this.export_format_id_is_valid(format_id).booleanValue() && format_id != this.format_id_selected) {
                this.format_id_selected = format_id;
                UI uI = Display_Builder_4.this.ui;
                String string = "Export format updated to: " + this.format_label_list.get(this.format_id_selected);
                Display_Builder_4.this.ui.getClass();
                uI.osd_message_display(string, 0);
            }
        }

        public void export_format_select_from_menu_entry(int menu_id) {
            if (this.export_format_id_is_valid(menu_id).booleanValue()) {
                this.export_format_select(this.format_lookup_list[menu_id]);
            }
        }

        public float max_image_scale_calculate(PVector export_dimensions) {
            float image_scale = 0.0f;
            int available_memory = Display_Builder_4.floor((float)(Display_Builder_4.this.check_memory() / 4));
            int max_bytes = available_memory / 4;
            int max_width = max_bytes / Display_Builder_4.round((float)export_dimensions.y);
            int i = 5;
            while (i > 0) {
                if (export_dimensions.x / (float)i < (float)max_width) {
                    image_scale = 1.0f / PApplet.parseFloat((int)i);
                }
                --i;
            }
            Display_Builder_4.this.debug_output("Memory: " + available_memory + ". Maximum image buffer is: " + max_width + ", " + export_dimensions.y + ", export scale: " + image_scale);
            return image_scale;
        }

        public StringList project_data_comments_get(int comment_type, String comment_prefix) {
            StringList comment_lines = new StringList();
            switch (comment_type) {
                case 0: {
                    break;
                }
                case 1: {
                    int[] displaygroup_counts = Display_Builder_4.this.project.displaygroup_data_counts_get();
                    String project_summary = String.valueOf(comment_prefix) + "Project uses: " + displaygroup_counts[0] + " Displays";
                    project_summary = String.valueOf(project_summary) + ", a total of " + displaygroup_counts[1] + " (" + Display_Builder_4.this.human_readable_number_string(displaygroup_counts[1]) + ") pixels";
                    project_summary = String.valueOf(project_summary) + ", and " + displaygroup_counts[2] + " Player(s).";
                    comment_lines.append(project_summary);
                    PVector projection_surface_dimensions = Display_Builder_4.this.project.surface_dimensions_get("project");
                    int[] projection_surface_bounds = Display_Builder_4.this.project.surface_bounds_get("project");
                    comment_lines.append(String.valueOf(comment_prefix) + "Project Total Projection Surface: " + projection_surface_dimensions.x + " x " + projection_surface_dimensions.y + "px");
                    float surface_centre_x = (float)projection_surface_bounds[3] + projection_surface_dimensions.x / 2.0f;
                    float surface_centre_y = (float)projection_surface_bounds[0] + projection_surface_dimensions.y / 2.0f;
                    String surface_centre = "Project Projection Surface Centre: " + surface_centre_x + " x " + surface_centre_y + "px (exact)";
                    surface_centre = String.valueOf(surface_centre) + " - " + Display_Builder_4.round((float)surface_centre_x) + " x " + Display_Builder_4.round((float)surface_centre_y) + "px (rounded)";
                    comment_lines.append(String.valueOf(comment_prefix) + surface_centre);
                    comment_lines.append(comment_prefix);
                    comment_lines.append(String.valueOf(comment_prefix) + Display_Builder_4.this.app_signature_get());
                    break;
                }
                case 2: {
                    comment_lines.append(String.valueOf(comment_prefix) + "Project: " + Display_Builder_4.this.project.pref_project_name);
                    comment_lines.append(String.valueOf(comment_prefix) + Display_Builder_4.this.app_signature_get());
                }
            }
            return comment_lines;
        }
    }

    class Grid {
        int id;
        int alignment_id = 0;
        PVector drawing_origin;
        PVector grid_cell_size;
        PVector grid_cell_size_screen;
        int[] grid_cell_count = new int[]{1, 1};
        int[] grid_vector = new int[]{1, 1};
        int[] grid_bounds = new int[4];
        int grid_alpha = 128;
        String name;
        PVector origin_offset;
        PVector stage_origin;
        Boolean visible = false;

        Grid(int gid, String gname) {
            this.id = gid;
            this.name = gname;
            this.grid_cell_size = new PVector(1.0f, 1.0f);
            this.grid_cell_size_screen = new PVector(0.0f, 0.0f);
            this.drawing_origin = new PVector(0.0f, 0.0f);
            this.origin_offset = new PVector(0.0f, 0.0f);
            this.stage_origin = new PVector(0.0f, 0.0f);
        }

        public int alignment_id_get() {
            return this.alignment_id;
        }

        public void alignment_id_set(int new_value) {
            if (new_value >= 0 && new_value != this.alignment_id) {
                this.alignment_id = new_value;
                this.grid_data_calculate();
            }
        }

        public void grid_bounds_set(int top, int right, int bottom, int left) {
            this.grid_bounds[0] = top;
            this.grid_bounds[1] = right;
            this.grid_bounds[2] = bottom;
            this.grid_bounds[3] = left;
            this.grid_data_calculate();
        }

        public void grid_data_calculate() {
            if (Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                this.grid_scale_calculate();
                PVector grid_surface_dimensions = Display_Builder_4.this.dimensions_from_bounds(this.grid_bounds);
                PVector grid_surface_centre = PVector.mult((PVector)grid_surface_dimensions, (float)0.5f);
                grid_surface_centre.x += (float)this.grid_bounds[3];
                grid_surface_centre.y += (float)this.grid_bounds[0];
                PVector origin_offset_pixels_stage = new PVector((float)Display_Builder_4.round((float)Display_Builder_4.this.physical_to_pixels(this.origin_offset.x)), (float)Display_Builder_4.round((float)Display_Builder_4.this.physical_to_pixels(this.origin_offset.y)));
                PVector grid_cell_size_stage = new PVector(0.0f, 0.0f);
                grid_cell_size_stage.x = Display_Builder_4.this.physical_to_pixels(this.grid_cell_size.x);
                grid_cell_size_stage.y = Display_Builder_4.this.physical_to_pixels(this.grid_cell_size.y);
                grid_surface_dimensions.x += Display_Builder_4.abs((float)origin_offset_pixels_stage.x);
                grid_surface_dimensions.y += Display_Builder_4.abs((float)origin_offset_pixels_stage.y);
                this.stage_origin = origin_offset_pixels_stage.copy();
                switch (this.alignment_id) {
                    default: {
                        this.stage_origin.x += (float)this.grid_bounds[3];
                        this.stage_origin.y += (float)this.grid_bounds[0];
                        break;
                    }
                    case 1: {
                        this.stage_origin.x = grid_surface_centre.x + origin_offset_pixels_stage.x;
                        this.stage_origin.y += (float)this.grid_bounds[0];
                        break;
                    }
                    case 2: {
                        this.stage_origin.x += (float)(this.grid_bounds[1] + 1);
                        this.stage_origin.y += (float)this.grid_bounds[0];
                        break;
                    }
                    case 3: {
                        this.stage_origin.x += (float)this.grid_bounds[3];
                        this.stage_origin.y = grid_surface_centre.y + origin_offset_pixels_stage.y;
                        break;
                    }
                    case 4: {
                        this.stage_origin.x = grid_surface_centre.x + origin_offset_pixels_stage.x;
                        this.stage_origin.y = grid_surface_centre.y + origin_offset_pixels_stage.y;
                        break;
                    }
                    case 5: {
                        this.grid_bounds[1] = 1;
                        this.stage_origin.x += (float)1;
                        this.stage_origin.y = grid_surface_centre.y + origin_offset_pixels_stage.y;
                        break;
                    }
                    case 6: {
                        this.stage_origin.x += (float)this.grid_bounds[3];
                        this.stage_origin.y += (float)(this.grid_bounds[2] + 1);
                        break;
                    }
                    case 7: {
                        this.stage_origin.x = grid_surface_centre.x + origin_offset_pixels_stage.x;
                        this.stage_origin.y += (float)(this.grid_bounds[2] + 1);
                        break;
                    }
                    case 8: {
                        this.stage_origin.x += (float)(this.grid_bounds[1] + 1);
                        this.stage_origin.y += (float)(this.grid_bounds[2] + 1);
                    }
                }
                this.drawing_origin.x = this.stage_origin.x - (float)Display_Builder_4.this.grid_cell_count_from_dimension(Float.valueOf(this.stage_origin.x - (float)this.grid_bounds[3]), Float.valueOf(grid_cell_size_stage.x)) * grid_cell_size_stage.x;
                this.drawing_origin.y = this.stage_origin.y - (float)Display_Builder_4.this.grid_cell_count_from_dimension(Float.valueOf(this.stage_origin.y - (float)this.grid_bounds[0]), Float.valueOf(grid_cell_size_stage.y)) * grid_cell_size_stage.y;
                this.grid_cell_count[0] = Display_Builder_4.ceil((float)((Display_Builder_4.max((float)this.grid_bounds[1], (float)this.stage_origin.x) - this.drawing_origin.x) / grid_cell_size_stage.x));
                this.grid_cell_count[1] = Display_Builder_4.ceil((float)((Display_Builder_4.max((float)this.grid_bounds[2], (float)this.stage_origin.y) - this.drawing_origin.y) / grid_cell_size_stage.y));
            }
        }

        public void grid_scale_calculate() {
            this.grid_cell_size_screen.x = Display_Builder_4.this.stage_to_screen(Display_Builder_4.this.physical_to_pixels(this.grid_cell_size.x));
            this.grid_cell_size_screen.y = Display_Builder_4.this.stage_to_screen(Display_Builder_4.this.physical_to_pixels(this.grid_cell_size.y));
        }

        public void grid_draw() {
            if (this.visible.booleanValue()) {
                int screen_max_x = Display_Builder_4.round((float)((float)this.grid_cell_count[0] * this.grid_cell_size_screen.x));
                int screen_max_y = Display_Builder_4.round((float)((float)this.grid_cell_count[1] * this.grid_cell_size_screen.y));
                float grid_line_x_screen = 0.0f;
                float grid_line_y_screen = 0.0f;
                int grid_line_count = 0;
                int marker_interval = 5;
                Display_Builder_4.this.stroke(Display_Builder_4.this.ui.colour_get_by_name("grid_line_physical"), this.grid_alpha);
                Display_Builder_4.this.pushMatrix();
                Display_Builder_4.this.translate(Display_Builder_4.this.ui.viewport.x, Display_Builder_4.this.ui.viewport.y);
                Display_Builder_4.this.translate(Display_Builder_4.this.stage_to_screen(this.drawing_origin.x), Display_Builder_4.this.stage_to_screen(this.drawing_origin.y));
                grid_line_count = 0;
                while (grid_line_count <= this.grid_cell_count[0]) {
                    grid_line_x_screen = Display_Builder_4.round((float)((float)grid_line_count * this.grid_cell_size_screen.x));
                    Display_Builder_4.this.line(grid_line_x_screen, 0.0f, grid_line_x_screen, screen_max_y);
                    if (grid_line_count % marker_interval == 0) {
                        Display_Builder_4.this.line(grid_line_x_screen, 0.0f, grid_line_x_screen, screen_max_y);
                    }
                    ++grid_line_count;
                }
                grid_line_count = 0;
                while (grid_line_count <= this.grid_cell_count[1]) {
                    grid_line_y_screen = Display_Builder_4.round((float)((float)grid_line_count * this.grid_cell_size_screen.y));
                    Display_Builder_4.this.line(0.0f, grid_line_y_screen, screen_max_x, grid_line_y_screen);
                    if (grid_line_count % marker_interval == 0) {
                        Display_Builder_4.this.line(0.0f, grid_line_y_screen, screen_max_x, grid_line_y_screen);
                    }
                    ++grid_line_count;
                }
                Display_Builder_4.this.popMatrix();
                Display_Builder_4.this.pushMatrix();
                Display_Builder_4.this.translate(Display_Builder_4.this.ui.viewport.x, Display_Builder_4.this.ui.viewport.y);
                Display_Builder_4.this.translate(Display_Builder_4.this.stage_to_screen(this.stage_origin.x), Display_Builder_4.this.stage_to_screen(this.stage_origin.y));
                float marker_length = 12.5f;
                Display_Builder_4.this.line(0.0f, marker_length * -1.0f, 0.0f, marker_length);
                Display_Builder_4.this.line(marker_length * -1.0f, 0.0f, marker_length, 0.0f);
                Display_Builder_4.this.ellipseMode(3);
                Display_Builder_4.this.noFill();
                Display_Builder_4.this.ellipse(0.0f, 0.0f, marker_length, marker_length);
                Display_Builder_4.this.popMatrix();
            }
        }

        public void grid_render(PGraphics grid_image, PVector image_dimensions, Float image_scale) {
            if (this.visible.booleanValue()) {
                int[] project_projection_bounds = Display_Builder_4.this.project.surface_bounds_get("project");
                PVector drawing_offset = new PVector((float)project_projection_bounds[3], (float)project_projection_bounds[0]);
                PVector drawing_position = new PVector(0.0f, 0.0f);
                PVector drawing_origin_image = PVector.sub((PVector)this.drawing_origin, (PVector)drawing_offset);
                float grid_cell_pixel_size = Display_Builder_4.this.project.viewport_physical_scale * image_scale.floatValue();
                float circle_width = Display_Builder_4.min((float)50.0f, (float)grid_cell_pixel_size);
                int grid_line_count = 0;
                int grid_count_offset = 0;
                int grid_line_number = 0;
                int marker_interval = 5;
                grid_image.stroke(Display_Builder_4.this.project.grid_colour_get("fg"));
                grid_line_count = 0;
                grid_count_offset = Display_Builder_4.round((float)((this.drawing_origin.x - this.stage_origin.x) / grid_cell_pixel_size));
                while (grid_line_count <= this.grid_cell_count[0]) {
                    drawing_position.x = drawing_origin_image.x + (float)Display_Builder_4.round((float)((float)grid_line_count * grid_cell_pixel_size));
                    grid_line_number = grid_line_count + grid_count_offset;
                    grid_image.line(drawing_position.x, 0.0f, drawing_position.x, image_dimensions.y);
                    if (grid_line_number % marker_interval == 0) {
                        grid_image.line(drawing_position.x, 0.0f, drawing_position.x, image_dimensions.y);
                    }
                    ++grid_line_count;
                }
                grid_line_count = 0;
                grid_count_offset = Display_Builder_4.round((float)((this.drawing_origin.y - this.stage_origin.y) / grid_cell_pixel_size));
                while (grid_line_count <= this.grid_cell_count[1]) {
                    drawing_position.y = drawing_origin_image.y + (float)Display_Builder_4.round((float)((float)grid_line_count * grid_cell_pixel_size));
                    grid_line_number = grid_line_count + grid_count_offset;
                    grid_image.line(0.0f, drawing_position.y, image_dimensions.x, drawing_position.y);
                    if (grid_line_number % marker_interval == 0) {
                        grid_image.line(0.0f, drawing_position.y, image_dimensions.x, drawing_position.y);
                    }
                    ++grid_line_count;
                }
                drawing_origin_image = PVector.sub((PVector)this.stage_origin, (PVector)drawing_offset);
                grid_image.ellipseMode(3);
                grid_image.stroke(255.0f, 255.0f, 255.0f);
                grid_image.ellipse(drawing_origin_image.x, drawing_origin_image.y, circle_width * 2.0f, circle_width * 2.0f);
                grid_image.ellipse(drawing_origin_image.x, drawing_origin_image.y, circle_width * 4.0f, circle_width * 4.0f);
            }
        }

        public void grid_size_set(String input_name, int new_value) {
            if (input_name.equals("textfield_grid_h_px")) {
                this.grid_cell_size.x = new_value;
            }
            if (input_name.equals("textfield_grid_v_px")) {
                this.grid_cell_size.y = new_value;
            }
            this.grid_scale_calculate();
        }

        public PVector origins_offset_get() {
            return this.origin_offset;
        }

        public void origin_offset_set(String input_dimension, float new_value) {
            if (input_dimension.equals("x")) {
                this.origin_offset.x = new_value;
            }
            if (input_dimension.equals("y")) {
                this.origin_offset.y = new_value;
            }
            this.grid_data_calculate();
        }

        public PVector origins_stage_get() {
            return this.stage_origin;
        }

        public Boolean visibility_get() {
            return this.visible;
        }

        public void visibility_set(Boolean new_status) {
            if (Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                this.visible = new_status;
                this.grid_scale_calculate();
            } else {
                this.visible = false;
            }
            Display_Builder_4.this.debug_output("Grid " + this.id + " " + this.name + " set_visibility to: " + this.visible);
        }
    }

    public class Guide {
        int id;
        int type;
        final int GUIDE_IMAGE = 0;
        final int GUIDE_LINE = 1;
        final int GUIDE_MEASUREMENT = 2;
        Boolean locked = false;
        String name = "";
        float opacity = 50.0f;
        int parent_id = -1;
        int parent_alignment_id = 4;
        PVector parent_position = new PVector(0.0f, 0.0f);
        PVector position = new PVector(0.0f, 0.0f);
        PVector position_last = new PVector(0.0f, 0.0f);
        float rotation = 0.0f;
        float rotation_last = 0.0f;
        float scale;
        float scale_last;
        int transform_save_id;
        Boolean visible = true;

        Guide() {
        }

        public Boolean allow_move() {
            return true;
        }

        public Boolean allow_rotation() {
            return true;
        }

        public Boolean allow_scale() {
            return true;
        }

        public void apply_move(PVector transform_delta) {
            if (this.allow_move().booleanValue()) {
                PVector transform_screen = new PVector(Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)transform_delta.x)), Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)transform_delta.y)));
                this.position = PVector.add((PVector)this.position_last, (PVector)transform_screen);
                Display_Builder_4.this.ui_elements.update_guide_controls_position();
            }
        }

        public void apply_rotation(float transform_angle) {
            if (this.allow_rotation().booleanValue()) {
                this.rotation = this.rotation_last + transform_angle;
                Display_Builder_4.this.ui_elements.update_guide_controls_rotation();
            }
        }

        public void apply_scale(PVector transform_scale) {
            if (this.allow_scale().booleanValue()) {
                this.scale = this.scale_last * transform_scale.x;
                Display_Builder_4.this.ui_elements.update_guide_controls_scale();
            }
        }

        public void cleanup() {
            this.parent_id_set(-1);
        }

        public int colour_get() {
            return Display_Builder_4.this.ui.colour_get_by_name("guide_line_default");
        }

        public void colour_set(int new_colour) {
        }

        public void draw_guide(String guide_type) {
        }

        public XML generate_project_xml(XML xml_project_guides) {
            XML xml_guide = xml_project_guides.addChild("guide");
            xml_guide.setInt("id", this.id);
            xml_guide.setInt("type_id", this.type);
            XML xml_guide_data = xml_guide.addChild("guide_properties");
            xml_guide_data.setString("locked", Display_Builder_4.this.boolean_to_string(this.locked));
            xml_guide_data.setString("name", this.name);
            xml_guide_data.setFloat("opacity", this.opacity);
            xml_guide_data.setFloat("position_x", this.position.x);
            xml_guide_data.setFloat("position_y", this.position.y);
            xml_guide_data.setFloat("rotation", Display_Builder_4.degrees((float)this.rotation));
            xml_guide_data.setFloat("scale", this.scale * 100.0f);
            xml_guide_data.setString("visible", Display_Builder_4.this.boolean_to_string(this.visible));
            xml_guide_data.setInt("parent_id", this.parent_id);
            xml_guide_data.setInt("parent_alignment_id", this.parent_alignment_id);
            int[] rgba_color_values = new int[4];
            switch (this.type) {
                case 0: {
                    xml_guide_data = xml_guide.addChild("image_properties");
                    xml_guide_data.setString("image_filename", this.filename_get());
                    xml_guide_data.setString("image_filepath", this.filepath_get());
                    break;
                }
                case 1: {
                    xml_guide_data = xml_guide.addChild("line_properties");
                    xml_guide_data.setInt("orientation", this.orientation_get());
                    rgba_color_values = Display_Builder_4.this.get_color_rgb_values(this.colour_get());
                    xml_guide_data.setInt("r", rgba_color_values[0]);
                    xml_guide_data.setInt("g", rgba_color_values[1]);
                    xml_guide_data.setInt("b", rgba_color_values[2]);
                    xml_guide_data.setInt("a", rgba_color_values[3]);
                    break;
                }
                case 2: {
                    xml_guide_data = xml_guide.addChild("measurement_properties");
                    xml_guide_data.setFloat("position_2_x", this.position_last.x);
                    xml_guide_data.setFloat("position_2_y", this.position_last.y);
                    rgba_color_values = Display_Builder_4.this.get_color_rgb_values(this.colour_get());
                    xml_guide_data.setInt("r", rgba_color_values[0]);
                    xml_guide_data.setInt("g", rgba_color_values[1]);
                    xml_guide_data.setInt("b", rgba_color_values[2]);
                    xml_guide_data.setInt("a", rgba_color_values[3]);
                }
            }
            return xml_project_guides;
        }

        public int[] dimensions_get() {
            int[] dimensions = new int[2];
            return dimensions;
        }

        public String filename_get() {
            return "";
        }

        public String filepath_get() {
            return "";
        }

        public PVector get_position() {
            return this.position;
        }

        public PVector get_relative_position() {
            PVector position_relative = PVector.sub((PVector)this.position, (PVector)this.parent_position);
            return position_relative;
        }

        public Float get_rotation() {
            return Float.valueOf(Display_Builder_4.degrees((float)this.rotation));
        }

        public String get_rotation_text() {
            return Display_Builder_4.nf((float)(Display_Builder_4.degrees((float)this.rotation) + 90.0f), (int)1, (int)3);
        }

        public String get_text() {
            return "";
        }

        public String get_text_info() {
            return "";
        }

        public int get_type() {
            return this.type;
        }

        public void id_update(int id_new) {
            if (this.parent_id >= 0) {
                DisplayGroup parent_displaygroup = Display_Builder_4.this.project.displaygroup_get_by_id(this.parent_id);
                parent_displaygroup.child_guide_id_update(this.id, id_new);
            }
            this.id = id_new;
        }

        public Boolean is_image() {
            return false;
        }

        public Boolean is_line() {
            return false;
        }

        public Boolean is_locked() {
            return this.locked;
        }

        public String name_get() {
            if (this.name.equals("")) {
                this.name = this.get_text_info();
            }
            return this.name;
        }

        public void name_set(String new_name) {
            this.name = Display_Builder_4.trim((String)new_name);
        }

        public int orientation_get() {
            return 0;
        }

        public void orientation_set(int orient_id) {
        }

        public void parent_id_set(int new_parent_id) {
            if (new_parent_id != this.parent_id) {
                Display_Builder_4.this.debug_output("Guide " + this.id + " parent_id_set to: " + new_parent_id + " from " + this.parent_id);
                DisplayGroup parent_displaygroup = Display_Builder_4.this.project.displaygroup_get_by_id(this.parent_id);
                if (parent_displaygroup != null) {
                    parent_displaygroup.child_guide_id_remove(this.id);
                }
                if (new_parent_id >= 0) {
                    parent_displaygroup = Display_Builder_4.this.project.displaygroup_get_by_id(new_parent_id);
                    if (parent_displaygroup != null) {
                        this.parent_id = new_parent_id;
                        this.parent_position = parent_displaygroup.alignment_point_calculate(0).copy();
                        Display_Builder_4.this.debug_output("Guide " + this.id + " Parent position set to: " + Display_Builder_4.round((float)this.parent_position.x) + "," + Display_Builder_4.round((float)this.parent_position.y));
                        parent_displaygroup.child_guide_id_add(this.id);
                    } else {
                        Display_Builder_4.this.debug_output("Guide failed to set parent DisplayGroup - Reverting to Stage.");
                        this.parent_id = -1;
                    }
                } else {
                    this.parent_id = new_parent_id;
                }
                if (this.parent_id < 0) {
                    Display_Builder_4.this.debug_output("Guide " + this.id + " resetting Parent position.");
                    this.parent_position.x = 0.0f;
                    this.parent_position.y = 0.0f;
                }
                Display_Builder_4.this.debug_output("Guide " + this.id + " parent_id now: " + this.parent_id);
            }
            Display_Builder_4.this.ui_elements.update_guide_controls_position();
        }

        public void parent_position_set(PVector new_parent_position) {
            if (this.parent_id >= 0) {
                PVector parent_position_offset = PVector.sub((PVector)new_parent_position, (PVector)this.parent_position);
                this.parent_position = new_parent_position.copy();
                this.position.add(parent_position_offset);
                Display_Builder_4.this.debug_output("Guide " + this.id + " position updated to: " + Display_Builder_4.round((float)this.position.x) + "," + Display_Builder_4.round((float)this.position.y));
                Display_Builder_4.this.ui_elements.update_guide_controls_position();
            }
        }

        public void position_set(PVector new_position) {
            this.position = new_position.copy();
            Display_Builder_4.this.ui_elements.update_guide_controls_position();
        }

        public void position_set_from_ui(String input_dimension, int pixel_value) {
            PVector position_new = this.position.copy();
            if (input_dimension.equals("x")) {
                position_new.x = pixel_value;
                if (this.type == 1) {
                    this.orientation_set(0);
                }
            }
            if (input_dimension.equals("y")) {
                position_new.y = pixel_value;
                if (this.type == 1) {
                    this.orientation_set(1);
                }
            }
            this.position = PVector.add((PVector)this.parent_position, (PVector)position_new);
            Display_Builder_4.this.ui_elements.update_guide_controls_position();
        }

        public void opacity_set(float opacity_val) {
            this.opacity = opacity_val;
        }

        public void rotation_set(float rotation_val) {
            this.rotation = rotation_val;
            Display_Builder_4.this.ui_elements.update_guide_controls_rotation();
        }

        public void scale_set(float scale_val) {
            this.scale = scale_val / 100.0f;
        }

        public void toggle_lock() {
            this.locked = this.locked == false;
            Display_Builder_4.this.ui_elements.update_guide_controls();
        }

        public void toggle_visible() {
            this.visible = this.visible == false;
        }

        public void transform_restore(Transform transform_object) {
            Display_Builder_4.this.debug_output("Guide " + this.id + " restoring from Transform: " + transform_object.id);
            this.position = transform_object.position;
            this.rotation = transform_object.rotation;
            this.scale = transform_object.scale.x;
        }

        public void transform_save(Transform transform_object) {
            this.transform_save_id = transform_object.id;
            transform_object.position = this.position;
            transform_object.stagesize = new PVector(this.scale, this.scale);
            transform_object.rotation = this.rotation;
            this.position_last = this.position;
            this.rotation_last = this.rotation;
            this.scale_last = this.scale;
        }
    }

    public class GuideImage
    extends Guide {
        String image_filename;
        String image_filepath;
        PImage image;

        GuideImage(int new_id, File new_image_file) {
            this.id = new_id;
            this.type = 0;
            this.image_filename = new_image_file.getName();
            this.image_filepath = new_image_file.getAbsolutePath();
            this.image = Display_Builder_4.this.loadImage(this.image_filepath);
            this.scale = 1.0f;
            this.visible = true;
            this.locked = false;
            Display_Builder_4.this.debug_output("Added GuideImage " + this.id + ": " + this.image_filename);
        }

        @Override
        public Boolean allow_move() {
            return this.locked == false;
        }

        @Override
        public Boolean allow_rotation() {
            return this.locked == false;
        }

        @Override
        public Boolean allow_scale() {
            return this.locked == false;
        }

        @Override
        public void draw_guide(String guide_type) {
            if (guide_type.equals("image") && Display_Builder_4.this.project.pref_ui_view_guideimages.booleanValue() && this.image != null && this.visible.booleanValue() && this.opacity > 0.0f && this.scale > 0.0f) {
                float image_width = this.image.width;
                float image_height = this.image.height;
                float background_image_origin_x = Display_Builder_4.this.stage_to_screen(this.position.x);
                float background_image_origin_y = Display_Builder_4.this.stage_to_screen(this.position.y);
                Display_Builder_4.this.tint(255, Display_Builder_4.map((float)this.opacity, (float)0.0f, (float)100.0f, (float)0.0f, (float)255.0f));
                Display_Builder_4.this.pushMatrix();
                Display_Builder_4.this.translate(background_image_origin_x + Display_Builder_4.this.ui.viewport.x, background_image_origin_y + Display_Builder_4.this.ui.viewport.y);
                Display_Builder_4.this.scale(Display_Builder_4.this.ui.viewport_scale / 100.0f * this.scale);
                Display_Builder_4.this.rotate(this.rotation);
                Display_Builder_4.this.image(this.image, image_width * -0.5f, image_height * -0.5f, image_width, image_height);
                Display_Builder_4.this.popMatrix();
                Display_Builder_4.this.noTint();
            }
        }

        @Override
        public String filename_get() {
            return this.image_filename;
        }

        @Override
        public String filepath_get() {
            return this.image_filepath;
        }

        public int[] get_dimensions() {
            int[] dimensions = new int[2];
            if (this.image != null) {
                dimensions[0] = this.image.width;
                dimensions[1] = this.image.height;
            }
            return dimensions;
        }

        @Override
        public String get_text() {
            return this.image_filename;
        }

        @Override
        public String get_text_info() {
            String text_info = "Image size: " + this.image.width + "x" + this.image.height + "px";
            return text_info;
        }

        @Override
        public Boolean is_image() {
            return true;
        }
    }

    public class GuideLine
    extends Guide {
        int orientation;
        int colour;

        GuideLine(int new_id) {
            this.id = new_id;
            this.type = 1;
            this.orientation = 0;
            this.opacity = 100.0f;
            this.rotation = 0.0f;
            this.rotation_last = 0.0f;
            this.visible = true;
            this.locked = false;
            this.colour = Display_Builder_4.this.ui.colour_get_by_name("guide_line_default");
            Display_Builder_4.this.debug_output("Added GuideLine " + this.id);
        }

        @Override
        public Boolean allow_move() {
            return this.locked == false;
        }

        @Override
        public Boolean allow_rotation() {
            return false;
        }

        @Override
        public Boolean allow_scale() {
            return false;
        }

        @Override
        public int colour_get() {
            return this.colour;
        }

        @Override
        public void colour_set(int new_colour) {
            this.colour = new_colour;
        }

        @Override
        public void draw_guide(String guide_type) {
            if (guide_type.equals("line") && Display_Builder_4.this.project.pref_ui_view_guidelines.booleanValue() && this.visible.booleanValue() && this.opacity > 0.0f) {
                PVector line_origin = new PVector(Display_Builder_4.this.stage_to_screen(this.position.x) + Display_Builder_4.this.ui.viewport.x, 0.0f);
                PVector line_target = new PVector(0.0f, (float)Display_Builder_4.this.height);
                if (this.orientation == 1) {
                    line_origin.x = 0.0f;
                    line_origin.y = Display_Builder_4.this.stage_to_screen(this.position.y) + Display_Builder_4.this.ui.viewport.y;
                    line_target.x = Display_Builder_4.this.width;
                    line_target.y = 0.0f;
                }
                Display_Builder_4.this.pushMatrix();
                Display_Builder_4.this.translate(line_origin.x, line_origin.y);
                Display_Builder_4.this.pushStyle();
                if (Display_Builder_4.this.project.current_guide.id == this.id) {
                    Display_Builder_4.this.strokeWeight(2.0f);
                }
                Display_Builder_4.this.noFill();
                Display_Builder_4.this.stroke(this.colour, this.opacity);
                Display_Builder_4.this.line(0.0f, 0.0f, line_target.x, line_target.y);
                Display_Builder_4.this.popStyle();
                Display_Builder_4.this.popMatrix();
            }
        }

        @Override
        public String get_text() {
            String[] orientation_axis = new String[]{"x", "y"};
            return "Guide Line " + Display_Builder_4.this.get_number_from_id(this.id) + " (" + orientation_axis[this.orientation] + ")";
        }

        @Override
        public String get_text_info() {
            return this.get_text();
        }

        @Override
        public Boolean is_line() {
            return true;
        }

        @Override
        public int orientation_get() {
            return this.orientation;
        }

        @Override
        public void orientation_set(int orient_id) {
            if (orient_id != this.orientation && (orient_id == 0 || orient_id == 1)) {
                this.orientation = orient_id;
                Display_Builder_4.this.ui_elements.update_guide_menu();
                Display_Builder_4.this.ui_elements.update_guide_controls();
            }
        }
    }

    public class GuideMeasure
    extends Guide {
        Float distance;
        int colour;

        GuideMeasure(int new_id) {
            this.id = new_id;
            this.type = 2;
            this.opacity = 100.0f;
            this.rotation = 0.0f;
            this.rotation_last = 0.0f;
            this.visible = true;
            this.locked = false;
            this.distance = Float.valueOf(0.0f);
            this.colour = Display_Builder_4.this.ui.colour_get_by_name("guide_line_default");
            Display_Builder_4.this.debug_output("Added GuideMeasure " + this.id);
        }

        @Override
        public Boolean allow_move() {
            return false;
        }

        @Override
        public Boolean allow_rotation() {
            return false;
        }

        @Override
        public Boolean allow_scale() {
            return false;
        }

        @Override
        public int colour_get() {
            return this.colour;
        }

        @Override
        public void colour_set(int new_colour) {
            this.colour = new_colour;
        }

        public void distance_set(Float new_distance) {
            this.distance = new_distance;
        }

        @Override
        public void draw_guide(String guide_type) {
            if (guide_type.equals("line") && Display_Builder_4.this.project.pref_ui_view_guidelines.booleanValue() && this.visible.booleanValue() && this.opacity > 0.0f) {
                PVector line_origin = Display_Builder_4.this.stage_to_screen(this.position).copy();
                PVector line_target = Display_Builder_4.this.stage_to_screen(this.position_last).copy();
                float cross_size = Display_Builder_4.this.stage_to_screen(50.0f);
                Display_Builder_4.this.pushMatrix();
                Display_Builder_4.this.translate(Display_Builder_4.this.ui.viewport.x, Display_Builder_4.this.ui.viewport.y);
                Display_Builder_4.this.pushStyle();
                Display_Builder_4.this.noFill();
                Display_Builder_4.this.stroke(this.colour, this.opacity);
                Display_Builder_4.this.strokeWeight(2.0f);
                Display_Builder_4.this.line(line_origin.x, line_origin.y, line_target.x, line_target.y);
                Display_Builder_4.this.line(line_origin.x - cross_size, line_origin.y, line_origin.x + cross_size, line_origin.y);
                Display_Builder_4.this.line(line_origin.x, line_origin.y - cross_size, line_origin.x, line_origin.y + cross_size);
                Display_Builder_4.this.line(line_target.x - cross_size, line_target.y, line_target.x + cross_size, line_target.y);
                Display_Builder_4.this.line(line_target.x, line_target.y - cross_size, line_target.x, line_target.y + cross_size);
                Display_Builder_4.this.popStyle();
                Display_Builder_4.this.popMatrix();
            }
        }

        @Override
        public String get_text() {
            return "Measurement " + Display_Builder_4.this.get_number_from_id(this.id);
        }

        @Override
        public String get_text_info() {
            String text_info = String.valueOf(Display_Builder_4.nf((float)this.distance.floatValue(), (int)0, (int)2)) + "px";
            if (Display_Builder_4.this.project.physical_settings_active.booleanValue()) {
                text_info = String.valueOf(text_info) + " (" + Display_Builder_4.nf((float)Display_Builder_4.this.pixels_to_physical(this.distance.floatValue()), (int)0, (int)2) + "m)";
            }
            text_info = String.valueOf(text_info) + " rotation: " + Display_Builder_4.nf((float)(Display_Builder_4.degrees((float)this.rotation) + 90.0f), (int)0, (int)2) + "\u00b0";
            return text_info;
        }

        public Boolean is_measure() {
            return true;
        }

        @Override
        public void parent_position_set(PVector new_parent_position) {
            if (this.parent_id >= 0) {
                PVector parent_position_offset = PVector.sub((PVector)new_parent_position, (PVector)this.parent_position);
                this.parent_position = new_parent_position.copy();
                this.position.add(parent_position_offset);
                this.position_last.add(parent_position_offset);
                Display_Builder_4.this.debug_output("Guide " + this.id + " position updated to: " + Display_Builder_4.round((float)this.position.x) + "," + Display_Builder_4.round((float)this.position.y));
                Display_Builder_4.this.ui_elements.update_guide_controls_position();
            }
        }
    }

    class ImageFileData {
        int id;
        int id_displaygroup;
        int id_stagetier;
        String filepath;
        String filename;
        String grid_type;
        Boolean render_status;
        float scale;

        ImageFileData() {
        }
    }

    class ImportLayerData {
        int id;
        int type;
        String name;
        float bounds_top;
        float bounds_right;
        float bounds_bottom;
        float bounds_left;

        ImportLayerData() {
        }
    }

    class MixedInputResult {
        Boolean status;
        float value;
        String text;

        MixedInputResult(Boolean new_status, float new_value, String new_text) {
            this.status = new_status;
            this.value = new_value;
            this.text = new_text;
        }
    }

    class Project {
        float default_softedge_fraction = 0.2f;
        int max_array_size = 999;
        Boolean physical_settings_active = false;
        float viewport_physical_scale = 0.0f;
        int[] projection_surface_bounds = new int[4];
        String filepath = "default_project";
        Boolean process_project_file = false;
        IntList group_player_counts;
        final int DISPLAY_2D = 0;
        final int PREVIEW_2D = 1;
        final int LED_PANEL = 2;
        final int DISPLAY_VIRTUAL = 3;
        final int PROJECTOR_3D = 4;
        ArrayList<DisplayResolution> resolutions_list;
        IntDict resolutions_lookup;
        int default_resolution_id = 16;
        int resolutions_preset_count_initial;
        ArrayList<StageTier> stage_tiers;
        StageTier current_stage_tier;
        ArrayList<DisplayGroup> display_groups;
        int current_displaygroup_id = 0;
        int incremental_display_group_id = 0;
        DisplayGroup current_displaygroup;
        Grid physical_grid;
        ArrayList<Guide> guides;
        Guide current_guide;
        float max_stage_size_scale = 3.0f;
        ArrayList<Transform> transform_list;
        Transform current_transform;
        int current_transform_id;
        Boolean project_load_overwrite = true;
        Boolean pref_auto_increment_group_player_ids = true;
        Boolean pref_invert_mouse_wheel_direction = true;
        Boolean pref_image_export_antialiasing = false;
        Boolean pref_dimension_rounding_automatic = false;
        int pref_dimension_rounding_multiple = 2;
        int[] pref_target_surface_bounds = new int[4];
        Boolean pref_ui_scaling = true;
        Boolean pref_ui_view_guideimages = true;
        Boolean pref_ui_view_guidelines = true;
        Boolean pref_ui_view_display_output_ids = false;
        String pref_project_name = "WO displays";
        Boolean pref_resolution_list_order_invert = true;
        Boolean pref_ui_scale_auto = false;
        Boolean pref_ui_show_display_info = true;
        Boolean pref_ui_show_display_info_crop = false;
        Boolean pref_ui_show_mouse_coords_overlay = false;
        Boolean pref_ui_show_overlay_display_spacing = false;
        Boolean pref_ui_show_parent_links = true;
        Boolean pref_ui_show_current_group_only = false;
        int pref_display_colour_mode = 0;
        Boolean pref_ui_toggle_show_layout_grid = true;
        int pref_ui_grid_size_h;
        int pref_ui_grid_size_v;
        Boolean pref_export_display_data = true;
        Boolean pref_export_pixel_grid = true;
        Boolean pref_export_physical_grid = false;
        Boolean pref_export_warping_grid = false;
        Boolean pref_export_colourbars = false;
        Boolean pref_export_psd_jsx = false;
        int pref_export_grid_cell_unit = 1;
        int pref_export_grid_cell_size = 50;
        int pref_export_grid_marker_interval = 1000;
        int pref_export_grid_line_width = 2;
        Boolean pref_export_grid_use_display_colours = true;
        Boolean pref_export_grid_use_grid_colour = false;
        Boolean pref_export_grid_invert_colour = false;
        Boolean pref_export_grid_crosshatch_show = false;
        Boolean pref_export_grid_show_alignment = true;
        Boolean pref_export_grid_show_markers = true;
        Boolean pref_export_show_column_row_numbers = false;
        Boolean pref_export_show_display_id = true;
        Boolean pref_export_show_displaygroup_id = true;
        Boolean pref_export_show_displaygroup_name = false;
        Boolean pref_export_show_info_overlay = false;
        Boolean pref_export_show_display_coordinates = false;
        Boolean pref_export_show_softedge_text = true;
        int pref_projection_surface_mode;
        final int MODE_AUTOMATIC = 0;
        final int MODE_USERSET = 1;

        Project() {
            this.resolutions_lookup = new IntDict();
            this.resolutions_list = new ArrayList();
            this.stage_tiers = new ArrayList();
            this.display_groups = new ArrayList();
            this.transform_list = new ArrayList();
            this.guides = new ArrayList();
            this.group_player_counts = new IntList();
            this.physical_grid = new Grid(1, "physical");
        }

        public DisplayGroup displaygroup_add() {
            ++this.incremental_display_group_id;
            int new_displaygroup_id = this.display_groups.size();
            DisplayGroup new_displaygroup = new DisplayGroup();
            new_displaygroup.id = new_displaygroup_id;
            new_displaygroup.name = "Display Group " + this.incremental_display_group_id;
            Display_Builder_4.this.debug_output("Added new DisplayGroup with id: " + new_displaygroup_id + " resolution.id: " + new_displaygroup.resolution.id);
            this.display_groups.add(new_displaygroup);
            return new_displaygroup;
        }

        public void displaygroup_add_or_copy(int existing_displaygroup_id) {
            DisplayGroup new_displaygroup = this.displaygroup_add();
            if (existing_displaygroup_id > -1) {
                this.displaygroup_select(new_displaygroup.id);
                this.current_displaygroup.group_copy(existing_displaygroup_id, "copy");
            } else {
                this.displaygroup_select(new_displaygroup.id);
                this.current_displaygroup.group_defaults_set();
            }
            this.pref_projection_surface_mode = 0;
            this.summary_text_update();
            Display_Builder_4.this.ui_elements.update_all_controls();
            this.displaygroups_list();
        }

        public int displaygroup_count_get() {
            return this.display_groups.size();
        }

        public Boolean displaygroup_is_unique() {
            if (this.displaygroup_count_get() == 1) {
                return true;
            }
            return false;
        }

        public int[] displaygroup_data_counts_get() {
            int display_count = 0;
            int pixel_count = 0;
            int player_count = 0;
            for (DisplayGroup group : Display_Builder_4.this.project.display_groups) {
                if (!group.group_active.booleanValue()) continue;
                display_count += group.display_count_get();
                pixel_count += group.display_pixel_count_get() * group.display_count_get();
                player_count += group.player_count;
            }
            int[] displaygroup_counts = new int[]{display_count, pixel_count, player_count};
            return displaygroup_counts;
        }

        public StringList displaygroup_data_text_get(int export_stage_tier_id, String comment_prefix) {
            StringList displaygroup_data_text = new StringList();
            for (DisplayGroup group : this.display_groups) {
                if (export_stage_tier_id != group.stagetier_id) continue;
                displaygroup_data_text.append(group.group_data_text_get(comment_prefix));
            }
            return displaygroup_data_text;
        }

        public void displaygroup_current_delete() {
            if (this.display_groups.size() > 1) {
                Display_Builder_4.this.debug_output("Project deleting DisplayGroup: " + this.current_displaygroup_id);
                DisplayGroup target_displaygroup = this.display_groups.get(this.current_displaygroup_id);
                target_displaygroup.group_cleanup();
                this.display_groups.remove(this.current_displaygroup_id);
                this.stage_tier_delete();
                this.displaygroup_ids_update_all();
                this.displaygroup_select(0);
                this.projection_surface_bounds_update();
                this.summary_text_update();
                Display_Builder_4.this.ui_elements.update_all_controls();
                this.displaygroups_list();
            }
        }

        public Boolean displaygroup_current_get() {
            if (this.current_displaygroup_id <= this.display_groups.size()) {
                this.current_displaygroup = this.display_groups.get(this.current_displaygroup_id);
                this.stage_tier_select(this.current_displaygroup.stagetier_id);
                Display_Builder_4.this.debug_output("Project CurrentDisplayGroup now " + this.current_displaygroup_id + " - " + this.current_displaygroup.name);
                return true;
            }
            return false;
        }

        public void displaygroup_current_update() {
            if (this.displaygroup_current_get().booleanValue()) {
                this.current_displaygroup.displays_update();
            } else {
                Display_Builder_4.this.debug_output("Error getting Project displaygroup object.");
            }
            this.summary_text_update();
        }

        public DisplayGroup displaygroup_get_by_id(int group_id) {
            if (this.displaygroup_id_is_valid(group_id).booleanValue()) {
                return this.display_groups.get(group_id);
            }
            return null;
        }

        public Boolean displaygroup_id_is_valid(int group_id) {
            if (group_id >= 0 && group_id < this.display_groups.size()) {
                return true;
            }
            return false;
        }

        public void displaygroup_ids_update_all() {
            int displaygroup_index = 0;
            for (DisplayGroup group : this.display_groups) {
                group.group_id_update(displaygroup_index);
                ++displaygroup_index;
            }
        }

        public void displaygroups_list() {
            int i = 0;
            for (DisplayGroup group : this.display_groups) {
                Display_Builder_4.this.debug_output("Project DisplayGroup index: " + i + ", ID: " + group.id + " - " + group.name);
                ++i;
            }
        }

        public void displaygroup_mouseover_check(int mouse_pos_x, int mouse_pos_y, String action) {
            if (!Display_Builder_4.this.ui.mouse_within_ui_pane()) {
                int displaygoups_max_id;
                Boolean hit_detected_group = false;
                int i = displaygoups_max_id = this.display_groups.size() - 1;
                while (i >= 0) {
                    DisplayGroup group = this.display_groups.get(i);
                    if (!hit_detected_group.booleanValue() && (hit_detected_group = group.mouse_within_displaygroup(mouse_pos_x, mouse_pos_y, action)).booleanValue()) {
                        if (action.equals("click")) {
                            if (group.id != this.current_displaygroup.id && !this.pref_ui_show_current_group_only.booleanValue()) {
                                this.displaygroup_select(group.id);
                            }
                        } else {
                            hit_detected_group = false;
                        }
                    }
                    --i;
                }
            }
        }

        public void displaygroup_name_set(int group_id, String group_name) {
            DisplayGroup target_displaygroup = this.display_groups.get(group_id);
            target_displaygroup.group_name_set(group_name);
        }

        public String[] displaygroup_names_get() {
            String[] displaygroup_names = new String[this.display_groups.size()];
            int displaygroup_index = 0;
            for (DisplayGroup group : this.display_groups) {
                displaygroup_names[displaygroup_index] = group.name;
                ++displaygroup_index;
            }
            return displaygroup_names;
        }

        public void displaygroup_origin_alignment_id_set(float new_value) {
            if (this.current_displaygroup != null) {
                this.current_displaygroup.anchor_alignment_id_set(new_value);
            }
        }

        public void displaygroup_outputs_allocate(int displaygroup_request_id) {
            int[][] displaygroup_output_data = new int[this.display_groups.size()][3];
            int allocate_current_displaygroup_id = 0;
            int allocate_current_player_num = 1;
            int allocate_current_output_num = 1;
            for (DisplayGroup group : this.display_groups) {
                displaygroup_output_data[group.id][0] = group.player_outputs_count * group.player_count;
                displaygroup_output_data[group.id][1] = group.player_count;
                displaygroup_output_data[group.id][2] = group.player_outputs_sharing != false ? displaygroup_output_data[group.id][0] - group.display_count_get() : 0;
                if (group.id != 0 || displaygroup_output_data[group.id][2] <= 0) continue;
                allocate_current_player_num = group.player_start_number + (group.player_count - 1);
                allocate_current_output_num = group.display_count_get() % group.player_outputs_count;
            }
            for (DisplayGroup group : this.display_groups) {
                if (group.id == 0) {
                    if (!group.player_output_one_reserved.booleanValue()) continue;
                    group.player_outputs_start_number_set(2);
                    continue;
                }
                if (group.player_outputs_sharing.booleanValue() && displaygroup_output_data[allocate_current_displaygroup_id][2] > 0) {
                    Display_Builder_4.this.debug_output("DisplayGroup " + group.id + " Allocating to Group: " + allocate_current_displaygroup_id + ", Player: " + allocate_current_player_num + ", Output: " + allocate_current_output_num + " (Shared)");
                    group.player_start_number = allocate_current_player_num;
                    if (group.display_type == 1 && group.parent_displaygroup.player_output_one_reserved.booleanValue()) {
                        group.player_outputs_start_number_set(1);
                    } else {
                        group.player_outputs_start_number_set(allocate_current_output_num + 1);
                    }
                    int group_displays_remaining = group.display_count_get() - Display_Builder_4.min((int)group.display_count_get(), (int)displaygroup_output_data[allocate_current_displaygroup_id][2]);
                    group.player_outputs_shared_count = group.display_count_get() - group_displays_remaining;
                    displaygroup_output_data[group.id][1] = Display_Builder_4.ceil((float)((float)group_displays_remaining / PApplet.parseFloat((int)group.player_outputs_count)));
                    displaygroup_output_data[group.id][2] = group.player_outputs_count * displaygroup_output_data[group.id][1] - group_displays_remaining;
                    allocate_current_output_num += group.player_outputs_shared_count;
                    int[] nArray = displaygroup_output_data[allocate_current_displaygroup_id];
                    nArray[2] = nArray[2] - group.display_count_get();
                    if (displaygroup_output_data[allocate_current_displaygroup_id][2] >= 0) continue;
                    ++allocate_current_displaygroup_id;
                    allocate_current_player_num += displaygroup_output_data[group.id][1];
                    allocate_current_output_num = group_displays_remaining;
                    continue;
                }
                allocate_current_player_num = displaygroup_output_data[allocate_current_displaygroup_id][1] + 1;
                allocate_current_displaygroup_id = group.id;
                allocate_current_output_num = 1;
                group.player_outputs_shared_count = 0;
                group.player_start_number = allocate_current_player_num;
                group.player_outputs_start_number_set(allocate_current_output_num);
            }
        }

        public void displaygroup_parent_alignment_id_set(float new_value) {
            if (this.current_displaygroup != null) {
                this.current_displaygroup.parent_alignment_id_set(new_value);
            }
        }

        public void displaygroup_parent_id_set(float ui_value) {
            int new_value = Display_Builder_4.round((float)ui_value);
            Display_Builder_4.this.debug_output("project set_displaygroup_parent_id to " + new_value);
            if (Display_Builder_4.this.ui.tab_is_current("group_guides").booleanValue()) {
                if (this.current_guide != null) {
                    this.current_guide.parent_id_set(new_value);
                }
            } else if (this.current_displaygroup != null) {
                this.current_displaygroup.parent_id_set(new_value);
            }
        }

        public void displaygroup_select(int new_displaygroup_id) {
            Display_Builder_4.this.debug_output("Project select_displaygroup set to: " + new_displaygroup_id + " from: " + this.current_displaygroup_id);
            if (this.displaygroup_id_is_valid(new_displaygroup_id).booleanValue()) {
                this.current_displaygroup_id = new_displaygroup_id;
                if (this.displaygroup_current_get().booleanValue()) {
                    UI uI = Display_Builder_4.this.ui;
                    Display_Builder_4.this.ui.getClass();
                    uI.transform_target_type_set(0);
                    Display_Builder_4.this.debug_output("Selected new DisplayGroup: " + this.current_displaygroup_id + " - " + this.current_displaygroup.name);
                    if (this.current_displaygroup.name != null && this.current_displaygroup.group_active.booleanValue()) {
                        Display_Builder_4.this.ui_elements.update_all_controls();
                    }
                }
            }
        }

        public void displaygroup_update_by_id(int group_id) {
            if (this.displaygroup_id_is_valid(group_id).booleanValue()) {
                DisplayGroup selected_displaygroup = this.display_groups.get(group_id);
                int n = selected_displaygroup.display_type;
                Display_Builder_4.this.project.getClass();
                if (n == 1) {
                    selected_displaygroup.preview_display_scale_to_parent();
                } else {
                    selected_displaygroup.anchor_point_calculate();
                    selected_displaygroup.displays_update();
                }
            } else {
                Display_Builder_4.this.debug_output("Error getting Project displaygroup object with id:" + group_id);
            }
        }

        public void displaygroups_remove_all() {
            Display_Builder_4.this.debug_output("Project removing all DisplayGroups.");
            for (DisplayGroup group : this.display_groups) {
                group.group_cleanup();
            }
            this.display_groups.clear();
            this.incremental_display_group_id = 0;
        }

        public void displays_draw_all() {
            if (Display_Builder_4.this.ui.active.booleanValue()) {
                for (DisplayGroup group : this.display_groups) {
                    if (this.pref_ui_show_current_group_only.booleanValue() && (!this.pref_ui_show_current_group_only.booleanValue() || group.id != this.current_displaygroup.id)) continue;
                    group.group_surface_draw();
                    group.displays_draw_all();
                }
            }
        }

        public void export_lineup_grid_cell_size_set(String ui_text) {
            float ui_text_result = Display_Builder_4.this.parse_math_string_expression(ui_text);
            Display_Builder_4.this.project.pref_export_grid_cell_size = ui_text_result > 0.0f ? Display_Builder_4.round((float)ui_text_result) : Integer.parseInt(ui_text);
            Display_Builder_4.this.ui_elements.update_export_alignment_grid_controls();
        }

        public void export_grid_marker_interval_set(String ui_text) {
            float ui_text_result = Display_Builder_4.this.parse_math_string_expression(ui_text);
            Display_Builder_4.this.project.pref_export_grid_marker_interval = ui_text_result > 0.0f ? Display_Builder_4.round((float)ui_text_result) : Integer.parseInt(ui_text);
            Display_Builder_4.this.ui_elements.update_export_alignment_grid_controls();
        }

        public void export_lineup_grid_line_width_set(String ui_text) {
            float ui_text_result = Display_Builder_4.this.parse_math_string_expression(ui_text);
            Display_Builder_4.this.project.pref_export_grid_line_width = ui_text_result > 0.0f ? Display_Builder_4.round((float)ui_text_result) : Integer.parseInt(ui_text);
            Display_Builder_4.this.ui_elements.update_export_alignment_grid_controls();
        }

        public void export_lineup_grid_fit_squares() {
            PVector displaygroup_dimensions = this.current_displaygroup.projection_surface_dimensions_get();
            this.pref_export_grid_cell_size = Display_Builder_4.this.highest_common_factor(Display_Builder_4.round((float)displaygroup_dimensions.x), Display_Builder_4.round((float)displaygroup_dimensions.y));
            float current_marker_interval = 20.0f;
            switch (this.pref_export_grid_cell_unit) {
                case 1: {
                    current_marker_interval = this.pref_export_grid_marker_interval / this.pref_export_grid_cell_size;
                    break;
                }
                case 2: {
                    current_marker_interval = this.pref_export_grid_marker_interval;
                }
            }
            this.pref_export_grid_marker_interval = Display_Builder_4.round((float)(current_marker_interval * (float)this.pref_export_grid_cell_size));
            this.pref_export_grid_cell_unit = 1;
            Display_Builder_4.this.ui_elements.update_export_alignment_grid_controls();
            String ui_message = "Alignment grid cell size set to " + this.pref_export_grid_cell_size + " pixels";
            ui_message = String.valueOf(ui_message) + " (" + displaygroup_dimensions.x / (float)this.pref_export_grid_cell_size + " by " + displaygroup_dimensions.y / (float)this.pref_export_grid_cell_size + " grid cells).";
            UI uI = Display_Builder_4.this.ui;
            Display_Builder_4.this.ui.getClass();
            uI.osd_message_display(ui_message, 0);
        }

        public void export_lineup_grid_unit_change(int menu_id) {
            Display_Builder_4.this.debug_output("Project export_lineup_grid_unit_change from " + this.pref_export_grid_cell_unit + " to " + menu_id);
            if (menu_id != this.pref_export_grid_cell_unit) {
                PVector displaygroup_dimensions = this.current_displaygroup.projection_surface_dimensions_get();
                int current_export_grid_cell_size = this.pref_export_grid_cell_size;
                int current_export_grid_marker_interval = this.pref_export_grid_marker_interval;
                switch (this.pref_export_grid_cell_unit) {
                    case 1: {
                        this.pref_export_grid_cell_size = Display_Builder_4.round((float)(displaygroup_dimensions.x / (float)current_export_grid_cell_size));
                        this.pref_export_grid_marker_interval = current_export_grid_marker_interval / this.pref_export_grid_cell_size;
                        break;
                    }
                    case 2: {
                        this.pref_export_grid_cell_size = Display_Builder_4.round((float)(displaygroup_dimensions.x / (float)current_export_grid_cell_size));
                        this.pref_export_grid_marker_interval = current_export_grid_marker_interval * this.pref_export_grid_cell_size;
                    }
                }
                this.pref_export_grid_cell_unit = menu_id;
                Display_Builder_4.this.ui_elements.update_export_alignment_grid_controls();
            }
        }

        public String filepath_get() {
            return this.filepath;
        }

        public void filepath_set(String absolute_filepath) {
            if (!absolute_filepath.equals("")) {
                this.filepath = absolute_filepath;
                Display_Builder_4.this.ui_elements.update_project_filepath();
            }
        }

        public int grid_colour_get(String colour_name) {
            if (!this.pref_export_grid_invert_colour.booleanValue()) {
                if (colour_name.equals("bg")) {
                    return Display_Builder_4.this.color(0, 0, 0, 255);
                }
                if (colour_name.equals("fg")) {
                    return Display_Builder_4.this.color(255, 255, 255, 150);
                }
                if (colour_name.equals("mid")) {
                    return Display_Builder_4.this.color(255, 255, 255, 180);
                }
            } else {
                if (colour_name.equals("bg")) {
                    return Display_Builder_4.this.color(255, 255, 255, 255);
                }
                if (colour_name.equals("fg")) {
                    return Display_Builder_4.this.color(0, 0, 0, 0);
                }
                if (colour_name.equals("mid")) {
                    return Display_Builder_4.this.color(128, 128, 128, 180);
                }
            }
            return Display_Builder_4.this.color(0, 0, 0);
        }

        public void grid_dimensions_ui_update(String input_dimension, String ui_text) {
            int ui_text_value = Display_Builder_4.round((float)Display_Builder_4.this.parse_math_string_expression(ui_text));
            if (ui_text_value > 0) {
                if (input_dimension == "x") {
                    Display_Builder_4.this.project.pref_ui_grid_size_h = ui_text_value;
                }
                Display_Builder_4.this.project.pref_ui_grid_size_v = ui_text_value;
                Display_Builder_4.this.redraw_screen();
            }
            Display_Builder_4.this.ui_elements.grid_pixel_dimensions_update();
        }

        public int guideimage_add(File guide_image_filepath_input) {
            Display_Builder_4.this.ui.set_active(false);
            int new_guideimage_id = this.guides.size();
            GuideImage new_guideimage = new GuideImage(new_guideimage_id, guide_image_filepath_input);
            new_guideimage.id = new_guideimage_id;
            this.guides.add(new_guideimage);
            this.guide_select(new_guideimage_id);
            this.guides_update_ids();
            Display_Builder_4.this.ui.set_active(true);
            Display_Builder_4.this.ui_elements.update_guide_menu();
            return new_guideimage_id;
        }

        public int guideline_add() {
            Display_Builder_4.this.ui.set_active(false);
            GuideLine new_guideline = this.guideline_create();
            new_guideline.orientation = 0;
            new_guideline.position_set(Display_Builder_4.this.screen_to_stage(Display_Builder_4.this.ui.viewport_centre_get()));
            this.guide_select(new_guideline.id);
            UI uI = Display_Builder_4.this.ui;
            Display_Builder_4.this.ui.getClass();
            uI.transform_target_type_set(2);
            Display_Builder_4.this.ui.set_active(true);
            Display_Builder_4.this.ui_elements.update_guide_menu();
            Display_Builder_4.this.ui_elements.update_guide_controls_position();
            return new_guideline.id;
        }

        public void guideline_add_auto() {
            if (this.current_displaygroup != null) {
                Display_Builder_4.this.ui.set_active(false);
                int i = 0;
                while (i < 4) {
                    GuideLine new_guideline = this.guideline_create();
                    new_guideline.orientation = (i + 1) % 2;
                    new_guideline.position_set(new PVector((float)this.current_displaygroup.projection_surface_bounds[i], (float)this.current_displaygroup.projection_surface_bounds[i]));
                    new_guideline.colour = this.current_displaygroup.outline_colour;
                    new_guideline.parent_id_set(this.current_displaygroup.id);
                    new_guideline.name_set("Display Group " + Display_Builder_4.this.get_number_from_id(this.current_displaygroup.id) + " - " + Display_Builder_4.this.ui.labels_bounds[i]);
                    new_guideline.locked = true;
                    this.guide_select(new_guideline.id);
                    ++i;
                }
                Display_Builder_4.this.ui.set_active(true);
                Display_Builder_4.this.ui_elements.update_guide_menu();
                Display_Builder_4.this.ui_elements.update_guide_controls_position();
            }
        }

        public GuideLine guideline_create() {
            int new_guideline_id = this.guides.size();
            GuideLine new_guideline = new GuideLine(new_guideline_id);
            this.guides.add(new_guideline);
            return new_guideline;
        }

        public int guidemeasure_add() {
            Display_Builder_4.this.ui.set_active(false);
            int new_guidemeasure_id = this.guides.size();
            GuideMeasure new_guidemeasure = new GuideMeasure(new_guidemeasure_id);
            this.guides.add(new_guidemeasure);
            this.guide_select(new_guidemeasure_id);
            this.guides_update_ids();
            UI uI = Display_Builder_4.this.ui;
            Display_Builder_4.this.ui.getClass();
            uI.transform_target_type_set(2);
            Display_Builder_4.this.ui.set_active(true);
            Display_Builder_4.this.ui_elements.update_guide_menu();
            Display_Builder_4.this.ui_elements.update_guide_controls_position();
            return new_guidemeasure_id;
        }

        public void guide_delete() {
            Display_Builder_4.this.debug_output("Deleting current_guide: " + this.current_guide.id);
            int guide_count = this.guides.size();
            if (guide_count > 0) {
                Display_Builder_4.this.ui.set_active(false);
                this.current_guide.cleanup();
                int target_id = this.current_guide.id;
                this.guides.remove(target_id);
                this.guides_update_ids();
                if (guide_count > 1) {
                    int new_selection = Display_Builder_4.max((int)(target_id - 1), (int)(guide_count - 1));
                    this.guide_select(new_selection);
                } else {
                    this.current_guide = null;
                }
                Display_Builder_4.this.ui.set_active(true);
                Display_Builder_4.this.ui_elements.update_guide_controls();
            }
            Display_Builder_4.this.ui_elements.update_guide_menu();
        }

        public void guide_parent_set(int parent_id) {
            if (this.current_guide != null && parent_id < this.display_groups.size()) {
                this.current_guide.parent_id_set(parent_id);
            }
        }

        public void guide_position_update_from_ui(String input_dimension, String ui_text) {
            MixedInputResult mixed_input_parse_result = Display_Builder_4.this.parse_mixed_input(ui_text);
            if (mixed_input_parse_result != null && Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                int pixel_value = Display_Builder_4.this.convert_unit_size_to_pixels(mixed_input_parse_result.value, mixed_input_parse_result.text);
                this.current_guide.position_set_from_ui(input_dimension, pixel_value);
            } else {
                float pixel_value_float = Display_Builder_4.this.parse_math_string_expression(ui_text);
                this.current_guide.position_set_from_ui(input_dimension, Display_Builder_4.round((float)pixel_value_float));
            }
        }

        public void guide_select(int new_guide_id) {
            if (new_guide_id >= 0 && new_guide_id < this.guides.size()) {
                this.current_guide = this.guides.get(new_guide_id);
                UI uI = Display_Builder_4.this.ui;
                Display_Builder_4.this.ui.getClass();
                uI.transform_target_type_set(2);
                if (this.current_guide.id >= 0) {
                    Display_Builder_4.this.debug_output("Selected current_guide: " + this.current_guide.id);
                    Display_Builder_4.this.ui_elements.update_guide_controls();
                }
            }
        }

        public void guide_update_parent_position(int guide_id, PVector parent_position) {
            Display_Builder_4.this.debug_output("guide_update_parent_position guide: " + guide_id + " to " + parent_position.x + "," + parent_position.y);
            Guide target_guide = this.guides.get(guide_id);
            target_guide.parent_position_set(parent_position);
        }

        public void guides_delete_all() {
            Display_Builder_4.this.debug_output("Project removing all Guides.");
            for (Guide guide : this.guides) {
                guide.cleanup();
            }
            this.guides.clear();
            Display_Builder_4.this.ui_elements.update_guide_controls();
            Display_Builder_4.this.ui_elements.update_guide_menu();
        }

        public void guides_draw(String guide_type) {
            if (Display_Builder_4.this.ui.active.booleanValue()) {
                for (Guide guide : this.guides) {
                    guide.draw_guide(guide_type);
                }
            }
        }

        public void guides_update_ids() {
            int guide_index = 0;
            for (Guide guide : this.guides) {
                guide.id_update(guide_index);
                ++guide_index;
            }
        }

        public void load_defaults() {
            this.filepath_set("default_project");
            Display_Builder_4.this.load_project_file();
        }

        public int player_count_get_total() {
            int project_player_count = 0;
            int i = 0;
            while (i < this.group_player_counts.size()) {
                project_player_count += this.group_player_counts.get(i);
                ++i;
            }
            return project_player_count;
        }

        public void player_count_set_group(int group_id, int player_count) {
            this.group_player_counts.set(group_id, player_count);
            if (this.pref_auto_increment_group_player_ids.booleanValue()) {
                int incremental_player_id = 1;
                for (DisplayGroup group : this.display_groups) {
                    if (group.id <= group_id) continue;
                    incremental_player_id = this.player_id_get_next(group.id);
                    group.player_start_number_set(incremental_player_id);
                }
            }
            this.summary_text_update();
        }

        public int player_id_get_next(int group_id) {
            if (group_id > 0 && group_id - 1 < this.group_player_counts.size()) {
                int player_count = 0;
                int i = 0;
                while (i < group_id) {
                    player_count += this.group_player_counts.get(i);
                    ++i;
                }
                return ++player_count;
            }
            return 1;
        }

        public void project_settings_reset() {
            this.viewport_physical_scale = 0.0f;
            this.physical_settings_active = false;
            this.pref_ui_toggle_show_layout_grid = true;
            this.pref_ui_grid_size_h = 1000;
            this.pref_ui_grid_size_v = Display_Builder_4.this.project.pref_ui_grid_size_h;
            this.physical_grid.visibility_set(false);
            this.physical_grid.alignment_id_set(0);
        }

        public void name_set(String new_name) {
            this.pref_project_name = !(new_name = Display_Builder_4.trim((String)new_name)).equals("") ? new_name : "WO displays";
            UI uI = Display_Builder_4.this.ui;
            String string = "Project name set: " + this.pref_project_name;
            Display_Builder_4.this.ui.getClass();
            uI.osd_message_display(string, 1);
            Display_Builder_4.this.ui_elements.update_all_controls();
        }

        public void physical_grid_alignment_id_set(int new_value) {
            if (new_value >= 0) {
                this.physical_grid.alignment_id_set(new_value);
            }
        }

        public void physical_grid_offset_ui_input_parse(String input_dimension, String ui_text) {
            MixedInputResult mixed_input_parse_result;
            Display_Builder_4.this.debug_output("Project set_physical_grid_offset : " + input_dimension + " to: " + ui_text);
            if (Display_Builder_4.this.is_float(ui_text)) {
                this.physical_grid.origin_offset_set(input_dimension, PApplet.parseFloat((String)ui_text));
            } else if (Display_Builder_4.this.project.physical_settings_active_get().booleanValue() && (mixed_input_parse_result = Display_Builder_4.this.parse_mixed_input(ui_text)) != null) {
                int pixel_value = Display_Builder_4.this.convert_unit_size_to_pixels(mixed_input_parse_result.value, mixed_input_parse_result.text);
                this.physical_grid.origin_offset_set(input_dimension, Display_Builder_4.this.pixels_to_physical(pixel_value));
            }
            Display_Builder_4.this.ui_elements.update_physical_grid_offset();
        }

        public Boolean physical_settings_active_get() {
            return this.physical_settings_active;
        }

        public int[] projection_surface_bounds_get() {
            return this.projection_surface_bounds;
        }

        public void preview_tier_add() {
            int stagetier_id_preview = this.stage_tier_add(0, "Preview - Group" + Display_Builder_4.this.get_id_from_number(this.current_displaygroup.id));
            Display_Builder_4.this.debug_output("Added Preview StageTier: " + stagetier_id_preview);
            DisplayGroup preview_displaygroup = this.displaygroup_add();
            preview_displaygroup.group_active_set(false);
            preview_displaygroup.group_copy(this.current_displaygroup.id, "Preview");
            preview_displaygroup.displays_delete_all();
            if (preview_displaygroup.resolution.name.substring(0, 6).equals("Custom")) {
                preview_displaygroup.resolution_set_by_id(Display_Builder_4.this.project.default_resolution_id);
                preview_displaygroup.resolution_object_set_by_id(Display_Builder_4.this.project.default_resolution_id);
            }
            Display_Builder_4.this.project.getClass();
            preview_displaygroup.display_type = 1;
            preview_displaygroup.softedge_dimensions = new PVector(0.0f, 0.0f);
            preview_displaygroup.display_rows = 1;
            preview_displaygroup.display_cols = 1;
            preview_displaygroup.stagetier_id_set(stagetier_id_preview);
            preview_displaygroup.parent_id_set(this.current_displaygroup.id);
            this.current_displaygroup.player_output_one_reserved = true;
            preview_displaygroup.parent_offset = new PVector(0.0f, 0.0f);
            preview_displaygroup.anchor_alignment_id_set(4.0f);
            preview_displaygroup.parent_alignment_id_set(4.0f);
            if (this.current_displaygroup.player_outputs_sharing.booleanValue()) {
                preview_displaygroup.player_start_number_set(this.current_displaygroup.player_start_number);
            } else {
                preview_displaygroup.player_start_number_set(this.current_displaygroup.player_start_number + 1);
            }
            preview_displaygroup.preview_display_scale_to_parent();
            preview_displaygroup.group_active_set(true);
            preview_displaygroup.displays_update();
            preview_displaygroup.debug_info();
            this.displaygroup_select(preview_displaygroup.id);
        }

        public void projection_surface_bounds_update() {
            for (DisplayGroup group : this.display_groups) {
                int[] group_projection_surface_bounds = group.projection_surface_bounds_get();
                if (group.id == 0) {
                    this.projection_surface_bounds[0] = group_projection_surface_bounds[0];
                    this.projection_surface_bounds[1] = group_projection_surface_bounds[1];
                    this.projection_surface_bounds[2] = group_projection_surface_bounds[2];
                    this.projection_surface_bounds[3] = group_projection_surface_bounds[3];
                    continue;
                }
                this.projection_surface_bounds[0] = Display_Builder_4.min((int)this.projection_surface_bounds[0], (int)group_projection_surface_bounds[0]);
                this.projection_surface_bounds[1] = Display_Builder_4.max((int)this.projection_surface_bounds[1], (int)group_projection_surface_bounds[1]);
                this.projection_surface_bounds[2] = Display_Builder_4.max((int)this.projection_surface_bounds[2], (int)group_projection_surface_bounds[2]);
                this.projection_surface_bounds[3] = Display_Builder_4.min((int)this.projection_surface_bounds[3], (int)group_projection_surface_bounds[3]);
            }
            this.physical_grid.grid_bounds_set(this.projection_surface_bounds[0], this.projection_surface_bounds[1], this.projection_surface_bounds[2], this.projection_surface_bounds[3]);
            String debug = "Project Projection Surface ";
            debug = String.valueOf(debug) + "Mode " + this.pref_projection_surface_mode;
            debug = String.valueOf(debug) + ": " + (this.projection_surface_bounds[1] - this.projection_surface_bounds[3] + 1);
            debug = String.valueOf(debug) + "," + (this.projection_surface_bounds[2] - this.projection_surface_bounds[0] + 1);
            debug = String.valueOf(debug) + " - Top:" + this.projection_surface_bounds[0];
            debug = String.valueOf(debug) + ", Right:" + this.projection_surface_bounds[1];
            debug = String.valueOf(debug) + ", Bottom:" + this.projection_surface_bounds[2];
            debug = String.valueOf(debug) + ", Left:" + this.projection_surface_bounds[3];
            Display_Builder_4.this.debug_output(debug);
        }

        public void reset() {
            Display_Builder_4.this.debug_output("Project reset.");
            Display_Builder_4.this.ui.active = false;
            this.reset_project_lists();
            this.project_settings_reset();
            this.target_surface_bounds_reset();
            this.transform_list_reset();
            this.load_defaults();
        }

        public void reset_project_lists() {
            this.guides_delete_all();
            this.displaygroups_remove_all();
            this.stage_tiers_delete_all();
        }

        public PVector resolution_dimensions_get(int res_id) {
            PVector dimensions = new PVector(0.0f, 0.0f);
            if (res_id <= this.resolutions_list.size()) {
                DisplayResolution resolution = this.resolutions_list.get(res_id);
                dimensions.x = resolution.pixel_count.x;
                dimensions.y = resolution.pixel_count.y;
            }
            return dimensions;
        }

        public Boolean resolution_id_is_valid(int res_id) {
            if (res_id >= 0 && res_id <= this.resolutions_list.size()) {
                return true;
            }
            return false;
        }

        public int resolution_lookup_by_values(PVector resolution_search) {
            PVector resolution_compare = new PVector(0.0f, 0.0f);
            for (DisplayResolution resolution : this.resolutions_list) {
                resolution_compare = PVector.sub((PVector)resolution.pixel_count, (PVector)resolution_search);
                if (resolution_compare.x != 0.0f || resolution_compare.y != 0.0f) continue;
                Display_Builder_4.this.ui_elements.button_resolution_preset_add_lock(true);
                Display_Builder_4.println((String)("resolution_lookup_by_values match: " + resolution.id + " with res: " + resolution.pixel_count.x + "x" + resolution.pixel_count.y));
                return resolution.id;
            }
            Display_Builder_4.this.ui_elements.button_resolution_preset_add_lock(false);
            return -1;
        }

        public int resolution_preset_add(String res_name, int res_width, int res_height, int res_cols, int res_rows, int res_type_id, float res_width_physical, float res_height_physical) {
            DisplayResolution new_resolution = new DisplayResolution(res_name, res_width, res_height, res_cols, res_rows, res_type_id, res_width_physical, res_height_physical);
            this.resolutions_list.add(new_resolution);
            return new_resolution.id;
        }

        public int resolution_preset_add_custom(int res_width, int res_height) {
            if (res_width > 0 && res_height > 0) {
                int resolution_check_id = this.resolution_lookup_by_values(new PVector((float)res_width, (float)res_height));
                if (resolution_check_id < 0) {
                    Display_Builder_4.this.debug_output("resolution_preset_add_custom " + res_width + "," + res_height);
                    int customs_preset_id = Display_Builder_4.this.get_number_from_id(this.resolutions_list.size() - this.resolutions_preset_count_initial);
                    String res_name = "Custom " + customs_preset_id;
                    int res_type = 0;
                    if (res_width < 720 || res_height < 576) {
                        res_type = 2;
                    }
                    int new_preset_id = this.resolution_preset_add(res_name, res_width, res_height, 2, 2, res_type, 0.0f, 0.0f);
                    if (this.current_displaygroup != null) {
                        this.current_displaygroup.resolution_object_set_by_id(new_preset_id);
                    }
                    Display_Builder_4.this.ui_elements.resolutions_menu_update();
                    return new_preset_id;
                }
                return resolution_check_id;
            }
            return -1;
        }

        public void stage_tier_add() {
            this.stage_tier_add(this.stage_tiers.size(), "");
        }

        public int stage_tier_add(int tier_id, String tier_name) {
            int new_tier_id = 0;
            new_tier_id = tier_id < 0 ? this.stage_tiers.size() : Display_Builder_4.max((int)tier_id, (int)this.stage_tiers.size());
            StageTier new_stagetier = new StageTier(new_tier_id, tier_name);
            this.stage_tiers.add(new_stagetier);
            Display_Builder_4.this.ui_elements.stagetiers_menu_update();
            return new_stagetier.id;
        }

        public void stage_tier_delete() {
            if (this.current_stage_tier.id > 0 && this.stage_tiers.size() > 1) {
                int stagetier_delete_id = this.current_stage_tier.id;
                this.stage_tier_select(this.current_stage_tier.id - 1);
                this.stage_tiers.remove(stagetier_delete_id);
                this.stage_tiers_id_update();
                this.stage_tier_remove_reference(stagetier_delete_id);
                Display_Builder_4.this.ui_elements.stagetiers_menu_update();
            } else {
                UI uI = Display_Builder_4.this.ui;
                Display_Builder_4.this.ui.getClass();
                uI.osd_message_display("Cannot delete the first stage tier!", 2);
            }
        }

        public void stage_tiers_delete_all() {
            Display_Builder_4.this.debug_output("Project deleting all StageTiers.");
            this.stage_tiers.clear();
            this.stage_tier_remove_reference(0);
        }

        public void stage_tiers_id_update() {
            int stagetier_index = 0;
            for (StageTier tier : this.stage_tiers) {
                tier.id = stagetier_index++;
            }
        }

        public void stage_tier_remove_reference(int stagetier_id_remove) {
            int stagetier_id_default = 0;
            for (DisplayGroup group : Display_Builder_4.this.project.display_groups) {
                if (group.stagetier_id != stagetier_id_remove && stagetier_id_remove != stagetier_id_default) continue;
                group.stagetier_id_set(stagetier_id_default);
            }
        }

        public void stage_tier_select(int new_stagetier_id) {
            if (new_stagetier_id >= 0 && new_stagetier_id < this.stage_tiers.size()) {
                this.current_stage_tier = this.stage_tiers.get(new_stagetier_id);
                Display_Builder_4.this.ui_elements.stagetier_name_update();
                if (this.current_displaygroup != null && this.current_displaygroup.stagetier_id != this.current_stage_tier.id) {
                    this.current_displaygroup.stagetier_id_set(this.current_stage_tier.id);
                    UI uI = Display_Builder_4.this.ui;
                    String string = "DisplayGroup " + Display_Builder_4.this.get_number_from_id(this.current_displaygroup.id) + " assigned to StageTier " + Display_Builder_4.this.get_number_from_id(this.current_stage_tier.id) + ".";
                    Display_Builder_4.this.ui.getClass();
                    uI.osd_message_display(string, 1);
                }
            }
        }

        public void summary_text_update() {
            String text_project_summary = "";
            String text_project_summary_tooltip = "";
            int group_count = this.display_groups.size();
            int[] displaygroup_counts = this.displaygroup_data_counts_get();
            int display_count = displaygroup_counts[0];
            int pixel_count = displaygroup_counts[1];
            int player_count = displaygroup_counts[2];
            text_project_summary = String.valueOf(text_project_summary) + "Groups:   " + group_count + "     ";
            text_project_summary = String.valueOf(text_project_summary) + "Players:  " + player_count + "\n\n";
            text_project_summary = String.valueOf(text_project_summary) + "Displays: " + display_count + "    ";
            text_project_summary = String.valueOf(text_project_summary) + "Pixels: " + Display_Builder_4.this.human_readable_number_string(pixel_count);
            text_project_summary_tooltip = String.valueOf(text_project_summary_tooltip) + "Groups: " + group_count + ", ";
            text_project_summary_tooltip = String.valueOf(text_project_summary_tooltip) + "Displays: " + display_count + ", ";
            text_project_summary_tooltip = String.valueOf(text_project_summary_tooltip) + "Players: " + player_count + ", ";
            text_project_summary_tooltip = String.valueOf(text_project_summary_tooltip) + "Pixels: " + Display_Builder_4.nfc((int)pixel_count);
            Display_Builder_4.this.ui_elements.update_project_summary(text_project_summary, text_project_summary_tooltip);
        }

        public int[] surface_bounds_get(String surface_name) {
            if (surface_name.equals("target")) {
                return this.pref_target_surface_bounds;
            }
            if (surface_name.equals("project")) {
                return this.projection_surface_bounds;
            }
            return this.current_displaygroup.projection_surface_bounds;
        }

        public PVector surface_dimensions_get(String surface_name) {
            PVector dimensions = this.current_displaygroup.projection_surface_dimensions_get();
            if (surface_name.equals("target")) {
                dimensions.x = this.pref_target_surface_bounds[1] - this.pref_target_surface_bounds[3] + 1;
                dimensions.y = this.pref_target_surface_bounds[2] - this.pref_target_surface_bounds[0] + 1;
            }
            if (surface_name.equals("project")) {
                dimensions.x = this.projection_surface_bounds[1] - this.projection_surface_bounds[3] + 1;
                dimensions.y = this.projection_surface_bounds[2] - this.projection_surface_bounds[0] + 1;
            }
            return dimensions;
        }

        public void surface_dimensions_physical_ui_update(String ui_control_element_name, String ui_value) {
            if (this.physical_settings_active_get().booleanValue()) {
                this.target_surface_bounds_calculate(ui_control_element_name, ui_value);
            } else {
                this.current_displaygroup.display_physical_dimensions_calculate_from_surface(ui_control_element_name, ui_value);
            }
        }

        public void surface_mode_toggle() {
            if (this.pref_projection_surface_mode == 0) {
                this.pref_projection_surface_mode = 1;
                this.target_surface_bounds_calculate("surface_mode", "");
                Display_Builder_4.this.redraw_screen();
            } else {
                this.pref_projection_surface_mode = 0;
                this.displaygroup_current_update();
            }
        }

        public void target_surface_bounds_calculate(String ui_control_name, String ui_control_value) {
            Display_Builder_4.this.debug_output("Project calculate_target_surface_bounds from " + ui_control_name + " : " + ui_control_value);
            float user_input_physical = Display_Builder_4.this.parse_math_string_expression(ui_control_value);
            int user_input_px = Display_Builder_4.round((float)user_input_physical) - 1;
            int[] base_bounds = this.current_displaygroup.projection_surface_bounds_get();
            if (ui_control_name == "button_surface_mode") {
                this.pref_projection_surface_mode = 1;
            }
            this.pref_target_surface_bounds[3] = base_bounds[3];
            this.pref_target_surface_bounds[1] = base_bounds[1];
            this.pref_target_surface_bounds[0] = base_bounds[0];
            this.pref_target_surface_bounds[2] = base_bounds[2];
            if (user_input_px > 0 || !ui_control_value.equals("")) {
                this.pref_projection_surface_mode = 1;
                if (ui_control_name == "textfield_projection_surface_h_px") {
                    this.pref_target_surface_bounds[1] = this.pref_target_surface_bounds[3] + user_input_px;
                    this.pref_target_surface_bounds[2] = base_bounds[2];
                }
                if (ui_control_name == "textfield_projection_surface_v_px") {
                    this.pref_target_surface_bounds[2] = this.pref_target_surface_bounds[0] + user_input_px;
                    this.pref_target_surface_bounds[1] = base_bounds[1];
                }
                if (!Float.isNaN(user_input_physical)) {
                    int user_input_as_pixels = Display_Builder_4.round((float)(user_input_physical * this.viewport_physical_scale)) - 1;
                    if (ui_control_name == "textfield_group_surface_h_physical") {
                        this.pref_target_surface_bounds[1] = this.pref_target_surface_bounds[3] + user_input_as_pixels;
                    }
                    if (ui_control_name == "textfield_group_surface_v_physical") {
                        this.pref_target_surface_bounds[2] = this.pref_target_surface_bounds[0] + user_input_as_pixels;
                    }
                }
            }
            PVector target_surface_dimensions = new PVector((float)(this.pref_target_surface_bounds[1] - this.pref_target_surface_bounds[3]), (float)(this.pref_target_surface_bounds[2] - this.pref_target_surface_bounds[0]));
            this.pref_target_surface_bounds = Display_Builder_4.this.alignment_apply_to_bounds(target_surface_dimensions, this.current_displaygroup.anchor_alignment_id);
            Display_Builder_4.this.ui_elements.update_surface_dimensions();
            String debug = "Project Target Surface ";
            debug = String.valueOf(debug) + "Mode " + this.pref_projection_surface_mode;
            debug = String.valueOf(debug) + ": " + (this.pref_target_surface_bounds[1] - this.pref_target_surface_bounds[3]);
            debug = String.valueOf(debug) + "," + (this.pref_target_surface_bounds[2] - this.pref_target_surface_bounds[0]);
            debug = String.valueOf(debug) + " - Top:" + this.pref_target_surface_bounds[0];
            debug = String.valueOf(debug) + ", Right:" + this.pref_target_surface_bounds[1];
            debug = String.valueOf(debug) + ", Bottom:" + this.pref_target_surface_bounds[2];
            debug = String.valueOf(debug) + ", Left:" + this.pref_target_surface_bounds[3];
            Display_Builder_4.this.debug_output(debug);
        }

        public void target_surface_bounds_reset() {
            this.pref_target_surface_bounds = new int[4];
        }

        public void toggle_ui_auto_scale(boolean ui_toggle_status) {
            this.pref_ui_scale_auto = ui_toggle_status;
            if (this.pref_ui_scale_auto.booleanValue()) {
                this.displaygroup_current_update();
            }
        }

        public void toggle_ui_scaling(boolean ui_toggle_status) {
            this.pref_ui_scaling = ui_toggle_status;
            if (!this.pref_ui_scaling.booleanValue()) {
                Display_Builder_4.this.ui.window_width_current = Display_Builder_4.this.ui.window_width_min;
                Display_Builder_4.this.ui.window_height_current = Display_Builder_4.this.ui.window_height_min;
                Display_Builder_4.this.ui.window_scale_set(1.0f);
                Display_Builder_4.this.ui.update_ui_dimensions();
            }
        }

        public void toggle_physical_grid_visibility(boolean ui_toggle_status) {
            if (this.physical_settings_active_get().booleanValue()) {
                Display_Builder_4.this.debug_output("Project toggle_physical_grid_visibility " + ui_toggle_status);
                this.physical_grid.visibility_set(ui_toggle_status);
            }
        }

        public void toggle_project_load_mode() {
            this.project_load_overwrite = Display_Builder_4.this.toggle_status(this.project_load_overwrite);
            Display_Builder_4.this.debug_output("Project load mode project_load_overwrite: " + this.project_load_overwrite);
            Display_Builder_4.this.ui_elements.update_project_load_mode_toggle(this.project_load_overwrite);
        }

        public void transform_add() {
            int new_transform_id = this.transform_list.size();
            Display_Builder_4.this.ui.getClass();
            int target_type = 0;
            int target_group_id = -1;
            int target_id = -1;
            Boolean target_set = false;
            if (Display_Builder_4.this.ui.tab_is_current("group_guides").booleanValue()) {
                if (Display_Builder_4.this.project.current_guide != null) {
                    Display_Builder_4.this.ui.getClass();
                    target_type = 2;
                    target_group_id = -1;
                    target_id = Display_Builder_4.this.project.current_guide.id;
                    target_set = true;
                }
            } else {
                Display_Builder_4.this.ui.getClass();
                target_type = 0;
                target_group_id = Display_Builder_4.this.project.current_displaygroup_id;
                target_id = -1;
                target_set = true;
            }
            if (target_set.booleanValue()) {
                Transform new_transform = new Transform(new_transform_id, target_type, target_group_id, target_id);
                this.transform_list.add(new_transform);
                this.current_transform = this.transform_get(new_transform_id);
                if (target_group_id == -1) {
                    this.guide_select(target_id);
                    this.current_guide.transform_save(this.current_transform);
                    this.current_transform.debug();
                }
            }
        }

        public Transform transform_get(int transform_id) {
            if (transform_id >= 0 && transform_id < this.transform_list.size()) {
                this.current_transform_id = transform_id;
                return this.transform_list.get(transform_id);
            }
            return null;
        }

        public void transform_list_reset() {
            this.transform_list.clear();
        }

        public void transform_remove() {
        }

        public void transform_undo() {
            if (this.current_transform != null) {
                Display_Builder_4.this.debug_output("transform_undo(): " + this.current_transform.id);
                switch (this.current_transform.target_type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.guide_select(this.current_transform.target_display_id);
                        this.current_guide.transform_restore(this.current_transform);
                    }
                }
            }
        }

        public void viewport_physical_scale_calculate(float display_height_pixels, float display_height_physical) {
            if (display_height_physical > 0.0f) {
                this.viewport_physical_scale = display_height_pixels / display_height_physical;
                this.physical_settings_active = true;
            } else {
                this.viewport_physical_scale = 0.0f;
                this.physical_settings_active = false;
            }
        }

        public void viewport_physical_scale_set(float new_scale, int displaygroup_id) {
            if (new_scale != this.viewport_physical_scale) {
                this.viewport_physical_scale = new_scale;
                Display_Builder_4.this.debug_output("Project - DisplayGroup " + displaygroup_id + " set_viewport_physical_scale: " + this.viewport_physical_scale);
                if (this.viewport_physical_scale > 0.0f) {
                    this.physical_settings_active = true;
                    Display_Builder_4.this.ui_elements.physical_controls_lock(false);
                } else {
                    this.physical_settings_active = false;
                    this.physical_grid.visibility_set(false);
                    Display_Builder_4.this.ui_elements.physical_controls_lock(true);
                }
                this.physical_grid.grid_data_calculate();
                for (DisplayGroup group : this.display_groups) {
                    if (group.id == displaygroup_id) continue;
                    group.group_physical_scale_calculate("stage");
                }
            }
        }

        public void viewport_physical_scale_set_from_current_displaygroup() {
            if (this.current_displaygroup != null && this.current_displaygroup.physical_scale > 0.0f) {
                Display_Builder_4.this.debug_output("viewport_physical_scale_set_from_current_displaygroup: " + this.current_displaygroup.id);
                this.viewport_physical_scale_set(this.current_displaygroup.physical_scale, this.current_displaygroup.id);
            }
        }

        public void viewport_physical_scale_set_if_not_active(float new_scale, int displaygroup_id) {
            if (!this.physical_settings_active_get().booleanValue()) {
                this.viewport_physical_scale_set(new_scale, displaygroup_id);
            }
        }
    }

    class StageTier {
        int id;
        String name;
        int[] displaygroup_list;

        StageTier(int tid, String tname) {
            this.id = tid;
            this.name_set(tname, false);
            this.displaygroup_list = new int[0];
            Display_Builder_4.this.debug_output("Added StageTier " + this.id + " - " + this.name);
        }

        public Boolean[] displaygroup_check(int group_id) {
            Boolean[] group_tier_status = new Boolean[]{false, false, false};
            int group_tier_count = this.displaygroup_list.length;
            int i = 0;
            while (i < group_tier_count) {
                if (this.displaygroup_list[i] == group_id) {
                    if (i == 0) {
                        group_tier_status[0] = true;
                    }
                    group_tier_status[1] = true;
                    if (i != group_tier_count - 1) break;
                    group_tier_status[2] = true;
                    break;
                }
                ++i;
            }
            return group_tier_status;
        }

        public void displaygroup_list_debug() {
            int group_tier_count = this.displaygroup_list.length;
            String output = "Stagetier " + this.id + " contains " + group_tier_count + " DisplayGroups: ";
            int i = 0;
            while (i < group_tier_count) {
                output = String.valueOf(output) + this.displaygroup_list[i] + ",";
                ++i;
            }
            Display_Builder_4.this.debug_output(output);
        }

        public void displaygroup_register(int group_id) {
            Boolean[] group_tier_status = this.displaygroup_check(group_id);
            if (!group_tier_status[1].booleanValue()) {
                this.displaygroup_list = Display_Builder_4.append((int[])this.displaygroup_list, (int)group_id);
                this.displaygroup_list = Display_Builder_4.sort((int[])this.displaygroup_list);
            }
            this.displaygroup_list_debug();
        }

        public void displaygroup_unregister(int group_id) {
            int group_tier_count = this.displaygroup_list.length;
            int[] displaygroup_list_temp = new int[]{};
            int i = 0;
            while (i < group_tier_count) {
                if (this.displaygroup_list[i] != group_id) {
                    displaygroup_list_temp = Display_Builder_4.append((int[])displaygroup_list_temp, (int)this.displaygroup_list[i]);
                }
                ++i;
            }
            this.displaygroup_list = Display_Builder_4.sort((int[])displaygroup_list_temp);
            this.displaygroup_list_debug();
        }

        public XML generate_project_xml(XML xml_project_stagetiers) {
            XML xml_stagetier = xml_project_stagetiers.addChild("tier");
            xml_stagetier.setInt("id", this.id);
            xml_stagetier.setString("name", this.name);
            return xml_project_stagetiers;
        }

        public void name_set(String new_name, Boolean show_message) {
            this.name = !new_name.equals("") ? new_name : "Tier " + (this.id + 1);
            if (show_message.booleanValue()) {
                UI uI = Display_Builder_4.this.ui;
                String string = "Stage Tier " + (this.id + 1) + " name changed to: " + this.name;
                Display_Builder_4.this.ui.getClass();
                uI.osd_message_display(string, 1);
            }
        }
    }

    public class Transform {
        int id;
        int target_type;
        int target_displaygroup_id;
        int target_display_id;
        PVector position;
        PVector stagesize;
        PVector scale;
        float rotation;

        Transform(int tid, int type, int tdisplaygroup_id, int tdisplay_id) {
            this.id = tid;
            this.target_type = type;
            this.target_displaygroup_id = tdisplaygroup_id;
            this.target_display_id = tdisplay_id;
            this.position = new PVector(0.0f, 0.0f);
            this.stagesize = new PVector(0.0f, 0.0f);
            this.scale = new PVector(1.0f, 1.0f);
            Display_Builder_4.this.debug_output("Transform " + this.id + " created.");
        }

        public void debug() {
            Display_Builder_4.this.debug_output("Transform " + this.id + " Type: " + this.target_type + " DGid: " + this.target_displaygroup_id + ", Did: " + this.target_display_id + ", P: " + this.position.x + "," + this.position.y + ", S: " + this.scale.x + "," + this.scale.y + ", R: " + this.rotation);
        }

        public void set(PVector tposition, PVector tstagesize, PVector tscale, float trotation) {
            this.position = tposition;
            this.stagesize = tstagesize;
            this.scale = tscale;
            this.rotation = trotation;
        }
    }

    class UI {
        Boolean ready;
        Boolean active = true;
        Boolean operation_in_progress;
        int window_width_min;
        int window_height_min;
        int window_width_current;
        int window_height_current;
        float window_scale;
        int swatch_target_id;
        IntDict colours;
        Boolean key_ctrl_active = false;
        int mouse_click_time;
        int mouse_doubleclick_delay = 400;
        boolean is_panning;
        PVector mouse_offset;
        PVector screen_centre;
        int scrollbar_width;
        PVector viewport;
        float viewport_scale;
        int viewport_scale_max;
        ScrollableList dropdownlist_display_colour_options;
        ScrollableList dropdownlist_display_groups;
        ScrollableList dropdownlist_display_type;
        ScrollableList dropdownlist_export_formats;
        ScrollableList dropdownlist_guides;
        ScrollableList dropdownlist_guide_parent;
        ScrollableList dropdownlist_export_grid_unit;
        ScrollableList dropdownlist_parent_group;
        ScrollableList dropdownlist_resolutions;
        ScrollableList dropdownlist_stage_tiers;
        Boolean transform_mode_selected;
        Boolean transform_in_progress;
        int tool_mode;
        final int MODE_DEFAULT = 0;
        final int TRANSFORM_MOVE = 1;
        final int TRANSFORM_ROTATE = 2;
        final int TRANSFORM_SCALE = 3;
        final int MODE_DRAW = 4;
        final int MODE_MEASURE = 5;
        int transform_target_type;
        final int TARGET_DISPLAYGROUP = 0;
        final int TARGET_DISPLAY = 1;
        final int TARGET_GUIDE = 2;
        PVector drawing_target;
        PVector transform_source_position;
        PVector transform_origin;
        PVector transform_position_delta;
        float transform_initial_angle = 0.0f;
        float transform_initial_distance = 0.0f;
        float transform_angle = 0.0f;
        float transform_distance = 0.0f;
        float transform_minimum_scale_value = 0.1f;
        float transform_scale_constrained = 1.0f;
        PVector transform_scale;
        int transform_constrain_axis = -1;
        Boolean transform_slow_mode = false;
        int active_tab_id = 0;
        int osd_message_status;
        final int MESSAGE_INFO = 0;
        final int MESSAGE_SUCCESS = 1;
        final int MESSAGE_ERROR = 2;
        String osd_message_text;
        int osd_message_duration = 3000;
        int osd_message_timer;
        int osd_message_opacity;
        String[] labels_display_types = new String[]{"2D Display", "Preview Display", "LED Panel", "Virtual Display", "3D Display"};
        String[] labels_bounds = new String[]{"Top", "Right", "Bottom", "Left"};
        String[] units_display_list = new String[]{"m", "ft", "in"};
        PVector[] alignment_position_vectors = new PVector[]{new PVector(0.0f, 0.0f), new PVector(-0.5f, 0.0f), new PVector(-1.0f, 0.0f), new PVector(0.0f, -0.5f), new PVector(-0.5f, -0.5f), new PVector(-1.0f, -0.5f), new PVector(0.0f, -1.0f), new PVector(-0.5f, -1.0f), new PVector(-1.0f, -1.0f)};
        String[] alignment_grid_labels = new String[]{"TL", "TC", "TR", "CL", "CC", "CR", "BL", "BC", "BR"};
        String overlay_text;
        String[] symbol_arrow_strings = new String[]{"\u2191", "\u2192", "\u2193", "\u2190"};
        String symbol_position = "\u2725";
        String symbol_rotation = "\u21bb";
        String symbol_scale = "\u25a3";

        UI() {
            this.colours = new IntDict();
            this.colours_add_defaults();
            this.mouse_reset_click_timer();
            this.is_panning = false;
            this.viewport_scale_max = 100;
            this.window_width_min = 1280;
            this.window_height_min = 720;
            this.window_width_current = this.window_width_min;
            this.window_height_current = this.window_height_min;
            this.mouse_offset = new PVector(0.0f, 0.0f);
            this.operation_in_progress = false;
            this.ready = false;
            this.scrollbar_width = 5;
            this.viewport_scale = 20.0f;
            this.swatch_target_id = 0;
            this.tool_mode = 0;
            this.transform_in_progress = false;
            this.transform_mode_selected = false;
            this.drawing_target = new PVector(0.0f, 0.0f);
            this.transform_origin = new PVector(0.0f, 0.0f);
            this.transform_position_delta = new PVector(0.0f, 0.0f);
            this.transform_scale = new PVector(1.0f, 1.0f);
            this.transform_source_position = new PVector(0.0f, 0.0f);
            this.transform_target_type = 0;
            this.viewport = new PVector(0.0f, 0.0f);
            this.screen_centre = new PVector(0.0f, 0.0f);
            this.window_scale = 1.0f;
        }

        public int alignment_grid_label_get_id(String search_label) {
            int i = 0;
            while (i < Display_Builder_4.this.ui.alignment_grid_labels.length) {
                if (this.alignment_grid_labels[i].equals(search_label)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void window_size_check() {
            if (Display_Builder_4.this.width != this.window_width_current || Display_Builder_4.this.height != this.window_height_current) {
                this.window_width_current = Display_Builder_4.max((int)this.window_width_min, (int)Display_Builder_4.this.width);
                this.window_height_current = Display_Builder_4.max((int)this.window_height_min, (int)Display_Builder_4.this.height);
                Display_Builder_4.this.surface.setSize(this.window_width_current, this.window_height_current);
                this.window_scale_set(Display_Builder_4.min((float)((float)Display_Builder_4.this.width / PApplet.parseFloat((int)this.window_width_min)), (float)((float)Display_Builder_4.this.height / PApplet.parseFloat((int)this.window_height_min))));
                this.update_ui_dimensions();
            }
        }

        public void window_scale_set(float new_scale) {
            this.window_scale = new_scale;
        }

        public void colours_add_defaults() {
            this.colours.set("matkeane", Display_Builder_4.this.color(255, 102, 0));
            this.colours.set("viewport_bg", Display_Builder_4.this.color(0, 0, 0, 255));
            this.colours.set("display_stroke", Display_Builder_4.this.color(255, 102, 0));
            this.colours.set("display_fill", Display_Builder_4.this.color(100, 100, 100, 128));
            this.colours.set("surface_stroke", Display_Builder_4.this.color(255, 255, 0, 90));
            this.colours.set("ui_pane_bg", Display_Builder_4.this.color(50, 50, 50, 255));
            this.colours.set("ui_pane_line", Display_Builder_4.this.color(120, 120, 120, 255));
            this.colours.set("ui_label", Display_Builder_4.this.color(225, 225, 255, 255));
            this.colours.set("info_text", Display_Builder_4.this.color(255));
            this.colours.set("grid_line_pixel", Display_Builder_4.this.color(100, 100, 255, 128));
            this.colours.set("grid_line_physical", Display_Builder_4.this.color(100, 255, 100, 128));
            this.colours.set("grid_line_default", Display_Builder_4.this.color(100, 200, 200, 128));
            this.colours.set("guide_line_default", Display_Builder_4.this.color(100, 200, 200, 255));
            this.colours.set("info_text", Display_Builder_4.this.color(255));
            this.colours.set("info_background", Display_Builder_4.this.color(50, 50, 80, 255));
            this.colours.set("ui_element_default", Display_Builder_4.this.color(0, 31, 63, 255));
            this.colours.set("ui_element_enabled", Display_Builder_4.this.color(0, 180, 0, 255));
            this.colours.set("ui_element_disabled", Display_Builder_4.this.color(150, 50, 50, 255));
            this.colours.set("ui_element_warning", Display_Builder_4.this.color(180, 0, 0, 255));
        }

        public int colour_get_by_name(String colour_name) {
            if (Display_Builder_4.this.ui.colours.hasKey(colour_name)) {
                return Display_Builder_4.this.ui.colours.get(colour_name);
            }
            return Display_Builder_4.this.ui.colours.get("matkeane");
        }

        public void colour_set_by_name_rgba(String colour_name, int r, int g, int b, int a) {
            this.colours.set(colour_name, Display_Builder_4.this.color(r, g, b, a));
            Display_Builder_4.this.debug_output("Added colour: " + colour_name + " " + r + " " + g + " " + b);
        }

        public void colour_swatch_clicked(int swatch_id) {
            Display_Builder_4.this.debug_output("Colour Swatch clicked with swatch id: " + swatch_id);
            this.swatch_target_id = swatch_id;
            if (this.colourpicker_get_visibility().booleanValue()) {
                this.colourpicker_display(false);
            } else {
                this.colourpicker_display(true);
            }
        }

        public void colourpicker_display(Boolean visible) {
            if (this.ready.booleanValue()) {
                ((ColorWheel)Display_Builder_4.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).moveTo(this.tab_get_active_name());
                if (visible.booleanValue()) {
                    ((ColorWheel)Display_Builder_4.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).setRGB(this.colour_get_from_swatch_id(this.swatch_target_id));
                    ((ColorWheel)Display_Builder_4.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).show();
                } else {
                    ((ColorWheel)Display_Builder_4.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).hide();
                }
            }
        }

        public void colourpicker_event(int action_id) {
            int colourpicker_r = ((ColorWheel)Display_Builder_4.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).r();
            int colourpicker_g = ((ColorWheel)Display_Builder_4.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).g();
            int colourpicker_b = ((ColorWheel)Display_Builder_4.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).b();
            int new_colour = Display_Builder_4.this.color(colourpicker_r, colourpicker_g, colourpicker_b, 255);
            switch (action_id) {
                case 2: {
                    this.colourpicker_display(false);
                    break;
                }
                case 100: {
                    this.colour_update_from_swatch(new_colour);
                }
            }
        }

        public Boolean colourpicker_get_visibility() {
            return ((ColorWheel)Display_Builder_4.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).isVisible();
        }

        public int colour_get_from_swatch_id(int swatch_id) {
            int swatch_colour = Display_Builder_4.this.ui.colour_get_by_name("display_stroke");
            switch (swatch_id) {
                case 1: {
                    if (Display_Builder_4.this.project.current_displaygroup != null) {
                        swatch_colour = Display_Builder_4.this.project.current_displaygroup.outline_colour;
                        break;
                    }
                    swatch_colour = Display_Builder_4.this.ui.colour_get_by_name("display_stroke");
                    break;
                }
                case 2: {
                    swatch_colour = Display_Builder_4.this.ui.colour_get_by_name("grid_line_pixel");
                    break;
                }
                case 3: {
                    swatch_colour = Display_Builder_4.this.ui.colour_get_by_name("surface_stroke");
                    break;
                }
                case 4: {
                    swatch_colour = Display_Builder_4.this.ui.colour_get_by_name("grid_line_physical");
                    break;
                }
                case 5: {
                    if (Display_Builder_4.this.project.current_guide == null) break;
                    swatch_colour = Display_Builder_4.this.project.current_guide.colour_get();
                }
            }
            return swatch_colour;
        }

        public void colour_update_from_swatch(int picked_color) {
            switch (this.swatch_target_id) {
                case 1: {
                    Display_Builder_4.this.ui.colours.set("display_stroke", picked_color);
                    Display_Builder_4.this.project.current_displaygroup.colour_set(picked_color);
                    break;
                }
                case 2: {
                    Display_Builder_4.this.ui.colours.set("grid_line_pixel", picked_color);
                    break;
                }
                case 3: {
                    Display_Builder_4.this.ui.colours.set("surface_stroke", picked_color);
                    break;
                }
                case 4: {
                    Display_Builder_4.this.ui.colours.set("grid_line_physical", picked_color);
                    break;
                }
                case 5: {
                    if (Display_Builder_4.this.project.current_guide == null) break;
                    Display_Builder_4.this.project.current_guide.colour_set(picked_color);
                    Display_Builder_4.this.ui_elements.update_guide_swatch();
                }
            }
            Display_Builder_4.this.ui_elements.update_colour_swatches();
        }

        public Boolean drag_to_pan_active() {
            return this.is_panning;
        }

        public void drag_to_pan_set(Boolean active_status) {
            if (active_status.booleanValue()) {
                if (!this.colourpicker_get_visibility().booleanValue() && !this.mouse_within_ui_pane()) {
                    this.is_panning = true;
                    Display_Builder_4.this.cursor(12);
                    Display_Builder_4.this.ui.mouse_offset.x = (float)Display_Builder_4.this.mouseX - Display_Builder_4.this.ui.viewport.x;
                    Display_Builder_4.this.ui.mouse_offset.y = (float)Display_Builder_4.this.mouseY - Display_Builder_4.this.ui.viewport.y;
                }
            } else {
                this.is_panning = false;
                Display_Builder_4.this.cursor(0);
            }
        }

        public void keyboard_event(int key_code, Boolean key_active) {
            Boolean mouse_within_ui_pane = this.mouse_within_ui_pane();
            switch (key_code) {
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    break;
                }
                case 16: {
                    break;
                }
                case 17: 
                case 157: {
                    this.key_ctrl_active = key_active;
                    break;
                }
                case 18: {
                    break;
                }
                case 27: {
                    this.transform_cancel();
                    break;
                }
                case 32: {
                    if (mouse_within_ui_pane.booleanValue()) break;
                    this.tool_mode_set(0);
                    this.drag_to_pan_set(key_active);
                    break;
                }
                case 65: {
                    break;
                }
                case 67: {
                    break;
                }
                case 68: {
                    this.tool_mode_set(4);
                    break;
                }
                case 73: {
                    this.tool_mode_set(5);
                    break;
                }
                case 71: 
                case 77: {
                    this.tool_mode_set(1);
                    break;
                }
                case 82: {
                    this.tool_mode_set(2);
                    break;
                }
                case 83: {
                    this.tool_mode_set(3);
                    break;
                }
                case 84: {
                    break;
                }
                case 85: {
                    break;
                }
                case 86: {
                    if (!this.key_ctrl_active.booleanValue() || !key_active.booleanValue()) break;
                    Display_Builder_4.this.text_content_get_from_clipboard();
                    break;
                }
                case 88: 
                case 89: {
                    if (mouse_within_ui_pane.booleanValue()) break;
                    this.transform_constrain_axis_set(key_code, key_active);
                }
            }
        }

        public void mouse_dragged() {
            this.transform_apply();
        }

        public void mouse_moved() {
            if (!this.mouse_within_ui_pane() && !this.colourpicker_get_visibility().booleanValue()) {
                Display_Builder_4.this.project.displaygroup_mouseover_check(Display_Builder_4.this.mouseX, Display_Builder_4.this.mouseY, "hover");
            }
        }

        public void mouse_pressed() {
            if (this.mouse_within_ui_pane()) {
                this.transform_cancel();
                this.drag_to_pan_set(false);
                this.tool_mode_set(0);
            } else if (!this.colourpicker_get_visibility().booleanValue()) {
                if (Display_Builder_4.this.mouseButton == 3) {
                    this.tool_mode_set(0);
                    this.drag_to_pan_set(true);
                } else {
                    this.transform_begin();
                }
            }
        }

        public void mouse_released() {
            if (this.mouse_doubleclicked().booleanValue()) {
                this.transform_cancel();
                this.tool_mode_set(0);
                if (!this.mouse_within_ui_pane()) {
                    this.pan_surface_to_viewport_centre();
                }
            } else if (this.mouse_within_ui_pane()) {
                this.transform_cancel();
                this.tool_mode_set(0);
            } else {
                this.transform_end();
                Display_Builder_4.this.project.displaygroup_mouseover_check(Display_Builder_4.this.mouseX, Display_Builder_4.this.mouseY, "click");
            }
        }

        public void mouse_reset_click_timer() {
            this.mouse_click_time = Display_Builder_4.this.millis();
        }

        public Boolean mouse_doubleclicked() {
            int mouse_click_interval = Display_Builder_4.this.millis() - this.mouse_click_time;
            this.mouse_reset_click_timer();
            if (mouse_click_interval <= this.mouse_doubleclick_delay) {
                return true;
            }
            return false;
        }

        public void mouse_wheel(Float mouse_wheel_value) {
            if (!this.mouse_within_ui_pane()) {
                if (Display_Builder_4.this.project.pref_invert_mouse_wheel_direction.booleanValue()) {
                    mouse_wheel_value = Float.valueOf(mouse_wheel_value.floatValue() * -1.0f);
                }
                float old_display_scale = Display_Builder_4.this.ui.viewport_scale;
                this.viewport_scale += mouse_wheel_value.floatValue();
                this.viewport_scale = Display_Builder_4.max((float)1.0f, (float)this.viewport_scale);
                this.update_pan_to_maintain_centre(old_display_scale);
                Display_Builder_4.this.ui_elements.update_scale_slider();
                this.transform_set_source_position();
                Display_Builder_4.this.project.physical_grid.grid_scale_calculate();
                Display_Builder_4.this.redraw_screen();
            }
        }

        public boolean mouse_within_ui_pane() {
            if (Display_Builder_4.this.ui_elements.pane_position_screen_top.booleanValue()) {
                return Display_Builder_4.this.mouseY <= Display_Builder_4.this.ui_elements.pane_height;
            }
            return Display_Builder_4.this.mouseY >= Display_Builder_4.this.ui_elements.pane_origin;
        }

        public void osd_message_display(String osd_message_string, int message_type_code) {
            if (message_type_code != 0) {
                Display_Builder_4.this.debug_output(osd_message_string);
            }
            this.osd_message_status = message_type_code;
            this.osd_message_text = osd_message_string;
            this.osd_message_timer = Display_Builder_4.this.millis();
            this.osd_message_opacity = 255;
        }

        public void osd_message_fade() {
            Display_Builder_4.this.ui.osd_message_timer = Display_Builder_4.this.millis() - Display_Builder_4.this.ui.osd_message_duration;
        }

        public void pan_surface_to_viewport_centre() {
            PVector surface_centre_coords = Display_Builder_4.this.project.current_displaygroup.projection_surface_centre_screen_get();
            PVector viewport_centre_coords = Display_Builder_4.this.ui.viewport_centre_get();
            Display_Builder_4.this.ui.viewport = PVector.sub((PVector)viewport_centre_coords, (PVector)surface_centre_coords);
        }

        public void stage_scale_auto_fit_to_bounds(int[] surface_bounds_check) {
            PVector surface_dimensions = Display_Builder_4.this.dimensions_from_bounds(surface_bounds_check);
            if (Display_Builder_4.this.project.pref_ui_scale_auto.booleanValue() && surface_dimensions.x > 0.0f && surface_dimensions.y > 0.0f) {
                surface_dimensions.x += (float)(Display_Builder_4.this.project.pref_ui_grid_size_h / 2);
                surface_dimensions.y += (float)(Display_Builder_4.this.project.pref_ui_grid_size_v / 2);
                float new_scale_value = PApplet.parseFloat((int)Display_Builder_4.this.width) / surface_dimensions.x;
                new_scale_value = Display_Builder_4.min((float)new_scale_value, (float)(PApplet.parseFloat((int)(Display_Builder_4.this.ui.window_height_current - Display_Builder_4.this.ui_elements.pane_height)) / surface_dimensions.y));
                Display_Builder_4.this.debug_output("Calculating UI Auto Scale value for dimensions: " + surface_dimensions.x + ", " + surface_dimensions.y + " : " + (new_scale_value *= 100.0f));
                if (new_scale_value > 0.0f && new_scale_value < this.viewport_scale) {
                    this.viewport_scale = new_scale_value;
                    this.pan_surface_to_viewport_centre();
                    ((Slider)Display_Builder_4.this.ui_elements.controls.get(Slider.class, "slider_stage_scale")).setValue(this.viewport_scale);
                }
            }
        }

        public void stage_scale_set(float new_slider_value) {
            float old_display_scale = this.viewport_scale;
            this.viewport_scale = new_slider_value;
            this.update_pan_to_maintain_centre(old_display_scale);
            Display_Builder_4.this.redraw_screen();
        }

        public void active_tab_id_set(int tab_id) {
            this.active_tab_id = tab_id;
            this.transform_target_type = this.tab_is_current("group_guides") != false ? 2 : 0;
        }

        public String tab_get_active_name() {
            return Display_Builder_4.this.ui_elements.tab_name_labels[this.active_tab_id][0];
        }

        public Boolean tab_is_current(String tab_name) {
            if (Display_Builder_4.this.ui_elements.tab_name_labels[this.active_tab_id][0].equals(tab_name)) {
                return true;
            }
            return false;
        }

        public void tab_select_next() {
            int next_tab_id = this.active_tab_id + 1;
            if (next_tab_id >= Display_Builder_4.this.ui_elements.tab_name_labels.length) {
                this.active_tab_id_set(0);
            } else {
                this.active_tab_id_set(next_tab_id);
            }
            Display_Builder_4.this.ui_elements.controls.getTab(Display_Builder_4.this.ui_elements.tab_name_labels[this.active_tab_id][0]).bringToFront();
        }

        public int tool_mode_active() {
            return this.tool_mode;
        }

        public void tool_mode_set(int new_mode) {
            if (!this.mouse_within_ui_pane()) {
                if (this.transform_target_exists().booleanValue() || new_mode == 5) {
                    if (new_mode != this.tool_mode) {
                        this.transform_constrain_axis_set(0, false);
                        if (!this.transform_mode_selected.booleanValue()) {
                            this.transform_set_source_position();
                        }
                        if (new_mode > 0) {
                            this.drag_to_pan_set(false);
                            this.transform_mode_selected = true;
                            this.transform_reset_values();
                            this.transform_set_source_position();
                        }
                        switch (new_mode) {
                            case 5: {
                                this.tool_mode = 5;
                                this.transform_initial_angle = 0.0f;
                                Display_Builder_4.this.cursor(1);
                                break;
                            }
                            case 4: {
                                this.tool_mode = 4;
                                Display_Builder_4.this.cursor(1);
                                break;
                            }
                            case 3: {
                                this.tool_mode = 3;
                                Display_Builder_4.this.cursor(13);
                                break;
                            }
                            case 2: {
                                this.tool_mode = 2;
                                Display_Builder_4.this.cursor(13);
                                break;
                            }
                            case 1: {
                                this.tool_mode = 1;
                                Display_Builder_4.this.cursor(13);
                                break;
                            }
                            default: {
                                this.tool_mode = 0;
                                this.transform_cancel();
                                this.transform_mode_selected = false;
                                this.drag_to_pan_set(false);
                                Display_Builder_4.this.cursor(0);
                            }
                        }
                        Display_Builder_4.this.debug_output("tool_mode_set: " + this.tool_mode);
                    }
                } else {
                    Display_Builder_4.this.debug_output("No target exists for transform!");
                }
            }
        }

        public Boolean transform_target_exists() {
            if (this.tab_is_current("group_guides") != false ? Display_Builder_4.this.project.current_guide != null : this.transform_target_type == 0 && Display_Builder_4.this.project.current_displaygroup != null) {
                return true;
            }
            return false;
        }

        public void transform_begin() {
            if (!this.drag_to_pan_active().booleanValue() && this.transform_mode_selected.booleanValue()) {
                if (!this.transform_in_progress.booleanValue()) {
                    if (this.tool_mode != 4 && this.tool_mode != 5) {
                        Display_Builder_4.this.project.transform_add();
                    }
                    this.transform_set_source_position();
                    this.transform_in_progress = true;
                } else {
                    Display_Builder_4.this.debug_output("transform_begin() cancelled - transform_in_progress: " + this.transform_in_progress);
                }
            }
        }

        public void transform_cancel() {
            if (this.transform_mode_selected.booleanValue()) {
                if (this.transform_in_progress.booleanValue()) {
                    this.transform_in_progress = false;
                    if (this.tool_mode != 4) {
                        Display_Builder_4.this.project.transform_undo();
                    }
                }
                this.drag_to_pan_set(false);
            }
        }

        public void transform_constrain_axis_set(int key_code, Boolean key_active) {
            int axis = -1;
            if (!key_active.booleanValue()) {
                axis = -1;
            } else {
                switch (key_code) {
                    case 88: {
                        axis = 0;
                        break;
                    }
                    case 89: {
                        axis = 1;
                    }
                }
            }
            if (!this.transform_in_progress.booleanValue() && this.transform_target_type == 2 && this.transform_target_exists().booleanValue()) {
                Display_Builder_4.this.project.current_guide.orientation_set(axis);
            }
            this.transform_constrain_axis = axis;
        }

        public void transform_apply() {
            if (this.drag_to_pan_active().booleanValue()) {
                this.viewport.x = (float)Display_Builder_4.this.mouseX - this.mouse_offset.x;
                this.viewport.y = (float)Display_Builder_4.this.mouseY - this.mouse_offset.y;
            } else {
                this.transform_calculate();
                switch (this.tool_mode) {
                    case 1: {
                        if (Display_Builder_4.this.project.current_guide == null) break;
                        Display_Builder_4.this.project.current_guide.apply_move(this.transform_position_delta);
                        break;
                    }
                    case 2: {
                        if (Display_Builder_4.this.project.current_guide == null) break;
                        Display_Builder_4.this.project.current_guide.apply_rotation(this.transform_angle);
                        break;
                    }
                    case 3: {
                        if (Display_Builder_4.this.project.current_guide == null) break;
                        Display_Builder_4.this.project.current_guide.apply_scale(this.transform_scale);
                        break;
                    }
                }
            }
        }

        public void transform_calculate() {
            PVector mouse_position = new PVector((float)Display_Builder_4.this.mouseX, (float)Display_Builder_4.this.mouseY);
            this.transform_angle = this.translate_calculate_angle(mouse_position, this.transform_origin);
            this.transform_angle -= this.transform_initial_angle;
            this.transform_distance = this.translate_calculate_distance(mouse_position, this.transform_origin);
            this.transform_position_delta = PVector.sub((PVector)mouse_position, (PVector)this.transform_source_position);
            this.transform_scale_constrained = this.transform_distance / this.transform_initial_distance;
            this.transform_scale_constrained = Display_Builder_4.max((float)this.transform_minimum_scale_value, (float)this.transform_scale_constrained);
            this.transform_scale.x = this.transform_scale_constrained + Display_Builder_4.max((float)this.transform_minimum_scale_value, (float)(this.transform_position_delta.x / this.transform_distance));
            this.transform_scale.y = this.transform_scale_constrained + Display_Builder_4.max((float)this.transform_minimum_scale_value, (float)(this.transform_position_delta.y / this.transform_distance));
            switch (this.transform_constrain_axis) {
                case 0: {
                    this.transform_position_delta.y = 0.0f;
                    this.transform_scale.y = this.transform_scale_constrained;
                    break;
                }
                case 1: {
                    this.transform_position_delta.x = 0.0f;
                    this.transform_scale.x = this.transform_scale_constrained;
                    break;
                }
                default: {
                    this.transform_scale.x = this.transform_scale_constrained;
                    this.transform_scale.y = this.transform_scale_constrained;
                }
            }
        }

        public float translate_calculate_angle(PVector point_from, PVector point_to) {
            float angle = Display_Builder_4.atan2((float)(point_from.y - point_to.y), (float)(point_from.x - point_to.x));
            return angle;
        }

        public float translate_calculate_distance(PVector point_from, PVector point_to) {
            float transform_dist = PVector.dist((PVector)point_from, (PVector)point_to);
            return transform_dist;
        }

        public void transform_end() {
            if (this.transform_mode_selected.booleanValue()) {
                if (this.transform_in_progress.booleanValue()) {
                    this.transform_in_progress = false;
                    if (this.tool_mode == 4) {
                        Display_Builder_4.println((String)"End MODE_DRAW");
                    }
                    if (this.tool_mode == 5) {
                        Display_Builder_4.println((String)"Add new Measurement");
                        PVector start_position = Display_Builder_4.this.screen_to_stage(this.transform_source_position);
                        PVector mouse_position = Display_Builder_4.this.screen_to_stage(new PVector((float)Display_Builder_4.this.mouseX, (float)Display_Builder_4.this.mouseY));
                        switch (Display_Builder_4.this.ui.transform_constrain_axis) {
                            case 0: {
                                mouse_position.y = start_position.y;
                                break;
                            }
                            case 1: {
                                mouse_position.x = start_position.x;
                            }
                        }
                        this.transform_angle = this.translate_calculate_angle(mouse_position, start_position);
                        int new_guide_id = Display_Builder_4.this.project.guidemeasure_add();
                        GuideMeasure new_guide = (GuideMeasure)Display_Builder_4.this.project.guides.get(new_guide_id);
                        new_guide.distance = Float.valueOf(this.translate_calculate_distance(start_position, mouse_position));
                        new_guide.position = start_position.copy();
                        new_guide.position_last = mouse_position.copy();
                        new_guide.rotation = this.transform_angle;
                        new_guide.name = new_guide.get_text_info();
                        new_guide.locked = true;
                        Display_Builder_4.this.debug_output("Added new Guide Measurement at " + new_guide.position_last.x + "," + new_guide.position_last.y + " with distance: " + new_guide.distance + ", rotation: " + new_guide.rotation);
                        Display_Builder_4.this.project.guide_select(new_guide.id);
                        this.tool_mode_set(0);
                    }
                }
            } else if (this.drag_to_pan_active().booleanValue()) {
                this.drag_to_pan_set(false);
            }
        }

        public String transform_get_text_data() {
            String transform_text = "";
            switch (this.tool_mode) {
                case 1: {
                    transform_text = "Move: " + Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)this.transform_position_delta.x)) + "," + Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)this.transform_position_delta.y));
                    break;
                }
                case 2: {
                    transform_text = "Rotate: " + Display_Builder_4.nf((float)Display_Builder_4.degrees((float)this.transform_angle), (int)1, (int)2);
                    break;
                }
                case 3: {
                    transform_text = "Scale: ";
                    if (this.transform_constrain_axis == -1) {
                        transform_text = String.valueOf(transform_text) + Display_Builder_4.nf((float)(this.transform_scale_constrained * 100.0f), (int)1, (int)2);
                        break;
                    }
                    transform_text = String.valueOf(transform_text) + Display_Builder_4.nf((float)(this.transform_scale.x * 100.0f), (int)1, (int)2) + "," + Display_Builder_4.nf((float)(this.transform_scale.y * 100.0f), (int)1, (int)2);
                    break;
                }
                case 4: {
                    transform_text = "Draw: " + Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)this.transform_position_delta.x)) + "," + Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)this.transform_position_delta.y));
                    break;
                }
                case 5: {
                    transform_text = "Measurement distance: " + Display_Builder_4.this.get_formatted_float_string(Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)this.transform_position_delta.x))) + "," + Display_Builder_4.this.get_formatted_float_string(Display_Builder_4.this.screen_to_stage(Display_Builder_4.round((float)this.transform_position_delta.y)));
                    transform_text = String.valueOf(transform_text) + ", rotation: " + Display_Builder_4.this.get_formatted_float_string(Display_Builder_4.degrees((float)this.transform_angle) + 90.0f);
                }
            }
            return transform_text;
        }

        public void transform_reset_values() {
            this.transform_angle = 0.0f;
            this.transform_distance = 0.0f;
            this.transform_position_delta.x = 0.0f;
            this.transform_position_delta.y = 0.0f;
            this.transform_scale_constrained = 1.0f;
            this.transform_scale.x = 1.0f;
            this.transform_scale.y = 1.0f;
        }

        public void transform_set_source_position() {
            this.transform_source_position.x = Display_Builder_4.this.mouseX;
            this.transform_source_position.y = Display_Builder_4.this.mouseY;
            if (this.tool_mode == 4 || this.tool_mode == 5) {
                this.transform_origin = this.transform_source_position.copy();
            } else if (Display_Builder_4.this.ui.tab_is_current("group_guides").booleanValue()) {
                if (Display_Builder_4.this.project.current_guide != null) {
                    PVector temp_position = Display_Builder_4.this.project.current_guide.get_position().copy();
                    this.transform_origin.x = Display_Builder_4.round((float)(Display_Builder_4.this.stage_to_screen(temp_position.x) + this.viewport.x));
                    this.transform_origin.y = Display_Builder_4.round((float)(Display_Builder_4.this.stage_to_screen(temp_position.y) + this.viewport.y));
                }
            } else if (Display_Builder_4.this.project.current_displaygroup != null) {
                PVector temp_position = Display_Builder_4.this.project.current_displaygroup.projection_surface_centre_screen_get();
                this.transform_origin.x = Display_Builder_4.round((float)(temp_position.x + this.viewport.x));
                this.transform_origin.y = Display_Builder_4.round((float)(temp_position.y + this.viewport.y));
            }
            this.transform_initial_angle = this.translate_calculate_angle(this.transform_source_position, this.transform_origin);
            this.transform_initial_distance = this.translate_calculate_distance(this.transform_source_position, this.transform_origin);
        }

        public void transform_target_type_set(int target_type) {
            if (target_type >= 0 && target_type <= 4) {
                this.transform_target_type = target_type;
                Display_Builder_4.this.debug_output("transform_target_type set to: " + this.transform_target_type);
            }
        }

        public void update_pan_to_maintain_centre(float previous_ui_scale) {
            if (Display_Builder_4.this.ui.viewport.x != 0.0f || Display_Builder_4.this.ui.viewport.y != 0.0f) {
                float cfr_ignored_0 = Display_Builder_4.this.ui.viewport_scale;
                float previous_scale_reciprocal = 1.0f / (previous_ui_scale / 100.0f);
                PVector viewport_centre = Display_Builder_4.this.ui.viewport_centre_get();
                float visual_centre_x = (viewport_centre.x - Display_Builder_4.this.ui.viewport.x) * previous_scale_reciprocal;
                float visual_centre_y = (viewport_centre.y - Display_Builder_4.this.ui.viewport.y) * previous_scale_reciprocal;
                Display_Builder_4.this.ui.viewport.x = viewport_centre.x - Display_Builder_4.this.stage_to_screen(visual_centre_x);
                Display_Builder_4.this.ui.viewport.y = viewport_centre.y - Display_Builder_4.this.stage_to_screen(visual_centre_y);
            }
        }

        public void select_export_folder() {
            Display_Builder_4.this.selectFolder("Select folder for Exports:", "export_folder_selected");
        }

        public void select_project_save_folder() {
            Display_Builder_4.this.selectFolder("Select folder for Project file:", "project_save_folder_selected");
        }

        public void set_active(Boolean status) {
            this.active = status;
            Display_Builder_4.this.debug_output("UI active status: " + this.active);
        }

        public void update_ui_dimensions() {
            Display_Builder_4.this.ui_elements.calculate_ui_pane_height();
            Display_Builder_4.this.ui_elements.calculate_tab_dimensions();
            Display_Builder_4.this.ui_elements.resize_tabs();
            Display_Builder_4.this.ui_elements.calculate_control_layout_grid();
            Display_Builder_4.this.ui_elements.move_controls();
            Display_Builder_4.this.ui_elements.controls.setGraphics(Display_Builder_4.this.app, 0, 0);
            this.viewport_centre_calculate();
        }

        public void viewport_centre_calculate() {
            this.screen_centre.x = this.window_width_current / 2;
            this.screen_centre.y = Display_Builder_4.this.ui_elements.pane_position_screen_top != false ? (float)(Display_Builder_4.this.ui_elements.pane_height + (this.window_height_current - Display_Builder_4.this.ui_elements.pane_height) / 2) : (float)(Display_Builder_4.this.ui_elements.pane_origin / 2);
        }

        public PVector viewport_centre_get() {
            PVector screen_centre_copy = this.screen_centre.copy();
            return screen_centre_copy;
        }
    }

    public class UiElements {
        ControlP5 controls;
        StringDict control_tooltips;
        PGraphics controls_image;
        int pane_height_default;
        int pane_height;
        int pane_origin;
        Boolean pane_position_screen_top = true;
        int tab_count = 7;
        PVector tab_dimensions;
        int tab_caption_margin_left = 12;
        int[][] divider_positions = new int[][]{new int[1]};
        int tab_height_default = 25;
        int control_width_default = 20;
        int control_height_default;
        int control_height;
        int control_grid_width_default;
        int control_grid_height_default = 36;
        int toggle_width_default = 18;
        int label_offset_x_default = 10;
        int label_offset_y_default = -22;
        int osd_overlay_height = 28;
        int[] control_grid_origin;
        int control_grid_columns;
        int control_grid_rows;
        int[] control_grid_column_positions;
        int[] control_grid_row_positions;
        float control_grid_row_height;
        int colourpicker_size;
        ControlFont ui_font_tabs;
        String[][] tab_name_labels = new String[][]{{"default", "DISPLAY BUILDER"}, {"group_guides", "Layout Guides"}, {"group_displaygroups", "Tiers & Groups"}, {"group_display_setup", "Display Setup"}, {"group_display_layout", "Display Layout"}, {"group_view", "View Options"}, {"group_export", "Export Options"}};

        UiElements() {
            this.control_tooltips = new StringDict();
            this.pane_height = this.pane_height_default = 180;
            this.tab_dimensions = new PVector(0.0f, 0.0f);
            this.divider_positions = new int[this.tab_count][0];
            this.control_height = this.control_height_default = 20;
            this.ui_font_tabs = new ControlFont(Display_Builder_4.this.font_display_ui, this.tab_height_default / 2);
            this.control_grid_origin = new int[2];
            this.control_grid_columns = 64;
            this.control_grid_rows = 4;
            this.control_grid_column_positions = new int[this.control_grid_columns];
            this.control_grid_row_positions = new int[this.control_grid_rows];
            this.colourpicker_size = 300;
        }

        public void init() {
            this.controls = new ControlP5(Display_Builder_4.this.app);
            this.controls_image = Display_Builder_4.this.createGraphics(Display_Builder_4.this.width, Display_Builder_4.this.height, "processing.awt.PGraphicsJava2D");
            this.calculate_ui_pane_height();
            this.calculate_tab_dimensions();
            this.calculate_control_layout_grid();
            Display_Builder_4.this.ui.viewport_centre_calculate();
            CallbackListener ui_elements_callback = new CallbackListener(){

                public void controlEvent(CallbackEvent theEvent) {
                    if (((UiElements)UiElements.this).Display_Builder_4.this.ui.ready.booleanValue()) {
                        Controller ui_control_element = theEvent.getController();
                        String ui_control_element_name = ui_control_element.getName();
                        theEvent.getController().getId();
                        theEvent.getAction();
                        switch (theEvent.getAction()) {
                            case 6: {
                                if (!((UiElements)UiElements.this).Display_Builder_4.this.ui_elements.control_tooltips.hasKey(ui_control_element_name)) break;
                                UI uI = ((UiElements)UiElements.this).Display_Builder_4.this.ui;
                                String string = ((UiElements)UiElements.this).Display_Builder_4.this.ui_elements.control_tooltips.get(ui_control_element_name);
                                ((UiElements)UiElements.this).Display_Builder_4.this.ui.getClass();
                                uI.osd_message_display(string, 0);
                                break;
                            }
                            case 7: {
                                ((UiElements)UiElements.this).Display_Builder_4.this.ui.osd_message_fade();
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 9: {
                                break;
                            }
                        }
                    }
                }
            };
            Display_Builder_4.this.ui_elements.controls.addCallback(ui_elements_callback);
        }

        public void calculate_control_layout_grid() {
            float column_width = Display_Builder_4.this.ui.window_width_current / this.control_grid_columns;
            int i = 0;
            while (i < this.control_grid_columns) {
                this.control_grid_column_positions[i] = Display_Builder_4.round((float)((float)i * column_width));
                ++i;
            }
            float cfr_ignored_0 = this.tab_dimensions.y;
            this.control_grid_origin[0] = 0;
            this.control_grid_origin[1] = Display_Builder_4.round((float)this.pane_origin);
            this.control_grid_row_height = Display_Builder_4.round((float)((float)this.control_grid_height_default * Display_Builder_4.this.ui.window_scale));
            i = 0;
            while (i < this.control_grid_rows) {
                this.control_grid_row_positions[i] = this.control_grid_origin[1] + Display_Builder_4.round((float)(this.control_grid_row_height * (float)(i + 1)));
                ++i;
            }
        }

        public void calculate_ui_pane_height() {
            this.pane_height = Display_Builder_4.round((float)((float)this.pane_height_default * Display_Builder_4.this.ui.window_scale));
            this.pane_origin = this.pane_position_screen_top != false ? 0 : Display_Builder_4.this.ui.window_height_current - this.pane_height;
        }

        public void calculate_tab_dimensions() {
            this.tab_dimensions.x = Display_Builder_4.floor((float)((Display_Builder_4.this.ui.window_width_current - this.tab_count) / this.tab_count));
            this.tab_dimensions.y = Display_Builder_4.round((float)((float)this.tab_height_default * Display_Builder_4.this.ui.window_scale));
            this.ui_font_tabs = new ControlFont(Display_Builder_4.this.font_display_ui, Display_Builder_4.floor((float)(this.tab_dimensions.y / 2.0f)));
        }

        public void resize_tabs() {
            int i = 0;
            while (i < this.tab_name_labels.length) {
                this.controls.getTab(this.tab_name_labels[i][0]).setWidth(Display_Builder_4.round((float)this.tab_dimensions.x)).setHeight(Display_Builder_4.round((float)this.tab_dimensions.y));
                this.controls.getTab(this.tab_name_labels[i][0]).getCaptionLabel().setFont(this.ui_font_tabs);
                ++i;
            }
        }

        public int get_scaled_size(int original_size) {
            return Display_Builder_4.round((float)((float)original_size * Display_Builder_4.this.ui.window_scale));
        }

        public int get_grid_width(float grid_cell_count) {
            return Display_Builder_4.round((float)((float)this.control_grid_column_positions[1] * grid_cell_count));
        }

        public int get_ui_pane_origin() {
            return this.pane_origin;
        }

        public void lock_invert_layout_button(Boolean lock_state) {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Button)this.controls.get(Button.class, "button_invert_cols_rows_layout")).setLock(lock_state.booleanValue());
            }
        }

        public void move_controls() {
            ControlFont ui_font = new ControlFont(Display_Builder_4.this.font_display_ui, Display_Builder_4.round((float)(11.0f * Display_Builder_4.this.ui.window_scale)));
            this.osd_overlay_height = this.get_scaled_size(28);
            int current_tab_id = 0;
            int grid_width = Display_Builder_4.round((float)this.control_grid_column_positions[1]);
            int row_height = Display_Builder_4.round((float)this.control_grid_row_height);
            int control_hpos = 0;
            int control_height = this.get_scaled_size(22);
            int button_width_large = this.get_scaled_size(100);
            int button_width_med_large = this.get_scaled_size(80);
            int button_width_med = this.get_scaled_size(50);
            int button_width_small = this.get_scaled_size(20);
            int button_height = this.get_scaled_size(30);
            int radiobutton_size = this.get_scaled_size(12);
            int radiobutton_spacing = this.get_scaled_size(10);
            int radiobutton_offset_v = 5;
            int label_offset_y = this.get_scaled_size(-22);
            int textlabel_offset_y = this.get_scaled_size(4);
            this.controls.getWindow().setPositionOfTabs(1, this.pane_origin + 1);
            this.resize_tabs();
            this.divider_positions[current_tab_id] = new int[0];
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_version")).setPosition((float)this.get_grid_width(2.0f), (float)this.control_grid_row_positions[0] + (float)row_height * 0.75f)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_link_matkeane")).setPosition((float)this.get_grid_width(1.75f), (float)this.control_grid_row_positions[3] - (float)row_height * 0.2f)).setSize(this.get_scaled_size(120), Display_Builder_4.round((float)((float)button_height * 0.75f)))).setFont(ui_font);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(9.5f));
            control_hpos = this.control_grid_column_positions[11];
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_project_load")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(button_width_med_large, button_height)).setFont(ui_font);
            control_hpos = this.control_grid_column_positions[16];
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_project_load_mode")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(button_width_large, button_height)).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_project_name")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(11.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_project_name")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_project_name")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(5.0f) * -1;
            control_hpos = this.control_grid_column_positions[23];
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_project_save")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(button_width_med_large, button_height)).setFont(ui_font);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(28.0f));
            control_hpos = this.control_grid_column_positions[29];
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_project_summary_title")).setPosition((float)control_hpos, (float)(this.control_grid_row_positions[0] + textlabel_offset_y))).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_project_summary_data")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1] - (float)row_height * 0.25f)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_project_reset")).setPosition((float)this.get_grid_width(30.5f), (float)this.control_grid_row_positions[2])).setSize(button_width_large, button_height)).setFont(ui_font);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(38.0f));
            control_hpos = this.control_grid_column_positions[39];
            ((Textarea)((Textarea)this.controls.get(Textarea.class, "licence_textarea")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(25.0f), control_height * 6).setFont(ui_font).setLineHeight(this.get_scaled_size(16));
            current_tab_id = 1;
            this.divider_positions[current_tab_id] = new int[0];
            control_hpos = this.control_grid_column_positions[1];
            ((ScrollableList)((ScrollableList)((ScrollableList)Display_Builder_4.this.ui.dropdownlist_guides.setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setWidth(this.get_grid_width(12.0f))).setHeight(this.get_grid_width(6.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_guide_line_add")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(button_width_large, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_guide_line_add_auto")).setPosition((float)this.get_grid_width(8.0f), (float)this.control_grid_row_positions[2])).setSize(button_width_large, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_guide_image_load")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setSize(button_width_large, control_height)).setFont(ui_font);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(14.0f));
            control_hpos = this.control_grid_column_positions[15];
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_guide_info")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_guide_delete")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setSize(button_width_med_large, control_height)).setFont(ui_font);
            ((Bang)((Bang)((Bang)((Bang)this.controls.get(Bang.class, "bang_guide_locked")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setWidth(button_width_small)).setHeight(button_width_small)).setFont(ui_font);
            ((Bang)this.controls.get(Bang.class, (String)"bang_guide_locked")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Bang)this.controls.get(Bang.class, (String)"bang_guide_locked")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[24];
            ((Bang)((Bang)((Bang)((Bang)this.controls.get(Bang.class, "bang_swatch_guide")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setWidth(button_width_small)).setHeight(button_width_small)).setFont(ui_font);
            ((Bang)this.controls.get(Bang.class, (String)"bang_swatch_guide")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-3.25f);
            ((Bang)this.controls.get(Bang.class, (String)"bang_swatch_guide")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Slider)((Slider)((Slider)((Slider)this.controls.get(Slider.class, "slider_guide_opacity")).setBroadcast(false)).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(10.0f), this.get_grid_width(1.0f)).setFont(ui_font)).setBroadcast(true);
            ((Slider)this.controls.get(Slider.class, (String)"slider_guide_opacity")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-13.5f);
            ((Slider)((Slider)((Slider)((Slider)this.controls.get(Slider.class, "slider_image_scale")).setBroadcast(false)).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setSize(this.get_grid_width(10.0f), this.get_grid_width(1.0f)).setFont(ui_font)).setBroadcast(true);
            ((Slider)this.controls.get(Slider.class, (String)"slider_image_scale")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-13.5f);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(35.0f));
            control_hpos = this.get_grid_width(37.0f);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_guide_rotation")).setPosition((float)(control_hpos - this.get_grid_width(1.0f)), (float)this.control_grid_row_positions[1])).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_guide_rotation_value")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setFont(ui_font);
            ((Knob)((Knob)this.controls.get(Knob.class, "knob_guide_rotation")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2] + (float)row_height * 0.25f)).setSize(control_height * 2, control_height * 2);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(41.0f));
            control_hpos = this.control_grid_column_positions[42];
            ((ScrollableList)((ScrollableList)((ScrollableList)Display_Builder_4.this.ui.dropdownlist_guide_parent.setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setWidth(this.get_grid_width(10.0f))).setHeight(this.get_grid_width(6.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font);
            control_hpos = this.control_grid_column_positions[49];
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_x")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(3.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_guide_position_x")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-5.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_guide_position_x")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_y")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setSize(this.get_grid_width(3.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_guide_position_y")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-5.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_guide_position_y")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(53.0f));
            control_hpos = this.control_grid_column_positions[54];
            current_tab_id = 2;
            this.divider_positions[current_tab_id] = new int[0];
            control_hpos = this.control_grid_column_positions[1];
            ((ScrollableList)((ScrollableList)((ScrollableList)Display_Builder_4.this.ui.dropdownlist_stage_tiers.setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setWidth(this.get_grid_width(8.0f))).setHeight(this.get_grid_width(6.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_stagetier_name")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(8.0f), control_height).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_stagetier_add")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(button_width_med, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_stagetier_delete")).setPosition((float)(control_hpos + this.get_grid_width(5.5f)), (float)this.control_grid_row_positions[2])).setSize(button_width_med, control_height)).setFont(ui_font);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(10.0f));
            control_hpos = this.control_grid_column_positions[11];
            ((ScrollableList)((ScrollableList)((ScrollableList)Display_Builder_4.this.ui.dropdownlist_display_groups.setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setWidth(this.get_grid_width(9.5f))).setHeight(this.get_grid_width(6.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_display_group_name")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(9.5f), control_height).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_display_group_add")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(button_width_med, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_display_group_duplicate")).setPosition((float)(control_hpos + this.get_grid_width(3.5f)), (float)this.control_grid_row_positions[2])).setSize(button_width_med, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_display_group_delete")).setPosition((float)(control_hpos + this.get_grid_width(7.0f)), (float)this.control_grid_row_positions[2])).setSize(button_width_med, control_height)).setFont(ui_font);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(21.5f));
            control_hpos = this.get_grid_width(22.5f);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_display_basename")).setPosition((float)(control_hpos + this.get_grid_width(7.0f)), (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(4.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_basename")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-7.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_basename")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_display_colour")).setPosition((float)(control_hpos - this.get_grid_width(0.25f)), (float)this.control_grid_row_positions[1])).setFont(ui_font);
            ((ScrollableList)((ScrollableList)((ScrollableList)Display_Builder_4.this.ui.dropdownlist_display_colour_options.setPosition((float)(control_hpos + this.get_grid_width(3.5f)), (float)this.control_grid_row_positions[1])).setWidth(this.get_grid_width(7.5f))).setHeight(this.get_grid_width(4.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font);
            ((Bang)((Bang)((Bang)((Bang)this.controls.get(Bang.class, "bang_swatch_display_outline")).setPosition((float)(control_hpos + this.get_grid_width(10.0f)), (float)this.control_grid_row_positions[2])).setWidth(button_width_small)).setHeight(button_width_small)).setFont(ui_font);
            ((Bang)this.controls.get(Bang.class, (String)"bang_swatch_display_outline")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-10.0f);
            ((Bang)this.controls.get(Bang.class, (String)"bang_swatch_display_outline")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(34.5f));
            control_hpos = this.get_grid_width(42.5f);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_display_baseip")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(4.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_baseip")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-7.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_baseip")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_multi_output")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_multi_output")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-7.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_multi_output")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[54];
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_display_startip")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(1.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_startip")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-6.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_startip")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_player_outputs_shared")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_player_outputs_shared")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-8.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_player_outputs_shared")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[57];
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)(control_hpos - this.get_grid_width(1.0f)));
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_obj_surface_load")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(button_width_large, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_preview_tier_add")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(button_width_large, control_height)).setFont(ui_font);
            current_tab_id = 3;
            this.divider_positions[current_tab_id] = new int[0];
            control_hpos = this.control_grid_column_positions[1];
            ((ScrollableList)((ScrollableList)((ScrollableList)Display_Builder_4.this.ui.dropdownlist_display_type.setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setWidth(this.get_grid_width(8.0f))).setHeight(this.get_grid_width(6.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[10]);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_resolution_presets")).setPosition((float)(control_hpos += this.get_grid_width(10.0f)), (float)(this.control_grid_row_positions[0] + textlabel_offset_y))).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_resolution_width")).setPosition((float)(control_hpos += this.get_grid_width(1.5f)), (float)(this.control_grid_row_positions[1] + textlabel_offset_y))).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_resolution_height")).setPosition((float)control_hpos, (float)(this.control_grid_row_positions[2] + textlabel_offset_y))).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_resolution_pixel_count")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setFont(ui_font);
            ((Textlabel)this.controls.get(Textlabel.class, (String)"label_resolution_pixel_count")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((ScrollableList)((ScrollableList)((ScrollableList)Display_Builder_4.this.ui.dropdownlist_resolutions.setPosition((float)(control_hpos += this.get_grid_width(3.0f)), (float)this.control_grid_row_positions[0])).setWidth(this.get_grid_width(10.0f))).setHeight(this.get_grid_width(6.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_display_width_resolution")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_display_height_resolution")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Bang)((Bang)((Bang)this.controls.get(Bang.class, "bang_display_aspect_locked")).setPosition((float)(control_hpos += this.get_grid_width(2.5f)), (float)this.control_grid_row_positions[1] + (float)row_height * 0.5f)).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_resolution_aspect_ratio")).setPosition((float)(control_hpos += this.get_grid_width(1.5f)), (float)this.control_grid_row_positions[1])).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_resolution_preset_add")).setPosition((float)(control_hpos += this.get_grid_width(1.0f)), (float)this.control_grid_row_positions[2])).setSize(button_width_med, control_height)).setFont(ui_font);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(26.5f));
            control_hpos = this.get_grid_width(27.5f);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_display_physical_size")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setFont(ui_font);
            ((Textlabel)this.controls.get(Textlabel.class, (String)"label_display_physical_size")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)this.controls.get(Textfield.class, "textfield_display_width_physical")).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_width_physical")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-3.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_width_physical")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)this.controls.get(Textfield.class, "textfield_display_height_physical")).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_height_physical")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-3.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_height_physical")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)this.controls.get(Textfield.class, "textfield_display_width_physical")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1]);
            ((Textfield)this.controls.get(Textfield.class, "textfield_display_height_physical")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2]);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_project_physical_scale_set")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setSize(this.get_grid_width(8.0f), control_height)).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_display_physical_area")).setPosition((float)(control_hpos += this.get_grid_width(2.5f)), (float)this.control_grid_row_positions[1])).setFont(ui_font);
            ((Textlabel)this.controls.get(Textlabel.class, (String)"label_display_physical_area")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_pixel_size")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setFont(ui_font);
            ((Textlabel)this.controls.get(Textlabel.class, (String)"label_pixel_size")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[36]);
            control_hpos = this.get_grid_width(37.0f);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_stage_size")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setFont(ui_font);
            ((Textlabel)this.controls.get(Textlabel.class, (String)"label_stage_size")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_display_width_stage")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_width_stage")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_width_stage")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_display_height_stage")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_height_stage")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_height_stage")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_stagesize_round")).setPosition((float)(control_hpos += this.get_grid_width(4.0f)), (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(3.0f), control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_stagesize_reset")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(3.0f), control_height)).setFont(ui_font);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[45]);
            control_hpos = this.get_grid_width(46.0f);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_display_rotation")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setFont(ui_font);
            ((Knob)((Knob)this.controls.get(Knob.class, "knob_display_rotation")).setPosition((float)(control_hpos += this.get_grid_width(0.5f)), (float)(this.control_grid_row_positions[0] + row_height * 1))).setSize(control_height * 2, control_height * 2);
            current_tab_id = 4;
            this.divider_positions[current_tab_id] = new int[0];
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_displays")).setPosition((float)this.control_grid_column_positions[1], (float)(this.control_grid_row_positions[0] + textlabel_offset_y))).setFont(ui_font);
            ((Textlabel)this.controls.get(Textlabel.class, (String)"label_displays")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_invert_cols_rows_layout")).setPosition((float)this.control_grid_column_positions[5], (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(3.5f), control_height)).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_display_count_h")).setPosition((float)this.control_grid_column_positions[2] + (float)grid_width * 0.5f, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_count_h")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(3.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_count_h")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_display_col_subtract")).setPosition((float)this.control_grid_column_positions[1], (float)this.control_grid_row_positions[1])).setSize(button_width_small, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_display_col_add")).setPosition((float)this.control_grid_column_positions[4], (float)this.control_grid_row_positions[1])).setSize(button_width_small, control_height)).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_display_count_v")).setPosition((float)this.control_grid_column_positions[2] + (float)grid_width * 0.5f, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(1.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_count_v")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(3.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_display_count_v")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_display_row_subtract")).setPosition((float)this.control_grid_column_positions[1], (float)this.control_grid_row_positions[2])).setSize(button_width_small, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_display_row_add")).setPosition((float)this.control_grid_column_positions[4], (float)this.control_grid_row_positions[2])).setSize(button_width_small, control_height)).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_displays_count_summary")).setPosition((float)this.control_grid_column_positions[2] + (float)grid_width * 0.33f, (float)this.control_grid_row_positions[3])).setFont(ui_font);
            control_hpos = this.control_grid_column_positions[10];
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[9]);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_softedge")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setFont(ui_font);
            ((Textlabel)this.controls.get(Textlabel.class, (String)"label_softedge")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_soft_h")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setFont(ui_font);
            ((Textlabel)this.controls.get(Textlabel.class, (String)"label_soft_h")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_soft_v")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setFont(ui_font);
            ((Textlabel)this.controls.get(Textlabel.class, (String)"label_soft_v")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[11] + this.get_grid_width(0.5f);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_softedge_h_px")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_h_px")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_h_px")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_softedge_v_px")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_v_px")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_v_px")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[16];
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_softedge_h_pc")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_h_pc")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_h_pc")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_softedge_v_pc")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_v_pc")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_v_pc")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[20];
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_softedge_h_physical")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_h_physical")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_h_physical")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_softedge_v_physical")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_v_physical")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_softedge_v_physical")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[25];
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[24]);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_surface")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_projection_surface_h_px")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_projection_surface_h_px")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_projection_surface_h_px")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_projection_surface_v_px")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_projection_surface_v_px")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_projection_surface_v_px")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_group_surface_area_pixels")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setFont(ui_font);
            control_hpos = this.control_grid_column_positions[29];
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_group_surface_h_physical")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_group_surface_h_physical")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_group_surface_h_physical")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_group_surface_v_physical")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_group_surface_v_physical")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_group_surface_v_physical")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_group_surface_area_physical")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setFont(ui_font);
            control_hpos = this.control_grid_column_positions[34];
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_surface_mode")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(4.25f), control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_surface_fit")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(4.25f), control_height)).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_group_surface_area_ratio")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setFont(ui_font);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[39]);
            control_hpos = this.control_grid_column_positions[40];
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_displaygroup_origin")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setFont(ui_font);
            ((RadioButton)((RadioButton)this.controls.get(RadioButton.class, "radio_displaygroup_origin")).setPosition((float)control_hpos, (float)(this.control_grid_row_positions[1] + radiobutton_offset_v))).setSize(radiobutton_size, radiobutton_size).setSpacingColumn(radiobutton_spacing).setSpacingRow(radiobutton_spacing);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[44]);
            control_hpos = this.control_grid_column_positions[45];
            ((ScrollableList)((ScrollableList)((ScrollableList)Display_Builder_4.this.ui.dropdownlist_parent_group.setPosition((float)this.control_grid_column_positions[53], (float)this.control_grid_row_positions[0])).setWidth(this.get_grid_width(10.0f))).setHeight(this.get_grid_width(6.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_parent")).setPosition((float)this.get_grid_width(44.75f), (float)this.control_grid_row_positions[0])).setFont(ui_font);
            ((RadioButton)((RadioButton)this.controls.get(RadioButton.class, "radio_displaygroup_alignment")).setPosition((float)this.control_grid_column_positions[45], (float)(this.control_grid_row_positions[1] + radiobutton_offset_v))).setSize(radiobutton_size, radiobutton_size).setSpacingColumn(radiobutton_spacing).setSpacingRow(radiobutton_spacing);
            control_hpos = this.control_grid_column_positions[49];
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_origin_h")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_origin_v")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setFont(ui_font);
            control_hpos = this.control_grid_column_positions[56];
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_origin_offset_h_px")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_origin_offset_h_px")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_origin_offset_h_px")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_origin_offset_v_px")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(2.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_origin_offset_v_px")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_origin_offset_v_px")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[60];
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_origin_offset_reset")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1] + (float)row_height * 0.5f)).setSize(button_width_med, control_height)).setFont(ui_font);
            current_tab_id = 5;
            this.divider_positions[current_tab_id] = new int[0];
            control_hpos = this.control_grid_column_positions[1];
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_view_guideimages")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_view_guideimages")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_view_guideimages")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_view_guidelines")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_view_guidelines")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_view_guidelines")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_mouse_coords_overlay")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_mouse_coords_overlay")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_mouse_coords_overlay")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.get_grid_width(9.0f));
            control_hpos = this.control_grid_column_positions[10];
            int colourpicker_position_y = this.get_ui_pane_origin() - this.colourpicker_size;
            if (Display_Builder_4.this.ui_elements.pane_position_screen_top.booleanValue()) {
                colourpicker_position_y = this.get_ui_pane_origin() + Display_Builder_4.this.ui_elements.pane_height;
            }
            ((ColorWheel)this.controls.get(ColorWheel.class, "colourwheel")).setPosition((float)(Display_Builder_4.this.width / 2 - this.colourpicker_size / 2), (float)colourpicker_position_y);
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_current_displaygroup_solo")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_current_displaygroup_solo")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_current_displaygroup_solo")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_overlay_parent_links")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_overlay_parent_links")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_overlay_parent_links")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_display_info")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_display_info")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_display_info")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[18];
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_overlay_display_spacing")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_overlay_display_spacing")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_overlay_display_spacing")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_display_info_crop")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_display_info_crop")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_display_info_crop")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_displaygroup_43_marks")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_displaygroup_43_marks")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_displaygroup_43_marks")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[25] + this.get_grid_width(0.5f);
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[25]);
            ((Slider)((Slider)this.controls.get(Slider.class, "slider_stage_scale")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(10.0f), this.get_grid_width(1.0f)).setFont(ui_font);
            ((Slider)this.controls.get(Slider.class, (String)"slider_stage_scale")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-10.0f);
            ((Slider)this.controls.get(Slider.class, (String)"slider_stage_scale")).getCaptionLabel().getStyle().marginTop = row_height * -1;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_auto_scale")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_auto_scale")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_auto_scale")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[36]);
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_view_ui_grid_pixel")).setPosition((float)this.control_grid_column_positions[37], (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_view_ui_grid_pixel")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_view_ui_grid_pixel")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_grid_h_px")).setPosition((float)this.control_grid_column_positions[38], (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(2.0f), this.get_grid_width(1.0f)).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_grid_h_px")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-1.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_grid_h_px")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_grid_v_px")).setPosition((float)this.control_grid_column_positions[38], (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(2.0f), this.get_grid_width(1.0f)).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_grid_v_px")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-1.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_grid_v_px")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[45];
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[44]);
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_view_ui_grid_physical")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_view_ui_grid_physical")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_view_ui_grid_physical")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_physical_grid_alignment")).setPosition((float)(control_hpos - 2), (float)this.control_grid_row_positions[1])).setFont(ui_font);
            ((RadioButton)((RadioButton)this.controls.get(RadioButton.class, "radio_physical_grid_alignment")).setPosition((float)control_hpos, (float)(this.control_grid_row_positions[2] + radiobutton_offset_v))).setSize(radiobutton_size, radiobutton_size).setSpacingColumn(radiobutton_spacing).setSpacingRow(radiobutton_spacing);
            control_hpos = this.control_grid_column_positions[51];
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_physical_grid_offset_h")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(2.0f), this.get_grid_width(1.0f)).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_physical_grid_offset_h")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-1.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_physical_grid_offset_h")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_physical_grid_offset_v")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setSize(this.get_grid_width(2.0f), this.get_grid_width(1.0f)).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_physical_grid_offset_v")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-1.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_physical_grid_offset_v")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[54]);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_view_colours")).setPosition((float)this.control_grid_column_positions[55], (float)this.control_grid_row_positions[0])).setFont(ui_font);
            control_hpos = this.control_grid_column_positions[61];
            ((Bang)((Bang)((Bang)((Bang)this.controls.get(Bang.class, "bang_swatch_grid_pixel")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setWidth(button_width_small)).setHeight(button_width_small)).setFont(ui_font);
            ((Bang)this.controls.get(Bang.class, (String)"bang_swatch_grid_pixel")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-6.0f);
            ((Bang)this.controls.get(Bang.class, (String)"bang_swatch_grid_pixel")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Bang)((Bang)((Bang)((Bang)this.controls.get(Bang.class, "bang_swatch_grid_physical")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setWidth(button_width_small)).setHeight(button_width_small)).setFont(ui_font);
            ((Bang)this.controls.get(Bang.class, (String)"bang_swatch_grid_physical")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-6.0f);
            ((Bang)this.controls.get(Bang.class, (String)"bang_swatch_grid_physical")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Bang)((Bang)((Bang)((Bang)this.controls.get(Bang.class, "bang_swatch_surface")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setWidth(button_width_small)).setHeight(button_width_small)).setFont(ui_font);
            ((Bang)this.controls.get(Bang.class, (String)"bang_swatch_surface")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-6.0f);
            ((Bang)this.controls.get(Bang.class, (String)"bang_swatch_surface")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            current_tab_id = 6;
            this.divider_positions[current_tab_id] = new int[0];
            control_hpos = this.control_grid_column_positions[1];
            ((ScrollableList)((ScrollableList)((ScrollableList)Display_Builder_4.this.ui.dropdownlist_export_grid_unit.setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setWidth(this.get_grid_width(5.5f))).setHeight(this.get_grid_width(7.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_export_lineup_grid_fit_squares")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setSize(this.get_grid_width(5.5f), control_height)).setFont(ui_font);
            control_hpos = this.control_grid_column_positions[4];
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_lineup_grid_size")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.5f), this.get_grid_width(1.0f)).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_lineup_grid_size")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-3.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_lineup_grid_size")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_lineup_marker_interval")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(1.5f), this.get_grid_width(1.0f)).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_lineup_marker_interval")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(-3.0f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_lineup_marker_interval")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[6];
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_lineup_grid_unit_h")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_lineup_grid_unit_v")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_lineup_grid_line_width")).setPosition((float)(control_hpos + this.get_grid_width(1.0f)), (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f)).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_lineup_grid_line_width")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_lineup_grid_line_width")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[10]);
            control_hpos = this.control_grid_column_positions[11];
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_grid_use_display_colours")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_grid_use_display_colours")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_grid_use_display_colours")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_grid_use_grid_colour")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_grid_use_grid_colour")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_grid_use_grid_colour")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_invert_grid_colour")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_invert_grid_colour")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_invert_grid_colour")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_grid_crosshatch_show")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_grid_crosshatch_show")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_grid_crosshatch_show")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[21]);
            control_hpos = this.control_grid_column_positions[22];
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_displaygroup_id")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_displaygroup_id")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_displaygroup_id")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_displaygroup_name")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_displaygroup_name")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_displaygroup_name")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_info_overlay")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_info_overlay")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_info_overlay")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[31];
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_display_id")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_display_id")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_display_id")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_column_row_numbers")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_column_row_numbers")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_column_row_numbers")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_display_coordinates")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_display_coordinates")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_display_coordinates")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_softedge_text")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_softedge_text")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_show_softedge_text")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            this.divider_positions[current_tab_id] = Display_Builder_4.append((int[])this.divider_positions[current_tab_id], (int)this.control_grid_column_positions[41]);
            control_hpos = this.control_grid_column_positions[42];
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_display_data")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_display_data")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_display_data")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_pixel_grid")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_pixel_grid")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_pixel_grid")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_physical_grid")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_physical_grid")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_physical_grid")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_psd_jsx")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[3])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_psd_jsx")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_psd_jsx")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.control_grid_column_positions[49];
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_colourbars")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[1])).setSize(this.get_grid_width(1.0f), this.get_grid_width(1.0f))).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_colourbars")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(1.5f);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_export_colourbars")).getCaptionLabel().getStyle().marginTop = label_offset_y;
            control_hpos = this.get_grid_width(48.5f);
            ((ScrollableList)((ScrollableList)((ScrollableList)Display_Builder_4.this.ui.dropdownlist_export_formats.setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setWidth(this.get_grid_width(8.0f))).setHeight(this.get_grid_width(7.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font);
            control_hpos = this.get_grid_width(58.0f);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_display_data_copy")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[0])).setSize(button_width_large, button_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_display_data_export")).setPosition((float)control_hpos, (float)this.control_grid_row_positions[2])).setSize(button_width_large, button_height)).setFont(ui_font);
        }

        public void update_colour_swatches() {
            if (Display_Builder_4.this.project.current_displaygroup != null) {
                ((Bang)this.controls.get(Bang.class, "bang_swatch_display_outline")).setColorForeground(Display_Builder_4.this.project.current_displaygroup.colour_get());
                ((Bang)this.controls.get(Bang.class, "bang_swatch_display_outline")).setColorActive(Display_Builder_4.this.project.current_displaygroup.colour_get());
            } else {
                ((Bang)this.controls.get(Bang.class, "bang_swatch_display_outline")).setColorForeground(Display_Builder_4.this.ui.colour_get_by_name("display_stroke"));
                ((Bang)this.controls.get(Bang.class, "bang_swatch_display_outline")).setColorActive(Display_Builder_4.this.ui.colour_get_by_name("display_stroke"));
            }
            ((Bang)this.controls.get(Bang.class, "bang_swatch_grid_pixel")).setColorForeground(Display_Builder_4.this.ui.colour_get_by_name("grid_line_pixel"));
            ((Bang)this.controls.get(Bang.class, "bang_swatch_grid_pixel")).setColorActive(Display_Builder_4.this.ui.colour_get_by_name("grid_line_pixel"));
            ((Bang)this.controls.get(Bang.class, "bang_swatch_grid_physical")).setColorForeground(Display_Builder_4.this.ui.colour_get_by_name("grid_line_physical"));
            ((Bang)this.controls.get(Bang.class, "bang_swatch_grid_physical")).setColorActive(Display_Builder_4.this.ui.colour_get_by_name("grid_line_physical"));
            ((Bang)this.controls.get(Bang.class, "bang_swatch_surface")).setColorForeground(Display_Builder_4.this.ui.colour_get_by_name("surface_stroke"));
            ((Bang)this.controls.get(Bang.class, "bang_swatch_surface")).setColorActive(Display_Builder_4.this.ui.colour_get_by_name("surface_stroke"));
        }

        public void displaygroup_menu_update() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                String[] displaygroup_names = Display_Builder_4.this.project.displaygroup_names_get();
                String menu_text = "";
                Display_Builder_4.this.ui.dropdownlist_display_groups.clear();
                int i = 0;
                while (i < displaygroup_names.length) {
                    menu_text = String.valueOf(i + 1) + ": " + displaygroup_names[i];
                    Display_Builder_4.this.ui.dropdownlist_display_groups.addItem(menu_text, (Object)i);
                    if (i == Display_Builder_4.this.project.current_displaygroup_id) {
                        ((ScrollableList)this.controls.get(ScrollableList.class, "menu_displaygroups")).setCaptionLabel(Display_Builder_4.this.truncate_string(menu_text, 25));
                    }
                    ++i;
                }
            }
        }

        public void update_displaygroups_lock_status() {
            Boolean multiple_displaygroups_exist = Display_Builder_4.this.project.display_groups.size() > 1;
            Display_Builder_4.this.ui.dropdownlist_display_groups.setLock(multiple_displaygroups_exist == false);
            ((Button)this.controls.get(Button.class, "button_display_group_delete")).setLock(multiple_displaygroups_exist == false);
        }

        public void update_displaycolouroptions_menu() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((ScrollableList)Display_Builder_4.this.ui.dropdownlist_display_colour_options.setBroadcast(false)).setValue((float)Display_Builder_4.this.project.current_displaygroup.display_colour_mode).setBroadcast(true);
            }
        }

        public void update_display_layout_order() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                if (!Display_Builder_4.this.project.current_displaygroup.display_invert_cols_rows.booleanValue()) {
                    ((Button)this.controls.get(Button.class, "button_invert_cols_rows_layout")).setCaptionLabel("H/V ORDER");
                } else {
                    ((Button)this.controls.get(Button.class, "button_invert_cols_rows_layout")).setCaptionLabel("V/H ORDER");
                }
            }
        }

        public void update_display_dimensions() {
            if (Display_Builder_4.this.ui.ready.booleanValue() && Display_Builder_4.this.ui.active.booleanValue()) {
                ((Textfield)this.controls.get(Textfield.class, "textfield_display_width_resolution")).setText(Display_Builder_4.nf((float)Display_Builder_4.this.project.current_displaygroup.display_resolution.x));
                ((Textfield)this.controls.get(Textfield.class, "textfield_display_height_resolution")).setText(Display_Builder_4.nf((float)Display_Builder_4.this.project.current_displaygroup.display_resolution.y));
                ((Textfield)this.controls.get(Textfield.class, "textfield_display_width_physical")).setText(Display_Builder_4.this.physical_dimension_get_as_string(Display_Builder_4.this.project.current_displaygroup.display_dimensions_physical.x));
                ((Textfield)this.controls.get(Textfield.class, "textfield_display_height_physical")).setText(Display_Builder_4.this.physical_dimension_get_as_string(Display_Builder_4.this.project.current_displaygroup.display_dimensions_physical.y));
                ((Textlabel)this.controls.get(Textlabel.class, "label_resolution_pixel_count")).setText("TOTAL:    " + Display_Builder_4.nfc((int)Display_Builder_4.this.project.current_displaygroup.display_pixel_count_get()) + " px");
                int status_colour = Display_Builder_4.this.get_colour_from_status(Display_Builder_4.this.project.current_displaygroup.display_aspect_ratio_locked, true);
                ((Bang)((Bang)this.controls.get(Bang.class, "bang_display_aspect_locked")).setColorForeground(status_colour)).setColorActive(status_colour);
                ((Textlabel)this.controls.get(Textlabel.class, "label_resolution_aspect_ratio")).setText("Ratio: " + Display_Builder_4.this.aspect_ratio_as_string(Display_Builder_4.this.project.current_displaygroup.display_aspect_ratio.floatValue()));
                ((Textlabel)this.controls.get(Textlabel.class, "label_stage_size")).setText("STAGE SIZE: " + Display_Builder_4.nf((float)(Display_Builder_4.this.project.current_displaygroup.stage_scale * 100.0f), (int)1, (int)2) + "%");
                ((Textfield)this.controls.get(Textfield.class, "textfield_display_width_stage")).setText(Display_Builder_4.nf((float)Display_Builder_4.this.project.current_displaygroup.display_dimensions_stage.x));
                ((Textfield)this.controls.get(Textfield.class, "textfield_display_height_stage")).setText(Display_Builder_4.nf((float)Display_Builder_4.this.project.current_displaygroup.display_dimensions_stage.y));
                if (Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                    ((Textlabel)this.controls.get(Textlabel.class, "label_pixel_size")).setText(String.valueOf(Display_Builder_4.nf((float)Display_Builder_4.this.project.current_displaygroup.display_pixel_density, (int)1, (int)2)) + " mm/px\n\n" + Display_Builder_4.this.project.current_displaygroup.physical_scale + " px/m");
                } else {
                    ((Textlabel)this.controls.get(Textlabel.class, "label_pixel_size")).setText("N/A mm/px");
                }
                if (Display_Builder_4.this.project.current_displaygroup.stage_scale_active().booleanValue()) {
                    ((Button)this.controls.get(Button.class, "button_stagesize_reset")).setLock(false);
                    ((Textfield)this.controls.get(Textfield.class, "textfield_display_width_stage")).setColorBackground(Display_Builder_4.this.ui.colour_get_by_name("ui_element_warning"));
                    ((Textfield)this.controls.get(Textfield.class, "textfield_display_height_stage")).setColorBackground(Display_Builder_4.this.ui.colour_get_by_name("ui_element_warning"));
                } else {
                    ((Button)this.controls.get(Button.class, "button_stagesize_reset")).setLock(true);
                    ((Textfield)this.controls.get(Textfield.class, "textfield_display_width_stage")).setColorBackground(Display_Builder_4.this.ui.colour_get_by_name("ui_element_default"));
                    ((Textfield)this.controls.get(Textfield.class, "textfield_display_height_stage")).setColorBackground(Display_Builder_4.this.ui.colour_get_by_name("ui_element_default"));
                }
                float display_area_physical = Display_Builder_4.this.project.current_displaygroup.display_dimensions_physical.x * Display_Builder_4.this.project.current_displaygroup.display_dimensions_physical.y;
                ((Textlabel)this.controls.get(Textlabel.class, "label_display_physical_area")).setText("Area: " + Display_Builder_4.nf((float)display_area_physical, (int)1, (int)2) + " m2");
            }
        }

        public void update_display_settings() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Textfield)this.controls.get(Textfield.class, "textfield_display_basename")).setText(Display_Builder_4.this.project.current_displaygroup.display_basename);
                ((Textfield)this.controls.get(Textfield.class, "textfield_display_baseip")).setText(Display_Builder_4.this.project.current_displaygroup.player_name_prefix);
                ((Textfield)this.controls.get(Textfield.class, "textfield_multi_output")).setText(Integer.toString(Display_Builder_4.this.project.current_displaygroup.player_outputs_count));
                ((Textfield)this.controls.get(Textfield.class, "textfield_display_startip")).setText(Integer.toString(Display_Builder_4.this.project.current_displaygroup.player_start_number));
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_player_outputs_shared")).setBroadcast(false)).setValue(Display_Builder_4.this.project.current_displaygroup.player_outputs_sharing.booleanValue()).setBroadcast(true);
            }
        }

        public void update_export_controls() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_grid_use_display_colours")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_grid_use_display_colours.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_grid_use_grid_colour")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_grid_use_grid_colour.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_invert_grid_colour")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_grid_invert_colour.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_display_id")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_show_display_id.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_displaygroup_id")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_show_displaygroup_id.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_displaygroup_name")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_show_displaygroup_name.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_display_coordinates")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_show_display_coordinates.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_show_column_row_numbers")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_show_column_row_numbers.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_display_data")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_display_data.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_pixel_grid")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_pixel_grid.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_physical_grid")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_physical_grid.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_colourbars")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_colourbars.booleanValue()).setBroadcast(true);
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_export_psd_jsx")).setBroadcast(false)).setValue(Display_Builder_4.this.project.pref_export_psd_jsx.booleanValue()).setBroadcast(true);
            }
        }

        public void update_export_alignment_grid_controls() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                Display_Builder_4.this.ui.dropdownlist_export_grid_unit.setValue((float)Display_Builder_4.this.project.pref_export_grid_cell_unit);
                ((Textfield)this.controls.get(Textfield.class, "textfield_lineup_grid_size")).setText(Integer.toString(Display_Builder_4.this.project.pref_export_grid_cell_size));
                ((Textfield)this.controls.get(Textfield.class, "textfield_lineup_marker_interval")).setText(Integer.toString(Display_Builder_4.this.project.pref_export_grid_marker_interval));
                ((Textfield)this.controls.get(Textfield.class, "textfield_lineup_grid_line_width")).setText(Integer.toString(Display_Builder_4.this.project.pref_export_grid_line_width));
                switch (Display_Builder_4.this.project.pref_export_grid_cell_unit) {
                    case 1: {
                        ((Textlabel)this.controls.get(Textlabel.class, "label_lineup_grid_unit_h")).setText("PIXELS");
                        ((Textlabel)this.controls.get(Textlabel.class, "label_lineup_grid_unit_v")).setText("PIXELS");
                        break;
                    }
                    case 2: {
                        ((Textlabel)this.controls.get(Textlabel.class, "label_lineup_grid_unit_h")).setText("CELLS");
                        ((Textlabel)this.controls.get(Textlabel.class, "label_lineup_grid_unit_v")).setText("CELLS");
                    }
                }
            }
        }

        public void grid_pixel_dimensions_update() {
            ((Textfield)this.controls.get(Textfield.class, "textfield_grid_h_px")).setText(Integer.toString(Display_Builder_4.this.project.pref_ui_grid_size_h));
            ((Textfield)this.controls.get(Textfield.class, "textfield_grid_v_px")).setText(Integer.toString(Display_Builder_4.this.project.pref_ui_grid_size_v));
        }

        public void update_guide_controls() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                if (Display_Builder_4.this.project.current_guide != null) {
                    this.update_guide_controls_position();
                    this.update_guide_controls_rotation();
                    this.update_guide_controls_scale();
                    ((Slider)((Slider)this.controls.get(Slider.class, "slider_guide_opacity")).setBroadcast(false)).setValue(Display_Builder_4.this.project.current_guide.opacity).setBroadcast(true);
                    Display_Builder_4.this.ui.dropdownlist_guide_parent.setValue((float)(Display_Builder_4.this.project.current_guide.parent_id + 1));
                    ((Textlabel)this.controls.get(Textlabel.class, "label_guide_info")).setText(Display_Builder_4.this.project.current_guide.name_get());
                    int status_colour = Display_Builder_4.this.get_colour_from_status(Display_Builder_4.this.project.current_guide.locked, true);
                    ((Bang)((Bang)((Bang)this.controls.get(Bang.class, "bang_guide_locked")).setColorForeground(status_colour)).setColorActive(status_colour)).setLabel(Display_Builder_4.this.status_lock_get_as_text(Display_Builder_4.this.project.current_guide.locked));
                    switch (Display_Builder_4.this.project.current_guide.get_type()) {
                        case 0: {
                            ((Knob)this.controls.get(Knob.class, "knob_guide_rotation")).setLock(false);
                            ((Textlabel)this.controls.get(Textlabel.class, "label_guide_rotation_value")).setText(Display_Builder_4.this.project.current_guide.get_rotation_text());
                            ((Slider)this.controls.get(Slider.class, "slider_image_scale")).setLock(false);
                            ((Bang)this.controls.get(Bang.class, "bang_swatch_guide")).setLock(true);
                            ((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_x")).setLock(false);
                            ((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_y")).setLock(false);
                            break;
                        }
                        case 1: {
                            ((Knob)this.controls.get(Knob.class, "knob_guide_rotation")).setLock(true);
                            ((Textlabel)this.controls.get(Textlabel.class, "label_guide_rotation_value")).setText("");
                            ((Slider)this.controls.get(Slider.class, "slider_image_scale")).setLock(true);
                            ((Bang)this.controls.get(Bang.class, "bang_swatch_guide")).setLock(false);
                            ((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_x")).setLock(false);
                            ((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_y")).setLock(false);
                            break;
                        }
                        case 2: {
                            ((Knob)this.controls.get(Knob.class, "knob_guide_rotation")).setLock(true);
                            ((Textlabel)this.controls.get(Textlabel.class, "label_guide_rotation_value")).setLock(true);
                            ((Slider)this.controls.get(Slider.class, "slider_image_scale")).setLock(true);
                            ((Bang)this.controls.get(Bang.class, "bang_swatch_guide")).setLock(false);
                            ((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_x")).setLock(true);
                            ((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_y")).setLock(true);
                        }
                    }
                } else {
                    ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_x")).setBroadcast(false)).setText("0").setBroadcast(true);
                    ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_y")).setBroadcast(false)).setText("0").setBroadcast(true);
                    ((Knob)((Knob)this.controls.get(Knob.class, "knob_guide_rotation")).setBroadcast(false)).setValue(1.5707964f).setBroadcast(true);
                    ((Slider)((Slider)this.controls.get(Slider.class, "slider_image_scale")).setBroadcast(false)).setValue(100.0f).setBroadcast(true);
                    ((Slider)((Slider)this.controls.get(Slider.class, "slider_guide_opacity")).setBroadcast(false)).setValue(50.0f).setBroadcast(true);
                    ((Textlabel)this.controls.get(Textlabel.class, "label_guide_info")).setText("- NO GUIDES AVAILABLE -");
                }
                Display_Builder_4.this.ui_elements.update_guide_swatch();
            }
        }

        public void update_guide_controls_disabled(Boolean disabled) {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_x")).setLock(disabled.booleanValue());
                ((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_y")).setLock(disabled.booleanValue());
                ((Knob)this.controls.get(Knob.class, "knob_guide_rotation")).setLock(disabled.booleanValue());
                ((Slider)this.controls.get(Slider.class, "slider_image_scale")).setLock(disabled.booleanValue());
                ((Slider)this.controls.get(Slider.class, "slider_guide_opacity")).setLock(disabled.booleanValue());
                ((Bang)this.controls.get(Bang.class, "bang_guide_locked")).setLock(disabled.booleanValue());
                ((Bang)this.controls.get(Bang.class, "bang_swatch_guide")).setLock(disabled.booleanValue());
                ((Button)this.controls.get(Button.class, "button_guide_delete")).setLock(disabled.booleanValue());
            }
        }

        public void update_guide_controls_position() {
            if (Display_Builder_4.this.project.current_guide != null && Display_Builder_4.this.ui.ready.booleanValue()) {
                PVector guide_position = Display_Builder_4.this.project.current_guide.get_position().copy();
                ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_x")).setBroadcast(false)).setText(Display_Builder_4.this.get_float_as_integer_string(guide_position.x)).setBroadcast(true);
                ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_guide_position_y")).setBroadcast(false)).setText(Display_Builder_4.this.get_float_as_integer_string(guide_position.y)).setBroadcast(true);
            }
        }

        public void update_guide_controls_rotation() {
            if (Display_Builder_4.this.project.current_guide != null && Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Knob)((Knob)this.controls.get(Knob.class, "knob_guide_rotation")).setBroadcast(false)).setValue(Display_Builder_4.this.project.current_guide.rotation + 1.5707964f).setBroadcast(true);
                ((Textlabel)this.controls.get(Textlabel.class, "label_guide_rotation_value")).setText(Display_Builder_4.this.project.current_guide.get_rotation_text());
            }
        }

        public void update_guide_controls_scale() {
            if (Display_Builder_4.this.project.current_guide != null && Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Slider)((Slider)this.controls.get(Slider.class, "slider_image_scale")).setBroadcast(false)).setValue(Display_Builder_4.this.project.current_guide.scale * 100.0f).setBroadcast(true);
            }
        }

        public void update_guide_menu() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                Display_Builder_4.this.debug_output("update_guide_menu");
                Boolean controls_disabled = true;
                int guide_count = Display_Builder_4.this.project.guides.size();
                String menu_text = "";
                String guide_name = "";
                String guide_name_truncated = "";
                Display_Builder_4.this.ui.dropdownlist_guides.setBroadcast(false);
                Display_Builder_4.this.ui.dropdownlist_guides.clear();
                Display_Builder_4.this.ui.dropdownlist_guides.setOpen(false);
                if (guide_count > 0) {
                    controls_disabled = false;
                    int i = 0;
                    while (i < guide_count) {
                        Guide guide = Display_Builder_4.this.project.guides.get(i);
                        guide_name = guide.get_text();
                        guide_name_truncated = Display_Builder_4.this.truncate_string(guide_name, 22);
                        menu_text = String.valueOf(i + 1) + ": " + guide_name;
                        Display_Builder_4.this.ui.dropdownlist_guides.addItem(menu_text, (Object)i);
                        if (guide.id == Display_Builder_4.this.project.current_guide.id) {
                            Display_Builder_4.this.ui.dropdownlist_guides.setCaptionLabel(guide_name_truncated);
                        }
                        ++i;
                    }
                    if (guide_count > 1) {
                        Display_Builder_4.this.ui.dropdownlist_guides.setLock(false);
                    }
                } else {
                    ((ScrollableList)Display_Builder_4.this.ui.dropdownlist_guides.setCaptionLabel("GUIDES")).setLock(true);
                }
                Display_Builder_4.this.ui.dropdownlist_guides.setBroadcast(true);
                this.update_guide_controls_disabled(controls_disabled);
            }
        }

        public void update_guide_swatch() {
            if (Display_Builder_4.this.project.current_guide != null) {
                ((Bang)this.controls.get(Bang.class, "bang_swatch_guide")).setColorForeground(Display_Builder_4.this.project.current_guide.colour_get());
                ((Bang)this.controls.get(Bang.class, "bang_swatch_guide")).setColorActive(Display_Builder_4.this.project.current_guide.colour_get());
            }
        }

        public void physical_controls_lock(Boolean lock_state) {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Textfield)this.controls.get(Textfield.class, "textfield_softedge_h_physical")).setLock(lock_state.booleanValue());
                ((Textfield)this.controls.get(Textfield.class, "textfield_softedge_v_physical")).setLock(lock_state.booleanValue());
                ((Toggle)this.controls.get(Toggle.class, "toggle_view_ui_grid_physical")).setLock(lock_state.booleanValue());
                ((Toggle)this.controls.get(Toggle.class, "toggle_export_physical_grid")).setLock(lock_state.booleanValue());
                if (lock_state.booleanValue()) {
                    ((RadioButton)this.controls.get(RadioButton.class, "radio_physical_grid_alignment")).deactivateAll();
                } else {
                    if (Display_Builder_4.this.project.physical_grid.alignment_id_get() >= 0) {
                        ((RadioButton)this.controls.get(RadioButton.class, "radio_physical_grid_alignment")).activate(Display_Builder_4.this.project.physical_grid.alignment_id_get());
                    }
                    this.update_physical_grid_offset();
                }
            }
        }

        public void physical_controls_update() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_view_ui_grid_physical")).setBroadcast(false)).setValue(Display_Builder_4.this.project.physical_grid.visibility_get().booleanValue()).setBroadcast(true);
                this.update_physical_grid_offset();
            }
        }

        public void update_physical_grid_offset() {
            PVector physical_grid_offsets = Display_Builder_4.this.project.physical_grid.origins_offset_get();
            ((Textfield)this.controls.get(Textfield.class, "textfield_physical_grid_offset_h")).setText(Display_Builder_4.nfp((float)physical_grid_offsets.x, (int)1, (int)2));
            ((Textfield)this.controls.get(Textfield.class, "textfield_physical_grid_offset_v")).setText(Display_Builder_4.nfp((float)physical_grid_offsets.y, (int)1, (int)2));
        }

        public void update_project_load_mode_toggle(Boolean mode_status) {
            if (mode_status.booleanValue()) {
                ((Button)this.controls.get(Button.class, "button_project_load_mode")).setCaptionLabel("OVERWRITE");
            } else {
                ((Button)this.controls.get(Button.class, "button_project_load_mode")).setCaptionLabel("APPEND");
            }
        }

        public void update_project_filepath() {
            Display_Builder_4.this.ui.ready.booleanValue();
        }

        public void update_project_summary(String project_summary_text, String text_project_summary_tooltip) {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Textlabel)this.controls.get(Textlabel.class, "label_project_summary_data")).setText(project_summary_text);
                Display_Builder_4.this.ui_elements.control_tooltips.set("label_project_summary_data", text_project_summary_tooltip);
            }
        }

        public void update_scale_slider() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Slider)((Slider)this.controls.get(Slider.class, "slider_stage_scale")).setBroadcast(false)).setValue(Display_Builder_4.this.ui.viewport_scale).setBroadcast(true);
            }
        }

        public void update_surface_physical_dimensions() {
            if (Display_Builder_4.this.ui.ready.booleanValue() && Display_Builder_4.this.ui.active.booleanValue()) {
                PVector surface_dimensions = Display_Builder_4.this.project.current_displaygroup.projection_surface_dimensions_physical_get();
                Display_Builder_4.this.debug_output("Current DisplayGroup surface dimensions: " + surface_dimensions.x + ", " + surface_dimensions.y);
                if (surface_dimensions.x > 0.0f) {
                    ((Textfield)this.controls.get(Textfield.class, "textfield_group_surface_h_physical")).setLock(false);
                    ((Textfield)this.controls.get(Textfield.class, "textfield_group_surface_v_physical")).setLock(false);
                } else {
                    ((Textlabel)this.controls.get(Textlabel.class, "label_display_physical_area")).setText("");
                }
                if (Display_Builder_4.this.ui.ready.booleanValue()) {
                    ((Textfield)this.controls.get(Textfield.class, "textfield_group_surface_h_physical")).setText(Display_Builder_4.this.get_formatted_float_string(surface_dimensions.x));
                    ((Textfield)this.controls.get(Textfield.class, "textfield_group_surface_v_physical")).setText(Display_Builder_4.this.get_formatted_float_string(surface_dimensions.y));
                    ((Textlabel)this.controls.get(Textlabel.class, "label_group_surface_area_physical")).setText(String.valueOf(Display_Builder_4.this.get_formatted_float_string(surface_dimensions.x * surface_dimensions.y)) + " m2");
                }
            }
        }

        public void update_display_counts() {
            ((Textfield)this.controls.get(Textfield.class, "textfield_display_count_h")).setText(Integer.toString(Display_Builder_4.this.project.current_displaygroup.display_cols));
            ((Textfield)this.controls.get(Textfield.class, "textfield_display_count_v")).setText(Integer.toString(Display_Builder_4.this.project.current_displaygroup.display_rows));
        }

        public void display_summary_update(String control_text, String tooltip_text) {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Textlabel)this.controls.get(Textlabel.class, "label_displays_count_summary")).setText(control_text);
                Display_Builder_4.this.ui_elements.control_tooltips.set("label_displays_count_summary", tooltip_text);
            }
        }

        public void update_menu_displaygroup_parent() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                String[] displaygroup_names = Display_Builder_4.this.project.displaygroup_names_get();
                String menu_text = "Stage";
                String caption_text = "Stage";
                Display_Builder_4.this.ui.dropdownlist_parent_group.clear();
                Display_Builder_4.this.ui.dropdownlist_parent_group.addItem("Stage", (Object)-1);
                Display_Builder_4.this.ui.dropdownlist_guide_parent.clear();
                Display_Builder_4.this.ui.dropdownlist_guide_parent.addItem("Stage", (Object)-1);
                int i = 0;
                while (i < displaygroup_names.length) {
                    menu_text = String.valueOf(i + 1) + ": " + displaygroup_names[i];
                    if (i != Display_Builder_4.this.project.current_displaygroup_id && i < Display_Builder_4.this.project.current_displaygroup_id) {
                        Display_Builder_4.this.ui.dropdownlist_parent_group.addItem(menu_text, (Object)i);
                    }
                    Display_Builder_4.this.ui.dropdownlist_guide_parent.addItem(menu_text, (Object)i);
                    ++i;
                }
                if (Display_Builder_4.this.project.current_displaygroup.parent_group_id >= 0) {
                    caption_text = String.valueOf(Display_Builder_4.this.project.current_displaygroup.parent_group_id + 1) + ": " + displaygroup_names[Display_Builder_4.this.project.current_displaygroup.parent_group_id];
                }
                ((ScrollableList)this.controls.get(ScrollableList.class, "menu_displaygroup_parent")).setCaptionLabel(caption_text);
            }
        }

        public void menu_display_type_label_update() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                String control_label = "Display Type";
                if (Display_Builder_4.this.project.current_displaygroup != null) {
                    control_label = Display_Builder_4.this.ui.labels_display_types[Display_Builder_4.this.project.current_displaygroup.display_type];
                }
                ((ScrollableList)((ScrollableList)((ScrollableList)this.controls.get(ScrollableList.class, "menu_display_type")).setLock(false)).setCaptionLabel(control_label)).setLock(true);
            }
        }

        public void menu_export_format_label_update() {
            String control_label = "Export Format";
            control_label = Display_Builder_4.this.export_manager.export_format_list_label_get_current();
            ((ScrollableList)this.controls.get(ScrollableList.class, "menu_export_format")).setCaptionLabel(control_label);
        }

        public void resolutions_menu_label_update() {
            String control_label = "Custom Resolution";
            if (Display_Builder_4.this.project.current_displaygroup.resolution != null) {
                control_label = String.valueOf(Display_Builder_4.round((float)Display_Builder_4.this.project.current_displaygroup.resolution.pixel_count.x)) + "x" + Display_Builder_4.round((float)Display_Builder_4.this.project.current_displaygroup.resolution.pixel_count.y);
                control_label = String.valueOf(control_label) + " - " + Display_Builder_4.this.project.current_displaygroup.resolution.name;
            }
            ((ScrollableList)this.controls.get(ScrollableList.class, "menu_resolution_presets")).setCaptionLabel(control_label);
        }

        public void button_resolution_preset_add_lock(Boolean status) {
            ((Button)this.controls.get(Button.class, "button_resolution_preset_add")).setLock(status.booleanValue());
        }

        public void resolutions_menu_update() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                int resolutions_count = Display_Builder_4.this.project.resolutions_list.size();
                int loop_start = 0;
                int loop_end = resolutions_count;
                int loop_increment = 1;
                if (Display_Builder_4.this.project.pref_resolution_list_order_invert.booleanValue()) {
                    loop_start = resolutions_count - 1;
                    loop_end = -1;
                    loop_increment = -1;
                }
                Display_Builder_4.this.ui.dropdownlist_resolutions.clear();
                int i = loop_start;
                while (i != loop_end) {
                    DisplayResolution resolution = Display_Builder_4.this.project.resolutions_list.get(i);
                    String item_label = String.valueOf(Display_Builder_4.round((float)resolution.pixel_count.x)) + "x" + Display_Builder_4.round((float)resolution.pixel_count.y);
                    item_label = String.valueOf(item_label) + " - " + resolution.name;
                    Display_Builder_4.this.ui.dropdownlist_resolutions.addItem(item_label, (Object)resolution.id);
                    i += loop_increment;
                }
                Display_Builder_4.this.ui.dropdownlist_resolutions.setOpen(false);
            }
        }

        public void stagetiers_menu_update() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                Display_Builder_4.this.ui.dropdownlist_stage_tiers.clear();
                for (StageTier tier : Display_Builder_4.this.project.stage_tiers) {
                    Display_Builder_4.this.ui.dropdownlist_stage_tiers.addItem(String.valueOf(Display_Builder_4.this.get_number_from_id(tier.id)) + ": " + Display_Builder_4.this.truncate_string(tier.name, 18), (Object)tier.id);
                }
                Boolean multiple_tiers_exist = Display_Builder_4.this.project.stage_tiers.size() > 1;
                Display_Builder_4.this.ui.dropdownlist_stage_tiers.setLock(multiple_tiers_exist == false);
                ((Button)this.controls.get(Button.class, "button_stagetier_delete")).setLock(multiple_tiers_exist == false);
                this.stagetier_name_update();
            }
        }

        public void stagetier_name_update() {
            if (Display_Builder_4.this.ui.ready.booleanValue() && Display_Builder_4.this.project.current_stage_tier != null) {
                ((Textfield)this.controls.get(Textfield.class, "textfield_stagetier_name")).setText(Display_Builder_4.this.project.current_stage_tier.name);
                ((ScrollableList)this.controls.get(ScrollableList.class, "menu_stagetiers")).setCaptionLabel("Tier: " + Display_Builder_4.this.truncate_string(Display_Builder_4.this.project.current_stage_tier.name, 18));
            }
        }

        public void parent_offset_controls_update() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Textfield)this.controls.get(Textfield.class, "textfield_origin_offset_h_px")).setText(Display_Builder_4.nf((float)Display_Builder_4.this.project.current_displaygroup.parent_offset.x, (int)0, (int)0));
                ((Textfield)this.controls.get(Textfield.class, "textfield_origin_offset_v_px")).setText(Display_Builder_4.nf((float)Display_Builder_4.this.project.current_displaygroup.parent_offset.y, (int)0, (int)0));
            }
        }

        public void update_softedge_controls() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                float softedge_percentage = Display_Builder_4.this.project.current_displaygroup.softedge_values_get("horizontal", "percentage");
                float softedge_physical = Display_Builder_4.this.project.current_displaygroup.softedge_values_get("horizontal", "physical");
                ((Textfield)this.controls.get(Textfield.class, "textfield_softedge_h_px")).setText(Display_Builder_4.nf((float)Display_Builder_4.this.project.current_displaygroup.softedge_dimensions.x, (int)0, (int)0));
                ((Textfield)this.controls.get(Textfield.class, "textfield_softedge_h_pc")).setText(Display_Builder_4.nfs((float)softedge_percentage, (int)1, (int)2));
                ((Textfield)this.controls.get(Textfield.class, "textfield_softedge_h_physical")).setText(Display_Builder_4.this.get_formatted_float_string(softedge_physical));
                softedge_percentage = Display_Builder_4.this.project.current_displaygroup.softedge_values_get("vertical", "percentage");
                softedge_physical = Display_Builder_4.this.project.current_displaygroup.softedge_values_get("vertical", "physical");
                ((Textfield)this.controls.get(Textfield.class, "textfield_softedge_v_px")).setText(Display_Builder_4.nf((float)Display_Builder_4.this.project.current_displaygroup.softedge_dimensions.y, (int)0, (int)0));
                ((Textfield)this.controls.get(Textfield.class, "textfield_softedge_v_pc")).setText(Display_Builder_4.nfs((float)softedge_percentage, (int)1, (int)2));
                ((Textfield)this.controls.get(Textfield.class, "textfield_softedge_v_physical")).setText(Display_Builder_4.this.get_formatted_float_string(softedge_physical));
            }
        }

        public void update_surface_dimensions() {
            if (Display_Builder_4.this.ui.ready.booleanValue() && Display_Builder_4.this.ui.active.booleanValue()) {
                PVector surface_dimensions = new PVector(0.0f, 0.0f);
                String[] surface_mode_labels = new String[]{"AUTOMATIC", "USER SET"};
                switch (Display_Builder_4.this.project.pref_projection_surface_mode) {
                    case 0: {
                        ((Button)this.controls.get(Button.class, "button_surface_fit")).setLock(true);
                        surface_dimensions = Display_Builder_4.this.project.surface_dimensions_get("displaygroup");
                        break;
                    }
                    case 1: {
                        ((Button)this.controls.get(Button.class, "button_surface_fit")).setLock(false);
                        surface_dimensions = Display_Builder_4.this.project.surface_dimensions_get("target");
                    }
                }
                ((Textfield)this.controls.get(Textfield.class, "textfield_projection_surface_h_px")).setText(Display_Builder_4.nf((float)surface_dimensions.x));
                ((Textfield)this.controls.get(Textfield.class, "textfield_projection_surface_v_px")).setText(Display_Builder_4.nf((float)surface_dimensions.y));
                ((Textlabel)this.controls.get(Textlabel.class, "label_group_surface_area_pixels")).setText(String.valueOf(Display_Builder_4.this.human_readable_number_string(Display_Builder_4.round((float)(surface_dimensions.x * surface_dimensions.y)))) + "  PX");
                ((Textlabel)this.controls.get(Textlabel.class, "label_group_surface_area_ratio")).setText("Ratio: " + Display_Builder_4.this.get_formatted_float_string(surface_dimensions.x / surface_dimensions.y));
                if (Display_Builder_4.this.project.physical_settings_active_get().booleanValue()) {
                    ((Textfield)this.controls.get(Textfield.class, "textfield_group_surface_h_physical")).setText(Display_Builder_4.this.get_formatted_float_string(surface_dimensions.x / Display_Builder_4.this.project.viewport_physical_scale));
                    ((Textfield)this.controls.get(Textfield.class, "textfield_group_surface_v_physical")).setText(Display_Builder_4.this.get_formatted_float_string(surface_dimensions.y / Display_Builder_4.this.project.viewport_physical_scale));
                    Float group_surface_are_physical = Float.valueOf(surface_dimensions.x / Display_Builder_4.this.project.viewport_physical_scale * (surface_dimensions.y / Display_Builder_4.this.project.viewport_physical_scale));
                    ((Textlabel)this.controls.get(Textlabel.class, "label_group_surface_area_physical")).setText(String.valueOf(Display_Builder_4.this.get_formatted_float_string(group_surface_are_physical.floatValue())) + " m2");
                    ((Button)this.controls.get(Button.class, "button_project_physical_scale_set")).setLock(false);
                } else {
                    ((Textfield)this.controls.get(Textfield.class, "textfield_group_surface_h_physical")).setText("N/A");
                    ((Textfield)this.controls.get(Textfield.class, "textfield_group_surface_v_physical")).setText("N/A");
                    ((Textlabel)this.controls.get(Textlabel.class, "label_group_surface_area_physical")).setText("N/A");
                    ((Button)this.controls.get(Button.class, "button_project_physical_scale_set")).setLock(true);
                }
                ((Button)this.controls.get(Button.class, "button_surface_mode")).setCaptionLabel(surface_mode_labels[Display_Builder_4.this.project.pref_projection_surface_mode]);
            }
        }

        public void update_all_controls() {
            if (Display_Builder_4.this.ui.ready.booleanValue()) {
                ((Textfield)this.controls.get(Textfield.class, "textfield_project_name")).setText(Display_Builder_4.this.project.pref_project_name);
                this.stagetiers_menu_update();
                this.stagetier_name_update();
                this.update_guide_controls();
                this.displaygroup_menu_update();
                this.update_displaygroups_lock_status();
                if (Display_Builder_4.this.project.current_displaygroup.name != null) {
                    ((Textfield)this.controls.get(Textfield.class, "textfield_display_group_name")).setText(Display_Builder_4.this.project.current_displaygroup.name);
                }
                this.menu_display_type_label_update();
                this.update_display_dimensions();
                this.update_display_settings();
                if (Display_Builder_4.this.project.current_displaygroup.id == 0) {
                    ((RadioButton)this.controls.get(RadioButton.class, "radio_displaygroup_alignment")).deactivateAll();
                } else {
                    ((RadioButton)this.controls.get(RadioButton.class, "radio_displaygroup_alignment")).activate(Display_Builder_4.this.project.current_displaygroup.parent_alignment_id);
                    ((RadioButton)this.controls.get(RadioButton.class, "radio_displaygroup_origin")).activate(Display_Builder_4.this.project.current_displaygroup.anchor_alignment_id);
                }
                this.update_display_layout_order();
                this.update_display_counts();
                this.resolutions_menu_label_update();
                this.update_menu_displaygroup_parent();
                ((Knob)((Knob)this.controls.get(Knob.class, "knob_display_rotation")).setBroadcast(false)).setValue(Display_Builder_4.this.project.current_displaygroup.display_rotation).setBroadcast(true);
                this.update_softedge_controls();
                this.update_surface_dimensions();
                this.update_surface_physical_dimensions();
                this.parent_offset_controls_update();
                this.grid_pixel_dimensions_update();
                this.update_displaycolouroptions_menu();
                this.physical_controls_update();
                if (Display_Builder_4.this.project.current_displaygroup.display_dimensions_physical.x > 0.0f) {
                    this.physical_controls_lock(false);
                }
                this.menu_export_format_label_update();
                this.update_export_alignment_grid_controls();
                this.update_export_controls();
                this.update_colour_swatches();
            }
        }
    }
}

