/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.CP;
import controlP5.CallbackEvent;
import controlP5.CallbackListener;
import controlP5.ControlBehavior;
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlGroup;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlWindow;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerPlug;
import controlP5.ControllerProperty;
import controlP5.ControllerView;
import controlP5.Label;
import controlP5.Numberbox;
import controlP5.Pointer;
import controlP5.Tab;
import controlP5.Textfield;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.KeyEvent;

public abstract class Controller<T>
implements ControllerInterface<T>,
CDrawable,
ControlP5Constants {
    protected float[] position = new float[2];
    protected float[] positionBuffer = new float[2];
    protected float[] absolutePosition = new float[2];
    protected ControllerInterface<?> _myParent;
    protected final String _myName;
    protected ControlWindow _myControlWindow;
    protected boolean isMousePressed = false;
    protected ControlP5 cp5;
    private int width;
    private int height;
    protected int _myId = -1;
    protected float _myValue = Float.NaN;
    protected float _myDefaultValue = Float.NaN;
    protected String _myStringValue = "";
    protected float[] _myArrayValue;
    protected Label _myCaptionLabel;
    protected Label _myValueLabel;
    protected boolean isLabelVisible = true;
    protected boolean isMoveable = true;
    protected boolean isBroadcast = true;
    protected boolean isVisible = true;
    protected boolean isActive = false;
    protected boolean isLock = false;
    protected boolean isUserInteraction = true;
    protected boolean isInit = false;
    protected List<ControlListener> _myControlListener;
    protected Map<Integer, List<CallbackListener>> _myControlListenerLUT;
    protected CColor color = new CColor();
    protected float _myMin;
    protected float _myMax;
    protected float _myUnit;
    protected String target;
    protected Object targetObject;
    protected ControlBehavior _myBehavior;
    protected boolean isBehavior;
    protected List<Controller<?>> subelements;
    protected int _myBroadcastType = 2;
    protected boolean isUpdate = false;
    protected int _myDecimalPoints = 2;
    public static int autoWidth = 49;
    public static int autoHeight = 19;
    public static float[] autoSpacing = new float[]{10.0f, 10.0f};
    protected boolean[] availableImages = new boolean[4];
    protected PImage[] images = new PImage[4];
    protected ControllerView<T> _myControllerView;
    protected ControllerView<T> _myDebugView;
    protected int _myDisplayMode = 0;
    protected int _myPickingColor = -256;
    protected boolean mouseover;
    protected String _myAddress = "";
    protected List<ControllerPlug> _myControllerPlugList;
    protected boolean tooltipEnabled;
    protected boolean listening;
    protected boolean isInside = false;
    private T me;
    protected boolean isDragged;

    public Controller(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 0.0f, autoWidth, autoHeight);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected Controller(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, float f, float f2, int n, int n2) {
        this.cp5 = controlP5;
        this.me = this;
        if (this.cp5 == null) {
            this.isBroadcast = false;
        }
        this._myName = string;
        Controller.set(this.position, f, f2);
        Controller.set(this.positionBuffer, f, f2);
        this.setParent(controllerGroup);
        if (controllerGroup != null) {
            this.color.set(controllerGroup.color);
        } else {
            this.color.set(ControlP5.color);
        }
        this.width = n;
        this.height = n2;
        this._myCaptionLabel = new Label(this.cp5, string);
        this._myCaptionLabel.setColor(this.color.getCaptionLabel());
        this._myValueLabel = new Label(this.cp5, "-");
        this._myValueLabel.setColor(this.color.getCaptionLabel());
        this._myControllerPlugList = new ArrayList<ControllerPlug>();
        this._myControlListener = new ArrayList<ControlListener>();
        this.subelements = new ArrayList();
        this._myArrayValue = new float[0];
        this._myDebugView = new DebugView();
        this.setView(this._myDebugView);
    }

    List<Controller<?>> getSubelements() {
        return this.subelements;
    }

    @Override
    @ControlP5.Layout
    public String getAddress() {
        return this._myAddress;
    }

    @Override
    @ControlP5.Invisible
    @ControlP5.Layout
    public T setAddress(String string) {
        if (this._myAddress.length() == 0) {
            this._myAddress = string;
        }
        return this.me;
    }

    protected Controller(ControlP5 controlP5, String string, float f, float f2, int n, int n2) {
        this(controlP5, controlP5.getDefaultTab(), string, f, f2, n, n2);
    }

    protected Controller(String string, int n, int n2) {
        this._myName = string;
        Controller.set(this.position, n, n2);
    }

    @Override
    @ControlP5.Invisible
    public void init() {
        this._myDefaultValue = this._myValue;
        this.cp5.getControlBroadcaster().plug((Object)this.cp5.papplet, this, this._myName);
        this.initControllerValue();
        this.isInit = this.cp5.isAutoInitialization;
        this.setValue(this._myDefaultValue);
        this.isInit = true;
        this.updateDisplayMode(0);
    }

    protected final void initControllerValue() {
        boolean bl = false;
        if (this.getClass().equals(Numberbox.class)) {
            bl = this._myDefaultValue == 0.0f;
        } else {
            boolean bl2 = bl = this._myDefaultValue == this.getMin() || Float.isNaN(this.getValue());
        }
        if (bl) {
            if (this._myControllerPlugList.size() == 1) {
                if (this.getControllerPlugList().get(0).getValue() == null) {
                    this.setDefaultValue(this.getMin());
                } else {
                    float f = 0.0f;
                    if (this.getControllerPlugList().get(0).getValue() instanceof Boolean) {
                        boolean bl3 = new Boolean(this.getControllerPlugList().get(0).getValue().toString());
                        f = bl3 ? 1.0f : 0.0f;
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof Float) {
                        f = new Float(this.getControllerPlugList().get(0).getValue().toString()).floatValue();
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof Integer) {
                        f = new Integer(this.getControllerPlugList().get(0).getValue().toString()).intValue();
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof String) {
                        this._myStringValue = this.getControllerPlugList().get(0).getValue().toString();
                    }
                    this.setDefaultValue(f);
                }
            } else if (Float.isNaN(this.getDefaultValue())) {
                this.setDefaultValue(this.getMin());
            }
        }
        this._myValue = this._myDefaultValue;
    }

    protected void updateFont(ControlFont controlFont) {
        this.setFont(controlFont);
    }

    public T setBehavior(ControlBehavior controlBehavior) {
        this.isBehavior = true;
        this._myBehavior = controlBehavior;
        this._myBehavior.init(this);
        return this.me;
    }

    public T removeBehavior() {
        this.isBehavior = false;
        this._myBehavior = null;
        return this.me;
    }

    public ControlBehavior getBehavior() {
        return this._myBehavior;
    }

    @ControlP5.Layout
    public float getDefaultValue() {
        return this._myDefaultValue;
    }

    @ControlP5.Layout
    public T setDefaultValue(float f) {
        this._myDefaultValue = f;
        return this.me;
    }

    @ControlP5.Layout
    public T setMoveable(boolean bl) {
        this.isMoveable = bl;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isMoveable() {
        return this.isMoveable;
    }

    @ControlP5.Layout
    public T setLabelVisible(boolean bl) {
        this.isLabelVisible = bl;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isLabelVisible() {
        return this.isLabelVisible;
    }

    @ControlP5.Layout
    public T setBroadcast(boolean bl) {
        this.isBroadcast = bl;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    @Override
    @ControlP5.Layout
    public float[] getPosition() {
        return this.position;
    }

    @Override
    @ControlP5.Layout
    public T setPosition(float[] fArray) {
        Controller.set(this.position, Controller.x(fArray), Controller.y(fArray));
        Controller.set(this.positionBuffer, Controller.x(fArray), Controller.y(fArray));
        return this.me;
    }

    @Override
    public T setPosition(float f, float f2) {
        Controller.set(this.position, f, f2);
        Controller.set(this.positionBuffer, f, f2);
        return this.me;
    }

    @Override
    public float[] getAbsolutePosition() {
        return this.absolutePosition;
    }

    @Override
    @ControlP5.Invisible
    public T setAbsolutePosition(float[] fArray) {
        Controller.set(this.absolutePosition, Controller.x(fArray), Controller.y(fArray));
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public T updateAbsolutePosition() {
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public final void continuousUpdateEvents() {
        if (this.isBehavior && this._myBehavior.isActive() && !this.isMousePressed) {
            this._myBehavior.update();
        }
    }

    @Override
    @ControlP5.Invisible
    public final T updateEvents() {
        if (this.isInside) {
            boolean bl;
            boolean bl2 = bl = this._myControlWindow.mouseX - this._myControlWindow.pmouseX != 0 || this._myControlWindow.mouseY - this._myControlWindow.pmouseY != 0;
            if (this.isMousePressed) {
                if (bl) {
                    if (!this.isDragged) {
                        this.onStartDrag();
                        this.callListener(10);
                    }
                    this.onDrag();
                    this.isDragged = true;
                    this.callListener(4);
                }
            } else if (bl && this.equals(this._myControlWindow.getFirstFromMouseOverList())) {
                this.onMove();
                this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 5));
                this.callListener(5);
            }
        }
        if (this.isVisible && this.isMousePressed == this._myControlWindow.mouselock) {
            if (this.isMousePressed && this.cp5.isAltDown() && this.isMoveable) {
                if (!this.cp5.isMoveable) {
                    Controller.set(this.positionBuffer, Controller.x(this.positionBuffer) + (float)this._myControlWindow.mouseX - (float)this._myControlWindow.pmouseX, Controller.y(this.positionBuffer) + (float)this._myControlWindow.mouseY - (float)this._myControlWindow.pmouseY);
                    if (this.cp5.isShiftDown()) {
                        Controller.set(this.position, (int)Controller.x(this.positionBuffer) / 10 * 10, (int)Controller.y(this.positionBuffer) / 10 * 10);
                    } else {
                        Controller.set(this.position, this.positionBuffer);
                    }
                }
            } else if (!this.isLock) {
                if (this.isInside) {
                    this.setMouseOver(true);
                }
                if (this.inside()) {
                    if (this.cp5.getMouseOverList().isEmpty()) {
                        if (!this.isInside) {
                            this.onEnter();
                            this.setIsInside(true);
                            this.callListener(6);
                        }
                        this.setIsInside(true);
                    }
                } else {
                    if (this.isInside && !this.isMousePressed) {
                        this.onLeave();
                        this.setMouseOver(false);
                        this.setIsInside(false);
                        this.callListener(7);
                    }
                    if (!this.isInside && this.mouseover) {
                        this.setMouseOver(false);
                    }
                }
            }
        }
        return this.me;
    }

    public Pointer getPointer() {
        return new Pointer(){

            @Override
            public int x() {
                return (int)((float)Controller.this._myControlWindow.mouseX - Controller.x(Controller.this._myParent.getAbsolutePosition()) - Controller.x(Controller.this.position));
            }

            @Override
            public int y() {
                return (int)((float)Controller.this._myControlWindow.mouseY - Controller.y(Controller.this._myParent.getAbsolutePosition()) - Controller.y(Controller.this.position));
            }

            @Override
            public int px() {
                return (int)((float)Controller.this._myControlWindow.pmouseX - Controller.x(Controller.this._myParent.getAbsolutePosition()) - Controller.x(Controller.this.position));
            }

            @Override
            public int py() {
                return (int)((float)Controller.this._myControlWindow.pmouseY - Controller.y(Controller.this._myParent.getAbsolutePosition()) - Controller.y(Controller.this.position));
            }

            @Override
            public int dx() {
                return this.x() - this.px();
            }

            @Override
            public int dy() {
                return this.y() - this.py();
            }

            @Override
            public long pt() {
                return Controller.this._myControlWindow.pmousePressedTime;
            }

            @Override
            public long dt() {
                return Controller.this._myControlWindow.mousePressedTime - Controller.this._myControlWindow.pmousePressedTime;
            }

            @Override
            public long t() {
                return Controller.this._myControlWindow.mousePressedTime;
            }

            public String toString() {
                return String.format("{ x: %d y: %d px: %d py: %d dx: %d dy: %d}", this.x(), this.y(), this.px(), this.py(), this.dx(), this.dy());
            }
        };
    }

    @Override
    @ControlP5.Invisible
    public final boolean setMousePressed(boolean bl) {
        if (!this.isVisible && !this.isUserInteraction) {
            return false;
        }
        if (bl) {
            if (this.isInside) {
                this.isMousePressed = true;
                if (!this.cp5.isAltDown()) {
                    this.mousePressed();
                    this.onPress();
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 1));
                    this.callListener(1);
                    if (this.getPointer().dt() < 500L) {
                        this.onDoublePress();
                        this.callListener(12);
                    }
                }
                return true;
            }
        } else {
            if (this.isMousePressed && this.inside()) {
                this.isMousePressed = false;
                if (!this.cp5.isAltDown()) {
                    this.mouseReleased();
                    this.onRelease();
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 2));
                    this.callListener(2);
                    if (this.isDragged) {
                        this.onEndDrag();
                        this.callListener(11);
                    } else {
                        this.onClick();
                        this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 3));
                        this.callListener(3);
                    }
                    this.isDragged = false;
                }
            }
            if (!this.inside()) {
                this.setIsInside(false);
                if (this.isMousePressed) {
                    this.isMousePressed = false;
                    this.mouseReleasedOutside();
                    this.onReleaseOutside();
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 9));
                    this.callListener(9);
                }
                if (this instanceof Textfield) {
                    this.mouseReleasedOutside();
                    this.onReleaseOutside();
                    this.callListener(9);
                }
            }
        }
        return false;
    }

    public T listen(boolean bl) {
        if (bl == this.listening) {
            return this.me;
        }
        this.listening = bl;
        if (this.listening) {
            this.cp5.listenTo(this._myName, this.cp5.getObjectForController(this));
        } else {
            this.cp5.stopListeningTo(this._myName, this.cp5.getObjectForController(this));
        }
        return this.me;
    }

    public boolean isListening() {
        return this.listening;
    }

    @Override
    public boolean isMouseOver() {
        return this.mouseover;
    }

    @Override
    public T setMouseOver(boolean bl) {
        if (this.mouseover == bl) {
            return this.me;
        }
        this.mouseover = bl;
        if (this.mouseover) {
            this._myControlWindow.setMouseOverController(this);
            this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 6));
            this.cp5.getTooltip().activate(this);
        } else {
            this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 7));
            this._myControlWindow.removeMouseOverFor(this);
            this.cp5.getTooltip().deactivate();
            this.setIsInside(false);
        }
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public T updateInternalEvents(PApplet pApplet) {
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public void draw(PGraphics pGraphics) {
        pGraphics.pushMatrix();
        pGraphics.translate(Controller.x(this.position), Controller.y(this.position));
        this._myControllerView.display(pGraphics, this.me);
        pGraphics.popMatrix();
    }

    @Override
    @ControlP5.Invisible
    public T add(ControllerInterface<?> controllerInterface) {
        ControlP5.logger().warning(" add() not supported.");
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public T remove(ControllerInterface<?> controllerInterface) {
        ControlP5.logger().warning("remove() not supported.");
        return this.me;
    }

    @Override
    public void remove() {
        this._myControlWindow.removeMouseOverFor(this);
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.cp5 != null) {
            this.cp5.remove(this);
        }
    }

    @Override
    public T bringToFront() {
        return this.bringToFront(this);
    }

    @Override
    public T bringToFront(ControllerInterface<?> controllerInterface) {
        if (this._myParent instanceof Tab) {
            this.moveTo((Tab)this._myParent);
        } else {
            this._myParent.bringToFront(controllerInterface);
        }
        if (controllerInterface != this && this.getSubelements().contains(controllerInterface) && controllerInterface instanceof Controller) {
            this.getSubelements().remove(controllerInterface);
            this.getSubelements().add((Controller)controllerInterface);
        }
        return this.me;
    }

    @Override
    public String getName() {
        return this._myName;
    }

    public final T moveTo(String string) {
        this.setTab(string);
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(string);
        }
        return this.me;
    }

    public final T moveTo(Tab tab) {
        this.setTab(tab.getWindow(), tab.getName());
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(tab);
        }
        return this.me;
    }

    public final T moveTo(PApplet pApplet) {
        this.setTab("default");
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(pApplet);
        }
        return this.me;
    }

    public final T moveTo(PApplet pApplet, String string) {
        this.setTab(string);
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(pApplet, string);
        }
        return this.me;
    }

    public final T moveTo(ControlWindow controlWindow) {
        this.setTab(controlWindow, "default");
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(controlWindow);
        }
        return this.me;
    }

    public final T moveTo(ControlWindow controlWindow, String string) {
        this.setTab(controlWindow, string);
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(controlWindow, string);
        }
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> controllerGroup, Tab tab, ControlWindow controlWindow) {
        for (Controller<?> controller : this.getSubelements()) {
            controller.moveTo(controllerGroup, tab, controlWindow);
        }
        if (controllerGroup != null) {
            this.setGroup(controllerGroup);
            return this.me;
        }
        if (controlWindow == null) {
            controlWindow = this.cp5.controlWindow;
        }
        this.setTab(controlWindow, tab.getName());
        return this.me;
    }

    @Override
    public final T moveTo(ControlGroup<?> controlGroup) {
        if (controlGroup != null) {
            this.setGroup(controlGroup);
        }
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> controllerGroup) {
        if (controllerGroup != null) {
            this.setGroup(controllerGroup);
        }
        return this.me;
    }

    public final T setTab(String string) {
        this.setParent(this.cp5.getTab(string));
        for (Controller<?> controller : this.getSubelements()) {
            controller.setTab(string);
        }
        return this.me;
    }

    public final T setTab(ControlWindow controlWindow, String string) {
        this.setParent(this.cp5.getTab(controlWindow, string));
        for (Controller<?> controller : this.getSubelements()) {
            controller.setTab(controlWindow, string);
        }
        return this.me;
    }

    public final T setGroup(String string) {
        this.setParent(this.cp5.getGroup(string));
        for (Controller<?> controller : this.getSubelements()) {
            controller.setGroup(string);
        }
        return this.me;
    }

    public final T setGroup(ControllerGroup<?> controllerGroup) {
        this.setParent(controllerGroup);
        for (Controller<?> controller : this.getSubelements()) {
            controller.setGroup(controllerGroup);
        }
        return this.me;
    }

    @Override
    public Tab getTab() {
        if (this._myParent instanceof Tab) {
            return (Tab)this._myParent;
        }
        return this._myParent.getTab();
    }

    @ControlP5.Invisible
    public final T setParent(ControllerInterface<?> controllerInterface) {
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        Controller.set(this.absolutePosition, Controller.x(this.position), Controller.y(this.position));
        if (controllerInterface != null) {
            this._myParent = controllerInterface;
            this._myParent.add(this);
            Controller.set(this.absolutePosition, Controller.x(this.absolutePosition) + Controller.x(this._myParent.getPosition()), Controller.y(this.absolutePosition) + Controller.y(this._myParent.getPosition()));
            this._myControlWindow = this._myParent.getWindow();
        }
        this.setMouseOver(false);
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    @ControlP5.Layout
    public ControllerInterface<?> getParent() {
        return this._myParent;
    }

    @Override
    public ControlWindow getWindow() {
        return this._myControlWindow;
    }

    protected boolean inside() {
        float f = PApplet.max((float)0.0f, (float)(Controller.x(this.position) + Controller.x(this._myParent.getAbsolutePosition())));
        float f2 = PApplet.min((float)this.cp5.pgw, (float)(Controller.x(this.position) + Controller.x(this._myParent.getAbsolutePosition()) + (float)this.getWidth()));
        float f3 = PApplet.max((float)0.0f, (float)(Controller.y(this.position) + Controller.y(this._myParent.getAbsolutePosition())));
        float f4 = PApplet.min((float)this.cp5.pgh, (float)(Controller.y(this.position) + Controller.y(this._myParent.getAbsolutePosition()) + (float)this.getHeight()));
        return (float)this._myControlWindow.mouseX > f && (float)this._myControlWindow.mouseX < f2 && (float)this._myControlWindow.mouseY > f3 && (float)this._myControlWindow.mouseY < f4;
    }

    public boolean isInside() {
        return this.isInside;
    }

    @ControlP5.Layout
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isMousePressed() {
        return this.isMousePressed;
    }

    public T addListenerFor(int n, CallbackListener callbackListener) {
        if (this._myControlListenerLUT == null) {
            this._myControlListenerLUT = new HashMap<Integer, List<CallbackListener>>();
        }
        if (this._myControlListenerLUT.get(n) == null) {
            this._myControlListenerLUT.put(n, new ArrayList());
        }
        this._myControlListenerLUT.get(n).add(callbackListener);
        return this.me;
    }

    public T removeListenerFor(int n, CallbackListener callbackListener) {
        if (this._myControlListenerLUT == null) {
            return this.me;
        }
        if (this._myControlListenerLUT.get(n) == null) {
            return this.me;
        }
        this._myControlListenerLUT.get(n).remove(callbackListener);
        return this.me;
    }

    public T removeListenersFor(int n) {
        if (this._myControlListenerLUT == null) {
            return this.me;
        }
        if (this._myControlListenerLUT.get(n) == null) {
            return this.me;
        }
        this._myControlListenerLUT.get(n).clear();
        return this.me;
    }

    protected void callListener(int n) {
        List<CallbackListener> list;
        if (this._myControlListenerLUT != null && (list = this._myControlListenerLUT.get(n)) != null) {
            CallbackEvent callbackEvent = new CallbackEvent(this, n);
            for (CallbackListener callbackListener : list) {
                callbackListener.controlEvent(callbackEvent);
            }
        }
    }

    public T onDraw(ControllerView<T> controllerView) {
        return this.setView(controllerView);
    }

    public T onEnter(CallbackListener callbackListener) {
        return this.addListenerFor(6, callbackListener);
    }

    public T onLeave(CallbackListener callbackListener) {
        return this.addListenerFor(7, callbackListener);
    }

    public T onDrag(CallbackListener callbackListener) {
        return this.addListenerFor(4, callbackListener);
    }

    public T onStartDrag(CallbackListener callbackListener) {
        return this.addListenerFor(10, callbackListener);
    }

    public T onEndDrag(CallbackListener callbackListener) {
        return this.addListenerFor(11, callbackListener);
    }

    public T onWheel(CallbackListener callbackListener) {
        return this.addListenerFor(8, callbackListener);
    }

    public T onMove(CallbackListener callbackListener) {
        return this.addListenerFor(5, callbackListener);
    }

    public T onClick(CallbackListener callbackListener) {
        return this.addListenerFor(3, callbackListener);
    }

    public T onPress(CallbackListener callbackListener) {
        return this.addListenerFor(1, callbackListener);
    }

    public T onDoublePress(CallbackListener callbackListener) {
        return this.addListenerFor(12, callbackListener);
    }

    public T onRelease(CallbackListener callbackListener) {
        return this.addListenerFor(2, callbackListener);
    }

    public T onReleaseOutside(CallbackListener callbackListener) {
        return this.addListenerFor(9, callbackListener);
    }

    public T onChange(CallbackListener callbackListener) {
        return this.addListenerFor(100, callbackListener);
    }

    protected void onEnter() {
    }

    protected void onLeave() {
    }

    protected void onDrag() {
    }

    protected void onStartDrag() {
    }

    protected void onEndDrag() {
    }

    protected void onWheel() {
    }

    protected void onMove() {
    }

    protected void onClick() {
    }

    protected void onPress() {
    }

    protected void onDoublePress() {
    }

    protected void onRelease() {
    }

    protected void onScroll(int n) {
    }

    protected void onReleaseOutside() {
    }

    protected void mousePressed() {
    }

    protected void mouseReleased() {
    }

    protected void mouseReleasedOutside() {
    }

    protected void setIsInside(boolean bl) {
        this.isInside = bl;
    }

    protected boolean getIsInside() {
        return this.isInside;
    }

    @Override
    @ControlP5.Invisible
    public void keyEvent(KeyEvent keyEvent) {
    }

    @Override
    @ControlP5.Layout
    public T setId(int n) {
        this._myId = n;
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public int getId() {
        return this._myId;
    }

    protected ControllerPlug getControllerPlug(int n) {
        return this._myControllerPlugList.get(n);
    }

    public List<ControllerPlug> getControllerPlugList() {
        return this._myControllerPlugList;
    }

    protected boolean checkControllerPlug(ControllerPlug controllerPlug) {
        for (ControllerPlug controllerPlug2 : this._myControllerPlugList) {
            if (!controllerPlug2.getObject().equals(controllerPlug.getObject()) || !controllerPlug2.getName().equals(controllerPlug.getName())) continue;
            return true;
        }
        return false;
    }

    protected void addControllerPlug(ControllerPlug controllerPlug) {
        if (this.checkControllerPlug(controllerPlug)) {
            return;
        }
        this._myControllerPlugList.add(controllerPlug);
    }

    protected void removeControllerPlug(ControllerPlug controllerPlug) {
        this._myControllerPlugList.remove(controllerPlug);
    }

    public T plugTo(Object[] objectArray) {
        for (Object object : objectArray) {
            this.plugTo(object, this._myName);
        }
        return this.me;
    }

    public T plugTo(Object[] objectArray, String string) {
        for (Object object : objectArray) {
            this.plugTo(object, string);
        }
        return this.me;
    }

    public T plugTo(Object object) {
        return this.plugTo(object, this._myName);
    }

    public T plugTo(Object object, String string) {
        if (object instanceof PApplet) {
            this.unplugFrom(object);
        }
        this.cp5.getControlBroadcaster().plug(object, this, string);
        this.cp5.getControlBroadcaster().plug(object, this, this.cp5.getControlBroadcaster().getEventMethod());
        return this.me;
    }

    public T unplugFrom(Object[] objectArray) {
        for (Object object : objectArray) {
            this.unplugFrom(object);
        }
        return this.me;
    }

    public T unplugFrom(Object object) {
        Iterator<ControllerPlug> iterator = this._myControllerPlugList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getObject().equals(object)) continue;
            iterator.remove();
        }
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setValue(float f) {
        this._myValue = f;
        this.broadcast(2);
        return this.me;
    }

    public T setValueSelf(float f) {
        boolean bl = this.isBroadcast();
        this.setBroadcast(false);
        this._myValue = f;
        this.broadcast(2);
        this.setBroadcast(bl);
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public float getValue() {
        return this._myValue;
    }

    @Override
    @ControlP5.Layout
    public T setStringValue(String string) {
        this._myStringValue = string;
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public String getStringValue() {
        return this._myStringValue;
    }

    @Override
    @ControlP5.Layout
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    @Override
    public float getArrayValue(int n) {
        if (n >= 0 && n < this._myArrayValue.length) {
            return this._myArrayValue[n];
        }
        return Float.NaN;
    }

    @Override
    @ControlP5.Layout
    public T setArrayValue(float[] fArray) {
        this._myArrayValue = fArray;
        return this.me;
    }

    @Override
    public T setArrayValue(int n, float f) {
        if (n >= 0 && n < this._myArrayValue.length) {
            this._myArrayValue[n] = f;
        }
        return this.me;
    }

    public final T changeValue(float f) {
        boolean bl = this.isBroadcast;
        this.isBroadcast = false;
        this.setValue(f);
        this.isBroadcast = bl;
        return this.me;
    }

    @Override
    public T update() {
        return this.me;
    }

    @Override
    public T setUpdate(boolean bl) {
        this.isUpdate = bl;
        return this.me;
    }

    @Override
    public boolean isUpdate() {
        return this.isUpdate;
    }

    @Override
    @ControlP5.Invisible
    public int getPickingColor() {
        return this._myPickingColor;
    }

    @Override
    @ControlP5.Layout
    public CColor getColor() {
        return this.color;
    }

    @Override
    @ControlP5.Layout
    public T setCaptionLabel(String string) {
        this._myCaptionLabel.set(string);
        return this.me;
    }

    @ControlP5.Layout
    public T setValueLabel(String string) {
        this._myValueLabel.set(string);
        return this.me;
    }

    @ControlP5.Invisible
    public String getLabel() {
        return this._myCaptionLabel.getText();
    }

    @Override
    public T addListener(ControlListener controlListener) {
        this._myControlListener.add(controlListener);
        return this.me;
    }

    public T removeListener(ControlListener controlListener) {
        this._myControlListener.remove(controlListener);
        return this.me;
    }

    public int listenerSize() {
        return this._myControlListener.size();
    }

    public T addCallback(CallbackListener callbackListener) {
        this.cp5.addCallback(callbackListener, this);
        return this.me;
    }

    public T removeCallback(CallbackListener callbackListener) {
        this.cp5.removeCallback(callbackListener);
        return this.me;
    }

    public T removeCallback() {
        this.cp5.removeCallback((Controller<?>)this);
        return this.me;
    }

    protected void broadcast() {
        this.broadcast(this._myBroadcastType);
    }

    protected void broadcast(int n) {
        n = this._myBroadcastType;
        ControlEvent controlEvent = new ControlEvent(this);
        for (ControlListener controlListener : this._myControlListener) {
            controlListener.controlEvent(controlEvent);
        }
        if (this.isBroadcast && this.isInit) {
            this.cp5.getControlBroadcaster().broadcast(controlEvent, n);
            this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(this, 100));
            this.callListener(100);
        }
        this.isInit = true;
    }

    @Override
    @ControlP5.Layout
    public boolean isVisible() {
        if (this.getParent() != null && !this.getParent().isVisible()) {
            return false;
        }
        return this.isVisible;
    }

    @ControlP5.Layout
    public T setVisible(boolean bl) {
        this.isVisible = bl;
        if (!bl) {
            this.isActive = false;
        }
        return this.me;
    }

    @Override
    public T hide() {
        this.setMouseOver(false);
        this.isVisible = false;
        this.isActive = false;
        return this.me;
    }

    @Override
    public T show() {
        this.isVisible = true;
        return this.me;
    }

    @Override
    public T setColor(CColor cColor) {
        this.color.set(cColor);
        this.setColorCaptionLabel(cColor.getCaptionLabel());
        this.setColorValueLabel(cColor.getValueLabel());
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setColorActive(int n) {
        this.color.setActive(n);
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setColorForeground(int n) {
        this.color.setForeground(n);
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public T setColorBackground(int n) {
        this.color.setBackground(n);
        return this.me;
    }

    @ControlP5.Layout
    public T setColorCaptionLabel(int n) {
        this.color.setCaptionLabel(n);
        this._myCaptionLabel.setColor(this.color.getCaptionLabel());
        return this.me;
    }

    @ControlP5.Layout
    public T setColorValueLabel(int n) {
        this.color.setValueLabel(n);
        if (this._myValueLabel != null) {
            this._myValueLabel.setColor(this.color.getValueLabel());
        }
        return this.me;
    }

    public T setImages(PImage pImage, PImage pImage2, PImage pImage3) {
        this.setImage(pImage, 0);
        this.setImage(pImage2, 1);
        this.setImage(pImage3, 2);
        this.setImage(pImage3, 3);
        return this.me;
    }

    public T setImages(PImage pImage, PImage pImage2, PImage pImage3, PImage pImage4) {
        this.setImage(pImage, 0);
        this.setImage(pImage2, 1);
        this.setImage(pImage3, 2);
        this.setImage(pImage4, 3);
        return this.me;
    }

    public T setImages(PImage ... pImageArray) {
        if (pImageArray.length < 3 || pImageArray.length > 4) {
            return this.me;
        }
        this.setImage(pImageArray[0], 0);
        this.setImage(pImageArray[1], 1);
        this.setImage(pImageArray[2], 2);
        this.setImage(pImageArray.length == 3 ? pImageArray[2] : pImageArray[3], 3);
        return this.me;
    }

    public T setImage(PImage pImage) {
        return this.setImage(pImage, 0);
    }

    public T setImage(PImage pImage, int n) {
        if (pImage != null) {
            this.images[n] = pImage;
            this.availableImages[n] = true;
            this.updateDisplayMode(1);
        }
        return this.me;
    }

    public T updateSize() {
        if (this.images[0] != null) {
            this.setSize(this.images[0]);
        }
        return this.me;
    }

    public T setSize(PImage pImage) {
        if (pImage != null) {
            this.setSize(pImage.width, pImage.height);
        }
        return this.me;
    }

    public T setSize(int n, int n2) {
        this.setWidth(n);
        this.setHeight(n2);
        return this.me;
    }

    protected T updateDisplayMode(int n) {
        if (n != 0) {
            ControlP5.logger().warning("Image-based or custom displays are not yet implemented for this type of controller. (" + this.getClass().getName() + ")");
        }
        return this.me;
    }

    public T setView(ControllerView<T> controllerView) {
        this.setView(controllerView, 3);
        return this.me;
    }

    public void setView(ControllerView<T> controllerView, int n) {
        this._myDisplayMode = n;
        this._myControllerView = controllerView;
    }

    public ControllerView<T> getView() {
        return this._myControllerView;
    }

    @ControlP5.Layout
    public Label getCaptionLabel() {
        return this._myCaptionLabel;
    }

    @ControlP5.Layout
    public Label getValueLabel() {
        return this._myValueLabel;
    }

    @ControlP5.Layout
    public float getMax() {
        return this._myMax;
    }

    @ControlP5.Layout
    public float getMin() {
        return this._myMin;
    }

    @ControlP5.Layout
    public T setMin(float f) {
        this._myMin = f;
        this.changeValue(this.getValue());
        return this.me;
    }

    @ControlP5.Layout
    public T setMax(float f) {
        this._myMax = f;
        this.changeValue(this.getValue());
        return this.me;
    }

    @ControlP5.Layout
    public T setWidth(int n) {
        this.width = n;
        return this.me;
    }

    @ControlP5.Layout
    public T setHeight(int n) {
        this.height = n;
        return this.me;
    }

    @Override
    @ControlP5.Layout
    public int getWidth() {
        return this.width;
    }

    @Override
    @ControlP5.Layout
    public int getHeight() {
        return this.height;
    }

    @ControlP5.Layout
    public T setDecimalPrecision(int n) {
        this._myDecimalPoints = n;
        int[] nArray = this._myValueLabel.getAlign();
        this._myValueLabel = new Label(this.cp5, "" + (this.adjustValue(this._myMax).length() > this.adjustValue(this._myMin).length() ? this.adjustValue(this._myMax) : this.adjustValue(this._myMin)));
        this._myValueLabel.align(nArray);
        this._myValueLabel.setColor(this.color.getValueLabel());
        this._myValueLabel.set("" + this.adjustValue(this.getValue()));
        return this.me;
    }

    @ControlP5.Layout
    public int getDecimalPrecision() {
        return this._myDecimalPoints;
    }

    protected String adjustValue(float f) {
        return this.adjustValue(f, this._myDecimalPoints);
    }

    protected String adjustValue(float f, int n) {
        Object object;
        block6: {
            int n2;
            block5: {
                int n3;
                int n4;
                n2 = n + 1;
                if (this.getControllerPlugList().size() > 0) {
                    object = this.getControllerPlugList().iterator();
                    while (object.hasNext()) {
                        ControllerPlug controllerPlug = object.next();
                        if (controllerPlug.getClassType() != Integer.TYPE) continue;
                        n2 = 0;
                    }
                }
                if ((n4 = ((String)(object = "" + f)).indexOf(46)) <= 0) break block5;
                if (n == 0) {
                    --n4;
                }
                if ((n3 = ((String)(object = ((String)object).substring(0, Math.min(((String)object).length(), n4 + n2)))).length() - n4) >= n2) break block6;
                for (int i = 0; i < n2 - n3; ++i) {
                    object = (String)object + "0";
                }
                break block6;
            }
            object = (String)object + ".";
            for (int i = 0; i < n2; ++i) {
                object = (String)object + "0";
            }
        }
        return object;
    }

    public T align(int n, int n2, int n3, int n4) {
        this.getCaptionLabel().align(n, n2);
        this.getCaptionLabel().align(n3, n4);
        return this.me;
    }

    public ControlWindow getControlWindow() {
        return this._myControlWindow;
    }

    public T lock() {
        this.isLock = true;
        return this.me;
    }

    public T unlock() {
        this.isLock = false;
        return this.me;
    }

    @ControlP5.Layout
    public boolean isLock() {
        return this.isLock;
    }

    @ControlP5.Layout
    public T setLock(boolean bl) {
        this.isLock = bl;
        return this.me;
    }

    @ControlP5.Invisible
    public T setUserInteraction(boolean bl) {
        this.isUserInteraction = bl;
        return this.me;
    }

    @ControlP5.Invisible
    public boolean isUserInteraction() {
        return this.isUserInteraction;
    }

    public T registerTooltip(String string) {
        this.cp5.getTooltip().register(this, string);
        return this.me;
    }

    public T unregisterTooltip() {
        this.cp5.getTooltip().unregister(this);
        return this.me;
    }

    protected T setTooltipEnabled(boolean bl) {
        this.tooltipEnabled = bl;
        return this.me;
    }

    protected boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public T linebreak() {
        this.cp5.linebreak(this, true, autoWidth, autoHeight, autoSpacing);
        return this.me;
    }

    @Override
    public ControllerProperty getProperty(String string) {
        return this.cp5.getProperties().getProperty(this, string);
    }

    @Override
    public ControllerProperty getProperty(String string, String string2) {
        return this.cp5.getProperties().getProperty(this, string, string2);
    }

    @Override
    public T registerProperty(String string) {
        this.cp5.getProperties().register(this, string);
        return this.me;
    }

    @Override
    public T registerProperty(String string, String string2) {
        this.cp5.getProperties().register(this, string, string2);
        return this.me;
    }

    @Override
    public T removeProperty(String string) {
        this.cp5.getProperties().remove((ControllerInterface<?>)this, string);
        return this.me;
    }

    @Override
    public T removeProperty(String string, String string2) {
        this.cp5.getProperties().remove((ControllerInterface<?>)this, string, string2);
        return this.me;
    }

    public String toString() {
        return this.getName() + " [" + this.getClass().getSimpleName() + "]";
    }

    public String getInfo() {
        return "[ type:\tController\nname:\t" + this._myName + "\n" + "label:\t" + this._myCaptionLabel.getText() + "\n" + "id:\t" + this._myId + "\n" + "value:\t" + this.getValue() + "\n" + "arrayvalue:\t" + CP.arrayToString(this._myArrayValue) + "\n" + "position:\t" + this.position + "\n" + "absolute:\t" + this.absolutePosition + "\n" + "width:\t" + this.getWidth() + "\n" + "height:\t" + this.getHeight() + "\n" + "color:\t" + this.getColor() + "\n" + "visible:\t" + this.isVisible + "\n" + "moveable:\t" + this.isMoveable + " ]";
    }

    public static float[] set(float[] fArray, float ... fArray2) {
        if (fArray2.length > fArray.length) {
            System.arraycopy(fArray2, 0, fArray, 0, fArray.length);
        } else {
            System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
        }
        return fArray;
    }

    public static float x(float[] fArray) {
        if (fArray.length > 0) {
            return fArray[0];
        }
        return 0.0f;
    }

    public static float y(float[] fArray) {
        if (fArray.length > 1) {
            return fArray[1];
        }
        return 0.0f;
    }

    @Override
    public T setLabel(String string) {
        this.getCaptionLabel().setText(string);
        return this.me;
    }

    @Override
    public T setColorLabel(int n) {
        this.getCaptionLabel().setColor(n);
        return this.me;
    }

    @Override
    public T setColorValue(int n) {
        this.getValueLabel().setColor(n);
        return this.me;
    }

    @Override
    public T setFont(PFont pFont) {
        this.getValueLabel().setFont(pFont);
        this.getCaptionLabel().setFont(pFont);
        return this.me;
    }

    @Override
    public T setFont(ControlFont controlFont) {
        this.getValueLabel().setFont(controlFont);
        this.getCaptionLabel().setFont(controlFont);
        return this.me;
    }

    class DebugView
    implements ControllerView<T> {
        DebugView() {
        }

        @Override
        public void display(PGraphics pGraphics, T t) {
            if (Controller.this.inside()) {
                pGraphics.fill(255.0f, 0.0f, 0.0f, 50.0f);
                pGraphics.stroke(255.0f, 0.0f, 0.0f);
            } else {
                pGraphics.fill(255, 50.0f);
                pGraphics.stroke(255);
            }
            pGraphics.pushMatrix();
            pGraphics.rect(0.0f, 0.0f, (float)Controller.this.width, (float)Controller.this.height);
            pGraphics.popMatrix();
        }
    }
}

