/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Bang;
import controlP5.Button;
import controlP5.CallbackEvent;
import controlP5.CallbackListener;
import controlP5.CheckBox;
import controlP5.ColorWheel;
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ScrollableList;
import controlP5.Tab;
import controlP5.Textarea;
import controlP5.Textfield;
import controlP5.Textlabel;
import controlP5.Toggle;
import hypermedia.net.UDP;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import oscP5.OscMessage;
import oscP5.OscP5;
import oscP5.OscProperties;
import oscP5.OscStatus;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.data.IntDict;
import processing.data.IntList;
import processing.data.StringList;
import processing.data.XML;

public class WoConditionalLayers
extends PApplet {
    PApplet app = this;
    Locale app_locale;
    Project project = new Project();
    UI ui = new UI();
    UiElements ui_elements = new UiElements();
    String app_title = "Conditional Layer Utility";
    String app_version = "1.1.0";
    String xml_version = "1.0";
    int copyright_year_end = 2018;
    String web_url = "https://matkeane.com";
    String web_api_path = "app";
    String web_button_url = String.valueOf(this.web_url) + "/" + this.web_api_path + "/" + this.sanitize_network_string(this.app_title) + "/?version=" + this.app_version;
    Boolean debug_mode = false;
    PFont font_display_ui;
    PFont font_display_ui_title;

    public void setup() {
        String welcome_message = "Welcome to " + this.app_title + " " + this.app_version;
        WoConditionalLayers.println((String)welcome_message);
        if (this.frame != null) {
            this.surface.setResizable(true);
        }
        this.frameRate(60.0f);
        this.surface.setTitle(String.valueOf(this.app_title) + " " + this.app_version);
        Locale.setDefault(Locale.US);
        this.app_locale = Locale.getDefault();
        WoConditionalLayers.println((String)("Using Locale: " + this.app_locale.getDisplayName() + " " + this.app_locale.toLanguageTag()));
        WoConditionalLayers.println((String)("Monitor resolution: " + this.displayWidth + "x" + this.displayHeight + ", pixelDensity: " + this.displayDensity()));
        this.font_display_ui = this.createFont("Verdana", 12.0f, true);
        this.font_display_ui_title = this.createFont("Verdana", 18.0f, true);
        this.project.init();
        this.ui_elements.init();
        this.setup_ui_elements();
        this.ui.logo_image_create();
        this.project.app_server_udp.start();
    }

    public void draw() {
        this.ui.check_frame_size();
        this.project.app_server_check_status();
        this.background(this.ui.colour_get_by_name("viewport_bg"));
        this.draw_ui_background();
        this.draw_layer_groups();
        this.draw_ui_pane();
        this.draw_message_overlay();
        this.draw_throbber();
    }

    public void keyPressed() {
        this.ui.keyboard_event(this.keyCode, true);
        if (this.key == '\u001b') {
            this.key = '\u0000';
        }
    }

    public void keyReleased() {
        if (this.key == '\u001a') {
            this.debug_output("Keyboard UNDO.");
        }
        if (this.keyCode == 9) {
            this.ui.tab_select_next();
        }
        this.ui.keyboard_event(this.keyCode, false);
    }

    public void file_load_check(File project_filepath_input) {
        if (project_filepath_input != null) {
            this.project.filepath = project_filepath_input.getAbsolutePath();
            this.file_load_xml();
        }
    }

    public void file_load_xml() {
        Boolean loading_completed = false;
        this.debug_output("load_project_file: " + this.project.filepath);
        this.ui.message_display("Loading Project file ...");
        this.ui.display_colourpicker(false);
        XML xml_project_file = this.loadXML(this.project.filepath);
        if (xml_project_file != null) {
            if (xml_project_file.hasAttribute("xml_version")) {
                this.debug_output("Loaded project file with XML version: " + xml_project_file.getString("xml_version"));
                this.debug_output("XML file has locale: " + xml_project_file.getString("locale"));
                this.project.filename = xml_project_file.getString("name");
            }
            this.project.reset_project();
            this.ui.active = false;
            XML[] project_prefs = xml_project_file.getChild("project_preferences").getChildren("setting");
            this.debug_output("Loading project_prefs: found " + project_prefs.length + " settings.");
            if (project_prefs.length > 0) {
                int i = 0;
                while (i < project_prefs.length) {
                    this.file_load_preference(project_prefs[i]);
                    ++i;
                }
            } else {
                this.ui.message_display("Error loading Project preferences.");
            }
            XML[] grid_values = xml_project_file.getChild("grid_values").getChildren("grid");
            this.debug_output("Loading grid_values: found " + grid_values.length + " settings.");
            if (grid_values.length > 0) {
                int i = 0;
                while (i < grid_values.length) {
                    this.file_load_grid_value(grid_values[i]);
                    ++i;
                }
            } else {
                this.ui.message_display("Error loading Grid values.");
            }
            XML[] client_connections = xml_project_file.getChild("project_clients").getChildren("client_connection");
            this.debug_output("Loading client_connections: found " + client_connections.length + " clients.");
            if (client_connections.length > 0) {
                int i = 0;
                while (i < client_connections.length) {
                    this.file_load_client_connection(client_connections[i]);
                    ++i;
                }
            } else {
                this.ui.message_display("Error loading client connections.");
            }
            XML[] server_settings = xml_project_file.getChild("project_servers").getChildren("app_server");
            this.debug_output("Loading server_settings: found " + server_settings.length + " servers.");
            if (server_settings.length > 0) {
                int i = 0;
                while (i < server_settings.length) {
                    this.file_load_server_setting(server_settings[i]);
                    ++i;
                }
            } else {
                this.ui.message_display("Error loading server settings.");
            }
            XML[] layer_names = xml_project_file.getChild("layer_names").getChildren("layer");
            this.debug_output("Loading layer_names: found " + layer_names.length + " layers.");
            if (layer_names.length > 0) {
                int i = 0;
                while (i < layer_names.length) {
                    this.file_load_layer_name(layer_names[i]);
                    ++i;
                }
            } else {
                this.ui.message_display("Error loading layer names.");
            }
            XML[] layer_groups = xml_project_file.getChild("layer_groups").getChildren("layer_group");
            this.debug_output("Loading layer_groups: found " + layer_names.length + " groups.");
            if (layer_groups.length > 0) {
                int i = 0;
                while (i < layer_groups.length) {
                    this.file_load_layer_group(layer_groups[i]);
                    ++i;
                }
            } else {
                this.ui.message_display("Error loading layer groups.");
            }
            XML[] layer_presets = xml_project_file.getChild("layer_presets").getChildren("layer_preset");
            this.debug_output("Loading layer_presets: found " + layer_presets.length + " presets.");
            if (layer_presets.length > 0) {
                int i = 0;
                while (i < layer_presets.length) {
                    this.file_load_layer_preset(layer_presets[i]);
                    ++i;
                }
            } else {
                this.ui.message_display("Error loading layer presets.");
            }
            loading_completed = true;
        } else {
            this.ui.message_display("Error loading Project XML file.");
        }
        if (loading_completed.booleanValue()) {
            this.ui.message_display("Project file loaded successfully.");
            this.ui.active = true;
            if (this.ui.ready.booleanValue()) {
                this.ui_elements.update_all_controls();
            }
        }
    }

    public void file_load_client_connection(XML client_connection) {
        this.debug_output("Parsing client connection: " + client_connection.getString("ip") + ", " + client_connection.getInt("port") + ", " + client_connection.getString("name"));
        this.project.client_connection_add(client_connection.getString("ip"), client_connection.getInt("port"), client_connection.getString("name"));
    }

    public int file_load_colour(XML colour_data) {
        int r = colour_data.getInt("r", -1);
        int g = colour_data.getInt("g", -1);
        int b = colour_data.getInt("b", -1);
        int a = colour_data.getInt("a", 255);
        this.debug_output("Parsing Colour: r:" + r + ",g:" + g + ",b:" + b + ",a:" + a);
        if (r >= 0 && g >= 0 && b >= 0 && a >= 0) {
            return this.color(r, g, b, a);
        }
        return this.ui.colour_get_by_name("matkeane");
    }

    public void file_load_grid_value(XML grid_value) {
        int grid_id = grid_value.getInt("id");
        this.debug_output("Parsing grid id: " + grid_id + " " + grid_value.getString("name") + " = " + grid_value.getString("value_binary") + ", " + grid_value.getString("value_int"));
        if (!grid_value.getString("value_binary").equals("")) {
            int[] binary_array = this.get_array_from_binary_string(grid_value.getString("value_binary"));
            WoConditionalLayers.arrayCopy((Object)binary_array, (Object)this.project.layer_values[grid_id]);
        }
    }

    public void file_load_layer_group(XML layer_group) {
        XML[] group_member_layers = layer_group.getChild("layers").getChildren("layer");
        XML[] group_colour = layer_group.getChildren("colour");
        this.debug_output("Parsing group: " + layer_group.getString("name") + " with " + group_member_layers.length + " layers");
        String group_name = layer_group.getString("name");
        int group_type = layer_group.getInt("type");
        if (group_name != null && group_type >= 0) {
            this.project.layer_group_add();
            this.project.current_layergroup.set_name(layer_group.getString("name"));
            this.project.current_layergroup.set_type(group_type);
            int i = 0;
            while (i < group_colour.length) {
                this.project.current_layergroup.set_colour(this.file_load_colour(group_colour[i]));
                ++i;
            }
            if (group_member_layers.length > 0) {
                int layer_id = -1;
                int i2 = 0;
                while (i2 < group_member_layers.length) {
                    layer_id = group_member_layers[i2].getInt("id");
                    this.project.current_layergroup.add_layer(this.get_number_from_id(layer_id));
                    ++i2;
                }
            }
        }
    }

    public void file_load_layer_name(XML layer_name) {
        int layer_id = layer_name.getInt("id");
        this.debug_output("Parsing name for layer id: " + layer_id + " " + layer_name.getString("name") + " = " + layer_name.getString("machine_name"));
        if (this.is_valid_layer_id(layer_id).booleanValue()) {
            this.project.layer_name_set(layer_id, layer_name.getString("name"));
        }
    }

    public void file_load_layer_preset(XML layer_preset) {
        this.debug_output("Parsing layer preset: " + layer_preset.getString("name") + " = " + layer_preset.getString("value_binary"));
        String value_binary = layer_preset.getString("value_binary");
        layer_preset.getInt("value_int");
        if (value_binary != null) {
            this.project.preset_add();
            this.project.current_preset.set_name(layer_preset.getString("name"));
            int[] value_array = this.get_array_from_binary_string(value_binary);
            this.project.current_preset.set_array_value(value_array);
        }
    }

    public void file_load_preference(XML preference) {
        String pref_name = preference.getString("id");
        this.debug_output("Parsing preference: " + pref_name + ", " + preference.getString("type") + " = " + preference.getContent());
        if (!preference.getContent().equals("")) {
            if (pref_name.equals("app_broadcasting")) {
                this.project.app_broadcasting = this.get_boolean_from_string(preference.getContent());
            }
            if (pref_name.equals("operating_mode")) {
                this.project.operating_mode_set(preference.getIntContent(0));
            }
            if (pref_name.equals("pref_force_all_layers_to_zero")) {
                this.project.pref_force_all_layers_to_zero = this.get_boolean_from_string(preference.getContent());
            }
            if (pref_name.equals("pref_take_auto_switch")) {
                this.project.pref_take_auto_switch = this.get_boolean_from_string(preference.getContent());
            }
            if (pref_name.equals("pref_use_keyboard_shortcuts")) {
                this.project.pref_use_keyboard_shortcuts = this.get_boolean_from_string(preference.getContent());
            }
        }
        this.ui_elements.project_preference_toggle_controls_update();
    }

    public void file_load_server_setting(XML server_setting) {
        this.debug_output("Parsing server setting: " + server_setting.getString("type") + ", " + server_setting.getInt("port") + ", " + server_setting.getString("status"));
        String server_type = server_setting.getString("type");
        if (server_type != null) {
            int server_port = server_setting.getInt("port");
            Boolean server_active = this.get_boolean_from_string(server_setting.getString("status"));
            if (server_type.equals("UDP")) {
                this.project.app_server_udp.port_set(server_port);
                if (server_active.booleanValue()) {
                    this.project.app_server_udp.start();
                } else {
                    this.project.app_server_udp.stop();
                }
            }
            if (server_type.equals("OSC")) {
                this.project.app_server_osc.port_set(server_port);
                if (server_active.booleanValue()) {
                    this.project.app_server_osc.start();
                } else {
                    this.project.app_server_osc.stop();
                }
            }
        }
    }

    public void file_save_location_selected(File selection) {
        if (selection == null) {
            this.debug_output("Project save window was closed or the user hit cancel.");
        } else {
            String project_filepath_folder = String.valueOf(selection.getAbsolutePath()) + "/";
            this.debug_output("User selected folder: " + project_filepath_folder);
            this.file_save_data(project_filepath_folder);
        }
    }

    public void file_save_data(String project_filepath_folder) {
        this.ui.message_display("Saving Project file ...");
        XML xml_project = new XML("conditional_layer_project");
        xml_project.setString("xml_version", this.xml_version);
        xml_project.setString("app_version", this.app_version);
        xml_project.setString("generated_ddmmyy", this.get_current_date_string());
        xml_project.setString("name", this.project.filename);
        xml_project.setString("locale", this.app_locale.toLanguageTag());
        xml_project.addChild(this.generate_project_xml());
        XML xml_grid_values = xml_project.addChild("grid_values");
        int grid_id = 0;
        while (grid_id <= 1) {
            xml_grid_values.addChild(this.project.layer_values_xml_generate(grid_id));
            ++grid_id;
        }
        XML xml_project_clients = xml_project.addChild("project_clients");
        for (AppClient client : this.project.client_connections) {
            xml_project_clients.addChild(client.xml_generate());
        }
        XML xml_project_servers = xml_project.addChild("project_servers");
        if (this.project.app_server_udp != null) {
            xml_project_servers.addChild(this.project.app_server_udp.xml_generate());
        }
        if (this.project.app_server_osc != null) {
            xml_project_servers.addChild(this.project.app_server_osc.xml_generate());
        }
        xml_project.addChild(this.project.layer_name_xml_generate());
        XML xml_layer_groups = xml_project.addChild("layer_groups");
        for (LayerGroup group : this.project.layer_groups) {
            xml_layer_groups.addChild(group.xml_generate());
        }
        XML xml_project_presets = xml_project.addChild("layer_presets");
        for (LayerPreset preset : this.project.layer_presets) {
            xml_project_presets.addChild(preset.xml_generate());
        }
        String project_filename_temp = String.valueOf(this.project.filename) + " " + this.get_current_date_string();
        String project_filename = String.valueOf(project_filename_temp.replaceAll("\\s", "-")) + "-conditional_layers.xml";
        String project_filepath = String.valueOf(project_filepath_folder) + project_filename;
        this.debug_output("Saving project file to: " + project_filepath);
        this.saveXML(xml_project, project_filepath);
        this.ui.message_display("Project file successfully saved to: " + project_filepath);
    }

    public XML generate_project_xml() {
        XML xml_project_preferences = new XML("project_preferences");
        XML xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "app_broadcasting");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.get_boolean_as_string(this.project.app_broadcasting));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "operating_mode");
        xml_pref.setString("type", "integer");
        xml_pref.setContent(Integer.toString(0));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "pref_force_all_layers_to_zero");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.get_boolean_as_string(this.project.pref_force_all_layers_to_zero));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "pref_take_auto_switch");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.get_boolean_as_string(this.project.pref_take_auto_switch));
        xml_pref = xml_project_preferences.addChild("setting");
        xml_pref.setString("id", "pref_use_keyboard_shortcuts");
        xml_pref.setString("type", "boolean");
        xml_pref.setContent(this.get_boolean_as_string(this.project.pref_use_keyboard_shortcuts));
        return xml_project_preferences;
    }

    public void controlEvent(ControlEvent theEvent) {
        if (this.ui.ready.booleanValue()) {
            if (theEvent.isController()) {
                Controller ui_control_element = theEvent.getController();
                String ui_control_element_name = ui_control_element.getName();
                int ui_control_element_id = theEvent.getController().getId();
                this.debug_output("UI controller event from: " + ui_control_element_name + " with ID : " + ui_control_element_id);
                if (theEvent.isTab()) {
                    this.debug_output("Got a controller event from tab : " + theEvent.getTab().getName() + " with id " + theEvent.getTab().getId());
                    this.ui.set_active_tab_id(theEvent.getTab().getId());
                }
            } else if (theEvent.isTab()) {
                this.debug_output("got an event from tab : " + theEvent.getTab().getName() + " with id " + theEvent.getTab().getId());
                this.ui.set_active_tab_id(theEvent.getTab().getId());
            } else {
                ControlGroup ui_control_group = theEvent.getGroup();
                this.debug_output("UI Group event from group: " + ui_control_group.getName() + ", ID " + theEvent.getGroup().getId());
            }
        }
    }

    public void button_app_broadcast_toggle() {
        this.project.app_broadcast_toggle();
    }

    public void button_client_add() {
        this.project.client_connection_ui_add();
    }

    public void button_client_delete() {
        this.project.client_connection_ui_delete();
    }

    public void button_client_textfields_clear() {
        this.ui_elements.client_connection_controls_clear();
    }

    public void button_client_port_production() {
        this.project.client_connection_port_set_preset_value("Production");
    }

    public void button_client_port_display() {
        this.project.client_connection_port_set_preset_value("Display");
    }

    public void button_copy_main_to_preview() {
        this.project.layer_values_update_preview();
    }

    public void button_layer_all_enable() {
        this.project.layer_set_values_all(true);
    }

    public void button_layer_all_disable() {
        this.project.layer_set_values_all(false);
    }

    public void button_layergroup_add() {
        this.project.layer_group_add();
    }

    public void button_layergroup_delete() {
        this.project.layer_group_delete(this.project.current_layergroup.id);
    }

    public void button_layergroup_edit() {
        this.project.layer_group_edit();
    }

    public void button_layergroup_swatch() {
        this.ui.colour_swatch_clicked(0);
    }

    public void button_matkeane() {
        this.link(this.web_button_url);
    }

    public void button_preset_capture_grid() {
        this.project.preset_capture_grid();
    }

    public void button_preset_delete() {
        this.project.preset_current_delete();
    }

    public void button_preset_recall() {
        this.project.preset_recall(this.project.current_preset.id);
    }

    public void button_preset_update() {
        this.project.preset_current_update();
    }

    public void button_project_load() {
        this.selectInput("Please choose a Conditional Layers project file", "file_load_check");
    }

    public void button_project_save() {
        this.ui.project_select_save_folder();
    }

    public void button_server_osc_toggle() {
        this.project.app_server_osc.status_toggle();
    }

    public void button_server_udp_toggle() {
        this.project.app_server_udp.status_toggle();
    }

    public void button_take() {
        this.project.perform_take();
    }

    public void menu_client_select(int menu_id) {
        this.project.client_connection_select(menu_id);
    }

    public void menu_layer_select(int menu_id) {
        this.project.layer_id_set_current(menu_id);
    }

    public void menu_layergroup_select(int menu_id) {
        this.project.layer_group_select(menu_id);
    }

    public void menu_layergroup_type(int menu_id) {
        if (this.project.current_layergroup != null) {
            this.project.current_layergroup.set_type(menu_id);
        }
    }

    public void menu_preset_edit(int menu_id) {
        this.project.preset_current_select(menu_id);
    }

    public void menu_preset_recall(int menu_id) {
        this.project.preset_recall(menu_id);
    }

    public void menu_project_mode(int menu_id) {
        this.project.operating_mode_set(menu_id);
    }

    public void textfield_server_port_udp(String ui_text) {
        this.project.app_server_udp.port_set(ui_text);
    }

    public void textfield_server_port_osc(String ui_text) {
        this.project.app_server_osc.port_set(ui_text);
    }

    public void textfield_client_ip(String ui_text) {
        this.project.client_connection_ui_update("textfield_client_ip", ui_text);
    }

    public void textfield_client_port(String ui_text) {
        this.project.client_connection_ui_update("textfield_client_port", ui_text);
    }

    public void textfield_client_name(String ui_text) {
        this.project.client_connection_ui_update("textfield_client_name", ui_text);
    }

    public void textfield_layer_name(String ui_text) {
        this.project.layer_name_set(this.project.layer_id_current, ui_text);
    }

    public void textfield_layergroup_name(String ui_text) {
        if (this.project.current_layergroup != null) {
            this.project.current_layergroup.set_name(ui_text);
        }
    }

    public void textfield_preset_name(String ui_text) {
        this.project.current_preset.set_name(ui_text);
        this.ui_elements.preset_menus_update();
        this.ui_elements.preset_data_update();
    }

    public void textfield_project_filename(String ui_text) {
        this.project.filename_set(ui_text);
    }

    public void toggle_pref_force_all_layers_to_zero(boolean toggle_status) {
        this.project.preference_toggle("toggle_pref_force_all_layers_to_zero", toggle_status);
    }

    public void toggle_pref_take_auto_switch(boolean toggle_status) {
        this.project.preference_toggle("toggle_pref_take_auto_switch", toggle_status);
    }

    public void toggle_pref_use_keyboard_shortcuts(boolean toggle_status) {
        this.project.preference_toggle("toggle_pref_use_keyboard_shortcuts", toggle_status);
    }

    public void controlEvent(CallbackEvent theEvent) {
        if (this.ui.ready.booleanValue()) {
            Controller ui_control_element = theEvent.getController();
            String ui_control_element_name = ui_control_element.getName();
            int ui_control_element_id = theEvent.getController().getId();
            int event_action_id = theEvent.getAction();
            if (this.is_valid_layer_id(ui_control_element_id).booleanValue() && (event_action_id == 6 || event_action_id == 7)) {
                this.ui.grid_control_rollover(ui_control_element_name, ui_control_element_id, event_action_id);
            }
            switch (theEvent.getAction()) {
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (!this.is_valid_layer_id(ui_control_element_id).booleanValue()) break;
                    this.project.update_layer_value_from_ui(ui_control_element_name, ui_control_element_id);
                    break;
                }
                case 9: {
                    break;
                }
            }
        }
    }

    public void draw_ui_background() {
        int n = this.project.operating_mode;
        this.project.getClass();
        if (n == 3) {
            this.pushStyle();
            this.fill(this.ui.colour_get_by_name("ui_pane_bg_edit"));
            this.rectMode(0);
            this.rect(0.0f, 0.0f, this.width / 2, this.height);
            this.popStyle();
        }
    }

    public void draw_ui_pane() {
        if (this.ui.active.booleanValue()) {
            int i;
            this.fill(this.ui.colour_get_by_name("ui_pane_bg_dark"));
            this.stroke(0);
            this.rectMode(0);
            this.rect(this.ui.get_scaled_size(540), 0.0f, this.ui.get_scaled_size(200), this.height);
            this.rect(0.0f, this.ui_elements.get_ui_pane_origin(), this.width, this.ui_elements.pane_height);
            Boolean draw_ui_layout_grid = false;
            if (this.debug_mode.booleanValue() && draw_ui_layout_grid.booleanValue()) {
                this.pushStyle();
                int grid_size = this.ui.get_scaled_size(20);
                this.noFill();
                this.stroke(75);
                int x = 0;
                while (x < this.width) {
                    this.line(x, 0.0f, x, this.ui_elements.get_ui_pane_origin());
                    int y = 0;
                    while (y < this.ui_elements.get_ui_pane_origin()) {
                        this.line(0.0f, y, this.width, y);
                        y += grid_size;
                    }
                    x += grid_size;
                }
                this.stroke(50.0f, 100.0f, 150.0f);
                this.line(0.0f, this.ui_elements.control_origin_y, this.width, this.ui_elements.control_origin_y);
                this.popStyle();
                this.pushStyle();
                this.stroke(180.0f, 80.0f, 20.0f, 120.0f);
                i = 0;
                while (i < this.ui_elements.grid_row_positions.length) {
                    int row_pos = this.ui_elements.grid_row_positions[i];
                    this.line(0.0f, row_pos, this.width, row_pos);
                    ++i;
                }
                i = 0;
                while (i < this.ui_elements.grid_column_positions.length) {
                    this.line(this.ui_elements.grid_column_positions[i], this.ui_elements.grid_origin[1], this.ui_elements.grid_column_positions[i], this.height);
                    ++i;
                }
                this.stroke(200.0f, 100.0f, 50.0f, 200.0f);
                this.line(this.width / 2, this.ui_elements.grid_origin[1], this.width / 2, this.height);
                i = 0;
                while (i < 3) {
                    int[][] nArray = this.ui_elements.grid_pane_alignments;
                    this.project.getClass();
                    float f = this.ui.get_scaled_size(nArray[0][i]);
                    int[][] nArray2 = this.ui_elements.grid_pane_alignments;
                    this.project.getClass();
                    this.line(f, 0.0f, this.ui.get_scaled_size(nArray2[0][i]), this.height);
                    int[][] nArray3 = this.ui_elements.grid_pane_alignments;
                    this.project.getClass();
                    float f2 = this.ui.get_scaled_size(nArray3[1][i]);
                    int[][] nArray4 = this.ui_elements.grid_pane_alignments;
                    this.project.getClass();
                    this.line(f2, 0.0f, this.ui.get_scaled_size(nArray4[1][i]), this.height);
                    ++i;
                }
                this.popStyle();
            }
            this.pushStyle();
            this.noFill();
            this.stroke(this.ui.colour_get_by_name("outline"));
            float grid_origin_offset = this.ui_elements.layer_grid_button_spacing / 2;
            i = 0;
            while (i < 2) {
                if (i == 0) {
                    this.stroke(this.ui.colour_get_by_name("preview"));
                } else {
                    this.stroke(this.ui.colour_get_by_name("program"));
                }
                this.rect(this.ui.get_scaled_size(this.ui_elements.layer_grid_origins[i].x - grid_origin_offset), this.ui.get_scaled_size(this.ui_elements.layer_grid_origins[i].y - grid_origin_offset), this.ui.get_scaled_size(this.ui_elements.grid_controls_dimensions[0]), this.ui.get_scaled_size(this.ui_elements.grid_controls_dimensions[1]));
                ++i;
            }
            this.stroke(this.ui.colour_get_by_name("outline"));
            this.rect(this.ui.get_scaled_size(560), this.ui.get_scaled_size(this.ui_elements.control_origin_y - 20), this.ui.get_scaled_size(160), this.ui.get_scaled_size(160));
            this.rect(this.ui.get_scaled_size(560), this.ui.get_scaled_size(this.ui_elements.control_origin_y + 160), this.ui.get_scaled_size(160), this.ui.get_scaled_size(120));
            this.rect(this.ui.get_scaled_size(560), this.ui.get_scaled_size(this.ui_elements.control_origin_y + 350), this.ui.get_scaled_size(160), this.ui.get_scaled_size(110));
            this.popStyle();
            this.stroke(this.ui.colour_get_by_name("ui_label"), 100.0f);
            this.strokeWeight(1.0f);
            switch (this.ui.active_tab_id) {
                case 0: {
                    this.draw_logo();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
            this.stroke(this.ui.colour_get_by_name("ui_pane_line"), 255.0f);
            i = 0;
            while (i < this.ui_elements.divider_positions[this.ui.active_tab_id].length) {
                this.line(this.ui_elements.divider_positions[this.ui.active_tab_id][i], this.ui_elements.grid_origin[1] + 42, this.ui_elements.divider_positions[this.ui.active_tab_id][i], this.height);
                ++i;
            }
            this.ui_elements.colour_swatches_update();
        }
    }

    public void draw_message_overlay() {
        if (this.ui.ready.booleanValue()) {
            int time_elapsed = this.millis() - this.ui.overlay_timer;
            if (time_elapsed > this.ui.overlay_duration) {
                this.ui.overlay_opacity = this.ui.overlay_opacity > 0 ? (this.ui.overlay_opacity -= 4) : 0;
            }
            if (this.ui.overlay_opacity > 0 && !this.ui.overlay_text.equals("")) {
                this.pushStyle();
                this.rectMode(0);
                this.fill(this.ui.colour_get_by_name("info_background"), (float)this.ui.overlay_opacity * 0.4f);
                this.noStroke();
                this.pushMatrix();
                this.translate(0.0f, this.ui_elements.pane_origin - this.ui_elements.data_overlay_height);
                this.rect(0.0f, 0.0f, this.width, this.ui_elements.data_overlay_height);
                this.fill(this.ui.colour_get_by_name("info_text"), this.ui.overlay_opacity);
                this.textFont(this.font_display_ui, 12.0f);
                this.textAlign(37, 3);
                this.text(this.ui.overlay_text, this.ui_elements.data_overlay_height, (float)this.ui_elements.data_overlay_height * 0.4f);
                this.popMatrix();
                this.popStyle();
            }
        }
    }

    public void draw_layer_groups() {
        int group_count = this.project.layer_groups.size();
        int grid_id = this.project.get_current_grid_id();
        int rect_size = this.ui_elements.layer_grid_button_size + this.ui_elements.layer_grid_button_spacing;
        int button_size = this.ui_elements.layer_grid_button_size + 2;
        float button_half_size = this.ui_elements.layer_grid_button_size / 2;
        int group_colour = this.ui.colour_get_by_name("ui_pane_line");
        int outline_colour = this.ui.colour_get_by_name("ui_pane_line");
        this.pushStyle();
        this.noStroke();
        this.rectMode(3);
        int i = 0;
        while (i < group_count) {
            LayerGroup group = this.project.layer_groups.get(i);
            group_colour = group.get_colour();
            int[] layer_ids = group.layer_ids.array();
            int j = 0;
            while (j < layer_ids.length) {
                this.fill(group_colour);
                this.rect(this.ui_elements.layer_grid_origins[grid_id].x + this.ui_elements.layer_grid_positions[layer_ids[j]].x + button_half_size, this.ui_elements.layer_grid_origins[grid_id].y + this.ui_elements.layer_grid_positions[layer_ids[j]].y + button_half_size, rect_size, rect_size);
                this.fill(outline_colour);
                this.rect(this.ui_elements.layer_grid_origins[grid_id].x + this.ui_elements.layer_grid_positions[layer_ids[j]].x + button_half_size, this.ui_elements.layer_grid_origins[grid_id].y + this.ui_elements.layer_grid_positions[layer_ids[j]].y + button_half_size, button_size, button_size);
                ++j;
            }
            ++i;
        }
        this.popStyle();
    }

    public void draw_logo() {
        float logo_scale = this.ui.window_scale * 0.36f;
        this.image((PImage)this.ui.logo_image, this.ui_elements.grid_column_positions[3], this.ui_elements.grid_row_positions[0], this.ui.logo_image_dimensions.x * logo_scale, this.ui.logo_image_dimensions.y * logo_scale);
    }

    public void draw_throbber() {
        if (this.ui.file_operation_in_progress.booleanValue()) {
            int viewport_centre_x = WoConditionalLayers.round((float)(this.width / 2));
            int viewport_centre_y = WoConditionalLayers.round((float)((this.height - this.ui_elements.pane_height) / 3));
            int box_size = 175;
            int box_corner_radius = 25;
            int segment_count = 8;
            int segment_size = WoConditionalLayers.round((float)(box_size / 3));
            float segment_alpha = 0.0f;
            float segment_degrees = 360 / segment_count;
            int base_angle = this.millis() / 2 % 360;
            this.rectMode(3);
            this.fill(0.0f, 0.0f, 0.0f, 150.0f);
            this.stroke(this.ui.colour_get_by_name("matkeane"));
            this.pushMatrix();
            this.translate(viewport_centre_x, viewport_centre_y);
            this.rect(0.0f, 0.0f, box_size, box_size, box_corner_radius);
            int i = 0;
            while (i < segment_count) {
                segment_alpha = WoConditionalLayers.map((float)WoConditionalLayers.sin((float)WoConditionalLayers.radians((float)((float)base_angle - segment_degrees * (float)i))), (float)-1.0f, (float)1.0f, (float)0.0f, (float)120.0f);
                this.pushMatrix();
                this.rotate(WoConditionalLayers.radians((float)segment_degrees) * (float)i);
                this.translate((float)box_size * -0.25f, 0.0f);
                this.noStroke();
                this.fill(255.0f, 102.0f, 0.0f, segment_alpha);
                this.ellipse(0.0f, 0.0f, segment_size, segment_size);
                this.popMatrix();
                ++i;
            }
            this.fill(255);
            this.textAlign(3);
            this.textSize(box_corner_radius);
            this.text("Thinking...", 0.0f, (float)box_corner_radius * 0.33f);
            this.popMatrix();
        }
    }

    public void setup_ui_elements() {
        this.ui_elements.controls.setAutoDraw(true);
        ControlFont ui_font = new ControlFont(this.font_display_ui, WoConditionalLayers.round((float)this.ui.get_scaled_size(16)));
        int i = 0;
        while (i < this.ui_elements.tab_name_labels.length) {
            ((Tab)this.ui_elements.controls.addTab(this.ui_elements.tab_name_labels[i][0]).setLabel(this.ui_elements.tab_name_labels[i][1]).setId(i)).activateEvent(true).setWidth(this.ui_elements.tab_dimensions[0]).setHeight(this.ui_elements.tab_dimensions[1]);
            this.ui_elements.controls.getTab((String)this.ui_elements.tab_name_labels[i][0]).getCaptionLabel().getStyle().marginLeft = this.ui_elements.tab_caption_margin_left;
            ++i;
        }
        String control_name = "";
        int layer_id = 0;
        while (layer_id < this.project.layer_count) {
            int control_grid = 0;
            while (control_grid < this.ui_elements.layer_grid_names.length) {
                control_name = String.valueOf(this.ui_elements.layer_grid_button_name_stem) + "_" + this.ui_elements.layer_grid_names[control_grid] + "_" + String.valueOf(layer_id);
                ((Bang)((Bang)((Bang)((Bang)this.ui_elements.controls.addBang(control_name).setId(layer_id)).setTriggerEvent(2).moveTo("global")).setLabel(String.valueOf(this.get_number_from_id(layer_id)))).setFont(ui_font)).getCaptionLabel().align(3, 3);
                ++control_grid;
            }
            ++layer_id;
        }
        this.ui_elements.controls.addTextlabel("label_header_preview", "PREVIEW", 0, 0).moveTo("global");
        this.ui_elements.controls.addTextlabel("label_header_program", "PROGRAM", 0, 0).moveTo("global");
        this.ui_elements.controls.addTextlabel("label_data_prev", "BINARY:\nINTEGER:", 0, 0).moveTo("global");
        this.ui_elements.controls.addTextlabel("label_data_main", "BINARY:\nINTEGER:", 0, 0).moveTo("global");
        this.ui_elements.controls.addTextlabel("label_header_network", "NETWORK", 0, 0).moveTo("global");
        this.ui_elements.controls.addTextlabel("label_controls_network_receive", "LISTENING", 0, 0).moveTo("global");
        this.ui_elements.controls.addTextlabel("label_controls_network_send", "SENDING", 0, 0).moveTo("global");
        ((Button)((Button)this.ui_elements.controls.addButton("button_take").setColorBackground(this.ui.colour_get_by_name("matkeane"))).setLabel("TAKE")).moveTo("global");
        ((Button)this.ui_elements.controls.addButton("button_copy_main_to_preview").setLabel("\u2190 COPY PROGRAM")).moveTo("global");
        ((Button)this.ui_elements.controls.addButton("button_app_broadcast_toggle").setLabel("OFFLINE")).moveTo("group_network");
        ((Button)((Button)this.ui_elements.controls.addButton("button_app_broadcast_status").setLabel("OFFLINE")).setLock(true)).moveTo("global");
        ((Button)this.ui_elements.controls.addButton("button_layer_all_enable").setLabel("ALL ON")).moveTo("global");
        ((Button)this.ui_elements.controls.addButton("button_layer_all_disable").setLabel("ALL OFF")).moveTo("global");
        ((Button)this.ui_elements.controls.addButton("button_preset_capture_grid").setCaptionLabel("PRESET +")).moveTo("global");
        String version_text = String.valueOf(this.app_title) + " - version " + this.app_version;
        this.ui_elements.controls.addTextlabel("label_app_version", version_text, 0, 0);
        String about_blurb = String.valueOf(this.app_title) + " for Watchout\n\n";
        about_blurb = String.valueOf(about_blurb) + "\u00a9 copyright " + this.copyright_year_end + " Matthew Keane \n\n";
        about_blurb = String.valueOf(about_blurb) + "Built with Processing";
        this.ui_elements.controls.addTextlabel("label_app_about", about_blurb, 0, 0);
        ((Button)this.ui_elements.controls.addButton("button_matkeane").setLabel("matkeane.com")).setColorBackground(this.ui.colour_get_by_name("matkeane"));
        Textarea ui_textarea_licence = this.ui_elements.controls.addTextarea("textarea_licence");
        String licence_text = "Copyright (c) " + this.copyright_year_end + " Matthew Keane\n";
        licence_text = String.valueOf(licence_text) + "\n";
        licence_text = String.valueOf(licence_text) + "Permission to use, copy, modify, and/or distribute this software for any purpose ";
        licence_text = String.valueOf(licence_text) + "with or without fee is hereby granted, provided that the above copyright notice ";
        licence_text = String.valueOf(licence_text) + "and this permission notice appear in all copies.\n";
        licence_text = String.valueOf(licence_text) + "\n";
        licence_text = String.valueOf(licence_text) + "THE SOFTWARE IS PROVIDED \"AS IS\" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH ";
        licence_text = String.valueOf(licence_text) + "REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND ";
        licence_text = String.valueOf(licence_text) + "FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, ";
        licence_text = String.valueOf(licence_text) + "INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS ";
        licence_text = String.valueOf(licence_text) + "OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER ";
        licence_text = String.valueOf(licence_text) + "TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF ";
        licence_text = String.valueOf(licence_text) + "THIS SOFTWARE.";
        ui_textarea_licence.setText(licence_text);
        this.ui_elements.controls.addTextlabel("label_project_save", "Save/Load Project Settings", 0, 0);
        ((Button)this.ui_elements.controls.addButton("button_project_load").setLabel("LOAD")).setColorBackground(this.ui.colour_get_by_name("matkeane"));
        ((Button)this.ui_elements.controls.addButton("button_project_save").setLabel("SAVE")).setColorBackground(this.ui.colour_get_by_name("matkeane"));
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_project_filename", 0, 0, 20, 20).setCaptionLabel("Project File Name:")).setText("").setAutoClear(false);
        this.ui_elements.controls.addTextlabel("label_server_reception", "MESSAGE RECEPTION", 0, 0).moveTo("group_network");
        this.ui_elements.controls.addTextlabel("label_server_sending", "BROADCASTING", 0, 0).moveTo("group_network");
        this.ui_elements.controls.addTextlabel("label_client_count", "0 Clients", 0, 0).moveTo("group_network");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_server_port_udp", 0, 0, 20, 20).setCaptionLabel("UDP Port:")).setText(String.valueOf(this.project.app_port_udp)).setAutoClear(false).moveTo("group_network");
        ((Button)this.ui_elements.controls.addButton("button_server_udp_toggle").setLabel("OFFLINE")).moveTo("group_network");
        ((Button)((Button)this.ui_elements.controls.addButton("button_server_udp_status").setLabel("UDP")).setLock(true)).moveTo("global");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_server_port_osc", 0, 0, 20, 20).setCaptionLabel("OSC Port:")).setText(String.valueOf(this.project.app_port_osc)).setAutoClear(false).moveTo("group_network");
        ((Button)this.ui_elements.controls.addButton("button_server_osc_toggle").setLabel("OFFLINE")).moveTo("group_network");
        ((Button)((Button)this.ui_elements.controls.addButton("button_server_osc_status").setLabel("OSC")).setLock(true)).moveTo("global");
        ((Button)this.ui_elements.controls.addButton("button_client_add").setCaptionLabel("ADD")).moveTo("group_network");
        ((Button)((Button)this.ui_elements.controls.addButton("button_client_delete").setCaptionLabel("DELETE")).setColorBackground(this.ui.colour_get_by_name("button_status_warning"))).moveTo("group_network");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_client_ip", 0, 0, 20, 20).setCaptionLabel("Client IP4:")).setText("").setAutoClear(false).moveTo("group_network");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_client_port", 0, 0, 20, 20).setCaptionLabel("Port:")).setText("").setAutoClear(false).moveTo("group_network");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_client_name", 0, 0, 20, 20).setCaptionLabel("Name (Optional):")).setText("").setAutoClear(false).moveTo("group_network");
        ((Button)this.ui_elements.controls.addButton("button_client_textfields_clear").setCaptionLabel("CLEAR FIELDS")).moveTo("group_network");
        ((Button)this.ui_elements.controls.addButton("button_client_port_production").setCaptionLabel("PRODUCTION")).moveTo("group_network");
        ((Button)this.ui_elements.controls.addButton("button_client_port_display").setCaptionLabel("DISPLAY")).moveTo("group_network");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_layer_name", 0, 0, 20, 20).setCaptionLabel("")).setText("- Layer Name -").setAutoClear(false).moveTo("group_layergroups");
        this.ui_elements.controls.addTextlabel("label_layer_name_machine", "", 0, 0).moveTo("group_layergroups");
        ((Button)this.ui_elements.controls.addButton("button_layergroup_add").setCaptionLabel("ADD GROUP")).moveTo("group_layergroups");
        ((Button)((Button)this.ui_elements.controls.addButton("button_layergroup_delete").setCaptionLabel("DELETE")).setColorBackground(this.ui.colour_get_by_name("button_status_warning"))).moveTo("group_layergroups");
        ((Button)this.ui_elements.controls.addButton("button_layergroup_edit").setCaptionLabel("EDIT LAYERS")).moveTo("group_layergroups");
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_layergroup_name", 0, 0, 20, 20).setCaptionLabel("")).setText("- Group Name -").setAutoClear(false).moveTo("group_layergroups");
        this.ui_elements.controls.addTextlabel("label_layergroup_member_count", "", 0, 0).moveTo("group_layergroups");
        this.ui_elements.controls.addTextlabel("label_layergroup_name_machine", "", 0, 0).moveTo("group_layergroups");
        ((Button)this.ui_elements.controls.addButton("button_layergroup_swatch").setCaptionLabel("Colour:")).moveTo("group_layergroups");
        ((ColorWheel)((ColorWheel)((ColorWheel)this.ui_elements.controls.addColorWheel("colourwheel", 250, 10, this.ui_elements.colourpicker_size).setLabelVisible(false)).hide()).moveTo("global")).addCallback(new CallbackListener(){

            public void controlEvent(CallbackEvent theEvent) {
                WoConditionalLayers.this.ui.colourpicker_event(theEvent.getAction());
            }
        });
        ((Textfield)this.ui_elements.controls.addTextfield("textfield_preset_name", 0, 0, 20, 20).setCaptionLabel("Preset Name (Optional):")).setText("- Preset Name -").setAutoClear(false).moveTo("group_presets");
        this.ui_elements.controls.addTextlabel("label_preset_name_machine", "MACHINE_NAME", 0, 0).moveTo("group_presets");
        ((Button)this.ui_elements.controls.addButton("button_preset_update").setCaptionLabel("UPDATE")).moveTo("group_presets");
        ((Button)this.ui_elements.controls.addButton("button_preset_recall").setCaptionLabel("RECALL")).moveTo("group_presets");
        ((Button)((Button)this.ui_elements.controls.addButton("button_preset_delete").setCaptionLabel("DELETE")).setColorBackground(this.ui.colour_get_by_name("button_status_warning"))).moveTo("group_presets");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_pref_take_auto_switch").setCaptionLabel("A/B AUTO SWITCHING")).setState(this.project.pref_take_auto_switch.booleanValue()).moveTo("group_help");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_pref_use_keyboard_shortcuts").setCaptionLabel("KEYBOARD SHORTCUTS")).setState(this.project.pref_use_keyboard_shortcuts.booleanValue()).moveTo("group_help");
        ((Toggle)this.ui_elements.controls.addToggle("toggle_pref_force_all_layers_to_zero").setCaptionLabel("FORCE ALL LAYERS OFF")).setState(this.project.pref_force_all_layers_to_zero.booleanValue()).moveTo("group_help");
        this.ui_elements.dropdownlist_client_select = this.ui_elements.controls.addScrollableList("menu_client_select", 0, 0, 140, 100);
        this.ui_elements.dropdownlist_client_select.setBackgroundColor(this.color(120));
        this.ui_elements.dropdownlist_client_select.setCaptionLabel("Client Connections");
        this.ui_elements.dropdownlist_client_select.setBarHeight(20);
        this.ui_elements.dropdownlist_client_select.setItemHeight(18);
        this.ui_elements.dropdownlist_client_select.setValue(0.0f);
        this.ui_elements.dropdownlist_client_select.setOpen(false);
        this.ui_elements.dropdownlist_client_select.moveTo("group_network");
        this.ui_elements.dropdownlist_layergroup_select = this.ui_elements.controls.addScrollableList("menu_layergroup_select", 0, 0, 140, 100);
        this.ui_elements.dropdownlist_layergroup_select.setBackgroundColor(this.color(120));
        this.ui_elements.dropdownlist_layergroup_select.setCaptionLabel("Layer Groups");
        this.ui_elements.dropdownlist_layergroup_select.setBarHeight(20);
        this.ui_elements.dropdownlist_layergroup_select.setItemHeight(18);
        this.ui_elements.dropdownlist_layergroup_select.setValue(0.0f);
        this.ui_elements.dropdownlist_layergroup_select.setOpen(false);
        this.ui_elements.dropdownlist_layergroup_select.moveTo("group_layergroups");
        this.ui_elements.dropdownlist_layergroup_type = this.ui_elements.controls.addScrollableList("menu_layergroup_type", 0, 0, 140, 100);
        this.ui_elements.dropdownlist_layergroup_type.setBackgroundColor(this.color(120));
        this.ui_elements.dropdownlist_layergroup_type.setCaptionLabel("Group Behaviour");
        this.ui_elements.dropdownlist_layergroup_type.setBarHeight(20);
        this.ui_elements.dropdownlist_layergroup_type.setItemHeight(18);
        String[] layergroup_type_list = new String[]{"None (Visual only)", "Radio Buttons", "Linked", "Toggle", "Locked"};
        int i2 = 0;
        while (i2 < layergroup_type_list.length) {
            this.ui_elements.dropdownlist_layergroup_type.addItem(layergroup_type_list[i2], (Object)i2);
            ++i2;
        }
        this.ui_elements.dropdownlist_layergroup_type.setValue(0.0f);
        this.ui_elements.dropdownlist_layergroup_type.setCaptionLabel("Group Behaviour");
        this.ui_elements.dropdownlist_layergroup_type.setOpen(false);
        this.ui_elements.dropdownlist_layergroup_type.moveTo("group_layergroups");
        this.ui_elements.dropdownlist_layer_select = this.ui_elements.controls.addScrollableList("menu_layer_select", 0, 0, 140, 100);
        this.ui_elements.dropdownlist_layer_select.setBroadcast(false);
        this.ui_elements.dropdownlist_layer_select.setBackgroundColor(this.color(120));
        this.ui_elements.dropdownlist_layer_select.setCaptionLabel("Layer Select");
        this.ui_elements.dropdownlist_layer_select.setBarHeight(20);
        this.ui_elements.dropdownlist_layer_select.setItemHeight(18);
        i2 = 0;
        while (i2 < this.project.layer_count) {
            String item_label = "Layer " + this.get_number_from_id(i2);
            this.ui_elements.dropdownlist_layer_select.addItem(item_label, (Object)i2);
            ++i2;
        }
        this.ui_elements.dropdownlist_layer_select.setValue(0.0f);
        this.ui_elements.dropdownlist_layer_select.setOpen(false);
        this.ui_elements.dropdownlist_layer_select.moveTo("group_layergroups");
        this.ui_elements.dropdownlist_layer_select.setBroadcast(true);
        this.ui_elements.dropdownlist_preset_recall = this.ui_elements.controls.addScrollableList("menu_preset_recall", 0, 0, 140, 100);
        this.ui_elements.dropdownlist_preset_recall.setBackgroundColor(this.color(120));
        this.ui_elements.dropdownlist_preset_recall.setCaptionLabel("Preset Recall");
        this.ui_elements.dropdownlist_preset_recall.setBarHeight(20);
        this.ui_elements.dropdownlist_preset_recall.setItemHeight(18);
        this.ui_elements.dropdownlist_preset_recall.setValue(0.0f);
        this.ui_elements.dropdownlist_preset_recall.setOpen(false);
        this.ui_elements.dropdownlist_preset_recall.moveTo("global");
        this.ui_elements.dropdownlist_preset_edit = this.ui_elements.controls.addScrollableList("menu_preset_edit", 0, 0, 140, 100);
        this.ui_elements.dropdownlist_preset_edit.setBackgroundColor(this.color(120));
        this.ui_elements.dropdownlist_preset_edit.setCaptionLabel("Preset Edit");
        this.ui_elements.dropdownlist_preset_edit.setBarHeight(20);
        this.ui_elements.dropdownlist_preset_edit.setItemHeight(18);
        this.ui_elements.dropdownlist_preset_edit.setValue(0.0f);
        this.ui_elements.dropdownlist_preset_edit.setOpen(false);
        this.ui_elements.dropdownlist_preset_edit.moveTo("group_presets");
        this.ui_elements.dropdownlist_project_mode = this.ui_elements.controls.addScrollableList("menu_project_mode", 0, 0, 140, 100);
        this.ui_elements.dropdownlist_project_mode.setBackgroundColor(this.color(120));
        this.ui_elements.dropdownlist_project_mode.setCaptionLabel("Operation Mode");
        this.ui_elements.dropdownlist_project_mode.setBarHeight(20);
        this.ui_elements.dropdownlist_project_mode.setItemHeight(18);
        int project_mode_count = this.project.operating_mode_labels.length;
        int i3 = 0;
        while (i3 < project_mode_count) {
            String item_label = this.project.operating_mode_labels[i3];
            this.ui_elements.dropdownlist_project_mode.addItem(item_label, (Object)i3);
            ++i3;
        }
        this.ui_elements.dropdownlist_project_mode.setValue(0.0f);
        this.ui_elements.dropdownlist_project_mode.setOpen(false);
        this.ui_elements.dropdownlist_project_mode.moveTo("global");
        this.ui.ready = true;
        this.ui_elements.move_controls();
        this.ui_elements.update_all_controls();
        this.debug_output("UI elements setup: " + this.ui.ready);
    }

    public float calculate_reciprocal_scale() {
        return 1.0f / (this.ui.stage_scale / 100.0f);
    }

    public String convert_stringlist_to_string(StringList string_list) {
        String string_output = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)string_list);
        return string_output;
    }

    public void debug_output(String debug_string) {
        if (this.debug_mode.booleanValue()) {
            WoConditionalLayers.println((String)debug_string);
        }
    }

    public String generate_timestamp() {
        LocalDateTime timestamp_now = LocalDateTime.now();
        return timestamp_now.format(this.project.timestamp_formatter);
    }

    public int[] get_array_from_binary_string(String binary_string) {
        int binary_length = binary_string.length();
        int[] binary_array = new int[WoConditionalLayers.min((int)binary_length, (int)this.project.layer_count)];
        int array_index = 0;
        int i = 0;
        while (i < binary_length) {
            array_index = this.project.layer_count - i - 1;
            binary_array[array_index] = Integer.valueOf(binary_string.substring(i, i + 1));
            ++i;
        }
        return binary_array;
    }

    public String get_binary_string_from_array(int[] grid_values_array) {
        String binary_string = "";
        int i = 0;
        while (i < grid_values_array.length) {
            binary_string = String.valueOf(String.valueOf(grid_values_array[i])) + binary_string;
            ++i;
        }
        return binary_string;
    }

    public String get_binary_from_int(int int_val) {
        String binary_string = WoConditionalLayers.binary((int)int_val, (int)this.project.layer_count);
        return binary_string;
    }

    public int get_boolean_as_int(Boolean boolean_value) {
        return boolean_value != false ? 1 : 0;
    }

    public Float get_boolean_as_float(Boolean boolean_value) {
        if (boolean_value.booleanValue()) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf(0.0f);
    }

    public String get_boolean_as_string(Boolean boolean_value) {
        if (boolean_value.booleanValue()) {
            return "true";
        }
        return "false";
    }

    public Boolean get_boolean_from_int(int boolean_int) {
        if (boolean_int != 0) {
            return true;
        }
        return false;
    }

    public Boolean get_boolean_from_float(float boolean_float) {
        if (boolean_float != 0.0f) {
            return true;
        }
        return false;
    }

    public Boolean get_boolean_from_string(String boolean_string) {
        if ((boolean_string = this.sanitize_string(boolean_string)).equals("true") || boolean_string.equals("on")) {
            return true;
        }
        if (boolean_string.equals("false") || boolean_string.equals("off")) {
            return false;
        }
        return false;
    }

    public int get_colour_from_status(int status, Boolean invert) {
        if (invert.booleanValue()) {
            status = this.toggle_status(status);
        }
        if (status == 1) {
            return this.ui.colours.get("ui_layer_enabled");
        }
        return this.ui.colours.get("ui_layer_disabled");
    }

    public int get_colour_from_boolean_status(Boolean status, Boolean invert) {
        if (invert.booleanValue()) {
            status = this.toggle_status(status);
        }
        if (status.booleanValue()) {
            return this.ui.colours.get("ui_layer_enabled");
        }
        return this.ui.colours.get("ui_layer_disabled");
    }

    public String get_grid_name_from_control(String ui_control_element_name) {
        return ui_control_element_name.substring(5, 9);
    }

    public int get_int_from_binary_string(String binary_string) {
        return Integer.parseUnsignedInt(binary_string, 2);
    }

    public int get_id_from_number(int number) {
        return number - 1;
    }

    public int get_number_from_id(int index) {
        return index + 1;
    }

    public String get_current_date_string() {
        String date_string = "";
        int d = WoConditionalLayers.day();
        int m = WoConditionalLayers.month();
        int y = WoConditionalLayers.year();
        String year_string = String.valueOf(y);
        date_string = String.valueOf(date_string) + year_string.substring(2);
        date_string = String.valueOf(date_string) + WoConditionalLayers.nf((float)m, (int)2, (int)0);
        date_string = String.valueOf(date_string) + WoConditionalLayers.nf((float)d, (int)2, (int)0);
        return date_string;
    }

    public int get_network_command_id(String command) {
        int network_command_id = -1;
        if (this.project.network_command_alias_list.hasKey(command = this.sanitize_network_string(command))) {
            network_command_id = this.project.network_command_alias_list.get(command);
        }
        return network_command_id;
    }

    public int get_power_from_int(int int_val) {
        int layer_power = (int)WoConditionalLayers.pow((float)2.0f, (float)(int_val - 1));
        return layer_power;
    }

    public boolean is_float(String string) {
        try {
            Float.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean is_integer(String string) {
        try {
            Integer.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean is_ip4_address(String check_ip) {
        String match_pattern = "(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)";
        String[] match_ip = WoConditionalLayers.match((String)check_ip, (String)match_pattern);
        if (match_ip != null) {
            return true;
        }
        this.ui.message_display("Error: Invalid IP address (" + check_ip + ").");
        return false;
    }

    public boolean is_valid_layer_num(String layer_id) {
        if (this.is_integer(layer_id)) {
            int layer_num_int = Integer.valueOf(layer_id);
            return this.is_valid_layer_num(layer_num_int);
        }
        return false;
    }

    public boolean is_valid_layer_num(int layer_num) {
        return layer_num > 0 && layer_num <= this.project.layer_count;
    }

    public Boolean is_valid_layer_id(int check_layer_id) {
        if (check_layer_id >= 0 && check_layer_id < this.project.layer_id_group_lookup.length) {
            return true;
        }
        return false;
    }

    public boolean is_valid_network_command(String command) {
        command = this.sanitize_network_string(command);
        return this.project.network_command_alias_list.hasKey(command);
    }

    public boolean is_valid_port(int port_number) {
        if (port_number > 0 && port_number < 65536) {
            return true;
        }
        this.ui.message_display("Error: Invalid port number (" + port_number + ").");
        return false;
    }

    public boolean is_valid_preset_num(String preset_id) {
        if (this.is_integer(preset_id)) {
            int preset_id_int = this.get_id_from_number(Integer.valueOf(preset_id));
            return this.is_valid_preset_id(preset_id_int) != false;
        }
        return false;
    }

    public Boolean is_valid_preset_id(int check_preset_id) {
        if (check_preset_id >= 0 && check_preset_id < this.project.layer_presets.size()) {
            return true;
        }
        return false;
    }

    public String sanitize_network_string(String name) {
        String name_trimmed = name.trim();
        String machine_name = name_trimmed.replaceAll("\\s", "_");
        machine_name = machine_name.toLowerCase();
        return machine_name;
    }

    public String sanitize_string(String message) {
        String message_trimmed = message.trim();
        String message_stripped = message_trimmed.replaceAll("\"", "");
        return message_stripped;
    }

    public void test_commands() {
        this.project.client_connection_add("172.16.123.130", 3040, "Test Connection 1");
        this.project.network_message_add("Connect", "127.0.0.1", 2020, 0);
        this.project.network_message_add("enable_condition 1", "127.0.0.1", 2020, 0);
        this.project.network_message_add("enable_layer 4", "127.0.0.1", 2020, 1);
        this.project.network_message_add("setlayer 21 true", "127.0.0.1", 2020, 0);
        this.project.network_message_add("enable_condition 13", "127.0.0.1", 2020, 0);
        this.project.layer_group_add();
        LayerGroup layer_group = this.project.layer_groups.get(0);
        layer_group.set_name("Group 1");
        layer_group.set_colour(this.color(128, 30, 180));
        layer_group.set_type(1);
        layer_group.add_layer(1);
        layer_group.add_layer(7);
        layer_group.add_layer(13);
        layer_group.add_layer(0);
        this.project.layer_group_add();
        LayerGroup layer_group_1 = this.project.layer_groups.get(1);
        layer_group_1.set_name("Group 2");
        layer_group_1.set_colour(this.color(30, 180, 128));
        layer_group_1.set_type(2);
        layer_group_1.add_layer(3);
        layer_group_1.add_layer(9);
        layer_group_1.add_layer(15);
        this.project.network_message_add("enable_layer 5", "127.0.0.1", 2020, 0);
        this.project.layer_group_add();
        LayerGroup layer_group_2 = this.project.layer_groups.get(2);
        layer_group_2.set_name("Group 3");
        layer_group_2.set_colour(this.color(180, 128, 30));
        this.project.network_message_add("enable_condition 6", "127.0.0.1", 2020, 0);
        layer_group_2.set_type(3);
        layer_group_2.add_layer(6);
        layer_group_2.add_layer(12);
        layer_group_2.add_layer(18);
        this.project.network_message_add("enable_condition 15", "127.0.0.1", 2020, 0);
        this.project.network_message_add("enable_condition 17", "127.0.0.1", 2020, 0);
        this.project.preset_capture_grid();
        this.project.network_message_add("disable_all", "127.0.0.1", 2020, 0);
        this.project.network_message_add("preset 1", "127.0.0.1", 2020, 0);
        this.project.network_message_add("take", "127.0.0.1", 2020, 0);
    }

    public Boolean toggle_status(boolean current_status) {
        return !current_status;
    }

    public int toggle_status(int current_status) {
        if (current_status == 1) {
            return 0;
        }
        return 1;
    }

    public void settings() {
        this.size(1280, 720, "processing.opengl.PGraphics2D");
        this.smooth();
        this.pixelDensity(1);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"WoConditionalLayers"};
        if (passedArgs != null) {
            PApplet.main((String[])WoConditionalLayers.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class AppClient {
        int id;
        String ip_address;
        int port;
        String name;

        AppClient(int new_id, String new_ip_address, int new_port) {
            this.id = new_id;
            this.ip_address = new_ip_address;
            this.port = new_port;
            this.set_name(this.check_local_ip(this.ip_address));
        }

        public String check_local_ip(String address) {
            if (address.equals("127.0.0.1")) {
                return "Localhost";
            }
            return address;
        }

        public String get_address() {
            return this.ip_address;
        }

        public int get_port() {
            return this.port;
        }

        public void set_ip_address(String new_address) {
            if (WoConditionalLayers.this.is_ip4_address(new_address) && !this.ip_address.equals(new_address)) {
                WoConditionalLayers.this.debug_output("Setting address for Client id: " + this.id);
                WoConditionalLayers.this.project.client_ip_lookup_list.remove(this.ip_address);
                if (this.name.equals(this.ip_address)) {
                    this.set_name(this.check_local_ip(new_address));
                }
                this.ip_address = new_address;
                WoConditionalLayers.this.ui.message_display("Client connection " + WoConditionalLayers.this.get_number_from_id(this.id) + " address set to: " + this.ip_address);
                WoConditionalLayers.this.project.client_ip_lookup_list.add(this.ip_address, this.id);
                WoConditionalLayers.this.ui_elements.client_connections_menu_update();
            }
        }

        public void set_name(String new_name) {
            this.name = !(new_name = WoConditionalLayers.this.sanitize_string(new_name)).equals("") ? new_name : this.check_local_ip(this.ip_address);
            WoConditionalLayers.this.ui.message_display("Renamed client connection " + WoConditionalLayers.this.get_number_from_id(this.id) + " as: " + this.name);
        }

        public void set_port(int new_port) {
            if (WoConditionalLayers.this.is_valid_port(new_port)) {
                this.port = new_port;
                WoConditionalLayers.this.ui.message_display("Client connection " + WoConditionalLayers.this.get_number_from_id(this.id) + " port set to: " + new_port);
            }
        }

        public XML xml_generate() {
            XML xml_client = new XML("client_connection");
            xml_client.setString("ip", this.ip_address);
            xml_client.setInt("port", this.port);
            xml_client.setString("name", this.name);
            return xml_client;
        }
    }

    public class AppServer {
        final int SERVER_UDP = 0;
        final int SERVER_OSC = 1;
        int id;
        int port;
        int type;
        Boolean status_active;
        OscP5 app_connection_osc;
        OscProperties osc_properties;
        UDP app_connection_udp;

        AppServer(int server_type) {
            this.type = server_type;
            this.status_active = false;
            switch (this.type) {
                case 0: {
                    this.port = 50005;
                    break;
                }
                case 1: {
                    this.osc_properties = new OscProperties();
                    this.port = 12000;
                    this.osc_properties.setListeningPort(this.port);
                }
            }
        }

        public void oscEvent(OscMessage message) {
            WoConditionalLayers.this.debug_output("- - -");
            WoConditionalLayers.this.debug_output("Received new OSC message at : " + WoConditionalLayers.this.generate_timestamp());
            WoConditionalLayers.this.debug_output("OSC connection from: " + message.netAddress().address() + " port: " + message.netAddress().port() + " addrpattern: " + message.addrPattern() + " typetag: " + message.typetag());
            String network_message_contents = "";
            if (message.addrPattern().equals("/mk/layer/enable")) {
                if (message.checkTypetag("i")) {
                    network_message_contents = "enable_layer " + message.get(0).intValue();
                }
                if (message.checkTypetag("s") && WoConditionalLayers.this.sanitize_string(message.get(0).stringValue()).equals("all")) {
                    network_message_contents = "enable_all";
                }
            }
            if (message.addrPattern().equals("/mk/layer/enable/all")) {
                network_message_contents = "enable_all";
            }
            if (message.addrPattern().equals("/mk/layer/disable")) {
                if (message.checkTypetag("i")) {
                    network_message_contents = "disable_layer " + message.get(0).intValue();
                }
                if (message.checkTypetag("s") && WoConditionalLayers.this.sanitize_string(message.get(0).stringValue()).equals("all")) {
                    network_message_contents = "disable_all";
                }
            }
            if (message.addrPattern().equals("/mk/layer/disable/all")) {
                network_message_contents = "disable_all";
            }
            if (message.addrPattern().equals("/mk/layer/set")) {
                if (message.checkTypetag("ii")) {
                    network_message_contents = "layer_set " + message.get(0).intValue() + " " + message.get(1).intValue();
                }
                if (message.checkTypetag("iT")) {
                    network_message_contents = "layer_set " + message.get(0).intValue() + " true";
                }
                if (message.checkTypetag("iF")) {
                    network_message_contents = "layer_set " + message.get(0).intValue() + " false";
                }
            }
            if (message.addrPattern().equals("/mk/layer/toggle") && message.checkTypetag("i")) {
                network_message_contents = "toggle_layer " + message.get(0).intValue();
            }
            if (message.addrPattern().equals("/mk/preset") && message.checkTypetag("i")) {
                network_message_contents = "recall_preset " + message.get(0).intValue();
            }
            if (message.addrPattern().equals("/mk/server/connect")) {
                network_message_contents = "client_connect " + message.netAddress().address();
            }
            if (message.addrPattern().equals("/mk/server/disconnect")) {
                network_message_contents = "client_disconnect " + message.netAddress().address();
            }
            message.addrPattern().equals("/mk/server/test");
            if (message.addrPattern().equals("/mk/take")) {
                network_message_contents = "take";
            }
            if (!network_message_contents.equals("")) {
                WoConditionalLayers.this.debug_output(network_message_contents);
                WoConditionalLayers.this.project.network_message_add(network_message_contents, message.netAddress().address(), message.netAddress().port(), 2);
            }
        }

        public void oscStatus(OscStatus osc_status) {
            WoConditionalLayers.this.debug_output("oscStatus: " + osc_status.id());
        }

        public void receive(byte[] data, String ip, int port) {
            String message = new String(data);
            message = WoConditionalLayers.this.sanitize_string(message);
            WoConditionalLayers.this.debug_output("- - -");
            WoConditionalLayers.this.debug_output("Received new UDP message at : " + WoConditionalLayers.this.generate_timestamp());
            WoConditionalLayers.this.debug_output("received: " + message + " from " + ip + " on port " + port);
            if (!message.equals("")) {
                WoConditionalLayers.this.project.network_message_add(message, ip, port, 2);
            }
        }

        public int port_get() {
            return this.port;
        }

        public void port_set(int new_port) {
            if (WoConditionalLayers.this.is_valid_port(new_port) && new_port != this.port) {
                this.port = new_port;
                if (this.type == 0) {
                    this.start();
                }
                if (this.type == 1) {
                    this.stop();
                    this.osc_properties.setListeningPort(this.port);
                    this.start();
                }
            }
        }

        public void port_set(String port_string) {
            if (WoConditionalLayers.this.is_integer(port_string = WoConditionalLayers.this.sanitize_string(port_string))) {
                this.port_set(Integer.valueOf(port_string));
            } else {
                WoConditionalLayers.this.debug_output("Error: UI Input for Port number does not appear to be an Integer.");
            }
        }

        public Boolean status_get() {
            return this.status_active;
        }

        public void status_toggle() {
            if (this.type == 0 && this.app_connection_udp != null) {
                if (!this.app_connection_udp.isListening()) {
                    this.app_connection_udp.listen(true);
                } else {
                    this.app_connection_udp.listen(false);
                }
                this.status_active = this.app_connection_udp.isListening();
            }
            if (this.type == 1) {
                if (this.app_connection_osc != null) {
                    if (this.status_active.booleanValue()) {
                        this.stop();
                    } else {
                        this.start();
                    }
                } else {
                    this.start();
                }
            }
            WoConditionalLayers.this.debug_output("Server type " + this.type + " toggling status to: " + this.status_active);
            WoConditionalLayers.this.ui_elements.network_status_controls_update();
        }

        public void start() {
            if (this.type == 0) {
                if (this.app_connection_udp != null) {
                    this.app_connection_udp.listen(false);
                    this.app_connection_udp.close();
                }
                this.app_connection_udp = new UDP((Object)this, this.port);
                this.app_connection_udp.listen(true);
                this.status_active = this.app_connection_udp.isListening();
                WoConditionalLayers.this.debug_output("UDP server running on port " + this.app_connection_udp.port());
            }
            if (this.type == 1) {
                this.app_connection_osc = new OscP5((Object)this, this.osc_properties);
                this.status_active = true;
            }
            WoConditionalLayers.this.ui_elements.network_status_controls_update();
        }

        public void stop() {
            if (this.type == 0 && this.app_connection_udp != null) {
                this.app_connection_udp.listen(false);
            }
            if (this.type == 1 && this.app_connection_osc != null) {
                this.app_connection_osc.stop();
                this.app_connection_osc.dispose();
            }
            this.status_active = false;
            WoConditionalLayers.this.ui_elements.network_status_controls_update();
        }

        public XML xml_generate() {
            XML xml_server = new XML("app_server");
            xml_server.setString("status", WoConditionalLayers.this.get_boolean_as_string(this.status_active));
            xml_server.setInt("port", this.port);
            if (this.type == 0) {
                xml_server.setString("type", "UDP");
            } else {
                xml_server.setString("type", "OSC");
            }
            return xml_server;
        }
    }

    public class LayerGroup {
        int id;
        String name;
        String machine_name;
        IntList layer_ids = new IntList();
        int colour;
        int type = 0;
        final int DEFAULT = 0;
        final int RADIO = 1;
        final int LINKED = 2;
        final int TOGGLE = 3;
        final int LOCKED = 4;
        int type_enum_max = 4;

        LayerGroup(int new_id) {
            this.id = new_id;
            this.set_name("");
            this.set_colour(WoConditionalLayers.this.ui.colour_get_by_name("matkeane"));
        }

        public void debug() {
            String output = "LayerGroup " + this.id;
            WoConditionalLayers.this.debug_output(output);
            WoConditionalLayers.println((Object)this.layer_ids);
        }

        public void add_layer(int layer_num_add) {
            if (WoConditionalLayers.this.is_valid_layer_num(layer_num_add)) {
                int layer_index = WoConditionalLayers.this.get_id_from_number(layer_num_add);
                if (!this.layer_ids.hasValue(layer_index)) {
                    this.layer_ids.append(layer_index);
                    WoConditionalLayers.this.project.layer_group_lookup_set(layer_index, this.id);
                    WoConditionalLayers.this.debug_output("Added layer Num (" + layer_num_add + ") to Layer Group " + this.id);
                    WoConditionalLayers.this.ui_elements.layer_group_data_update();
                }
            } else {
                WoConditionalLayers.this.debug_output("Error: Cannot add invalid layer Num (" + layer_num_add + ") to Layer Group " + this.id);
            }
        }

        public void layer_toggle_status(int layer_id) {
            if (WoConditionalLayers.this.is_valid_layer_id(layer_id).booleanValue()) {
                if (!this.layer_ids.hasValue(layer_id)) {
                    this.add_layer(WoConditionalLayers.this.get_number_from_id(layer_id));
                } else {
                    this.remove_layer(WoConditionalLayers.this.get_number_from_id(layer_id));
                }
            }
        }

        public int get_colour() {
            return this.colour;
        }

        public int[] get_layer_ids() {
            this.layer_ids.sort();
            return this.layer_ids.array();
        }

        public int get_member_count() {
            return this.layer_ids.size();
        }

        public int[] get_member_status(int grid_source_id) {
            int group_member_count = this.layer_ids.size();
            int[] group_members_status = new int[group_member_count];
            int layer_id_check = 0;
            int i = 0;
            while (i < group_member_count) {
                layer_id_check = this.layer_ids.get(i);
                group_members_status[i] = WoConditionalLayers.this.project.layer_get_value(layer_id_check, grid_source_id);
                ++i;
            }
            return group_members_status;
        }

        public int get_type() {
            return this.type;
        }

        public int[] process_member_layers(int target_layer_id, boolean target_layer_status_future, int grid_source_id) {
            WoConditionalLayers.this.debug_output("Group type " + this.type + " process_member_layers for target_layer_id: " + target_layer_id + " to " + target_layer_status_future);
            int[] group_member_ids = this.get_layer_ids();
            int[] group_members_status_current = this.get_member_status(grid_source_id);
            int[] group_members_status_future = new int[group_member_ids.length];
            int group_member_count = this.layer_ids.size();
            int i = 0;
            while (i < group_member_count) {
                if (group_member_ids[i] == target_layer_id) {
                    group_members_status_future[i] = this.type == 4 ? group_members_status_current[i] : WoConditionalLayers.this.get_boolean_as_int(target_layer_status_future);
                    WoConditionalLayers.this.debug_output("Group Setting layer ID " + group_member_ids[i] + " from " + group_members_status_current[i] + " to " + group_members_status_future[i]);
                } else {
                    switch (this.type) {
                        case 0: 
                        case 4: {
                            group_members_status_future[i] = group_members_status_current[i];
                            break;
                        }
                        case 1: {
                            if (target_layer_status_future) {
                                group_members_status_future[i] = WoConditionalLayers.this.get_boolean_as_int(WoConditionalLayers.this.toggle_status(target_layer_status_future));
                                break;
                            }
                            group_members_status_future[i] = 0;
                            break;
                        }
                        case 2: {
                            group_members_status_future[i] = WoConditionalLayers.this.get_boolean_as_int(target_layer_status_future);
                            break;
                        }
                        case 3: {
                            group_members_status_future[i] = WoConditionalLayers.this.toggle_status(group_members_status_current[i]);
                        }
                    }
                }
                ++i;
            }
            return group_members_status_future;
        }

        public void remove_layer(int id_remove) {
            int index_remove = WoConditionalLayers.this.get_id_from_number(id_remove);
            if (this.layer_ids.hasValue(index_remove)) {
                int search_index = -1;
                int i = 0;
                while (i < this.layer_ids.size()) {
                    if (this.layer_ids.get(i) == index_remove) {
                        search_index = i;
                    }
                    ++i;
                }
                if (search_index > -1) {
                    this.layer_ids.remove(search_index);
                    WoConditionalLayers.this.project.layer_group_lookup_unset(index_remove);
                    WoConditionalLayers.this.debug_output("Removed layer id (" + id_remove + ") from Layer Group " + this.id);
                    WoConditionalLayers.this.ui_elements.layer_group_data_update();
                }
            }
        }

        public void set_colour(int new_colour) {
            this.colour = new_colour;
            WoConditionalLayers.this.ui_elements.layer_group_data_update();
        }

        public void set_name(String new_name) {
            this.name = !(new_name = WoConditionalLayers.this.sanitize_string(new_name)).equals("") ? new_name : "Group " + (this.id + 1);
            this.machine_name = WoConditionalLayers.this.sanitize_network_string(this.name);
            WoConditionalLayers.this.ui.message_display("Renamed layer group " + WoConditionalLayers.this.get_number_from_id(this.id) + " as: " + this.name);
            WoConditionalLayers.this.ui_elements.layer_group_menu_update();
        }

        public void set_type(int new_type) {
            if (new_type >= 0 && new_type <= this.type_enum_max) {
                this.type = new_type;
                WoConditionalLayers.this.debug_output("Layer Group " + this.id + " set Type to: " + this.type);
            }
        }

        public XML xml_generate() {
            XML xml_layergroup = new XML("layer_group");
            xml_layergroup.setString("name", this.name);
            xml_layergroup.setString("machine_name", this.machine_name);
            xml_layergroup.setInt("type", this.type);
            XML xml_colour = xml_layergroup.addChild("colour");
            xml_colour.setInt("a", this.colour >> 24 & 0xFF);
            xml_colour.setInt("r", this.colour >> 16 & 0xFF);
            xml_colour.setInt("g", this.colour >> 8 & 0xFF);
            xml_colour.setInt("b", this.colour & 0xFF);
            XML xml_members = xml_layergroup.addChild("layers");
            int i = 0;
            while (i < this.layer_ids.size()) {
                XML xml_layer = xml_members.addChild("layer");
                xml_layer.setInt("id", this.layer_ids.get(i));
                ++i;
            }
            return xml_layergroup;
        }
    }

    public class LayerPreset {
        int id;
        String name;
        String machine_name;
        int[] value_array;

        LayerPreset(int new_id) {
            this.value_array = new int[WoConditionalLayers.this.project.layer_count];
            this.id = new_id;
            this.set_name("Preset " + WoConditionalLayers.this.get_number_from_id(this.id));
            WoConditionalLayers.this.debug_output("Added new LayerPreset: " + this.id + ", " + this.name);
        }

        public void debug() {
            String output = "LayerPreset " + this.id + ": " + this.get_int_value() + " - " + this.get_binary_value();
            WoConditionalLayers.this.debug_output(output);
            WoConditionalLayers.println((Object)this.value_array);
        }

        public String get_binary_value() {
            return WoConditionalLayers.this.get_binary_string_from_array(this.value_array);
        }

        public int get_int_value() {
            int value_int = Integer.parseUnsignedInt(this.get_binary_value(), 2);
            return value_int;
        }

        public void set_array_value(int[] new_value_array) {
            WoConditionalLayers.arrayCopy((Object)new_value_array, (Object)this.value_array);
        }

        public void set_name(String new_name) {
            this.name = !(new_name = WoConditionalLayers.this.sanitize_string(new_name)).equals("") ? new_name : "preset_" + this.id;
            WoConditionalLayers.this.ui.message_display("Renamed preset " + WoConditionalLayers.this.get_number_from_id(this.id) + " as: " + this.name);
            this.machine_name = WoConditionalLayers.this.sanitize_network_string(this.name);
        }

        public XML xml_generate() {
            XML xml_layerpreset = new XML("layer_preset");
            xml_layerpreset.setString("name", this.name);
            xml_layerpreset.setString("machine_name", this.machine_name);
            xml_layerpreset.setString("value_binary", this.get_binary_value());
            xml_layerpreset.setInt("value_int", this.get_int_value());
            return xml_layerpreset;
        }
    }

    public class NetworkMessage {
        int id;
        int status;
        final int INVALID = -1;
        final int RECEIVED = 0;
        final int PROCESSED = 1;
        final int SENT = 2;
        int source_id;
        final int PREVIEW = 0;
        final int MAIN = 1;
        final int NETWORK = 2;
        String message_raw;
        String source_ip;
        int source_port;
        String[] message_parts;
        int network_command_id;
        int layer_id;
        boolean layer_enabled;
        int layer_group_id;
        int[] affected_layer_ids;
        int[] affected_layer_states_updated;
        boolean contains_valid_command = false;
        boolean contains_valid_id = false;
        boolean contains_valid_status = false;
        int argument_count_required;
        int argument_count_validated;
        LocalDateTime timestamp_start;
        int millis_start;
        int millis_end;
        int millis_duration;

        NetworkMessage(int new_id, String new_message, String new_source_ip, int new_source_port, int new_source_id) {
            this.id = new_id;
            this.status = 0;
            this.message_raw = new_message;
            this.source_ip = new_source_ip;
            this.source_port = new_source_port;
            this.source_id = new_source_id;
            this.layer_id = -1;
            this.argument_count_required = 0;
            this.argument_count_validated = 0;
            this.set_time_start();
        }

        public void calculate_duration() {
            this.millis_duration = this.millis_end - this.millis_start;
        }

        public int get_duration() {
            return this.millis_duration;
        }

        public String get_timestamp() {
            return this.timestamp_start.format(WoConditionalLayers.this.project.timestamp_formatter);
        }

        public void process_message() {
            WoConditionalLayers.this.debug_output("Processing network_message: " + this.id + " " + this.message_raw);
            this.process_message_parts();
            if (this.message_parts != null) {
                int i = 0;
                while (i < this.message_parts.length) {
                    this.validate_message_arguments(i);
                    ++i;
                }
                WoConditionalLayers.this.debug_output("Message " + this.id + " contains " + this.message_parts.length + " parts, required arg count: " + this.argument_count_required + " Validated arg count: " + this.argument_count_validated);
                if (this.argument_count_required > 0 && this.argument_count_validated < this.argument_count_required) {
                    this.set_status(-1);
                    WoConditionalLayers.this.debug_output("Error: Insufficient valid arguments supplied for Network Message id: " + this.id);
                } else if (WoConditionalLayers.this.project.network_command_is_layer_related(this.network_command_id).booleanValue()) {
                    this.set_layer_status_from_command();
                    this.check_group_status();
                } else {
                    if (this.network_command_id == WoConditionalLayers.this.project.ENABLE_ALL) {
                        this.layer_enabled = true;
                    }
                    if (this.network_command_id == WoConditionalLayers.this.project.DISABLE_ALL) {
                        this.layer_enabled = false;
                    }
                }
                if (this.status != -1) {
                    this.set_status(1);
                    WoConditionalLayers.this.project.network_command_dispatch(this);
                } else {
                    WoConditionalLayers.this.debug_output("Error: Invalid Network Message for message id: " + this.id);
                }
            } else {
                this.set_status(-1);
            }
        }

        public void check_group_status() {
            if (WoConditionalLayers.this.is_valid_layer_id(this.layer_id).booleanValue()) {
                this.layer_group_id = WoConditionalLayers.this.project.layer_group_get_id_from_layer_id(this.layer_id);
                WoConditionalLayers.this.project.getClass();
                if (this.layer_group_id != -1) {
                    LayerGroup layer_group = WoConditionalLayers.this.project.layer_groups.get(this.layer_group_id);
                    int layer_group_member_count = layer_group.layer_ids.size();
                    this.affected_layer_ids = new int[layer_group_member_count];
                    this.affected_layer_states_updated = new int[layer_group_member_count];
                    WoConditionalLayers.arrayCopy((Object)layer_group.get_layer_ids(), (Object)this.affected_layer_ids);
                    int grid_id = this.source_id;
                    if (this.source_id == 2) {
                        grid_id = WoConditionalLayers.this.project.operating_mode;
                    }
                    int[] group_updated_statuses = layer_group.process_member_layers(this.layer_id, this.layer_enabled, grid_id);
                    WoConditionalLayers.arrayCopy((Object)group_updated_statuses, (Object)this.affected_layer_states_updated);
                } else {
                    this.affected_layer_ids = new int[1];
                    this.affected_layer_ids[0] = this.layer_id;
                    this.affected_layer_states_updated = new int[1];
                    this.affected_layer_states_updated[0] = WoConditionalLayers.this.get_boolean_as_int(this.layer_enabled);
                }
            }
        }

        public void set_layer_status_from_command() {
            WoConditionalLayers.this.project.getClass();
            if (this.network_command_id == 2) {
                this.layer_enabled = true;
                this.contains_valid_status = true;
            }
            WoConditionalLayers.this.project.getClass();
            if (this.network_command_id == 3) {
                this.layer_enabled = false;
                this.contains_valid_status = true;
            }
            if (this.network_command_id == WoConditionalLayers.this.project.TOGGLE_LAYER) {
                float layer_current_value;
                int grid_source_id = this.source_id;
                if (this.source_id == 2) {
                    grid_source_id = WoConditionalLayers.this.project.operating_mode;
                }
                if ((layer_current_value = (float)WoConditionalLayers.this.project.layer_get_value(this.layer_id, grid_source_id)) >= 0.0f) {
                    this.layer_enabled = layer_current_value == 0.0f;
                    this.contains_valid_status = true;
                } else {
                    this.contains_valid_status = false;
                }
                WoConditionalLayers.this.debug_output("Toggling layer " + this.layer_id + " from " + layer_current_value + " to " + this.layer_enabled + ", status: " + this.contains_valid_status);
            }
        }

        public void set_layer_id(int processed_layer_id) {
            this.layer_id = processed_layer_id;
        }

        public void process_message_parts() {
            String[] network_message_array = this.message_raw.split(" ");
            this.message_parts = new String[network_message_array.length];
            WoConditionalLayers.arrayCopy((Object)network_message_array, (Object)this.message_parts);
        }

        public void set_status(int new_status) {
            this.status = new_status;
            if (this.status == -1) {
                WoConditionalLayers.this.debug_output("Network Message id " + this.id + " set status to: " + this.status);
            }
        }

        public void set_time_start() {
            this.timestamp_start = LocalDateTime.now();
            this.millis_start = WoConditionalLayers.this.millis();
        }

        public void set_time_end() {
            this.millis_end = WoConditionalLayers.this.millis();
            this.calculate_duration();
        }

        public void validate_message_arguments(int arg_id) {
            if (this.message_parts.length > arg_id) {
                switch (arg_id) {
                    case 0: {
                        String network_message_command = WoConditionalLayers.this.sanitize_string(this.message_parts[0]);
                        this.contains_valid_command = WoConditionalLayers.this.is_valid_network_command(network_message_command);
                        if (this.contains_valid_command) {
                            this.network_command_id = WoConditionalLayers.this.get_network_command_id(network_message_command);
                            this.argument_count_required = WoConditionalLayers.this.project.network_command_argument_count[this.network_command_id];
                            break;
                        }
                        this.set_status(-1);
                        WoConditionalLayers.this.debug_output("Network command failed validation (message part 0).");
                        break;
                    }
                    case 1: {
                        if (WoConditionalLayers.this.project.network_command_is_layer_related(this.network_command_id).booleanValue()) {
                            this.contains_valid_id = WoConditionalLayers.this.is_valid_layer_num(this.message_parts[1]);
                            if (this.contains_valid_id) {
                                this.set_layer_id(WoConditionalLayers.this.get_id_from_number(Integer.valueOf(this.message_parts[1])));
                                ++this.argument_count_validated;
                                break;
                            }
                            this.set_status(-1);
                            break;
                        }
                        if ((this.network_command_id == 0 || this.network_command_id == 1) && WoConditionalLayers.this.is_ip4_address(this.message_parts[1])) {
                            ++this.argument_count_validated;
                        }
                        if (this.network_command_id != 9) break;
                        this.contains_valid_id = WoConditionalLayers.this.is_valid_preset_num(this.message_parts[1]);
                        if (this.contains_valid_id) {
                            this.set_layer_id(WoConditionalLayers.this.get_id_from_number(Integer.valueOf(this.message_parts[1])));
                            ++this.argument_count_validated;
                            break;
                        }
                        this.set_status(-1);
                        break;
                    }
                    case 2: {
                        if (WoConditionalLayers.this.is_integer(this.message_parts[2])) {
                            this.layer_enabled = WoConditionalLayers.this.get_boolean_from_int(Integer.valueOf(this.message_parts[2]));
                            this.contains_valid_status = true;
                            ++this.argument_count_validated;
                            break;
                        }
                        this.layer_enabled = WoConditionalLayers.this.get_boolean_from_string(this.message_parts[2]);
                        this.contains_valid_status = true;
                        ++this.argument_count_validated;
                    }
                }
            }
        }
    }

    class Project {
        int layer_count_max = 30;
        int layer_count = 30;
        String filepath = "default_project_filepath";
        String filename = "project";
        final int GRID_CURRENT = -1;
        final int GRID_PREVIEW = 0;
        final int GRID_MAIN = 1;
        final int GRID_COPY = 2;
        int[][] layer_values;
        int layer_id_current = -1;
        String[] layer_names;
        IntDict layer_machine_name_lookup;
        AppServer app_server_udp;
        AppServer app_server_osc;
        final int SERVER_UDP = 0;
        final int SERVER_OSC = 1;
        Boolean app_broadcasting;
        Boolean app_listening;
        int app_port_udp = 50005;
        int app_port_osc = 12000;
        IntDict client_port_preset_list;
        ArrayList<AppClient> client_connections;
        IntDict client_ip_lookup_list;
        AppClient current_connection;
        int operating_mode;
        int operating_mode_previous;
        final int MODE_PREVIEW = 0;
        final int MODE_LIVE = 1;
        final int MODE_NETWORK = 2;
        final int MODE_EDIT = 3;
        int operating_mode_enum_max = 3;
        String[] operating_mode_labels = new String[]{"Mode: Preview", "Mode: Live", "Mode: Network"};
        ArrayList<NetworkMessage> network_messages;
        DateTimeFormatter timestamp_formatter;
        IntDict network_command_alias_list;
        final int CLIENT_CONNECT = 0;
        final int CLIENT_DISCONNECT = 1;
        final int ENABLE_LAYER = 2;
        final int DISABLE_LAYER = 3;
        final int TOGGLE_LAYER = 4;
        final int SET_LAYER = 5;
        final int ENABLE_ALL = 6;
        final int DISABLE_ALL = 7;
        final int TAKE = 8;
        final int RECALL_PRESET = 9;
        int[] network_command_argument_count;
        ArrayList<LayerGroup> layer_groups;
        int[] layer_id_group_lookup;
        final int GROUP_UNDEFINED = -1;
        LayerGroup current_layergroup;
        ArrayList<LayerPreset> layer_presets;
        LayerPreset current_preset;
        Boolean pref_take_auto_switch;
        Boolean pref_use_keyboard_shortcuts;
        Boolean pref_force_all_layers_to_zero;

        Project() {
            int[] nArray = new int[10];
            nArray[2] = 1;
            nArray[3] = 1;
            nArray[4] = 1;
            nArray[5] = 2;
            nArray[9] = 1;
            this.network_command_argument_count = nArray;
            this.GROUP_UNDEFINED = -1;
            this.operating_mode = 0;
            this.app_broadcasting = false;
            this.app_listening = true;
            this.network_messages = new ArrayList();
            this.client_connections = new ArrayList();
            this.client_ip_lookup_list = new IntDict();
            this.client_port_preset_list = new IntDict();
            this.client_port_preset_list.add("Production", 3040);
            this.client_port_preset_list.add("Display", 3039);
            this.network_command_alias_list = new IntDict();
            this.layer_groups = new ArrayList();
            this.layer_id_group_lookup = new int[this.layer_count_max];
            this.layer_presets = new ArrayList();
            this.layer_names = new String[this.layer_count_max];
            this.layer_machine_name_lookup = new IntDict();
            this.timestamp_formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        }

        public void init() {
            this.app_server_udp = new AppServer(0);
            this.app_server_osc = new AppServer(1);
            this.app_broadcasting = true;
            this.network_command_alias_list_build();
            this.layer_value_arrays_init();
            this.layer_group_lookup_init();
            this.pref_take_auto_switch = true;
            this.pref_use_keyboard_shortcuts = true;
            this.pref_force_all_layers_to_zero = true;
        }

        public void app_broadcast_toggle() {
            this.app_broadcasting = WoConditionalLayers.this.toggle_status(this.app_broadcasting);
            WoConditionalLayers.this.ui_elements.network_status_controls_update();
        }

        public void app_server_check_status() {
            if (this.app_server_udp.app_connection_udp != null && this.app_listening.booleanValue() && !this.app_server_udp.app_connection_udp.isListening()) {
                this.app_listening = this.app_server_udp.app_connection_udp.isListening();
                WoConditionalLayers.this.ui_elements.network_status_controls_update();
                WoConditionalLayers.this.debug_output("Error: Server no longer listening!");
            }
        }

        public void client_connection_add(String client_ip_address, int client_port, String client_name) {
            if (WoConditionalLayers.this.is_ip4_address(client_ip_address)) {
                int new_id = this.client_connections.size();
                AppClient new_client = new AppClient(new_id, client_ip_address, client_port);
                new_client.set_name(client_name);
                this.client_connections.add(new_client);
                this.client_ip_lookup_list.add(client_ip_address, new_id);
                WoConditionalLayers.this.ui.message_display("Added new client " + WoConditionalLayers.this.get_number_from_id(new_id) + " with address: " + new_client.ip_address + ", port: " + new_client.port);
                WoConditionalLayers.this.ui_elements.client_connections_menu_update();
            }
        }

        public void client_connection_delete(String client_ip, int client_id) {
            WoConditionalLayers.this.ui.message_display("Deleting client connection " + WoConditionalLayers.this.get_number_from_id(client_id) + ": " + client_ip);
            if (client_id < this.client_connections.size()) {
                this.client_connections.remove(client_id);
                this.client_connection_renumber_ids();
                this.client_connection_select(-1);
                if (this.client_ip_lookup_list.hasKey(client_ip)) {
                    this.client_ip_lookup_list.remove(client_ip);
                }
            }
        }

        public void client_connection_port_set_preset_value(String preset_name) {
            if (this.client_port_preset_list.hasKey(preset_name)) {
                int new_port = this.client_port_preset_list.get(preset_name);
                if (this.current_connection != null) {
                    this.current_connection.set_port(new_port);
                }
                if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                    ((Textfield)WoConditionalLayers.this.ui_elements.controls.get(Textfield.class, "textfield_client_port")).setText(Integer.toString(new_port));
                }
            }
        }

        public void client_connection_renumber_ids() {
            int client_index = 0;
            for (AppClient client : this.client_connections) {
                client.id = client_index++;
            }
        }

        public void client_connection_select(int connection_id) {
            if (connection_id < 0) {
                this.current_connection = this.client_connections.size() > 0 ? this.client_connections.get(this.client_connections.size() - 1) : null;
            } else if (connection_id < this.client_connections.size()) {
                this.current_connection = this.client_connections.get(connection_id);
            }
            WoConditionalLayers.this.ui_elements.client_connections_menu_update();
            WoConditionalLayers.this.ui_elements.client_connection_control_update_values();
        }

        public void client_connection_ui_add() {
            String[] ui_values = WoConditionalLayers.this.ui_elements.get_client_connection_values();
            if (WoConditionalLayers.this.is_integer(ui_values[1])) {
                int port_number = Integer.valueOf(ui_values[1]);
                if (WoConditionalLayers.this.is_ip4_address(ui_values[0]) && WoConditionalLayers.this.is_valid_port(port_number)) {
                    this.client_connection_add(ui_values[0], port_number, ui_values[2]);
                    this.client_connection_select(-1);
                }
            }
        }

        public void client_connection_ui_delete() {
            if (this.current_connection != null) {
                this.client_connection_delete(this.current_connection.ip_address, this.current_connection.id);
            }
        }

        public void client_connection_ui_update(String ui_element_name, String ui_element_value) {
            if (this.current_connection != null) {
                String ui_string_value = WoConditionalLayers.this.sanitize_string(ui_element_value);
                if (ui_element_name.equals("textfield_client_ip")) {
                    this.current_connection.set_ip_address(ui_string_value);
                }
                if (ui_element_name.equals("textfield_client_port")) {
                    int port_number = Integer.valueOf(ui_string_value);
                    this.current_connection.set_port(port_number);
                }
                if (ui_element_name.equals("textfield_client_name")) {
                    this.current_connection.set_name(ui_string_value);
                    WoConditionalLayers.this.ui_elements.client_connections_menu_update();
                }
                WoConditionalLayers.this.ui_elements.client_connection_control_update_values();
            }
        }

        public void filename_set(String new_filename) {
            this.filename = (new_filename = WoConditionalLayers.this.sanitize_string(new_filename)).equals("") ? "project" : new_filename;
            WoConditionalLayers.this.ui.message_display("Project filename set: '" + this.filename + "'");
        }

        public int get_current_grid_id() {
            int grid_id = this.operating_mode;
            if (this.operating_mode == 2) {
                grid_id = 1;
            }
            if (this.operating_mode == 3) {
                grid_id = 0;
            }
            return grid_id;
        }

        public void layer_group_add() {
            int new_group_id = this.layer_groups.size();
            LayerGroup new_group = new LayerGroup(new_group_id);
            this.layer_groups.add(new_group);
            WoConditionalLayers.this.ui.message_display("Added new layer group " + WoConditionalLayers.this.get_number_from_id(new_group.id) + ": " + new_group.name);
            this.layer_group_select(new_group.id);
            WoConditionalLayers.this.ui_elements.layer_group_menu_update();
        }

        public void layer_group_delete(int group_id) {
            if (group_id != -1 && group_id <= this.layer_groups.size()) {
                WoConditionalLayers.this.debug_output("layer_group_delete: " + group_id);
                WoConditionalLayers.this.ui.message_display("Deleted layer group " + WoConditionalLayers.this.get_number_from_id(this.current_layergroup.id) + ": " + this.current_layergroup.name);
                this.current_layergroup = null;
                this.layer_groups.remove(group_id);
                WoConditionalLayers.this.debug_output("Deleted layer group: " + group_id);
                if (this.layer_groups.size() > 0) {
                    this.current_layergroup = this.layer_group_get(this.layer_groups.size() - 1);
                }
                WoConditionalLayers.this.ui_elements.layer_group_menu_update();
            }
        }

        public void layer_group_edit() {
            if (this.operating_mode != 3) {
                WoConditionalLayers.this.ui.message_display("Editing layer group " + this.current_layergroup.name + " ...");
                this.operating_mode_set(3);
            } else {
                this.operating_mode_set(this.operating_mode_previous);
            }
        }

        public LayerGroup layer_group_get(int group_id) {
            if (group_id != -1 && group_id <= this.layer_groups.size()) {
                return WoConditionalLayers.this.project.layer_groups.get(group_id);
            }
            return null;
        }

        public int layer_group_get_id_from_layer_id(int check_layer_id) {
            if (WoConditionalLayers.this.is_valid_layer_id(check_layer_id).booleanValue()) {
                return this.layer_id_group_lookup[check_layer_id];
            }
            return -1;
        }

        public int[] layer_group_get_members(int group_id) {
            if (group_id != -1) {
                LayerGroup layer_group = this.layer_group_get(group_id);
                int[] layer_group_ids = layer_group.get_layer_ids();
                WoConditionalLayers.this.debug_output("Group " + group_id + " contains " + layer_group_ids.length + " member layers ids: ");
                WoConditionalLayers.println((Object)layer_group_ids);
                return layer_group_ids;
            }
            int[] layer_group_ids = new int[]{};
            return layer_group_ids;
        }

        public int[] layer_group_get_member_status(int group_id) {
            if (group_id != -1) {
                LayerGroup layer_group = this.layer_group_get(group_id);
                int[] layer_group_statuses = layer_group.get_member_status(this.operating_mode);
                WoConditionalLayers.this.debug_output("Group " + group_id + " contains " + layer_group_statuses.length + " member layers ids: ");
                return layer_group_statuses;
            }
            int[] layer_group_statuses = new int[]{};
            return layer_group_statuses;
        }

        public void layer_group_lookup_init() {
            int i = 0;
            while (i < this.layer_id_group_lookup.length) {
                this.layer_group_lookup_set(i, -1);
                ++i;
            }
        }

        public void layer_group_lookup_set(int layer_id, int group_id) {
            if (WoConditionalLayers.this.is_valid_layer_id(layer_id).booleanValue()) {
                this.layer_id_group_lookup[layer_id] = group_id;
            }
        }

        public void layer_group_lookup_unset(int layer_id) {
            if (WoConditionalLayers.this.is_valid_layer_id(layer_id).booleanValue()) {
                this.layer_id_group_lookup[layer_id] = -1;
            }
        }

        public void layer_group_select(int layergroup_id) {
            this.current_layergroup = this.layer_group_get(layergroup_id);
            if (this.current_layergroup != null) {
                WoConditionalLayers.this.debug_output("layer_group_select: " + this.current_layergroup.id + " - " + this.current_layergroup.name);
                WoConditionalLayers.this.ui_elements.layer_group_data_update();
            }
        }

        public int layer_get_value(int layer_id, int grid_source_id) {
            WoConditionalLayers.this.debug_output("layer_get_value for layer " + layer_id + " from grid id " + grid_source_id);
            int layer_value = -1;
            if (WoConditionalLayers.this.is_valid_layer_id(layer_id).booleanValue()) {
                switch (grid_source_id) {
                    case 0: {
                        return this.layer_values[0][layer_id];
                    }
                }
                return this.layer_values[1][layer_id];
            }
            WoConditionalLayers.this.debug_output("Error with get_layer_value for layer: " + layer_id);
            return layer_value;
        }

        public void layer_id_set_current(int new_layer_id) {
            WoConditionalLayers.this.debug_output("layer_id_set_current: " + new_layer_id);
            if (WoConditionalLayers.this.is_valid_layer_id(new_layer_id).booleanValue() && new_layer_id != this.layer_id_current) {
                this.layer_id_current = new_layer_id;
                WoConditionalLayers.this.ui_elements.layer_name_textfield_update();
            }
        }

        public void layer_name_set(int layer_id, String new_layer_name) {
            if (WoConditionalLayers.this.is_valid_layer_id(layer_id).booleanValue()) {
                String current_name;
                if (this.layer_names[layer_id] != null && this.layer_machine_name_lookup.hasKey(current_name = WoConditionalLayers.this.sanitize_network_string(this.layer_names[layer_id]))) {
                    this.layer_machine_name_lookup.remove(current_name);
                }
                if (!new_layer_name.equals("")) {
                    this.layer_names[layer_id] = WoConditionalLayers.this.sanitize_string(new_layer_name);
                    this.layer_machine_name_lookup.set(WoConditionalLayers.this.sanitize_network_string(this.layer_names[layer_id]), layer_id);
                    WoConditionalLayers.this.ui.message_display("Renamed layer " + WoConditionalLayers.this.get_number_from_id(layer_id) + " to: '" + new_layer_name + "'");
                    WoConditionalLayers.this.ui_elements.layer_name_textfield_update();
                }
            }
        }

        public XML layer_name_xml_generate() {
            XML xml_layer_names = new XML("layer_names");
            int i = 0;
            while (i < this.layer_count) {
                if (this.layer_names[i] != null) {
                    XML xml_layer = xml_layer_names.addChild("layer");
                    xml_layer.setInt("id", i);
                    xml_layer.setString("name", this.layer_names[i]);
                    xml_layer.setString("machine_name", WoConditionalLayers.this.sanitize_network_string(this.layer_names[i]));
                }
                ++i;
            }
            return xml_layer_names;
        }

        public void layer_set_values_all(Boolean layers_enabled) {
            WoConditionalLayers.this.debug_output("layer_set_values_all: " + layers_enabled + ", operating mode: " + this.operating_mode);
            int layer_id = 0;
            while (layer_id < this.layer_count) {
                this.layer_values[2][layer_id] = WoConditionalLayers.this.get_boolean_as_int(layers_enabled);
                ++layer_id;
            }
            switch (this.operating_mode) {
                case 0: {
                    WoConditionalLayers.arrayCopy((Object)this.layer_values[2], (Object)this.layer_values[0]);
                    break;
                }
                case 1: 
                case 2: {
                    WoConditionalLayers.arrayCopy((Object)this.layer_values[2], (Object)this.layer_values[1]);
                    this.network_broadcast_message();
                }
            }
            WoConditionalLayers.this.ui_elements.layer_control_values_update();
        }

        public void layer_set_value(NetworkMessage network_message) {
            WoConditionalLayers.this.debug_output("layer_set_value for message: " + network_message.id + " layer_id: " + network_message.layer_id + ", value: " + network_message.layer_enabled);
            if (network_message.contains_valid_id) {
                if (network_message.contains_valid_status) {
                    int affected_layer_count = network_message.affected_layer_ids.length;
                    int target_grid_id = this.operating_mode;
                    if (network_message.source_id < 2) {
                        target_grid_id = network_message.source_id;
                    }
                    int i = 0;
                    while (i < affected_layer_count) {
                        WoConditionalLayers.this.debug_output("Grid " + target_grid_id + " layer_set_value (" + (i + 1) + " of " + affected_layer_count + ") for layer id: " + network_message.affected_layer_ids[i] + " to " + network_message.affected_layer_states_updated[i]);
                        switch (target_grid_id) {
                            case 0: {
                                this.layer_values[0][network_message.affected_layer_ids[i]] = network_message.affected_layer_states_updated[i];
                                break;
                            }
                            case 1: 
                            case 2: {
                                this.layer_values[1][network_message.affected_layer_ids[i]] = network_message.affected_layer_states_updated[i];
                            }
                        }
                        ++i;
                    }
                    if (target_grid_id == 1 || target_grid_id == 2) {
                        this.network_broadcast_message();
                    }
                    WoConditionalLayers.this.ui_elements.layer_control_values_update();
                } else {
                    WoConditionalLayers.this.debug_output("Error: layer_set_value Layer status is not valid: " + network_message.layer_id);
                }
            } else {
                WoConditionalLayers.this.debug_output("Error: layer_set_value Layer ID is not valid: " + network_message.layer_id);
            }
        }

        public void layer_value_arrays_init() {
            int grid_count = 3;
            this.layer_values = new int[grid_count][this.layer_count];
            int control_grid = 0;
            while (control_grid < grid_count) {
                int layer_id = 0;
                while (layer_id < this.layer_count) {
                    this.layer_values[control_grid][layer_id] = 0;
                    ++layer_id;
                }
                ++control_grid;
            }
        }

        public XML layer_values_xml_generate(int grid_id) {
            XML xml_grid_value = new XML("grid");
            xml_grid_value.setInt("id", grid_id);
            xml_grid_value.setString("name", WoConditionalLayers.this.ui_elements.layer_grid_names[grid_id]);
            String binary_value = WoConditionalLayers.this.get_binary_string_from_array(this.layer_values[grid_id]);
            xml_grid_value.setString("value_binary", binary_value);
            xml_grid_value.setInt("value_int", WoConditionalLayers.this.get_int_from_binary_string(binary_value));
            return xml_grid_value;
        }

        public int[] layer_values_get(int grid_id) {
            if (grid_id == -1) {
                switch (this.operating_mode) {
                    case 0: {
                        return this.layer_values[0];
                    }
                }
                return this.layer_values[1];
            }
            return this.layer_values[grid_id];
        }

        public void layer_values_update_main() {
            WoConditionalLayers.arrayCopy((Object)this.layer_values[0], (Object)this.layer_values[1]);
            WoConditionalLayers.this.ui_elements.layer_control_values_update();
        }

        public void layer_values_update_preview() {
            WoConditionalLayers.arrayCopy((Object)this.layer_values[1], (Object)this.layer_values[0]);
            WoConditionalLayers.this.ui_elements.layer_control_values_update();
        }

        public void network_broadcast_check() {
            if (this.operating_mode == 1 || this.operating_mode == 2) {
                this.network_broadcast_message();
            }
        }

        public String layer_values_get_binary_string(int grid_id) {
            int[] grid_values_array = this.layer_values_get(grid_id);
            return WoConditionalLayers.this.get_binary_string_from_array(grid_values_array);
        }

        public void network_broadcast_message() {
            if (this.app_broadcasting.booleanValue()) {
                String binary_string = this.layer_values_get_binary_string(1);
                int binary_int_value = WoConditionalLayers.this.get_int_from_binary_string(binary_string);
                if (binary_int_value == 0 && this.pref_force_all_layers_to_zero.booleanValue()) {
                    binary_int_value = 0x40000000;
                }
                WoConditionalLayers.this.debug_output("IntValue from Binary: " + binary_int_value);
                WoConditionalLayers.this.debug_output("Binary: " + binary_string);
                String message = "enableLayerCond " + binary_int_value + " $0D";
                WoConditionalLayers.this.debug_output("Network broadcast at: " + WoConditionalLayers.this.generate_timestamp() + " : " + message);
                WoConditionalLayers.this.debug_output("Broadcasting to " + this.client_connections.size() + " client IP addresses");
                String client_ip_address = "";
                for (AppClient client : this.client_connections) {
                    WoConditionalLayers.this.debug_output("Broadcasting to " + client.name + ": " + message);
                    client_ip_address = client.get_address();
                    this.app_server_udp.app_connection_udp.send(message, client_ip_address, 3040);
                }
            }
        }

        public void network_client_connection(NetworkMessage network_message) {
            String connection_address = network_message.source_ip;
            if (network_message.argument_count_validated > 0) {
                connection_address = network_message.message_parts[1];
            }
            WoConditionalLayers.this.debug_output("network_client_connection: " + network_message.network_command_id + " from: " + connection_address);
            if (WoConditionalLayers.this.is_ip4_address(connection_address)) {
                if (this.client_ip_lookup_list.hasKey(connection_address)) {
                    if (network_message.network_command_id == 1) {
                        int client_id = this.client_ip_lookup_list.get(connection_address);
                        this.client_connection_delete(connection_address, client_id);
                    }
                } else if (network_message.network_command_id == 0) {
                    this.client_connection_add(connection_address, network_message.source_port, "");
                }
            } else {
                WoConditionalLayers.this.debug_output("Error: Client IP does not appear to be valid IP4 address.");
            }
        }

        public void network_command_alias_list_build() {
            this.network_command_alias_list.set("client_connect", 0);
            this.network_command_alias_list.set("clientconnect", 0);
            this.network_command_alias_list.set("connect", 0);
            this.network_command_alias_list.set("client_disconnect", 1);
            this.network_command_alias_list.set("clientdisconnect", 1);
            this.network_command_alias_list.set("disconnect", 1);
            this.network_command_alias_list.set("enable_layer", 2);
            this.network_command_alias_list.set("enablelayer", 2);
            this.network_command_alias_list.set("layer_enable", 2);
            this.network_command_alias_list.set("layerenable", 2);
            this.network_command_alias_list.set("enable_condition", 2);
            this.network_command_alias_list.set("enablecondition", 2);
            this.network_command_alias_list.set("disable_layer", 3);
            this.network_command_alias_list.set("disablelayer", 3);
            this.network_command_alias_list.set("layer_disable", 3);
            this.network_command_alias_list.set("layerdisable", 3);
            this.network_command_alias_list.set("disable_condition", 3);
            this.network_command_alias_list.set("disablecondition", 3);
            this.network_command_alias_list.set("toggle_layer", 4);
            this.network_command_alias_list.set("togglelayer", 4);
            this.network_command_alias_list.set("layer_toggle", 4);
            this.network_command_alias_list.set("layertoggle", 4);
            this.network_command_alias_list.set("toggle_condition", 4);
            this.network_command_alias_list.set("togglecondition", 4);
            this.network_command_alias_list.set("set_layer", 5);
            this.network_command_alias_list.set("setlayer", 5);
            this.network_command_alias_list.set("layer_set", 5);
            this.network_command_alias_list.set("layerset", 5);
            this.network_command_alias_list.set("set_condition", 5);
            this.network_command_alias_list.set("setcondition", 5);
            this.network_command_alias_list.set("enable_all", 6);
            this.network_command_alias_list.set("enableall", 6);
            this.network_command_alias_list.set("disable_all", 7);
            this.network_command_alias_list.set("disableall", 7);
            this.network_command_alias_list.set("take", 8);
            this.network_command_alias_list.set("recall_preset", 9);
            this.network_command_alias_list.set("recallpreset", 9);
            this.network_command_alias_list.set("preset_recall", 9);
            this.network_command_alias_list.set("presetrecall", 9);
            this.network_command_alias_list.set("preset", 9);
        }

        public void network_command_dispatch(NetworkMessage network_message) {
            WoConditionalLayers.this.debug_output("Dispatching command for network message: " + network_message.id);
            if (network_message.contains_valid_command) {
                switch (network_message.network_command_id) {
                    case 0: 
                    case 1: {
                        this.network_client_connection(network_message);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        this.layer_set_value(network_message);
                        break;
                    }
                    case 6: {
                        this.layer_set_values_all(network_message.layer_enabled);
                        break;
                    }
                    case 7: {
                        this.layer_set_values_all(network_message.layer_enabled);
                        break;
                    }
                    case 8: {
                        this.perform_take();
                        break;
                    }
                    case 9: {
                        this.preset_recall(network_message.layer_id);
                    }
                }
                network_message.set_time_end();
                network_message.getClass();
                network_message.set_status(2);
            } else {
                WoConditionalLayers.this.debug_output("Invalid network command: " + network_message.network_command_id);
            }
        }

        public Boolean network_command_is_layer_related(int command_id) {
            if (command_id > 1 && command_id < 6) {
                return true;
            }
            return false;
        }

        public void network_message_add(String message, String source_ip, int source_port, int source_id) {
            int new_message_id = this.network_messages.size();
            WoConditionalLayers.this.debug_output("Added new network message " + new_message_id + " at : " + WoConditionalLayers.this.generate_timestamp());
            NetworkMessage new_message = new NetworkMessage(new_message_id, message, source_ip, source_port, source_id);
            this.network_messages.add(new_message);
            new_message.process_message();
        }

        public void operating_mode_set(int new_project_mode) {
            if (new_project_mode <= this.operating_mode_labels.length && new_project_mode != this.operating_mode) {
                this.operating_mode_previous = this.operating_mode;
                this.operating_mode = new_project_mode;
                WoConditionalLayers.this.debug_output("Project set_operating_mode: " + this.operating_mode + " (from " + this.operating_mode_previous + ")");
                switch (this.operating_mode) {
                    case 0: {
                        WoConditionalLayers.this.ui_elements.enable_layer_grid_controls(0, true);
                        WoConditionalLayers.this.ui_elements.display_layer_grid_controls(0, true);
                        WoConditionalLayers.this.ui_elements.enable_layer_grid_controls(1, true);
                        WoConditionalLayers.this.ui_elements.enable_take_button(true);
                        WoConditionalLayers.this.ui_elements.enable_layer_controls(true);
                        break;
                    }
                    case 1: {
                        WoConditionalLayers.this.ui_elements.enable_layer_grid_controls(0, false);
                        WoConditionalLayers.this.ui_elements.display_layer_grid_controls(0, false);
                        WoConditionalLayers.this.ui_elements.enable_layer_grid_controls(1, true);
                        WoConditionalLayers.this.ui_elements.enable_take_button(false);
                        WoConditionalLayers.this.ui_elements.enable_layer_controls(true);
                        break;
                    }
                    case 2: {
                        WoConditionalLayers.this.ui_elements.enable_layer_grid_controls(0, false);
                        WoConditionalLayers.this.ui_elements.display_layer_grid_controls(0, false);
                        WoConditionalLayers.this.ui_elements.enable_layer_grid_controls(1, false);
                        WoConditionalLayers.this.ui_elements.enable_take_button(false);
                        WoConditionalLayers.this.ui_elements.enable_layer_controls(false);
                        break;
                    }
                    case 3: {
                        WoConditionalLayers.this.ui_elements.enable_layer_grid_controls(0, true);
                        WoConditionalLayers.this.ui_elements.display_layer_grid_controls(0, true);
                        WoConditionalLayers.this.ui_elements.enable_layer_grid_controls(1, false);
                        WoConditionalLayers.this.ui_elements.enable_take_button(false);
                        WoConditionalLayers.this.ui_elements.enable_layer_controls(false);
                    }
                }
                ((ScrollableList)WoConditionalLayers.this.ui_elements.dropdownlist_project_mode.setBroadcast(false)).setValue((float)this.operating_mode).setOpen(false).setBroadcast(true);
                WoConditionalLayers.this.ui_elements.update_all_controls();
            }
        }

        public void perform_take() {
            if (this.pref_take_auto_switch.booleanValue()) {
                WoConditionalLayers.arrayCopy((Object)this.layer_values[1], (Object)this.layer_values[2]);
            }
            this.layer_values_update_main();
            if (this.pref_take_auto_switch.booleanValue()) {
                WoConditionalLayers.arrayCopy((Object)this.layer_values[2], (Object)this.layer_values[0]);
                WoConditionalLayers.this.ui_elements.layer_control_values_update();
            }
            this.network_broadcast_message();
        }

        public void preference_toggle(String pref_name, Boolean pref_status) {
            if (pref_name.equals("toggle_pref_force_all_layers_to_zero")) {
                this.pref_force_all_layers_to_zero = pref_status;
            }
            if (pref_name.equals("toggle_pref_take_auto_switch")) {
                this.pref_take_auto_switch = pref_status;
            }
            if (pref_name.equals("toggle_pref_use_keyboard_shortcuts")) {
                this.pref_use_keyboard_shortcuts = pref_status;
            }
        }

        public void preset_add() {
            int preset_id = this.layer_presets.size();
            this.current_preset = new LayerPreset(preset_id);
            this.layer_presets.add(this.current_preset);
            WoConditionalLayers.this.ui.message_display("Added new preset (" + WoConditionalLayers.this.get_number_from_id(this.current_preset.id) + ") : " + this.current_preset.name);
            WoConditionalLayers.this.ui_elements.preset_menus_update();
            WoConditionalLayers.this.ui_elements.preset_data_update();
        }

        public void preset_capture_grid() {
            this.preset_add();
            this.current_preset.set_array_value(this.layer_values_get(-1));
        }

        public void preset_current_delete() {
            WoConditionalLayers.this.ui.message_display("Deleted preset (" + WoConditionalLayers.this.get_number_from_id(this.current_preset.id) + ") : " + this.current_preset.name);
            int remove_id = this.current_preset.id;
            this.current_preset = null;
            this.layer_presets.remove(remove_id);
            if (this.layer_presets.size() > 0) {
                this.current_preset = this.layer_presets.get(this.layer_presets.size() - 1);
            }
            WoConditionalLayers.this.ui_elements.preset_menus_update();
            WoConditionalLayers.this.ui_elements.preset_data_update();
        }

        public void preset_current_select(int preset_id) {
            if (preset_id >= 0 && preset_id < this.layer_presets.size()) {
                this.current_preset = this.layer_presets.get(preset_id);
                WoConditionalLayers.this.debug_output("preset_current_select: " + this.current_preset.id + " - " + this.current_preset.name);
                WoConditionalLayers.this.ui_elements.preset_data_update();
            }
        }

        public void preset_current_update() {
            this.current_preset.set_array_value(this.layer_values_get(-1));
            WoConditionalLayers.this.ui.message_display("Updated Preset (" + WoConditionalLayers.this.get_number_from_id(this.current_preset.id) + ").");
        }

        public void preset_recall(int preset_id) {
            if (preset_id >= 0 && preset_id < this.layer_presets.size()) {
                LayerPreset recall_preset = this.layer_presets.get(preset_id);
                WoConditionalLayers.arrayCopy((Object)recall_preset.value_array, (Object)this.layer_values[this.get_current_grid_id()]);
                this.network_broadcast_check();
                WoConditionalLayers.this.ui_elements.layer_control_values_update();
            } else {
                WoConditionalLayers.this.debug_output("Error: Invalid Preset ID (" + preset_id + ") supplied.");
            }
        }

        public void preset_delete(int preset_id) {
            WoConditionalLayers.this.debug_output("preset_delete: " + preset_id);
            if (preset_id < this.layer_presets.size()) {
                this.layer_presets.remove(preset_id);
            }
        }

        public void reset_project() {
            int i = this.client_connections.size() - 1;
            while (i >= 0) {
                this.current_connection = this.client_connections.get(i);
                this.client_connection_delete(this.current_connection.ip_address, this.current_connection.id);
                --i;
            }
            i = this.layer_groups.size() - 1;
            while (i >= 0) {
                this.current_layergroup = this.layer_groups.get(i);
                this.layer_group_delete(this.current_layergroup.id);
                --i;
            }
            i = this.layer_presets.size() - 1;
            while (i >= 0) {
                this.current_preset = null;
                this.layer_presets.remove(i);
                --i;
            }
            this.layer_names = new String[this.layer_count_max];
            this.layer_machine_name_lookup.clear();
            WoConditionalLayers.this.ui_elements.update_all_controls();
        }

        public void update_layer_value_from_ui(String ui_control_element_name, int ui_control_element_id) {
            if (this.operating_mode == 3) {
                this.current_layergroup.layer_toggle_status(ui_control_element_id);
            } else if (ui_control_element_name.length() > 8) {
                String grid_name = WoConditionalLayers.this.get_grid_name_from_control(ui_control_element_name);
                int source_id = 0;
                if (grid_name.equals(WoConditionalLayers.this.ui_elements.layer_grid_names[0]) || grid_name.equals(WoConditionalLayers.this.ui_elements.layer_grid_names[1])) {
                    if (grid_name.equals(WoConditionalLayers.this.ui_elements.layer_grid_names[1])) {
                        source_id = 1;
                    }
                    String ui_message = "toggleCondition " + WoConditionalLayers.this.get_number_from_id(ui_control_element_id);
                    this.network_message_add(ui_message, "127.0.0.1", 0, source_id);
                }
            }
        }
    }

    class UI {
        Boolean ready = false;
        Boolean active = true;
        Boolean file_operation_in_progress;
        int min_stage_width;
        int min_stage_height;
        int current_stage_width;
        int current_stage_height;
        float stage_scale;
        float window_scale;
        int swatch_target_id;
        IntDict colours;
        int active_tab_id;
        String overlay_text;
        int overlay_duration = 3000;
        int overlay_timer;
        int overlay_opacity;
        PGraphics logo_image;
        PGraphics logo_image_mask;
        PVector logo_image_dimensions = new PVector(400.0f, 200.0f);

        UI() {
            this.colours = new IntDict();
            this.colours_add_defaults();
            this.min_stage_width = 1280;
            this.min_stage_height = 720;
            this.current_stage_width = this.min_stage_width;
            this.current_stage_height = this.min_stage_height;
            this.stage_scale = 20.0f;
            this.window_scale = 1.0f;
            this.swatch_target_id = 0;
            this.active_tab_id = 0;
            this.display_throbber(false, "");
        }

        public void check_frame_size() {
            if (WoConditionalLayers.this.width != this.current_stage_width || WoConditionalLayers.this.height != this.current_stage_height) {
                if (WoConditionalLayers.this.width < this.min_stage_width || WoConditionalLayers.this.height < this.min_stage_height) {
                    this.current_stage_width = WoConditionalLayers.max((int)this.min_stage_width, (int)WoConditionalLayers.this.width);
                    this.current_stage_height = WoConditionalLayers.max((int)this.min_stage_height, (int)WoConditionalLayers.this.height);
                    WoConditionalLayers.this.surface.setSize(this.current_stage_width, this.current_stage_height);
                } else {
                    this.current_stage_width = WoConditionalLayers.this.width;
                    this.current_stage_height = WoConditionalLayers.this.height;
                }
                this.update_ui_dimensions();
                WoConditionalLayers.this.ui_elements.controls.setGraphics(WoConditionalLayers.this.app, 0, 0);
            }
        }

        public void colours_add_defaults() {
            this.colours.set("matkeane", WoConditionalLayers.this.color(255, 102, 0));
            this.colours.set("ui_pane_bg_dark", WoConditionalLayers.this.color(50, 50, 50, 255));
            this.colours.set("ui_pane_bg_edit", WoConditionalLayers.this.color(40, 25, 25, 255));
            this.colours.set("viewport_bg", WoConditionalLayers.this.color(64, 60, 60, 255));
            this.colours.set("outline", WoConditionalLayers.this.color(120, 120, 120, 255));
            this.colours.set("preview", WoConditionalLayers.this.color(20, 160, 20, 255));
            this.colours.set("program", WoConditionalLayers.this.color(160, 20, 20, 255));
            this.colours.set("button_status_warning", WoConditionalLayers.this.color(255, 0, 0, 255));
            this.colours.set("button_status_ok", WoConditionalLayers.this.color(0, 255, 0, 255));
            this.colours.set("button_status_disable", WoConditionalLayers.this.color(120, 120, 120, 255));
            this.colours.set("ui_pane_line", WoConditionalLayers.this.color(20, 20, 20, 255));
            this.colours.set("ui_label", WoConditionalLayers.this.color(225, 225, 255, 255));
            this.colours.set("ui_mouse_info", WoConditionalLayers.this.color(225, 225, 255, 128));
            this.colours.set("info_text", WoConditionalLayers.this.color(255));
            this.colours.set("info_background", WoConditionalLayers.this.color(0, 0, 0, 100));
            this.colours.set("ui_layer_active", WoConditionalLayers.this.color(100, 100, 255, 255));
            this.colours.set("ui_layer_enabled", WoConditionalLayers.this.color(0, 180, 0, 255));
            this.colours.set("ui_layer_disabled", WoConditionalLayers.this.color(180, 0, 0, 255));
        }

        public int colour_get_by_name(String colour_name) {
            if (this.colours.hasKey(colour_name)) {
                return this.colours.get(colour_name);
            }
            return this.colours.get("matkeane");
        }

        public int colour_get_from_swatch_id(int swatch_id) {
            int colour = this.colours.get("matkeane");
            switch (swatch_id) {
                case 0: {
                    if (WoConditionalLayers.this.project.current_layergroup == null) break;
                    colour = WoConditionalLayers.this.project.current_layergroup.get_colour();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
            return colour;
        }

        public void colour_swatch_clicked(int swatch_id) {
            WoConditionalLayers.this.debug_output("Colour Swatch clicked with swatch id: " + swatch_id);
            this.swatch_target_id = swatch_id;
            if (this.get_colourpicker_visibility().booleanValue()) {
                this.display_colourpicker(false);
            } else {
                this.display_colourpicker(true);
            }
        }

        public void colour_update_from_swatch(int picked_color) {
            switch (this.swatch_target_id) {
                case 0: {
                    if (WoConditionalLayers.this.project.current_layergroup == null) break;
                    WoConditionalLayers.this.project.current_layergroup.set_colour(picked_color);
                    break;
                }
                case 2: {
                    this.colours.set("grid_line_pixel", picked_color);
                    break;
                }
                case 3: {
                    this.colours.set("surface_stroke", picked_color);
                    break;
                }
                case 4: {
                    this.colours.set("grid_line_physical", picked_color);
                }
            }
        }

        public void colourpicker_event(int action_id) {
            int colourpicker_r = ((ColorWheel)WoConditionalLayers.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).r();
            int colourpicker_g = ((ColorWheel)WoConditionalLayers.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).g();
            int colourpicker_b = ((ColorWheel)WoConditionalLayers.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).b();
            int new_colour = WoConditionalLayers.this.color(colourpicker_r, colourpicker_g, colourpicker_b, 255);
            switch (action_id) {
                case 2: {
                    this.display_colourpicker(false);
                    break;
                }
                case 100: {
                    this.colour_update_from_swatch(new_colour);
                }
            }
        }

        public void display_throbber(Boolean status, String file_operation_label) {
            if (status.booleanValue()) {
                this.display_colourpicker(false);
            }
            this.file_operation_in_progress = status;
        }

        public void display_colourpicker(Boolean visible) {
            if (this.ready.booleanValue()) {
                if (visible.booleanValue()) {
                    ((ColorWheel)WoConditionalLayers.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).setRGB(this.colour_get_from_swatch_id(this.swatch_target_id));
                    ((ColorWheel)WoConditionalLayers.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).show();
                } else {
                    ((ColorWheel)WoConditionalLayers.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).hide();
                }
            }
        }

        public Boolean get_colourpicker_visibility() {
            return ((ColorWheel)WoConditionalLayers.this.ui_elements.controls.get(ColorWheel.class, "colourwheel")).isVisible();
        }

        public int get_scaled_size(int original_size) {
            return WoConditionalLayers.round((float)((float)original_size * WoConditionalLayers.this.ui.window_scale));
        }

        public int get_scaled_size(float original_size) {
            return WoConditionalLayers.round((float)(original_size * WoConditionalLayers.this.ui.window_scale));
        }

        public void grid_control_rollover(String ui_control_element_name, int ui_control_element_id, int controlp5_action_id) {
            if (ui_control_element_name.length() > 8) {
                WoConditionalLayers.this.get_grid_name_from_control(ui_control_element_name);
            }
        }

        public void keyboard_event(int key_code, Boolean key_active) {
            if (!WoConditionalLayers.this.ui_elements.mouse_within_ui_pane()) {
                switch (key_code) {
                    case 8: {
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 17: {
                        break;
                    }
                    case 18: {
                        break;
                    }
                    case 27: {
                        break;
                    }
                    case 32: {
                        if (!WoConditionalLayers.this.project.pref_use_keyboard_shortcuts.booleanValue() || key_active.booleanValue()) break;
                        WoConditionalLayers.this.project.perform_take();
                        break;
                    }
                    case 68: {
                        break;
                    }
                    case 71: 
                    case 77: {
                        break;
                    }
                    case 82: {
                        break;
                    }
                    case 83: {
                        break;
                    }
                    case 85: {
                        break;
                    }
                }
            }
        }

        public void logo_image_create() {
            WoConditionalLayers.this.ui.logo_image = WoConditionalLayers.this.createGraphics(WoConditionalLayers.round((float)WoConditionalLayers.this.ui.logo_image_dimensions.x), WoConditionalLayers.round((float)WoConditionalLayers.this.ui.logo_image_dimensions.y));
            WoConditionalLayers.this.ui.logo_image.beginDraw();
            WoConditionalLayers.this.ui.logo_image.fill(WoConditionalLayers.this.ui.colour_get_by_name("ui_pane_bg_dark"));
            WoConditionalLayers.this.ui.logo_image.noStroke();
            WoConditionalLayers.this.ui.logo_image.rectMode(0);
            WoConditionalLayers.this.ui.logo_image.rect(0.0f, 0.0f, WoConditionalLayers.this.ui.logo_image_dimensions.x, WoConditionalLayers.this.ui.logo_image_dimensions.y);
            WoConditionalLayers.this.ui.logo_image.fill(255);
            WoConditionalLayers.this.ui.logo_image.translate(WoConditionalLayers.this.ui.logo_image_dimensions.x / 2.0f, WoConditionalLayers.this.ui.logo_image_dimensions.y - 10.0f);
            WoConditionalLayers.this.ui.logo_image.textAlign(3);
            WoConditionalLayers.this.ui.logo_image.textSize(WoConditionalLayers.this.ui.logo_image_dimensions.y * 1.25f);
            WoConditionalLayers.this.ui.logo_image.text("CL", 0.0f, 0.0f);
            WoConditionalLayers.this.ui.logo_image.endDraw();
            WoConditionalLayers.this.ui.logo_image_mask = WoConditionalLayers.this.createGraphics(WoConditionalLayers.round((float)WoConditionalLayers.this.ui.logo_image_dimensions.x), WoConditionalLayers.round((float)WoConditionalLayers.this.ui.logo_image_dimensions.y));
            WoConditionalLayers.this.ui.logo_image_mask.beginDraw();
            WoConditionalLayers.this.ui.logo_image_mask.noStroke();
            WoConditionalLayers.this.ui.logo_image_mask.fill(0);
            WoConditionalLayers.this.ui.logo_image_mask.noStroke();
            WoConditionalLayers.this.ui.logo_image_mask.rectMode(0);
            WoConditionalLayers.this.ui.logo_image_mask.rect(0.0f, 0.0f, WoConditionalLayers.this.ui.logo_image_dimensions.x, WoConditionalLayers.this.ui.logo_image_dimensions.y);
            WoConditionalLayers.this.ui.logo_image_mask.fill(255);
            int[] grid_size = new int[]{8, 8};
            PVector grid_dimensions = new PVector(WoConditionalLayers.this.ui.logo_image_dimensions.x / (float)grid_size[0], WoConditionalLayers.this.ui.logo_image_dimensions.y / (float)grid_size[1]);
            WoConditionalLayers.this.ui.logo_image_mask.translate(grid_dimensions.x * 0.8f, 0.0f);
            int i = 0;
            while (i <= grid_size[0]) {
                int j = 0;
                while (j <= grid_size[1]) {
                    WoConditionalLayers.this.ui.logo_image_mask.rect(grid_dimensions.x * (float)i, grid_dimensions.y * (float)j, grid_dimensions.x * 0.8f, grid_dimensions.y * 0.8f);
                    ++j;
                }
                ++i;
            }
            WoConditionalLayers.this.ui.logo_image_mask.endDraw();
            WoConditionalLayers.this.ui.logo_image.mask((PImage)WoConditionalLayers.this.ui.logo_image_mask);
        }

        public void message_display(String message_string) {
            WoConditionalLayers.this.debug_output(message_string);
            this.overlay_text = message_string;
            this.overlay_timer = WoConditionalLayers.this.millis();
            this.overlay_opacity = 255;
        }

        public void project_select_save_folder() {
            WoConditionalLayers.this.selectFolder("Select folder for Project file:", "file_save_location_selected");
        }

        public void select_export_folder() {
            WoConditionalLayers.this.selectFolder("Select folder for Exports:", "export_folder_selected");
        }

        public void select_project_save_folder() {
            WoConditionalLayers.this.selectFolder("Select folder for Project file:", "project_save_folder_selected");
        }

        public void set_active(Boolean status) {
            this.active = status;
            WoConditionalLayers.this.debug_output("UI active status: " + this.active);
        }

        public void set_active_tab_id(int tab_id) {
            this.active_tab_id = tab_id;
            WoConditionalLayers.this.debug_output("set_active_tab_id: " + this.active_tab_id);
            WoConditionalLayers.this.ui_elements.controls.getTab(WoConditionalLayers.this.ui_elements.tab_name_labels[this.active_tab_id][0]).bringToFront();
        }

        public void tab_select_next() {
            int next_tab_id = this.active_tab_id + 1;
            if (next_tab_id >= WoConditionalLayers.this.ui_elements.tab_name_labels.length) {
                this.set_active_tab_id(0);
            } else {
                this.set_active_tab_id(next_tab_id);
            }
        }

        public void update_ui_dimensions() {
            this.window_scale = WoConditionalLayers.min((float)((float)WoConditionalLayers.this.width / PApplet.parseFloat((int)this.min_stage_width)), (float)((float)WoConditionalLayers.this.height / PApplet.parseFloat((int)this.min_stage_height)));
            WoConditionalLayers.this.ui_elements.calculate_ui_pane_height();
            WoConditionalLayers.this.ui_elements.calculate_tab_dimensions();
            WoConditionalLayers.this.ui_elements.resize_tabs();
            WoConditionalLayers.this.ui_elements.calculate_control_layout_grid();
            WoConditionalLayers.this.ui_elements.move_controls();
        }
    }

    public class UiElements {
        ControlP5 controls;
        PGraphics controls_image;
        CheckBox checkboxes_main;
        CheckBox checkboxes_preview;
        ScrollableList dropdownlist_client_select;
        ScrollableList dropdownlist_layer_select;
        ScrollableList dropdownlist_layergroup_select;
        ScrollableList dropdownlist_layergroup_type;
        ScrollableList dropdownlist_preset_recall;
        ScrollableList dropdownlist_preset_edit;
        ScrollableList dropdownlist_project_mode;
        int pane_height_default;
        int pane_height;
        int pane_origin;
        int centre_pane_width;
        int control_origin_y = 80;
        int data_overlay_height = 28;
        int grid_pane_width;
        int[] grid_controls_dimensions;
        int[][] grid_pane_alignments;
        final int ALIGN_LEFT = 0;
        final int ALIGN_CENTRE = 1;
        final int ALIGN_RIGHT = 2;
        String layer_grid_button_name_stem = "grid";
        String[] layer_grid_names = new String[]{"prev", "main"};
        PVector[] layer_grid_origins;
        PVector[] layer_grid_positions;
        int layer_grid_column_count;
        int layer_grid_row_count;
        int layer_grid_button_size;
        int layer_grid_button_spacing;
        Boolean layer_grid_layout_order_rows_first;
        int tab_count;
        int[] tab_dimensions = new int[2];
        int tab_caption_margin_left = 12;
        int[][] divider_positions = new int[][]{new int[1]};
        int tab_height_default = 25;
        int control_width_default = 20;
        int control_height_default;
        int control_height;
        int control_grid_width_default;
        int control_grid_height_default = 40;
        int toggle_width_default = 18;
        int label_offset_x_default = 10;
        int label_offset_y_default = -22;
        int[] grid_origin;
        int grid_columns;
        int grid_rows;
        int[] grid_column_positions;
        int[] grid_row_positions;
        float grid_row_height;
        int colourpicker_size;
        ControlFont ui_font_tabs;
        String[][] tab_name_labels = new String[][]{{"default", "Conditional Layer Utility"}, {"group_network", "Network"}, {"group_layergroups", "Layers and Groups"}, {"group_presets", "Presets"}, {"group_help", "Settings"}};

        UiElements() {
            this.pane_height = this.pane_height_default = 50;
            this.grid_pane_alignments = new int[this.layer_grid_names.length][3];
            this.grid_controls_dimensions = new int[2];
            this.tab_count = this.tab_name_labels.length;
            this.divider_positions = new int[this.tab_count][0];
            this.control_height = this.control_height_default = 20;
            this.ui_font_tabs = new ControlFont(WoConditionalLayers.this.font_display_ui, this.tab_height_default / 2);
            this.layer_grid_origins = new PVector[this.layer_grid_names.length];
            this.layer_grid_origins[0] = new PVector(70.0f, (float)this.control_origin_y);
            this.layer_grid_origins[1] = new PVector(810.0f, (float)this.control_origin_y);
            this.layer_grid_positions = new PVector[WoConditionalLayers.this.project.layer_count];
            this.layer_grid_button_size = 40;
            this.layer_grid_button_spacing = 30;
            this.layer_grid_column_count = 6;
            this.layer_grid_row_count = WoConditionalLayers.floor((float)(WoConditionalLayers.this.project.layer_count / this.layer_grid_column_count));
            this.layer_grid_layout_order_rows_first = true;
            this.grid_origin = new int[2];
            this.grid_columns = 64;
            this.grid_rows = 3;
            this.grid_column_positions = new int[this.grid_columns];
            this.grid_row_positions = new int[this.grid_rows];
            this.colourpicker_size = 300;
        }

        public void init() {
            this.controls = new ControlP5(WoConditionalLayers.this.app);
            this.controls_image = WoConditionalLayers.this.createGraphics(WoConditionalLayers.this.width, WoConditionalLayers.this.height, "processing.awt.PGraphicsJava2D");
            this.centre_pane_width = 200;
            this.calculate_ui_pane_height();
            this.calculate_tab_dimensions();
            this.calculate_layer_grid_positions();
            this.calculate_control_layout_grid();
            this.calculate_grid_control_dimensions();
            this.calculate_grid_pane_positions();
            this.calculate_grid_control_origins();
        }

        public void calculate_layer_grid_positions() {
            int[] nArray = new int[2];
            nArray[1] = 1;
            int[] checkbox_layout_order = nArray;
            int checkbox_layout_dimension = this.layer_grid_column_count;
            if (this.layer_grid_layout_order_rows_first.booleanValue()) {
                checkbox_layout_order[0] = 1;
                checkbox_layout_order[1] = 0;
            }
            int checkbox_offset = this.layer_grid_button_size + this.layer_grid_button_spacing;
            PVector grid_position = new PVector(0.0f, 0.0f);
            int i = 0;
            while (i < WoConditionalLayers.this.project.layer_count) {
                grid_position.x = i % checkbox_layout_dimension * checkbox_offset;
                grid_position.y = WoConditionalLayers.floor((float)(i / checkbox_layout_dimension)) * checkbox_offset;
                this.layer_grid_positions[i] = new PVector(grid_position.x, grid_position.y);
                ++i;
            }
        }

        public void calculate_control_layout_grid() {
            float column_width = WoConditionalLayers.this.width / this.grid_columns;
            int i = 0;
            while (i < this.grid_columns) {
                this.grid_column_positions[i] = WoConditionalLayers.round((float)((float)i * column_width));
                ++i;
            }
            float tab_height_difference = this.tab_dimensions[1] - this.tab_height_default;
            this.grid_origin[0] = 0;
            this.grid_origin[1] = WoConditionalLayers.round((float)((float)this.pane_origin + tab_height_difference));
            this.grid_row_height = WoConditionalLayers.round((float)((float)this.control_grid_height_default * WoConditionalLayers.this.ui.window_scale));
            int i2 = 0;
            while (i2 < this.grid_rows) {
                this.grid_row_positions[i2] = this.grid_origin[1] + WoConditionalLayers.round((float)(this.grid_row_height * (float)(i2 + 1)));
                ++i2;
            }
        }

        public void calculate_grid_control_dimensions() {
            this.grid_controls_dimensions[0] = (this.layer_grid_button_size + this.layer_grid_button_spacing) * this.layer_grid_column_count;
            this.grid_controls_dimensions[1] = (this.layer_grid_button_size + this.layer_grid_button_spacing) * this.layer_grid_row_count;
        }

        public void calculate_grid_control_origins() {
            this.layer_grid_origins[0].x = this.grid_pane_alignments[0][1] - this.grid_controls_dimensions[0] / 2 + this.layer_grid_button_spacing / 2;
            this.layer_grid_origins[0].y = this.control_origin_y - 5;
            this.layer_grid_origins[1].x = this.grid_pane_alignments[1][1] - this.grid_controls_dimensions[0] / 2 + this.layer_grid_button_spacing / 2;
            this.layer_grid_origins[1].y = this.control_origin_y - 5;
        }

        public void calculate_grid_pane_positions() {
            this.grid_pane_width = (WoConditionalLayers.this.width - this.centre_pane_width) / 2;
            int grid_pane_width_half = this.grid_controls_dimensions[0] / 2;
            int centre_alignment = WoConditionalLayers.this.ui_elements.grid_pane_width / 2;
            WoConditionalLayers.this.project.getClass();
            this.grid_pane_alignments[0][0] = centre_alignment - grid_pane_width_half;
            WoConditionalLayers.this.project.getClass();
            this.grid_pane_alignments[0][1] = centre_alignment;
            WoConditionalLayers.this.project.getClass();
            this.grid_pane_alignments[0][2] = centre_alignment + grid_pane_width_half;
            centre_alignment = WoConditionalLayers.this.width - WoConditionalLayers.this.ui_elements.grid_pane_width / 2;
            WoConditionalLayers.this.project.getClass();
            this.grid_pane_alignments[1][0] = centre_alignment - grid_pane_width_half;
            WoConditionalLayers.this.project.getClass();
            this.grid_pane_alignments[1][1] = centre_alignment;
            WoConditionalLayers.this.project.getClass();
            this.grid_pane_alignments[1][2] = centre_alignment + grid_pane_width_half;
        }

        public void calculate_ui_pane_height() {
            this.pane_height = WoConditionalLayers.max((int)this.pane_height_default, (int)WoConditionalLayers.floor((float)((float)WoConditionalLayers.this.height * 0.22f)));
            this.pane_origin = WoConditionalLayers.this.height - this.pane_height;
        }

        public void calculate_tab_dimensions() {
            this.tab_dimensions[0] = WoConditionalLayers.floor((float)((WoConditionalLayers.this.width - this.tab_count) / this.tab_count));
            this.tab_dimensions[1] = WoConditionalLayers.round((float)((float)this.tab_height_default * WoConditionalLayers.this.ui.window_scale));
            this.ui_font_tabs = new ControlFont(WoConditionalLayers.this.font_display_ui, this.tab_dimensions[1] / 2);
        }

        public void resize_tabs() {
            int i = 0;
            while (i < this.tab_name_labels.length) {
                this.controls.getTab(this.tab_name_labels[i][0]).setWidth(this.tab_dimensions[0]).setHeight(this.tab_dimensions[1]);
                this.controls.getTab(this.tab_name_labels[i][0]).getCaptionLabel().setFont(this.ui_font_tabs);
                ++i;
            }
        }

        public void display_layer_grid_controls(int grid_id, Boolean display_grid) {
            WoConditionalLayers.this.debug_output("display_layer_grid_controls for grid " + grid_id + ": " + display_grid);
            String control_name = "";
            int layer_id = 0;
            while (layer_id < WoConditionalLayers.this.project.layer_count) {
                control_name = String.valueOf(this.layer_grid_button_name_stem) + "_" + this.layer_grid_names[grid_id] + "_" + String.valueOf(layer_id);
                ((Bang)WoConditionalLayers.this.ui_elements.controls.get(Bang.class, control_name)).setVisible(display_grid.booleanValue());
                ++layer_id;
            }
            String grid_label_name = "label_data_" + this.layer_grid_names[grid_id];
            ((Textlabel)this.controls.get(Textlabel.class, grid_label_name)).setVisible(display_grid.booleanValue());
        }

        public void enable_layer_grid_controls(int grid_id, Boolean grid_enabled) {
            WoConditionalLayers.this.debug_output("enable_layer_grid_controls for grid " + grid_id + ": " + grid_enabled);
            String control_name = "";
            int layer_id = 0;
            while (layer_id < WoConditionalLayers.this.project.layer_count) {
                control_name = String.valueOf(this.layer_grid_button_name_stem) + "_" + this.layer_grid_names[grid_id] + "_" + String.valueOf(layer_id);
                ((Bang)WoConditionalLayers.this.ui_elements.controls.get(Bang.class, control_name)).setLock(grid_enabled == false);
                ++layer_id;
            }
        }

        public void enable_layer_controls(Boolean controls_enabled) {
            WoConditionalLayers.this.debug_output("enable_layer_controls: " + controls_enabled);
            ((ScrollableList)this.dropdownlist_preset_recall.setVisible(controls_enabled.booleanValue())).setLock(controls_enabled == false);
            ((Button)((Button)this.controls.get(Button.class, "button_preset_capture_grid")).setVisible(controls_enabled.booleanValue())).setLock(controls_enabled == false);
            ((Button)((Button)this.controls.get(Button.class, "button_layer_all_enable")).setVisible(controls_enabled.booleanValue())).setLock(controls_enabled == false);
            ((Button)((Button)this.controls.get(Button.class, "button_layer_all_disable")).setVisible(controls_enabled.booleanValue())).setLock(controls_enabled == false);
        }

        public void enable_take_button(Boolean take_enabled) {
            ((Button)this.controls.get(Button.class, "button_take")).setLock(take_enabled == false);
            ((Button)this.controls.get(Button.class, "button_copy_main_to_preview")).setLock(take_enabled == false);
        }

        public int get_checkbox_id_from_name(String control_name) {
            int checkbox_id = Integer.valueOf(control_name.substring(1));
            return checkbox_id;
        }

        public String[] get_client_connection_values() {
            String[] ui_values = new String[]{"", "", ""};
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                ui_values[0] = WoConditionalLayers.this.sanitize_string(((Textfield)this.controls.get(Textfield.class, "textfield_client_ip")).getText());
                ui_values[1] = WoConditionalLayers.this.sanitize_string(((Textfield)this.controls.get(Textfield.class, "textfield_client_port")).getText());
                ui_values[2] = WoConditionalLayers.this.sanitize_string(((Textfield)this.controls.get(Textfield.class, "textfield_client_name")).getText());
            }
            return ui_values;
        }

        public int get_grid_width(float grid_cell_count) {
            return WoConditionalLayers.round((float)((float)this.grid_column_positions[1] * grid_cell_count));
        }

        public int[] get_layer_grid_origin_coordinates(int grid_id) {
            int[] grid_coordinates = new int[2];
            if (grid_id >= 0 && grid_id < this.layer_grid_names.length) {
                grid_coordinates[0] = WoConditionalLayers.round((float)this.layer_grid_origins[grid_id].x);
                grid_coordinates[1] = WoConditionalLayers.round((float)this.layer_grid_origins[grid_id].y);
            }
            return grid_coordinates;
        }

        public int get_ui_pane_origin() {
            return this.pane_origin;
        }

        public boolean mouse_within_ui_pane() {
            return WoConditionalLayers.this.mouseY >= this.pane_origin;
        }

        public void move_controls() {
            ControlFont ui_font = new ControlFont(WoConditionalLayers.this.font_display_ui, WoConditionalLayers.round((float)(12.0f * WoConditionalLayers.this.ui.window_scale)));
            ControlFont ui_font_title = new ControlFont(WoConditionalLayers.this.font_display_ui_title, WoConditionalLayers.round((float)(18.0f * WoConditionalLayers.this.ui.window_scale)));
            int current_grid_id = WoConditionalLayers.this.project.get_current_grid_id();
            WoConditionalLayers.round((float)(WoConditionalLayers.this.ui_elements.grid_controls_dimensions[0] / 2));
            WoConditionalLayers.round((float)(WoConditionalLayers.this.ui_elements.layer_grid_button_spacing / 2));
            int centre_alignment = WoConditionalLayers.this.ui.get_scaled_size(590);
            int title_position_y = WoConditionalLayers.this.ui.get_scaled_size(this.control_origin_y - 60);
            int current_tab_id = 0;
            int grid_width = WoConditionalLayers.round((float)this.grid_column_positions[1]);
            WoConditionalLayers.round((float)this.grid_row_height);
            int control_vpos = 0;
            int control_height = WoConditionalLayers.this.ui.get_scaled_size(22);
            int button_width_large = WoConditionalLayers.this.ui.get_scaled_size(100);
            int button_width_med_large = WoConditionalLayers.this.ui.get_scaled_size(80);
            int button_width_med = WoConditionalLayers.this.ui.get_scaled_size(60);
            int button_width_huge = WoConditionalLayers.this.ui.get_scaled_size(120);
            int button_width_custom = 0;
            int button_height = WoConditionalLayers.this.ui.get_scaled_size(30);
            int label_position_left = 0;
            int label_position_above = control_height * -2;
            WoConditionalLayers.this.ui.get_scaled_size(-22);
            WoConditionalLayers.this.ui.get_scaled_size(-6);
            this.controls.getWindow().setPositionOfTabs(0, this.pane_origin);
            this.resize_tabs();
            String control_name = "";
            int layer_grid_control_size = WoConditionalLayers.this.ui.get_scaled_size(this.layer_grid_button_size);
            PVector layer_grid_position = new PVector();
            int layer_id = 0;
            while (layer_id < WoConditionalLayers.this.project.layer_count) {
                int control_grid = 0;
                while (control_grid < this.layer_grid_names.length) {
                    control_name = String.valueOf(this.layer_grid_button_name_stem) + "_" + this.layer_grid_names[control_grid] + "_" + String.valueOf(layer_id);
                    layer_grid_position.x = WoConditionalLayers.this.ui.get_scaled_size(this.layer_grid_origins[control_grid].x + this.layer_grid_positions[layer_id].x);
                    layer_grid_position.y = WoConditionalLayers.this.ui.get_scaled_size(this.layer_grid_origins[control_grid].y + this.layer_grid_positions[layer_id].y);
                    ((Bang)((Bang)WoConditionalLayers.this.ui_elements.controls.get(Bang.class, control_name)).setSize(layer_grid_control_size, layer_grid_control_size)).setPosition(layer_grid_position.x, layer_grid_position.y);
                    ++control_grid;
                }
                ++layer_id;
            }
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_header_preview")).setPosition((float)WoConditionalLayers.this.ui.get_scaled_size(225), (float)title_position_y)).setFont(ui_font_title);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_header_program")).setPosition((float)WoConditionalLayers.this.ui.get_scaled_size(960), (float)title_position_y)).setFont(ui_font_title);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_header_network")).setPosition((float)centre_alignment, (float)title_position_y)).setFont(ui_font_title);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_controls_network_receive")).setPosition((float)(centre_alignment + WoConditionalLayers.this.ui.get_scaled_size(10)), (float)WoConditionalLayers.this.ui.get_scaled_size(this.control_origin_y - 10))).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_controls_network_send")).setPosition((float)(centre_alignment + WoConditionalLayers.this.ui.get_scaled_size(16)), (float)WoConditionalLayers.this.ui.get_scaled_size(this.control_origin_y + 60))).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_server_udp_status")).setPosition((float)(centre_alignment - this.get_grid_width(0.5f)), (float)WoConditionalLayers.this.ui.get_scaled_size(this.control_origin_y + 20))).setSize(this.get_grid_width(2.5f), button_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_server_osc_status")).setPosition((float)(centre_alignment + this.get_grid_width(3.0f)), (float)WoConditionalLayers.this.ui.get_scaled_size(this.control_origin_y + 20))).setSize(this.get_grid_width(2.5f), button_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_app_broadcast_status")).setPosition((float)(WoConditionalLayers.this.width / 2 - button_width_huge / 2), (float)WoConditionalLayers.this.ui.get_scaled_size(this.control_origin_y + 90))).setSize(button_width_huge, button_height)).setFont(ui_font);
            ((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)this.dropdownlist_project_mode.setPosition((float)(centre_alignment - this.get_grid_width(1.5f)), (float)WoConditionalLayers.this.ui.get_scaled_size(this.control_origin_y + 300))).setWidth(WoConditionalLayers.this.ui.get_scaled_size(160))).setHeight(this.get_grid_width(6.0f))).setBarHeight(button_height).setItemHeight(control_height).setFont(ui_font)).setLock(false);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_take")).setPosition((float)(WoConditionalLayers.this.width / 2 - button_width_huge / 2), (float)WoConditionalLayers.this.ui.get_scaled_size(this.control_origin_y + 370))).setSize(button_width_huge, WoConditionalLayers.this.ui.get_scaled_size(70))).setFont(ui_font_title);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_copy_main_to_preview")).setPosition((float)(WoConditionalLayers.this.width / 2 - button_width_huge / 2), (float)WoConditionalLayers.this.ui.get_scaled_size(this.control_origin_y + 180))).setSize(button_width_huge, button_height)).setFont(ui_font);
            control_vpos = WoConditionalLayers.this.ui.get_scaled_size(this.control_origin_y + 355);
            Textlabel textlabel = (Textlabel)this.controls.get(Textlabel.class, "label_data_prev");
            UI uI = WoConditionalLayers.this.ui;
            int[][] nArray = WoConditionalLayers.this.ui_elements.grid_pane_alignments;
            WoConditionalLayers.this.project.getClass();
            ((Textlabel)textlabel.setPosition((float)uI.get_scaled_size(nArray[0][WoConditionalLayers.this.ui_elements.ALIGN_LEFT] + 10), (float)control_vpos)).setFont(ui_font);
            Textlabel textlabel2 = (Textlabel)this.controls.get(Textlabel.class, "label_data_main");
            UI uI2 = WoConditionalLayers.this.ui;
            int[][] nArray2 = WoConditionalLayers.this.ui_elements.grid_pane_alignments;
            WoConditionalLayers.this.project.getClass();
            ((Textlabel)textlabel2.setPosition((float)uI2.get_scaled_size(nArray2[1][WoConditionalLayers.this.ui_elements.ALIGN_LEFT] + 10), (float)control_vpos)).setFont(ui_font);
            control_vpos = WoConditionalLayers.this.ui.get_scaled_size(this.control_origin_y + 390);
            ((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)this.dropdownlist_preset_recall.setPosition((float)WoConditionalLayers.this.ui.get_scaled_size(WoConditionalLayers.this.ui_elements.grid_pane_alignments[current_grid_id][WoConditionalLayers.this.ui_elements.ALIGN_LEFT]), (float)control_vpos)).setWidth(WoConditionalLayers.this.ui.get_scaled_size(160))).setHeight(this.get_grid_width(6.0f))).setBarHeight(button_height).setItemHeight(control_height).setFont(ui_font)).setLock(false);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_preset_capture_grid")).setPosition((float)WoConditionalLayers.this.ui.get_scaled_size(WoConditionalLayers.this.ui_elements.grid_pane_alignments[current_grid_id][WoConditionalLayers.this.ui_elements.ALIGN_LEFT] + 170), (float)control_vpos)).setSize(button_width_med_large, button_height)).setFont(ui_font);
            button_width_custom = WoConditionalLayers.this.ui.get_scaled_size(70);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_layer_all_enable")).setPosition((float)(WoConditionalLayers.this.ui.get_scaled_size(WoConditionalLayers.this.ui_elements.grid_pane_alignments[current_grid_id][WoConditionalLayers.this.ui_elements.ALIGN_RIGHT]) - button_width_custom), (float)control_vpos)).setSize(button_width_custom, button_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_layer_all_disable")).setPosition((float)WoConditionalLayers.this.ui.get_scaled_size(WoConditionalLayers.this.ui_elements.grid_pane_alignments[current_grid_id][WoConditionalLayers.this.ui_elements.ALIGN_RIGHT] - 150), (float)control_vpos)).setSize(button_width_custom, button_height)).setFont(ui_font);
            current_tab_id = 0;
            this.divider_positions[current_tab_id] = new int[0];
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_app_version")).setPosition((float)(grid_width / 2), (float)this.grid_row_positions[2])).setFont(ui_font);
            this.divider_positions[current_tab_id] = WoConditionalLayers.append((int[])this.divider_positions[current_tab_id], (int)this.grid_column_positions[14]);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_app_about")).setPosition((float)this.grid_column_positions[15], (float)this.grid_row_positions[0])).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_matkeane")).setPosition((float)this.grid_column_positions[15], (float)this.grid_row_positions[2])).setSize(button_width_large, WoConditionalLayers.round((float)((float)button_height * 0.75f)))).setFont(ui_font);
            this.divider_positions[current_tab_id] = WoConditionalLayers.append((int[])this.divider_positions[current_tab_id], (int)this.grid_column_positions[28]);
            ((Textarea)((Textarea)this.controls.get(Textarea.class, "textarea_licence")).setPosition((float)this.grid_column_positions[29], (float)this.grid_row_positions[0])).setSize(this.get_grid_width(22.0f), control_height * 5).setFont(ui_font).setLineHeight(WoConditionalLayers.this.ui.get_scaled_size(16));
            this.divider_positions[current_tab_id] = WoConditionalLayers.append((int[])this.divider_positions[current_tab_id], (int)this.grid_column_positions[51]);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_project_save")).setPosition((float)this.grid_column_positions[53], (float)this.grid_row_positions[0])).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_project_load")).setPosition((float)this.grid_column_positions[53], (float)this.grid_row_positions[2])).setSize(button_width_med_large, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_project_save")).setPosition((float)this.grid_column_positions[58], (float)this.grid_row_positions[2])).setSize(button_width_med_large, control_height)).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_project_filename")).setPosition((float)this.grid_column_positions[53], (float)this.grid_row_positions[1])).setSize(this.get_grid_width(9.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_project_filename")).getCaptionLabel().getStyle().marginLeft = label_position_left;
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_project_filename")).getCaptionLabel().getStyle().marginTop = label_position_above;
            current_tab_id = 1;
            this.divider_positions[current_tab_id] = new int[0];
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_server_reception")).setPosition((float)this.grid_column_positions[2], (float)this.grid_row_positions[0])).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_server_port_udp")).setPosition((float)this.grid_column_positions[2], (float)this.grid_row_positions[2])).setSize(this.get_grid_width(3.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_server_port_udp")).getCaptionLabel().getStyle().marginLeft = label_position_left;
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_server_port_udp")).getCaptionLabel().getStyle().marginTop = label_position_above;
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_server_udp_toggle")).setPosition((float)this.grid_column_positions[2], (float)this.grid_row_positions[1])).setSize(this.get_grid_width(3.0f), control_height)).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_server_port_osc")).setPosition((float)this.grid_column_positions[6], (float)this.grid_row_positions[2])).setSize(this.get_grid_width(3.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_server_port_osc")).getCaptionLabel().getStyle().marginLeft = label_position_left;
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_server_port_osc")).getCaptionLabel().getStyle().marginTop = label_position_above;
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_server_osc_toggle")).setPosition((float)this.grid_column_positions[6], (float)this.grid_row_positions[1])).setSize(this.get_grid_width(3.0f), control_height)).setFont(ui_font);
            this.divider_positions[current_tab_id] = WoConditionalLayers.append((int[])this.divider_positions[current_tab_id], (int)this.grid_column_positions[11]);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_server_sending")).setPosition((float)this.grid_column_positions[13], (float)this.grid_row_positions[0])).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_app_broadcast_toggle")).setPosition((float)this.grid_column_positions[13], (float)this.grid_row_positions[1])).setSize(this.get_grid_width(3.0f), control_height)).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_client_count")).setPosition((float)this.grid_column_positions[13], (float)this.grid_row_positions[2])).setFont(ui_font);
            this.divider_positions[current_tab_id] = WoConditionalLayers.append((int[])this.divider_positions[current_tab_id], (int)this.grid_column_positions[20]);
            ((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)this.dropdownlist_client_select.setPosition((float)this.grid_column_positions[22], (float)this.grid_row_positions[0])).setWidth(this.get_grid_width(10.0f))).setHeight(this.get_grid_width(6.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font)).setLock(false);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_client_ip")).setPosition((float)this.grid_column_positions[22], (float)this.grid_row_positions[1])).setSize(this.get_grid_width(6.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_client_ip")).getCaptionLabel().getStyle().marginLeft = label_position_left;
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_client_ip")).getCaptionLabel().getStyle().marginTop = label_position_above;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_client_port")).setPosition((float)this.grid_column_positions[29], (float)this.grid_row_positions[1])).setSize(this.get_grid_width(3.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_client_port")).getCaptionLabel().getStyle().marginLeft = label_position_left;
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_client_port")).getCaptionLabel().getStyle().marginTop = label_position_above;
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_client_name")).setPosition((float)this.grid_column_positions[33], (float)this.grid_row_positions[1])).setSize(this.get_grid_width(10.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_client_name")).getCaptionLabel().getStyle().marginLeft = label_position_left;
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_client_name")).getCaptionLabel().getStyle().marginTop = label_position_above;
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_client_add")).setPosition((float)this.grid_column_positions[44], (float)this.grid_row_positions[1])).setSize(button_width_med, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_client_delete")).setPosition((float)this.grid_column_positions[48], (float)this.grid_row_positions[1])).setSize(button_width_med, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_client_textfields_clear")).setPosition((float)this.grid_column_positions[22], (float)this.grid_row_positions[2])).setSize(this.get_grid_width(6.0f), control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_client_port_display")).setPosition((float)this.grid_column_positions[29], (float)this.grid_row_positions[2])).setSize(button_width_med, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_client_port_production")).setPosition((float)this.grid_column_positions[33], (float)this.grid_row_positions[2])).setSize(button_width_large, control_height)).setFont(ui_font);
            current_tab_id = 2;
            this.divider_positions[current_tab_id] = new int[0];
            ((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)this.dropdownlist_layer_select.setPosition((float)this.grid_column_positions[2], (float)this.grid_row_positions[0])).setWidth(this.get_grid_width(8.0f))).setHeight(this.get_grid_width(6.0f))).setBarHeight(WoConditionalLayers.this.ui.get_scaled_size(25)).setItemHeight(control_height).setFont(ui_font)).setLock(false);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_layer_name")).setPosition((float)this.grid_column_positions[2], (float)this.grid_row_positions[1])).setSize(this.get_grid_width(8.0f), control_height).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_layer_name_machine")).setPosition((float)this.grid_column_positions[2], (float)this.grid_row_positions[2])).setFont(ui_font);
            this.divider_positions[current_tab_id] = WoConditionalLayers.append((int[])this.divider_positions[current_tab_id], (int)this.grid_column_positions[12]);
            ((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)this.dropdownlist_layergroup_select.setPosition((float)this.grid_column_positions[14], (float)this.grid_row_positions[0])).setWidth(this.get_grid_width(9.0f))).setHeight(this.get_grid_width(6.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font)).setLock(false);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_layergroup_add")).setPosition((float)this.grid_column_positions[14], (float)this.grid_row_positions[1])).setSize(button_width_large, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_layergroup_delete")).setPosition((float)this.grid_column_positions[20], (float)this.grid_row_positions[1])).setSize(button_width_med, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_layergroup_edit")).setPosition((float)this.grid_column_positions[24], (float)this.grid_row_positions[1])).setSize(button_width_large, control_height)).setFont(ui_font);
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_layergroup_member_count")).setPosition((float)this.grid_column_positions[24], (float)this.grid_row_positions[2])).setFont(ui_font);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_layergroup_name")).setPosition((float)this.grid_column_positions[30], (float)this.grid_row_positions[1])).setSize(this.get_grid_width(10.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_layergroup_name")).getCaptionLabel().getStyle().marginLeft = label_position_left;
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_layergroup_name")).getCaptionLabel().getStyle().marginTop = label_position_above;
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_layergroup_name_machine")).setPosition((float)this.grid_column_positions[30], (float)this.grid_row_positions[2])).setFont(ui_font);
            ((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)this.dropdownlist_layergroup_type.setPosition((float)this.grid_column_positions[41], (float)this.grid_row_positions[1])).setWidth(this.get_grid_width(10.0f))).setHeight(this.get_grid_width(4.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font)).setLock(false);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_layergroup_swatch")).setPosition((float)this.grid_column_positions[55], (float)this.grid_row_positions[1])).setSize(this.get_grid_width(1.0f), control_height)).setFont(ui_font);
            ((Button)this.controls.get(Button.class, (String)"button_layergroup_swatch")).getCaptionLabel().getStyle().marginLeft = this.get_grid_width(2.0f) * -1;
            ((ColorWheel)this.controls.get(ColorWheel.class, "colourwheel")).setPosition((float)(WoConditionalLayers.this.width / 2 - this.colourpicker_size / 2), 10.0f);
            current_tab_id = 3;
            this.divider_positions[current_tab_id] = new int[0];
            ((ScrollableList)((ScrollableList)((ScrollableList)((ScrollableList)this.dropdownlist_preset_edit.setPosition((float)this.grid_column_positions[2], (float)this.grid_row_positions[0])).setWidth(this.get_grid_width(10.0f))).setHeight(this.get_grid_width(6.0f))).setBarHeight(control_height).setItemHeight(control_height).setFont(ui_font)).setLock(false);
            ((Textfield)((Textfield)this.controls.get(Textfield.class, "textfield_preset_name")).setPosition((float)this.grid_column_positions[13], (float)this.grid_row_positions[1])).setSize(this.get_grid_width(10.0f), control_height).setFont(ui_font);
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_preset_name")).getCaptionLabel().getStyle().marginLeft = label_position_left;
            ((Textfield)this.controls.get(Textfield.class, (String)"textfield_preset_name")).getCaptionLabel().getStyle().marginTop = label_position_above;
            ((Textlabel)((Textlabel)this.controls.get(Textlabel.class, "label_preset_name_machine")).setPosition((float)this.grid_column_positions[13], (float)this.grid_row_positions[2])).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_preset_update")).setPosition((float)this.grid_column_positions[24], (float)this.grid_row_positions[1])).setSize(button_width_med, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_preset_recall")).setPosition((float)this.grid_column_positions[28], (float)this.grid_row_positions[1])).setSize(button_width_med, control_height)).setFont(ui_font);
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_preset_delete")).setPosition((float)this.grid_column_positions[32], (float)this.grid_row_positions[1])).setSize(button_width_med, control_height)).setFont(ui_font);
            current_tab_id = 4;
            this.divider_positions[current_tab_id] = new int[0];
            PVector toggle_label_offset = new PVector((float)WoConditionalLayers.this.ui.get_scaled_size((float)control_height * 1.5f), (float)WoConditionalLayers.this.ui.get_scaled_size(control_height * -1));
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_pref_take_auto_switch")).setPosition((float)this.grid_column_positions[1], (float)this.grid_row_positions[0])).setSize(control_height, control_height)).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_pref_take_auto_switch")).getCaptionLabel().getStyle().marginLeft = WoConditionalLayers.round((float)toggle_label_offset.x);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_pref_take_auto_switch")).getCaptionLabel().getStyle().marginTop = WoConditionalLayers.round((float)toggle_label_offset.y);
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_pref_use_keyboard_shortcuts")).setPosition((float)this.grid_column_positions[1], (float)this.grid_row_positions[1])).setSize(control_height, control_height)).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_pref_use_keyboard_shortcuts")).getCaptionLabel().getStyle().marginLeft = WoConditionalLayers.round((float)toggle_label_offset.x);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_pref_use_keyboard_shortcuts")).getCaptionLabel().getStyle().marginTop = WoConditionalLayers.round((float)toggle_label_offset.y);
            ((Toggle)((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_pref_force_all_layers_to_zero")).setPosition((float)this.grid_column_positions[1], (float)this.grid_row_positions[2])).setSize(control_height, control_height)).setFont(ui_font);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_pref_force_all_layers_to_zero")).getCaptionLabel().getStyle().marginLeft = WoConditionalLayers.round((float)toggle_label_offset.x);
            ((Toggle)this.controls.get(Toggle.class, (String)"toggle_pref_force_all_layers_to_zero")).getCaptionLabel().getStyle().marginTop = WoConditionalLayers.round((float)toggle_label_offset.y);
            this.divider_positions[current_tab_id] = WoConditionalLayers.append((int[])this.divider_positions[current_tab_id], (int)this.grid_column_positions[11]);
        }

        public void client_connections_menu_update() {
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                int client_count = WoConditionalLayers.this.project.client_connections.size();
                String menu_text = "";
                String client_name = "";
                String client_name_truncated = "";
                WoConditionalLayers.this.ui_elements.dropdownlist_client_select.setBroadcast(false);
                WoConditionalLayers.this.ui_elements.dropdownlist_client_select.clear();
                WoConditionalLayers.this.ui_elements.dropdownlist_client_select.setOpen(false);
                if (client_count > 0) {
                    int i = 0;
                    while (i < client_count) {
                        AppClient client_connection = WoConditionalLayers.this.project.client_connections.get(i);
                        client_name = client_connection.name;
                        client_name_truncated = client_name.substring(0, WoConditionalLayers.min((int)22, (int)client_name.length()));
                        menu_text = String.valueOf(i + 1) + ": " + client_name;
                        WoConditionalLayers.this.ui_elements.dropdownlist_client_select.addItem(menu_text, (Object)i);
                        if (WoConditionalLayers.this.project.current_connection != null && client_connection.id == WoConditionalLayers.this.project.current_connection.id) {
                            WoConditionalLayers.this.ui_elements.dropdownlist_client_select.setCaptionLabel(String.valueOf(i + 1) + ": " + client_name_truncated);
                        }
                        ++i;
                    }
                    if (client_count > 0) {
                        WoConditionalLayers.this.ui_elements.dropdownlist_client_select.setLock(false);
                    }
                } else {
                    ((ScrollableList)WoConditionalLayers.this.ui_elements.dropdownlist_client_select.setCaptionLabel("Client Connections")).setLock(true);
                }
                WoConditionalLayers.this.ui_elements.dropdownlist_client_select.setBroadcast(true);
                ((Textlabel)this.controls.get(Textlabel.class, "label_client_count")).setText(String.valueOf(WoConditionalLayers.nf((float)client_count, (int)1, (int)0)) + " Clients");
            }
        }

        public void client_connection_control_update_values() {
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                if (WoConditionalLayers.this.project.current_connection != null) {
                    ((Textfield)this.controls.get(Textfield.class, "textfield_client_ip")).setText(WoConditionalLayers.this.project.current_connection.ip_address);
                    ((Textfield)this.controls.get(Textfield.class, "textfield_client_port")).setText(Integer.toString(WoConditionalLayers.this.project.current_connection.port));
                    ((Textfield)this.controls.get(Textfield.class, "textfield_client_name")).setText(WoConditionalLayers.this.project.current_connection.name);
                } else {
                    this.client_connection_controls_clear();
                }
            }
        }

        public void client_connection_controls_clear() {
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                ((Textfield)this.controls.get(Textfield.class, "textfield_client_ip")).setText("");
                ((Textfield)this.controls.get(Textfield.class, "textfield_client_port")).setText("");
                ((Textfield)this.controls.get(Textfield.class, "textfield_client_name")).setText("");
            }
        }

        public void colour_swatches_update() {
        }

        public void layer_control_values_update() {
            String control_name = "";
            int layer_id = 0;
            while (layer_id < WoConditionalLayers.this.project.layer_count) {
                int control_grid = 0;
                while (control_grid < this.layer_grid_names.length) {
                    control_name = String.valueOf(this.layer_grid_button_name_stem) + "_" + this.layer_grid_names[control_grid] + "_" + String.valueOf(layer_id);
                    int status_colour = WoConditionalLayers.this.get_colour_from_status(WoConditionalLayers.this.project.layer_values[control_grid][layer_id], false);
                    ((Bang)this.controls.get(Bang.class, control_name)).setColorForeground(status_colour);
                    ++control_grid;
                }
                ++layer_id;
            }
            WoConditionalLayers.this.ui_elements.layer_text_values_update();
        }

        public void layer_control_group_lock_update() {
            String control_name = "";
            int layer_control_group_id = -1;
            int layer_id = 0;
            while (layer_id < WoConditionalLayers.this.project.layer_count) {
                control_name = String.valueOf(this.layer_grid_button_name_stem) + "_" + this.layer_grid_names[0] + "_" + String.valueOf(layer_id);
                int n = WoConditionalLayers.this.project.operating_mode;
                WoConditionalLayers.this.project.getClass();
                if (n == 3) {
                    layer_control_group_id = WoConditionalLayers.this.project.layer_id_group_lookup[layer_id];
                    WoConditionalLayers.this.project.getClass();
                    if (layer_control_group_id == -1 || layer_control_group_id == WoConditionalLayers.this.project.current_layergroup.id) {
                        ((Bang)this.controls.get(Bang.class, control_name)).setLock(false);
                    } else {
                        ((Bang)this.controls.get(Bang.class, control_name)).setLock(true);
                    }
                } else {
                    ((Bang)this.controls.get(Bang.class, control_name)).setLock(false);
                }
                ++layer_id;
            }
        }

        public void layer_name_textfield_update() {
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                String layer_name = "- Layer Name -";
                String machine_name = "";
                if (WoConditionalLayers.this.project.layer_id_current > -1 && WoConditionalLayers.this.project.layer_names[WoConditionalLayers.this.project.layer_id_current] != null) {
                    layer_name = WoConditionalLayers.this.project.layer_names[WoConditionalLayers.this.project.layer_id_current];
                    machine_name = WoConditionalLayers.this.sanitize_network_string(layer_name);
                }
                ((Textfield)this.controls.get(Textfield.class, "textfield_layer_name")).setText(layer_name);
                ((Textlabel)this.controls.get(Textlabel.class, "label_layer_name_machine")).setText(machine_name);
            }
        }

        public void layer_text_values_update() {
            int grid_id = 0;
            while (grid_id < this.layer_grid_names.length) {
                String binary_string = WoConditionalLayers.this.project.layer_values_get_binary_string(grid_id);
                int binary_int_value = WoConditionalLayers.this.get_int_from_binary_string(binary_string);
                String display_text = binary_string;
                display_text = String.valueOf(display_text) + " - INTEGER: ";
                display_text = String.valueOf(display_text) + binary_int_value;
                String control_name = "label_data_" + this.layer_grid_names[grid_id];
                ((Textlabel)this.controls.get(Textlabel.class, control_name)).setText(display_text);
                ++grid_id;
            }
        }

        public void layer_group_data_update() {
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                if (WoConditionalLayers.this.project.current_layergroup != null) {
                    ((Textfield)this.controls.get(Textfield.class, "textfield_layergroup_name")).setText(WoConditionalLayers.this.project.current_layergroup.name);
                    ((Textlabel)this.controls.get(Textlabel.class, "label_layergroup_member_count")).setText(String.valueOf(WoConditionalLayers.this.project.current_layergroup.get_member_count()) + " Members");
                    ((Textlabel)this.controls.get(Textlabel.class, "label_layergroup_name_machine")).setText(WoConditionalLayers.this.project.current_layergroup.machine_name);
                    ((Button)this.controls.get(Button.class, "button_layergroup_delete")).setLock(false);
                    ((Button)((Button)this.controls.get(Button.class, "button_layergroup_swatch")).setColorBackground(WoConditionalLayers.this.project.current_layergroup.get_colour())).setColorActive(WoConditionalLayers.this.project.current_layergroup.get_colour());
                    ((Button)this.controls.get(Button.class, "button_layergroup_edit")).setLock(false);
                    ((ScrollableList)WoConditionalLayers.this.ui_elements.dropdownlist_layergroup_type.setBroadcast(false)).setValue((float)WoConditionalLayers.this.project.current_layergroup.type).setBroadcast(true);
                } else {
                    ((Textfield)this.controls.get(Textfield.class, "textfield_layergroup_name")).setText("- Group Name -");
                    ((Textlabel)this.controls.get(Textlabel.class, "label_layergroup_member_count")).setText("");
                    ((Textlabel)this.controls.get(Textlabel.class, "label_layergroup_name_machine")).setText("");
                    ((Button)this.controls.get(Button.class, "button_layergroup_delete")).setLock(true);
                    ((Button)this.controls.get(Button.class, "button_layergroup_edit")).setLock(true);
                }
            }
        }

        public void layer_group_edit_controls_status_update() {
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                int n = WoConditionalLayers.this.project.operating_mode;
                WoConditionalLayers.this.project.getClass();
                if (n == 3) {
                    ((Button)this.controls.get(Button.class, "button_layergroup_edit")).setCaptionLabel("END EDITING");
                    WoConditionalLayers.this.ui_elements.dropdownlist_project_mode.setLock(true);
                } else {
                    ((Button)this.controls.get(Button.class, "button_layergroup_edit")).setCaptionLabel("EDIT LAYERS");
                    WoConditionalLayers.this.ui_elements.dropdownlist_project_mode.setLock(false);
                }
            }
        }

        public void layer_group_menu_update() {
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                int group_count = WoConditionalLayers.this.project.layer_groups.size();
                String menu_text = "";
                String group_name = "";
                String group_name_truncated = "";
                WoConditionalLayers.this.ui_elements.dropdownlist_layergroup_select.setBroadcast(false);
                WoConditionalLayers.this.ui_elements.dropdownlist_layergroup_select.clear();
                WoConditionalLayers.this.ui_elements.dropdownlist_layergroup_select.setOpen(false);
                if (group_count > 0) {
                    int i = 0;
                    while (i < group_count) {
                        LayerGroup group = WoConditionalLayers.this.project.layer_groups.get(i);
                        group_name = group.name;
                        group_name_truncated = group_name.substring(0, WoConditionalLayers.min((int)22, (int)group_name.length()));
                        menu_text = String.valueOf(i + 1) + ": " + group_name;
                        WoConditionalLayers.this.ui_elements.dropdownlist_layergroup_select.addItem(menu_text, (Object)i);
                        if (WoConditionalLayers.this.project.current_layergroup != null && group.id == WoConditionalLayers.this.project.current_layergroup.id) {
                            WoConditionalLayers.this.ui_elements.dropdownlist_layergroup_select.setCaptionLabel(String.valueOf(i + 1) + ": " + group_name_truncated);
                        }
                        ++i;
                    }
                    this.layer_group_controls_lock(false);
                } else {
                    WoConditionalLayers.this.ui_elements.dropdownlist_layergroup_select.setCaptionLabel("Layer Groups");
                    this.layer_group_controls_lock(true);
                }
                WoConditionalLayers.this.ui_elements.dropdownlist_layergroup_select.setBroadcast(true);
            }
        }

        public void layer_group_controls_lock(Boolean locked_status) {
            WoConditionalLayers.this.ui_elements.dropdownlist_layergroup_select.setLock(locked_status.booleanValue());
            WoConditionalLayers.this.ui_elements.dropdownlist_layergroup_type.setLock(locked_status.booleanValue());
            ((Button)this.controls.get(Button.class, "button_layergroup_delete")).setLock(locked_status.booleanValue());
            ((Button)this.controls.get(Button.class, "button_layergroup_edit")).setLock(locked_status.booleanValue());
            ((Textfield)this.controls.get(Textfield.class, "textfield_layergroup_name")).setLock(locked_status.booleanValue());
        }

        public void network_status_controls_update() {
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                String[] status_text = new String[]{"OFFLINE", "ONLINE"};
                Boolean server_status = WoConditionalLayers.this.project.app_server_udp.status_get();
                ((Button)((Button)this.controls.get(Button.class, "button_server_udp_toggle")).setColorBackground(WoConditionalLayers.this.get_colour_from_boolean_status(server_status, false))).setLabel(status_text[WoConditionalLayers.this.get_boolean_as_int(server_status)]);
                ((Button)this.controls.get(Button.class, "button_server_udp_status")).setColorBackground(WoConditionalLayers.this.get_colour_from_boolean_status(server_status, false));
                server_status = WoConditionalLayers.this.project.app_server_osc.status_get();
                ((Button)((Button)this.controls.get(Button.class, "button_server_osc_toggle")).setColorBackground(WoConditionalLayers.this.get_colour_from_boolean_status(server_status, false))).setLabel(status_text[WoConditionalLayers.this.get_boolean_as_int(server_status)]);
                ((Button)this.controls.get(Button.class, "button_server_osc_status")).setColorBackground(WoConditionalLayers.this.get_colour_from_boolean_status(server_status, false));
                server_status = WoConditionalLayers.this.project.app_broadcasting;
                ((Button)((Button)this.controls.get(Button.class, "button_app_broadcast_toggle")).setColorBackground(WoConditionalLayers.this.get_colour_from_boolean_status(server_status, false))).setLabel(status_text[WoConditionalLayers.this.get_boolean_as_int(server_status)]);
                status_text[1] = "BROADCASTING";
                ((Button)((Button)this.controls.get(Button.class, "button_app_broadcast_status")).setColorBackground(WoConditionalLayers.this.get_colour_from_boolean_status(server_status, false))).setLabel(status_text[WoConditionalLayers.this.get_boolean_as_int(server_status)]);
            }
        }

        public void preset_data_update() {
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                if (WoConditionalLayers.this.project.current_preset != null) {
                    ((Textfield)this.controls.get(Textfield.class, "textfield_preset_name")).setText(WoConditionalLayers.this.project.current_preset.name);
                    ((Textlabel)this.controls.get(Textlabel.class, "label_preset_name_machine")).setText(WoConditionalLayers.this.project.current_preset.machine_name);
                    ((Button)this.controls.get(Button.class, "button_preset_update")).setLock(false);
                    ((Button)this.controls.get(Button.class, "button_preset_recall")).setLock(false);
                    ((Button)this.controls.get(Button.class, "button_preset_delete")).setLock(false);
                } else {
                    ((Textfield)this.controls.get(Textfield.class, "textfield_preset_name")).setText("- Preset Name -");
                    ((Textlabel)this.controls.get(Textlabel.class, "label_preset_name_machine")).setText("");
                    ((Button)this.controls.get(Button.class, "button_preset_update")).setLock(true);
                    ((Button)this.controls.get(Button.class, "button_preset_recall")).setLock(true);
                    ((Button)this.controls.get(Button.class, "button_preset_delete")).setLock(true);
                }
            }
        }

        public void preset_menus_update() {
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                int preset_count = WoConditionalLayers.this.project.layer_presets.size();
                String menu_text = "";
                String preset_name = "";
                String preset_name_truncated = "";
                ((ScrollableList)WoConditionalLayers.this.ui_elements.dropdownlist_preset_recall.setBroadcast(false)).clear().setOpen(false);
                ((ScrollableList)WoConditionalLayers.this.ui_elements.dropdownlist_preset_edit.setBroadcast(false)).clear().setOpen(false);
                if (preset_count > 0) {
                    int i = 0;
                    while (i < preset_count) {
                        LayerPreset layer_preset = WoConditionalLayers.this.project.layer_presets.get(i);
                        preset_name = layer_preset.name;
                        preset_name_truncated = preset_name.substring(0, WoConditionalLayers.min((int)22, (int)preset_name.length()));
                        menu_text = String.valueOf(i + 1) + ": " + preset_name;
                        WoConditionalLayers.this.ui_elements.dropdownlist_preset_recall.addItem(menu_text, (Object)i);
                        WoConditionalLayers.this.ui_elements.dropdownlist_preset_edit.addItem(menu_text, (Object)i);
                        if (layer_preset.id == WoConditionalLayers.this.project.current_preset.id) {
                            WoConditionalLayers.this.ui_elements.dropdownlist_preset_recall.setCaptionLabel(String.valueOf(i + 1) + ": " + preset_name_truncated);
                            WoConditionalLayers.this.ui_elements.dropdownlist_preset_edit.setCaptionLabel(String.valueOf(i + 1) + ": " + preset_name_truncated);
                        }
                        ++i;
                    }
                    if (preset_count > 1) {
                        WoConditionalLayers.this.ui_elements.dropdownlist_preset_recall.setLock(false);
                        WoConditionalLayers.this.ui_elements.dropdownlist_preset_edit.setLock(false);
                    }
                } else {
                    ((ScrollableList)WoConditionalLayers.this.ui_elements.dropdownlist_preset_recall.setCaptionLabel("Preset Recall")).setLock(true);
                    ((ScrollableList)WoConditionalLayers.this.ui_elements.dropdownlist_preset_edit.setCaptionLabel("Preset Edit")).setLock(true);
                }
                WoConditionalLayers.this.ui_elements.dropdownlist_preset_recall.setBroadcast(true);
                WoConditionalLayers.this.ui_elements.dropdownlist_preset_edit.setBroadcast(true);
            }
        }

        public void project_filepath_update() {
            WoConditionalLayers.this.ui.ready.booleanValue();
        }

        public void project_preference_toggle_controls_update() {
            ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_pref_take_auto_switch")).setBroadcast(false)).setValue(WoConditionalLayers.this.project.pref_take_auto_switch.booleanValue()).setBroadcast(true);
            ((Toggle)((Toggle)this.controls.get(Toggle.class, "toggle_pref_use_keyboard_shortcuts")).setBroadcast(false)).setValue(WoConditionalLayers.this.project.pref_use_keyboard_shortcuts.booleanValue()).setBroadcast(true);
        }

        public void project_summary_update() {
            WoConditionalLayers.this.ui.ready.booleanValue();
        }

        public void scale_slider_update() {
            WoConditionalLayers.this.ui.ready.booleanValue();
        }

        public void update_all_controls() {
            if (WoConditionalLayers.this.ui.ready.booleanValue()) {
                switch (WoConditionalLayers.this.project.operating_mode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        ((Textlabel)this.controls.get(Textlabel.class, "label_data_prev")).setVisible(false);
                    }
                }
                this.client_connections_menu_update();
                this.layer_control_group_lock_update();
                this.layer_control_values_update();
                this.layer_name_textfield_update();
                this.layer_group_menu_update();
                this.layer_group_edit_controls_status_update();
                this.network_status_controls_update();
                this.preset_menus_update();
                this.preset_data_update();
                this.move_controls();
            }
        }
    }
}

