/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

@InstrumentationTarget(value="java.io.FileInputStream")
public final class FileInputStreamRMHooks {
    private final FileDescriptor fd = null;
    private String path = null;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;

    @InstrumentationMethod
    public final FileDescriptor getFD() throws IOException {
        return this.getFD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    private void open(String string) throws FileNotFoundException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_OPEN_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = resourceRequest.request(1L, resourceIdImpl);
            if (l < 1L) {
                throw new FileNotFoundException(string + ": resource limited: too many open files");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(string + ": resource limited: too many open files");
            fileNotFoundException.initCause(resourceRequestDeniedException);
            throw fileNotFoundException;
        }
        ResourceRequest resourceRequest2 = null;
        long l2 = 0L;
        int n = 0;
        try {
            FileDescriptor fileDescriptor = null;
            try {
                fileDescriptor = this.getFD();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            resourceRequest2 = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(fileDescriptor);
            try {
                l2 = resourceRequest2.request(1L, resourceIdImpl);
                if (l2 < 1L) {
                    throw new FileNotFoundException(string + ": resource limited: too many open file descriptors");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                FileNotFoundException fileNotFoundException = new FileNotFoundException(string + ": resource limited: too many open file descriptors");
                fileNotFoundException.initCause(resourceRequestDeniedException);
                throw fileNotFoundException;
            }
            this.open(string);
            n = 1;
        }
        finally {
            resourceRequest2.request(-(l2 - (long)n), resourceIdImpl);
            resourceRequest.request(-(l - (long)n), resourceIdImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read() throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = this.getFD() == FileDescriptor.in ? ApproverGroup.STDIN_READ_GROUP.getApprover(this) : ApproverGroup.FILE_READ_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = resourceRequest.request(1L, resourceIdImpl);
            if (l < 1L) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n = -1;
        try {
            n = this.read();
            resourceRequest.request(-(l - (long)(n == -1 ? 0 : 1)), resourceIdImpl);
        }
        catch (Throwable throwable) {
            resourceRequest.request(-(l - (long)(n == -1 ? 0 : 1)), resourceIdImpl);
            throw throwable;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            return this.read(byArray);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = this.getFD() == FileDescriptor.in ? ApproverGroup.STDIN_READ_GROUP.getApprover(this) : ApproverGroup.FILE_READ_GROUP.getApprover(this);
        int n = byArray.length;
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(n, resourceIdImpl), 0L);
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        int n3 = 0;
        try {
            if (l < (long)n) {
                resourceRequest.request(-l, resourceIdImpl);
                n3 = this.read(byArray, 0, byArray.length);
                n2 = Math.max(n3, 0);
            } else {
                n3 = this.read(byArray);
                n2 = Math.max(n3, 0);
            }
        }
        finally {
            resourceRequest.request(-(l - (long)n2), resourceIdImpl);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            return this.read(byArray, n, n2);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = this.getFD() == FileDescriptor.in ? ApproverGroup.STDIN_READ_GROUP.getApprover(this) : ApproverGroup.FILE_READ_GROUP.getApprover(this);
        long l = 0L;
        try {
            l = Math.max(resourceRequest.request(n2, resourceIdImpl), 0L);
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        n2 = Math.min(n2, (int)l);
        int n4 = 0;
        try {
            n3 = this.read(byArray, n, n2);
            n4 = Math.max(n3, 0);
        }
        finally {
            resourceRequest.request(-(l - (long)n4), resourceIdImpl);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void close() throws IOException {
        long l;
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
        }
        JavaIOFileDescriptorAccess javaIOFileDescriptorAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
        try {
            l = javaIOFileDescriptorAccess.getHandle(this.fd);
            if (l == -1L) {
                l = javaIOFileDescriptorAccess.get(this.fd);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            l = javaIOFileDescriptorAccess.get(this.fd);
        }
        try {
            this.close();
        }
        finally {
            ResourceRequest resourceRequest;
            long l2;
            try {
                l2 = javaIOFileDescriptorAccess.getHandle(this.fd);
                if (l2 == -1L) {
                    l2 = javaIOFileDescriptorAccess.get(this.fd);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                l2 = javaIOFileDescriptorAccess.get(this.fd);
            }
            ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
            if (l2 != l) {
                resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(this.fd);
                resourceRequest.request(-1L, resourceIdImpl);
            }
            resourceRequest = ApproverGroup.FILE_OPEN_GROUP.getApprover(this);
            resourceRequest.request(-1L, resourceIdImpl);
        }
    }
}

