/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.awt;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.OffscreenLayerOption;
import com.jogamp.nativewindow.ScalableSurface;
import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.awt.AWTPrintLifecycle;
import com.jogamp.nativewindow.awt.AWTWindowClosingProtocol;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.GLSharedContextSetter;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.Threading;
import com.jogamp.opengl.awt.AWTGLAutoDrawable;
import com.jogamp.opengl.util.GLDrawableUtil;
import com.jogamp.opengl.util.TileRenderer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.SurfaceScaleUtils;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.awt.AWTTilePainter;

public class GLCanvas
extends Canvas
implements AWTGLAutoDrawable,
WindowClosingProtocol,
OffscreenLayerOption,
AWTPrintLifecycle,
GLSharedContextSetter,
ScalableSurface {
    private static final boolean DEBUG = Debug.debug("GLCanvas");
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    private final GLDrawableHelper helper = new GLDrawableHelper();
    private volatile GLDrawableImpl drawable;
    private volatile JAWTWindow jawtWindow;
    private volatile GLContextImpl context;
    private volatile boolean sendReshape = false;
    private final float[] minPixelScale = new float[]{1.0f, 1.0f};
    private final float[] maxPixelScale = new float[]{1.0f, 1.0f};
    private final float[] hasPixelScale = new float[]{1.0f, 1.0f};
    final float[] reqPixelScale = new float[]{0.0f, 0.0f};
    private final GLCapabilitiesImmutable capsReqUser;
    private final GLCapabilitiesChooser chooser;
    private int additionalCtxCreationFlags = 0;
    private boolean shallUseOffscreenLayer = false;
    private volatile GraphicsDevice awtDeviceReq;
    private volatile AWTGraphicsConfiguration awtConfig;
    private volatile boolean isShowing;
    private final HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            GLCanvas.this.isShowing = GLCanvas.this.isShowing();
        }
    };
    private final AWTWindowClosingProtocol awtWindowClosingProtocol = new AWTWindowClosingProtocol(this, new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.destroyImpl(true);
        }
    }, null);
    private final Runnable realizeOnEDTAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.setRealizedImpl(true);
        }
    };
    private final Runnable unrealizeOnEDTAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.setRealizedImpl(false);
        }
    };
    private final Runnable setSurfaceScaleOnEDTAction = new Runnable(){

        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                if (null != GLCanvas.this.drawable && GLCanvas.this.drawable.isRealized() && GLCanvas.this.setSurfaceScaleImpl(GLCanvas.this.jawtWindow)) {
                    GLCanvas.this.reshapeImpl(GLCanvas.this.getWidth(), GLCanvas.this.getHeight());
                    if (!GLCanvas.this.helper.isAnimatorAnimatingOnOtherThread()) {
                        GLCanvas.this.helper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.displayAction, GLCanvas.this.initAction);
                    }
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private volatile boolean printActive = false;
    private GLAnimatorControl printAnimator = null;
    private GLAutoDrawable printGLAD = null;
    private AWTTilePainter printAWTTiles = null;
    private final Runnable setupPrintOnEDT = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                boolean bl;
                if (!GLCanvas.this.validateGLDrawable()) {
                    if (DEBUG) {
                        System.err.println(GLCanvas.getThreadName() + ": Info: GLCanvas setupPrint - skipped GL render, drawable not valid yet");
                    }
                    GLCanvas.this.printActive = false;
                    return;
                }
                if (!GLCanvas.this.isVisible()) {
                    if (DEBUG) {
                        System.err.println(GLCanvas.getThreadName() + ": Info: GLCanvas setupPrint - skipped GL render, canvas not visible");
                    }
                    GLCanvas.this.printActive = false;
                    return;
                }
                GLCanvas.this.sendReshape = false;
                GLCanvas.this.printAnimator = GLCanvas.this.helper.getAnimator();
                if (null != GLCanvas.this.printAnimator) {
                    GLCanvas.this.printAnimator.remove(GLCanvas.this);
                }
                GLCanvas.this.printGLAD = GLCanvas.this;
                GLCapabilitiesImmutable gLCapabilitiesImmutable = GLCanvas.this.getChosenGLCapabilities();
                int n = GLCanvas.this.printAWTTiles.getNumSamples(gLCapabilitiesImmutable);
                GLDrawable gLDrawable = GLCanvas.this.printGLAD.getDelegatedDrawable();
                boolean bl2 = n != gLCapabilitiesImmutable.getNumSamples();
                boolean bl3 = ((GLCanvas)GLCanvas.this).printAWTTiles.customTileWidth != -1 && ((GLCanvas)GLCanvas.this).printAWTTiles.customTileWidth != gLDrawable.getSurfaceWidth() || ((GLCanvas)GLCanvas.this).printAWTTiles.customTileHeight != -1 && ((GLCanvas)GLCanvas.this).printAWTTiles.customTileHeight != gLDrawable.getSurfaceHeight();
                boolean bl4 = gLCapabilitiesImmutable.isOnscreen();
                GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
                gLCapabilities.setDoubleBuffered(false);
                gLCapabilities.setOnscreen(false);
                if (n != gLCapabilities.getNumSamples()) {
                    gLCapabilities.setSampleBuffers(0 < n);
                    gLCapabilities.setNumSamples(n);
                }
                boolean bl5 = GLDrawableUtil.isSwapGLContextSafe(GLCanvas.this.getRequestedGLCapabilities(), gLCapabilitiesImmutable, gLCapabilities);
                boolean bl6 = bl = (bl4 || bl2 || bl3) && bl5;
                if (DEBUG) {
                    System.err.println("AWT print.setup: reqNewGLAD " + bl + "[ onscreen " + bl4 + ", samples " + bl2 + ", size " + bl3 + ", safe " + bl5 + "], , drawableSize " + gLDrawable.getSurfaceWidth() + "x" + gLDrawable.getSurfaceHeight() + ", customTileSize " + ((GLCanvas)GLCanvas.this).printAWTTiles.customTileWidth + "x" + ((GLCanvas)GLCanvas.this).printAWTTiles.customTileHeight + ", scaleMat " + ((GLCanvas)GLCanvas.this).printAWTTiles.scaleMatX + " x " + ((GLCanvas)GLCanvas.this).printAWTTiles.scaleMatY + ", numSamples " + ((GLCanvas)GLCanvas.this).printAWTTiles.customNumSamples + " -> " + n + ", printAnimator " + GLCanvas.this.printAnimator);
                }
                if (bl) {
                    GLOffscreenAutoDrawable gLOffscreenAutoDrawable;
                    block17: {
                        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
                        gLOffscreenAutoDrawable = null;
                        try {
                            gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilities, null, ((GLCanvas)GLCanvas.this).printAWTTiles.customTileWidth != -1 ? ((GLCanvas)GLCanvas.this).printAWTTiles.customTileWidth : 1024, ((GLCanvas)GLCanvas.this).printAWTTiles.customTileHeight != -1 ? ((GLCanvas)GLCanvas.this).printAWTTiles.customTileHeight : 1024);
                        }
                        catch (GLException gLException) {
                            if (!DEBUG) break block17;
                            System.err.println("Caught: " + gLException.getMessage());
                            gLException.printStackTrace();
                        }
                    }
                    if (null != gLOffscreenAutoDrawable) {
                        GLCanvas.this.printGLAD = gLOffscreenAutoDrawable;
                        GLDrawableUtil.swapGLContextAndAllGLEventListener(GLCanvas.this, GLCanvas.this.printGLAD);
                        gLDrawable = GLCanvas.this.printGLAD.getDelegatedDrawable();
                    }
                }
                GLCanvas.this.printAWTTiles.setGLOrientation(GLCanvas.this.printGLAD.isGLOriented(), GLCanvas.this.printGLAD.isGLOriented());
                ((GLCanvas)GLCanvas.this).printAWTTiles.renderer.setTileSize(gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), 0);
                ((GLCanvas)GLCanvas.this).printAWTTiles.renderer.attachAutoDrawable(GLCanvas.this.printGLAD);
                if (DEBUG) {
                    System.err.println("AWT print.setup " + GLCanvas.this.printAWTTiles);
                    System.err.println("AWT print.setup AA " + n + ", " + gLCapabilities);
                    System.err.println("AWT print.setup printGLAD: " + GLCanvas.this.printGLAD.getSurfaceWidth() + "x" + GLCanvas.this.printGLAD.getSurfaceHeight() + ", " + GLCanvas.this.printGLAD);
                    System.err.println("AWT print.setup printDraw: " + gLDrawable.getSurfaceWidth() + "x" + gLDrawable.getSurfaceHeight() + ", " + gLDrawable);
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Runnable releasePrintOnEDT = new Runnable(){

        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                if (DEBUG) {
                    System.err.println("AWT print.release " + GLCanvas.this.printAWTTiles);
                }
                GLCanvas.this.printAWTTiles.dispose();
                GLCanvas.this.printAWTTiles = null;
                if (GLCanvas.this.printGLAD != GLCanvas.this) {
                    GLDrawableUtil.swapGLContextAndAllGLEventListener(GLCanvas.this.printGLAD, GLCanvas.this);
                    GLCanvas.this.printGLAD.destroy();
                }
                GLCanvas.this.printGLAD = null;
                if (null != GLCanvas.this.printAnimator) {
                    GLCanvas.this.printAnimator.add(GLCanvas.this);
                    GLCanvas.this.printAnimator = null;
                }
                GLCanvas.this.sendReshape = true;
                GLCanvas.this.printActive = false;
                GLCanvas.this.display();
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Runnable destroyOnEDTAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                GLAnimatorControl gLAnimatorControl = GLCanvas.this.getAnimator();
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Info: destroyOnEDTAction() - START, hasContext " + (null != GLCanvas.this.context) + ", hasDrawable " + (null != GLCanvas.this.drawable) + ", " + gLAnimatorControl);
                }
                boolean bl = null != gLAnimatorControl ? gLAnimatorControl.pause() : false;
                GLException gLException = null;
                if (null != GLCanvas.this.context) {
                    if (GLCanvas.this.context.isCreated()) {
                        try {
                            GLCanvas.this.helper.disposeGL(GLCanvas.this, GLCanvas.this.context, true);
                            if (DEBUG) {
                                System.err.println(GLCanvas.getThreadName() + ": destroyOnEDTAction() - post ctx: " + GLCanvas.this.context);
                            }
                        }
                        catch (GLException gLException2) {
                            gLException = gLException2;
                        }
                    }
                    GLCanvas.this.context = null;
                }
                Throwable throwable = null;
                if (null != GLCanvas.this.drawable) {
                    try {
                        GLCanvas.this.drawable.setRealized(false);
                        if (DEBUG) {
                            System.err.println(GLCanvas.getThreadName() + ": destroyOnEDTAction() - post drawable: " + GLCanvas.this.drawable);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                    GLCanvas.this.drawable = null;
                }
                if (bl) {
                    gLAnimatorControl.resume();
                }
                if (null != gLException) {
                    throw gLException;
                }
                if (null != throwable) {
                    throw GLException.newGLException(throwable);
                }
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": dispose() - END, animator " + gLAnimatorControl);
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Runnable disposeJAWTWindowAndAWTDeviceOnEDT = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.context = null;
            GLCanvas.this.drawable = null;
            if (null != GLCanvas.this.jawtWindow) {
                GLCanvas.this.jawtWindow.destroy();
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": GLCanvas.disposeJAWTWindowAndAWTDeviceOnEDT(): post JAWTWindow: " + GLCanvas.this.jawtWindow);
                }
                GLCanvas.this.jawtWindow = null;
            }
            ((GLCanvas)GLCanvas.this).hasPixelScale[0] = 1.0f;
            ((GLCanvas)GLCanvas.this).hasPixelScale[1] = 1.0f;
            ((GLCanvas)GLCanvas.this).minPixelScale[0] = 1.0f;
            ((GLCanvas)GLCanvas.this).minPixelScale[1] = 1.0f;
            ((GLCanvas)GLCanvas.this).maxPixelScale[0] = 1.0f;
            ((GLCanvas)GLCanvas.this).maxPixelScale[1] = 1.0f;
            if (null != GLCanvas.this.awtConfig) {
                AbstractGraphicsConfiguration abstractGraphicsConfiguration = GLCanvas.this.awtConfig.getNativeGraphicsConfiguration();
                AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
                String string = DEBUG ? abstractGraphicsDevice.toString() : null;
                boolean bl = abstractGraphicsDevice.close();
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": GLCanvas.disposeJAWTWindowAndAWTDeviceOnEDT(): post GraphicsDevice: " + string + ", result: " + bl);
                }
            }
            GLCanvas.this.awtConfig = null;
        }
    };
    private final Runnable initAction = new Runnable(){

        @Override
        public void run() {
            GLCanvas.this.helper.init(GLCanvas.this, !GLCanvas.this.sendReshape);
        }
    };
    private final Runnable displayAction = new Runnable(){

        @Override
        public void run() {
            if (GLCanvas.this.sendReshape) {
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Reshape: " + GLCanvas.this.getSurfaceWidth() + "x" + GLCanvas.this.getSurfaceHeight());
                }
                GLCanvas.this.helper.reshape(GLCanvas.this, 0, 0, GLCanvas.this.getSurfaceWidth(), GLCanvas.this.getSurfaceHeight());
                GLCanvas.this.sendReshape = false;
            }
            GLCanvas.this.helper.display(GLCanvas.this);
        }
    };
    private final Runnable displayOnEDTAction = new Runnable(){

        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                if (null != GLCanvas.this.drawable && GLCanvas.this.drawable.isRealized()) {
                    if (GLCanvas.this.updatePixelScale()) {
                        GLCanvas.this.reshapeImpl(GLCanvas.this.getWidth(), GLCanvas.this.getHeight());
                    }
                    GLCanvas.this.helper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.displayAction, GLCanvas.this.initAction);
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private final Runnable swapBuffersOnEDTAction = new Runnable(){

        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                if (null != GLCanvas.this.drawable && GLCanvas.this.drawable.isRealized()) {
                    GLCanvas.this.drawable.swapBuffers();
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    };
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;

    public GLCanvas() throws GLException {
        this((GLCapabilitiesImmutable)null);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws GLException {
        this(gLCapabilitiesImmutable, null, null);
    }

    public GLCanvas(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) throws GLException {
        this.capsReqUser = null == gLCapabilitiesImmutable ? new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDevice())) : (GLCapabilitiesImmutable)gLCapabilitiesImmutable.cloneMutable();
        if (!this.capsReqUser.isOnscreen()) {
            this.setShallUseOffscreenLayer(true);
        }
        this.awtDeviceReq = graphicsDevice;
        this.chooser = gLCapabilitiesChooser;
        this.addHierarchyListener(this.hierarchyListener);
        this.isShowing = this.isShowing();
    }

    @Override
    public final void setSharedContext(GLContext gLContext) throws IllegalStateException {
        this.helper.setSharedContext(this.context, gLContext);
    }

    @Override
    public final void setSharedAutoDrawable(GLAutoDrawable gLAutoDrawable) throws IllegalStateException {
        this.helper.setSharedAutoDrawable(this, gLAutoDrawable);
    }

    @Override
    public final Object getUpstreamWidget() {
        return this;
    }

    @Override
    public final RecursiveLock getUpstreamLock() {
        return this.lock;
    }

    @Override
    public final boolean isThreadGLCapable() {
        return Threading.isOpenGLThread();
    }

    @Override
    public void setShallUseOffscreenLayer(boolean bl) {
        this.shallUseOffscreenLayer = bl;
    }

    @Override
    public final boolean getShallUseOffscreenLayer() {
        return this.shallUseOffscreenLayer;
    }

    @Override
    public final boolean isOffscreenLayerSurfaceEnabled() {
        JAWTWindow jAWTWindow = this.jawtWindow;
        if (null != jAWTWindow) {
            return jAWTWindow.isOffscreenLayerSurfaceEnabled();
        }
        return false;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration;
        GraphicsConfiguration graphicsConfiguration2 = super.getGraphicsConfiguration();
        if (Beans.isDesignTime()) {
            return graphicsConfiguration2;
        }
        GraphicsConfiguration graphicsConfiguration3 = graphicsConfiguration = null != this.awtConfig ? this.awtConfig.getAWTGraphicsConfiguration() : null;
        if (null != graphicsConfiguration2 && null != graphicsConfiguration && !graphicsConfiguration.equals(graphicsConfiguration2)) {
            if (!graphicsConfiguration.getDevice().getIDstring().equals(graphicsConfiguration2.getDevice().getIDstring())) {
                AWTGraphicsConfiguration aWTGraphicsConfiguration = this.chooseGraphicsConfiguration((GLCapabilitiesImmutable)this.awtConfig.getChosenCapabilities(), (GLCapabilitiesImmutable)this.awtConfig.getRequestedCapabilities(), this.chooser, graphicsConfiguration2.getDevice());
                GraphicsConfiguration graphicsConfiguration4 = aWTGraphicsConfiguration.getAWTGraphicsConfiguration();
                boolean bl = aWTGraphicsConfiguration.getChosenCapabilities().equals(this.awtConfig.getChosenCapabilities());
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": getGraphicsConfiguration() Info: Changed GC and GD");
                    System.err.println("Created Config (n): Old     GC " + graphicsConfiguration);
                    System.err.println("Created Config (n): Old     GD " + graphicsConfiguration.getDevice().getIDstring());
                    System.err.println("Created Config (n): Parent  GC " + graphicsConfiguration2);
                    System.err.println("Created Config (n): Parent  GD " + graphicsConfiguration2.getDevice().getIDstring());
                    System.err.println("Created Config (n): New     GC " + graphicsConfiguration4);
                    System.err.println("Created Config (n): New     GD " + graphicsConfiguration4.getDevice().getIDstring());
                    System.err.println("Created Config (n): Old     CF " + this.awtConfig);
                    System.err.println("Created Config (n): New     CF " + aWTGraphicsConfiguration);
                    System.err.println("Created Config (n): EQUALS CAPS " + bl);
                }
                if (null != graphicsConfiguration4) {
                    if (!bl && GLAutoDrawable.SCREEN_CHANGE_ACTION_ENABLED) {
                        this.destroyImpl(true);
                        this.setAWTGraphicsConfiguration(aWTGraphicsConfiguration);
                        this.createJAWTDrawableAndContext();
                        this.validateGLDrawable();
                    } else {
                        this.setAWTGraphicsConfiguration(aWTGraphicsConfiguration);
                    }
                    if (DEBUG) {
                        System.err.println(GLCanvas.getThreadName() + ": Info: getGraphicsConfiguration - end.01: newGC " + graphicsConfiguration4);
                    }
                    return graphicsConfiguration4;
                }
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Info: getGraphicsConfiguration - end.00: oldGC " + graphicsConfiguration);
                }
            }
            return graphicsConfiguration;
        }
        if (null == graphicsConfiguration2) {
            return graphicsConfiguration;
        }
        return graphicsConfiguration2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext createContext(GLContext gLContext) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            if (this.drawable != null) {
                GLContext gLContext2 = this.drawable.createContext(gLContext);
                gLContext2.setContextCreationFlags(this.additionalCtxCreationFlags);
                GLContext gLContext3 = gLContext2;
                return gLContext3;
            }
            GLContext gLContext4 = null;
            return gLContext4;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setRealizedImpl(boolean bl) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            GLDrawableImpl gLDrawableImpl = this.drawable;
            if (null == gLDrawableImpl || bl == gLDrawableImpl.isRealized() || bl && (0 >= gLDrawableImpl.getSurfaceWidth() || 0 >= gLDrawableImpl.getSurfaceHeight())) {
                return;
            }
            gLDrawableImpl.setRealized(bl);
            if (bl && gLDrawableImpl.isRealized()) {
                this.sendReshape = true;
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final void setRealized(boolean bl) {
        AWTEDTExecutor.singleton.invoke(this.getTreeLock(), false, true, bl ? this.realizeOnEDTAction : this.unrealizeOnEDTAction);
    }

    @Override
    public boolean isRealized() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.isRealized() : false;
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.awtWindowClosingProtocol.getDefaultCloseOperation();
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        return this.awtWindowClosingProtocol.setDefaultCloseOperation(windowClosingMode);
    }

    @Override
    public void display() {
        if (!this.validateGLDrawable()) {
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": Info: GLCanvas display - skipped GL render, drawable not valid yet");
            }
            return;
        }
        if (this.isShowing && !this.printActive) {
            Threading.invoke(true, this.displayOnEDTAction, this.getTreeLock());
        }
    }

    @Override
    public void destroy() {
        this.destroyImpl(false);
    }

    protected void destroyImpl(boolean bl) {
        Threading.invoke(true, this.destroyOnEDTAction, this.getTreeLock());
        if (bl) {
            AWTEDTExecutor.singleton.invoke(this.getTreeLock(), true, true, this.disposeJAWTWindowAndAWTDeviceOnEDT);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
        } else if (!this.helper.isAnimatorAnimatingOnOtherThread()) {
            this.display();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            boolean bl = Beans.isDesignTime();
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": Info: addNotify - start, bounds: " + this.getBounds() + ", isBeansDesignTime " + bl);
            }
            if (bl) {
                super.addNotify();
            } else {
                GraphicsDevice graphicsDevice;
                Object object;
                this.disableBackgroundErase();
                if (null == this.awtDeviceReq) {
                    object = super.getGraphicsConfiguration();
                    if (null == object) {
                        throw new GLException("Error: NULL AWT GraphicsConfiguration");
                    }
                    graphicsDevice = ((GraphicsConfiguration)object).getDevice();
                } else {
                    graphicsDevice = this.awtDeviceReq;
                    this.awtDeviceReq = null;
                }
                object = this.chooseGraphicsConfiguration(this.capsReqUser, this.capsReqUser, this.chooser, graphicsDevice);
                if (null == object) {
                    throw new GLException("Error: NULL AWTGraphicsConfiguration");
                }
                this.setAWTGraphicsConfiguration((AWTGraphicsConfiguration)object);
                super.addNotify();
                this.disableBackgroundErase();
                this.createJAWTDrawableAndContext();
            }
            this.awtWindowClosingProtocol.addClosingListener();
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": Info: addNotify - end: peer: " + this.getPeer());
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final boolean setSurfaceScale(float[] fArray) {
        System.arraycopy(fArray, 0, this.reqPixelScale, 0, 2);
        if (this.isRealized() && this.isShowing) {
            Threading.invoke(true, this.setSurfaceScaleOnEDTAction, this.getTreeLock());
            return true;
        }
        return false;
    }

    private final boolean setSurfaceScaleImpl(ScalableSurface scalableSurface) {
        if (scalableSurface.setSurfaceScale(this.reqPixelScale)) {
            scalableSurface.getCurrentSurfaceScale(this.hasPixelScale);
            return true;
        }
        return false;
    }

    private final boolean updatePixelScale() {
        if (this.jawtWindow.hasPixelScaleChanged()) {
            this.jawtWindow.getMaximumSurfaceScale(this.maxPixelScale);
            this.jawtWindow.getMinimumSurfaceScale(this.minPixelScale);
            return this.setSurfaceScaleImpl(this.jawtWindow);
        }
        return false;
    }

    @Override
    public final float[] getRequestedSurfaceScale(float[] fArray) {
        System.arraycopy(this.reqPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getCurrentSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public float[] getMinimumSurfaceScale(float[] fArray) {
        System.arraycopy(this.minPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public float[] getMaximumSurfaceScale(float[] fArray) {
        System.arraycopy(this.maxPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    private void createJAWTDrawableAndContext() {
        if (!Beans.isDesignTime()) {
            this.jawtWindow = (JAWTWindow)NativeWindowFactory.getNativeWindow(this, this.awtConfig);
            this.jawtWindow.setShallUseOffscreenLayer(this.shallUseOffscreenLayer);
            this.jawtWindow.lockSurface();
            try {
                this.jawtWindow.setSurfaceScale(this.reqPixelScale);
                this.drawable = (GLDrawableImpl)GLDrawableFactory.getFactory(this.capsReqUser.getGLProfile()).createGLDrawable(this.jawtWindow);
                this.createContextImpl(this.drawable);
                this.jawtWindow.getCurrentSurfaceScale(this.hasPixelScale);
                this.jawtWindow.getMinimumSurfaceScale(this.minPixelScale);
                this.jawtWindow.getMaximumSurfaceScale(this.maxPixelScale);
            }
            finally {
                this.jawtWindow.unlockSurface();
            }
        }
    }

    private boolean createContextImpl(GLDrawable gLDrawable) {
        GLContext[] gLContextArray = new GLContext[]{null};
        if (!this.helper.isSharedGLContextPending(gLContextArray)) {
            this.context = (GLContextImpl)gLDrawable.createContext(gLContextArray[0]);
            this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": Context created: has shared " + (null != gLContextArray[0]));
            }
            return true;
        }
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": Context !created: pending share");
        }
        return false;
    }

    private boolean validateGLDrawable() {
        if (Beans.isDesignTime() || !this.isDisplayable()) {
            return false;
        }
        GLDrawableImpl gLDrawableImpl = this.drawable;
        if (null != gLDrawableImpl) {
            boolean bl = gLDrawableImpl.isRealized();
            if (!bl) {
                if (0 >= gLDrawableImpl.getSurfaceWidth() || 0 >= gLDrawableImpl.getSurfaceHeight()) {
                    return false;
                }
                this.setRealized(true);
                bl = gLDrawableImpl.isRealized();
                if (DEBUG) {
                    System.err.println(GLCanvas.getThreadName() + ": Realized Drawable: isRealized " + bl + ", " + gLDrawableImpl.toString());
                }
            }
            if (bl && null == this.context) {
                bl = this.createContextImpl(gLDrawableImpl);
            }
            return bl;
        }
        return false;
    }

    private void setAWTGraphicsConfiguration(AWTGraphicsConfiguration aWTGraphicsConfiguration) {
        this.awtConfig = aWTGraphicsConfiguration;
        if (null != this.jawtWindow) {
            this.jawtWindow.setAWTGraphicsConfiguration(aWTGraphicsConfiguration);
        }
    }

    @Override
    public void removeNotify() {
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": Info: removeNotify - start");
        }
        this.awtWindowClosingProtocol.removeClosingListener();
        if (Beans.isDesignTime()) {
            super.removeNotify();
        } else {
            try {
                this.destroyImpl(true);
            }
            finally {
                super.removeNotify();
            }
        }
        if (DEBUG) {
            System.err.println(GLCanvas.getThreadName() + ": Info: removeNotify - end, peer: " + this.getPeer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.reshape(n, n2, n3, n4);
            this.reshapeImpl(n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reshapeImpl(int n, int n2) {
        Object object;
        int n3 = SurfaceScaleUtils.scale(n, this.hasPixelScale[0]);
        int n4 = SurfaceScaleUtils.scale(n2, this.hasPixelScale[1]);
        if (DEBUG) {
            object = this.getNativeSurface();
            long l = null != object ? object.getSurfaceHandle() : 0L;
            System.err.println(GLCanvas.getThreadName() + ": GLCanvas.reshape.0 " + this.getName() + " resize" + (this.printActive ? "WithinPrint" : "") + " [ this " + this.getWidth() + "x" + this.getHeight() + ", pixelScale " + this.getPixelScaleStr() + "] -> " + (this.printActive ? "[skipped] " : "") + n + "x" + n2 + " * " + this.getPixelScaleStr() + " -> " + n3 + "x" + n4 + " - surfaceHandle 0x" + Long.toHexString(l));
        }
        if (this.validateGLDrawable() && !this.printActive) {
            object = this.drawable;
            if (!((GLDrawableImpl)object).getChosenGLCapabilities().isOnscreen()) {
                RecursiveLock recursiveLock = this.lock;
                recursiveLock.lock();
                try {
                    GLDrawableImpl gLDrawableImpl = GLDrawableHelper.resizeOffscreenDrawable((GLDrawableImpl)object, this.context, n3, n4);
                    if (object != gLDrawableImpl) {
                        this.drawable = gLDrawableImpl;
                    }
                }
                finally {
                    recursiveLock.unlock();
                }
            }
            this.sendReshape = true;
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void setupPrint(double d, double d2, int n, int n2, int n3) {
        this.printActive = true;
        int n4 = this.isOpaque() ? 3 : 4;
        TileRenderer tileRenderer = new TileRenderer();
        this.printAWTTiles = new AWTTilePainter(tileRenderer, n4, d, d2, n, n2, n3, DEBUG);
        AWTEDTExecutor.singleton.invoke(this.getTreeLock(), true, true, this.setupPrintOnEDT);
    }

    @Override
    public void releasePrint() {
        if (!this.printActive || null == this.printGLAD) {
            throw new IllegalStateException("setupPrint() not called");
        }
        this.sendReshape = false;
        AWTEDTExecutor.singleton.invoke(this.getTreeLock(), true, true, this.releasePrintOnEDT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Graphics graphics) {
        block12: {
            if (!this.printActive || null == this.printGLAD) {
                throw new IllegalStateException("setupPrint() not called");
            }
            if (DEBUG && !EventQueue.isDispatchThread()) {
                System.err.println(GLCanvas.getThreadName() + ": Warning: GLCanvas print - not called from AWT-EDT");
            }
            this.sendReshape = false;
            Graphics2D graphics2D = (Graphics2D)graphics;
            try {
                this.printAWTTiles.setupGraphics2DAndClipBounds(graphics2D, this.getWidth(), this.getHeight());
                TileRenderer tileRenderer = this.printAWTTiles.renderer;
                if (DEBUG) {
                    System.err.println("AWT print.0: " + tileRenderer);
                }
                if (tileRenderer.eot()) break block12;
                try {
                    do {
                        if (this.printGLAD != this) {
                            tileRenderer.display();
                            continue;
                        }
                        Threading.invoke(true, this.displayOnEDTAction, this.getTreeLock());
                    } while (!tileRenderer.eot());
                    if (DEBUG) {
                        System.err.println("AWT print.1: " + this.printAWTTiles);
                    }
                }
                finally {
                    tileRenderer.reset();
                    this.printAWTTiles.resetGraphics2D();
                }
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.err.println("Caught: Inversion failed of: " + graphics2D.getTransform());
                noninvertibleTransformException.printStackTrace();
            }
        }
        if (DEBUG) {
            System.err.println("AWT print.X: " + this.printAWTTiles);
        }
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.helper.addGLEventListener(gLEventListener);
    }

    @Override
    public void addGLEventListener(int n, GLEventListener gLEventListener) throws IndexOutOfBoundsException {
        this.helper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public int getGLEventListenerCount() {
        return this.helper.getGLEventListenerCount();
    }

    @Override
    public GLEventListener getGLEventListener(int n) throws IndexOutOfBoundsException {
        return this.helper.getGLEventListener(n);
    }

    @Override
    public boolean areAllGLEventListenerInitialized() {
        return this.helper.areAllGLEventListenerInitialized();
    }

    @Override
    public boolean getGLEventListenerInitState(GLEventListener gLEventListener) {
        return this.helper.getGLEventListenerInitState(gLEventListener);
    }

    @Override
    public void setGLEventListenerInitState(GLEventListener gLEventListener, boolean bl) {
        this.helper.setGLEventListenerInitState(gLEventListener, bl);
    }

    @Override
    public GLEventListener disposeGLEventListener(GLEventListener gLEventListener, boolean bl) {
        DisposeGLEventListenerAction disposeGLEventListenerAction = new DisposeGLEventListenerAction(gLEventListener, bl);
        Threading.invoke(true, disposeGLEventListenerAction, this.getTreeLock());
        return disposeGLEventListenerAction.listener;
    }

    @Override
    public GLEventListener removeGLEventListener(GLEventListener gLEventListener) {
        return this.helper.removeGLEventListener(gLEventListener);
    }

    @Override
    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        this.helper.setAnimator(gLAnimatorControl);
    }

    @Override
    public GLAnimatorControl getAnimator() {
        return this.helper.getAnimator();
    }

    @Override
    public final Thread setExclusiveContextThread(Thread thread) throws GLException {
        return this.helper.setExclusiveContextThread(thread, this.context);
    }

    @Override
    public final Thread getExclusiveContextThread() {
        return this.helper.getExclusiveContextThread();
    }

    @Override
    public boolean invoke(boolean bl, GLRunnable gLRunnable) throws IllegalStateException {
        return this.helper.invoke((GLAutoDrawable)this, bl, gLRunnable);
    }

    @Override
    public boolean invoke(boolean bl, List<GLRunnable> list) throws IllegalStateException {
        return this.helper.invoke((GLAutoDrawable)this, bl, list);
    }

    @Override
    public void flushGLRunnables() {
        this.helper.flushGLRunnables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GLContext setContext(GLContext gLContext, boolean bl) {
        RecursiveLock recursiveLock = this.lock;
        recursiveLock.lock();
        try {
            GLContextImpl gLContextImpl = this.context;
            GLDrawableHelper.switchContext(this.drawable, gLContextImpl, bl, gLContext, this.additionalCtxCreationFlags);
            this.context = (GLContextImpl)gLContext;
            GLContextImpl gLContextImpl2 = gLContextImpl;
            return gLContextImpl2;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final GLDrawable getDelegatedDrawable() {
        return this.drawable;
    }

    @Override
    public GLContext getContext() {
        return this.context;
    }

    @Override
    public GL getGL() {
        if (Beans.isDesignTime()) {
            return null;
        }
        GLContextImpl gLContextImpl = this.context;
        return gLContextImpl == null ? null : ((GLContext)gLContextImpl).getGL();
    }

    @Override
    public GL setGL(GL gL) {
        GLContextImpl gLContextImpl = this.context;
        if (gLContextImpl != null) {
            ((GLContext)gLContextImpl).setGL(gL);
            return gL;
        }
        return null;
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
        this.helper.setAutoSwapBufferMode(bl);
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return this.helper.getAutoSwapBufferMode();
    }

    @Override
    public void swapBuffers() {
        Threading.invoke(true, this.swapBuffersOnEDTAction, this.getTreeLock());
    }

    @Override
    public void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
        GLContextImpl gLContextImpl = this.context;
        if (null != gLContextImpl) {
            ((GLContext)gLContextImpl).setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public GLProfile getGLProfile() {
        return this.capsReqUser.getGLProfile();
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        if (Beans.isDesignTime()) {
            return this.capsReqUser;
        }
        if (null == this.awtConfig) {
            throw new GLException("No AWTGraphicsConfiguration: " + this);
        }
        return (GLCapabilitiesImmutable)this.awtConfig.getChosenCapabilities();
    }

    @Override
    public GLCapabilitiesImmutable getRequestedGLCapabilities() {
        if (null == this.awtConfig) {
            return this.capsReqUser;
        }
        return (GLCapabilitiesImmutable)this.awtConfig.getRequestedCapabilities();
    }

    @Override
    public int getSurfaceWidth() {
        return SurfaceScaleUtils.scale(this.getWidth(), this.hasPixelScale[0]);
    }

    @Override
    public int getSurfaceHeight() {
        return SurfaceScaleUtils.scale(this.getHeight(), this.hasPixelScale[1]);
    }

    @Override
    public boolean isGLOriented() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.isGLOriented() : true;
    }

    @Override
    public NativeSurface getNativeSurface() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getNativeSurface() : null;
    }

    @Override
    public long getHandle() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getHandle() : 0L;
    }

    @Override
    public GLDrawableFactory getFactory() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getFactory() : null;
    }

    @Override
    public String toString() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        int n = null != gLDrawableImpl ? gLDrawableImpl.getSurfaceWidth() : -1;
        int n2 = null != gLDrawableImpl ? gLDrawableImpl.getSurfaceHeight() : -1;
        return "AWT-GLCanvas[Realized " + this.isRealized() + ",\n\t" + (null != gLDrawableImpl ? gLDrawableImpl.getClass().getName() : "null-drawable") + ",\n\tFactory   " + this.getFactory() + ",\n\thandle    0x" + Long.toHexString(this.getHandle()) + ",\n\tDrawable size " + n + "x" + n2 + " surface[" + this.getSurfaceWidth() + "x" + this.getSurfaceHeight() + "],\n\tAWT[pos " + this.getX() + "/" + this.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + ",\n\tvisible " + this.isVisible() + ", displayable " + this.isDisplayable() + ", showing " + this.isShowing + ",\n\t" + this.awtConfig + "]]";
    }

    private final String getPixelScaleStr() {
        return "[" + this.hasPixelScale[0] + ", " + this.hasPixelScale[1] + "]";
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = GLCanvas.this.getToolkit().getClass();
                            while (clazz != null && disableBackgroundEraseMethod == null) {
                                try {
                                    disableBackgroundEraseMethod = clazz.getDeclaredMethod("disableBackgroundErase", Canvas.class);
                                    disableBackgroundEraseMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    clazz = clazz.getSuperclass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": GLCanvas: TK disableBackgroundErase method found: " + (null != disableBackgroundEraseMethod));
            }
        }
        if (disableBackgroundEraseMethod != null) {
            Exception exception = null;
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (DEBUG) {
                System.err.println(GLCanvas.getThreadName() + ": GLCanvas: TK disableBackgroundErase error: " + exception);
            }
        }
    }

    private AWTGraphicsConfiguration chooseGraphicsConfiguration(final GLCapabilitiesImmutable gLCapabilitiesImmutable, final GLCapabilitiesImmutable gLCapabilitiesImmutable2, final GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) {
        if (Beans.isDesignTime()) {
            return null;
        }
        if (null == graphicsDevice) {
            throw new GLException("Error: NULL AWT GraphicsDevice");
        }
        final AbstractGraphicsScreen abstractGraphicsScreen = AWTGraphicsScreen.createScreenDevice(graphicsDevice, 0);
        AWTGraphicsConfiguration aWTGraphicsConfiguration = null;
        if (EventQueue.isDispatchThread() || Thread.holdsLock(this.getTreeLock())) {
            aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class, GLCapabilitiesImmutable.class).chooseGraphicsConfiguration(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, 0);
        } else {
            try {
                final ArrayList arrayList = new ArrayList(1);
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class, GLCapabilitiesImmutable.class).chooseGraphicsConfiguration(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen, 0);
                        arrayList.add(aWTGraphicsConfiguration);
                    }
                });
                aWTGraphicsConfiguration = arrayList.size() > 0 ? (AWTGraphicsConfiguration)arrayList.get(0) : null;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new GLException(invocationTargetException.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                throw new GLException(interruptedException);
            }
        }
        if (null == aWTGraphicsConfiguration) {
            throw new GLException("Error: Couldn't fetch AWTGraphicsConfiguration");
        }
        return aWTGraphicsConfiguration;
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println((Object)JoglVersion.getInstance());
        System.err.println(JoglVersion.getDefaultOpenGLInfo(null, null, true).toString());
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDevice()));
        final Frame frame = new Frame("JOGL AWT Test");
        GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        frame.add(gLCanvas);
        frame.setSize(128, 128);
        gLCanvas.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLInfo(gL, null));
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        gLCanvas.display();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private class DisposeGLEventListenerAction
    implements Runnable {
        GLEventListener listener;
        private final boolean remove;

        private DisposeGLEventListenerAction(GLEventListener gLEventListener, boolean bl) {
            this.listener = gLEventListener;
            this.remove = bl;
        }

        @Override
        public void run() {
            RecursiveLock recursiveLock = GLCanvas.this.lock;
            recursiveLock.lock();
            try {
                this.listener = GLCanvas.this.helper.disposeGLEventListener(GLCanvas.this, GLCanvas.this.drawable, GLCanvas.this.context, this.listener, this.remove);
            }
            finally {
                recursiveLock.unlock();
            }
        }
    }
}

