/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Bang;
import controlP5.Button;
import controlP5.CheckBox;
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.Group;
import controlP5.RadioButton;
import controlP5.Textarea;
import controlP5.Textfield;
import controlP5.Textlabel;
import controlP5.Toggle;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Timer;
import java.util.TimerTask;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;

public class WoClockController
extends PApplet {
    PApplet app = this;
    DatagramPacket packet;
    DatagramSocket dsocket;
    String app_title = "Watchout Clock Utility";
    String app_version = "1.0.1";
    Boolean debug_mode = false;
    int copyright_year_end = 2018;
    ControlP5 controls;
    PGraphics controls_image;
    Boolean ui_ready;
    CheckBox checkboxes_display;
    CheckBox checkboxes_active;
    CheckBox checkboxes_options;
    String[] time_increment_labels = new String[]{"H", "M", "S"};
    Boolean isProduction = true;
    String production_ip = "192.168.0.9";
    String display_ip = "192.168.0.10";
    int[] network_ports = new int[]{3040, 3039};
    String target_ip;
    int target_port_number;
    InetAddress host_address;
    Timer clock_timer = new Timer();
    int clock_timer_interval = 1000;
    Boolean first_run;
    Boolean show_network_send_indicator = true;
    PFont clock_font;
    int clock_hours;
    int clock_minutes;
    int clock_seconds;
    int clock_offset_hours;
    int clock_offset_minutes;
    int redraw_interval_duration;
    int millis_since_last_redraw;
    int cx;
    int cy;
    float secondsRadius;
    float minutesRadius;
    float hoursRadius;
    float radians_h;
    float radians_m;
    float radians_s;
    float degrees_h;
    float degrees_m;
    float degrees_s;
    float clockDiameter;
    Boolean broadcasting_status;
    Boolean redraw_active;
    Boolean tween_animation;
    int tween_animation_duration_ms = 1000;
    float[] clock_hands_display = new float[]{1.0f, 1.0f, 1.0f};
    String generic_input_name_stem;
    int network_send_interval_ms = 5000;
    float variable_max = 360.0f;
    int command_syntax = 5;
    int[] command_syntax_versions = new int[]{5, 6};
    String[] broadcast_status_labels = new String[]{"Offline", "Broadcasting"};
    int[] broadcast_status_colours = new int[]{this.color(255, 0, 0, 255), this.color(0, 255, 0, 255)};

    public void setup() {
        this.stroke(255);
        this.frameRate(60.0f);
        this.set_network_port(0);
        this.generic_input_name_stem = "clock_";
        this.controls = new ControlP5(this.app);
        this.clock_font = this.createFont("Arial", 32.0f);
        this.set_target_ip_address("127.0.0.1");
        this.ui_ready = false;
        this.setup_ui_elements();
        this.create_socket();
        this.connect_to_client();
        int radius = 200;
        this.secondsRadius = (float)radius * 0.8f;
        this.minutesRadius = (float)radius * 0.6f;
        this.hoursRadius = (float)radius * 0.5f;
        this.clockDiameter = (float)radius * 1.8f;
        this.millis_since_last_redraw = 0;
        this.redraw_interval_duration = 100;
        this.cx = this.width / 2;
        this.cy = WoClockController.round((float)radius) + 20;
        this.redraw_active = true;
        this.first_run = true;
        this.tween_animation = true;
        this.set_broadcast_status(false);
        this.init_clock_timer();
        this.set_network_send_interval();
        this.update_time_values();
        this.calculate_time_angles();
        this.check_network_send_interval();
    }

    public void create_socket() {
        try {
            this.dsocket = new DatagramSocket();
        }
        catch (IOException e) {
            System.err.println("IOException " + e);
            this.set_broadcast_status(false);
        }
    }

    public void connect_to_client() {
        try {
            this.host_address = InetAddress.getByName(this.target_ip);
        }
        catch (IOException e) {
            System.err.println("IOException " + e);
            this.set_broadcast_status(false);
        }
    }

    public void build_network_commands() {
        if (this.broadcasting_status.booleanValue()) {
            String network_command = "";
            String generic_input_name = "";
            float[] hand_angles_hms = new float[]{0.0f, 0.0f, 0.0f};
            hand_angles_hms[0] = this.degrees_h / this.variable_max;
            hand_angles_hms[1] = this.degrees_m / this.variable_max;
            hand_angles_hms[2] = this.degrees_s / this.variable_max;
            int i = 0;
            while (i < 3) {
                if (this.command_syntax == 5 && this.checkboxes_active.getArrayValue()[i] == 1.0f) {
                    generic_input_name = String.valueOf(this.generic_input_name_stem) + this.time_increment_labels[i].toLowerCase();
                    network_command = "setInput " + generic_input_name + " " + WoClockController.nf((float)hand_angles_hms[i], (int)2, (int)3) + " " + this.get_tween_anim_speed(hand_angles_hms[i]) + "\n";
                    this.packet = this.build_packet(network_command);
                    this.send_packet(this.packet);
                    this.debug_output(network_command);
                }
                if (this.command_syntax == 6 && this.checkboxes_active.getArrayValue()[i] == 1.0f) {
                    generic_input_name = String.valueOf(this.generic_input_name_stem) + this.time_increment_labels[i].toLowerCase();
                    network_command = String.valueOf(network_command) + generic_input_name + " " + WoClockController.nf((float)hand_angles_hms[i], (int)2, (int)3) + " ";
                }
                ++i;
            }
            if (this.command_syntax == 6) {
                int tween_anim_speed = WoClockController.min((int)this.get_tween_anim_speed(hand_angles_hms[0]), (int)this.get_tween_anim_speed(hand_angles_hms[1]), (int)this.get_tween_anim_speed(hand_angles_hms[2]));
                String multiple_network_command = "setInputs " + tween_anim_speed + " " + network_command + "\n";
                this.packet = this.build_packet(multiple_network_command);
                this.send_packet(this.packet);
                this.debug_output(multiple_network_command);
            }
        }
    }

    public void set_clock_display_options() {
        WoClockController.arrayCopy((Object)this.checkboxes_display.getArrayValue(), (Object)this.clock_hands_display);
    }

    public void set_generic_input_name_stem(String new_input_name) {
        if (!(new_input_name = this.sanitize_network_string(new_input_name)).equals("")) {
            this.generic_input_name_stem = new_input_name;
        }
        this.debug_output("set_generic_input_name_stem: " + this.generic_input_name_stem);
    }

    public void set_network_port(int port_index) {
        this.target_port_number = port_index >= 0 && port_index <= 1 ? this.network_ports[port_index] : this.network_ports[0];
        this.debug_output("set_network_port: " + this.target_port_number);
    }

    public void set_command_syntax(float[] radio_array) {
        int i = 0;
        while (i < radio_array.length) {
            if (radio_array[i] == 1.0f) {
                this.command_syntax = this.command_syntax_versions[i];
            }
            ++i;
        }
        this.debug_output("set_command_syntax: " + this.command_syntax);
    }

    public DatagramPacket build_packet(String message) {
        byte[] message_bytes = message.getBytes();
        this.packet = new DatagramPacket(message_bytes, message_bytes.length, this.host_address, this.target_port_number);
        return this.packet;
    }

    public void send_packet(DatagramPacket send_packet) {
        if (this.broadcasting_status.booleanValue()) {
            try {
                this.dsocket.send(send_packet);
            }
            catch (IOException e) {
                System.err.println("IOException " + e);
                this.set_broadcast_status(false);
            }
        }
    }

    public void set_broadcast_status(Boolean new_status) {
        this.broadcasting_status = new_status;
        this.debug_output("set_broadcast_status: " + new_status + " " + this.get_boolean_as_int(this.broadcasting_status));
        if (this.ui_ready.booleanValue()) {
            ((Button)((Button)((Button)this.controls.get(Button.class, "button_broadcast_status")).setBroadcast(false)).setLabel(this.broadcast_status_labels[this.get_boolean_as_int(this.broadcasting_status)])).setBroadcast(true);
        }
        if (this.broadcasting_status.booleanValue()) {
            this.set_network_send_interval();
            this.update_time_values();
            this.calculate_time_angles();
            this.check_network_send_interval();
        }
    }

    public void toggle_broadcast_status() {
        if (this.broadcasting_status.booleanValue()) {
            this.set_broadcast_status(false);
        } else {
            this.set_broadcast_status(true);
        }
    }

    public void calculate_time_angles() {
        this.update_time_values();
        this.redraw_active = false;
        int clock_hours_twelve = this.clock_hours;
        if (this.clock_hours > 12) {
            clock_hours_twelve = this.clock_hours - 12;
        }
        this.radians_s = WoClockController.map((float)this.clock_seconds, (float)0.0f, (float)60.0f, (float)0.0f, (float)((float)Math.PI * 2)) - 1.5707964f;
        this.radians_m = WoClockController.map((float)((float)this.clock_minutes + WoClockController.norm((float)this.clock_seconds, (float)0.0f, (float)60.0f)), (float)0.0f, (float)60.0f, (float)0.0f, (float)((float)Math.PI * 2)) - 1.5707964f;
        this.radians_h = WoClockController.map((float)((float)clock_hours_twelve + WoClockController.norm((float)this.clock_minutes, (float)0.0f, (float)60.0f)), (float)0.0f, (float)12.0f, (float)0.0f, (float)((float)Math.PI * 2)) - 1.5707964f;
        this.degrees_s = WoClockController.map((float)this.clock_seconds, (float)0.0f, (float)60.0f, (float)0.0f, (float)360.0f);
        this.degrees_m = WoClockController.map((float)((float)this.clock_minutes + WoClockController.norm((float)this.clock_seconds, (float)0.0f, (float)60.0f)), (float)0.0f, (float)60.0f, (float)0.0f, (float)360.0f);
        this.degrees_h = WoClockController.map((float)((float)clock_hours_twelve + WoClockController.norm((float)this.clock_minutes, (float)0.0f, (float)60.0f)), (float)0.0f, (float)12.0f, (float)0.0f, (float)360.0f);
        this.redraw_active = true;
    }

    public void draw() {
        if (this.redraw_active.booleanValue()) {
            this.draw_clock();
        }
        if (this.show_network_send_indicator.booleanValue()) {
            this.draw_network_send_indicator();
        }
    }

    public int get_tween_anim_speed(float check_angle) {
        int anim_speed = 0;
        if ((this.first_run.booleanValue() || this.tween_animation.booleanValue()) && check_angle > 0.0f && check_angle < 1.0f) {
            anim_speed = WoClockController.min((int)this.tween_animation_duration_ms, (int)this.network_send_interval_ms) - 500;
        }
        return anim_speed;
    }

    public void set_network_send_interval() {
        if (this.ui_ready.booleanValue()) {
            if (this.checkboxes_active.getArrayValue()[0] == 1.0f) {
                this.network_send_interval_ms = 10000;
            }
            if (this.checkboxes_active.getArrayValue()[1] == 1.0f) {
                this.network_send_interval_ms = 5000;
            }
            if (this.checkboxes_active.getArrayValue()[2] == 1.0f) {
                this.network_send_interval_ms = 1000;
            }
        } else {
            this.network_send_interval_ms = 1000;
        }
        this.debug_output("network_send_interval_ms set to: " + this.network_send_interval_ms);
    }

    public void set_options() {
        this.tween_animation = this.get_boolean_from_float(this.checkboxes_options.getArrayValue()[0]);
        this.debug_output("set_options tween_animation: " + this.tween_animation);
    }

    public void set_time_offset(String ui_control_name, int ui_control_value) {
        this.debug_output("set_time_offset " + ui_control_name + ", " + ui_control_value);
        if (ui_control_name.equals("offset_h")) {
            this.clock_offset_hours = ui_control_value;
        }
        if (ui_control_name.equals("offset_m")) {
            this.clock_offset_minutes = ui_control_value;
        }
        this.update_time_values();
        this.debug_output("set_time_offset set h:" + this.clock_offset_hours + ", m:" + this.clock_offset_minutes);
    }

    public void reset_time_offsets() {
        this.clock_offset_hours = 0;
        this.clock_offset_minutes = 0;
        ((Textfield)this.controls.get(Textfield.class, "offset_h")).setText(WoClockController.nf((float)this.clock_offset_hours, (int)1, (int)0));
        ((Textfield)this.controls.get(Textfield.class, "offset_m")).setText(WoClockController.nf((float)this.clock_offset_minutes, (int)1, (int)0));
        this.update_time_values();
        this.debug_output("reset_time_offsets.");
    }

    public Boolean check_network_send_interval() {
        int network_send_interval_seconds = WoClockController.round((float)(this.network_send_interval_ms / 1000));
        if (this.clock_seconds % network_send_interval_seconds == 0 || this.first_run.booleanValue()) {
            this.build_network_commands();
            this.show_network_send_indicator = true;
            this.first_run = false;
            return true;
        }
        return false;
    }

    public void init_clock_timer() {
        int offset_from_clock = 1000 - WoClockController.round((float)System.currentTimeMillis()) % 1000;
        this.debug_output("Init clock: " + this.millis() + " " + offset_from_clock);
        int clock_timer_delay = WoClockController.max((int)0, (int)(1000 - offset_from_clock));
        this.clock_timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                WoClockController.this.calculate_time_angles();
                WoClockController.this.check_network_send_interval();
            }
        }, clock_timer_delay, (long)this.clock_timer_interval);
    }

    public int constrain_clock_hours(int check_hours) {
        if (check_hours > 24) {
            return check_hours - 24;
        }
        if (check_hours < 0) {
            return check_hours + 24;
        }
        return check_hours;
    }

    public int constrain_clock_minutes(int check_minutes) {
        if (check_minutes > 60) {
            ++this.clock_hours;
            this.constrain_clock_hours(this.clock_hours);
            return check_minutes - 60;
        }
        if (check_minutes < 0) {
            --this.clock_hours;
            this.constrain_clock_hours(this.clock_hours);
            return check_minutes + 60;
        }
        return check_minutes;
    }

    public void update_time_values() {
        this.clock_hours = this.constrain_clock_hours(WoClockController.hour() + this.clock_offset_hours);
        this.clock_minutes = this.constrain_clock_minutes(WoClockController.minute() + this.clock_offset_minutes);
        this.clock_seconds = WoClockController.second();
    }

    public void controlEvent(ControlEvent theEvent) {
        if (this.ui_ready.booleanValue()) {
            if (theEvent.isController()) {
                Controller ui_control_element = theEvent.controller();
                String ui_control_element_name = ui_control_element.getName();
                this.debug_output("UI control event from: " + ui_control_element_name + " with value : " + ui_control_element.getValue());
                if (ui_control_element_name == "text_target_ip") {
                    this.set_target_ip_address(ui_control_element.getStringValue());
                }
                if (ui_control_element_name == "text_input_name_stem") {
                    this.set_generic_input_name_stem(ui_control_element.getStringValue());
                }
                if (ui_control_element_name == "offset_h" || ui_control_element_name == "offset_m") {
                    this.set_time_offset(ui_control_element_name, Integer.valueOf(ui_control_element.getStringValue()));
                }
                if (ui_control_element_name == "offset_reset") {
                    this.reset_time_offsets();
                }
                if (ui_control_element_name == "button_broadcast_status") {
                    this.toggle_broadcast_status();
                }
            } else if (theEvent.isTab()) {
                this.debug_output("got an event from tab : " + theEvent.getTab().getName() + " with id " + theEvent.getTab().getId());
            } else {
                ControlGroup ui_control_group = theEvent.group();
                this.debug_output("UI Control event from group: " + ui_control_group.getName() + ", ID " + theEvent.getGroup().getName());
                if (theEvent.isFrom((ControllerInterface)this.checkboxes_display)) {
                    this.set_clock_display_options();
                }
                if (theEvent.isFrom((ControllerInterface)this.checkboxes_active)) {
                    this.set_network_send_interval();
                }
                if (theEvent.isFrom((ControllerInterface)this.checkboxes_options)) {
                    this.set_options();
                }
                if (ui_control_group.getName().equals("radio_port")) {
                    if (theEvent.getGroup().getArrayValue()[0] == 1.0f) {
                        this.set_network_port(0);
                    } else {
                        this.set_network_port(1);
                    }
                }
                if (ui_control_group.getName().equals("radio_syntax")) {
                    this.set_command_syntax(theEvent.getGroup().getArrayValue());
                }
            }
        }
    }

    public void set_target_ip_address(String new_target_ip_address) {
        if (this.is_ip4_address(new_target_ip_address)) {
            this.target_ip = new_target_ip_address;
            this.connect_to_client();
            this.debug_output("set_target_ip_address: " + this.target_ip);
        } else {
            this.debug_output("Error: Invalid IP address for set_target_ip_address: " + new_target_ip_address);
        }
    }

    public void draw_clock() {
        this.millis_since_last_redraw = this.millis();
        this.draw_clock_bg();
        this.draw_clock_analogue();
        this.draw_clock_digital();
        this.draw_broadcast_status();
    }

    public void draw_broadcast_status() {
        float[] draw_origin = new float[]{this.width / 4, this.height - 50};
        int text_size = 24;
        this.fill(this.broadcast_status_colours[this.get_boolean_as_int(this.broadcasting_status)]);
        this.rectMode(3);
        this.rect(draw_origin[0], draw_origin[1], text_size * 2, text_size * 2, 10.0f);
    }

    public void draw_clock_bg() {
        this.background(0);
        this.fill(80);
        this.noStroke();
        this.ellipse(this.cx, this.cy, this.clockDiameter, this.clockDiameter);
        this.fill(128);
        this.textSize(16.0f);
        this.textAlign(3);
        this.text("matkeane.com", this.cx, (float)this.cy + this.clockDiameter * 0.25f);
    }

    public void draw_clock_analogue() {
        this.stroke(255);
        if (this.clock_hands_display[2] == 1.0f) {
            this.strokeWeight(1.0f);
            this.line(this.cx, this.cy, (float)this.cx + WoClockController.cos((float)this.radians_s) * this.secondsRadius, (float)this.cy + WoClockController.sin((float)this.radians_s) * this.secondsRadius);
        }
        if (this.clock_hands_display[1] == 1.0f) {
            this.strokeWeight(2.0f);
            this.line(this.cx, this.cy, (float)this.cx + WoClockController.cos((float)this.radians_m) * this.minutesRadius, (float)this.cy + WoClockController.sin((float)this.radians_m) * this.minutesRadius);
        }
        if (this.clock_hands_display[0] == 1.0f) {
            this.strokeWeight(4.0f);
            this.line(this.cx, this.cy, (float)this.cx + WoClockController.cos((float)this.radians_h) * this.hoursRadius, (float)this.cy + WoClockController.sin((float)this.radians_h) * this.hoursRadius);
        }
        this.strokeWeight(2.0f);
        this.beginShape(3);
        int a = 0;
        while (a < 360) {
            float angle = WoClockController.radians((float)a);
            float x = (float)this.cx + WoClockController.cos((float)angle) * this.secondsRadius;
            float y = (float)this.cy + WoClockController.sin((float)angle) * this.secondsRadius;
            this.vertex(x, y);
            a += 6;
        }
        this.endShape();
    }

    public void draw_clock_digital() {
        String clock_text = String.valueOf(WoClockController.nf((float)this.clock_hours, (int)2, (int)0)) + ":" + WoClockController.nf((float)this.clock_minutes, (int)2, (int)0) + ":" + WoClockController.nf((float)this.clock_seconds, (int)2, (int)0);
        this.fill(255);
        this.textFont(this.clock_font);
        this.textSize(36.0f);
        this.textAlign(3);
        this.text(clock_text, this.width / 2, this.height - 125);
    }

    public void draw_network_send_indicator() {
        if (this.broadcasting_status.booleanValue()) {
            this.fill(this.broadcast_status_colours[1]);
            this.ellipse(this.width / 2 + 125, this.height - 50, 30.0f, 30.0f);
        }
        this.show_network_send_indicator = false;
    }

    public void setup_ui_elements() {
        this.controls.setAutoDraw(true);
        ControlFont ui_font = new ControlFont(this.clock_font, 12);
        int button_text_size = 24;
        int[] button_size = new int[]{WoClockController.round((float)(button_text_size * 7)), WoClockController.round((float)(button_text_size * 2))};
        float[] button_origin = new float[]{this.width / 2 - button_size[0] / 2, this.height - 50 - button_size[1] / 2};
        ((Button)((Button)((Button)((Button)((Button)this.controls.addButton("button_broadcast_status").setBroadcast(false)).setLabel(this.broadcast_status_labels[0].toUpperCase())).setSize(button_size[0], button_size[1])).setPosition(button_origin[0], button_origin[1])).setFont(ui_font)).setBroadcast(true);
        String[][] group_names = new String[][]{{"group_network", "Network Settings"}, {"group_time", "Time Settings"}, {"group_about", "About"}};
        int group_count = group_names.length;
        int group_width = WoClockController.round((float)(this.width / group_count));
        int[] group_positions = new int[group_count];
        int group_barheight = 16;
        int group_origin_y = group_barheight + 2;
        Group[] control_groups = new Group[group_count];
        int i = 0;
        while (i < group_count) {
            group_positions[i] = group_width * i;
            control_groups[i] = (Group)((Group)((Group)((Group)((Group)((Group)((Group)((Group)this.controls.addGroup(group_names[i][0]).setPosition((float)group_positions[i], (float)group_origin_y)).setWidth(group_width - 1)).setBackgroundColor(this.color(35, 30, 30, 240))).setBackgroundHeight(200)).setBarHeight(group_barheight)).setLabel(group_names[i][1])).setFont(ui_font)).close();
            ++i;
        }
        int current_group = 0;
        ((Textfield)((Textfield)((Textfield)((Textfield)this.controls.addTextfield("text_target_ip").setBroadcast(false)).setPosition(10.0f, (float)group_origin_y)).setSize(160, 20).setValue(this.target_ip).setLabel("I.P. Address:")).setAutoClear(false).setBroadcast(true)).setGroup((ControllerGroup)control_groups[current_group]);
        ((RadioButton)((RadioButton)((RadioButton)((RadioButton)this.controls.addRadioButton("radio_port").setPosition(10.0f, (float)(group_origin_y + 50))).setSize(20, 20).setColorForeground(this.color(120))).setColorActive(this.color(255))).setColorLabel(this.color(255))).setItemsPerRow(2).setSpacingColumn(60).addItem("Production", 0.0f).addItem("Display", 1.0f).activate(0).setGroup((ControllerGroup)control_groups[current_group]);
        ((Textfield)((Textfield)this.controls.addTextfield("text_input_name_stem").setPosition(10.0f, (float)(group_origin_y + 100))).setSize(160, 20).setValue(this.generic_input_name_stem).setLabel("Generic Input name base:")).setAutoClear(false).setGroup((ControllerGroup)control_groups[current_group]);
        ((RadioButton)((RadioButton)((RadioButton)((RadioButton)this.controls.addRadioButton("radio_syntax").setPosition(10.0f, (float)(group_origin_y + 140))).setSize(20, 20).setColorForeground(this.color(120))).setColorActive(this.color(255))).setColorLabel(this.color(255))).setItemsPerRow(2).setSpacingColumn(60).addItem("Watchout 5", 0.0f).addItem("Watchout 6+", 1.0f).activate(0).setGroup((ControllerGroup)control_groups[current_group]);
        current_group = 1;
        String[] time_control_labels = new String[]{"Show", "Send", "Offset"};
        String control_name = "";
        String control_label = "";
        int control_size = 20;
        int[] label_align_x = new int[]{10, 80, 120, 160};
        int[] label_align_y = new int[]{10, 40, 80, 120, 160};
        int checkbox_spacing = 20;
        this.checkboxes_display = (CheckBox)((CheckBox)((CheckBox)((CheckBox)((CheckBox)this.controls.addCheckBox("checkbox_display").setSize(control_size, control_size).setItemsPerRow(3).setPosition((float)label_align_x[1], (float)label_align_y[1])).setSpacingColumn(checkbox_spacing).setColorForeground(this.color(120))).setColorActive(this.color(255))).setColorLabel(this.color(255))).setGroup((ControllerGroup)control_groups[current_group]);
        this.checkboxes_active = (CheckBox)((CheckBox)((CheckBox)((CheckBox)((CheckBox)this.controls.addCheckBox("checkbox_active").setSize(control_size, control_size).setItemsPerRow(3).setPosition((float)label_align_x[1], (float)label_align_y[2])).setSpacingColumn(checkbox_spacing).setColorForeground(this.color(120))).setColorActive(this.color(255))).setColorLabel(this.color(255))).setGroup((ControllerGroup)control_groups[current_group]);
        int i2 = 0;
        while (i2 < 3) {
            control_name = "label_" + this.time_increment_labels[i2].toLowerCase();
            control_label = this.time_increment_labels[i2];
            this.controls.addTextlabel(control_name, control_label, label_align_x[i2 + 1], label_align_y[0]).setGroup((ControllerGroup)control_groups[current_group]);
            control_name = "label_" + time_control_labels[i2].toLowerCase();
            control_label = time_control_labels[i2];
            this.controls.addTextlabel(control_name, control_label, label_align_x[0], label_align_y[i2 + 1]).setGroup((ControllerGroup)control_groups[current_group]);
            control_name = this.time_increment_labels[i2].toLowerCase();
            this.checkboxes_display.addItem("check_display_" + control_name, (float)i2);
            this.checkboxes_active.addItem("check_active_" + control_name, (float)i2);
            ((Toggle)((Toggle)this.checkboxes_display.getItem(i2).setFont(ui_font)).setCaptionLabel("")).setValue(1.0f);
            ((Toggle)((Toggle)this.checkboxes_active.getItem(i2).setFont(ui_font)).setCaptionLabel("")).setValue(1.0f);
            ++i2;
        }
        this.checkboxes_options = (CheckBox)((CheckBox)((CheckBox)((CheckBox)((CheckBox)this.controls.addCheckBox("checkbox_options").setSize(control_size, control_size).setItemsPerRow(2).setPosition((float)label_align_x[0], (float)label_align_y[4])).setSpacingColumn(checkbox_spacing).setColorForeground(this.color(120))).setColorActive(this.color(255))).setColorLabel(this.color(255))).setGroup((ControllerGroup)control_groups[current_group]);
        this.checkboxes_options.addItem("check_option_tween", 0.0f);
        ((Toggle)this.checkboxes_options.getItem(0).setCaptionLabel("Tween anim.")).setValue(1.0f);
        ((Textfield)((Textfield)this.controls.addTextfield("offset_h").setPosition((float)label_align_x[1], (float)label_align_y[3])).setSize(control_size, control_size).setValue("0").setAutoClear(false).setLabel("")).setGroup((ControllerGroup)control_groups[current_group]);
        ((Textfield)((Textfield)this.controls.addTextfield("offset_m").setPosition((float)label_align_x[2], (float)label_align_y[3])).setSize(control_size, control_size).setValue("0").setAutoClear(false).setLabel("")).setGroup((ControllerGroup)control_groups[current_group]);
        ((Bang)((Bang)((Bang)this.controls.addBang("offset_reset").setPosition((float)label_align_x[3], (float)label_align_y[3])).setSize(control_size, control_size)).setTriggerEvent(2).setLabel("Reset")).setGroup((ControllerGroup)control_groups[current_group]);
        current_group = 2;
        String about_blurb = "Clock Utility for Watchout 5, 6\n\n";
        about_blurb = String.valueOf(about_blurb) + "copyright 2017-" + this.copyright_year_end + "  Matthew Keane \n\n";
        ((Textlabel)this.controls.addTextlabel("label_about", about_blurb, 0, 0).setPosition((float)label_align_x[0], (float)label_align_y[0])).setGroup((ControllerGroup)control_groups[current_group]);
        String licence_text = "Copyright (c) 2017-" + this.copyright_year_end + ", Matthew Keane\n";
        licence_text = String.valueOf(licence_text) + "\n";
        licence_text = String.valueOf(licence_text) + "Permission to use, copy, modify, and/or distribute this software for any purpose ";
        licence_text = String.valueOf(licence_text) + "with or without fee is hereby granted, provided that the above copyright notice ";
        licence_text = String.valueOf(licence_text) + "and this permission notice appear in all copies.\n";
        licence_text = String.valueOf(licence_text) + "\n";
        licence_text = String.valueOf(licence_text) + "THE SOFTWARE IS PROVIDED \"AS IS\" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH ";
        licence_text = String.valueOf(licence_text) + "REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND ";
        licence_text = String.valueOf(licence_text) + "FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, ";
        licence_text = String.valueOf(licence_text) + "INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS ";
        licence_text = String.valueOf(licence_text) + "OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER ";
        licence_text = String.valueOf(licence_text) + "TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF ";
        licence_text = String.valueOf(licence_text) + "THIS SOFTWARE.";
        ((Textarea)this.controls.addTextarea("licence_textarea").setText(licence_text).setPosition((float)label_align_x[0], (float)label_align_y[2])).setWidth(group_width - 20).setGroup((ControllerGroup)control_groups[current_group]);
        this.ui_ready = true;
        this.debug_output("UI elements setup: " + this.ui_ready);
    }

    public void debug_output(String debug_string) {
        if (this.debug_mode.booleanValue()) {
            WoClockController.println((String)debug_string);
        }
    }

    public int get_boolean_as_int(Boolean boolean_value) {
        return boolean_value != false ? 1 : 0;
    }

    public Boolean get_boolean_from_float(float boolean_float) {
        if (boolean_float != 0.0f) {
            return true;
        }
        return false;
    }

    public boolean is_ip4_address(String check_ip) {
        String match_pattern = "(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)";
        String[] match_ip = WoClockController.match((String)check_ip, (String)match_pattern);
        return match_ip != null;
    }

    public String sanitize_network_string(String name) {
        String machine_name = WoClockController.trim((String)name.replaceAll("\\s", "_"));
        machine_name = machine_name.toLowerCase();
        return machine_name;
    }

    public void settings() {
        this.size(600, 600);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"WoClockController"};
        if (passedArgs != null) {
            PApplet.main((String[])WoClockController.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

