/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CDrawable;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import processing.core.PGraphics;

public class ButtonBar
extends Controller<ButtonBar> {
    public static int autoWidth = 69;
    public static int autoHeight = 19;
    private List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();

    public ButtonBar(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 0.0f, autoWidth, autoHeight);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected ButtonBar(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, float f, float f2, int n, int n2) {
        super(controlP5, controllerGroup, string, f, f2, n, n2);
    }

    @Override
    @ControlP5.Invisible
    public ButtonBar updateDisplayMode(int n) {
        return this.updateViewMode(n);
    }

    public void changeItem(String string, String string2, Object object) {
        Map map = this.modifiableItem(string);
        if (!map.equals(Collections.EMPTY_MAP)) {
            map.put(string2, object);
        }
    }

    private Map modifiableItem(String string) {
        if (string != null) {
            for (Map<String, Object> map : this.items) {
                if (!string.equals(map.get("name"))) continue;
                return map;
            }
        }
        return Collections.EMPTY_MAP;
    }

    public Map getItem(String string) {
        return Collections.unmodifiableMap(this.modifiableItem(string));
    }

    @ControlP5.Invisible
    public ButtonBar updateViewMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new ButtonBarView();
                break;
            }
            case 1: {
                break;
            }
        }
        return this;
    }

    @Override
    public void onClick() {
        int n = this.hover();
        if (n > -1) {
            for (Map<String, Object> map : this.items) {
                map.put("selected", false);
            }
            this.items.get(n).put("selected", true);
            this.setValue(this.hover());
        }
    }

    public int hover() {
        int n = this.getWidth() / (this.items.isEmpty() ? 1 : this.items.size());
        int n2 = this.getHeight();
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.getPointer().x() < i * n || this.getPointer().x() >= (i + 1) * n) continue;
            return i;
        }
        return -1;
    }

    private Map<String, Object> getDefaultItemMap(String string, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", string);
        hashMap.put("text", string);
        hashMap.put("value", object);
        hashMap.put("color", this.getColor());
        hashMap.put("view", new CDrawable(){

            @Override
            public void draw(PGraphics pGraphics) {
            }
        });
        hashMap.put("selected", false);
        return hashMap;
    }

    public ButtonBar addItem(String string, Object object) {
        Map<String, Object> map = this.getDefaultItemMap(string, object);
        this.items.add(map);
        return this;
    }

    public ButtonBar addItems(String[] stringArray) {
        this.addItems(Arrays.asList(stringArray));
        return this;
    }

    public ButtonBar addItems(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addItem(list.get(i).toString(), i);
        }
        return this;
    }

    public ButtonBar addItems(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.addItem(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ButtonBar setItems(String[] stringArray) {
        this.setItems(Arrays.asList(stringArray));
        return this;
    }

    public ButtonBar setItems(List<String> list) {
        this.items.clear();
        return this.addItems(list);
    }

    public ButtonBar setItems(Map<String, Object> map) {
        this.items.clear();
        return this.addItems(map);
    }

    public ButtonBar removeItems(List<String> list) {
        for (String string : list) {
            this.removeItem(string);
        }
        return this;
    }

    public ButtonBar removeItem(String string) {
        if (string != null) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> map : this.items) {
                if (!string.equals(map.get("name"))) continue;
                arrayList.add(map);
            }
            this.items.removeAll(arrayList);
        }
        return this;
    }

    private Map<String, Object> getItem(int n) {
        return this.items.get(n);
    }

    public List getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public ButtonBar clear() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            this.items.remove(i);
        }
        this.items.clear();
        return this;
    }

    private class ButtonBarView
    implements ControllerView<ButtonBar> {
        private ButtonBarView() {
        }

        @Override
        public void display(PGraphics pGraphics, ButtonBar buttonBar) {
            pGraphics.noStroke();
            pGraphics.fill(ButtonBar.this.color.getBackground());
            pGraphics.rect(0.0f, 0.0f, (float)buttonBar.getWidth(), (float)buttonBar.getHeight());
            int n = ButtonBar.this.hover();
            int n2 = buttonBar.getWidth() / (ButtonBar.this.items.isEmpty() ? 1 : ButtonBar.this.items.size());
            int n3 = buttonBar.getHeight();
            pGraphics.textFont(buttonBar.getValueLabel().getFont().pfont);
            pGraphics.pushMatrix();
            for (int i = 0; i < ButtonBar.this.items.size(); ++i) {
                int n4 = ControlP5.b(((Map)ButtonBar.this.items.get(i)).get("selected"), false) ? ButtonBar.this.color.getActive() : (ButtonBar.this.isInside() && n == i ? (ButtonBar.this.isMousePressed ? ButtonBar.this.color.getActive() : ButtonBar.this.color.getForeground()) : ButtonBar.this.color.getBackground());
                pGraphics.fill(n4);
                pGraphics.rect(0.0f, 0.0f, (float)n2, (float)n3);
                pGraphics.fill(buttonBar.getValueLabel().getColor());
                buttonBar.getValueLabel().set(ControlP5.s(((Map)ButtonBar.this.items.get(i)).get("text"))).align(3, 3).draw(pGraphics, 0, 0, n2, n3);
                pGraphics.translate((float)n2, 0.0f);
            }
            pGraphics.popMatrix();
        }
    }
}

