/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.net.DatagramPacket;
import java.util.ArrayList;
import netP5.Bytes;
import netP5.TcpPacket;
import oscP5.OscMessage;
import oscP5.OscPacket;

public class OscBundle
extends OscPacket {
    protected static final int BUNDLE_HEADER_SIZE = 16;
    protected static final byte[] BUNDLE_AS_BYTES = new byte[]{35, 98, 117, 110, 100, 108, 101, 0};
    private int _myMessageSize = 0;

    public OscBundle() {
        this.messages = new ArrayList();
    }

    protected OscBundle(DatagramPacket datagramPacket) {
        this.inetAddress = datagramPacket.getAddress();
        this.port = datagramPacket.getPort();
        this.hostAddress = this.inetAddress.toString();
        this._myMessageSize = this.parseBundle(datagramPacket.getData(), this.inetAddress, this.port, null);
        this._myType = 1;
    }

    protected OscBundle(TcpPacket tcpPacket) {
        this._myTcpClient = tcpPacket.getTcpConnection();
        this.inetAddress = this._myTcpClient.netAddress().inetaddress();
        this.port = this._myTcpClient.netAddress().port();
        this.hostAddress = this.inetAddress.toString();
        this._myMessageSize = this.parseBundle(tcpPacket.getData(), this.inetAddress, this.port, this._myTcpClient);
        this._myType = 1;
    }

    public void add(OscMessage oscMessage) {
        this.messages.add(new OscMessage(oscMessage));
        this._myMessageSize = this.messages.size();
    }

    public void clear() {
        this.messages = new ArrayList();
    }

    public void remove(int n) {
        this.messages.remove(n);
    }

    public void remove(OscMessage oscMessage) {
        this.messages.remove(oscMessage);
    }

    public OscMessage getMessage(int n) {
        return (OscMessage)this.messages.get(n);
    }

    public int size() {
        return this._myMessageSize;
    }

    public void setTimetag(long l) {
        long l2 = l / 1000L + 2208988800L;
        long l3 = (l % 1000L << 32) / 1000L;
        this.timetag = l2 << 32 | l3;
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public byte[] timetag() {
        return Bytes.toBytes(this.timetag);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[]{};
        byArray = Bytes.append(byArray, BUNDLE_AS_BYTES);
        byArray = Bytes.append(byArray, this.timetag());
        for (int i = 0; i < this.size(); ++i) {
            byte[] byArray2 = this.getMessage(i).getBytes();
            byArray = Bytes.append(byArray, Bytes.toBytes(byArray2.length));
            byArray = Bytes.append(byArray, byArray2);
        }
        return byArray;
    }
}

