/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import sun.net.util.IPAddressUtil;

public abstract class URLStreamHandler {
    protected abstract URLConnection openConnection(URL var1) throws IOException;

    protected URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseURL(URL uRL, String string, int n, int n2) {
        String string2;
        int n3;
        boolean bl;
        int n4;
        String string3 = uRL.getProtocol();
        String string4 = uRL.getAuthority();
        String string5 = uRL.getUserInfo();
        String string6 = uRL.getHost();
        int n5 = uRL.getPort();
        String string7 = uRL.getPath();
        String string8 = uRL.getQuery();
        String string9 = uRL.getRef();
        boolean bl2 = false;
        boolean bl3 = false;
        if (n < n2) {
            n4 = string.indexOf(63);
            boolean bl4 = bl3 = n4 == n;
            if (n4 != -1 && n4 < n2) {
                string8 = string.substring(n4 + 1, n2);
                if (n2 > n4) {
                    n2 = n4;
                }
                string = string.substring(0, n4);
            }
        }
        n4 = 0;
        boolean bl5 = bl = n <= n2 - 4 && string.charAt(n) == '/' && string.charAt(n + 1) == '/' && string.charAt(n + 2) == '/' && string.charAt(n + 3) == '/';
        if (!bl && n <= n2 - 2 && string.charAt(n) == '/' && string.charAt(n + 1) == '/') {
            n4 = string.indexOf(47, n += 2);
            if (!(n4 >= 0 && n4 <= n2 || (n4 = string.indexOf(63, n)) >= 0 && n4 <= n2)) {
                n4 = n2;
            }
            string6 = string4 = string.substring(n, n4);
            n3 = string4.indexOf(64);
            if (n3 != -1) {
                if (n3 != string4.lastIndexOf(64)) {
                    string5 = null;
                    string6 = null;
                } else {
                    string5 = string4.substring(0, n3);
                    string6 = string4.substring(n3 + 1);
                }
            } else {
                string5 = null;
            }
            if (string6 != null) {
                if (string6.length() > 0 && string6.charAt(0) == '[') {
                    n3 = string6.indexOf(93);
                    if (n3 <= 2) throw new IllegalArgumentException("Invalid authority field: " + string4);
                    string2 = string6;
                    if (!IPAddressUtil.isIPv6LiteralAddress((string6 = string2.substring(0, n3 + 1)).substring(1, n3))) {
                        throw new IllegalArgumentException("Invalid host: " + string6);
                    }
                    n5 = -1;
                    if (string2.length() > n3 + 1) {
                        if (string2.charAt(n3 + 1) != ':') throw new IllegalArgumentException("Invalid authority field: " + string4);
                        if (string2.length() > ++n3 + 1) {
                            n5 = Integer.parseInt(string2.substring(n3 + 1));
                        }
                    }
                } else {
                    n3 = string6.indexOf(58);
                    n5 = -1;
                    if (n3 >= 0) {
                        if (string6.length() > n3 + 1) {
                            n5 = Integer.parseInt(string6.substring(n3 + 1));
                        }
                        string6 = string6.substring(0, n3);
                    }
                }
            } else {
                string6 = "";
            }
            if (n5 < -1) {
                throw new IllegalArgumentException("Invalid port number :" + n5);
            }
            n = n4;
            if (string4 != null && string4.length() > 0) {
                string7 = "";
            }
        }
        if (string6 == null) {
            string6 = "";
        }
        if (n < n2) {
            if (string.charAt(n) == '/') {
                string7 = string.substring(n, n2);
            } else if (string7 != null && string7.length() > 0) {
                bl2 = true;
                n3 = string7.lastIndexOf(47);
                string2 = "";
                if (n3 == -1 && string4 != null) {
                    string2 = "/";
                }
                string7 = string7.substring(0, n3 + 1) + string2 + string.substring(n, n2);
            } else {
                String string10 = string4 != null ? "/" : "";
                string7 = string10 + string.substring(n, n2);
            }
        } else if (bl3 && string7 != null) {
            n3 = string7.lastIndexOf(47);
            if (n3 < 0) {
                n3 = 0;
            }
            string7 = string7.substring(0, n3) + "/";
        }
        if (string7 == null) {
            string7 = "";
        }
        if (bl2) {
            while ((n4 = string7.indexOf("/./")) >= 0) {
                string7 = string7.substring(0, n4) + string7.substring(n4 + 2);
            }
            n4 = 0;
            while ((n4 = string7.indexOf("/../", n4)) >= 0) {
                if (n4 > 0 && (n2 = string7.lastIndexOf(47, n4 - 1)) >= 0 && string7.indexOf("/../", n2) != 0) {
                    string7 = string7.substring(0, n2) + string7.substring(n4 + 3);
                    n4 = 0;
                    continue;
                }
                n4 += 3;
            }
            while (string7.endsWith("/..") && (n2 = string7.lastIndexOf(47, (n4 = string7.indexOf("/..")) - 1)) >= 0) {
                string7 = string7.substring(0, n2 + 1);
            }
            if (string7.startsWith("./") && string7.length() > 2) {
                string7 = string7.substring(2);
            }
            if (string7.endsWith("/.")) {
                string7 = string7.substring(0, string7.length() - 1);
            }
        }
        this.setURL(uRL, string3, string6, n5, string4, string5, string7, string8, string9);
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected boolean equals(URL uRL, URL uRL2) {
        String string;
        String string2 = uRL.getRef();
        return (string2 == (string = uRL2.getRef()) || string2 != null && string2.equals(string)) && this.sameFile(uRL, uRL2);
    }

    protected int hashCode(URL uRL) {
        String string;
        InetAddress inetAddress;
        int n = 0;
        String string2 = uRL.getProtocol();
        if (string2 != null) {
            n += string2.hashCode();
        }
        if ((inetAddress = this.getHostAddress(uRL)) != null) {
            n += inetAddress.hashCode();
        } else {
            string = uRL.getHost();
            if (string != null) {
                n += string.toLowerCase().hashCode();
            }
        }
        string = uRL.getFile();
        if (string != null) {
            n += string.hashCode();
        }
        n = uRL.getPort() == -1 ? (n += this.getDefaultPort()) : (n += uRL.getPort());
        String string3 = uRL.getRef();
        if (string3 != null) {
            n += string3.hashCode();
        }
        return n;
    }

    protected boolean sameFile(URL uRL, URL uRL2) {
        int n;
        if (!(uRL.getProtocol() == uRL2.getProtocol() || uRL.getProtocol() != null && uRL.getProtocol().equalsIgnoreCase(uRL2.getProtocol()))) {
            return false;
        }
        if (!(uRL.getFile() == uRL2.getFile() || uRL.getFile() != null && uRL.getFile().equals(uRL2.getFile()))) {
            return false;
        }
        int n2 = uRL.getPort() != -1 ? uRL.getPort() : uRL.handler.getDefaultPort();
        int n3 = n = uRL2.getPort() != -1 ? uRL2.getPort() : uRL2.handler.getDefaultPort();
        if (n2 != n) {
            return false;
        }
        return this.hostsEqual(uRL, uRL2);
    }

    protected synchronized InetAddress getHostAddress(URL uRL) {
        if (uRL.hostAddress != null) {
            return uRL.hostAddress;
        }
        String string = uRL.getHost();
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            uRL.hostAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        return uRL.hostAddress;
    }

    protected boolean hostsEqual(URL uRL, URL uRL2) {
        InetAddress inetAddress = this.getHostAddress(uRL);
        InetAddress inetAddress2 = this.getHostAddress(uRL2);
        if (inetAddress != null && inetAddress2 != null) {
            return inetAddress.equals(inetAddress2);
        }
        if (uRL.getHost() != null && uRL2.getHost() != null) {
            return uRL.getHost().equalsIgnoreCase(uRL2.getHost());
        }
        return uRL.getHost() == null && uRL2.getHost() == null;
    }

    protected String toExternalForm(URL uRL) {
        int n = uRL.getProtocol().length() + 1;
        if (uRL.getAuthority() != null && uRL.getAuthority().length() > 0) {
            n += 2 + uRL.getAuthority().length();
        }
        if (uRL.getPath() != null) {
            n += uRL.getPath().length();
        }
        if (uRL.getQuery() != null) {
            n += 1 + uRL.getQuery().length();
        }
        if (uRL.getRef() != null) {
            n += 1 + uRL.getRef().length();
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(":");
        if (uRL.getAuthority() != null && uRL.getAuthority().length() > 0) {
            stringBuffer.append("//");
            stringBuffer.append(uRL.getAuthority());
        }
        if (uRL.getPath() != null) {
            stringBuffer.append(uRL.getPath());
        }
        if (uRL.getQuery() != null) {
            stringBuffer.append('?');
            stringBuffer.append(uRL.getQuery());
        }
        if (uRL.getRef() != null) {
            stringBuffer.append("#");
            stringBuffer.append(uRL.getRef());
        }
        return stringBuffer.toString();
    }

    protected void setURL(URL uRL, String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        if (this != uRL.handler) {
            throw new SecurityException("handler for url different from this handler");
        }
        uRL.set(uRL.getProtocol(), string2, n, string3, string4, string5, string6, string7);
    }

    @Deprecated
    protected void setURL(URL uRL, String string, String string2, int n, String string3, String string4) {
        String string5 = null;
        String string6 = null;
        if (string2 != null && string2.length() != 0) {
            string5 = n == -1 ? string2 : string2 + ":" + n;
            int n2 = string2.lastIndexOf(64);
            if (n2 != -1) {
                string6 = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
            }
        }
        String string7 = null;
        String string8 = null;
        if (string3 != null) {
            int n3 = string3.lastIndexOf(63);
            if (n3 != -1) {
                string8 = string3.substring(n3 + 1);
                string7 = string3.substring(0, n3);
            } else {
                string7 = string3;
            }
        }
        this.setURL(uRL, string, string2, n, string5, string6, string7, string8, string4);
    }
}

